# Generated by Django 1.11.15 on 2019-03-28 10:15


from django.db import migrations

from enterprise_data_roles.constants import ENTERPRISE_DATA_ADMIN_ROLE


def create_roles(apps, schema_editor):
    """
    Create the enterprise data roles if they do not already exist.
    """
    EnterpriseDataFeatureRole = apps.get_model('enterprise_data_roles', 'EnterpriseDataFeatureRole')
    EnterpriseDataFeatureRole.objects.update_or_create(name=ENTERPRISE_DATA_ADMIN_ROLE)


def delete_roles(apps, schema_editor):
    """Delete the enterprise data roles."""
    EnterpriseDataFeatureRole = apps.get_model('enterprise_data_roles', 'EnterpriseDataFeatureRole')
    EnterpriseDataFeatureRole.objects.filter(name=ENTERPRISE_DATA_ADMIN_ROLE).delete()



class Migration(migrations.Migration):

    dependencies = [
        ('enterprise_data_roles', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_roles, delete_roles)
    ]
