"""
Apollo SPS, Aerojet AJ10-137 (Apollo Service Module Engine)
"""
from rocketisp.rocket_isp import RocketThruster
from rocketisp.geometry import Geometry
from rocketisp.stream_tubes import CoreStream
from rocketisp.efficiencies import Efficiencies

# create basic Geometry. 
# Use "place-holder" of 1 inch for throat radius... correct later with "scale_Rt_to_Thrust"
geomObj = Geometry(Rthrt=1,
                   CR=2.5, eps=62.5,  pcentBell=72.3, 
                   RupThroat=1.5, RdwnThroat=1.0, RchmConv=1.0, cham_conv_deg=30,
                   LchmOvrDt=3.10, LchmMin=2.0, LchamberInp=None)
                   
effObj = Efficiencies()
effObj.set_const('ERE', 0.98) # don't know injector details so set effERE=0.98

# It's an ablative chamber, so some FFC (fuel film cooling) is required... guess about 10%
core = CoreStream( geomObj=geomObj, effObj=effObj, pcentFFC=10.0,
                   oxName='N2O4', fuelName='A50',  MRcore=1.6, Pc=100 )
             
R = RocketThruster(name='Apollo SPS',coreObj=core)
             
R.scale_Rt_to_Thrust( 20500 , Pamb=0.0  )
R.summ_print()
