# -*- coding: utf-8 -*-
"""`Concordance between JSIC13 and ISIC4 <https://unstats.un.org/unsd/classifications/Econ/tables/ISIC/JSIC13_ISIC4/JSIC13-ISIC4.xls>`_.
"""
from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import JSIC13

JSIC13_to_ISIC4 = Concordance(
    src=JSIC13,
    dst=ISIC4,
    concordances=[
        ((Standards.JSIC13, "0100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0111"), (Standards.ISIC4, "0112")),
        ((Standards.JSIC13, "0112"), (Standards.ISIC4, "0111")),
        ((Standards.JSIC13, "0113"), (Standards.ISIC4, "0113")),
        ((Standards.JSIC13, "0114"), (Standards.ISIC4, "0121")),
        ((Standards.JSIC13, "0114"), (Standards.ISIC4, "0122")),
        ((Standards.JSIC13, "0114"), (Standards.ISIC4, "0123")),
        ((Standards.JSIC13, "0114"), (Standards.ISIC4, "0124")),
        ((Standards.JSIC13, "0114"), (Standards.ISIC4, "0125")),
        ((Standards.JSIC13, "0115"), (Standards.ISIC4, "0119")),
        ((Standards.JSIC13, "0115"), (Standards.ISIC4, "0129")),
        ((Standards.JSIC13, "0115"), (Standards.ISIC4, "0130")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0111")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0113")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0114")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0115")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0116")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0126")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0127")),
        ((Standards.JSIC13, "0116"), (Standards.ISIC4, "0128")),
        ((Standards.JSIC13, "0117"), (Standards.ISIC4, "0113")),
        ((Standards.JSIC13, "0119"), (Standards.ISIC4, "0119")),
        ((Standards.JSIC13, "0119"), (Standards.ISIC4, "0130")),
        ((Standards.JSIC13, "0121"), (Standards.ISIC4, "0141")),
        ((Standards.JSIC13, "0121"), (Standards.ISIC4, "0144")),
        ((Standards.JSIC13, "0122"), (Standards.ISIC4, "0141")),
        ((Standards.JSIC13, "0123"), (Standards.ISIC4, "0145")),
        ((Standards.JSIC13, "0124"), (Standards.ISIC4, "0146")),
        ((Standards.JSIC13, "0125"), (Standards.ISIC4, "0149")),
        ((Standards.JSIC13, "0126"), (Standards.ISIC4, "0149")),
        ((Standards.JSIC13, "0129"), (Standards.ISIC4, "0142")),
        ((Standards.JSIC13, "0129"), (Standards.ISIC4, "0143")),
        ((Standards.JSIC13, "0129"), (Standards.ISIC4, "0144")),
        ((Standards.JSIC13, "0129"), (Standards.ISIC4, "0146")),
        ((Standards.JSIC13, "0129"), (Standards.ISIC4, "0149")),
        ((Standards.JSIC13, "0131"), (Standards.ISIC4, "0161")),
        ((Standards.JSIC13, "0131"), (Standards.ISIC4, "0163")),
        ((Standards.JSIC13, "0132"), (Standards.ISIC4, "0161")),
        ((Standards.JSIC13, "0132"), (Standards.ISIC4, "0163")),
        ((Standards.JSIC13, "0133"), (Standards.ISIC4, "0161")),
        ((Standards.JSIC13, "0133"), (Standards.ISIC4, "0163")),
        ((Standards.JSIC13, "0133"), (Standards.ISIC4, "0164")),
        ((Standards.JSIC13, "0134"), (Standards.ISIC4, "0162")),
        ((Standards.JSIC13, "0141"), (Standards.ISIC4, "8130")),
        ((Standards.JSIC13, "0200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0211"), (Standards.ISIC4, "0210")),
        ((Standards.JSIC13, "0221"), (Standards.ISIC4, "0220")),
        ((Standards.JSIC13, "0231"), (Standards.ISIC4, "0220")),
        ((Standards.JSIC13, "0239"), (Standards.ISIC4, "0230")),
        ((Standards.JSIC13, "0241"), (Standards.ISIC4, "0240")),
        ((Standards.JSIC13, "0242"), (Standards.ISIC4, "0240")),
        ((Standards.JSIC13, "0243"), (Standards.ISIC4, "0240")),
        ((Standards.JSIC13, "0249"), (Standards.ISIC4, "0240")),
        ((Standards.JSIC13, "0299"), (Standards.ISIC4, "0170")),
        ((Standards.JSIC13, "0299"), (Standards.ISIC4, "0210")),
        ((Standards.JSIC13, "0300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0311"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0312"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0313"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0314"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0315"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0316"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0317"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0318"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0319"), (Standards.ISIC4, "0311")),
        ((Standards.JSIC13, "0321"), (Standards.ISIC4, "0312")),
        ((Standards.JSIC13, "0400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0411"), (Standards.ISIC4, "0321")),
        ((Standards.JSIC13, "0412"), (Standards.ISIC4, "0321")),
        ((Standards.JSIC13, "0413"), (Standards.ISIC4, "0321")),
        ((Standards.JSIC13, "0414"), (Standards.ISIC4, "0321")),
        ((Standards.JSIC13, "0415"), (Standards.ISIC4, "0321")),
        ((Standards.JSIC13, "0419"), (Standards.ISIC4, "0321")),
        ((Standards.JSIC13, "0421"), (Standards.ISIC4, "0322")),
        ((Standards.JSIC13, "0500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0511"), (Standards.ISIC4, "0729")),
        ((Standards.JSIC13, "0512"), (Standards.ISIC4, "0729")),
        ((Standards.JSIC13, "0513"), (Standards.ISIC4, "0710")),
        ((Standards.JSIC13, "0519"), (Standards.ISIC4, "0721")),
        ((Standards.JSIC13, "0519"), (Standards.ISIC4, "0729")),
        ((Standards.JSIC13, "0521"), (Standards.ISIC4, "0510")),
        ((Standards.JSIC13, "0521"), (Standards.ISIC4, "0892")),
        ((Standards.JSIC13, "0522"), (Standards.ISIC4, "0520")),
        ((Standards.JSIC13, "0531"), (Standards.ISIC4, "0610")),
        ((Standards.JSIC13, "0531"), (Standards.ISIC4, "0910")),
        ((Standards.JSIC13, "0532"), (Standards.ISIC4, "0620")),
        ((Standards.JSIC13, "0532"), (Standards.ISIC4, "0910")),
        ((Standards.JSIC13, "0541"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0541"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0542"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0542"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0543"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0543"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0544"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0544"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0545"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0545"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0546"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0546"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0547"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0547"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0548"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0548"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0549"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0549"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0551"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0551"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0552"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0552"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0553"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0553"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0554"), (Standards.ISIC4, "0899")),
        ((Standards.JSIC13, "0554"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0555"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0555"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0556"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0556"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0557"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0557"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0559"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0559"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0591"), (Standards.ISIC4, "0899")),
        ((Standards.JSIC13, "0591"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0592"), (Standards.ISIC4, "0899")),
        ((Standards.JSIC13, "0592"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0593"), (Standards.ISIC4, "0899")),
        ((Standards.JSIC13, "0593"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0594"), (Standards.ISIC4, "0899")),
        ((Standards.JSIC13, "0594"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0599"), (Standards.ISIC4, "0810")),
        ((Standards.JSIC13, "0599"), (Standards.ISIC4, "0891")),
        ((Standards.JSIC13, "0599"), (Standards.ISIC4, "0899")),
        ((Standards.JSIC13, "0599"), (Standards.ISIC4, "0990")),
        ((Standards.JSIC13, "0600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0611"), (Standards.ISIC4, "4100")),
        ((Standards.JSIC13, "0611"), (Standards.ISIC4, "4210")),
        ((Standards.JSIC13, "0611"), (Standards.ISIC4, "4220")),
        ((Standards.JSIC13, "0611"), (Standards.ISIC4, "4290")),
        ((Standards.JSIC13, "0611"), (Standards.ISIC4, "4312")),
        ((Standards.JSIC13, "0621"), (Standards.ISIC4, "4210")),
        ((Standards.JSIC13, "0621"), (Standards.ISIC4, "4220")),
        ((Standards.JSIC13, "0621"), (Standards.ISIC4, "4290")),
        ((Standards.JSIC13, "0622"), (Standards.ISIC4, "4290")),
        ((Standards.JSIC13, "0622"), (Standards.ISIC4, "8130")),
        ((Standards.JSIC13, "0623"), (Standards.ISIC4, "4290")),
        ((Standards.JSIC13, "0631"), (Standards.ISIC4, "4210")),
        ((Standards.JSIC13, "0631"), (Standards.ISIC4, "4220")),
        ((Standards.JSIC13, "0641"), (Standards.ISIC4, "4100")),
        ((Standards.JSIC13, "0651"), (Standards.ISIC4, "4100")),
        ((Standards.JSIC13, "0661"), (Standards.ISIC4, "4100")),
        ((Standards.JSIC13, "0700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0711"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0712"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0721"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0722"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0723"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0731"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0732"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0741"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0741"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0742"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0742"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0743"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0743"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0744"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0751"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0761"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0762"), (Standards.ISIC4, "4322")),
        ((Standards.JSIC13, "0762"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0763"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0771"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0772"), (Standards.ISIC4, "4210")),
        ((Standards.JSIC13, "0772"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0781"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0782"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0791"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0792"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0793"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0794"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0795"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0796"), (Standards.ISIC4, "4311")),
        ((Standards.JSIC13, "0799"), (Standards.ISIC4, "4311")),
        ((Standards.JSIC13, "0799"), (Standards.ISIC4, "4312")),
        ((Standards.JSIC13, "0799"), (Standards.ISIC4, "4330")),
        ((Standards.JSIC13, "0799"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0811"), (Standards.ISIC4, "4220")),
        ((Standards.JSIC13, "0811"), (Standards.ISIC4, "4321")),
        ((Standards.JSIC13, "0812"), (Standards.ISIC4, "4321")),
        ((Standards.JSIC13, "0821"), (Standards.ISIC4, "4321")),
        ((Standards.JSIC13, "0822"), (Standards.ISIC4, "4321")),
        ((Standards.JSIC13, "0823"), (Standards.ISIC4, "4210")),
        ((Standards.JSIC13, "0823"), (Standards.ISIC4, "4321")),
        ((Standards.JSIC13, "0831"), (Standards.ISIC4, "4322")),
        ((Standards.JSIC13, "0832"), (Standards.ISIC4, "4322")),
        ((Standards.JSIC13, "0833"), (Standards.ISIC4, "4322")),
        ((Standards.JSIC13, "0839"), (Standards.ISIC4, "4322")),
        ((Standards.JSIC13, "0841"), (Standards.ISIC4, "3320")),
        ((Standards.JSIC13, "0841"), (Standards.ISIC4, "4329")),
        ((Standards.JSIC13, "0842"), (Standards.ISIC4, "4329")),
        ((Standards.JSIC13, "0891"), (Standards.ISIC4, "4322")),
        ((Standards.JSIC13, "0891"), (Standards.ISIC4, "4390")),
        ((Standards.JSIC13, "0892"), (Standards.ISIC4, "4329")),
        ((Standards.JSIC13, "0893"), (Standards.ISIC4, "4210")),
        ((Standards.JSIC13, "0894"), (Standards.ISIC4, "4220")),
        ((Standards.JSIC13, "0894"), (Standards.ISIC4, "4312")),
        ((Standards.JSIC13, "0900"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0909"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "0911"), (Standards.ISIC4, "1010")),
        ((Standards.JSIC13, "0912"), (Standards.ISIC4, "1010")),
        ((Standards.JSIC13, "0913"), (Standards.ISIC4, "1050")),
        ((Standards.JSIC13, "0914"), (Standards.ISIC4, "1050")),
        ((Standards.JSIC13, "0919"), (Standards.ISIC4, "1010")),
        ((Standards.JSIC13, "0919"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "0921"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "0922"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "0923"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "0924"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "0925"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "0926"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "0929"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "0931"), (Standards.ISIC4, "1030")),
        ((Standards.JSIC13, "0932"), (Standards.ISIC4, "1030")),
        ((Standards.JSIC13, "0941"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "0942"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "0943"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "0944"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "0949"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "0951"), (Standards.ISIC4, "1072")),
        ((Standards.JSIC13, "0952"), (Standards.ISIC4, "1072")),
        ((Standards.JSIC13, "0953"), (Standards.ISIC4, "1062")),
        ((Standards.JSIC13, "0953"), (Standards.ISIC4, "1072")),
        ((Standards.JSIC13, "0961"), (Standards.ISIC4, "1061")),
        ((Standards.JSIC13, "0962"), (Standards.ISIC4, "1061")),
        ((Standards.JSIC13, "0969"), (Standards.ISIC4, "1061")),
        ((Standards.JSIC13, "0971"), (Standards.ISIC4, "1071")),
        ((Standards.JSIC13, "0972"), (Standards.ISIC4, "1071")),
        ((Standards.JSIC13, "0973"), (Standards.ISIC4, "1071")),
        ((Standards.JSIC13, "0974"), (Standards.ISIC4, "1071")),
        ((Standards.JSIC13, "0979"), (Standards.ISIC4, "1073")),
        ((Standards.JSIC13, "0981"), (Standards.ISIC4, "1010")),
        ((Standards.JSIC13, "0981"), (Standards.ISIC4, "1040")),
        ((Standards.JSIC13, "0982"), (Standards.ISIC4, "1040")),
        ((Standards.JSIC13, "0991"), (Standards.ISIC4, "1062")),
        ((Standards.JSIC13, "0992"), (Standards.ISIC4, "1074")),
        ((Standards.JSIC13, "0993"), (Standards.ISIC4, "1030")),
        ((Standards.JSIC13, "0994"), (Standards.ISIC4, "1030")),
        ((Standards.JSIC13, "0995"), (Standards.ISIC4, "1075")),
        ((Standards.JSIC13, "0996"), (Standards.ISIC4, "1030")),
        ((Standards.JSIC13, "0996"), (Standards.ISIC4, "1075")),
        ((Standards.JSIC13, "0997"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "0998"), (Standards.ISIC4, "1075")),
        ((Standards.JSIC13, "0999"), (Standards.ISIC4, "1030")),
        ((Standards.JSIC13, "0999"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "1000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1011"), (Standards.ISIC4, "1030")),
        ((Standards.JSIC13, "1011"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "1011"), (Standards.ISIC4, "1104")),
        ((Standards.JSIC13, "1021"), (Standards.ISIC4, "1102")),
        ((Standards.JSIC13, "1022"), (Standards.ISIC4, "1103")),
        ((Standards.JSIC13, "1023"), (Standards.ISIC4, "1102")),
        ((Standards.JSIC13, "1024"), (Standards.ISIC4, "1101")),
        ((Standards.JSIC13, "1031"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "1032"), (Standards.ISIC4, "1079")),
        ((Standards.JSIC13, "1041"), (Standards.ISIC4, "3530")),
        ((Standards.JSIC13, "1051"), (Standards.ISIC4, "1200")),
        ((Standards.JSIC13, "1052"), (Standards.ISIC4, "1200")),
        ((Standards.JSIC13, "1061"), (Standards.ISIC4, "1080")),
        ((Standards.JSIC13, "1062"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "1062"), (Standards.ISIC4, "1080")),
        ((Standards.JSIC13, "1063"), (Standards.ISIC4, "1020")),
        ((Standards.JSIC13, "1063"), (Standards.ISIC4, "1040")),
        ((Standards.JSIC13, "1063"), (Standards.ISIC4, "3821")),
        ((Standards.JSIC13, "1100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1111"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1112"), (Standards.ISIC4, "2030")),
        ((Standards.JSIC13, "1113"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "1114"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1115"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1116"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1117"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1118"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1119"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1121"), (Standards.ISIC4, "1312")),
        ((Standards.JSIC13, "1122"), (Standards.ISIC4, "1312")),
        ((Standards.JSIC13, "1123"), (Standards.ISIC4, "1312")),
        ((Standards.JSIC13, "1124"), (Standards.ISIC4, "1312")),
        ((Standards.JSIC13, "1125"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1125"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1129"), (Standards.ISIC4, "1312")),
        ((Standards.JSIC13, "1131"), (Standards.ISIC4, "1391")),
        ((Standards.JSIC13, "1132"), (Standards.ISIC4, "1391")),
        ((Standards.JSIC13, "1133"), (Standards.ISIC4, "1391")),
        ((Standards.JSIC13, "1141"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1142"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1143"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1144"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1145"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1146"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1147"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1147"), (Standards.ISIC4, "1430")),
        ((Standards.JSIC13, "1148"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1151"), (Standards.ISIC4, "1394")),
        ((Standards.JSIC13, "1152"), (Standards.ISIC4, "1394")),
        ((Standards.JSIC13, "1153"), (Standards.ISIC4, "1394")),
        ((Standards.JSIC13, "1154"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1155"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1156"), (Standards.ISIC4, "1311")),
        ((Standards.JSIC13, "1157"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1158"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1159"), (Standards.ISIC4, "1394")),
        ((Standards.JSIC13, "1159"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1161"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1162"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1163"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1164"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1165"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1166"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1166"), (Standards.ISIC4, "1430")),
        ((Standards.JSIC13, "1167"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1167"), (Standards.ISIC4, "1430")),
        ((Standards.JSIC13, "1168"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1168"), (Standards.ISIC4, "1430")),
        ((Standards.JSIC13, "1169"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1169"), (Standards.ISIC4, "1430")),
        ((Standards.JSIC13, "1171"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1172"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1172"), (Standards.ISIC4, "1430")),
        ((Standards.JSIC13, "1173"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1174"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1181"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1182"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1183"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1184"), (Standards.ISIC4, "1430")),
        ((Standards.JSIC13, "1185"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1186"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1189"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1189"), (Standards.ISIC4, "1420")),
        ((Standards.JSIC13, "1191"), (Standards.ISIC4, "1392")),
        ((Standards.JSIC13, "1192"), (Standards.ISIC4, "1392")),
        ((Standards.JSIC13, "1193"), (Standards.ISIC4, "1393")),
        ((Standards.JSIC13, "1194"), (Standards.ISIC4, "1392")),
        ((Standards.JSIC13, "1195"), (Standards.ISIC4, "1392")),
        ((Standards.JSIC13, "1196"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1197"), (Standards.ISIC4, "1312")),
        ((Standards.JSIC13, "1198"), (Standards.ISIC4, "1312")),
        ((Standards.JSIC13, "1198"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1198"), (Standards.ISIC4, "1709")),
        ((Standards.JSIC13, "1198"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "1199"), (Standards.ISIC4, "1392")),
        ((Standards.JSIC13, "1199"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1211"), (Standards.ISIC4, "1610")),
        ((Standards.JSIC13, "1212"), (Standards.ISIC4, "1621")),
        ((Standards.JSIC13, "1213"), (Standards.ISIC4, "1610")),
        ((Standards.JSIC13, "1219"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "1219"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "1221"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "1222"), (Standards.ISIC4, "1621")),
        ((Standards.JSIC13, "1223"), (Standards.ISIC4, "1621")),
        ((Standards.JSIC13, "1224"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "1225"), (Standards.ISIC4, "1621")),
        ((Standards.JSIC13, "1226"), (Standards.ISIC4, "1621")),
        ((Standards.JSIC13, "1227"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "1228"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "1231"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "1232"), (Standards.ISIC4, "1623")),
        ((Standards.JSIC13, "1233"), (Standards.ISIC4, "1623")),
        ((Standards.JSIC13, "1291"), (Standards.ISIC4, "1610")),
        ((Standards.JSIC13, "1292"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "1299"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "1299"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "1300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1311"), (Standards.ISIC4, "3100")),
        ((Standards.JSIC13, "1312"), (Standards.ISIC4, "3100")),
        ((Standards.JSIC13, "1313"), (Standards.ISIC4, "3100")),
        ((Standards.JSIC13, "1321"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "1321"), (Standards.ISIC4, "3100")),
        ((Standards.JSIC13, "1321"), (Standards.ISIC4, "3212")),
        ((Standards.JSIC13, "1321"), (Standards.ISIC4, "3220")),
        ((Standards.JSIC13, "1331"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "1331"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1391"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "1391"), (Standards.ISIC4, "3100")),
        ((Standards.JSIC13, "1392"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1392"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "1393"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "1399"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "1399"), (Standards.ISIC4, "2395")),
        ((Standards.JSIC13, "1399"), (Standards.ISIC4, "2396")),
        ((Standards.JSIC13, "1399"), (Standards.ISIC4, "2817")),
        ((Standards.JSIC13, "1399"), (Standards.ISIC4, "3100")),
        ((Standards.JSIC13, "1400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1411"), (Standards.ISIC4, "1701")),
        ((Standards.JSIC13, "1421"), (Standards.ISIC4, "1701")),
        ((Standards.JSIC13, "1422"), (Standards.ISIC4, "1701")),
        ((Standards.JSIC13, "1423"), (Standards.ISIC4, "1701")),
        ((Standards.JSIC13, "1424"), (Standards.ISIC4, "1701")),
        ((Standards.JSIC13, "1431"), (Standards.ISIC4, "1701")),
        ((Standards.JSIC13, "1432"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1433"), (Standards.ISIC4, "1709")),
        ((Standards.JSIC13, "1441"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1441"), (Standards.ISIC4, "1709")),
        ((Standards.JSIC13, "1442"), (Standards.ISIC4, "1709")),
        ((Standards.JSIC13, "1449"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1449"), (Standards.ISIC4, "1709")),
        ((Standards.JSIC13, "1451"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1452"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1453"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1454"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1454"), (Standards.ISIC4, "1709")),
        ((Standards.JSIC13, "1499"), (Standards.ISIC4, "1702")),
        ((Standards.JSIC13, "1499"), (Standards.ISIC4, "1709")),
        ((Standards.JSIC13, "1499"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1511"), (Standards.ISIC4, "1811")),
        ((Standards.JSIC13, "1512"), (Standards.ISIC4, "1811")),
        ((Standards.JSIC13, "1513"), (Standards.ISIC4, "1313")),
        ((Standards.JSIC13, "1513"), (Standards.ISIC4, "1811")),
        ((Standards.JSIC13, "1521"), (Standards.ISIC4, "1812")),
        ((Standards.JSIC13, "1531"), (Standards.ISIC4, "1812")),
        ((Standards.JSIC13, "1532"), (Standards.ISIC4, "1812")),
        ((Standards.JSIC13, "1591"), (Standards.ISIC4, "1812")),
        ((Standards.JSIC13, "1600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1611"), (Standards.ISIC4, "2012")),
        ((Standards.JSIC13, "1612"), (Standards.ISIC4, "2012")),
        ((Standards.JSIC13, "1619"), (Standards.ISIC4, "2012")),
        ((Standards.JSIC13, "1621"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1622"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1623"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1624"), (Standards.ISIC4, "0893")),
        ((Standards.JSIC13, "1629"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1631"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1631"), (Standards.ISIC4, "2013")),
        ((Standards.JSIC13, "1632"), (Standards.ISIC4, "2013")),
        ((Standards.JSIC13, "1633"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1634"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1635"), (Standards.ISIC4, "2013")),
        ((Standards.JSIC13, "1636"), (Standards.ISIC4, "2013")),
        ((Standards.JSIC13, "1639"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1639"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1641"), (Standards.ISIC4, "2023")),
        ((Standards.JSIC13, "1642"), (Standards.ISIC4, "2023")),
        ((Standards.JSIC13, "1643"), (Standards.ISIC4, "2023")),
        ((Standards.JSIC13, "1644"), (Standards.ISIC4, "2022")),
        ((Standards.JSIC13, "1645"), (Standards.ISIC4, "2022")),
        ((Standards.JSIC13, "1646"), (Standards.ISIC4, "2023")),
        ((Standards.JSIC13, "1647"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "1651"), (Standards.ISIC4, "2100")),
        ((Standards.JSIC13, "1652"), (Standards.ISIC4, "2021")),
        ((Standards.JSIC13, "1652"), (Standards.ISIC4, "2100")),
        ((Standards.JSIC13, "1653"), (Standards.ISIC4, "2100")),
        ((Standards.JSIC13, "1654"), (Standards.ISIC4, "2100")),
        ((Standards.JSIC13, "1655"), (Standards.ISIC4, "2100")),
        ((Standards.JSIC13, "1661"), (Standards.ISIC4, "2023")),
        ((Standards.JSIC13, "1662"), (Standards.ISIC4, "2023")),
        ((Standards.JSIC13, "1669"), (Standards.ISIC4, "2023")),
        ((Standards.JSIC13, "1691"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1692"), (Standards.ISIC4, "2021")),
        ((Standards.JSIC13, "1693"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1693"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1694"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1695"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1696"), (Standards.ISIC4, "2011")),
        ((Standards.JSIC13, "1697"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1699"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1711"), (Standards.ISIC4, "1920")),
        ((Standards.JSIC13, "1721"), (Standards.ISIC4, "1920")),
        ((Standards.JSIC13, "1731"), (Standards.ISIC4, "1910")),
        ((Standards.JSIC13, "1741"), (Standards.ISIC4, "1920")),
        ((Standards.JSIC13, "1799"), (Standards.ISIC4, "1910")),
        ((Standards.JSIC13, "1799"), (Standards.ISIC4, "1920")),
        ((Standards.JSIC13, "1800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1811"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1812"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1813"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1814"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1815"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1821"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1822"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1823"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1824"), (Standards.ISIC4, "1399")),
        ((Standards.JSIC13, "1824"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1825"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1831"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1832"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1832"), (Standards.ISIC4, "2930")),
        ((Standards.JSIC13, "1833"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1834"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1841"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1842"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1843"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1844"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1844"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "1845"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1851"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1852"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1891"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1892"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1897"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1898"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1900"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1909"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "1911"), (Standards.ISIC4, "2211")),
        ((Standards.JSIC13, "1919"), (Standards.ISIC4, "2211")),
        ((Standards.JSIC13, "1921"), (Standards.ISIC4, "1520")),
        ((Standards.JSIC13, "1921"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1922"), (Standards.ISIC4, "1520")),
        ((Standards.JSIC13, "1922"), (Standards.ISIC4, "2220")),
        ((Standards.JSIC13, "1931"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1932"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1933"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "1933"), (Standards.ISIC4, "2211")),
        ((Standards.JSIC13, "1933"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1991"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "1991"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1992"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1993"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "1994"), (Standards.ISIC4, "2211")),
        ((Standards.JSIC13, "1995"), (Standards.ISIC4, "3830")),
        ((Standards.JSIC13, "1999"), (Standards.ISIC4, "2219")),
        ((Standards.JSIC13, "2000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2011"), (Standards.ISIC4, "1511")),
        ((Standards.JSIC13, "2021"), (Standards.ISIC4, "1512")),
        ((Standards.JSIC13, "2021"), (Standards.ISIC4, "3092")),
        ((Standards.JSIC13, "2031"), (Standards.ISIC4, "1520")),
        ((Standards.JSIC13, "2041"), (Standards.ISIC4, "1520")),
        ((Standards.JSIC13, "2051"), (Standards.ISIC4, "1410")),
        ((Standards.JSIC13, "2061"), (Standards.ISIC4, "1512")),
        ((Standards.JSIC13, "2071"), (Standards.ISIC4, "1512")),
        ((Standards.JSIC13, "2072"), (Standards.ISIC4, "1512")),
        ((Standards.JSIC13, "2081"), (Standards.ISIC4, "1511")),
        ((Standards.JSIC13, "2099"), (Standards.ISIC4, "1512")),
        ((Standards.JSIC13, "2100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2111"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2112"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2113"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2114"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2115"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2116"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2117"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2119"), (Standards.ISIC4, "2310")),
        ((Standards.JSIC13, "2121"), (Standards.ISIC4, "2394")),
        ((Standards.JSIC13, "2122"), (Standards.ISIC4, "2395")),
        ((Standards.JSIC13, "2123"), (Standards.ISIC4, "2395")),
        ((Standards.JSIC13, "2129"), (Standards.ISIC4, "2395")),
        ((Standards.JSIC13, "2131"), (Standards.ISIC4, "2392")),
        ((Standards.JSIC13, "2132"), (Standards.ISIC4, "2392")),
        ((Standards.JSIC13, "2139"), (Standards.ISIC4, "2392")),
        ((Standards.JSIC13, "2141"), (Standards.ISIC4, "2392")),
        ((Standards.JSIC13, "2141"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "2142"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "2143"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "2144"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "2145"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "2146"), (Standards.ISIC4, "2392")),
        ((Standards.JSIC13, "2147"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "2148"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2149"), (Standards.ISIC4, "2393")),
        ((Standards.JSIC13, "2151"), (Standards.ISIC4, "2391")),
        ((Standards.JSIC13, "2152"), (Standards.ISIC4, "2391")),
        ((Standards.JSIC13, "2159"), (Standards.ISIC4, "2391")),
        ((Standards.JSIC13, "2161"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "2169"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2171"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2172"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2173"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2179"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2181"), (Standards.ISIC4, "2396")),
        ((Standards.JSIC13, "2182"), (Standards.ISIC4, "3830")),
        ((Standards.JSIC13, "2183"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2184"), (Standards.ISIC4, "2396")),
        ((Standards.JSIC13, "2185"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2186"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2191"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2192"), (Standards.ISIC4, "2395")),
        ((Standards.JSIC13, "2193"), (Standards.ISIC4, "2394")),
        ((Standards.JSIC13, "2194"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2199"), (Standards.ISIC4, "2399")),
        ((Standards.JSIC13, "2199"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2211"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2212"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2213"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2221"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2231"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2232"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2233"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2234"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2235"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2236"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2237"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2238"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2238"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2239"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2241"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2249"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2251"), (Standards.ISIC4, "2431")),
        ((Standards.JSIC13, "2251"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2252"), (Standards.ISIC4, "2431")),
        ((Standards.JSIC13, "2253"), (Standards.ISIC4, "2431")),
        ((Standards.JSIC13, "2254"), (Standards.ISIC4, "2591")),
        ((Standards.JSIC13, "2255"), (Standards.ISIC4, "2591")),
        ((Standards.JSIC13, "2291"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2292"), (Standards.ISIC4, "3830")),
        ((Standards.JSIC13, "2293"), (Standards.ISIC4, "2431")),
        ((Standards.JSIC13, "2299"), (Standards.ISIC4, "2410")),
        ((Standards.JSIC13, "2300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2311"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2312"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2319"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2321"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2322"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2329"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2331"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2332"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2339"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2341"), (Standards.ISIC4, "2732")),
        ((Standards.JSIC13, "2342"), (Standards.ISIC4, "2731")),
        ((Standards.JSIC13, "2351"), (Standards.ISIC4, "2432")),
        ((Standards.JSIC13, "2352"), (Standards.ISIC4, "2432")),
        ((Standards.JSIC13, "2353"), (Standards.ISIC4, "2432")),
        ((Standards.JSIC13, "2354"), (Standards.ISIC4, "2432")),
        ((Standards.JSIC13, "2355"), (Standards.ISIC4, "2591")),
        ((Standards.JSIC13, "2391"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2399"), (Standards.ISIC4, "2420")),
        ((Standards.JSIC13, "2400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2411"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2421"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2422"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2423"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2424"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2425"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2426"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2429"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2431"), (Standards.ISIC4, "2431")),
        ((Standards.JSIC13, "2432"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2432"), (Standards.ISIC4, "2815")),
        ((Standards.JSIC13, "2433"), (Standards.ISIC4, "2512")),
        ((Standards.JSIC13, "2433"), (Standards.ISIC4, "2815")),
        ((Standards.JSIC13, "2439"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2439"), (Standards.ISIC4, "2815")),
        ((Standards.JSIC13, "2441"), (Standards.ISIC4, "2511")),
        ((Standards.JSIC13, "2442"), (Standards.ISIC4, "2511")),
        ((Standards.JSIC13, "2443"), (Standards.ISIC4, "2511")),
        ((Standards.JSIC13, "2444"), (Standards.ISIC4, "2511")),
        ((Standards.JSIC13, "2445"), (Standards.ISIC4, "2511")),
        ((Standards.JSIC13, "2446"), (Standards.ISIC4, "2512")),
        ((Standards.JSIC13, "2446"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2591")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2818")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2822")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "2930")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "3091")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "3092")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "3099")),
        ((Standards.JSIC13, "2451"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "2591")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "2818")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "2822")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "2930")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "3091")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "3092")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "3099")),
        ((Standards.JSIC13, "2452"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "2453"), (Standards.ISIC4, "2591")),
        ((Standards.JSIC13, "2461"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2462"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2463"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2464"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2465"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2469"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2471"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2479"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2481"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2491"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2492"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2499"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "2499"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "2500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2511"), (Standards.ISIC4, "2513")),
        ((Standards.JSIC13, "2512"), (Standards.ISIC4, "2811")),
        ((Standards.JSIC13, "2513"), (Standards.ISIC4, "2811")),
        ((Standards.JSIC13, "2519"), (Standards.ISIC4, "2811")),
        ((Standards.JSIC13, "2521"), (Standards.ISIC4, "2813")),
        ((Standards.JSIC13, "2522"), (Standards.ISIC4, "2813")),
        ((Standards.JSIC13, "2523"), (Standards.ISIC4, "2812")),
        ((Standards.JSIC13, "2531"), (Standards.ISIC4, "2814")),
        ((Standards.JSIC13, "2532"), (Standards.ISIC4, "2816")),
        ((Standards.JSIC13, "2533"), (Standards.ISIC4, "2816")),
        ((Standards.JSIC13, "2534"), (Standards.ISIC4, "2815")),
        ((Standards.JSIC13, "2535"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2591"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2592"), (Standards.ISIC4, "2813")),
        ((Standards.JSIC13, "2593"), (Standards.ISIC4, "2592")),
        ((Standards.JSIC13, "2594"), (Standards.ISIC4, "2814")),
        ((Standards.JSIC13, "2595"), (Standards.ISIC4, "2811")),
        ((Standards.JSIC13, "2596"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2599"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2599"), (Standards.ISIC4, "3311")),
        ((Standards.JSIC13, "2599"), (Standards.ISIC4, "3312")),
        ((Standards.JSIC13, "2600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2611"), (Standards.ISIC4, "2821")),
        ((Standards.JSIC13, "2621"), (Standards.ISIC4, "2824")),
        ((Standards.JSIC13, "2631"), (Standards.ISIC4, "2826")),
        ((Standards.JSIC13, "2632"), (Standards.ISIC4, "2826")),
        ((Standards.JSIC13, "2633"), (Standards.ISIC4, "2826")),
        ((Standards.JSIC13, "2634"), (Standards.ISIC4, "2826")),
        ((Standards.JSIC13, "2635"), (Standards.ISIC4, "2826")),
        ((Standards.JSIC13, "2641"), (Standards.ISIC4, "2825")),
        ((Standards.JSIC13, "2642"), (Standards.ISIC4, "2822")),
        ((Standards.JSIC13, "2642"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2643"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2644"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2645"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2651"), (Standards.ISIC4, "2823")),
        ((Standards.JSIC13, "2652"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2652"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2653"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2661"), (Standards.ISIC4, "2822")),
        ((Standards.JSIC13, "2662"), (Standards.ISIC4, "2822")),
        ((Standards.JSIC13, "2662"), (Standards.ISIC4, "2823")),
        ((Standards.JSIC13, "2663"), (Standards.ISIC4, "2822")),
        ((Standards.JSIC13, "2663"), (Standards.ISIC4, "2823")),
        ((Standards.JSIC13, "2664"), (Standards.ISIC4, "2818")),
        ((Standards.JSIC13, "2671"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2672"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2691"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2692"), (Standards.ISIC4, "2593")),
        ((Standards.JSIC13, "2693"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2694"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2699"), (Standards.ISIC4, "2826")),
        ((Standards.JSIC13, "2699"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2711"), (Standards.ISIC4, "2817")),
        ((Standards.JSIC13, "2719"), (Standards.ISIC4, "2817")),
        ((Standards.JSIC13, "2721"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2721"), (Standards.ISIC4, "2826")),
        ((Standards.JSIC13, "2721"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2722"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2723"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2729"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "2729"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2729"), (Standards.ISIC4, "2829")),
        ((Standards.JSIC13, "2731"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2732"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2732"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2733"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2734"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2735"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2736"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2737"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2738"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2739"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2739"), (Standards.ISIC4, "2819")),
        ((Standards.JSIC13, "2739"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "2741"), (Standards.ISIC4, "2660")),
        ((Standards.JSIC13, "2741"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "2742"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "2743"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "2744"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "2751"), (Standards.ISIC4, "2670")),
        ((Standards.JSIC13, "2752"), (Standards.ISIC4, "2670")),
        ((Standards.JSIC13, "2753"), (Standards.ISIC4, "2670")),
        ((Standards.JSIC13, "2761"), (Standards.ISIC4, "2520")),
        ((Standards.JSIC13, "2761"), (Standards.ISIC4, "3040")),
        ((Standards.JSIC13, "2800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2811"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2811"), (Standards.ISIC4, "2660")),
        ((Standards.JSIC13, "2812"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2813"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2814"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2815"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2821"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2822"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2823"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2831"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2832"), (Standards.ISIC4, "2680")),
        ((Standards.JSIC13, "2841"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2842"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2851"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2859"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2899"), (Standards.ISIC4, "2610")),
        ((Standards.JSIC13, "2900"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2909"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "2911"), (Standards.ISIC4, "2710")),
        ((Standards.JSIC13, "2912"), (Standards.ISIC4, "2710")),
        ((Standards.JSIC13, "2913"), (Standards.ISIC4, "2710")),
        ((Standards.JSIC13, "2913"), (Standards.ISIC4, "2733")),
        ((Standards.JSIC13, "2914"), (Standards.ISIC4, "2710")),
        ((Standards.JSIC13, "2914"), (Standards.ISIC4, "2733")),
        ((Standards.JSIC13, "2915"), (Standards.ISIC4, "2733")),
        ((Standards.JSIC13, "2921"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "2922"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "2922"), (Standards.ISIC4, "2930")),
        ((Standards.JSIC13, "2929"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "2929"), (Standards.ISIC4, "2815")),
        ((Standards.JSIC13, "2931"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2932"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2933"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2939"), (Standards.ISIC4, "2750")),
        ((Standards.JSIC13, "2941"), (Standards.ISIC4, "2740")),
        ((Standards.JSIC13, "2942"), (Standards.ISIC4, "2740")),
        ((Standards.JSIC13, "2951"), (Standards.ISIC4, "2720")),
        ((Standards.JSIC13, "2952"), (Standards.ISIC4, "2720")),
        ((Standards.JSIC13, "2961"), (Standards.ISIC4, "2660")),
        ((Standards.JSIC13, "2962"), (Standards.ISIC4, "2660")),
        ((Standards.JSIC13, "2969"), (Standards.ISIC4, "2660")),
        ((Standards.JSIC13, "2971"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2972"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2973"), (Standards.ISIC4, "2651")),
        ((Standards.JSIC13, "2973"), (Standards.ISIC4, "2660")),
        ((Standards.JSIC13, "2999"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "3000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3011"), (Standards.ISIC4, "2630")),
        ((Standards.JSIC13, "3012"), (Standards.ISIC4, "2630")),
        ((Standards.JSIC13, "3013"), (Standards.ISIC4, "2630")),
        ((Standards.JSIC13, "3014"), (Standards.ISIC4, "2630")),
        ((Standards.JSIC13, "3014"), (Standards.ISIC4, "2640")),
        ((Standards.JSIC13, "3015"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "3019"), (Standards.ISIC4, "2630")),
        ((Standards.JSIC13, "3021"), (Standards.ISIC4, "2640")),
        ((Standards.JSIC13, "3022"), (Standards.ISIC4, "2670")),
        ((Standards.JSIC13, "3023"), (Standards.ISIC4, "2640")),
        ((Standards.JSIC13, "3031"), (Standards.ISIC4, "2620")),
        ((Standards.JSIC13, "3032"), (Standards.ISIC4, "2620")),
        ((Standards.JSIC13, "3033"), (Standards.ISIC4, "2620")),
        ((Standards.JSIC13, "3034"), (Standards.ISIC4, "2620")),
        ((Standards.JSIC13, "3035"), (Standards.ISIC4, "2620")),
        ((Standards.JSIC13, "3039"), (Standards.ISIC4, "2620")),
        ((Standards.JSIC13, "3100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3111"), (Standards.ISIC4, "2910")),
        ((Standards.JSIC13, "3111"), (Standards.ISIC4, "3091")),
        ((Standards.JSIC13, "3112"), (Standards.ISIC4, "2920")),
        ((Standards.JSIC13, "3113"), (Standards.ISIC4, "2930")),
        ((Standards.JSIC13, "3113"), (Standards.ISIC4, "3091")),
        ((Standards.JSIC13, "3121"), (Standards.ISIC4, "3020")),
        ((Standards.JSIC13, "3122"), (Standards.ISIC4, "3020")),
        ((Standards.JSIC13, "3131"), (Standards.ISIC4, "3011")),
        ((Standards.JSIC13, "3131"), (Standards.ISIC4, "3315")),
        ((Standards.JSIC13, "3132"), (Standards.ISIC4, "3011")),
        ((Standards.JSIC13, "3133"), (Standards.ISIC4, "3011")),
        ((Standards.JSIC13, "3133"), (Standards.ISIC4, "3012")),
        ((Standards.JSIC13, "3133"), (Standards.ISIC4, "3315")),
        ((Standards.JSIC13, "3134"), (Standards.ISIC4, "2811")),
        ((Standards.JSIC13, "3141"), (Standards.ISIC4, "3030")),
        ((Standards.JSIC13, "3142"), (Standards.ISIC4, "3030")),
        ((Standards.JSIC13, "3149"), (Standards.ISIC4, "1392")),
        ((Standards.JSIC13, "3149"), (Standards.ISIC4, "3030")),
        ((Standards.JSIC13, "3151"), (Standards.ISIC4, "2816")),
        ((Standards.JSIC13, "3159"), (Standards.ISIC4, "2816")),
        ((Standards.JSIC13, "3191"), (Standards.ISIC4, "3092")),
        ((Standards.JSIC13, "3199"), (Standards.ISIC4, "3030")),
        ((Standards.JSIC13, "3199"), (Standards.ISIC4, "3099")),
        ((Standards.JSIC13, "3200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3211"), (Standards.ISIC4, "3211")),
        ((Standards.JSIC13, "3212"), (Standards.ISIC4, "3211")),
        ((Standards.JSIC13, "3219"), (Standards.ISIC4, "3211")),
        ((Standards.JSIC13, "3221"), (Standards.ISIC4, "3212")),
        ((Standards.JSIC13, "3222"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3223"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3224"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3229"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3231"), (Standards.ISIC4, "2652")),
        ((Standards.JSIC13, "3241"), (Standards.ISIC4, "3220")),
        ((Standards.JSIC13, "3249"), (Standards.ISIC4, "3220")),
        ((Standards.JSIC13, "3251"), (Standards.ISIC4, "2640")),
        ((Standards.JSIC13, "3251"), (Standards.ISIC4, "3240")),
        ((Standards.JSIC13, "3252"), (Standards.ISIC4, "3240")),
        ((Standards.JSIC13, "3253"), (Standards.ISIC4, "3230")),
        ((Standards.JSIC13, "3261"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3262"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "3262"), (Standards.ISIC4, "2022")),
        ((Standards.JSIC13, "3262"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3269"), (Standards.ISIC4, "2817")),
        ((Standards.JSIC13, "3269"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3271"), (Standards.ISIC4, "1622")),
        ((Standards.JSIC13, "3271"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "3271"), (Standards.ISIC4, "3100")),
        ((Standards.JSIC13, "3281"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "3282"), (Standards.ISIC4, "1629")),
        ((Standards.JSIC13, "3283"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3284"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3285"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3289"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "3289"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3291"), (Standards.ISIC4, "2029")),
        ((Standards.JSIC13, "3292"), (Standards.ISIC4, "2599")),
        ((Standards.JSIC13, "3292"), (Standards.ISIC4, "2790")),
        ((Standards.JSIC13, "3293"), (Standards.ISIC4, "1623")),
        ((Standards.JSIC13, "3294"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3295"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3296"), (Standards.ISIC4, "1820")),
        ((Standards.JSIC13, "3297"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "3299"), (Standards.ISIC4, "3290")),
        ((Standards.JSIC13, "3300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3311"), (Standards.ISIC4, "3510")),
        ((Standards.JSIC13, "3312"), (Standards.ISIC4, "3510")),
        ((Standards.JSIC13, "3400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3411"), (Standards.ISIC4, "3520")),
        ((Standards.JSIC13, "3412"), (Standards.ISIC4, "3520")),
        ((Standards.JSIC13, "3500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3511"), (Standards.ISIC4, "3530")),
        ((Standards.JSIC13, "3600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3611"), (Standards.ISIC4, "3600")),
        ((Standards.JSIC13, "3621"), (Standards.ISIC4, "3600")),
        ((Standards.JSIC13, "3631"), (Standards.ISIC4, "3700")),
        ((Standards.JSIC13, "3632"), (Standards.ISIC4, "3700")),
        ((Standards.JSIC13, "3700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3711"), (Standards.ISIC4, "6110")),
        ((Standards.JSIC13, "3712"), (Standards.ISIC4, "6110")),
        ((Standards.JSIC13, "3713"), (Standards.ISIC4, "6110")),
        ((Standards.JSIC13, "3719"), (Standards.ISIC4, "6110")),
        ((Standards.JSIC13, "3719"), (Standards.ISIC4, "6190")),
        ((Standards.JSIC13, "3719"), (Standards.ISIC4, "6311")),
        ((Standards.JSIC13, "3721"), (Standards.ISIC4, "6120")),
        ((Standards.JSIC13, "3721"), (Standards.ISIC4, "6130")),
        ((Standards.JSIC13, "3731"), (Standards.ISIC4, "6190")),
        ((Standards.JSIC13, "3800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3811"), (Standards.ISIC4, "6020")),
        ((Standards.JSIC13, "3821"), (Standards.ISIC4, "6020")),
        ((Standards.JSIC13, "3822"), (Standards.ISIC4, "6010")),
        ((Standards.JSIC13, "3823"), (Standards.ISIC4, "6020")),
        ((Standards.JSIC13, "3823"), (Standards.ISIC4, "6130")),
        ((Standards.JSIC13, "3829"), (Standards.ISIC4, "6020")),
        ((Standards.JSIC13, "3831"), (Standards.ISIC4, "6020")),
        ((Standards.JSIC13, "3831"), (Standards.ISIC4, "6110")),
        ((Standards.JSIC13, "3832"), (Standards.ISIC4, "6010")),
        ((Standards.JSIC13, "3900"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3909"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "3911"), (Standards.ISIC4, "6201")),
        ((Standards.JSIC13, "3911"), (Standards.ISIC4, "6202")),
        ((Standards.JSIC13, "3911"), (Standards.ISIC4, "6209")),
        ((Standards.JSIC13, "3912"), (Standards.ISIC4, "6201")),
        ((Standards.JSIC13, "3913"), (Standards.ISIC4, "5820")),
        ((Standards.JSIC13, "3914"), (Standards.ISIC4, "5820")),
        ((Standards.JSIC13, "3921"), (Standards.ISIC4, "6311")),
        ((Standards.JSIC13, "3922"), (Standards.ISIC4, "6399")),
        ((Standards.JSIC13, "3923"), (Standards.ISIC4, "7320")),
        ((Standards.JSIC13, "3929"), (Standards.ISIC4, "6399")),
        ((Standards.JSIC13, "4000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4011"), (Standards.ISIC4, "6312")),
        ((Standards.JSIC13, "4012"), (Standards.ISIC4, "6311")),
        ((Standards.JSIC13, "4013"), (Standards.ISIC4, "6399")),
        ((Standards.JSIC13, "4100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4111"), (Standards.ISIC4, "5911")),
        ((Standards.JSIC13, "4112"), (Standards.ISIC4, "5911")),
        ((Standards.JSIC13, "4113"), (Standards.ISIC4, "5912")),
        ((Standards.JSIC13, "4114"), (Standards.ISIC4, "5913")),
        ((Standards.JSIC13, "4121"), (Standards.ISIC4, "5920")),
        ((Standards.JSIC13, "4122"), (Standards.ISIC4, "5920")),
        ((Standards.JSIC13, "4131"), (Standards.ISIC4, "5813")),
        ((Standards.JSIC13, "4141"), (Standards.ISIC4, "5811")),
        ((Standards.JSIC13, "4141"), (Standards.ISIC4, "5812")),
        ((Standards.JSIC13, "4141"), (Standards.ISIC4, "5813")),
        ((Standards.JSIC13, "4151"), (Standards.ISIC4, "5819")),
        ((Standards.JSIC13, "4161"), (Standards.ISIC4, "6391")),
        ((Standards.JSIC13, "4169"), (Standards.ISIC4, "5912")),
        ((Standards.JSIC13, "4169"), (Standards.ISIC4, "5920")),
        ((Standards.JSIC13, "4169"), (Standards.ISIC4, "7810")),
        ((Standards.JSIC13, "4200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4211"), (Standards.ISIC4, "4911")),
        ((Standards.JSIC13, "4211"), (Standards.ISIC4, "4912")),
        ((Standards.JSIC13, "4212"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4213"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4214"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4215"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4216"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4216"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4217"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4217"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4219"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4219"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4311"), (Standards.ISIC4, "4921")),
        ((Standards.JSIC13, "4311"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4321"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4331"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4391"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4399"), (Standards.ISIC4, "4922")),
        ((Standards.JSIC13, "4400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4411"), (Standards.ISIC4, "4923")),
        ((Standards.JSIC13, "4412"), (Standards.ISIC4, "4923")),
        ((Standards.JSIC13, "4421"), (Standards.ISIC4, "4923")),
        ((Standards.JSIC13, "4431"), (Standards.ISIC4, "4923")),
        ((Standards.JSIC13, "4441"), (Standards.ISIC4, "5320")),
        ((Standards.JSIC13, "4499"), (Standards.ISIC4, "4923")),
        ((Standards.JSIC13, "4500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4511"), (Standards.ISIC4, "5011")),
        ((Standards.JSIC13, "4512"), (Standards.ISIC4, "5012")),
        ((Standards.JSIC13, "4521"), (Standards.ISIC4, "5011")),
        ((Standards.JSIC13, "4522"), (Standards.ISIC4, "5012")),
        ((Standards.JSIC13, "4531"), (Standards.ISIC4, "5021")),
        ((Standards.JSIC13, "4532"), (Standards.ISIC4, "5021")),
        ((Standards.JSIC13, "4532"), (Standards.ISIC4, "5022")),
        ((Standards.JSIC13, "4533"), (Standards.ISIC4, "5021")),
        ((Standards.JSIC13, "4533"), (Standards.ISIC4, "5022")),
        ((Standards.JSIC13, "4541"), (Standards.ISIC4, "5011")),
        ((Standards.JSIC13, "4541"), (Standards.ISIC4, "5012")),
        ((Standards.JSIC13, "4541"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "4542"), (Standards.ISIC4, "5011")),
        ((Standards.JSIC13, "4542"), (Standards.ISIC4, "5012")),
        ((Standards.JSIC13, "4542"), (Standards.ISIC4, "5021")),
        ((Standards.JSIC13, "4542"), (Standards.ISIC4, "5022")),
        ((Standards.JSIC13, "4542"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "4600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4611"), (Standards.ISIC4, "5110")),
        ((Standards.JSIC13, "4611"), (Standards.ISIC4, "5120")),
        ((Standards.JSIC13, "4621"), (Standards.ISIC4, "0161")),
        ((Standards.JSIC13, "4621"), (Standards.ISIC4, "7310")),
        ((Standards.JSIC13, "4621"), (Standards.ISIC4, "7420")),
        ((Standards.JSIC13, "4700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4711"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "4721"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "4800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4811"), (Standards.ISIC4, "5224")),
        ((Standards.JSIC13, "4821"), (Standards.ISIC4, "5320")),
        ((Standards.JSIC13, "4822"), (Standards.ISIC4, "5229")),
        ((Standards.JSIC13, "4831"), (Standards.ISIC4, "5229")),
        ((Standards.JSIC13, "4841"), (Standards.ISIC4, "5229")),
        ((Standards.JSIC13, "4842"), (Standards.ISIC4, "5229")),
        ((Standards.JSIC13, "4851"), (Standards.ISIC4, "5221")),
        ((Standards.JSIC13, "4852"), (Standards.ISIC4, "5221")),
        ((Standards.JSIC13, "4853"), (Standards.ISIC4, "5221")),
        ((Standards.JSIC13, "4854"), (Standards.ISIC4, "5221")),
        ((Standards.JSIC13, "4854"), (Standards.ISIC4, "5222")),
        ((Standards.JSIC13, "4854"), (Standards.ISIC4, "5223")),
        ((Standards.JSIC13, "4855"), (Standards.ISIC4, "5222")),
        ((Standards.JSIC13, "4856"), (Standards.ISIC4, "5223")),
        ((Standards.JSIC13, "4891"), (Standards.ISIC4, "5229")),
        ((Standards.JSIC13, "4899"), (Standards.ISIC4, "5221")),
        ((Standards.JSIC13, "4899"), (Standards.ISIC4, "5222")),
        ((Standards.JSIC13, "4899"), (Standards.ISIC4, "5223")),
        ((Standards.JSIC13, "4899"), (Standards.ISIC4, "5224")),
        ((Standards.JSIC13, "4899"), (Standards.ISIC4, "5229")),
        ((Standards.JSIC13, "4901"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "4911"), (Standards.ISIC4, "5310")),
        ((Standards.JSIC13, "4911"), (Standards.ISIC4, "5320")),
        ((Standards.JSIC13, "5000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5008"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5011"), (Standards.ISIC4, "4690")),
        ((Standards.JSIC13, "5019"), (Standards.ISIC4, "4690")),
        ((Standards.JSIC13, "5100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5108"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5111"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5112"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5113"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5121"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5122"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5123"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5129"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5131"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5132"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5133"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5139"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5139"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5208"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5211"), (Standards.ISIC4, "4620")),
        ((Standards.JSIC13, "5212"), (Standards.ISIC4, "4620")),
        ((Standards.JSIC13, "5213"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5214"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5215"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5216"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5219"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5221"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5222"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5223"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5224"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5225"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5226"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5227"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5229"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5308"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5311"), (Standards.ISIC4, "4663")),
        ((Standards.JSIC13, "5312"), (Standards.ISIC4, "4663")),
        ((Standards.JSIC13, "5313"), (Standards.ISIC4, "4663")),
        ((Standards.JSIC13, "5314"), (Standards.ISIC4, "4663")),
        ((Standards.JSIC13, "5319"), (Standards.ISIC4, "4663")),
        ((Standards.JSIC13, "5321"), (Standards.ISIC4, "4663")),
        ((Standards.JSIC13, "5322"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5329"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5331"), (Standards.ISIC4, "4661")),
        ((Standards.JSIC13, "5332"), (Standards.ISIC4, "4661")),
        ((Standards.JSIC13, "5332"), (Standards.ISIC4, "4662")),
        ((Standards.JSIC13, "5341"), (Standards.ISIC4, "4662")),
        ((Standards.JSIC13, "5342"), (Standards.ISIC4, "4662")),
        ((Standards.JSIC13, "5349"), (Standards.ISIC4, "4662")),
        ((Standards.JSIC13, "5351"), (Standards.ISIC4, "4662")),
        ((Standards.JSIC13, "5352"), (Standards.ISIC4, "4662")),
        ((Standards.JSIC13, "5361"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5362"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5363"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5364"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5369"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5408"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5411"), (Standards.ISIC4, "4653")),
        ((Standards.JSIC13, "5412"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5413"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5414"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5419"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5421"), (Standards.ISIC4, "4510")),
        ((Standards.JSIC13, "5421"), (Standards.ISIC4, "4520")),
        ((Standards.JSIC13, "5421"), (Standards.ISIC4, "4540")),
        ((Standards.JSIC13, "5422"), (Standards.ISIC4, "4530")),
        ((Standards.JSIC13, "5422"), (Standards.ISIC4, "4540")),
        ((Standards.JSIC13, "5423"), (Standards.ISIC4, "4520")),
        ((Standards.JSIC13, "5423"), (Standards.ISIC4, "4530")),
        ((Standards.JSIC13, "5423"), (Standards.ISIC4, "4540")),
        ((Standards.JSIC13, "5423"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5431"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5432"), (Standards.ISIC4, "4651")),
        ((Standards.JSIC13, "5432"), (Standards.ISIC4, "4652")),
        ((Standards.JSIC13, "5432"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5491"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5491"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5492"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5492"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5493"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5508"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5511"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5511"), (Standards.ISIC4, "4659")),
        ((Standards.JSIC13, "5512"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5513"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5514"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5514"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5515"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5519"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5521"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5522"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5523"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5524"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5531"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5532"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5591"), (Standards.ISIC4, "4663")),
        ((Standards.JSIC13, "5592"), (Standards.ISIC4, "4620")),
        ((Standards.JSIC13, "5592"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5592"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5593"), (Standards.ISIC4, "4641")),
        ((Standards.JSIC13, "5593"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5594"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5595"), (Standards.ISIC4, "4620")),
        ((Standards.JSIC13, "5595"), (Standards.ISIC4, "4630")),
        ((Standards.JSIC13, "5596"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5597"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5598"), (Standards.ISIC4, "4610")),
        ((Standards.JSIC13, "5599"), (Standards.ISIC4, "4620")),
        ((Standards.JSIC13, "5599"), (Standards.ISIC4, "4649")),
        ((Standards.JSIC13, "5599"), (Standards.ISIC4, "4661")),
        ((Standards.JSIC13, "5599"), (Standards.ISIC4, "4669")),
        ((Standards.JSIC13, "5600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5608"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5611"), (Standards.ISIC4, "4711")),
        ((Standards.JSIC13, "5611"), (Standards.ISIC4, "4719")),
        ((Standards.JSIC13, "5699"), (Standards.ISIC4, "4711")),
        ((Standards.JSIC13, "5699"), (Standards.ISIC4, "4719")),
        ((Standards.JSIC13, "5700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5708"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5711"), (Standards.ISIC4, "4751")),
        ((Standards.JSIC13, "5711"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5711"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5712"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "5712"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5721"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5721"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5731"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5731"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5732"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5732"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5741"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5741"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5742"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5742"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5791"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5791"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5792"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5792"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5793"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5793"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "5793"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5793"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "5799"), (Standards.ISIC4, "4771")),
        ((Standards.JSIC13, "5799"), (Standards.ISIC4, "4782")),
        ((Standards.JSIC13, "5800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5808"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5811"), (Standards.ISIC4, "4711")),
        ((Standards.JSIC13, "5811"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5821"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5821"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5822"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5822"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5831"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5831"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5832"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5832"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5841"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5841"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5851"), (Standards.ISIC4, "4722")),
        ((Standards.JSIC13, "5851"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5861"), (Standards.ISIC4, "1071")),
        ((Standards.JSIC13, "5862"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5862"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5863"), (Standards.ISIC4, "1071")),
        ((Standards.JSIC13, "5864"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5864"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5891"), (Standards.ISIC4, "4711")),
        ((Standards.JSIC13, "5892"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5892"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5893"), (Standards.ISIC4, "4722")),
        ((Standards.JSIC13, "5893"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5894"), (Standards.ISIC4, "4722")),
        ((Standards.JSIC13, "5894"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5895"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5895"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5896"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5896"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5897"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5897"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5898"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5898"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5899"), (Standards.ISIC4, "4721")),
        ((Standards.JSIC13, "5899"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "5900"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5908"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "5909"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "5911"), (Standards.ISIC4, "4510")),
        ((Standards.JSIC13, "5912"), (Standards.ISIC4, "4510")),
        ((Standards.JSIC13, "5912"), (Standards.ISIC4, "4520")),
        ((Standards.JSIC13, "5913"), (Standards.ISIC4, "4520")),
        ((Standards.JSIC13, "5913"), (Standards.ISIC4, "4530")),
        ((Standards.JSIC13, "5914"), (Standards.ISIC4, "4540")),
        ((Standards.JSIC13, "5921"), (Standards.ISIC4, "4763")),
        ((Standards.JSIC13, "5931"), (Standards.ISIC4, "4742")),
        ((Standards.JSIC13, "5931"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "5931"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "5932"), (Standards.ISIC4, "4741")),
        ((Standards.JSIC13, "5932"), (Standards.ISIC4, "4762")),
        ((Standards.JSIC13, "5932"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "5933"), (Standards.ISIC4, "4774")),
        ((Standards.JSIC13, "5933"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "5939"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "5939"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6008"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "6009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6011"), (Standards.ISIC4, "4752")),
        ((Standards.JSIC13, "6011"), (Standards.ISIC4, "4753")),
        ((Standards.JSIC13, "6011"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6011"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6012"), (Standards.ISIC4, "4752")),
        ((Standards.JSIC13, "6013"), (Standards.ISIC4, "4753")),
        ((Standards.JSIC13, "6014"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6021"), (Standards.ISIC4, "4752")),
        ((Standards.JSIC13, "6021"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6021"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6022"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6022"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6022"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6023"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6023"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6023"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6029"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6029"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6031"), (Standards.ISIC4, "4772")),
        ((Standards.JSIC13, "6031"), (Standards.ISIC4, "4719")),
        ((Standards.JSIC13, "6032"), (Standards.ISIC4, "4772")),
        ((Standards.JSIC13, "6033"), (Standards.ISIC4, "4772")),
        ((Standards.JSIC13, "6034"), (Standards.ISIC4, "4772")),
        ((Standards.JSIC13, "6041"), (Standards.ISIC4, "4653")),
        ((Standards.JSIC13, "6041"), (Standards.ISIC4, "4752")),
        ((Standards.JSIC13, "6042"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6043"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6051"), (Standards.ISIC4, "4730")),
        ((Standards.JSIC13, "6051"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6052"), (Standards.ISIC4, "4730")),
        ((Standards.JSIC13, "6052"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6061"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6061"), (Standards.ISIC4, "4761")),
        ((Standards.JSIC13, "6061"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6062"), (Standards.ISIC4, "4774")),
        ((Standards.JSIC13, "6063"), (Standards.ISIC4, "4761")),
        ((Standards.JSIC13, "6064"), (Standards.ISIC4, "4761")),
        ((Standards.JSIC13, "6071"), (Standards.ISIC4, "4763")),
        ((Standards.JSIC13, "6071"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6072"), (Standards.ISIC4, "4741")),
        ((Standards.JSIC13, "6072"), (Standards.ISIC4, "4764")),
        ((Standards.JSIC13, "6072"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6073"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6073"), (Standards.ISIC4, "4762")),
        ((Standards.JSIC13, "6073"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6081"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6082"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6091"), (Standards.ISIC4, "4719")),
        ((Standards.JSIC13, "6092"), (Standards.ISIC4, "4723")),
        ((Standards.JSIC13, "6092"), (Standards.ISIC4, "4781")),
        ((Standards.JSIC13, "6093"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6094"), (Standards.ISIC4, "4752")),
        ((Standards.JSIC13, "6094"), (Standards.ISIC4, "4753")),
        ((Standards.JSIC13, "6095"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6095"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6096"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6097"), (Standards.ISIC4, "4774")),
        ((Standards.JSIC13, "6098"), (Standards.ISIC4, "4774")),
        ((Standards.JSIC13, "6099"), (Standards.ISIC4, "4759")),
        ((Standards.JSIC13, "6099"), (Standards.ISIC4, "4762")),
        ((Standards.JSIC13, "6099"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "6099"), (Standards.ISIC4, "4789")),
        ((Standards.JSIC13, "6100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6108"), (Standards.ISIC4, "5210")),
        ((Standards.JSIC13, "6109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6111"), (Standards.ISIC4, "4791")),
        ((Standards.JSIC13, "6111"), (Standards.ISIC4, "4799")),
        ((Standards.JSIC13, "6112"), (Standards.ISIC4, "4791")),
        ((Standards.JSIC13, "6112"), (Standards.ISIC4, "4799")),
        ((Standards.JSIC13, "6113"), (Standards.ISIC4, "4791")),
        ((Standards.JSIC13, "6113"), (Standards.ISIC4, "4799")),
        ((Standards.JSIC13, "6114"), (Standards.ISIC4, "4791")),
        ((Standards.JSIC13, "6114"), (Standards.ISIC4, "4799")),
        ((Standards.JSIC13, "6119"), (Standards.ISIC4, "4791")),
        ((Standards.JSIC13, "6119"), (Standards.ISIC4, "4799")),
        ((Standards.JSIC13, "6121"), (Standards.ISIC4, "4799")),
        ((Standards.JSIC13, "6199"), (Standards.ISIC4, "4791")),
        ((Standards.JSIC13, "6199"), (Standards.ISIC4, "4799")),
        ((Standards.JSIC13, "6200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6211"), (Standards.ISIC4, "6411")),
        ((Standards.JSIC13, "6221"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6222"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6223"), (Standards.ISIC4, "6430")),
        ((Standards.JSIC13, "6229"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6311"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6312"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6313"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6314"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6321"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6322"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6323"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6324"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6325"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6411"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6412"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6421"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6431"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6432"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6491"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6492"), (Standards.ISIC4, "6492")),
        ((Standards.JSIC13, "6493"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6499"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6511"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6512"), (Standards.ISIC4, "6619")),
        ((Standards.JSIC13, "6513"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6513"), (Standards.ISIC4, "6630")),
        ((Standards.JSIC13, "6514"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6521"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6522"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6522"), (Standards.ISIC4, "6619")),
        ((Standards.JSIC13, "6529"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6611"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "6611"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6611"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6612"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6613"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6614"), (Standards.ISIC4, "6512")),
        ((Standards.JSIC13, "6615"), (Standards.ISIC4, "6520")),
        ((Standards.JSIC13, "6616"), (Standards.ISIC4, "6512")),
        ((Standards.JSIC13, "6617"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6617"), (Standards.ISIC4, "6611")),
        ((Standards.JSIC13, "6618"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6618"), (Standards.ISIC4, "6611")),
        ((Standards.JSIC13, "6619"), (Standards.ISIC4, "6499")),
        ((Standards.JSIC13, "6619"), (Standards.ISIC4, "6619")),
        ((Standards.JSIC13, "6619"), (Standards.ISIC4, "8291")),
        ((Standards.JSIC13, "6621"), (Standards.ISIC4, "6430")),
        ((Standards.JSIC13, "6622"), (Standards.ISIC4, "6430")),
        ((Standards.JSIC13, "6631"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6632"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6639"), (Standards.ISIC4, "6612")),
        ((Standards.JSIC13, "6700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6711"), (Standards.ISIC4, "6511")),
        ((Standards.JSIC13, "6712"), (Standards.ISIC4, "6511")),
        ((Standards.JSIC13, "6713"), (Standards.ISIC4, "6520")),
        ((Standards.JSIC13, "6719"), (Standards.ISIC4, "6511")),
        ((Standards.JSIC13, "6721"), (Standards.ISIC4, "6512")),
        ((Standards.JSIC13, "6722"), (Standards.ISIC4, "6520")),
        ((Standards.JSIC13, "6729"), (Standards.ISIC4, "6512")),
        ((Standards.JSIC13, "6731"), (Standards.ISIC4, "6511")),
        ((Standards.JSIC13, "6731"), (Standards.ISIC4, "6512")),
        ((Standards.JSIC13, "6732"), (Standards.ISIC4, "6511")),
        ((Standards.JSIC13, "6732"), (Standards.ISIC4, "6512")),
        ((Standards.JSIC13, "6733"), (Standards.ISIC4, "6512")),
        ((Standards.JSIC13, "6741"), (Standards.ISIC4, "6622")),
        ((Standards.JSIC13, "6742"), (Standards.ISIC4, "6622")),
        ((Standards.JSIC13, "6743"), (Standards.ISIC4, "6622")),
        ((Standards.JSIC13, "6751"), (Standards.ISIC4, "6629")),
        ((Standards.JSIC13, "6752"), (Standards.ISIC4, "6621")),
        ((Standards.JSIC13, "6759"), (Standards.ISIC4, "6621")),
        ((Standards.JSIC13, "6759"), (Standards.ISIC4, "6622")),
        ((Standards.JSIC13, "6759"), (Standards.ISIC4, "6629")),
        ((Standards.JSIC13, "6800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6811"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6812"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6821"), (Standards.ISIC4, "6820")),
        ((Standards.JSIC13, "6900"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6909"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "6911"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6912"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6919"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6921"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6922"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6931"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6931"), (Standards.ISIC4, "6820")),
        ((Standards.JSIC13, "6941"), (Standards.ISIC4, "6810")),
        ((Standards.JSIC13, "6941"), (Standards.ISIC4, "6820")),
        ((Standards.JSIC13, "7000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7011"), (Standards.ISIC4, "6491")),
        ((Standards.JSIC13, "7011"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7019"), (Standards.ISIC4, "6491")),
        ((Standards.JSIC13, "7019"), (Standards.ISIC4, "7729")),
        ((Standards.JSIC13, "7019"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7021"), (Standards.ISIC4, "6491")),
        ((Standards.JSIC13, "7021"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7022"), (Standards.ISIC4, "6491")),
        ((Standards.JSIC13, "7022"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7031"), (Standards.ISIC4, "6491")),
        ((Standards.JSIC13, "7031"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7032"), (Standards.ISIC4, "6491")),
        ((Standards.JSIC13, "7032"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7041"), (Standards.ISIC4, "6491")),
        ((Standards.JSIC13, "7041"), (Standards.ISIC4, "7710")),
        ((Standards.JSIC13, "7041"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7051"), (Standards.ISIC4, "7721")),
        ((Standards.JSIC13, "7091"), (Standards.ISIC4, "7729")),
        ((Standards.JSIC13, "7091"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7092"), (Standards.ISIC4, "7722")),
        ((Standards.JSIC13, "7093"), (Standards.ISIC4, "7729")),
        ((Standards.JSIC13, "7099"), (Standards.ISIC4, "7729")),
        ((Standards.JSIC13, "7099"), (Standards.ISIC4, "7730")),
        ((Standards.JSIC13, "7101"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7111"), (Standards.ISIC4, "7210")),
        ((Standards.JSIC13, "7112"), (Standards.ISIC4, "7210")),
        ((Standards.JSIC13, "7113"), (Standards.ISIC4, "7210")),
        ((Standards.JSIC13, "7114"), (Standards.ISIC4, "7210")),
        ((Standards.JSIC13, "7121"), (Standards.ISIC4, "7220")),
        ((Standards.JSIC13, "7201"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7211"), (Standards.ISIC4, "6910")),
        ((Standards.JSIC13, "7212"), (Standards.ISIC4, "6910")),
        ((Standards.JSIC13, "7221"), (Standards.ISIC4, "6910")),
        ((Standards.JSIC13, "7222"), (Standards.ISIC4, "6910")),
        ((Standards.JSIC13, "7222"), (Standards.ISIC4, "7110")),
        ((Standards.JSIC13, "7231"), (Standards.ISIC4, "6910")),
        ((Standards.JSIC13, "7241"), (Standards.ISIC4, "6920")),
        ((Standards.JSIC13, "7242"), (Standards.ISIC4, "6920")),
        ((Standards.JSIC13, "7251"), (Standards.ISIC4, "7490")),
        ((Standards.JSIC13, "7261"), (Standards.ISIC4, "7410")),
        ((Standards.JSIC13, "7271"), (Standards.ISIC4, "9000")),
        ((Standards.JSIC13, "7272"), (Standards.ISIC4, "9000")),
        ((Standards.JSIC13, "7281"), (Standards.ISIC4, "7020")),
        ((Standards.JSIC13, "7281"), (Standards.ISIC4, "7740")),
        ((Standards.JSIC13, "7282"), (Standards.ISIC4, "6420")),
        ((Standards.JSIC13, "7282"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7291"), (Standards.ISIC4, "8030")),
        ((Standards.JSIC13, "7292"), (Standards.ISIC4, "7490")),
        ((Standards.JSIC13, "7293"), (Standards.ISIC4, "7490")),
        ((Standards.JSIC13, "7294"), (Standards.ISIC4, "6820")),
        ((Standards.JSIC13, "7299"), (Standards.ISIC4, "7490")),
        ((Standards.JSIC13, "7300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7311"), (Standards.ISIC4, "7310")),
        ((Standards.JSIC13, "7401"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7411"), (Standards.ISIC4, "7500")),
        ((Standards.JSIC13, "7421"), (Standards.ISIC4, "7110")),
        ((Standards.JSIC13, "7422"), (Standards.ISIC4, "7110")),
        ((Standards.JSIC13, "7429"), (Standards.ISIC4, "7110")),
        ((Standards.JSIC13, "7431"), (Standards.ISIC4, "7110")),
        ((Standards.JSIC13, "7441"), (Standards.ISIC4, "7120")),
        ((Standards.JSIC13, "7442"), (Standards.ISIC4, "7120")),
        ((Standards.JSIC13, "7451"), (Standards.ISIC4, "5229")),
        ((Standards.JSIC13, "7452"), (Standards.ISIC4, "7120")),
        ((Standards.JSIC13, "7459"), (Standards.ISIC4, "7120")),
        ((Standards.JSIC13, "7461"), (Standards.ISIC4, "7420")),
        ((Standards.JSIC13, "7462"), (Standards.ISIC4, "7420")),
        ((Standards.JSIC13, "7499"), (Standards.ISIC4, "7110")),
        ((Standards.JSIC13, "7500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7511"), (Standards.ISIC4, "5510")),
        ((Standards.JSIC13, "7521"), (Standards.ISIC4, "5510")),
        ((Standards.JSIC13, "7531"), (Standards.ISIC4, "5590")),
        ((Standards.JSIC13, "7591"), (Standards.ISIC4, "5510")),
        ((Standards.JSIC13, "7592"), (Standards.ISIC4, "5510")),
        ((Standards.JSIC13, "7599"), (Standards.ISIC4, "5520")),
        ((Standards.JSIC13, "7599"), (Standards.ISIC4, "5590")),
        ((Standards.JSIC13, "7600"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7609"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7611"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7611"), (Standards.ISIC4, "5629")),
        ((Standards.JSIC13, "7621"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7622"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7623"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7624"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7625"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7629"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7631"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7641"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7651"), (Standards.ISIC4, "5630")),
        ((Standards.JSIC13, "7661"), (Standards.ISIC4, "5630")),
        ((Standards.JSIC13, "7671"), (Standards.ISIC4, "5630")),
        ((Standards.JSIC13, "7691"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7692"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7699"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7699"), (Standards.ISIC4, "5629")),
        ((Standards.JSIC13, "7700"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7709"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7711"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7711"), (Standards.ISIC4, "5629")),
        ((Standards.JSIC13, "7721"), (Standards.ISIC4, "5610")),
        ((Standards.JSIC13, "7721"), (Standards.ISIC4, "5621")),
        ((Standards.JSIC13, "7800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7811"), (Standards.ISIC4, "9601")),
        ((Standards.JSIC13, "7812"), (Standards.ISIC4, "9601")),
        ((Standards.JSIC13, "7813"), (Standards.ISIC4, "9601")),
        ((Standards.JSIC13, "7821"), (Standards.ISIC4, "9602")),
        ((Standards.JSIC13, "7831"), (Standards.ISIC4, "9602")),
        ((Standards.JSIC13, "7841"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7851"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7891"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7892"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7893"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7894"), (Standards.ISIC4, "9602")),
        ((Standards.JSIC13, "7899"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7900"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7909"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "7911"), (Standards.ISIC4, "7912")),
        ((Standards.JSIC13, "7912"), (Standards.ISIC4, "7911")),
        ((Standards.JSIC13, "7921"), (Standards.ISIC4, "9700")),
        ((Standards.JSIC13, "7922"), (Standards.ISIC4, "9700")),
        ((Standards.JSIC13, "7931"), (Standards.ISIC4, "9529")),
        ((Standards.JSIC13, "7941"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7951"), (Standards.ISIC4, "9603")),
        ((Standards.JSIC13, "7952"), (Standards.ISIC4, "9603")),
        ((Standards.JSIC13, "7961"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "7961"), (Standards.ISIC4, "9603")),
        ((Standards.JSIC13, "7962"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7963"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7991"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7992"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "7993"), (Standards.ISIC4, "7420")),
        ((Standards.JSIC13, "7999"), (Standards.ISIC4, "7990")),
        ((Standards.JSIC13, "7999"), (Standards.ISIC4, "9200")),
        ((Standards.JSIC13, "7999"), (Standards.ISIC4, "9609")),
        ((Standards.JSIC13, "8000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8011"), (Standards.ISIC4, "5914")),
        ((Standards.JSIC13, "8021"), (Standards.ISIC4, "9000")),
        ((Standards.JSIC13, "8022"), (Standards.ISIC4, "9000")),
        ((Standards.JSIC13, "8022"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8023"), (Standards.ISIC4, "9000")),
        ((Standards.JSIC13, "8024"), (Standards.ISIC4, "9000")),
        ((Standards.JSIC13, "8025"), (Standards.ISIC4, "9000")),
        ((Standards.JSIC13, "8025"), (Standards.ISIC4, "9312")),
        ((Standards.JSIC13, "8025"), (Standards.ISIC4, "9319")),
        ((Standards.JSIC13, "8031"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8032"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8033"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8034"), (Standards.ISIC4, "9319")),
        ((Standards.JSIC13, "8035"), (Standards.ISIC4, "9319")),
        ((Standards.JSIC13, "8036"), (Standards.ISIC4, "9319")),
        ((Standards.JSIC13, "8041"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8042"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8043"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8044"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8045"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8046"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8047"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8048"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8051"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8052"), (Standards.ISIC4, "9321")),
        ((Standards.JSIC13, "8053"), (Standards.ISIC4, "9321")),
        ((Standards.JSIC13, "8061"), (Standards.ISIC4, "9311")),
        ((Standards.JSIC13, "8062"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8063"), (Standards.ISIC4, "9200")),
        ((Standards.JSIC13, "8064"), (Standards.ISIC4, "9200")),
        ((Standards.JSIC13, "8065"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8069"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8091"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8092"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8093"), (Standards.ISIC4, "5011")),
        ((Standards.JSIC13, "8093"), (Standards.ISIC4, "5021")),
        ((Standards.JSIC13, "8094"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8095"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8096"), (Standards.ISIC4, "7810")),
        ((Standards.JSIC13, "8096"), (Standards.ISIC4, "7990")),
        ((Standards.JSIC13, "8096"), (Standards.ISIC4, "9200")),
        ((Standards.JSIC13, "8096"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8099"), (Standards.ISIC4, "9319")),
        ((Standards.JSIC13, "8099"), (Standards.ISIC4, "9329")),
        ((Standards.JSIC13, "8101"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8111"), (Standards.ISIC4, "8510")),
        ((Standards.JSIC13, "8121"), (Standards.ISIC4, "8510")),
        ((Standards.JSIC13, "8131"), (Standards.ISIC4, "8521")),
        ((Standards.JSIC13, "8141"), (Standards.ISIC4, "8521")),
        ((Standards.JSIC13, "8141"), (Standards.ISIC4, "8522")),
        ((Standards.JSIC13, "8142"), (Standards.ISIC4, "8521")),
        ((Standards.JSIC13, "8151"), (Standards.ISIC4, "8510")),
        ((Standards.JSIC13, "8151"), (Standards.ISIC4, "8521")),
        ((Standards.JSIC13, "8151"), (Standards.ISIC4, "8522")),
        ((Standards.JSIC13, "8161"), (Standards.ISIC4, "8530")),
        ((Standards.JSIC13, "8162"), (Standards.ISIC4, "8530")),
        ((Standards.JSIC13, "8163"), (Standards.ISIC4, "8530")),
        ((Standards.JSIC13, "8171"), (Standards.ISIC4, "8522")),
        ((Standards.JSIC13, "8172"), (Standards.ISIC4, "8522")),
        ((Standards.JSIC13, "8181"), (Standards.ISIC4, "8550")),
        ((Standards.JSIC13, "8191"), (Standards.ISIC4, "8510")),
        ((Standards.JSIC13, "8191"), (Standards.ISIC4, "8890")),
        ((Standards.JSIC13, "8200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8211"), (Standards.ISIC4, "8890")),
        ((Standards.JSIC13, "8212"), (Standards.ISIC4, "9101")),
        ((Standards.JSIC13, "8213"), (Standards.ISIC4, "9102")),
        ((Standards.JSIC13, "8214"), (Standards.ISIC4, "9103")),
        ((Standards.JSIC13, "8215"), (Standards.ISIC4, "8541")),
        ((Standards.JSIC13, "8216"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8219"), (Standards.ISIC4, "8550")),
        ((Standards.JSIC13, "8221"), (Standards.ISIC4, "8530")),
        ((Standards.JSIC13, "8221"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8222"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8229"), (Standards.ISIC4, "8521")),
        ((Standards.JSIC13, "8231"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8241"), (Standards.ISIC4, "8542")),
        ((Standards.JSIC13, "8242"), (Standards.ISIC4, "8542")),
        ((Standards.JSIC13, "8243"), (Standards.ISIC4, "8542")),
        ((Standards.JSIC13, "8244"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8245"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8246"), (Standards.ISIC4, "8541")),
        ((Standards.JSIC13, "8249"), (Standards.ISIC4, "8541")),
        ((Standards.JSIC13, "8249"), (Standards.ISIC4, "8542")),
        ((Standards.JSIC13, "8249"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8299"), (Standards.ISIC4, "8549")),
        ((Standards.JSIC13, "8300"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8309"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8311"), (Standards.ISIC4, "8610")),
        ((Standards.JSIC13, "8312"), (Standards.ISIC4, "8610")),
        ((Standards.JSIC13, "8321"), (Standards.ISIC4, "8610")),
        ((Standards.JSIC13, "8322"), (Standards.ISIC4, "8620")),
        ((Standards.JSIC13, "8331"), (Standards.ISIC4, "8610")),
        ((Standards.JSIC13, "8331"), (Standards.ISIC4, "8620")),
        ((Standards.JSIC13, "8341"), (Standards.ISIC4, "8690")),
        ((Standards.JSIC13, "8342"), (Standards.ISIC4, "8690")),
        ((Standards.JSIC13, "8351"), (Standards.ISIC4, "8690")),
        ((Standards.JSIC13, "8359"), (Standards.ISIC4, "8690")),
        ((Standards.JSIC13, "8361"), (Standards.ISIC4, "3250")),
        ((Standards.JSIC13, "8369"), (Standards.ISIC4, "8690")),
        ((Standards.JSIC13, "8400"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8409"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8411"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8421"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8422"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8423"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8429"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8491"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8492"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8493"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8499"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8500"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8509"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8511"), (Standards.ISIC4, "8430")),
        ((Standards.JSIC13, "8511"), (Standards.ISIC4, "6530")),
        ((Standards.JSIC13, "8521"), (Standards.ISIC4, "8810")),
        ((Standards.JSIC13, "8521"), (Standards.ISIC4, "8890")),
        ((Standards.JSIC13, "8531"), (Standards.ISIC4, "8890")),
        ((Standards.JSIC13, "8539"), (Standards.ISIC4, "8790")),
        ((Standards.JSIC13, "8539"), (Standards.ISIC4, "8890")),
        ((Standards.JSIC13, "8541"), (Standards.ISIC4, "8710")),
        ((Standards.JSIC13, "8542"), (Standards.ISIC4, "8690")),
        ((Standards.JSIC13, "8543"), (Standards.ISIC4, "8710")),
        ((Standards.JSIC13, "8543"), (Standards.ISIC4, "8810")),
        ((Standards.JSIC13, "8544"), (Standards.ISIC4, "8810")),
        ((Standards.JSIC13, "8545"), (Standards.ISIC4, "8710")),
        ((Standards.JSIC13, "8546"), (Standards.ISIC4, "8710")),
        ((Standards.JSIC13, "8546"), (Standards.ISIC4, "8730")),
        ((Standards.JSIC13, "8549"), (Standards.ISIC4, "8730")),
        ((Standards.JSIC13, "8549"), (Standards.ISIC4, "8810")),
        ((Standards.JSIC13, "8551"), (Standards.ISIC4, "8710")),
        ((Standards.JSIC13, "8551"), (Standards.ISIC4, "8720")),
        ((Standards.JSIC13, "8551"), (Standards.ISIC4, "8730")),
        ((Standards.JSIC13, "8559"), (Standards.ISIC4, "8810")),
        ((Standards.JSIC13, "8591"), (Standards.ISIC4, "8790")),
        ((Standards.JSIC13, "8591"), (Standards.ISIC4, "8890")),
        ((Standards.JSIC13, "8599"), (Standards.ISIC4, "8790")),
        ((Standards.JSIC13, "8599"), (Standards.ISIC4, "8890")),
        ((Standards.JSIC13, "8601"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8611"), (Standards.ISIC4, "5310")),
        ((Standards.JSIC13, "8611"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "8611"), (Standards.ISIC4, "6511")),
        ((Standards.JSIC13, "8621"), (Standards.ISIC4, "5310")),
        ((Standards.JSIC13, "8621"), (Standards.ISIC4, "6419")),
        ((Standards.JSIC13, "8621"), (Standards.ISIC4, "6622")),
        ((Standards.JSIC13, "8629"), (Standards.ISIC4, "4773")),
        ((Standards.JSIC13, "8701"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8800"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8809"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8811"), (Standards.ISIC4, "3700")),
        ((Standards.JSIC13, "8812"), (Standards.ISIC4, "3700")),
        ((Standards.JSIC13, "8813"), (Standards.ISIC4, "3700")),
        ((Standards.JSIC13, "8814"), (Standards.ISIC4, "3700")),
        ((Standards.JSIC13, "8815"), (Standards.ISIC4, "3811")),
        ((Standards.JSIC13, "8816"), (Standards.ISIC4, "3821")),
        ((Standards.JSIC13, "8817"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "8821"), (Standards.ISIC4, "3811")),
        ((Standards.JSIC13, "8821"), (Standards.ISIC4, "3812")),
        ((Standards.JSIC13, "8822"), (Standards.ISIC4, "3821")),
        ((Standards.JSIC13, "8822"), (Standards.ISIC4, "3822")),
        ((Standards.JSIC13, "8823"), (Standards.ISIC4, "3812")),
        ((Standards.JSIC13, "8824"), (Standards.ISIC4, "3822")),
        ((Standards.JSIC13, "8891"), (Standards.ISIC4, "3822")),
        ((Standards.JSIC13, "8899"), (Standards.ISIC4, "3822")),
        ((Standards.JSIC13, "8901"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "8911"), (Standards.ISIC4, "4520")),
        ((Standards.JSIC13, "8911"), (Standards.ISIC4, "4540")),
        ((Standards.JSIC13, "8919"), (Standards.ISIC4, "4520")),
        ((Standards.JSIC13, "8919"), (Standards.ISIC4, "4540")),
        ((Standards.JSIC13, "9000"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "9009"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "9011"), (Standards.ISIC4, "3311")),
        ((Standards.JSIC13, "9011"), (Standards.ISIC4, "3312")),
        ((Standards.JSIC13, "9012"), (Standards.ISIC4, "3312")),
        ((Standards.JSIC13, "9021"), (Standards.ISIC4, "3314")),
        ((Standards.JSIC13, "9021"), (Standards.ISIC4, "9511")),
        ((Standards.JSIC13, "9021"), (Standards.ISIC4, "9512")),
        ((Standards.JSIC13, "9021"), (Standards.ISIC4, "9521")),
        ((Standards.JSIC13, "9021"), (Standards.ISIC4, "9522")),
        ((Standards.JSIC13, "9031"), (Standards.ISIC4, "9524")),
        ((Standards.JSIC13, "9091"), (Standards.ISIC4, "9524")),
        ((Standards.JSIC13, "9092"), (Standards.ISIC4, "9529")),
        ((Standards.JSIC13, "9093"), (Standards.ISIC4, "9523")),
        ((Standards.JSIC13, "9099"), (Standards.ISIC4, "9529")),
        ((Standards.JSIC13, "9099"), (Standards.ISIC4, "9523")),
        ((Standards.JSIC13, "9100"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "9109"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "9111"), (Standards.ISIC4, "7810")),
        ((Standards.JSIC13, "9121"), (Standards.ISIC4, "7820")),
        ((Standards.JSIC13, "9121"), (Standards.ISIC4, "7830")),
        ((Standards.JSIC13, "9200"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "9209"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "9211"), (Standards.ISIC4, "8219")),
        ((Standards.JSIC13, "9211"), (Standards.ISIC4, "8299")),
        ((Standards.JSIC13, "9212"), (Standards.ISIC4, "8219")),
        ((Standards.JSIC13, "9221"), (Standards.ISIC4, "8110")),
        ((Standards.JSIC13, "9229"), (Standards.ISIC4, "8121")),
        ((Standards.JSIC13, "9229"), (Standards.ISIC4, "8129")),
        ((Standards.JSIC13, "9231"), (Standards.ISIC4, "8010")),
        ((Standards.JSIC13, "9231"), (Standards.ISIC4, "8020")),
        ((Standards.JSIC13, "9291"), (Standards.ISIC4, "7310")),
        ((Standards.JSIC13, "9292"), (Standards.ISIC4, "8129")),
        ((Standards.JSIC13, "9293"), (Standards.ISIC4, "7310")),
        ((Standards.JSIC13, "9294"), (Standards.ISIC4, "8220")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "3830")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "6399")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "7310")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "7740")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "8211")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "8230")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "8291")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "8292")),
        ((Standards.JSIC13, "9299"), (Standards.ISIC4, "8299")),
        ((Standards.JSIC13, "9311"), (Standards.ISIC4, "9411")),
        ((Standards.JSIC13, "9312"), (Standards.ISIC4, "9411")),
        ((Standards.JSIC13, "9312"), (Standards.ISIC4, "9412")),
        ((Standards.JSIC13, "9321"), (Standards.ISIC4, "9420")),
        ((Standards.JSIC13, "9331"), (Standards.ISIC4, "9412")),
        ((Standards.JSIC13, "9332"), (Standards.ISIC4, "9412")),
        ((Standards.JSIC13, "9341"), (Standards.ISIC4, "9492")),
        ((Standards.JSIC13, "9399"), (Standards.ISIC4, "9499")),
        ((Standards.JSIC13, "9411"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9412"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9421"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9422"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9431"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9432"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9491"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9499"), (Standards.ISIC4, "9491")),
        ((Standards.JSIC13, "9501"), (Standards.ISIC4, "7010")),
        ((Standards.JSIC13, "9511"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "9521"), (Standards.ISIC4, "1010")),
        ((Standards.JSIC13, "9599"), (Standards.ISIC4, "8413")),
        ((Standards.JSIC13, "9611"), (Standards.ISIC4, "8421")),
        ((Standards.JSIC13, "9699"), (Standards.ISIC4, "9900")),
        ((Standards.JSIC13, "9711"), (Standards.ISIC4, "8411")),
        ((Standards.JSIC13, "9721"), (Standards.ISIC4, "8423")),
        ((Standards.JSIC13, "9731"), (Standards.ISIC4, "8411")),
        ((Standards.JSIC13, "9731"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "9731"), (Standards.ISIC4, "8413")),
        ((Standards.JSIC13, "9731"), (Standards.ISIC4, "8421")),
        ((Standards.JSIC13, "9731"), (Standards.ISIC4, "8422")),
        ((Standards.JSIC13, "9731"), (Standards.ISIC4, "8423")),
        ((Standards.JSIC13, "9731"), (Standards.ISIC4, "8430")),
        ((Standards.JSIC13, "9811"), (Standards.ISIC4, "8411")),
        ((Standards.JSIC13, "9811"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "9811"), (Standards.ISIC4, "8413")),
        ((Standards.JSIC13, "9811"), (Standards.ISIC4, "8423")),
        ((Standards.JSIC13, "9821"), (Standards.ISIC4, "8411")),
        ((Standards.JSIC13, "9821"), (Standards.ISIC4, "8412")),
        ((Standards.JSIC13, "9821"), (Standards.ISIC4, "8413")),
        ((Standards.JSIC13, "9821"), (Standards.ISIC4, "8423")),
    ],
)
