# AUTOGENERATED! DO NOT EDIT! File to edit: 02_data_cloud.ipynb (unless otherwise specified).

__all__ = ['get_data_cloud']

# Cell
# export
import os
import requests
import json
import pandas as pd

# Cell


def get_data_cloud(space_id, room_id, context, after, before, points=None, api_token=None,
                   base_url='https://app.netdata.cloud', time_as_index=True, time_unit='ms',
                   group='average', aggregations=[{'method': 'sum', 'groupBy': ['dimension']}],
                   agent_options=['absolute', 'jsonwrap', 'nonzero', 'flip', 'ms'], gtime=0, with_metadata=True,
                   format='array', node_ids=[], dimensions=[]
                   ):
    """Get data from netdata cloud api"""
    if api_token is None:
        api_token = os.getenv('NETDATA_API_TOKEN')

    base_url = 'https://app.netdata.cloud'
    url = f'{base_url}/api/v2/spaces/{space_id}/rooms/{room_id}/data'
    headers = {'Accept': '*/*', 'Content-Type': 'application/json', 'Authorization': f'Bearer {api_token}'}
    data = {
        'filter': {
            'nodeIDs': node_ids,
            'context': context,
            'dimensions': dimensions,
        },
        'after': int(after),
        'before': int(before),
        'format': format,
        'group': group,
        'aggregations': aggregations,
        'agent_options': agent_options,
        'gtime': gtime,
        'with_metadata': with_metadata
    }
    if points:
        data['points'] = points
    r = requests.post(url, headers=headers, data=json.dumps(data))

    if r.status_code != 200:

        print(f'Error: {r.status_code, r.text}')
        return pd.DataFrame()

    else:

        df = pd.DataFrame(data=r.json()['result']['data'], columns=r.json()['result']['labels'])

        if time_unit:
            df['time'] = pd.to_datetime(df['time'], unit='ms')
        if time_as_index:
            df = df.set_index('time')

        return df

