# autonote

[![codecov](https://codecov.io/gh/nakamasato/autonote/branch/main/graph/badge.svg?token=ejR44mVdjO)](https://codecov.io/gh/nakamasato/autonote)

## Description

![](docs/diagram.drawio.svg)

Automate creating daily, weekly, monthly, and quarterly manual repetitive documents:

1. Daily: daily journal, habit tracker
1. Weekly: weekly report
1. Monthly: monthly report
1. Quarterly: quarterly review

## Prerequisite

1. Confluence API Token
1. Notion Integration Token

## Installation

```
pip install autonote
```

## Usage (Notion)

```python
from autonote.notion import NotionClient

client = NotionClient()

kwargs = {
    "Date": {"start": "2023-02-04", "end": "2023-02-10"},
    "replace_rules": [
        {
            "block_types": ["heading_1"],  # target blocks to apply replacement
            "replace_str": "YYYY/MM/DD",  # replacement string match
            "replace_type": "datetime",  # currently only support "datetime"
            "date_format": "%Y/%m/%d",  # used to parse `start_date` and generate string from datetime when interpolating
            "start_date": "2023/02/04",  # start date
            "increment": True,  # if true, increment 1 day every time replacement is executed
        },
    ],
}
client.create_page_from_template(
    template_id="a7cc4f73460c4b9fa82be8d4ed74d8ca",
    title="weekly note",
    override=True,
    **kwargs
)
```

Template:

<table><tr><td>
<img src="docs/notion_template_page_1.png" width="200px" />
</td></tr></table>

Generated page:

<table><tr><td>
<img src="docs/notion_page_3.png" width="200px" />
</td></tr></table>


For more examples, please check [Examples](examples/README.md).

## Credits

`autonote` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).

## Contributing

Interested in contributing? Check out the contributing guidelines. Please note that this project is released with a Code of Conduct. By contributing to this project, you agree to abide by its terms.

## License

`autonote` was created by Masato Naka. It is licensed under the terms of the MIT license.

## References
1. [Atlassian Python API Confluence module](https://atlassian-python-api.readthedocs.io/confluence.html)
1. [notion-client](https://pypi.org/project/notion-client/)
1. [Notion API](https://developers.notion.com/)
