# Generated by Django 3.1.2 on 2020-10-07 11:14

from django.conf import settings
import django.contrib.sites.managers
import django.contrib.sites.models
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BigBlueButton',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='Server name')),
                ('url', models.URLField(verbose_name='API base URL')),
                ('salt', models.CharField(max_length=60, verbose_name='API shared secret')),
            ],
        ),
        migrations.CreateModel(
            name='Meeting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='Meeting name')),
                ('welcome_message', models.TextField(blank=True, verbose_name='Welcome message')),
                ('moderator_message', models.TextField(blank=True, verbose_name='Welcome message for moderators')),
                ('max_participants', models.PositiveSmallIntegerField(default=0, verbose_name='Maximum number of participants')),
                ('guid', models.UUIDField(default=uuid.uuid1, editable=False)),
                ('api', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='meetings', to='django.bigbluebutton')),
            ],
        ),
        migrations.CreateModel(
            name='BigBlueButtonGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, verbose_name='Group name')),
                ('site', models.ForeignKey(default=django.contrib.sites.models.SiteManager.get_current, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('on_site', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AddField(
            model_name='bigbluebutton',
            name='group',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='apis', to='django.bigbluebuttongroup'),
        ),
        migrations.CreateModel(
            name='APIToken',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=60, unique=True, verbose_name='Descriptive name')),
                ('salt', models.CharField(max_length=60, unique=True, verbose_name='API salt')),
                ('scope', models.CharField(choices=[('token', 'Data associated to this token'), ('user', 'Data associated to the owning user'), ('global', 'All data')], default='token', max_length=15, verbose_name='Privilege scope')),
                ('guid', models.UUIDField(default=uuid.uuid1, editable=False)),
                ('server_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='django.bigbluebuttongroup')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User owning this token')),
            ],
        ),
    ]
