# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['obswebsocket_trio']

package_data = \
{'': ['*']}

install_requires = \
['single-source>=0.2.0,<0.3.0',
 'six>=1.16.0,<2.0.0',
 'trio-websocket>=0.9.2,<0.10.0',
 'trio>=0.19.0,<0.20.0',
 'typer>=0.4.0,<0.5.0']

setup_kwargs = {
    'name': 'obswebsocket-trio',
    'version': '0.1.1.post1',
    'description': 'Python library to communicate with an obs-websocket server, trio async version. Fork of obs-websocket-py<https://github.com/Elektordi/obs-websocket-py>',
    'long_description': '![PyPI - License](https://img.shields.io/pypi/l/obs-websocket-py-trio)\n![PyPI](https://img.shields.io/pypi/v/obs-websocket-py-trio)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/obs-websocket-py-trio)\n![GitHub commit activity](https://img.shields.io/github/commit-activity/m/mkdryden/obs-websocket-py-trio)\n\n# obs-websocket-py\nPython library to communicate with an [obs-websocket](https://github.com/Palakis/obs-websocket) server.\nThis is a fork of [obs-websocket-py](https://github.com/Elektordi/obs-websocket-py) using the trio async library.\n\n_Licensed under the MIT License_\n\n## Project pages\n\nGitHub project: https://github.com/mkdryden/obs-websocket-py-trio\n\nPyPI package: https://pypi.org/project/obs-websocket-py-trio/\n\n## Installation\n\nJust run `pip install obswebsocket-trio` in your Python venv or directly on your system.\n\nFor development, `poetry install` from the source directory will generate a venv with all the dependencies\n\nFor manual install, git clone the github repo and copy the directory **obswebsocket_trio** in your python project root.\n\n\n## Usage\n\nSee python scripts in the [samples](https://github.com/mkdryden/obs-websocket-py-trio/tree/master/samples) directory.\n\nThe big change from the original obs-websocket-py is the use of the trio async library.\nThis means that most methods of `ObsWS` must be called with `await` from inside a trio event loop.\nA new convenience function `open_obs_websocket` acts as an asynchronous context manager yielding an `ObsWs` instance,\nautomatically connecting and starting a trio `Nursery` to manage the background tasks required for the websocket\nconnection and to handle events from OBS.\n\n\nA simple example to print the names of all scenes:\n```python\nfrom obswebsocket_trio import open_obs_websocket, requests\nimport trio\n\nasync def main(host: str = \'localhost\', port: int = 4444, password: str = \'secret\'):\n    async with open_obs_websocket(host, port, password) as ws:\n        scenes = await ws.call(requests.GetSceneList())\n        for scene in scenes.getScenes():\n            print(scene[\'name\'])\n\ntrio.run(main)\n```\n\nOr take a look at the documentation below:\n\n_Output of `pydoc obswebsocket.core.ObsWS`:_\n\n```\nHelp on class ObsWS in obswebsocket.core:\n\nobswebsocket.core.ObsWS = class ObsWS(trio.abc.AsyncResource)\n |  obswebsocket.core.ObsWS(nursery: trio.Nursery, host=\'localhost\', port=4444, password=\'\')\n |\n |  Core class for using obs-websocket-py\n |\n |  Simple usage:\n |      >>> import obswebsocket_trio, obswebsocket_trio.requests as obsrequests\n |      >>> async with obswebsocket_trio.open_obs_websocket("localhost", 4444, "secret") as client:\n |      >>>     await client.call(obsrequests.GetVersion()).getObsWebsocketVersion()\n |      \'4.1.0\'\n |\n |  For advanced usage, including events callback, see the \'samples\' directory.\n |\n |  Method resolution order:\n |      ObsWS\n |      trio.abc.AsyncResource\n |      builtins.object\n |\n |  Methods defined here:\n |\n |  __init__(self, nursery: trio.Nursery, host=\'localhost\', port=4444, password=\'\')\n |      Construct a new obsws wrapper\n |\n |      :param nursery: A trio Nursery to run background tasks\n |      :param host: Hostname to connect to\n |      :param port: TCP Port to connect to (Default is 4444)\n |      :param password: Password for the websocket server (Leave this field\n |          empty if no auth enabled on the server)\n |\n |  async aclose(self)\n |      Close this resource, possibly blocking.\n |\n |      IMPORTANT: This method may block in order to perform a "graceful"\n |      shutdown. But, if this fails, then it still *must* close any\n |      underlying resources before returning. An error from this method\n |      indicates a failure to achieve grace, *not* a failure to close the\n |      connection.\n |\n |      For example, suppose we call :meth:`aclose` on a TLS-encrypted\n |      connection. This requires sending a "goodbye" message; but if the peer\n |      has become non-responsive, then our attempt to send this message might\n |      block forever, and eventually time out and be cancelled. In this case\n |      the :meth:`aclose` method on :class:`~trio.SSLStream` will\n |      immediately close the underlying transport stream using\n |      :func:`trio.aclose_forcefully` before raising :exc:`~trio.Cancelled`.\n |\n |      If the resource is already closed, then this method should silently\n |      succeed.\n |\n |      Once this method completes, any other pending or future operations on\n |      this resource should generally raise :exc:`~trio.ClosedResourceError`,\n |      unless there\'s a good reason to do otherwise.\n |\n |      See also: :func:`trio.aclose_forcefully`.\n |\n |  async call(self, obj) -> obswebsocket.base_classes.Baserequests\n |      Make a call to the OBS server through the Websocket.\n |\n |      :param obj: Request (class from obswebsocket.requests module) to send\n |          to the server.\n |      :return: Request object populated with response data.\n |\n |  async connect(self, autoreconnect: bool = True)\n |      Connect to the websocket server\n |      :param autoreconnect: If True, tries to reconnect every 2 seconds if disconnected.\n |\n |      :return: Nothing\n |\n |  async disconnect(self)\n |      Disconnect from websocket server\n |\n |      :return: Nothing\n |\n |  async reconnect(self)\n |      Restart the connection to the websocket server\n |\n |      :return: Nothing\n |\n |  register(self, func, event=None)\n |      Register a new hook in the websocket client\n |\n |      :param func: Callback function pointer for the hook\n |      :param event: Event (class from obswebsocket.events module) to trigger\n |          the hook on. Default is None, which means trigger on all events.\n |      :return: Nothing\n |\n |  async send(self, data: dict) -> dict\n |      Make a raw json call to the OBS server through the Websocket.\n |\n |      :param data: Request (python dict) to send to the server. Do not\n |          include field "message-id".\n |      :return: Response (python dict) from the server.\n |\n |  unregister(self, func, event=None)\n |      Unregister a new hook in the websocket client\n |\n |      :param func: Callback function pointer for the hook\n |      :param event: Event (class from obswebsocket.events module) which\n |          triggered the hook on. Default is None, which means unregister this\n |          function for all events.\n |      :return: Nothing\n |\n |  ----------------------------------------------------------------------\n |  Static methods defined here:\n |\n |  build_event(data)\n |\n |  ----------------------------------------------------------------------\n |  Data descriptors defined here:\n |\n |  __dict__\n |      dictionary for instance variables (if defined)\n |\n |  __weakref__\n |      list of weak references to the object (if defined)\n |\n |  ----------------------------------------------------------------------\n |  Data and other attributes defined here:\n |\n |  __abstractmethods__ = frozenset()\n |\n |  ----------------------------------------------------------------------\n |  Methods inherited from trio.abc.AsyncResource:\n |\n |  async __aenter__(self)\n |\n |  async __aexit__(self, *args)\n```\n\n',
    'author': 'Michael D. M. Dryden',
    'author_email': 'mk.dryden@utoronto.ca',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/mkdryden/obs-websocket-py-trio',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
