# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/wSAA.ipynb.

# %% auto 0
__all__ = ['RandomForestWSAA', 'SAA']

# %% ../nbs/wSAA.ipynb 5
import pandas as pd
import numpy as np

from sklearn.ensemble import RandomForestRegressor

from .core import BaseWeightsBasedPredictor, restructureWeightsDataList

# %% ../nbs/wSAA.ipynb 8
class RandomForestWSAA(RandomForestRegressor, BaseWeightsBasedPredictor):
        
    def fit(self, X, Y):

        super(RandomForestRegressor, self).fit(X = X, y = Y)
        
        self.Y = Y
        self.leafIndicesTrain = self.apply(X)
        
    #---
    
    def getWeightsData(self, X, outputType = 'onlyPositiveWeights', scalingList = None):
        
        leafIndicesDf = self.apply(X)
        
        weightsDataList = list()
        
        for leafIndices in leafIndicesDf:
            leafComparisonMatrix = (self.leafIndicesTrain == leafIndices) * 1
            nObsInSameLeaf = np.sum(leafComparisonMatrix, axis = 0)

            # It can happen that RF decides that the best strategy is to fit no tree at
            # all and simply average all results (happens when min_child_sample is too high, for example).
            # In this case 'leafComparisonMatrix' mustn't be averaged because there has been only a single tree.
            if len(leafComparisonMatrix.shape) == 1:
                weights = leafComparisonMatrix / nObsInSameLeaf
            else:
                weights = np.mean(leafComparisonMatrix / nObsInSameLeaf, axis = 1)
            
            weightsPosIndex = np.where(weights > 0)[0]
            
            weightsDataList.append((weights[weightsPosIndex], weightsPosIndex))
        
        #---
        
        weightsDataList = restructureWeightsDataList(weightsDataList = weightsDataList, 
                                                     outputType = outputType, 
                                                     Y = self.Y, 
                                                     scalingList = scalingList,
                                                     equalWeights = False)
        
        return weightsDataList
    
    #---
    
    def predict(self, X, probs = np.array([0.1, 0.5, 0.9]), outputAsDf = False, scalingList = None):
        
        quantileRes = super(BaseWeightsBasedPredictor, self).predict(X = X,
                                                                     probs = probs,
                                                                     outputAsDf = outputAsDf,
                                                                     scalingList = scalingList)
        
        return quantileRes
    
    #---
    
    def pointPredict(self, X):
        
        preds = super(RandomForestRegressor, self).predict(X)
        
        return preds
        

# %% ../nbs/wSAA.ipynb 10
class SAA(BaseWeightsBasedPredictor):
    
    def __init__(self):
        
        self.Y = None
    
    #---
    
    def fit(self, Y):
        self.Y = Y
        
    #---
    
    def getWeightsData(self, X = None, outputType = 'onlyPositiveWeights', scalingList = None):
        
        if X is None:
            neighborsList = [np.arange(len(self.Y))]
        else:
            neighborsList = [np.arange(len(self.Y)) for i in range(X.shape[0])]
        
        # weightsDataList is a list whose elements correspond to one test prediction each. 
        weightsDataList = [(np.repeat(1 / len(neighbors), len(neighbors)), np.array(neighbors)) for neighbors in neighborsList]

        weightsDataList = restructureWeightsDataList(weightsDataList = weightsDataList, 
                                                     outputType = outputType, 
                                                     Y = self.Y,
                                                     scalingList = scalingList,
                                                     equalWeights = True)
        
        return weightsDataList
    
