# -*- coding: utf-8 -*-
from __future__ import print_function, division

import sys
from panel_components.component import make_tag_function


component_tags = {
    "alert": "b-alert",
    "badge": "b-badge",
    "breadcrumb": "b-breadcrumb",
    "breadcrumb_item": "b-breadcrumb-item",
    "breadcrumb_link": "b-breadcrumb-link",
    "button": "b-button",
    "button_close": "b-button-close",
    "button_group": "b-button-group",
    "button_toolbar": "b-button-toolbar",
    "card": "b-card",
    "card_header": "b-card-header",
    "card_body": "b-card-body",
    "card_title": "b-card-title",
    "card_sub_title": "b-card-sub-title",
    "card_footer": "b-card-footer",
    "card_img": "b-card-img",
    "card_img_lazy": "b-card-img-lazy",
    "card_text": "b-card-text",
    "card_group": "b-card-group",
    "carousel": "b-carousel",
    "carousel_slide": "b-carousel-slide",
    "collapse": "b-collapse",
    "dropdown": "b-dropdown",
    "dropdown_item": "b-dropdown-item",
    "dropdown_item_button": "b-dropdown-item-button",
    "dropdown_header": "b-dropdown-header",
    "dropdown_divider": "b-dropdown-divider",
    "dropdown_form": "b-dropdown-form",
    "dropdown_text": "b-dropdown-text",
    "dropdown_group": "b-dropdown-group",
    "embed": "b-embed",
    "form": "b-form",
    "form_datalist": "b-form-datalist",
    "form_text": "b-form-text",
    "form_invalid_feedback": "b-form-invalid-feedback",
    "form_valid_feedback": "b-form-valid-feedback",
    "form_checkbox": "b-form-checkbox",
    "form_checkbox_group": "b-form-checkbox-group",
    "form_file": "b-form-file",
    "form_group": "b-form-group",
    "form_input": "b-form-input",
    "form_radio": "b-form-radio",
    "form_radio_group": "b-form-radio-group",
    "form_select": "b-form-select",
    "form_textarea": "b-form-textarea",
    "img": "b-img",
    "img_lazy": "b-img-lazy",
    "input_group": "b-input-group",
    "input_group_addon": "b-input-group-addon",
    "input_group_prepend": "b-input-group-prepend",
    "input_group_append": "b-input-group-append",
    "input_group_text": "b-input-group-text",
    "jumbotron": "b-jumbotron",
    "container": "b-container",
    "row": "b-row",
    "col": "b-col",
    "form_row": "b-form-row",
    "link": "b-link",
    "list_group": "b-list-group",
    "list_group_item": "b-list-group-item",
    "media": "b-media",
    "media_aside": "b-media-aside",
    "media_body": "b-media-body",
    "modal": "b-modal",
    "nav": "b-nav",
    "nav_item": "b-nav-item",
    "nav_text": "b-nav-text",
    "nav_form": "b-nav-form",
    "nav_item_dropdown": "b-nav-item-dropdown",
    "navbar": "b-navbar",
    "navbar_nav": "b-navbar-nav",
    "navbar_brand": "b-navbar-brand",
    "navbar_toggle": "b-navbar-toggle",
    "pagination": "b-pagination",
    "pagination_nav": "b-pagination-nav",
    "popover": "b-popover",
    "progress": "b-progress",
    "progress_bar": "b-progress-bar",
    "spinner": "b-spinner",
    "table": "b-table",
    "table_lite": "b-table-lite",
    "table_simple": "b-table-simple",
    "tbody": "b-tbody",
    "thead": "b-thead",
    "tfoot": "b-tfoot",
    "tr": "b-tr",
    "td": "b-td",
    "th": "b-th",
    "tabs": "b-tabs",
    "tab": "b-tab",
    "toast": "b-toast",
    "toaster": "b-toaster",
    "tooltip": "b-tooltip",
}

# Create a module-level function for each bootstrap-vue component tag
module = sys.modules[__name__]
for tag in component_tags:
    setattr(module, tag, make_tag_function(component_tags[tag]))

__all__ = list()
