# Copyright (c) 2018 ISP RAS (http://www.ispras.ru)
# Ivannikov Institute for System Programming of the Russian Academy of Sciences
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from clade.extensions.common import Common


class Objcopy(Common):
    __version__ = "1"

    def parse(self, cmds_file):
        super().parse(cmds_file, self.conf.get("Objcopy.which_list", []))

    def parse_cmd(self, cmd):
        parsed_cmd = super().parse_cmd(cmd, self.name)

        # objcopy has only one input file and no more than one output file.
        # out file is the same as in file if it didn't specified.
        if len(parsed_cmd["in"]) == 2:
            parsed_cmd["out"] = [parsed_cmd["in"].pop()]
        elif len(parsed_cmd["in"]) < 2:
            parsed_cmd["out"] = parsed_cmd["in"]

        if self.is_bad(parsed_cmd):
            self.dump_bad_cmd_id(parsed_cmd["id"])
            return

        self.dump_cmd_by_id(cmd["id"], parsed_cmd)
