# Examples

Below is a showcase of various examples of unit testing real and sample Algorand Python smart contracts using `algorand-python-testing`.

| Contract Name       | Test File                                                                                                                                 | Key Features Demonstrated                                                                                                                                                                                        | Test versions of Algopy Abstractions used                                                           |
| ------------------- | ----------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------- |
| Auction             | [test_contract.py](https://github.com/algorandfoundation/algorand-python-testing/blob/main/examples/auction/test_contract.py)             | - Use of algopy_testing_context<br>- Mocking of global state and transaction fields<br>- Testing of ARC4 contract methods<br>- Emulation of asset creation and transfers<br>- Verification of inner transactions | - **ARC4Contract**<br>- **Global**<br>- **Txn**<br>- **Asset**<br>- **Account**<br>- **LocalState** |
| Proof of Attendance | [test_contract.py](https://github.com/algorandfoundation/algorand-python-testing/blob/main/examples/proof_of_attendance/test_contract.py) | - Creation and management of dummy assets<br>- Testing of box storage operations<br>- Verification of inner transactions for asset transfers<br>- Use of `any.*` methods for generating test data                | - **ARC4Contract**<br>- **Box**<br>- **BoxMap**<br>- **Asset**<br>- **Account**<br>- **op**         |
| Simple Voting       | [test_contract.py](https://github.com/algorandfoundation/algorand-python-testing/blob/main/examples/simple_voting/test_contract.py)       | - Testing of global and local state operations<br>- Verification of transaction group operations<br>- Mocking of payment transactions                                                                            | - **Contract**<br>- **GlobalState**<br>- **LocalState**<br>- **Txn**<br>- **op.GTxn**               |
| ZK Whitelist        | [test_contract.py](https://github.com/algorandfoundation/algorand-python-testing/blob/main/examples/zk_whitelist/test_contract.py)        | - Testing of zero-knowledge proof verification<br>- Mocking of external application calls<br>- Use of ARC4 types and methods                                                                                     | - **ARC4Contract**<br>- **ARC4 types**<br>- **LocalState**<br>- **Global**<br>- **Txn**             |
| HTLC LogicSig       | [test_signature.py](https://github.com/algorandfoundation/algorand-python-testing/blob/main/examples/htlc_logicsig/test_signature.py)     | - Testing of LogicSig contracts<br>- Verification of time-based conditions<br>- Mocking of transaction parameters                                                                                                | - **logicsig**<br>- **Account**<br>- **Txn**<br>- **Global**<br>- **op**                            |
| Marketplace         | [test_contract.py](https://github.com/algorandfoundation/algorand-python-testing/blob/main/examples/marketplace/test_contract.py)         | - Testing of complex marketplace operations<br>- Use of BoxMap for listings<br>- Testing of asset transfers and payments                                                                                         | - **ARC4Contract**<br>- **BoxMap**<br>- **Asset**<br>- **ARC4 types**<br>- **Global**<br>- **Txn**  |
| Scratch Storage     | [test_contract.py](https://github.com/algorandfoundation/algorand-python-testing/blob/main/examples/scratch_storage/test_contract.py)     | - Testing of scratch space usage<br>- Verification of scratch slot values                                                                                                                                        | - **ARC4Contract**<br>- **Contract**<br>- **op**                                                    |
