/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.jpmml.lightgbm.GBDT;
import org.jpmml.lightgbm.LightGBMUtil;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--lgbm-input"}, description="LightGBM text input file", required=true)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    @Parameter(names={"--target-name"}, description="Target name. Defaults to \"_target\"")
    private String targetName = null;
    @Parameter(names={"--target-categories"}, description="Target categories. Defaults to 0-based index [0, 1, .., num_class - 1]")
    private List<String> targetCategories = null;
    @Parameter(names={"--X-compact"}, description="Transform LightGBM-style trees to PMML-style trees", arity=1)
    private boolean compact = true;
    @Parameter(names={"--X-nan_as_missing"}, description="Treat Not-a-Number (NaN) values as missing values", arity=1)
    private boolean nanAsMissing = true;
    @Parameter(names={"--X-num_iteration"}, description="Limit the number of trees. Defaults to all trees")
    private Integer numIteration = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        PMML pmml;
        long end;
        GBDT gbdt;
        long begin;
        try (FileInputStream is = new FileInputStream(this.input);){
            logger.info("Loading GBDT..");
            begin = System.currentTimeMillis();
            gbdt = LightGBMUtil.loadGBDT(is);
            end = System.currentTimeMillis();
            logger.info("Loaded GBDT in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to load GBDT", (Throwable)e);
            throw e;
        }
        LinkedHashMap<String, Comparable<Boolean>> options = new LinkedHashMap<String, Comparable<Boolean>>();
        options.put("compact", Boolean.valueOf(this.compact));
        options.put("nan_as_missing", Boolean.valueOf(this.nanAsMissing));
        options.put("num_iteration", this.numIteration);
        try {
            logger.info("Converting GBDT to PMML..");
            begin = System.currentTimeMillis();
            pmml = gbdt.encodePMML(options, this.targetName != null ? FieldName.create((String)this.targetName) : null, this.targetCategories);
            end = System.currentTimeMillis();
            logger.info("Converted GBDT to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert GBDT to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            long begin2 = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            long end2 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end2 - begin2));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }
}

