/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing.scipy;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import scipy.interpolate.BSpline;
import sklearn.Transformer;

public class BSplineTransformer
extends Transformer {
    public BSplineTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        BSpline bspline = this.getBSpline();
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        DefineFunction defineFunction = BSplineTransformer.createBSplineFunction(bspline, encoder);
        Apply apply = PMMLUtil.createApply((String)defineFunction.getName(), (Expression[])new Expression[]{continuousFeature.ref()});
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("bspline", continuousFeature), (Expression)apply);
        return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public BSpline getBSpline() {
        return (BSpline)this.get("bspline", BSpline.class);
    }

    private static DefineFunction createBSplineFunction(BSpline bspline, SkLearnEncoder encoder) {
        int k = bspline.getK();
        List c = bspline.getC();
        List t = bspline.getT();
        int n = t.size() - k - 1;
        ParameterField valueField = new ParameterField().setName(FieldName.create((String)"x")).setOpType(OpType.CONTINUOUS).setDataType(DataType.DOUBLE);
        Apply sumApply = PMMLUtil.createApply((String)"sum", (Expression[])new Expression[0]);
        for (int i = 0; i < n; ++i) {
            for (int j = k; j >= 0; --j) {
                BSplineTransformer.createBFunction(t, i, j, encoder);
            }
            Apply apply = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)((Number)c.get(i))), PMMLUtil.createApply((String)BSplineTransformer.formatBFunction(i, k), (Expression[])new Expression[]{new FieldRef(valueField.getName())})});
            sumApply.addExpressions(new Expression[]{apply});
        }
        DefineFunction defineFunction = new DefineFunction(BSplineTransformer.formatBSplineFunction(k), OpType.CONTINUOUS, DataType.DOUBLE, null, (Expression)sumApply).addParameterFields(new ParameterField[]{valueField});
        encoder.addDefineFunction(defineFunction);
        return defineFunction;
    }

    private static DefineFunction createBFunction(List<Number> t, int i, int k, SkLearnEncoder encoder) {
        Object expression;
        ParameterField valueField = new ParameterField().setName(FieldName.create((String)"x")).setOpType(OpType.CONTINUOUS).setDataType(DataType.DOUBLE);
        if (k == 0) {
            expression = !t.get(i).equals(t.get(i + 1)) ? PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"and", (Expression[])new Expression[]{PMMLUtil.createApply((String)"greaterOrEqual", (Expression[])new Expression[]{new FieldRef(valueField.getName()), PMMLUtil.createConstant((Number)t.get(i))}), PMMLUtil.createApply((String)"lessThan", (Expression[])new Expression[]{new FieldRef(valueField.getName()), PMMLUtil.createConstant((Number)t.get(i + 1))})}), PMMLUtil.createConstant((Number)1.0), PMMLUtil.createConstant((Number)0.0)}) : PMMLUtil.createConstant((Number)0.0);
        } else {
            Apply apply;
            ArrayList<Apply> expressions = new ArrayList<Apply>(2);
            if (!t.get(i + k).equals(t.get(i))) {
                apply = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{new FieldRef(valueField.getName()), PMMLUtil.createConstant((Number)t.get(i))}), PMMLUtil.createConstant((Number)(t.get(i + k).doubleValue() - t.get(i).doubleValue()))});
                apply = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{apply, PMMLUtil.createApply((String)BSplineTransformer.formatBFunction(i, k - 1), (Expression[])new Expression[]{new FieldRef(valueField.getName())})});
                expressions.add(apply);
            }
            if (!t.get(i + k + 1).equals(t.get(i + 1))) {
                apply = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)t.get(i + k + 1)), new FieldRef(valueField.getName())}), PMMLUtil.createConstant((Number)(t.get(i + k + 1).doubleValue() - t.get(i + 1).doubleValue()))});
                apply = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{apply, PMMLUtil.createApply((String)BSplineTransformer.formatBFunction(i + 1, k - 1), (Expression[])new Expression[]{new FieldRef(valueField.getName())})});
                expressions.add(apply);
            }
            expression = expressions.size() == 2 ? PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{(Expression)expressions.get(0), (Expression)expressions.get(1)}) : (expressions.size() == 1 ? (Expression)Iterables.getOnlyElement(expressions) : PMMLUtil.createConstant((Number)0.0));
        }
        DefineFunction defineFunction = new DefineFunction(BSplineTransformer.formatBFunction(i, k), OpType.CONTINUOUS, DataType.DOUBLE, null, (Expression)expression).addParameterFields(new ParameterField[]{valueField});
        encoder.addDefineFunction(defineFunction);
        return defineFunction;
    }

    private static String formatBSplineFunction(int k) {
        return "scipy.interpolate.BSpline(" + k + ")";
    }

    private static String formatBFunction(int i, int k) {
        return "scipy.interpolate.B(" + i + ", " + k + ")";
    }
}

