/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.postprocessing;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Decision;
import org.dmg.pmml.Decisions;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn2pmml.preprocessing.ExpressionTransformer;

public class BusinessDecisionTransformer
extends ExpressionTransformer {
    public BusinessDecisionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    protected DerivedField encodeDerivedField(FieldName name, OpType opType, DataType dataType, Expression expression, SkLearnEncoder encoder) {
        String businessProblem = this.getBusinessProblem();
        List<Object[]> decisions = this.getDecisions();
        Model model = encoder.getModel();
        if (model == null) {
            throw new IllegalArgumentException("Model is undefined");
        }
        switch (opType) {
            case CONTINUOUS: {
                opType = OpType.CATEGORICAL;
                break;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
        }
        Decisions pmmlDecisions = new Decisions().setBusinessProblem(businessProblem);
        for (Object[] decision : decisions) {
            Decision pmmlDecision = new Decision().setValue((String)TupleUtil.extractElement((Object[])decision, (int)0, String.class)).setDescription((String)TupleUtil.extractElement((Object[])decision, (int)1, String.class));
            pmmlDecisions.addDecisions(new Decision[]{pmmlDecision});
        }
        OutputField outputField = new OutputField(name, opType, dataType).setResultFeature(ResultFeature.DECISION).setFinalResult(Boolean.valueOf(true)).setExpression(expression).setDecisions(pmmlDecisions);
        return encoder.createDerivedField(model, outputField, true);
    }

    public String getBusinessProblem() {
        return this.getString("business_problem");
    }

    public List<Object[]> getDecisions() {
        return this.getTupleList("decisions");
    }

    @Override
    public String getExpr() {
        return this.getString("expr");
    }
}

