/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.False;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;

public class TreeModelPruner
extends AbstractTreeModelTransformer {
    private MiningFunction miningFunction = null;

    @Override
    public void enterNode(Node node) {
        Object defaultChild = node.getDefaultChild();
        if (node.hasNodes()) {
            List children = node.getNodes();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Predicate predicate;
                Node child = (Node)it.next();
                if (defaultChild != null && TreeModelPruner.equalsNode(defaultChild, child) || !((predicate = child.getPredicate()) instanceof False)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void exitNode(Node node) {
        List children;
        Object defaultChild = node.getDefaultChild();
        Predicate predicate = node.getPredicate();
        Number recordCount = node.getRecordCount();
        if (node.hasNodes() && (children = node.getNodes()).size() == 1) {
            Node child = (Node)children.get(0);
            Predicate childPredicate = child.getPredicate();
            Number childRecordCount = child.getRecordCount();
            if (Objects.equals(predicate, childPredicate) && Objects.equals(recordCount, childRecordCount)) {
                if (defaultChild != null) {
                    node.setDefaultChild(null);
                }
                if (MiningFunction.REGRESSION.equals((Object)this.miningFunction)) {
                    TreeModelPruner.initScore(node, child);
                } else if (MiningFunction.CLASSIFICATION.equals((Object)this.miningFunction)) {
                    TreeModelPruner.initScoreDistribution(node, child);
                } else {
                    throw new IllegalArgumentException();
                }
                TreeModelPruner.initDefaultChild(node, child);
                TreeModelPruner.replaceChildWithGrandchildren(node, child);
            }
        }
    }

    @Override
    public void enterTreeModel(TreeModel treeModel) {
        this.miningFunction = treeModel.getMiningFunction();
    }

    @Override
    public void exitTreeModel(TreeModel treeModel) {
        this.miningFunction = null;
    }
}

