/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.transformations;

import java.util.Objects;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.transformations.AbstractTransformation;

public class SigmoidTransformation
extends AbstractTransformation {
    private Number multiplier = null;

    public SigmoidTransformation(Number multiplier) {
        this.setMultiplier(multiplier);
    }

    @Override
    public FieldName getName(FieldName name) {
        return FieldNameUtil.create("sigmoid", name);
    }

    @Override
    public Expression createExpression(FieldRef fieldRef) {
        return SigmoidTransformation.createExpression(this.getMultiplier(), fieldRef);
    }

    public Number getMultiplier() {
        return this.multiplier;
    }

    private void setMultiplier(Number multiplier) {
        this.multiplier = Objects.requireNonNull(multiplier);
    }

    public static Expression createExpression(Number multiplier, FieldRef fieldRef) {
        Number one;
        if (multiplier instanceof Float) {
            one = Float.valueOf(1.0f);
        } else if (multiplier instanceof Double) {
            one = 1.0;
        } else {
            throw new IllegalArgumentException();
        }
        return PMMLUtil.createApply("/", new Expression[]{PMMLUtil.createConstant(one), PMMLUtil.createApply("+", new Expression[]{PMMLUtil.createConstant(one), PMMLUtil.createApply("exp", new Expression[]{PMMLUtil.createApply("*", new Expression[]{PMMLUtil.createConstant(multiplier), fieldRef})})})});
    }
}

