/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.dmg.pmml.Application;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.ComplexArray;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.Header;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.Row;
import org.dmg.pmml.Timestamp;
import org.dmg.pmml.Value;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.model.inlinetable.InputCell;
import org.jpmml.model.inlinetable.OutputCell;

public class PMMLUtil {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private PMMLUtil() {
    }

    public static Extension createExtension(String name, String value) {
        Extension extension = new Extension().setName(name).setValue(value);
        return extension;
    }

    public static Extension createExtension(String name, Object ... content) {
        Extension extension = new Extension().setName(name).addContent(content);
        return extension;
    }

    public static Header createHeader(Class<?> clazz) {
        Package _package = clazz.getPackage();
        return PMMLUtil.createHeader(_package.getImplementationTitle(), _package.getImplementationVersion());
    }

    public static Header createHeader(String name, String version) {
        Application application = new Application().setName(name).setVersion(version);
        return PMMLUtil.createHeader(application);
    }

    public static Header createHeader(Application application) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(UTC);
        Timestamp timestamp = new Timestamp().addContent(new Object[]{dateFormat.format(now)});
        Header header = new Header().setApplication(application).setTimestamp(timestamp);
        return header;
    }

    public static <F extends Field<F>> List<?> getValues(F field) {
        return PMMLUtil.getValues(field, null);
    }

    public static <F extends Field<F>> List<?> getValues(F field, Value.Property property) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (property == null) {
            property = Value.Property.VALID;
        }
        List pmmlValues = ((HasDiscreteDomain)field).getValues();
        for (Value pmmlValue : pmmlValues) {
            if (!property.equals((Object)pmmlValue.getProperty())) continue;
            result.add(pmmlValue.getValue());
        }
        return result;
    }

    public static <F extends Field<F>> void addValues(F field, List<?> values) {
        PMMLUtil.addValues(field, null, values);
    }

    public static <F extends Field<F>> void addValues(F field, Value.Property property, List<?> values) {
        if (Value.Property.VALID.equals((Object)property)) {
            property = null;
        }
        List pmmlValues = ((HasDiscreteDomain)field).getValues();
        for (Object value : values) {
            Value pmmlValue = new Value(value).setProperty(property);
            pmmlValues.add(pmmlValue);
        }
    }

    public static Apply createApply(String function, Expression ... expressions) {
        Apply apply = new Apply(function).addExpressions(expressions);
        return apply;
    }

    public static Constant createMissingConstant() {
        return PMMLUtil.createConstant(null, null);
    }

    public static Constant createConstant(Number value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return PMMLUtil.createConstant(value, TypeUtil.getDataType(value));
    }

    public static Constant createConstant(Object value, DataType dataType) {
        Constant constant = new Constant(value).setDataType(dataType).setMissing(Boolean.valueOf(value == null));
        return constant;
    }

    public static MapValues createMapValues(FieldName name, Map<?, ?> mapping) {
        ArrayList inputValues = new ArrayList();
        ArrayList outputValues = new ArrayList();
        Set<Map.Entry<?, ?>> entries = mapping.entrySet();
        for (Map.Entry entry : entries) {
            inputValues.add(entry.getKey());
            outputValues.add(entry.getValue());
        }
        return PMMLUtil.createMapValues(name, inputValues, outputValues);
    }

    public static MapValues createMapValues(FieldName name, List<?> inputValues, List<?> outputValues) {
        String inputColumn = "data:input";
        String outputColumn = "data:output";
        LinkedHashMap data = new LinkedHashMap();
        data.put(inputColumn, inputValues);
        data.put(outputColumn, outputValues);
        MapValues mapValues = new MapValues(outputColumn, null, PMMLUtil.createInlineTable(data)).addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(name, inputColumn)});
        return mapValues;
    }

    public static Expression toNegative(Expression expression) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            Object value = constant.getValue();
            if (value instanceof Long) {
                value = -((Long)value).longValue();
            } else if (value instanceof Integer) {
                value = -((Integer)value).intValue();
            } else if (value instanceof Float) {
                value = Float.valueOf(-((Float)value).floatValue());
            } else if (value instanceof Double) {
                value = -((Double)value).doubleValue();
            } else {
                String string = ValueUtil.asString(value);
                string = string.startsWith("-") ? string.substring(1) : "-" + string;
                value = string;
            }
            constant.setValue(value);
            return constant;
        }
        return PMMLUtil.createApply("*", new Expression[]{PMMLUtil.createConstant(-1), expression});
    }

    public static Array createStringArray(List<?> values) {
        ComplexArray array = new ComplexArray().setType(Array.Type.STRING).setValue(values);
        return array;
    }

    public static Array createIntArray(List<Integer> values) {
        ComplexArray array = new ComplexArray().setType(Array.Type.INT).setValue(values);
        return array;
    }

    public static Array createRealArray(List<? extends Number> values) {
        ComplexArray array = new ComplexArray().setType(Array.Type.REAL).setValue(values);
        return array;
    }

    public static RealSparseArray createRealSparseArray(List<? extends Number> values, Double defaultValue) {
        RealSparseArray sparseArray = new RealSparseArray().setN(Integer.valueOf(values.size())).setDefaultValue(defaultValue);
        List indices = sparseArray.getIndices();
        List entries = sparseArray.getEntries();
        int index = 1;
        for (Number number : values) {
            if (!ValueUtil.equals(number, defaultValue)) {
                indices.add(index);
                entries.add(ValueUtil.asDouble(number));
            }
            ++index;
        }
        return sparseArray;
    }

    public static InlineTable createInlineTable(Map<String, ? extends List<?>> data) {
        return PMMLUtil.createInlineTable(Function.identity(), data);
    }

    public static <K> InlineTable createInlineTable(Function<K, String> function, Map<K, ? extends List<?>> data) {
        int rows = 0;
        LinkedHashMap columns = new LinkedHashMap();
        Set<Map.Entry<K, List<?>>> entries = data.entrySet();
        for (Map.Entry entry : entries) {
            QName columnName;
            Object column = entry.getKey();
            List columnData = (List)entry.getValue();
            if (rows == 0) {
                rows = columnData.size();
            } else if (rows != columnData.size()) {
                throw new IllegalArgumentException();
            }
            String tagName = function.apply(column);
            if (tagName.startsWith("data:")) {
                columnName = new QName("http://jpmml.org/jpmml-model/InlineTable", tagName.substring("data:".length()), "data");
            } else {
                if (tagName.indexOf(58) > -1) {
                    throw new IllegalArgumentException(tagName);
                }
                columnName = new QName(PMMLEncoder.VERSION.getNamespaceURI(), tagName);
            }
            columns.put(column, columnName);
        }
        QName inputColumnName = InputCell.QNAME;
        QName outputColumnName = OutputCell.QNAME;
        InlineTable inlineTable = new InlineTable();
        for (int i = 0; i < rows; ++i) {
            Row row = new Row();
            Set entries2 = columns.entrySet();
            for (Map.Entry entry : entries2) {
                List<?> columnData = data.get(entry.getKey());
                Object value = columnData.get(i);
                if (value == null) continue;
                QName columName = (QName)entry.getValue();
                Object cell = inputColumnName.equals(columName) ? new InputCell(value) : (outputColumnName.equals(columName) ? new OutputCell(value) : new JAXBElement(columName, String.class, (Object)ValueUtil.asString(value)));
                row.addContent(new Object[]{cell});
            }
            inlineTable.addRows(new Row[]{row});
        }
        return inlineTable;
    }
}

