# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dragonpy',
 'dragonpy.CoCo',
 'dragonpy.Dragon32',
 'dragonpy.Dragon64',
 'dragonpy.Multicomp6809',
 'dragonpy.Simple6809',
 'dragonpy.components',
 'dragonpy.core',
 'dragonpy.sbc09',
 'dragonpy.tests',
 'dragonpy.utils',
 'dragonpy.vectrex']

package_data = \
{'': ['*']}

install_requires = \
['MC6809', 'click>=7.0,<8.0', 'dragonlib', 'pygments>=2.5.2,<3.0.0']

entry_points = \
{'console_scripts': ['DragonPy = dragonpy.core.cli:main',
                     'publish = dragonpy.publish:publish',
                     'update_rst_readme = dragonpy.publish:update_readme']}

setup_kwargs = {
    'name': 'dragonpyemulator',
    'version': '0.7.0',
    'description': 'Emulator for 6809 CPU based system like Dragon 32 / CoCo written in Python...',
    'long_description': '--------------------------------------\nDragon/CoCO emulator written in Python\n--------------------------------------\n\nDragonPy is a Open source (GPL v3 or later) emulator for the 30 years old homecomputer ``Dragon 32`` and ``Tandy TRS-80 Color Computer`` (CoCo)...\n\nThe `MC6809 <https://github.com/6809/MC6809>`_ project is used to emulate the 6809 CPU.\n\n+--------------------------------------+----------------------------------------------------+\n| |Build Status on travis-ci.org|      | `travis-ci.org/jedie/DragonPy`_                    |\n+--------------------------------------+----------------------------------------------------+\n| |Coverage Status on coveralls.io|    | `coveralls.io/r/jedie/DragonPy`_                   |\n+--------------------------------------+----------------------------------------------------+\n| |Requirements Status on requires.io| | `requires.io/github/jedie/DragonPy/requirements/`_ |\n+--------------------------------------+----------------------------------------------------+\n\n.. |Build Status on travis-ci.org| image:: https://travis-ci.org/jedie/DragonPy.svg?branch=master\n.. _travis-ci.org/jedie/DragonPy: https://travis-ci.org/jedie/DragonPy/\n.. |Coverage Status on coveralls.io| image:: https://coveralls.io/repos/jedie/DragonPy/badge.svg\n.. _coveralls.io/r/jedie/DragonPy: https://coveralls.io/r/jedie/DragonPy\n.. |Requirements Status on requires.io| image:: https://requires.io/github/jedie/DragonPy/requirements.svg?branch=master\n.. _requires.io/github/jedie/DragonPy/requirements/: https://requires.io/github/jedie/DragonPy/requirements/\n\nDragon 32 with CPython 3 under Linux:\n\n|screenshot Dragon 32|\n\n.. |screenshot Dragon 32| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20150820_DragonPy_Dragon32_CPython3_Linux_01.png\n\nTandy TRS-80 Color Computer 2b with CPython 2 under Windows:\n\n|screenshot CoCo under Windows|\n\n.. |screenshot CoCo under Windows| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20150820_DragonPy_CoCo2b_CPython2_Win_01.png\n\n(Note: Python 2 support was removed)\n\nDragonPy is written in Python.\nIt\'s platform independent and runs with Python and PyPy under Linux/Windows/OSX/...\nIt\'s tested with Python 3.x, PyPy\n\nDragonPy will not be a second XRoar written in Python.\nThis project is primarily to lean and understand.\n\nFuture goals are:\n\n* Implement a integrated development environment for BASIC programs\n\nA full featured Dragon / CoCo emulator is `XRoar <http://www.6809.org.uk/dragon/xroar.shtml>`_.\n\nCurrent state\n=============\n\nThe Dragon 32 / 64 and CoCo ROMs works in Text mode.\nAlso the "single board computer" ROMs sbc09, Simple6809 and Multicomp6809 works well.\n\nThere is a rudimentary BASIC editor with save/load BASIC programm listings direct into RAM.\n\nLooks like this:\n\n|old screenshot BASIC Editor|\n(older version of the editor)\n\n.. |old screenshot BASIC Editor| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140820_DragonPy_BASIC_Editor_01.png\n\nVectrex\n-------\n\nThe `Vectrex (Wikipedia) <https://en.wikipedia.org/wiki/Vectrex>`_ is a vector display-based video game console.\nThe Hardware are *only* the 6809 CPU, a 6522 Versatile Interface Adapter and the AY-3-8912 sound chip.\n\nCurrent state is completely not usable. The 6522 is only a dummy implementation.\nIt makes only sense to display some trace lines, e.g.:\n\n::\n\n    .../DragonPy$ poetry run DragonPy --verbosity 0 --machine=Vectrex run --trace --max_ops=1\n\nBASIC Editor\n============\n\nUse "BASIC editor / open" in the main menu to open the editor.\n\nYou can load/save ASCII .bas files from you local drive or just type a BASIC listing ;)\nWith "inject into DragonPy" you send the current listing from the Editor to the Emulator and with "load from DragonPy" back from emulator to editor.\nNote: The is currently no "warning" that un-saved content will be "overwritten" and there is no "auto-backup" ;)\n\nThe "renumbering" tool can be found in the editor window under "tools"\n\nYou can also run the BASIC Editor without the Emulator:\n\n::\n\n    .../DragonPy$ make editor\n    # or:\n    .../DragonPy$ poetry run DragonPy editor\n\nA rudimentary BASIC source code highlighting is available and looks like this:\n\n|screenshot BASIC Editor|\n\n.. |screenshot BASIC Editor| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140826_DragonPy_BASIC_Editor_01.png\n\nSpecial feature: The Line number that are used in GOTO, SOGUB etc. are extra marked on the left side.\n\n------------\ninstallation\n------------\n\nIMPORTANT: The **PyPi package** name is **DragonPyEmulator** and `not only "DragonPy" <https://github.com/jpanganiban/dragonpy/issues/3>`_!!!\n\n::\n\n    pip install DragonPyEmulator\n\nfrom source\n===========\n\n::\n\n    ~$ git clone https://github.com/jedie/DragonPy.git\n    ~$ cd DragonPy/\n    ~/DragonPy$ make\n    help                 List all commands\n    install-poetry       install or update poetry\n    install              install DragonPy via poetry\n    update               Update the dependencies as according to the pyproject.toml file\n    lint                 Run code formatters and linter\n    fix-code-style       Fix code formatting\n    tox-listenvs         List all tox test environments\n    tox                  Run pytest via tox with all environments\n    tox-py36             Run pytest via tox with *python v3.6*\n    tox-py37             Run pytest via tox with *python v3.7*\n    tox-py38             Run pytest via tox with *python v3.8*\n    pytest               Run pytest\n    update-rst-readme    update README.rst from README.creole\n    publish              Release new version to PyPi\n    download-roms        Download/Test only ROM files\n    profile              Profile the MC6809 emulation benchmark\n    benchmark            Run MC6809 emulation benchmark\n    editor               Run only the BASIC editor\n    Vectrex              Run GUI with Vectrex emulation (not working, yet!)\n    sbc09                Run GUI with sbc09 ROM emulation\n    Multicomp6809        Run GUI with Multicomp6809 ROM emulation\n    Simple6809           Run GUI with Simple6809 ROM emulation\n    CoCo2b               Run GUI with CoCo 2b emulation\n    Dragon32             Run GUI with Dragon 32 emulation\n    Dragon64             Run GUI with Dragon 64 emulation\n    run                  *Run the DragonPy Emulator GUI*\n    \n    ~/DragonPy$ make install-poetry\n    ~/DragonPy$ make install\n    ~/DragonPy$ make run\n    \n    # use the CLI:\n    ~/DragonPy$ poetry run DragonPy --help\n    ~/DragonPy$ poetry run DragonPy\n\ninstall in virtualenv by foot:\n==============================\n\ne.g.:\n\n::\n\n    # Create virtualenv:\n    .../$ python3 -Im venv DragonPy\n    \n    # activate created virtualenv:\n    .../$ cd DragonPy\n    .../DragonPy$ source bin/activate\n    \n    # update pip before install:\n    (DragonPy) .../DragonPy$ pip install -U pip\n    ...\n    \n    # Install DragonPy:\n    (DragonPy) .../DragonPy$ pip install DragonPyEmulator\n    Collecting DragonPyEmulator\n    ...\n    Installing collected packages: click, six, dragonlib, pygments, MC6809, DragonPyEmulator\n    Successfully installed DragonPyEmulator-0.5.3 MC6809-0.5.0 click-6.7 dragonlib-0.1.7 pygments-2.2.0 six-1.11.0\n    \n    # start Emulator\n    (DragonPy) .../DragonPy$ DragonPy\n\nWindows\n=======\n\nThere are several ways to install the project under windows.\n\nThe following is hopeful the easiest one:\n\n* Install Python 3, e.g.: `https://www.python.org/downloads/ <https://www.python.org/downloads/>`_\n\n* Download the ``DragonPy`` git snapshot from Github: `master.zip <https://github.com/jedie/DragonPy/archive/master.zip>`_\n\n* Extract the Archive somewhere\n\n* Maybe, adjust paths in ``boot_dragonpy.cmd``\n\n* Run ``boot_dragonpy.cmd``\n\nThe default ``boot_dragonpy.cmd`` will install via ``Python Package Index`` (PyPi) into ``%APPDATA%\\DragonPy_env``\n\nstart DragonPy\n--------------\n\nThe is a simple "starter GUI", just call the cli without arguments:\n\n``%APPDATA%\\DragonPy_env\\Scripts\\DragonPy.exe``\n\nIt looks like this:\n\n|starter GUI|\n\n.. |starter GUI| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20150821_DragonPy_starterGUI.png\n\n----\nROMs\n----\n\nAll needed ROM files, will be downloaded automatically.\n\nThe files will be downloaded from:\n\n+----------------+------------------------------------------------------------------------------------------------------------------+\n| Dragon 32 + 64 | `http://archive.worldofdragon.org/archive/index.php?dir=Software/Dragon/Dragon%20Data%20Ltd/Dragon%20Firmware/`_ |\n+----------------+------------------------------------------------------------------------------------------------------------------+\n| CoCo 2b        | `http://www.roust-it.dk/coco/roms/`_                                                                             |\n+----------------+------------------------------------------------------------------------------------------------------------------+\n| Multicomp      | `http://searle.x10host.com/Multicomp/index.html`_                                                                |\n+----------------+------------------------------------------------------------------------------------------------------------------+\n| Simple6809     | `http://searle.x10host.com/6809/Simple6809.html`_                                                                |\n+----------------+------------------------------------------------------------------------------------------------------------------+\n\n.. _http://archive.worldofdragon.org/archive/index.php?dir=Software/Dragon/Dragon%20Data%20Ltd/Dragon%20Firmware/: http://archive.worldofdragon.org/archive/index.php?dir=Software/Dragon/Dragon%20Data%20Ltd/Dragon%20Firmware/\n.. _http://www.roust-it.dk/coco/roms/: http://www.roust-it.dk/coco/roms/\n.. _http://searle.x10host.com/Multicomp/index.html: http://searle.x10host.com/Multicomp/index.html\n.. _http://searle.x10host.com/6809/Simple6809.html: http://searle.x10host.com/6809/Simple6809.html\n\nsbc09 and vectrex ROMs are included.\n\nAll ROM files and download will be checked by SHA1 value, before use.\n\n---------\nrun tests\n---------\n\nYou can run tests with PyPy, Python 2 and Python 3:\n\n::\n\n    ~/DragonPy$ make pytest\n    # or:\n    ~/DragonPy$ make tox\n    # or:\n    ~/DragonPy$ poetry run pytest\n\n----------------\nmore screenshots\n----------------\n\n"sbc09" ROM in Tkinter window:\n\n|screenshot sbc09|\n\n.. |screenshot sbc09| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/DragonPy_sbc09_01.png\n\n"Simple6809" ROM in Tkinter window:\n\n|screenshot simple6809|\n\n.. |screenshot simple6809| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/Simple6809_TK_04.PNG\n\nDragon Keyboard\n===============\n\nThe keyboard mapping is stored into `dragonpy/Dragon32/keyboard_map.py <https://github.com/jedie/DragonPy/blob/master/dragonpy/Dragon32/keyboard_map.py>`_.\n\nSome notes:\n\n* "CLEAR" is mapped to "Home" / "Pos 1" key\n\n* "BREAK" is mapped to "Escape" button\n\n* "LEFT" is mapped to left cursor key and to normal backspace, too.\n\nA "auto shift" mode is implemented. So normal lowercase letters would be automaticly converted to uppercase letters.\n\npaste clipboard\n---------------\n\nIt is possible to paste the content of the clipboard as user input in the machine.\nJust copy (Ctrl-C) the follow content:\n\n::\n\n    10 CLS\n    20 FOR I = 0 TO 255:\n    30 POKE 1024+(I*2),I\n    40 NEXT I\n    50 I$ = INKEY$:IF I$="" THEN 50\n\nFocus the DragonPy window and use Ctrl-V to paste the content.\n\nLooks like:\n\n|https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140805_DragonPy_Dragon32_Listing.png|\n\n.. |https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140805_DragonPy_Dragon32_Listing.png| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140805_DragonPy_Dragon32_Listing.png\n\nThen just **RUN** and then it looks like this:\n\n|https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140805_DragonPy_Dragon32_CharMap.png|\n\n.. |https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140805_DragonPy_Dragon32_CharMap.png| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/20140805_DragonPy_Dragon32_CharMap.png\n\nDragonPy schematic\n==================\n\n::\n\n    +------------------+                         +---------------------+\n    |                  |                         |                     |\n    | +-------------+  |                         |       6809 CPU      |\n    | |             |  |                         |       +     ^       |\n    | |     GUI     |  |                         |       |     |       |\n    | |             |  | Display RAM callback    |    +--v-----+--+    |\n    | |  .--------------------------------------------+   Memory  |    |\n    | |  |          |  |                         |    +--+-----^--+    |\n    | |  |          |  |                         |       |     |       |\n    | |  |          |  |                         | +-----v-----+-----+ |\n    | |  |          |  |                         | |    Periphery    | |\n    | |  |          |  |     Keyboard queue      | |   MC6883 SAM    | |\n    | |  |          +--------------------------------->MC6821 PIA    | |\n    | |  |          |  |                         | |                 | |\n    | +--+-----^----+  |                         | |                 | |\n    |    |     |       |                         | +-----------------+ |\n    |    |     |       |                         |                     |\n    | +--v-----+----+  |                         |                     |\n    | |             |  |                         |                     |\n    | |   Display   |  |                         |                     |\n    | |             |  |                         |                     |\n    | +-------------+  |                         |                     |\n    +------------------+                         +---------------------+\n\nperformance\n===========\n\nThe current implementation is not really optimized.\n\nWith CPython there is round about 490.000 CPU cycles/sec. in console version.\nThis is half as fast as the real Hardware.\n\nWith PyPy round about 6.900.000 - 8.000.000 CPU cycles/sec.\nIn other words with PyPy it\'s 8 times faster as the real Hardware.\n\ne.g. The Dragon 32 6809 machine with a 14.31818 MHz crystal runs with:\n0,895MHz (14,31818Mhz/16=0,895MHz) in other words: 895.000 CPU-cycles/sec.\n\n-----\nTODO:\n-----\n\n#. implement more Dragon 32 periphery\n\nmissing 6809 unittests after coverage run:\n\n* MUL\n\n* BVS\n\n----------\nPyDragon32\n----------\n\nSome Python/BASIC tools/scripts around Dragon32/64 / CoCo homecomputer.\n\nAll script are copyleft 2013-2020 by Jens Diemer and license unter GNU GPL v3 or above, see LICENSE for more details.\n\nPython scripts:\n===============\n\n* PyDC - Convert dragon 32 Cassetts WAV files into plain text:\n\n    * `https://github.com/jedie/DragonPy/tree/master/PyDC <https://github.com/jedie/DragonPy/tree/master/PyDC>`_\n\n* Filter Xroar traces:\n\n    * `https://github.com/jedie/DragonPy/tree/master/misc <https://github.com/jedie/DragonPy/tree/master/misc>`_\n\nBASIC programms:\n================\n\n* Simple memory HEX viewer:\n\n    * `https://github.com/jedie/DragonPy/tree/master/BASIC/HexViewer <https://github.com/jedie/DragonPy/tree/master/BASIC/HexViewer>`_\n\n* Test CC Registers:\n\n    * `https://github.com/jedie/DragonPy/tree/master/BASIC/TestCC_Registers <https://github.com/jedie/DragonPy/tree/master/BASIC/TestCC_Registers>`_\n\nInput/Output Tests\n------------------\n\n`/BASIC/InputOutput/keyboard.bas <https://github.com/jedie/DragonPy/tree/master/BASIC/InputOutput/keyboard.bas>`_\nDisplay memory Locations $0152 - $0159 (Keyboard matrix state table)\n\nExample screenshow with the "Y" key is pressed down. You see that this is saved in $0153:\n\n|KeyBoard Screenshot 01|\n\n.. |KeyBoard Screenshot 01| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/keyboard01.png\n\nExample with "U" is hold down:\n\n|KeyBoard Screenshot 02|\n\n.. |KeyBoard Screenshot 02| image:: https://raw.githubusercontent.com/jedie/jedie.github.io/master/screenshots/DragonPy/keyboard02.png\n\n-----\nLinks\n-----\n\n* Grant Searle\'s Multicomp FPGA project:\n\n    * Homepage: `http://searle.x10host.com/Multicomp/ <http://searle.x10host.com/Multicomp/>`_\n\n    * own `dragonpy/Multicomp6809/README <https://github.com/jedie/DragonPy/tree/master/dragonpy/Multicomp6809#readme>`_\n\n* Lennart Benschop 6809 Single Board Computer:\n\n    * Homepage: `http://lennartb.home.xs4all.nl/m6809.html <http://lennartb.home.xs4all.nl/m6809.html>`_\n\n    * own `dragonpy/sbc09/README <https://github.com/jedie/DragonPy/tree/master/dragonpy/sbc09#readme>`_\n\n* Grant Searle\'s Simple 6809 design:\n\n    * Homepage: `http://searle.x10host.com/6809/Simple6809.html`_\n\n    * own `dragonpy/Simple6809/README <https://github.com/jedie/DragonPy/tree/master/dragonpy/Simple6809#readme>`_\n\nSome links:\n\n* `http://www.burgins.com/m6809.html <http://www.burgins.com/m6809.html>`_\n\n* `http://www.maddes.net/m6809pm/ <http://www.maddes.net/m6809pm/>`_ - Programming Manual for the 6809 microprocessor from Motorola Inc. (now Freescale)\n\n* `http://www.6809.org.uk/dragon/hardware.shtml <http://www.6809.org.uk/dragon/hardware.shtml>`_\n\n* `http://dragondata.worldofdragon.org/Publications/inside-dragon.htm <http://dragondata.worldofdragon.org/Publications/inside-dragon.htm>`_\n\n* `http://koti.mbnet.fi/~atjs/mc6809/ <http://koti.mbnet.fi/~atjs/mc6809/>`_ - 6809 Emulation Page\n\nSource codes:\n\n* `https://github.com/naughton/mc6809/blob/master/mc6809.ts <https://github.com/naughton/mc6809/blob/master/mc6809.ts>`_\n\n* `https://github.com/maly/6809js/blob/master/6809.js <https://github.com/maly/6809js/blob/master/6809.js>`_\n\n* `http://mamedev.org/source/src/mess/drivers/dragon.c.html <http://mamedev.org/source/src/mess/drivers/dragon.c.html>`_\n\n* `http://mamedev.org/source/src/mess/machine/dragon.c.html <http://mamedev.org/source/src/mess/machine/dragon.c.html>`_\n\n* `http://mamedev.org/source/src/emu/cpu/m6809/m6809.c.html <http://mamedev.org/source/src/emu/cpu/m6809/m6809.c.html>`_\n\n* `https://github.com/kjetilhoem/hatchling-32/blob/master/hatchling-32/src/no/k/m6809/InstructionSet.scala <https://github.com/kjetilhoem/hatchling-32/blob/master/hatchling-32/src/no/k/m6809/InstructionSet.scala>`_\n\nDragon 32 resources:\n\n* Forum: `http://archive.worldofdragon.org/phpBB3/index.php <http://archive.worldofdragon.org/phpBB3/index.php>`_\n\n* Wiki: `http://archive.worldofdragon.org/index.php?title=Main_Page <http://archive.worldofdragon.org/index.php?title=Main_Page>`_\n\n-------\nCredits\n-------\n\nSome code based on:\n\n**ApplePy**\n\nAn Apple ][ emulator in Python\n\n* Author: James Tauber\n\n* `https://github.com/jtauber/applepy <https://github.com/jtauber/applepy>`_\n\n* License: MIT\n\n**XRoar**\nA really cool Dragon / CoCo emulator\n\n* Author: Ciaran Anscomb\n\n* `http://www.6809.org.uk/xroar/ <http://www.6809.org.uk/xroar/>`_\n\n* License: GNU GPL v2\n\nincluded Python modules:\n========================\n\n**python-pager**\nPage output and find dimensions of console.\n\n* Author: Anatoly Techtonik\n\n* License: Public Domain\n\n* Homepage: `https://bitbucket.org/techtonik/python-pager/ <https://bitbucket.org/techtonik/python-pager/>`_\n\n* Stored here: `/dragonpy/utils/pager.py <https://github.com/jedie/DragonPy/blob/master/dragonpy/utils/pager.py>`_\n\n**srecutils.py**\nMotorola S-Record utilities\n\n* Author: Gabriel Tremblay\n\n* License: GNU GPL v2\n\n* Homepage: `https://github.com/gabtremblay/pysrec <https://github.com/gabtremblay/pysrec>`_\n\n* Stored here: `/dragonpy/utils/srecord_utils.py <https://github.com/jedie/DragonPy/blob/master/dragonpy/utils/srecord_utils.py>`_\n\nrequirements\n============\n\n**dragonlib**\nDragon/CoCO Python Library\n\n* Author: Jens Diemer\n\n* `https://pypi.org/project/DragonLib/ <https://pypi.org/project/DragonLib/>`_\n\n* `https://github.com/6809/dragonlib <https://github.com/6809/dragonlib>`_\n\n* License: GNU GPL v3\n\n**MC6809**\nImplementation of the MC6809 CPU in Python\n\n* Author: Jens Diemer\n\n* `https://pypi.org/project/MC6809 <https://pypi.org/project/MC6809>`_\n\n* `https://github.com/6809/MC6809 <https://github.com/6809/MC6809>`_\n\n* License: GNU GPL v3\n\n**pygments**\ngeneric syntax highlighter\n\n* Author: Georg Brandl\n\n* `https://pypi.org/project/Pygments <https://pypi.org/project/Pygments>`_\n\n* `http://pygments.org/ <http://pygments.org/>`_\n\n* License: BSD License\n\n-------\nHistory\n-------\n\n* `*dev* <https://github.com/jedie/DragonPy/compare/v0.7.0...master>`_:\n\n    * tbc\n\n* `01.10.2020 - v0.7.0 <https://github.com/jedie/DragonPy/compare/v0.6.0...v0.7.0>`_:\n\n    * Modernize project testing, CI pipeline, usw poetry etc.\n\n    * Many Code updates\n\n    * Remove Python v2 fallback code parts\n\n    * Update ROM Download Links\n\n    * Bugfix "--max_ops" cli options\n\n* `19.06.2018 - v0.6.0 <https://github.com/jedie/DragonPy/compare/v0.5.3...v0.6.0>`_:\n\n    * Update to new MC6809 API\n\n    * reimplementing Simple6809, contributed by `Claudemir Todo Bom <https://github.com/ctodobom>`_\n\n    * TODO: Fix speedlimit\n\n    * Fix ``No module named \'nose\'`` on normal PyPi installation\n\n* `24.08.2015 - v0.5.3 <https://github.com/jedie/DragonPy/compare/v0.5.2...v0.5.3>`_:\n\n    * Bugfix for "freeze" after "speed limit" was activated\n\n* `20.08.2015 - v0.5.2 <https://github.com/jedie/DragonPy/compare/v0.5.1...v0.5.2>`_:\n\n    * Add run \'MC6809 benchmark\' button to \'starter GUI\'\n\n    * bugfix \'file not found\' in \'starter GUI\'\n\n    * change the GUI a little bit\n\n* `19.08.2015 - v0.5.1 <https://github.com/jedie/DragonPy/compare/v0.5.0...v0.5.1>`_:\n\n    * Add a "starter GUI"\n\n    * Add work-a-round for tkinter usage with virtualenv under windows, see: `virtualenv issues #93 <https://github.com/pypa/virtualenv/issues/93>`_\n\n    * bugfix e.g.: keyboard input in "sbc09" emulation\n\n    * use nose to run unittests\n\n* `18.08.2015 - v0.5.0 <https://github.com/jedie/DragonPy/compare/v0.4.0...v0.5.0>`_:\n\n    * ROM files will be downloaded on-the-fly (``.sh`` scripts are removed. So it\'s easier to use under Windows)\n\n* `26.05.2015 - v0.4.0 <https://github.com/jedie/DragonPy/compare/v0.3.2...v0.4.0>`_:\n\n    * The MC6809 code is out sourced to: `https://github.com/6809/MC6809`_\n\n* `15.12.2014 - v0.3.2 <https://github.com/jedie/DragonPy/compare/v0.3.1...v0.3.2>`_:\n\n    * Use `Pygments <http://pygments.org/>`_ syntax highlighter in BASIC editor\n\n* `08.10.2014 - v0.3.1 <https://github.com/jedie/DragonPy/compare/v0.3.0...v0.3.1>`_:\n\n    * Release as v0.3.1\n\n    * 30.09.2014 - Enhance the BASIC editor\n\n    * 29.09.2014 - Merge `PyDragon32 <https://github.com/jedie/PyDragon32>`_ project\n\n* `25.09.2014 - v0.3.0 <https://github.com/jedie/DragonPy/compare/v0.2.0...v0.3.0>`_:\n\n    * `Change Display Queue to a simple Callback <https://github.com/jedie/DragonPy/commit/f396551df730b509498d1b884cdda8f7075737c4>`_\n\n    * Reimplement `Multicomp 6809 <https://github.com/jedie/DragonPy/commit/f3bfbdb2ae9906d8e051436173225c3fa8de1373>`_ and `SBC09 <https://github.com/jedie/DragonPy/commit/61c26911379d2b7ea6d07a8b479ab14c5d5a7154>`_\n\n    * Many code refactoring and cleanup\n\n* `14.09.2014 - v0.2.0 <https://github.com/jedie/DragonPy/compare/v0.1.0...v0.2.0>`_:\n\n    * Add a speedlimit, config dialog and IRQ: `Forum post 11780 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&p=11780#p11780>`_\n\n* `05.09.2014 - v0.1.0 <https://github.com/jedie/DragonPy/compare/8fe24e5...v0.1.0>`_:\n\n    * Implement pause/resume, hard-/soft-reset 6809 in GUI and improve a little the GUI/Editor stuff\n\n    * see also: `Forum post 11719 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&p=11719#p11719>`_.\n\n* 27.08.2014 - Run CoCo with Extended Color Basic v1.1, bugfix transfer BASIC Listing with `8fe24e5...697d39e <https://github.com/jedie/DragonPy/compare/8fe24e5...697d39e>`_ see: `Forum post 11696 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&start=90#p11696>`_.\n\n* 20.08.2014 - rudimenary BASIC IDE works with `7e0f16630...ce12148 <https://github.com/jedie/DragonPy/compare/7e0f16630...ce12148>`_, see also: `Forum post 11645 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=8&t=4439#p11645>`_.\n\n* 05.08.2014 - Start to support CoCo, too with `0df724b <https://github.com/jedie/DragonPy/commit/0df724b3ee9d87088b524c3623040a41e9772eb4>`_, see also: `Forum post 11573 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&start=80#p11573>`_.\n\n* 04.08.2014 - Use the origin Pixel-Font with Tkinter GUI, see: `Forum post 4909 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4909>`_ and `Forum post 11570 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&start=80#p11570>`_.\n\n* 27.07.2014 - Copyrigth info from Dragon 64 ROM is alive with `543275b <https://github.com/jedie/DragonPy/commit/543275b1b90824b64b67dcd003cc5ab54296fc15>`_, see: `Forum post 11524 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&start=80#p11524>`_.\n\n* 29.06.2014 - First "HELLO WORLD" works, see: `Forum post 11283 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&start=70#p11283>`_.\n\n* 27.10.2013 - "sbc09" ROM works wuite well almist, see: `Forum post 9752 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&start=60#p9752>`_.\n\n* 16.10.2013 - See copyright info from "Simple6809" ROM with `25a97b6 <https://github.com/jedie/DragonPy/tree/25a97b66d8567ba7c3a5b646e4a807b816a0e376>`_ see also: `Forum post 9654 <http://archive.worldofdragon.org/phpBB3/viewtopic.php?f=5&t=4308&start=50#p9654>`_.\n\n* 10.09.2013 - Start to implement the 6809 CPU with `591d2ed <https://github.com/jedie/DragonPy/commit/591d2ed2b6f1a5f913c14e56e1e37f5870510b0d>`_\n\n* 28.08.2013 - Fork "Apple ][ Emulator" written in Python: `https://github.com/jtauber/applepy`_ to `https://github.com/jedie/DragonPy <https://github.com/jedie/DragonPy>`_\n\n------\nLinks:\n------\n\n+--------+-----------------------------------------------+\n| Forum  | `http://forum.pylucid.org/`_                  |\n+--------+-----------------------------------------------+\n| IRC    | `#pylucid on freenode.net`_                   |\n+--------+-----------------------------------------------+\n| Jabber | pylucid@conference.jabber.org                 |\n+--------+-----------------------------------------------+\n| PyPi   | `https://pypi.org/project/DragonPyEmulator/`_ |\n+--------+-----------------------------------------------+\n| Github | `https://github.com/jedie/DragonPy`_          |\n+--------+-----------------------------------------------+\n\n.. _http://forum.pylucid.org/: http://forum.pylucid.org/\n.. _#pylucid on freenode.net: http://www.pylucid.org/permalink/304/irc-channel\n.. _https://pypi.org/project/DragonPyEmulator/: https://pypi.org/project/DragonPyEmulator/\n\n--------\ndonation\n--------\n\n* Send `Bitcoins <http://www.bitcoin.org/>`_ to `1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F <https://blockexplorer.com/address/1823RZ5Md1Q2X5aSXRC5LRPcYdveCiVX6F>`_\n\n------------\n\n``Note: this file is generated from README.creole 2020-10-01 13:19:41 with "python-creole"``',
    'author': 'JensDiemer',
    'author_email': 'git@jensdiemer.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
