#!/usr/bin/env python

"""
    DragonPy - Simple6809 memory info
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    :created: 2013 by Jens Diemer - www.jensdiemer.de
    :copyleft: 2013 by the DragonPy team, see AUTHORS for more details.
    :license: GNU GPL v3 or above, see LICENSE for more details.
"""


import logging

from MC6809.core.memory_info import BaseMemoryInfo


log = logging.getLogger("DragonPy.Simple6809.mem_info")


class Simple6809MemInfo(BaseMemoryInfo):
    MEM_INFO = (
        # generated from "ExBasROM.LST" with "make_mem_info.py":

        (0x0008, 0x0008, 'BACKSPACE'),
        (0x000d, 0x000d, 'ENTER KEY'),
        (0x001b, 0x001b, 'ESCAPE CODE'),
        (0x0020, 0x0020, 'SPACE (BLANK)'),
        (0x003a, 0x003a, 'STACK BUFFER ROOM'),
        (0x00fa, 0x00fa, 'MAX NUMBER OF CHARS IN A BASIC LINE'),
        (0x00fa, 0x00fa, 'MAXIMUM MS BYTE OF LINE NUMBER'),
        (0x0021, 0x0021, 'OP CODE OF BRN - SKIP ONE BYTE'),
        (0x008c, 0x008c, 'OP CODE OF CMPX # - SKIP TWO BYTES'),
        (0x0086, 0x0086, 'OP CODE OF LDA # - SKIP THE NEXT BYTE'),
        (0x0000, 0x0000, 'STOP/END FLAG: POSITIVE=STOP, NEG=END'),
        (0x0001, 0x0001, 'TERMINATOR FLAG 1'),
        (0x0002, 0x0002, 'TERMINATOR FLAG 2'),
        (0x0003, 0x0003, 'SCRATCH VARIABLE'),
        (0x0004, 0x0004, 'IF COUNTER - HOW MANY IF STATEMENTS IN A LINE'),
        (0x0005, 0x0005, '*DV* ARRAY FLAG 0=EVALUATE, 1=DIMENSIONING'),
        (0x0006, 0x0006, '*DV* *PV TYPE FLAG: 0=NUMERIC, $FF=STRING'),
        (0x0007, 0x0007, '*TV STRING SPACE HOUSEKEEPING FLAG'),
        (0x0008, 0x0008, 'DISABLE ARRAY SEARCH: 00=ALLOW SEARCH'),
        (0x0009, 0x0009, '*TV INPUT FLAG: READ=0, INPUT<>0'),
        (0x000a, 0x000a, '*TV RELATIONAL OPERATOR FLAG'),
        (0x000b, 0x000b, '*PV TEMPORARY STRING STACK POINTER'),
        (0x000d, 0x000d, '*PV ADDR OF LAST USED STRING STACK ADDRESS'),
        (0x000f, 0x000f, 'TEMPORARY POINTER'),
        (0x0011, 0x0011, 'TEMPORARY DESCRIPTOR STORAGE (STACK SEARCH)'),
        (0x0013, 0x0013, 'FLOATING POINT ACCUMULATOR #2 MANTISSA'),
        (0x0017, 0x0017, 'BOTTOM OF STACK AT LAST CHECK'),
        (0x0019, 0x0019, '*PV BEGINNING OF BASIC PROGRAM'),
        (0x001b, 0x001b, '*PV START OF VARIABLES'),
        (0x001d, 0x001d, '*PV START OF ARRAYS'),
        (0x001f, 0x001f, '*PV END OF ARRAYS (+1)'),
        (0x0021, 0x0021, '*PV START OF STRING STORAGE (TOP OF FREE RAM)'),
        (0x0023, 0x0023, '*PV START OF STRING VARIABLES'),
        (0x0025, 0x0025, 'UTILITY STRING POINTER'),
        (0x0027, 0x0027, '*PV TOP OF STRING SPACE'),
        (0x0029, 0x0029, 'SAVED LINE NUMBER DURING A "STOP"'),
        (0x002b, 0x002b, 'BINARY VALUE OF A CONVERTED LINE NUMBER'),
        (0x002d, 0x002d, 'SAVED INPUT PTR DURING A "STOP"'),
        (0x002f, 0x002f, 'TEMPORARY INPUT POINTER STORAGE'),
        (0x0031, 0x0031, "*PV 'DATA' STATEMENT LINE NUMBER POINTER"),
        (0x0033, 0x0033, "*PV 'DATA' STATEMENT ADDRESS POINTER"),
        (0x0035, 0x0035, "DATA POINTER FOR 'INPUT' & 'READ'"),
        (0x0037, 0x0037, '*TV TEMP STORAGE FOR A VARIABLE NAME'),
        (0x0039, 0x0039, '*TV POINTER TO A VARIABLE DESCRIPTOR'),
        (0x003b, 0x003b, 'TEMP POINTER TO A VARIABLE DESCRIPTOR'),
        (0x003d, 0x003d, 'POINTER TO RELATIONAL OPERATOR PROCESSING ROUTINE'),
        (0x003f, 0x003f, 'TEMPORARY RELATIONAL OPERATOR FLAG BYTE'),

        (0x004f, 0x004f, '*PV FLOATING POINT ACCUMULATOR #0 FPA0 EXPONENT'),
        (0x0050, 0x0050, '*PV FLOAT.ACCU #0 FPA0 MANTISSA MS  Most Significant Byte'),
        (0x0051, 0x0051, '*PV FLOAT.ACCU #0 FPA0 MANTISSA NMS Next Most Significant Byte'),
        (0x0052, 0x0052, '*PV FLOAT.ACCU #0 FPA0 MANTISSA NLS Next Least Significant Byte'),
        (0x0053, 0x0053, '*PV FLOAT.ACCU #0 FPA0 MANTISSA LS  Least Significant Byte'),
        (0x0054, 0x0054, '*PV FLOATING POINT ACCUMULATOR #0 FPA0 SIGN'),

        (0x0055, 0x0055, 'POLYNOMIAL COEFFICIENT COUNTER'),
        (0x0056, 0x0056, 'TEMPORARY STRING DESCRIPTOR'),
        (0x005b, 0x005b, 'FLOATING POINT CARRY BYTE'),

        (0x005c, 0x005c, '*PV FLOATING POINT ACCUMULATOR #1 FPA0 EXPONENT'),
        (0x005d, 0x005d, '*PV FLOAT.ACCU #1 FPA0 MANTISSA MS  Most Significant Byte'),
        (0x005e, 0x005e, '*PV FLOAT.ACCU #1 FPA0 MANTISSA NMS Next Most Significant Byte'),
        (0x005f, 0x005f, '*PV FLOAT.ACCU #1 FPA0 MANTISSA NLS Next Least Significant Byte'),
        (0x0060, 0x0060, '*PV FLOAT.ACCU #1 FPA0 MANTISSA LS  Least Significant Byte'),
        (0x0061, 0x0061, '*PV FLOATING POINT ACCUMULATOR #1 FPA0 SIGN'),

        (0x0062, 0x0062, 'SIGN OF RESULT OF FLOATING POINT OPERATION'),
        (0x0063, 0x0063, 'FLOATING POINT SUB BYTE (FIFTH BYTE)'),
        (0x0064, 0x0064, 'POLYNOMIAL COEFFICIENT POINTER'),
        (0x0066, 0x0066, 'CURRENT LINE POINTER DURING LIST'),
        (0x0068, 0x0068, '*PV CURRENT LINE # OF BASIC PROGRAM, $FFFF = DIRECT'),
        (0x006a, 0x006a, '*TV TAB FIELD WIDTH'),
        (0x006b, 0x006b, '*TV TAB ZONE'),
        (0x006c, 0x006c, '*TV PRINT POSITION'),
        (0x006d, 0x006d, '*TV PRINT WIDTH'),
        (0x006e, 0x006e, '*PV WARM START FLAG: $55=WARM, OTHER=COLD'),
        (0x006f, 0x006f, '*PV WARM START VECTOR - JUMP ADDRESS FOR WARM START'),
        (0x0071, 0x0071, '*PV TOP OF RAM'),
        (0x0073, 0x0073, '*TV INKEY$ RAM IMAGE'),
        (0x0074, 0x0074, '*PV DUMMY - THESE TWO BYTES ARE ALWAYS ZERO'),
        (0x0076, 0x0076, '16'),
        (0x0077, 0x0077, '112'),
        (0x0078, 0x0078, '132'),
        (0x0079, 0x0079, '0'),
        (0x007a, 0x007a, 'LB4AA'),
        (0x007c, 0x007c, '*PV INCREMENT LS BYTE OF INPUT POINTER'),
        (0x007e, 0x007e, '*PV BRANCH IF NOT ZERO (NO CARRY)'),
        (0x0080, 0x0080, '*PV INCREMENT MS BYTE OF INPUT POINTER'),
        (0x0082, 0x0082, '*PV OP CODE OF LDA EXTENDED'),
        (0x0083, 0x0083, '*PV THESE 2 BYTES CONTAIN ADDRESS OF THE CURRENT'),
        (0x0085, 0x0085, 'JUMP BACK INTO THE BASIC RUM'),
        (0x0088, 0x0088, '= LOW ORDER FOUR BYTES OF THE PRODUCT'),
        (0x0089, 0x0089, '= OF A FLOATING POINT MULTIPLICATION'),
        (0x008a, 0x008a, '= THESE BYTES ARE USE AS RANDOM DATA'),
        (0x008b, 0x008b, '= BY THE RND STATEMENT'),
        (0x008c, 0x008c, '*PV TRACE FLAG 0=OFF ELSE=ON'),
        (0x008d, 0x008d, '*PV ADDRESS OF THE START OF USR VECTORS'),
        (0x00ad, 0x00ad, "JUMP ADDRESS FOR BASIC'S USR FUNCTION"),
        (0x00b0, 0x00b0, '* FLOATING POINT RANDOM NUMBER SEED EXPONENT'),
        (0x00b1, 0x00b1, '* MANTISSA: INITIALLY SET TO $804FC75259'),
        (0x00b5, 0x00b5, 'USR 0 VECTOR'),
        (0x00b7, 0x00b7, 'USR 1'),
        (0x00b9, 0x00b9, 'USR 2'),
        (0x00bb, 0x00bb, 'USR 3'),
        (0x00bd, 0x00bd, 'USR 4'),
        (0x00bf, 0x00bf, 'USR 5'),
        (0x00c1, 0x00c1, 'USR 6'),
        (0x00c3, 0x00c3, 'USR 7'),
        (0x00c5, 0x00c5, 'USR 8'),
        (0x00c7, 0x00c7, 'USR 9'),
        (0x00c9, 0x00c9, 'STRING DESCRIPTOR STACK'),
        (0x00f1, 0x00f1, 'LINE INPUT BUFFER HEADER'),
        (0x00f3, 0x00f3, 'BASIC LINE INPUT BUFFER'),
        (0x01ee, 0x01ee, 'STRING BUFFER'),
        (0x0217, 0x0217, 'START OF PROGRAM SPACE'),
        (0xdb00, 0xdb00, 'GET A CHARACTER FROM CONSOLE IN'),
        (0xdb02, 0xdb02, 'LOOP IF NO KEY DOWN'),
        (0xdb14, 0xdb14, 'IA'),
        (0xdb18, 0xdb18, 'IS IT CARRIAGE RETURN?'),
        (0xdb1a, 0xdb1a, 'YES'),
        (0xdb1f, 0xdb1f, 'INCREMENT CHARACTER COUNTER'),
        (0xdb21, 0xdb21, 'CHECK FOR END OF LINE PRINTER LINE'),
        (0xdb23, 0xdb23, 'AT END OF LINE PRINTER LINE?'),
        (0xdb25, 0xdb25, 'NO'),
        (0xdb27, 0xdb27, 'RESET CHARACTER COUNTER'),
        (0xdb29, 0xdb29, 'IA'),
        (0xdb30, 0xdb30, 'IA'),
        (0xdb32, 0xdb32, 'DO LINEFEED AFTER CR'),
        (0xdb46, 0xdb46, 'SET STACK TO TOP OF LINE INPUT BUFFER'),
        (0xdb4a, 0xdb4a, 'GET WARM START FLAG'),
        (0xdb4c, 0xdb4c, 'IS IT A WARM START?'),
        (0xdb4e, 0xdb4e, 'NO - D0 A COLD START'),
        (0xdb50, 0xdb50, 'WARM START VECTOR'),
        (0xdb52, 0xdb52, 'GET FIRST BYTE OF WARM START ADDR'),
        (0xdb54, 0xdb54, 'IS IT NOP?'),
        (0xdb56, 0xdb56, 'NO - DO A COLD START'),
        (0xdb58, 0xdb58, 'YES, G0 THERE'),
        (0xdb5a, 0xdb5a, 'POINT X TO CLEAR 1ST 1K OF RAM'),
        (0xdb5d, 0xdb5d, 'MOVE POINTER DOWN TWO-CLEAR BYTE'),
        (0xdb5f, 0xdb5f, 'ADVANCE POINTER ONE'),
        (0xdb61, 0xdb61, 'KEEP GOING IF NOT AT BOTTOM OF PAGE 0'),
        (0xdb63, 0xdb63, 'SET TO START OF PROGRAM SPACE'),
        (0xdb66, 0xdb66, 'CLEAR 1ST BYTE OF BASIC PROGRAM'),
        (0xdb68, 0xdb68, 'BEGINNING OF BASIC PROGRAM'),
        (0xdb6a, 0xdb6a, 'LOOK FOR END OF MEMORY'),
        (0xdb6c, 0xdb6c, '* COMPLEMENT IT AND PUT IT BACK'),
        (0xdb6d, 0xdb6d, '* INTO SYSTEM MEMORY'),
        (0xdb6f, 0xdb6f, 'IS IT RAM?'),
        (0xdb71, 0xdb71, 'BRANCH IF NOT (ROM, BAD RAM OR NO RAM)'),
        (0xdb73, 0xdb73, 'MOVE POINTER UP ONE'),
        (0xdb75, 0xdb75, 'RE-COMPLEMENT TO RESTORE BYTE'),
        (0xdb77, 0xdb77, 'KEEP LOOKING FOR END OF RAM'),
        (0xdb79, 0xdb79, 'SAVE ABSOLUTE TOP OF RAM'),
        (0xdb7b, 0xdb7b, 'SAVE TOP OF STRING SPACE'),
        (0xdb7d, 0xdb7d, 'SAVE START OF STRING VARIABLES'),
        (0xdb7f, 0xdb7f, 'CLEAR 200 - DEFAULT STRING SPACE TO 200 BYTES'),
        (0xdb83, 0xdb83, 'SAVE START OF STRING SPACE'),
        (0xdb85, 0xdb85, 'PUT STACK THERE'),
        (0xdb87, 0xdb87, 'POINT X TO ROM SOURCE DATA'),
        (0xdb8a, 0xdb8a, 'POINT U TO RAM DESTINATION'),
        (0xdb8d, 0xdb8d, 'MOVE 18 BYTES'),
        (0xdb8f, 0xdb8f, 'MOVE 18 BYTES FROM ROM TO RAM'),
        (0xdb92, 0xdb92, 'POINT U TO NEXT RAM DESTINATION'),
        (0xdb95, 0xdb95, 'MOVE 4 MORE BYTES'),
        (0xdb97, 0xdb97, 'MOVE 4 BYTES FROM ROM TO RAM'),
        (0xdb9c, 0xdb9c, 'PUT RTS IN LINHDR-1'),
        (0xdb9e, 0xdb9e, "G0 DO A 'NEW'"),
        (0xdba1, 0xdba1, 'INITIALIZE ADDRESS OF START OF'),
        (0xdba4, 0xdba4, 'USR JUMP TABLE'),
        (0xdba6, 0xdba6, "ADDRESS OF 'FC ERROR' ROUTINE"),
        (0xdba9, 0xdba9, '10 USR CALLS IN EX BASIC'),
        (0xdbab, 0xdbab, "STORE 'FC' ERROR AT USR ADDRESSES"),
        (0xdbad, 0xdbad, 'FINISHED ALL 10?'),
        (0xdbae, 0xdbae, 'NO'),
        (0xdbb0, 0xdbb0, 'DIV16 CLOCK -> 7372800 / 4 / 16 = 115200'),
        (0xdbb5, 0xdbb5, 'POINT X TO COLOR BASIC COPYRIGHT MESSAGE'),
        (0xdbb8, 0xdbb8, "PRINT 'COLOR BASIC'"),
        (0xdbbb, 0xdbbb, 'WARM START ADDRESS'),
        (0xdbbe, 0xdbbe, 'SAVE IT'),
        (0xdbc0, 0xdbc0, 'WARM START FLAG'),
        (0xdbc2, 0xdbc2, 'SAVE IT'),
        (0xdbc4, 0xdbc4, "GO TO BASIC'S MAIN LOOP"),
        (0xdbc6, 0xdbc6, 'FOR WARM START'),
        (0xdbc7, 0xdbc7, 'DO PART OF A NEW'),
        (0xdbca, 0xdbca, 'GO TO MAIN LOOP OF BASIC'),
        (0xdbce, 0xdbce, 'TAB FIELD WIDTH'),
        (0xdbcf, 0xdbcf, 'LAST TAB ZONE'),
        (0xdbd0, 0xdbd0, 'PRINTER WIDTH'),
        (0xdbd1, 0xdbd1, 'LINE PRINTER POSITION'),
        (0xdbd2, 0xdbd2, "ARGUMENT OF EXEC COMMAND - SET TO 'FC' ERROR"),
        (0xdbd4, 0xdbd4, '+1'),
        (0xdbe0, 0xdbe0, 'IRQ SERVICE'),
        (0xdbe3, 0xdbe3, 'FIRQ SERVICE'),
        (0xdbe6, 0xdbe6, "USR ADDRESS FOR 8K BASIC (INITIALIZED TO 'FC' ERROR)"),
        (0xdbe9, 0xdbe9, '*RANDOM SEED'),
        (0xdbea, 0xdbea, '*RANDON SEED OF MANTISSA'),
        (0xdbec, 0xdbec, '*.811635157'),
        (0xdbee, 0xdbee, '50 BASIC COMMANDS'),
        (0xdbef, 0xdbef, 'POINTS TO RESERVED WORDS'),
        (0xdbf1, 0xdbf1, 'POINTS TO JUMP TABLE FOR COMMANDS'),
        (0xdbf3, 0xdbf3, '29 BASIC SECONDARY COMMANDS'),
        (0xdbf4, 0xdbf4, 'POINTS TO SECONDARY FUNCTION RESERVED WORDS'),
        (0xdbf6, 0xdbf6, 'POINTS TO SECONDARY FUNCTION JUMP TABLE'),
        (0xdbf8, 0xdbf8, 'NO MORE TABLES (RES WORDS=0)'),
        (0xdbfa, 0xdbfa, 'NO MORE TABLES'),
        (0xdbfc, 0xdbfc, 'NO MORE TABLES'),
        (0xdbfe, 0xdbfe, 'NO MORE TABLES'),
        (0xdc00, 0xdc00, 'NO MORE TABLES'),
        (0xdc02, 0xdc02, 'NO MORE TABLES (SECONDARY FNS =0)'),
        (0xdc04, 0xdc04, 'BASIC"'),
        (0xdc18, 0xdc18, 'BY MICROSOFT"'),
        (0xdc30, 0xdc30, 'SAVE REGISTERS'),
        (0xdc32, 0xdc32, 'TAB FIELD WIDTH AND TAB ZONE'),
        (0xdc34, 0xdc34, 'PRINTER WIDTH AND POSITION'),
        (0xdc36, 0xdc36, 'SAVE TAB FIELD WIDTH AND ZONE'),
        (0xdc38, 0xdc38, 'SAVE PRINT POSITION'),
        (0xdc3a, 0xdc3a, 'SAVE PRINT WIDTH'),
        (0xdc3c, 0xdc3c, 'RESTORE REGISTERS'),
        (0xdc3e, 0xdc3e, 'RESET BREAK CHECK KEY TEMP KEY STORAGE'),
        (0xdc40, 0xdc40, 'INPUT LINE BUFFER'),
        (0xdc43, 0xdc43, 'ACCB CHAR COUNTER: SET TO 1 TO ALLOW A'),
        (0xdc45, 0xdc45, 'GO GET A CHARACTER FROM CONSOLE IN'),
        (0xdc48, 0xdc48, 'BACKSPACE'),
        (0xdc4a, 0xdc4a, 'NO'),
        (0xdc4c, 0xdc4c, 'YES - DECREMENT CHAR COUNTER'),
        (0xdc4d, 0xdc4d, 'BRANCH IF BACK AT START OF LINE AGAIN'),
        (0xdc4f, 0xdc4f, 'DECREMENT BUFFER POINTER'),
        (0xdc51, 0xdc51, 'ECHO CHAR TO SCREEN'),
        (0xdc53, 0xdc53, 'SHIFT RIGHT ARROW?'),
        (0xdc55, 0xdc55, 'NO'),
        (0xdc57, 0xdc57, 'DEC CHAR CTR'),
        (0xdc58, 0xdc58, 'GO BACK TO START IF CHAR CTR = 0'),
        (0xdc5a, 0xdc5a, 'BACKSPACE?'),
        (0xdc5c, 0xdc5c, 'SEND TO CONSOLE OUT (SCREEN)'),
        (0xdc5f, 0xdc5f, 'KEEP GOING'),
        (0xdc61, 0xdc61, 'BREAK KEY?'),
        (0xdc63, 0xdc63, 'SET CARRY FLAG'),
        (0xdc65, 0xdc65, 'BRANCH IF BREAK KEY DOWN'),
        (0xdc67, 0xdc67, 'ENTER KEY?'),
        (0xdc69, 0xdc69, 'NO'),
        (0xdc6b, 0xdc6b, 'CLEAR CARRY FLAG IF ENTER KEY - END LINE ENTRY'),
        (0xdc6c, 0xdc6c, 'SAVE CARRY FLAG'),
        (0xdc6e, 0xdc6e, 'SEND CR TO SCREEN'),
        (0xdc71, 0xdc71, 'MAKE LAST BYTE IN INPUT BUFFER = 0'),
        (0xdc73, 0xdc73, 'RESET INPUT BUFFER POINTER'),
        (0xdc76, 0xdc76, 'RESTORE CARRY FLAG'),
        (0xdc78, 0xdc78, 'IS IT CONTROL CHAR?'),
        (0xdc7a, 0xdc7a, 'BRANCH IF CONTROL CHARACTER'),
        (0xdc7e, 0xdc7e, '* IGNORE IF > LOWER CASE Z'),
        (0xdc80, 0xdc80, 'HAVE 250 OR MORE CHARACTERS BEEN ENTERED?'),
        (0xdc82, 0xdc82, 'YES, IGNORE ANY MORE'),
        (0xdc84, 0xdc84, 'PUT IT IN INPUT BUFFER'),
        (0xdc86, 0xdc86, 'INCREMENT CHARACTER COUNTER'),
        (0xdc87, 0xdc87, 'ECHO IT TO SCREEN'),
        (0xdc8a, 0xdc8a, 'GO SET SOME MORE'),
        (0xdc8c, 0xdc8c, 'BRANCH IF NO ARGUMENT'),
        (0xdc8e, 0xdc8e, 'EVALUATE ARGUMENT - ARGUMENT RETURNED IN X'),
        (0xdc91, 0xdc91, 'STORE X TO EXEC JUMP ADDRESS'),
        (0xdc93, 0xdc93, 'GO DO IT'),
        (0xdc97, 0xdc97, 'GO DO BREAK KEY CHECK'),
        (0xdc9a, 0xdc9a, 'WAS A KEY DOWN IN THE BREAK CHECK?'),
        (0xdc9c, 0xdc9c, 'YES'),
        (0xdc9e, 0xdc9e, 'GO GET A KEY'),
        (0xdca1, 0xdca1, 'CLEAR INKEY RAM IMAGE'),
        (0xdca3, 0xdca3, 'STORE THE KEY IN FPA0'),
        (0xdca5, 0xdca5, 'CONVERT FPA0+3 TO A STRING'),
        (0xdca9, 0xdca9, 'SET LENGTH OF STRING = 0 IF NO KEY DOWN'),
        (0xdcab, 0xdcab, 'PUT A NULL STRING ONTO THE STRING STACK'),
        (0xdcae, 0xdcae, 'GET BYTE FROM X'),
        (0xdcb0, 0xdcb0, 'STORE IT AT U'),
        (0xdcb2, 0xdcb2, 'MOVED ALL BYTES?'),
        (0xdcb3, 0xdcb3, 'NO'),
        (0xdcb7, 0xdcb7, 'GET CURRENT INPUT CHAR FROM BASIC LINE'),
        (0xdcb9, 0xdcb9, 'RETURN IF END OF LINE'),
        (0xdcbb, 0xdcbb, 'SYNTAX ERROR IF ANY MORE CHARACTERS'),
        (0xdcbe, 0xdcbe, 'FROM INTERRUPT'),
        (0xdcbf, 0xdcbf, 'IS THIS CHARACTER >=(ASCII 9)+1?'),
        (0xdcc1, 0xdcc1, 'BRANCH IF > 9; Z SET IF = COLON'),
        (0xdcc3, 0xdcc3, 'SPACE?'),
        (0xdcc5, 0xdcc5, 'NO - SET CARRY IF NUMERIC'),
        (0xdcc7, 0xdcc7, 'IF SPACE, GET NECT CHAR (IGNORE SPACES)'),
        (0xdcc9, 0xdcc9, '* SET CARRY IF'),
        (0xdccb, 0xdccb, '* CHARACTER > ASCII 0'),
        (0xdcce, 0xdcce, 'SGN'),
        (0xdcd0, 0xdcd0, 'INT'),
        (0xdcd2, 0xdcd2, 'ABS'),
        (0xdcd4, 0xdcd4, 'USR'),
        (0x0083, 0x0083, '_TAB/2+$7F'),
        (0xff83, 0xff83, 'C_TAB/2+$FF7F'),
        (0xdcd6, 0xdcd6, 'RND'),
        (0xdcd8, 0xdcd8, 'SIN'),
        (0xdcda, 0xdcda, 'PEEK'),
        (0xdcdc, 0xdcdc, 'LEN'),
        (0xdcde, 0xdcde, 'STR$'),
        (0xdce0, 0xdce0, 'VAL'),
        (0xdce2, 0xdce2, 'ASC'),
        (0xdce4, 0xdce4, 'CHR$'),
        (0xdce6, 0xdce6, 'ATN'),
        (0xdce8, 0xdce8, 'COS'),
        (0xdcea, 0xdcea, 'TAN'),
        (0xdcec, 0xdcec, 'EXP'),
        (0xdcee, 0xdcee, 'FIX'),
        (0xdcf0, 0xdcf0, 'LOG'),
        (0xdcf2, 0xdcf2, 'POS'),
        (0xdcf4, 0xdcf4, 'SQR'),
        (0xdcf6, 0xdcf6, 'HEX$'),
        (0xdcf8, 0xdcf8, 'LEFT$'),
        (0x0095, 0x0095, '_TAB/2+$7F'),
        (0xdcfa, 0xdcfa, 'RIGHT$'),
        (0xdcfc, 0xdcfc, 'MID$'),
        (0x0097, 0x0097, '_TAB/2+$7F'),
        (0xdcfe, 0xdcfe, 'INKEY$'),
        (0x0098, 0x0098, '_TAB/2+$7F'),
        (0xdd00, 0xdd00, 'MEM'),
        (0xdd02, 0xdd02, 'VARPTR'),
        (0xdd04, 0xdd04, 'INSTR'),
        (0xdd06, 0xdd06, 'STRING$'),
        (0x001d, 0x001d, 'NC_TAB/2'),
        (0xdd09, 0xdd09, '+'),
        (0xdd0c, 0xdd0c, '-'),
        (0xdd12, 0xdd12, '/'),
        (0xdd15, 0xdd15, 'EXPONENTIATION'),
        (0xdd18, 0xdd18, 'AND'),
        (0xdd1b, 0xdd1b, 'OR'),
        (0xdd1d, 0xdd1d, '80'),
        (0xdd1f, 0xdd1f, "'"),
        (0xdd20, 0xdd20, '81'),
        (0xdd21, 0xdd21, "'"),
        (0xdd22, 0xdd22, '82'),
        (0xdd24, 0xdd24, "'"),
        (0xdd25, 0xdd25, '83'),
        (0xdd26, 0xdd26, '84'),
        (0xdd29, 0xdd29, "'"),
        (0xdd2a, 0xdd2a, '85'),
        (0xdd2b, 0xdd2b, "'"),
        (0xdd2c, 0xdd2c, '86'),
        (0xdd2f, 0xdd2f, "'"),
        (0xdd30, 0xdd30, '87'),
        (0xdd34, 0xdd34, "'"),
        (0xdd35, 0xdd35, '88'),
        (0xdd36, 0xdd36, "'"),
        (0xdd37, 0xdd37, '89'),
        (0xdd3b, 0xdd3b, "'"),
        (0xdd3c, 0xdd3c, '8A'),
        (0xdd3e, 0xdd3e, "'"),
        (0xdd3f, 0xdd3f, '8B'),
        (0xdd42, 0xdd42, "'"),
        (0xdd43, 0xdd43, '8C'),
        (0xdd45, 0xdd45, "'"),
        (0xdd46, 0xdd46, '8D'),
        (0xdd49, 0xdd49, "'"),
        (0xdd4a, 0xdd4a, '8E'),
        (0xdd4c, 0xdd4c, "'"),
        (0xdd4d, 0xdd4d, '8F'),
        (0xdd53, 0xdd53, "'"),
        (0xdd54, 0xdd54, '90'),
        (0xdd59, 0xdd59, "'"),
        (0xdd5a, 0xdd5a, '91'),
        (0xdd5d, 0xdd5d, "'"),
        (0xdd5e, 0xdd5e, '92'),
        (0xdd61, 0xdd61, "'"),
        (0xdd62, 0xdd62, '93'),
        (0xdd65, 0xdd65, "'"),
        (0xdd66, 0xdd66, '94'),
        (0xdd69, 0xdd69, "'"),
        (0xdd6a, 0xdd6a, '95'),
        (0xdd6e, 0xdd6e, "'"),
        (0xdd6f, 0xdd6f, '96'),
        (0xdd71, 0xdd71, "'"),
        (0xdd72, 0xdd72, '97'),
        (0xdd75, 0xdd75, "'"),
        (0xdd76, 0xdd76, '98'),
        (0xdd79, 0xdd79, "'"),
        (0xdd7a, 0xdd7a, '99'),
        (0xdd7e, 0xdd7e, "'"),
        (0xdd7f, 0xdd7f, '9A'),
        (0xdd81, 0xdd81, "'"),
        (0xdd82, 0xdd82, '9B'),
        (0xdd84, 0xdd84, "'"),
        (0xdd85, 0xdd85, '9C'),
        (0xdd88, 0xdd88, "'"),
        (0xdd89, 0xdd89, '9D'),
        (0xdd8d, 0xdd8d, "'"),
        (0xdd8e, 0xdd8e, '9E'),
        (0xdd91, 0xdd91, "'"),
        (0xdd92, 0xdd92, '9F'),
        (0xdd95, 0xdd95, "'"),
        (0xdd96, 0xdd96, 'A0'),
        (0xdd97, 0xdd97, "'"),
        (0xdd98, 0xdd98, 'A1'),
        (0xdd9a, 0xdd9a, "'"),
        (0xdd9b, 0xdd9b, 'A2'),
        (0xdd9e, 0xdd9e, "'"),
        (0xdd9f, 0xdd9f, 'A3'),
        (0xdda1, 0xdda1, "'"),
        (0xdda2, 0xdda2, 'A4'),
        (0xdda5, 0xdda5, "'"),
        (0xdda6, 0xdda6, 'A5'),
        (0xdda8, 0xdda8, "'"),
        (0xdda9, 0xdda9, 'A6'),
        (0xddaa, 0xddaa, 'A7'),
        (0xddab, 0xddab, 'A8'),
        (0xddac, 0xddac, 'A9'),
        (0xddad, 0xddad, 'AA'),
        (0xddae, 0xddae, 'AB'),
        (0xddb0, 0xddb0, "'"),
        (0xddb1, 0xddb1, 'AC'),
        (0xddb2, 0xddb2, "'"),
        (0xddb3, 0xddb3, 'AD'),
        (0xddb4, 0xddb4, 'AE'),
        (0xddb5, 0xddb5, 'AF'),
        (0xddb6, 0xddb6, 'B0'),
        (0xddb7, 0xddb7, "'"),
        (0xddb8, 0xddb8, 'B1'),
        (0xddbc, 0xddbc, "'"),
        (0xddbd, 0xddbd, '80'),
        (0xddbf, 0xddbf, "'"),
        (0xddc0, 0xddc0, '81'),
        (0xddc2, 0xddc2, "'"),
        (0xddc3, 0xddc3, '82'),
        (0xddc5, 0xddc5, "'"),
        (0xddc6, 0xddc6, '83'),
        (0xddc8, 0xddc8, "'"),
        (0xddc9, 0xddc9, '84'),
        (0xddcb, 0xddcb, "'"),
        (0xddcc, 0xddcc, '85'),
        (0xddce, 0xddce, "'"),
        (0xddcf, 0xddcf, '86'),
        (0xddd2, 0xddd2, "'"),
        (0xddd3, 0xddd3, '87'),
        (0xddd5, 0xddd5, "'"),
        (0xddd6, 0xddd6, '88'),
        (0xddd9, 0xddd9, "'"),
        (0xddda, 0xddda, '89'),
        (0xdddc, 0xdddc, "'"),
        (0xdddd, 0xdddd, '8A'),
        (0xdddf, 0xdddf, "'"),
        (0xdde0, 0xdde0, '8B'),
        (0xdde3, 0xdde3, "'"),
        (0xdde4, 0xdde4, '8C'),
        (0xdde6, 0xdde6, "'"),
        (0xdde7, 0xdde7, '8D'),
        (0xdde9, 0xdde9, "'"),
        (0xddea, 0xddea, '8E'),
        (0xddec, 0xddec, "'"),
        (0xdded, 0xdded, '8F'),
        (0xddef, 0xddef, "'"),
        (0xddf0, 0xddf0, '90'),
        (0xddf2, 0xddf2, "'"),
        (0xddf3, 0xddf3, '91'),
        (0xddf5, 0xddf5, "'"),
        (0xddf6, 0xddf6, '92'),
        (0xddf8, 0xddf8, "'"),
        (0xddf9, 0xddf9, '93'),
        (0xddfb, 0xddfb, "'"),
        (0xddfc, 0xddfc, '94'),
        (0xddff, 0xddff, "'"),
        (0xde00, 0xde00, '95'),
        (0xde04, 0xde04, "'"),
        (0xde05, 0xde05, '96'),
        (0xde0a, 0xde0a, "'"),
        (0xde0b, 0xde0b, '97'),
        (0xde0e, 0xde0e, "'"),
        (0xde0f, 0xde0f, '98'),
        (0xde14, 0xde14, "'"),
        (0xde15, 0xde15, '99'),
        (0xde17, 0xde17, "'"),
        (0xde18, 0xde18, '9A'),
        (0xde1d, 0xde1d, "'"),
        (0xde1e, 0xde1e, '9B'),
        (0xde22, 0xde22, "'"),
        (0xde23, 0xde23, '9C'),
        (0xde29, 0xde29, "'"),
        (0xde2a, 0xde2a, '80'),
        (0xde2c, 0xde2c, '81'),
        (0xde2e, 0xde2e, '82'),
        (0x0082, 0x0082, 'TAB/2+$7F'),
        (0xde30, 0xde30, "83 (')"),
        (0x0083, 0x0083, '_TAB/2+$7F'),
        (0xde32, 0xde32, '84 (ELSE)'),
        (0x0084, 0x0084, 'TAB/2+$7F'),
        (0xde34, 0xde34, '85'),
        (0x0085, 0x0085, 'TAB/2+$7F'),
        (0xde36, 0xde36, '86'),
        (0x0086, 0x0086, 'TAB/2+$7F'),
        (0xde38, 0xde38, '87'),
        (0x0087, 0x0087, 'TAB/2+$7F'),
        (0xde3a, 0xde3a, '88'),
        (0xde3c, 0xde3c, '89'),
        (0x0089, 0x0089, 'TAB/2+$7F'),
        (0xde3e, 0xde3e, '8A'),
        (0xde40, 0xde40, '8B'),
        (0xde42, 0xde42, '8C'),
        (0xde44, 0xde44, '8D'),
        (0xde46, 0xde46, '8E'),
        (0xde48, 0xde48, '8F'),
        (0xde4a, 0xde4a, '90'),
        (0xde4c, 0xde4c, '91'),
        (0xde4e, 0xde4e, '92'),
        (0xde50, 0xde50, '93'),
        (0xde52, 0xde52, '94'),
        (0xde54, 0xde54, '95'),
        (0xde56, 0xde56, '96'),
        (0xde58, 0xde58, '97'),
        (0xde5a, 0xde5a, '98'),
        (0xde5c, 0xde5c, '99'),
        (0xde5e, 0xde5e, '9A'),
        (0xde60, 0xde60, '9B'),
        (0xde62, 0xde62, '9C'),
        (0xde64, 0xde64, '9D'),
        (0xde66, 0xde66, '9E'),
        (0x009e, 0x009e, 'CMD_TAB/2+$7F'),
        (0xde68, 0xde68, '0 NEXT WITHOUT FOR'),
        (0xde6a, 0xde6a, '1 SYNTAX ERROR'),
        (0xde6c, 0xde6c, '2 RETURN WITHOUT GOSUB'),
        (0xde6e, 0xde6e, '3 OUT OF DATA'),
        (0xde70, 0xde70, '4 ILLEGAL FUNCTION CALL'),
        (0xde72, 0xde72, '5 OVERFLOW'),
        (0xde74, 0xde74, '6 OUT OF MEMORY'),
        (0xde76, 0xde76, '7 UNDEFINED LINE NUMBER'),
        (0xde78, 0xde78, '8 BAD SUBSCRIPT'),
        (0xde7a, 0xde7a, '9 REDIMENSIONED ARRAY'),
        (0xde7c, 0xde7c, '10 DIVISION BY ZERO'),
        (0xde7e, 0xde7e, '11 ILLEGAL DIRECT STATEMENT'),
        (0xde80, 0xde80, '12 TYPE MISMATCH'),
        (0xde82, 0xde82, '13 OUT OF STRING SPACE'),
        (0xde84, 0xde84, '14 STRING TOO LONG'),
        (0xde86, 0xde86, '15 STRING FORMULA TOO COMPLEX'),
        (0xde88, 0xde88, "16 CAN'T CONTINUE"),
        (0xde8a, 0xde8a, '17 BAD FILE DATA'),
        (0xde8c, 0xde8c, '18 FILE ALREADY OPEN'),
        (0xde8e, 0xde8e, '19 DEVICE NUMBER ERROR'),
        (0xde90, 0xde90, '20 I/O ERROR'),
        (0xde92, 0xde92, '21 BAD FILE MODE'),
        (0xde94, 0xde94, '22 FILE NOT OPEN'),
        (0xde96, 0xde96, '23 INPUT PAST END OF FILE'),
        (0xde98, 0xde98, '24 DIRECT STATEMENT IN FILE'),
        (0xde9a, 0xde9a, '25 UNDEFINED FUNCTION (FN) CALL'),
        (0xde9c, 0xde9c, '26 FILE NOT FOUND'),
        (0xde9e, 0xde9e, 'R"'),
        (0xdeb0, 0xdeb0, '"'),
        (0xdeb6, 0xdeb6, 'POINT X TO 3RD ADDRESS ON STACK - IGNORE THE'),
        (0xdeb8, 0xdeb8, "18 BYTES SAVED ON STACK FOR EACH 'FOR' LOOP"),
        (0xdeba, 0xdeba, 'SAVE POINTER'),
        (0xdebc, 0xdebc, 'GET 1ST BYTE'),
        (0xdebe, 0xdebe, '* CHECK FOR TYPE OF STACK JUMP FOUND'),
        (0xdec0, 0xdec0, "* BRANCH IF NOT 'FOR/NEXT'"),
        (0xdec2, 0xdec2, '= GET INDEX VARIABLE DESCRIPTOR'),
        (0xdec4, 0xdec4, '= POINTER AND SAVE IT IN TMPTR1'),
        (0xdec6, 0xdec6, 'GET INDEX VARIABLE BEING SEARCHED FOR'),
        (0xdec8, 0xdec8, 'BRANCH IF DEFAULT INDEX VARIABLE - USE THE'),
        (0xdeca, 0xdeca, 'DOES THE STACK INDEX MATCH THE ONE'),
        (0xdecc, 0xdecc, 'YES'),
        (0xdece, 0xdece, '* RESTORE INITIAL POINTER, ADD'),
        (0xded0, 0xded0, '* 18 TO IT AND LOOK FOR'),
        (0xded1, 0xded1, '* NEXT BLOCK OF DATA'),
        (0xded3, 0xded3, '= GET 1ST INDEX VARIABLE FOUND AND'),
        (0xded5, 0xded5, "= SAVE AS 'NEXT' INDEX"),
        (0xded7, 0xded7, "POINT X TO START OF 'FOR/NEXT' DATA"),
        (0xded9, 0xded9, "SET ZERO FLAG IF 'FOR/NEXT' DATA"),
        (0xdedb, 0xdedb, 'ACCD = NEW BOTTOM OF FREE RAM - IS THERE'),
        (0xdedd, 0xdedd, 'POINT U TO DESTINATION ADDRESS (V41)'),
        (0xdedf, 0xdedf, 'ADD ONE TO U - COMPENSATE FOR FIRST PSHU'),
        (0xdee1, 0xdee1, 'POINT X TO SOURCE ADDRESS (V43)'),
        (0xdee3, 0xdee3, 'ADD ONE - COMPENSATE FOR FIRST LDA ,X'),
        (0xdee5, 0xdee5, 'GRAB A BYTE FROM SOURCE'),
        (0xdee7, 0xdee7, 'MOVE IT TO DESTINATION'),
        (0xdee9, 0xdee9, 'DONE?'),
        (0xdeeb, 0xdeeb, 'NO - KEEP MOVING BYTES'),
        (0xdeed, 0xdeed, 'SAVE FINAL DESTINATION ADDRESS'),
        (0xdef0, 0xdef0, '* ACCD CONTAINS NUMBER OF EXTRA'),
        (0xdef1, 0xdef1, '* BYTES TO PUT ON STACK'),
        (0xdef2, 0xdef2, 'END OF PROGRAM AND VARIABLES'),
        (0xdef4, 0xdef4, 'ADD STACK BUFFER - ROOM FOR STACK?'),
        (0xdef7, 0xdef7, 'BRANCH IF GREATER THAN $FFFF'),
        (0xdef9, 0xdef9, 'CURRENT NEW BOTTOM OF STACK STACK POINTER'),
        (0xdefc, 0xdefc, 'ARE WE GOING TO BE BELOW STACK?'),
        (0xdeff, 0xdeff, 'YES - NO ERROR'),
        (0xdf01, 0xdf01, 'OUT OF MEMORY ERROR'),
        (0xdf03, 0xdf03, 'RESET STACK, STRING STACK, CONTINUE POINTER'),
        (0xdf06, 0xdf06, 'SEND A CR TO SCREEN'),
        (0xdf09, 0xdf09, "SEND A '?' TO SCREEN"),
        (0xdf0c, 0xdf0c, 'POINT TO ERROR TABLE'),
        (0xdf0f, 0xdf0f, 'ADD MESSAGE NUMBER OFFSET'),
        (0xdf10, 0xdf10, '* GET TWO CHARACTERS FROM X AND'),
        (0xdf12, 0xdf12, '* SEND TO CONSOLE OUT (SCREEN)'),
        (0xdf14, 0xdf14, 'POINT TO "ERROR" MESSAGE'),
        (0xdf17, 0xdf17, 'PRINT MESSAGE POINTED TO BY X'),
        (0xdf1a, 0xdf1a, 'GET CURRENT LINE NUMBER (CURL IN)'),
        (0xdf1c, 0xdf1c, 'TEST FOR DIRECT MODE'),
        (0xdf1d, 0xdf1d, 'BRANCH IF DIRECT MODE'),
        (0xdf1f, 0xdf1f, "PRINT 'IN ****'"),
        (0xdf22, 0xdf22, 'MOVE CURSOR TO START OF LINE'),
        (0xdf25, 0xdf25, "POINT X TO 'OK', CR MESSAGE"),
        (0xdf28, 0xdf28, "PRINT 'OK', CR"),
        (0xdf2b, 0xdf2b, 'GO GET AN INPUT LINE'),
        (0xdf2e, 0xdf2e, 'THE LINE NUMBER FOR DIRECT MODE IS $FFFF'),
        (0xdf31, 0xdf31, 'SAVE IT IN CURLIN'),
        (0xdf33, 0xdf33, 'BRANCH IF LINE INPUT TERMINATED BY BREAK'),
        (0xdf35, 0xdf35, 'SAVE (X) AS CURRENT INPUT POINTER - THIS WILL'),
        (0xdf37, 0xdf37, 'GET NEXT CHARACTER FROM BASIC'),
        (0xdf39, 0xdf39, 'NO LINE INPUT - GET ANOTHER LINE'),
        (0xdf3b, 0xdf3b, 'BRANCH IF NUMER1C - THERE WAS A LINE NUMBER BEFORE'),
        (0xdf3d, 0xdf3d, 'GO CRUNCH LINE'),
        (0xdf40, 0xdf40, 'GO EXECUTE THE STATEMENT (LIVE KEYBOARD)'),
        (0xdf43, 0xdf43, 'GET A CHARACTER'),
        (0xdf45, 0xdf45, 'SEND TO CONSOLE OUT'),
        (0xdf48, 0xdf48, 'CONVERT LINE NUMBER TO BINARY'),
        (0xdf4b, 0xdf4b, 'GET CONVERTED LINE NUMBER'),
        (0xdf4d, 0xdf4d, 'STORE IT IN LINE INPUT HEADER'),
        (0xdf4f, 0xdf4f, 'GO CRUNCH THE LINE'),
        (0xdf52, 0xdf52, 'SAVE LINE LENGTH'),
        (0xdf54, 0xdf54, 'FIND OUT WHERE TO INSERT LINE'),
        (0xdf56, 0xdf56, 'BRANCH IF LINE NUMBER DOES NOT ALREADY EXIST'),
        (0xdf58, 0xdf58, 'GET ABSOLUTE ADDRESS OF LINE NUMBER'),
        (0xdf5a, 0xdf5a, 'SUBTRACT ADDRESS OF NEXT LINE NUMBER'),
        (0xdf5c, 0xdf5c, '* ADD TO CURRENT END OF PROGRAM - THIS WILL REMOVE'),
        (0xdf5e, 0xdf5e, '* THE LENGTH OF THIS LINE NUMBER FROM THE PROGRAM'),
        (0xdf60, 0xdf60, 'POINT U TO ADDRESS OF NEXT LINE NUMBER'),
        (0xdf62, 0xdf62, "GET A BYTE FROM WHAT'S LEFT OF PROGRAM"),
        (0xdf64, 0xdf64, 'MOVE IT DOWN'),
        (0xdf66, 0xdf66, 'COMPARE TO END OF BASIC PROGRAM'),
        (0xdf68, 0xdf68, 'BRANCH IF NOT AT END'),
        (0xdf6a, 0xdf6a, '* CHECK TO SEE IF THERE IS A LINE IN'),
        (0xdf6c, 0xdf6c, '* THE BUFFER AND BRANCH IF NONE'),
        (0xdf6e, 0xdf6e, '= SAVE CURRENT END OF'),
        (0xdf70, 0xdf70, '= PROGRAM IN V43'),
        (0xdf72, 0xdf72, '* ADD LENGTH OF CRUNCHED LINE,'),
        (0xdf74, 0xdf74, '* PROPOGATE CARRY AND SAVE NEW END'),
        (0xdf76, 0xdf76, '* OF PROGRAM IN V41'),
        (0xdf78, 0xdf78, "= MAKE SURE THERE'S ENOUGH RAM FOR THIS"),
        (0xdf7b, 0xdf7b, 'POINT U TO LINE TO BE INSERTED'),
        (0xdf7e, 0xdf7e, 'GET A BYTE FROM NEW LINE'),
        (0xdf80, 0xdf80, 'INSERT IT IN PROGRAM'),
        (0xdf82, 0xdf82, '* COMPARE TO ADDRESS OF END OF INSERTED'),
        (0xdf84, 0xdf84, '* LINE AND BRANCH IF NOT DONE'),
        (0xdf86, 0xdf86, '= GET AND SAVE'),
        (0xdf88, 0xdf88, '= END OF PROGRAM'),
        (0xdf8a, 0xdf8a, 'RESET INPUT POINTER, CLEAR VARIABLES, INITIALIZE'),
        (0xdf8c, 0xdf8c, 'ADJUST START OF NEXT LINE ADDRESSES'),
        (0xdf8e, 0xdf8e, "REENTER BASIC'S INPUT LOOP"),
        (0xdf90, 0xdf90, 'POINT X TO START OF PROGRAM'),
        (0xdf92, 0xdf92, 'GET ADDRESS OF NEXT LINE'),
        (0xdf94, 0xdf94, 'RETURN IF END OF PROGRAM'),
        (0xdf96, 0xdf96, 'POINT U TO START OF BASIC TEXT IN LINE'),
        (0xdf98, 0xdf98, '* SKIP THROUGH THE LINE UNTIL A'),
        (0xdf9a, 0xdf9a, '* ZERO (END OF LINE) IS FOUND'),
        (0xdf9c, 0xdf9c, 'SAVE THE NEW START OF NEXT LINE ADDRESS'),
        (0xdf9e, 0xdf9e, 'POINT X TO START OF NEXT LINE'),
        (0xdfa0, 0xdfa0, 'KEEP GOING'),
        (0xdfa2, 0xdfa2, 'GET THE LINE NUMBER TO FIND'),
        (0xdfa4, 0xdfa4, 'BEGINNING OF PROGRAM'),
        (0xdfa6, 0xdfa6, 'GET ADDRESS OF NEXT LINE NUMBER'),
        (0xdfa8, 0xdfa8, 'BRANCH IF END OF PROG'),
        (0xdfaa, 0xdfaa, 'IS IT A MATCH?'),
        (0xdfad, 0xdfad, 'CARRY SET IF LOWER; CARRY CLEAR IF MATCH'),
        (0xdfaf, 0xdfaf, 'X = ADDRESS OF NEXT LINE'),
        (0xdfb1, 0xdfb1, 'KEEP LOOPING FOR LINE NUMBER'),
        (0xdfb3, 0xdfb3, 'SET CARRY FLAG'),
        (0xdfb5, 0xdfb5, 'SAVE MATCH LINE NUMBER OR NUMBER OF LINE JUST AFTER'),
        (0xdfb8, 0xdfb8, 'BRANCH IF ARGUMENT GIVEN'),
        (0xdfba, 0xdfba, 'GET START OF BASIC'),
        (0xdfbc, 0xdfbc, '* PUT 2 ZERO BYTES THERE - ERASE'),
        (0xdfbe, 0xdfbe, '* THE BASIC PROGRAM'),
        (0xdfc0, 0xdfc0, 'AND THE NEXT ADDRESS IS NOW THE END OF PROGRAM'),
        (0xdfc2, 0xdfc2, 'GET START OF BASIC'),
        (0xdfc4, 0xdfc4, 'PUT INPUT POINTER ONE BEFORE START OF BASIC'),
        (0xdfc7, 0xdfc7, '* RESET START OF STRING VARIABLES'),
        (0xdfc9, 0xdfc9, '* TO TOP OF STRING SPACE'),
        (0xdfcb, 0xdfcb, "RESET 'DATA' POINTER TO START OF BASIC"),
        (0xdfce, 0xdfce, '* GET START OF VARIABLES AND USE IT'),
        (0xdfd0, 0xdfd0, '* TO RESET START OF ARRAYS'),
        (0xdfd2, 0xdfd2, 'RESET END OF ARRAYS'),
        (0xdfd4, 0xdfd4, '* RESET STRING STACK POINTER TO'),
        (0xdfd7, 0xdfd7, '* BOTTOM OF STRING STACK'),
        (0xdfd9, 0xdfd9, 'GET RETURN ADDRESS OFF STACK'),
        (0xdfdb, 0xdfdb, 'RESTORE STACK POINTER'),
        (0xdfde, 0xdfde, 'PUT A ZERO BYTE ON STACK - TO CLEAR ANY RETURN OF'),
        (0xdfe0, 0xdfe0, "RESET 'CONT' ADDRESS SO YOU"),
        (0xdfe2, 0xdfe2, "'CAN'T CONTINUE'"),
        (0xdfe4, 0xdfe4, 'CLEAR THE ARRAY DISABLE FLAG'),
        (0xdfe6, 0xdfe6, 'RETURN TO CALLING ROUTINE - THIS IS NECESSARY'),
        (0xdfe8, 0xdfe8, '* SAVE THE DISABLE ARRAY FLAG IN VO8'),
        (0xdfea, 0xdfea, '* DO NOT ALLOW THE INDEX VARIABLE TO BE AN ARRAY'),
        (0xdfec, 0xdfec, 'SET INDEX VARIABLE TO INITIAL VALUE'),
        (0xdfef, 0xdfef, "SEARCH THE STACK FOR 'FOR/NEXT' DATA"),
        (0xdff2, 0xdff2, 'PURGE RETURN ADDRESS OFF OF THE STACK'),
        (0xdff4, 0xdff4, 'BRANCH IF INDEX VARIABLE NOT ALREADY BEING USED'),
        (0xdff6, 0xdff6, "GET (ADDRESS + 18) OF MATCHED 'FOR/NEXT' DATA"),
        (0xdff8, 0xdff8, 'MOVE THE STACK POINTER TO THE BEGINNING OF THE'),
        (0xdffa, 0xdffa, '* CHECK FOR ROOM FOR 18 BYTES'),
        (0xdffc, 0xdffc, '* IN FREE RAM'),
        (0xdfff, 0xdfff, 'GET ADDR OF END OF SUBLINE IN X'),
        (0xe002, 0xe002, 'GET CURRENT LINE NUMBER'),
        (0xe004, 0xe004, 'SAVE LINE ADDR AND LINE NUMBER ON STACK'),
        (0xe006, 0xe006, "TOKEN FOR 'TO'"),
        (0xe008, 0xe008, "SYNTAX CHECK FOR 'TO'"),
        (0xe00b, 0xe00b, "'TM' ERROR IF INDEX VARIABLE SET TO STRING"),
        (0xe00e, 0xe00e, 'EVALUATE EXPRESSION'),
        (0xe011, 0xe011, 'GET FPA0 MANTISSA SIGN'),
        (0xe013, 0xe013, 'FORM A MASK TO SAVE DATA BITS OF HIGH ORDER MANTISSA'),
        (0xe015, 0xe015, 'PUT THE MANTISSA SIGN IN BIT 7 OF HIGH ORDER MANTISSA'),
        (0xe017, 0xe017, 'SAVE THE PACKED HIGH ORDER MANTISSA'),
        (0xe019, 0xe019, 'LOAD FOLLOWING ADDRESS INTO Y AS A RETURN'),
        (0xe01d, 0xe01d, 'ADDRESS - PUSH FPA0 ONTO THE STACK'),
        (0xe020, 0xe020, 'POINT X TO FLOATING POINT NUMBER 1.0 (DEFAULT STEP VALUE)'),
        (0xe023, 0xe023, 'MOVE (X) TO FPA0'),
        (0xe026, 0xe026, 'GET CURRENT INPUT CHARACTER'),
        (0xe028, 0xe028, 'STEP TOKEN'),
        (0xe02a, 0xe02a, "BRANCH IF NO 'STEP' VALUE"),
        (0xe02c, 0xe02c, 'GET A CHARACTER FROM BASIC'),
        (0xe02e, 0xe02e, 'EVALUATE NUMERIC EXPRESSION'),
        (0xe031, 0xe031, 'CHECK STATUS OF FPA0'),
        (0xe034, 0xe034, 'SAVE STATUS AND FPA0 ON THE STACK'),
        (0xe037, 0xe037, "* GET DESCRIPTOR POINTER FOR THE 'STEP'"),
        (0xe039, 0xe039, '* VARIABLE AND SAVE IT ON THE STACK'),
        (0xe03b, 0xe03b, "= GET THE 'FOR' FLAG AND"),
        (0xe03d, 0xe03d, '= SAVE IT ON THE STACK'),
        (0xe03f, 0xe03f, 'ENABLE IRQ,FIRQ'),
        (0xe041, 0xe041, 'CHECK FOR KEYBOARD BREAK'),
        (0xe043, 0xe043, "GET BASIC'S INPUT POINTER"),
        (0xe045, 0xe045, 'SAVE IT'),
        (0xe047, 0xe047, 'GET CURRENT INPUT CHAR & MOVE POINTER'),
        (0xe049, 0xe049, 'BRANCH IF END OF LINE'),
        (0xe04b, 0xe04b, 'CHECK FOR LINE SEPARATOR'),
        (0xe04d, 0xe04d, 'BRANCH IF COLON'),
        (0xe04f, 0xe04f, "'SYNTAX ERROR'-IF NOT LINE SEPARATOR"),
        (0xe052, 0xe052, 'GET MS BYTE OF ADDRESS OF NEXT BASIC LINE'),
        (0xe054, 0xe054, 'SAVE IN STOP/END FLAG - CAUSE A STOP IF'),
        (0xe056, 0xe056, "BRANCH TO 'STOP' - END OF PROGRAM"),
        (0xe058, 0xe058, 'GET CURRENT LINE NUMBER'),
        (0xe05a, 0xe05a, 'SAVE IN CURLIN'),
        (0xe05c, 0xe05c, 'SAVE ADDRESS OF FIRST BYTE OF LINE'),
        (0xe05e, 0xe05e, 'TEST THE TRACE FLAG'),
        (0xe060, 0xe060, 'BRANCH IF TRACE OFF'),
        (0xe062, 0xe062, '<LEFT HAND MARKER FOR TRON LINE NUMBER'),
        (0xe064, 0xe064, 'OUTPUT A CHARACTER'),
        (0xe067, 0xe067, 'GET MS BYTE OF LINE NUMBER'),
        (0xe069, 0xe069, 'CONVERT ACCD TO DECIMAL AND PRINT ON SCREEN'),
        (0xe06c, 0xe06c, '> RIGHT HAND MARKER FOR TRON LINE NUMBER'),
        (0xe06e, 0xe06e, 'OUTPUT A CHARACTER'),
        (0xe071, 0xe071, 'GET A CHARACTER FROM BASIC'),
        (0xe073, 0xe073, 'GO PROCESS COMMAND'),
        (0xe075, 0xe075, 'GO BACK TO MAIN LOOP'),
        (0xe077, 0xe077, 'RETURN IF END OF LINE (RTS - was BEQ LAE40)'),
        (0xe079, 0xe079, 'CHECK FOR TOKEN - BIT 7 SET (NEGATIVE)'),
        (0xe07a, 0xe07a, "BRANCH IF NOT A TOKEN - GO DO A 'LET' WHICH"),
        (0xe07e, 0xe07e, 'SECONDARY TOKEN'),
        (0xe082, 0xe082, 'SKIPF TOKEN - HIGHEST EXECUTABLE COMMAND IN BASIC'),
        (0xe084, 0xe084, "'SYNTAX ERROR' IF NON-EXECUTABLE TOKEN"),
        (0xe086, 0xe086, "GET ADDRESS OF BASIC'S COMMAND TABLE"),
        (0xe089, 0xe089, 'X2 (2 BYTE/JUMP ADDRESS) & DISCARD BIT 7'),
        (0xe08a, 0xe08a, 'SAVE COMMAND OFFSET IN ACCB'),
        (0xe08c, 0xe08c, 'NON X POINTS TO COMMAND JUMP ADDR'),
        (0xe08d, 0xe08d, 'GET AN INPUT CHAR'),
        (0xe08f, 0xe08f, 'GO DO A COMMAND'),
        (0xe091, 0xe091, 'GET AN INPUT CHAR'),
        (0xe093, 0xe093, 'TOKEN FOR "MID$"'),
        (0xe095, 0xe095, 'PROCESS MID$ REPLACEMENT'),
        (0xe099, 0xe099, 'SYNTAX ERROR'),
        (0xe09c, 0xe09c, 'BEGINNING OF PROGRAM ADDRESS'),
        (0xe09e, 0xe09e, 'MOVE TO ONE BYTE BEFORE PROGRAM'),
        (0xe0a0, 0xe0a0, 'SAVE NEW DATA POINTER'),
        (0xe0a3, 0xe0a3, 'GET A KEYSTROKE ENTRY'),
        (0xe0a6, 0xe0a6, 'RETURN IF NO INPUT'),
        (0xe0a8, 0xe0a8, 'CONTROL C? (BREAK)'),
        (0xe0aa, 0xe0aa, 'YES'),
        (0xe0ac, 0xe0ac, 'CONTROL S? (PAUSE)'),
        (0xe0ae, 0xe0ae, 'YES'),
        (0xe0b0, 0xe0b0, 'SAVE KEYSTROKE IN INKEY IMAGE'),
        (0xe0b3, 0xe0b3, 'GET A KEY'),
        (0xe0b6, 0xe0b6, 'BRANCH IF NO KEY DOWN'),
        (0xe0b8, 0xe0b8, 'CONTINUE - DO A BREAK CHECK'),
        (0xe0ba, 0xe0ba, 'GET CURRENT INPUT CHAR'),
        (0xe0be, 0xe0be, 'SET CARRY FLAG'),
        (0xe0c0, 0xe0c0, 'BRANCH IF ARGUMENT EXISTS'),
        (0xe0c2, 0xe0c2, '* SAVE CURRENT POSITION OF'),
        (0xe0c4, 0xe0c4, "* BASIC'S INPUT POINTER"),
        (0xe0c6, 0xe0c6, 'ROTATE CARRY INTO BIT 7 OF STOP/END FLAG'),
        (0xe0c8, 0xe0c8, 'PURGE RETURN ADDRESS OFF STACK'),
        (0xe0ca, 0xe0ca, 'GET CURRENT LINE NUMBER'),
        (0xe0cc, 0xe0cc, 'DIRECT MODE?'),
        (0xe0cf, 0xe0cf, 'YES'),
        (0xe0d1, 0xe0d1, 'SAVE CURRENT LINE NUMBER'),
        (0xe0d3, 0xe0d3, '* GET AND SAVE CURRENT POSITION'),
        (0xe0d5, 0xe0d5, "* OF BASIC'S INPUT POINTER"),
        (0xe0d7, 0xe0d7, "POINT TO CR, 'BREAK' MESSAGE"),
        (0xe0da, 0xe0da, 'CHECK STOP/END FLAG'),
        (0xe0dc, 0xe0dc, 'BRANCH TO MAIN LOOP OF BASIC IF END'),
        (0xe0e0, 0xe0e0, "PRINT 'BREAK AT ####' AND GO TO"),
        (0xe0e3, 0xe0e3, 'RETURN IF ARGUMENT GIVEN'),
        (0xe0e5, 0xe0e5, "'CAN'T CONTINUE' ERROR"),
        (0xe0e7, 0xe0e7, 'GET CONTINUE ADDRESS (INPUT POINTER)'),
        (0xe0e9, 0xe0e9, "'CN' ERROR IF CONTINUE ADDRESS = 0"),
        (0xe0ed, 0xe0ed, "RESET BASIC'S INPUT POINTER"),
        (0xe0ef, 0xe0ef, 'GET LINE NUMBER'),
        (0xe0f1, 0xe0f1, 'RESET CURRENT LINE NUMBER'),
        (0xe0f4, 0xe0f4, 'BRANCH IF NO ARGUMENT'),
        (0xe0f6, 0xe0f6, 'EVALUATE ARGUMENT'),
        (0xe0f9, 0xe0f9, 'SAVE AMOUNT OF STRING SPACE ON STACK'),
        (0xe0fb, 0xe0fb, 'GET CURRENT TOP OF CLEARED SPACE'),
        (0xe0fd, 0xe0fd, 'GET CURRENT INPUT CHARACTER'),
        (0xe0ff, 0xe0ff, 'BRANCH IF NO NEW TOP OF CLEARED SPACE'),
        (0xe101, 0xe101, 'SYNTAX CHECK FOR COMMA'),
        (0xe104, 0xe104, 'EVALUATE EXPRESSlON; RETURN VALUE IN X'),
        (0xe107, 0xe107, 'X = TOP OF CLEARED SPACE'),
        (0xe109, 0xe109, 'COMPARE TO TOP OF RAM'),
        (0xe10b, 0xe10b, "'OM' ERROR IF > TOP OF RAM"),
        (0xe10d, 0xe10d, 'ACCD = TOP OF CLEARED SPACE'),
        (0xe10f, 0xe10f, 'SUBTRACT OUT AMOUNT OF CLEARED SPACE'),
        (0xe111, 0xe111, "'OM' ERROR IF FREE MEM < 0"),
        (0xe113, 0xe113, 'U = BOTTOM OF CLEARED SPACE'),
        (0xe115, 0xe115, 'SUBTRACT OUT STACK BUFFER'),
        (0xe118, 0xe118, "'OM' ERROR IF FREE MEM < 0"),
        (0xe11a, 0xe11a, 'SUBTRACT OUT START OF VARIABLES'),
        (0xe11c, 0xe11c, "'OM' ERROR IF FREE MEM < 0"),
        (0xe11e, 0xe11e, 'SAVE NEW BOTTOM OF CLEARED SPACE'),
        (0xe120, 0xe120, 'SAVE NEW TOP OF CLEARED SPACE'),
        (0xe122, 0xe122, 'ERASE ALL VARIABLES, INITIALIZE POINTERS, ETC'),
        (0xe125, 0xe125, "'OM' ERROR"),
        (0xe128, 0xe128, '* GET CURRENT INPUT CHARACTER'),
        (0xe12a, 0xe12a, '* IF NO LINE NUMBER'),
        (0xe12e, 0xe12e, 'ERASE ALL VARIABLES'),
        (0xe131, 0xe131, "'GOTO' THE RUN ADDRESS"),
        (0xe133, 0xe133, 'SAVE INPUT CHARACTER IN ACCB'),
        (0xe135, 0xe135, 'GET A CHARACTER FROM BASIC'),
        (0xe137, 0xe137, "'TO' TOKEN"),
        (0xe139, 0xe139, 'BRANCH IF GOTO'),
        (0xe13b, 0xe13b, "'SUB' TOKEN"),
        (0xe13d, 0xe13d, "'SYNTAX ERROR' IF NEITHER"),
        (0xe13f, 0xe13f, '=ROOM FOR 6'),
        (0xe141, 0xe141, '=BYTES ON STACK?'),
        (0xe144, 0xe144, '* SAVE CURRENT BASIC INPUT POINTER, LINE'),
        (0xe146, 0xe146, '* NUMBER AND SUB TOKEN ON STACK'),
        (0xe14c, 0xe14c, "GO DO A 'GOTO'"),
        (0xe14e, 0xe14e, "JUMP BACK TO BASIC'S MAIN LOOP"),
        (0xe151, 0xe151, 'GET CURRENT INPUT CHAR'),
        (0xe153, 0xe153, 'GET LINE NUMBER TO BINARY IN BINVAL'),
        (0xe156, 0xe156, "ADVANCE BASIC'S POINTER TO END OF LINE"),
        (0xe158, 0xe158, 'POINT TO START OF NEXT LINE'),
        (0xe15a, 0xe15a, 'GET THE LINE NUMBER TO RUN'),
        (0xe15c, 0xe15c, 'COMPARE TO CURRENT LINE NUMBER'),
        (0xe15f, 0xe15f, "IF REO'D LINE NUMBER IS > CURRENT LINE NUMBER,"),
        (0xe161, 0xe161, 'BEGINNING OF PROGRAM'),
        (0xe163, 0xe163, 'GO FIND A LINE NUMBER'),
        (0xe166, 0xe166, "'UNDEFINED LINE NUMBER'"),
        (0xe168, 0xe168, 'MOVE BACK TO JUST BEFORE START OF LINE'),
        (0xe16a, 0xe16a, "RESET BASIC'S INPUT POINTER"),
        (0xe16d, 0xe16d, 'EXIT ROUTINE IF ARGUMENT GIVEN'),
        (0xe16f, 0xe16f, '* PUT AN ILLEGAL VARIABLE NAME IN FIRST BYTE OF'),
        (0xe171, 0xe171, "* VARDES WHICH WILL CAUSE 'FOR/NEXT' DATA ON THE"),
        (0xe173, 0xe173, 'CHECK FOR RETURN DATA ON THE STACK'),
        (0xe176, 0xe176, 'RESET STACK POINTER - PURGE TWO RETURN ADDRESSES'),
        (0xe178, 0xe178, 'SUB TOKEN - $80'),
        (0xe17a, 0xe17a, "BRANCH IF 'RETURN' FROM SUBROUTINE"),
        (0xe17c, 0xe17c, "ERROR #2 'RETURN WITHOUT GOSUB'"),
        (0xe17e, 0xe17e, 'SKIP TWO BYTES'),
        (0xe17f, 0xe17f, "ERROR #7 'UNDEFINED LINE NUMBER'"),
        (0xe181, 0xe181, 'JUMP TO ERROR HANDLER'),
        (0xe184, 0xe184, "'SYNTAX ERROR'"),
        (0xe187, 0xe187, '* RESTORE VALUES OF CURRENT LINE NUMBER AND'),
        (0xe189, 0xe189, "* BASIC'S INPUT POINTER FOR THIS SUBROUTINE"),
        (0xe18b, 0xe18b, '* AND LOAD ACCA WITH SUB TOKEN ($A6)'),
        (0xe18d, 0xe18d, 'MOVE INPUT POINTER TO END OF SUBLINE OR LINE'),
        (0xe18f, 0xe18f, 'SKIP 2 BYTES'),
        (0xe190, 0xe190, 'MOVE INPUT POINTER TO END OF LINE'),
        (0xe192, 0xe192, "RESET BASIC'S INPUT POINTER"),
        (0xe195, 0xe195, 'COLON = SUBLINE TERMINATOR CHARACTER'),
        (0xe197, 0xe197, 'SKPILD SKIP ONE BYTE; LDA #$5F'),
        (0xe198, 0xe198, '0 = LINE TERMINATOR CHARACTER'),
        (0xe199, 0xe199, 'TEMP STORE PRIMARY TERMINATOR CHARACTER'),
        (0xe19b, 0xe19b, '0 (END OF LINE) = ALTERNATE TERM. CHAR.'),
        (0xe19c, 0xe19c, "LOAD X W/BASIC'S INPUT POINTER"),
        (0xe19e, 0xe19e, '* CHANGE TERMINATOR CHARACTER'),
        (0xe1a0, 0xe1a0, '* FROM ACCB TO CHARAC - SAVE OLD TERMINATOR'),
        (0xe1a2, 0xe1a2, 'SWAP PRIMARY AND SECONDARY TERMINATORS'),
        (0xe1a4, 0xe1a4, 'GET NEXT INPUT CHARACTER'),
        (0xe1a6, 0xe1a6, 'RETURN IF 0 (END OF LINE)'),
        (0xe1a8, 0xe1a8, 'SAVE TERMINATOR ON STACK'),
        (0xe1aa, 0xe1aa, 'COMPARE TO INPUT CHARACTER'),
        (0xe1ac, 0xe1ac, 'RETURN IF EQUAL'),
        (0xe1ae, 0xe1ae, 'MOVE POINTER UP ONE'),
        (0xe1b0, 0xe1b0, 'CHECK FOR DOUBLE QUOTES'),
        (0xe1b2, 0xe1b2, 'BRANCH IF " - TOGGLE TERMINATOR CHARACTERS'),
        (0xe1b4, 0xe1b4, '* CHECK FOR $FF AND BRANCH IF'),
        (0xe1b5, 0xe1b5, '* NOT SECONDARY TOKEN'),
        (0xe1b7, 0xe1b7, 'MOVE INPUT POINTER 1 MORE IF SECONDARY'),
        (0xe1b9, 0xe1b9, 'TOKEN FOR IF?'),
        (0xe1bb, 0xe1bb, 'NO - GET ANOTHER INPUT CHARACTER'),
        (0xe1bd, 0xe1bd, 'INCREMENT IF COUNTER - KEEP TRACK OF HOW MANY'),
        (0xe1bf, 0xe1bf, 'GET ANOTHER INPUT CHARACTER'),
        (0xe1c1, 0xe1c1, 'EVALUATE NUMERIC EXPRESSION'),
        (0xe1c4, 0xe1c4, 'GET CURRENT INPUT CHARACTER'),
        (0xe1c6, 0xe1c6, 'TOKEN FOR GO'),
        (0xe1c8, 0xe1c8, "TREAT 'GO' THE SAME AS 'THEN'"),
        (0xe1ca, 0xe1ca, 'TOKEN FOR THEN'),
        (0xe1cc, 0xe1cc, 'DO A SYNTAX CHECK ON ACCB'),
        (0xe1cf, 0xe1cf, 'CHECK FOR TRUE/FALSE - FALSE IF FPA0 EXPONENT = ZERO'),
        (0xe1d1, 0xe1d1, 'BRANCH IF CONDITION TRUE'),
        (0xe1d3, 0xe1d3, 'CLEAR FLAG - KEEP TRACK OF WHICH NESTED ELSE STATEMENT'),
        (0xe1d5, 0xe1d5, "MOVE BASIC'S POINTER TO END OF SUBLINE"),
        (0xe1d7, 0xe1d7, '* CHECK TO SEE IF END OF LINE OR SUBLINE'),
        (0xe1d8, 0xe1d8, '* AND RETURN IF END OF LINE'),
        (0xe1da, 0xe1da, 'GET AN INPUT CHARACTER FROM BASIC'),
        (0xe1dc, 0xe1dc, 'TOKEN FOR ELSE'),
        (0xe1de, 0xe1de, "IGNORE ALL DATA EXCEPT 'ELSE' UNTIL"),
        (0xe1e0, 0xe1e0, 'CHECK TO SEE IF YOU MUST SEARCH ANOTHER SUBLINE'),
        (0xe1e2, 0xe1e2, "BRANCH TO SEARCH ANOTHER SUBLINE FOR 'ELSE'"),
        (0xe1e4, 0xe1e4, 'GET AN INPUT CHARACTER FROM BASIC'),
        (0xe1e6, 0xe1e6, 'GET CURRENT INPUT CHARACTER'),
        (0xe1e8, 0xe1e8, "BRANCH TO 'GOTO' IF NUMERIC CHARACTER"),
        (0xe1ec, 0xe1ec, 'RETURN TO MAIN INTERPRETATION LOOP'),
        (0xe1ef, 0xe1ef, 'EVALUATE EXPRESSION'),
        (0xe1f2, 0xe1f2, 'TOKEN FOR GO'),
        (0xe1f4, 0xe1f4, 'SYNTAX CHECK FOR GO'),
        (0xe1f7, 0xe1f7, 'SAVE NEW TOKEN (TO,SUB)'),
        (0xe1f9, 0xe1f9, 'TOKEN FOR SUB?'),
        (0xe1fb, 0xe1fb, 'YES'),
        (0xe1fd, 0xe1fd, 'TOKEN FOR TO?'),
        (0xe1ff, 0xe1ff, "'SYNTAX' ERROR IF NOT 'SUB' OR 'TO'"),
        (0xe201, 0xe201, 'DECREMENT IS BYTE OF MANTISSA OF FPA0 - THIS'),
        (0xe203, 0xe203, 'BRANCH IF NOT AT THE PROPER GOTO OR GOSUB LINE NUMBER'),
        (0xe205, 0xe205, "GET BACK THE TOKEN FOLLOWING 'GO'"),
        (0xe207, 0xe207, "GO DO A 'GOTO' OR 'GOSUB'"),
        (0xe20a, 0xe20a, 'GET A CHARACTER FROM BASIC'),
        (0xe20c, 0xe20c, 'CONVERT BASIC LINE NUMBER TO BINARY'),
        (0xe20e, 0xe20e, 'IS CHARACTER FOLLOWING LINE NUMBER A COMMA?'),
        (0xe210, 0xe210, 'YES'),
        (0xe212, 0xe212, 'IF NOT, FALL THROUGH TO NEXT COMMAND'),
        (0xe214, 0xe214, 'DEFAULT LINE NUMBER OF ZERO'),
        (0xe216, 0xe216, 'SAVE IT IN BINVAL'),
        (0xe218, 0xe218, 'RETURN IF NOT NUMERIC CHARACTER'),
        (0xe21a, 0xe21a, 'MASK OFF ASCII'),
        (0xe21c, 0xe21c, 'SAVE DIGIT IN VO1'),
        (0xe21e, 0xe21e, 'GET ACCUMULATED LINE NUMBER VALUE'),
        (0xe220, 0xe220, 'LARGEST LINE NUMBER IS $F9FF (63999) -'),
        (0xe222, 0xe222, "'SYNTAX' ERROR IF TOO BIG"),
        (0xe225, 0xe225, '* TIMES 2'),
        (0xe226, 0xe226, '='),
        (0xe227, 0xe227, '= TIMES 4'),
        (0xe228, 0xe228, 'ADD 1 = TIMES 5'),
        (0xe22b, 0xe22b, '* TIMES 10'),
        (0xe22c, 0xe22c, 'ADD NEXT DIGIT'),
        (0xe22e, 0xe22e, 'PROPAGATE CARRY'),
        (0xe230, 0xe230, 'SAVE NEW ACCUMULATED LINE NUMBER'),
        (0xe232, 0xe232, 'GET NEXT CHARACTER FROM BASIC'),
        (0xe234, 0xe234, 'LOOP- PROCESS NEXT DIGIT'),
        (0xe236, 0xe236, 'FIND TARGET VARIABLE DESCRIPTOR'),
        (0xe239, 0xe239, 'SAVE DESCRIPTOR ADDRESS OF 1ST EXPRESSION'),
        (0xe23b, 0xe23b, 'TOKEN FOR "="'),
        (0xe23d, 0xe23d, "DO A SYNTAX CHECK FOR '='"),
        (0xe240, 0xe240, '* GET VARIABLE TYPE AND'),
        (0xe242, 0xe242, '* SAVE ON THE STACK'),
        (0xe244, 0xe244, 'EVALUATE EXPRESSION'),
        (0xe247, 0xe247, '* REGET VARIABLE TYPE OF 1ST EXPRESSION AND'),
        (0xe249, 0xe249, '* SET CARRY IF STRING'),
        (0xe24a, 0xe24a, 'TYPE CHECK-TM ERROR IF VARIABLE TYPES ON'),
        (0xe24d, 0xe24d, 'GO PUT FPA0 INTO VARIABLE DESCRIPTOR IF NUMERIC'),
        (0xe251, 0xe251, 'POINT X TO DESCRIPTOR OF REPLACEMENT STRING'),
        (0xe253, 0xe253, 'LOAD ACCD WITH START OF STRING SPACE'),
        (0xe255, 0xe255, 'IS THE STRING IN STRING SPACE?'),
        (0xe258, 0xe258, "BRANCH IF IT'S NOT IN THE STRING SPACE"),
        (0xe25a, 0xe25a, 'COMPARE DESCRIPTOR ADDRESS TO START OF VARIABLES'),
        (0xe25c, 0xe25c, 'BRANCH IF DESCRIPTOR ADDRESS NOT IN VARIABLES'),
        (0xe25e, 0xe25e, 'GET LENGTH OF REPLACEMENT STRING'),
        (0xe260, 0xe260, 'RESERVE ACCB BYTES OF STRING SPACE'),
        (0xe263, 0xe263, 'GET DESCRIPTOR ADDRESS BACK'),
        (0xe265, 0xe265, 'MOVE STRING INTO STRING SPACE'),
        (0xe268, 0xe268, 'POINT X TO TEMP STRING DESCRIPTOR ADDRESS'),
        (0xe26b, 0xe26b, 'SAVE STRING DESCRIPTOR ADDRESS IN V4D'),
        (0xe26d, 0xe26d, 'REMOVE STRING DESCRIPTOR IF LAST ONE'),
        (0xe270, 0xe270, 'POINT U TO REPLACEMENT DESCRIPTOR ADDRESS'),
        (0xe272, 0xe272, 'GET TARGET DESCRIPTOR ADDRESS'),
        (0xe274, 0xe274, 'GET LENGTH AND START OF REPLACEMENT STRING'),
        (0xe276, 0xe276, '* SAVE STRING LENGTH AND START IN'),
        (0xe278, 0xe278, '* TARGET DESCRIPTOR LOCATION'),
        (0xe27c, 0xe27c, '?REDO MESSAGE'),
        (0xe283, 0xe283, 'JMP TO ERROR HANDLER'),
        (0xe286, 0xe286, '= GET THE INPUT FLAG AND BRANCH'),
        (0xe288, 0xe288, "= IF 'INPUT'"),
        (0xe28a, 0xe28a, '* GET LINE NUMBER WHERE THE ERROR OCCURRED'),
        (0xe28c, 0xe28c, '* AND USE IT AS THE CURRENT LINE NUMBER'),
        (0xe28e, 0xe28e, "'SYNTAX ERROR'"),
        (0xe291, 0xe291, "* POINT X TO '?REDO' AND PRINT"),
        (0xe294, 0xe294, '* IT ON THE SCREEN'),
        (0xe297, 0xe297, '= GET THE SAVED ABSOLUTE ADDRESS OF'),
        (0xe299, 0xe299, '= INPUT POINTER AND RESTORE IT'),
        (0xe29c, 0xe29c, "'ID' ERROR"),
        (0xe29e, 0xe29e, 'GET CURRENT LINE NUMBER'),
        (0xe2a0, 0xe2a0, 'ADD ONE'),
        (0xe2a2, 0xe2a2, "'ID' ERROR BRANCH IF DIRECT MODE"),
        (0xe2a4, 0xe2a4, 'GET SOME INPUT DATA - WAS LB002'),
        (0xe2a7, 0xe2a7, 'CHECK FOR PROMPT STRING DELIMITER'),
        (0xe2a9, 0xe2a9, 'BRANCH IF NO PROMPT STRING'),
        (0xe2ab, 0xe2ab, 'PUT PROMPT STRING ON STRING STACK'),
        (0xe2b0, 0xe2b0, '* DO A SYNTAX CHECK FOR SEMICOLON'),
        (0xe2b3, 0xe2b3, 'PRINT MESSAGE TO CONSOLE OUT'),
        (0xe2b6, 0xe2b6, "POINT TO BASIC'S LINE BUFFER"),
        (0xe2b9, 0xe2b9, 'CLEAR 1ST BYTE - FLAG TO INDICATE NO DATA'),
        (0xe2bb, 0xe2bb, 'INPUT A STRING TO LINE BUFFER'),
        (0xe2bd, 0xe2bd, '* INSERT A COMMA AT THE END'),
        (0xe2bf, 0xe2bf, '* OF THE LINE INPUT BUFFER'),
        (0xe2c3, 0xe2c3, 'SEND A "?" TO CONSOLE OUT'),
        (0xe2c6, 0xe2c6, "SEND A 'SPACE' TO CONSOLE OUT"),
        (0xe2c9, 0xe2c9, 'GO READ IN A BASIC LINE'),
        (0xe2cc, 0xe2cc, 'BRANCH IF ENTER KEY ENDED ENTRY'),
        (0xe2ce, 0xe2ce, 'PURGE TWO RETURN ADDRESSES OFF THE STACK'),
        (0xe2d0, 0xe2d0, "GO DO A 'STOP' IF BREAK KEY ENDED LINE ENTRY"),
        (0xe2d3, 0xe2d3, "'INPUT PAST END OF FILE' ERROR"),
        (0xe2d6, 0xe2d6, "GET 'READ' START ADDRESS"),
        (0xe2d8, 0xe2d8, 'SKIP ONE BYTE - LDA #*$4F'),
        (0xe2d9, 0xe2d9, "'INPUT' ENTRY POINT: INPUT FLAG = 0"),
        (0xe2da, 0xe2da, 'SET INPUT FLAG; 0 = INPUT: <> 0 = READ'),
        (0xe2dc, 0xe2dc, "SAVE 'READ' START ADDRESS/'INPUT' BUFFER START"),
        (0xe2de, 0xe2de, 'EVALUATE A VARIABLE'),
        (0xe2e1, 0xe2e1, 'SAVE DESCRIPTOR ADDRESS'),
        (0xe2e3, 0xe2e3, "* GET BASIC'S INPUT POINTER"),
        (0xe2e5, 0xe2e5, '* AND SAVE IT'),
        (0xe2e7, 0xe2e7, "GET 'READ' ADDRESS START/'INPUT' BUFFER POINTER"),
        (0xe2e9, 0xe2e9, 'GET A CHARACTER FROM THE BASIC PROGRAM'),
        (0xe2eb, 0xe2eb, 'BRANCH IF NOT END OF LINE'),
        (0xe2ed, 0xe2ed, '* CHECK INPUT FLAG AND BRANCH'),
        (0xe2ef, 0xe2ef, '* IF LOOKING FOR DATA (READ)'),
        (0xe2f1, 0xe2f1, "SEND A '?' TO CONSOLE OUT"),
        (0xe2f4, 0xe2f4, 'FILL INPUT BUFFER FROM CONSOLE IN'),
        (0xe2f6, 0xe2f6, "RESET BASIC'S INPUT POINTER"),
        (0xe2f8, 0xe2f8, 'GET A CHARACTER FROM BASIC'),
        (0xe2fa, 0xe2fa, '* CHECK VARIABLE TYPE AND'),
        (0xe2fc, 0xe2fc, '* BRANCH IF NUMERIC'),
        (0xe2fe, 0xe2fe, 'LOAD X WITH CURRENT BASIC INPUT POINTER'),
        (0xe300, 0xe300, 'SAVE CURRENT INPUT CHARACTER'),
        (0xe302, 0xe302, 'CHECK FOR STRING DELIMITER'),
        (0xe304, 0xe304, 'BRANCH IF STRING DELIMITER'),
        (0xe306, 0xe306, 'BACK UP POINTER'),
        (0xe308, 0xe308, '* ZERO = END OF LINE CHARACTER'),
        (0xe309, 0xe309, '* SAVE AS TERMINATOR'),
        (0xe30b, 0xe30b, 'SET UP PRINT PARAMETERS'),
        (0xe30e, 0xe30e, 'END OF SUBLINE CHARACTER'),
        (0xe310, 0xe310, 'SAVE AS TERMINATOR I'),
        (0xe312, 0xe312, 'COMMA'),
        (0xe314, 0xe314, 'SAVE AS TERMINATOR 2'),
        (0xe316, 0xe316, 'STRIP A STRING FROM THE INPUT BUFFER'),
        (0xe319, 0xe319, 'MOVE INPUT POINTER TO END OF STRING'),
        (0xe31c, 0xe31c, 'PUT A STRING INTO THE STRING SPACE IF NECESSARY'),
        (0xe31f, 0xe31f, 'CHECK FOR ANOTHER DATA ITEM'),
        (0xe321, 0xe321, 'CONVERT AN ASCII STRING TO FP NUMBER'),
        (0xe324, 0xe324, 'PACK FPA0 AND STORE IT IN ADDRESS IN VARDES -'),
        (0xe327, 0xe327, 'GET CURRENT INPUT CHARACTER'),
        (0xe329, 0xe329, 'BRANCH IF END OF LINE'),
        (0xe32b, 0xe32b, 'CHECK FOR A COMMA'),
        (0xe32d, 0xe32d, "BAD FILE DATA' ERROR OR RETRY"),
        (0xe331, 0xe331, '* GET CURRENT INPUT'),
        (0xe333, 0xe333, '* POINTER (USED AS A DATA POINTER) AND SAVE IT'),
        (0xe335, 0xe335, '* RESET INPUT POINTER TO INPUT OR'),
        (0xe337, 0xe337, '* READ STATEMENT'),
        (0xe339, 0xe339, 'GET CURRENT CHARACTER FROM BASIC'),
        (0xe33b, 0xe33b, 'BRANCH IF END OF LINE - EXIT COMMAND'),
        (0xe33d, 0xe33d, 'SYNTAX CHECK FOR COMMA'),
        (0xe340, 0xe340, 'GET ANOTHER INPUT OR READ ITEM'),
        (0xe342, 0xe342, "RESET BASIC'S INPUT POINTER"),
        (0xe344, 0xe344, 'SEARCH FOR END OF CURRENT LINE OR SUBLINE'),
        (0xe347, 0xe347, 'MOVE X ONE PAST END OF LINE'),
        (0xe349, 0xe349, 'CHECK FOR END OF LINE'),
        (0xe34a, 0xe34a, 'BRANCH IF END OF SUBLINE'),
        (0xe34c, 0xe34c, "'OUT OF DATA' ERROR"),
        (0xe34e, 0xe34e, 'GET NEXT 2 CHARACTERS'),
        (0xe350, 0xe350, "'OD' ERROR IF END OF PROGRAM"),
        (0xe352, 0xe352, 'GET BASIC LINE NUMBER AND'),
        (0xe354, 0xe354, 'SAVE IT IN DATTXT'),
        (0xe356, 0xe356, 'GET AN INPUT CHARACTER'),
        (0xe358, 0xe358, 'DATA TOKEN?'),
        (0xe35a, 0xe35a, 'NO - KEEP LOOKING'),
        (0xe35c, 0xe35c, 'YES'),
        (0xe35e, 0xe35e, 'GET DATA POINTER'),
        (0xe360, 0xe360, '* CHECK INPUT FLAG'),
        (0xe362, 0xe362, '* SAVE NEW DATA POINTER IF READ'),
        (0xe366, 0xe366, "= CHECK NEXT CHARACTER IN 'INPUT' BUFFER"),
        (0xe368, 0xe368, '='),
        (0xe36a, 0xe36a, "POINT X TO '?EXTRA IGNORED'"),
        (0xe36d, 0xe36d, 'PRINT THE MESSAGE'),
        (0xe371, 0xe371, 'IGNORED" ?EXTRA IGNORED MESSAGE'),
        (0xe381, 0xe381, 'BRANCH IF ARGUMENT GIVEN'),
        (0xe383, 0xe383, 'X = 0: DEFAULT FOR NO ARGUMENT'),
        (0xe387, 0xe387, 'EVALUATE AN ALPHA EXPRESSION'),
        (0xe38a, 0xe38a, 'SAVE VARIABLE DESCRIPTOR POINTER'),
        (0xe38c, 0xe38c, "GO SCAN FOR 'FOR/NEXT' DATA ON STACK"),
        (0xe38f, 0xe38f, 'BRANCH IF DATA FOUND'),
        (0xe391, 0xe391, "'NEXT WITHOUT FOR' ERROR (SHOULD BE CLRB)"),
        (0xe393, 0xe393, 'PROCESS ERROR'),
        (0xe395, 0xe395, "POINT S TO START OF 'FOR/NEXT' DATA"),
        (0xe397, 0xe397, 'POINT X TO FP VALUE OF STEP'),
        (0xe399, 0xe399, 'COPY A FP NUMBER FROM (X) TO FPA0'),
        (0xe39c, 0xe39c, 'GET THE DIRECTION OF STEP'),
        (0xe39e, 0xe39e, 'SAVE IT AS THE SIGN OF FPA0'),
        (0xe3a0, 0xe3a0, 'POINT (X) TO INDEX VARIABLE DESCRIPTOR'),
        (0xe3a2, 0xe3a2, 'ADD (X) TO FPA0 (STEP TO INDEX)'),
        (0xe3a5, 0xe3a5, 'PACK FPA0 AND STORE IT IN ADDRESS'),
        (0xe3a8, 0xe3a8, 'POINT (X) TO TERMINAL VALUE OF INDEX'),
        (0xe3aa, 0xe3aa, 'COMPARE CURRENT INDEX VALUE TO TERMINAL VALUE OF INDEX'),
        (0xe3ad, 0xe3ad, 'ACCB = 0 IF TERMINAL VALUE=CURRENT VALUE AND STEP=0 OR IF'),
        (0xe3af, 0xe3af, "BRANCH IF 'FOR/NEXT' LOOP DONE"),
        (0xe3b1, 0xe3b1, '* GET LINE NUMBER AND'),
        (0xe3b3, 0xe3b3, '* BASIC POINTER OF'),
        (0xe3b5, 0xe3b5, '* STATEMENT FOLLOWING THE'),
        (0xe3b8, 0xe3b8, '* PROPER FOR STATEMENT'),
        (0xe3ba, 0xe3ba, 'JUMP BACK TO COMMAND INTEPR. LOOP'),
        (0xe3bd, 0xe3bd, "PULL THE 'FOR-NEXT' DATA OFF THE STACK"),
        (0xe3c0, 0xe3c0, 'GET CURRENT INPUT CHARACTER'),
        (0xe3c2, 0xe3c2, 'CHECK FOR ANOTHER ARGUMENT'),
        (0xe3c4, 0xe3c4, 'RETURN IF NONE'),
        (0xe3c6, 0xe3c6, 'GET NEXT CHARACTER FROM BASIC'),
        (0xe3c8, 0xe3c8, "BSR SIMULATES A CALL TO 'NEXT' FROM COMMAND LOOP"),
        (0xe3ca, 0xe3ca, 'EVALUATE EXPRESSION AND DO A TYPE CHECK FOR NUMERIC'),
        (0xe3cc, 0xe3cc, 'CLEAR CARRY FLAG'),
        (0xe3ce, 0xe3ce, 'OP CODE OF TST $1A01 - SKIP TWO BYTES (DO NOT CHANGE CARRY FLAG)'),
        (0xe3cf, 0xe3cf, 'SET CARRY'),
        (0xe3d1, 0xe3d1, 'TEST TYPE FLAG; DO NOT CHANGE CARRY'),
        (0xe3d3, 0xe3d3, 'BRANCH IF STRING'),
        (0xe3d5, 0xe3d5, 'RETURN ON PLUS'),
        (0xe3d7, 0xe3d7, "SKIP 2 BYTES - 'TM' ERROR"),
        (0xe3d8, 0xe3d8, 'RETURN ON MINUS'),
        (0xe3da, 0xe3da, "'TYPE M1SMATCH' ERROR"),
        (0xe3dc, 0xe3dc, 'PROCESS ERROR'),
        (0xe3df, 0xe3df, 'BACK UP INPUT POINTER'),
        (0xe3e1, 0xe3e1, 'END OF OPERATION PRECEDENCE FLAG'),
        (0xe3e2, 0xe3e2, 'SKIP TWO BYTES'),
        (0xe3e3, 0xe3e3, 'SAVE FLAG (RELATIONAL OPERATOR FLAG)'),
        (0xe3e5, 0xe3e5, 'SAVE FLAG (PRECEDENCE FLAG)'),
        (0xe3e9, 0xe3e9, '* SEE IF ROOM IN FREE RAM FOR (B) WORDS'),
        (0xe3ec, 0xe3ec, 'GO EVALUATE AN EXPRESSION'),
        (0xe3ef, 0xe3ef, 'RESET RELATIONAL OPERATOR FLAG'),
        (0xe3f1, 0xe3f1, 'GET CURRENT INPUT CHARACTER'),
        (0xe3f3, 0xe3f3, 'TOKEN FOR >'),
        (0xe3f5, 0xe3f5, 'BRANCH IF LESS THAN RELATIONAL OPERATORS'),
        (0xe3f9, 0xe3f9, '* BRANCH IF GREATER THAN RELATIONAL OPERATORS'),
        (0xe3fb, 0xe3fb, "SET CARRY IF '>'"),
        (0xe3fd, 0xe3fd, 'CARRY TO BIT 0'),
        (0xe3fe, 0xe3fe, '* CARRY SET IF'),
        (0xe400, 0xe400, '* TRELFL = ACCA'),
        (0xe402, 0xe402, 'BRANCH IF SYNTAX ERROR : == << OR >>'),
        (0xe404, 0xe404, 'BIT 0: >, BIT 1 =, BIT 2: <'),
        (0xe406, 0xe406, 'GET AN INPUT CHARACTER'),
        (0xe408, 0xe408, 'CHECK FOR ANOTHER RELATIONAL OPERATOR'),
        (0xe40a, 0xe40a, 'GET RELATIONAL OPERATOR FLAG'),
        (0xe40c, 0xe40c, 'BRANCH IF RELATIONAL COMPARISON'),
        (0xe40e, 0xe40e, 'BRANCH IF > RELATIONAL OPERATOR'),
        (0xe412, 0xe412, 'SEVEN ARITHMETIC/LOGICAL OPERATORS'),
        (0xe414, 0xe414, 'BRANCH IF NOT ARITHMETIC/LOGICAL OPERATOR'),
        (0xe416, 0xe416, 'ADD CARRY, NUMERIC FLAG AND MODIFIED TOKEN NUMBER'),
        (0xe418, 0xe418, "BRANCH IF VALTYP = FF, AND ACCA = '+' TOKEN -"),
        (0xe41c, 0xe41c, 'RESTORE ARITHMETIC/LOGICAL OPERATOR NUMBER'),
        (0xe41e, 0xe41e, '* STORE OPERATOR NUMBER ON STACK; MULTIPLY IT BY 2'),
        (0xe420, 0xe420, '* THEN ADD THE STORED STACK DATA = MULTIPLY'),
        (0xe421, 0xe421, '* X 3; 3 BYTE/TABLE ENTRY'),
        (0xe423, 0xe423, 'JUMP TABLE FOR ARITHMETIC & LOGICAL OPERATORS'),
        (0xe426, 0xe426, 'POINT X TO PROPER TABLE'),
        (0xe428, 0xe428, 'GET PRECEDENCE FLAG FROM STACK'),
        (0xe42a, 0xe42a, 'COMPARE TO CURRENT OPERATOR'),
        (0xe42c, 0xe42c, 'BRANCH IF STACK OPERATOR > CURRENT OPERATOR'),
        (0xe42e, 0xe42e, "'TM' ERROR IF VARIABLE TYPE = STRING"),
        (0xe430, 0xe430, 'SAVE PRECEDENCE FLAG'),
        (0xe432, 0xe432, 'PUSH OPERATOR ROUTINE ADDRESS AND FPA0 ONTO STACK'),
        (0xe434, 0xe434, 'GET POINTER TO ARITHMETIC/LOGICAL TABLE ENTRY FOR'),
        (0xe436, 0xe436, 'GET PRECEDENCE FLAG OF PREVIOUS OPERATION'),
        (0xe438, 0xe438, 'BRANCH IF NOT END OF OPERATION'),
        (0xe43a, 0xe43a, 'CHECK TYPE OF PRECEDENCE FLAG'),
        (0xe43b, 0xe43b, 'BRANCH IF END OF EXPRESSION OR SUB-EXPRESSION'),
        (0xe43f, 0xe43f, 'EVALUATE AN OPERATION'),
        (0xe441, 0xe441, 'BIT 7 OF TYPE FLAG TO CARRY'),
        (0xe443, 0xe443, 'SHIFT RELATIONAL FLAG LEFT - VALTYP TO BIT 0'),
        (0xe444, 0xe444, 'MOVE THE INPUT POINTER BACK ONE'),
        (0xe446, 0xe446, 'POINT X TO RELATIONAL COMPARISON JUMP TABLE'),
        (0xe449, 0xe449, 'SAVE RELATIONAL COMPARISON DATA'),
        (0xe44b, 0xe44b, 'SET VARIABLE TYPE TO NUMERIC'),
        (0xe44d, 0xe44d, 'PERFORM OPERATION OR SAVE ON STACK'),
        (0xe44f, 0xe44f, "* GET BASIC'S INPUT POINTER AND"),
        (0xe451, 0xe451, '* MOVE IT BACK ONE'),
        (0xe454, 0xe454, 'RELATIONAL COMPARISON FLAG'),
        (0xe455, 0xe455, 'JUMP ADDRESS'),
        (0xe457, 0xe457, 'COMPARE PRECEDENCE OF LAST DONE OPERATION TO'),
        (0xe459, 0xe459, 'EVALUATE OPERATION IF LOWER PRECEDENCE'),
        (0xe45b, 0xe45b, 'PUSH OPERATION DATA ON STACK IF HIGHER PRECEDENCE'),
        (0xe45d, 0xe45d, 'GET ADDRESS OF OPERATOR ROUTINE'),
        (0xe45f, 0xe45f, 'SAVE IT ON THE STACK'),
        (0xe461, 0xe461, 'PUSH FPA0 ONTO STACK'),
        (0xe463, 0xe463, 'GET BACK RELATIONAL OPERATOR FLAG'),
        (0xe465, 0xe465, 'EVALUATE ANOTHER EXPRESSION'),
        (0xe468, 0xe468, "'SYNTAX ERROR'"),
        (0xe46b, 0xe46b, 'GET SIGN OF FPA0 MANTISSA'),
        (0xe46d, 0xe46d, 'GET PRECEDENCE CODE TO ACCA'),
        (0xe46f, 0xe46f, 'GET RETURN ADDRESS FROM STACK & PUT IT IN Y'),
        (0xe471, 0xe471, 'SAVE ACCB ON STACK'),
        (0xe473, 0xe473, '* PUSH FPA0 ONTO THE STACK'),
        (0xe47b, 0xe47b, 'JUMP TO ADDRESS IN Y'),
        (0xe47d, 0xe47d, 'POINT X TO DUMMY VALUE (ZERO)'),
        (0xe47f, 0xe47f, 'GET PRECEDENCE FLAG FROM STACK'),
        (0xe481, 0xe481, 'BRANCH IF END OF EXPRESSION'),
        (0xe483, 0xe483, '* CHECK FOR RELATIONAL COMPARISON FLAG'),
        (0xe485, 0xe485, '* AND BRANCH IF RELATIONAL COMPARISON'),
        (0xe487, 0xe487, "'TM' ERROR IF VARIABLE TYPE = STRING"),
        (0xe48a, 0xe48a, 'SAVE POINTER TO OPERATOR ROUTINE'),
        (0xe48c, 0xe48c, 'GET RELATIONAL OPERATOR FLAG FROM STACK'),
        (0xe48e, 0xe48e, "CHECK FOR 'NOT' OPERATOR"),
        (0xe490, 0xe490, "RETURN IF 'NOT' - NO RELATIONAL COMPARISON"),
        (0xe492, 0xe492, 'CHECK FOR NEGATION (UNARY) FLAG'),
        (0xe494, 0xe494, 'RETURN IF NEGATION - NO RELATIONAL COMPARISON'),
        (0xe496, 0xe496, '= ROTATE VALTYP BIT INTO CARRY'),
        (0xe497, 0xe497, '= FLAG AND SAVE NEW RELFLG'),
        (0xe499, 0xe499, '* PULL A FP VALUE OFF OF THE STACK'),
        (0xe49b, 0xe49b, '* AND SAVE IT IN FPA1'),
        (0xe4a1, 0xe4a1, '= GET MANTISSA SIGN AND'),
        (0xe4a3, 0xe4a3, '= SAVE IT IN FPA1'),
        (0xe4a5, 0xe4a5, 'EOR IT WITH FPA1 MANTISSA SIGN'),
        (0xe4a7, 0xe4a7, 'SAVE IT IN RESULT SIGN BYTE'),
        (0xe4a9, 0xe4a9, 'GET EXPONENT OF FPA0'),
        (0xe4ac, 0xe4ac, 'CALL EXTENDED BASIC ADD-IN'),
        (0xe4af, 0xe4af, 'INITIALIZE TYPE FLAG TO NUMERIC'),
        (0xe4b1, 0xe4b1, 'GET AN INPUT CHAR'),
        (0xe4b3, 0xe4b3, 'BRANCH IF NOT NUMERIC'),
        (0xe4b5, 0xe4b5, 'CONVERT ASCII STRING TO FLOATING POINT -'),
        (0xe4b8, 0xe4b8, 'SET CARRY IF NOT ALPHA'),
        (0xe4bb, 0xe4bb, 'BRANCH IF ALPHA CHARACTER'),
        (0xe4bd, 0xe4bd, "IS IT '.' (DECIMAL POINT)?"),
        (0xe4bf, 0xe4bf, 'CONVERT ASCII STRING TO FLOATING POINT'),
        (0xe4c1, 0xe4c1, 'MINUS TOKEN'),
        (0xe4c3, 0xe4c3, 'YES - GO PROCESS THE MINUS OPERATOR'),
        (0xe4c5, 0xe4c5, 'PLUS TOKEN'),
        (0xe4c7, 0xe4c7, 'YES - GET ANOTHER CHARACTER'),
        (0xe4c9, 0xe4c9, 'STRING DELIMITER?'),
        (0xe4cb, 0xe4cb, 'NO'),
        (0xe4cd, 0xe4cd, 'CURRENT BASIC POINTER TO X'),
        (0xe4cf, 0xe4cf, 'SAVE STRING ON STRING STACK'),
        (0xe4d2, 0xe4d2, '* GET ADDRESS OF END OF STRING AND'),
        (0xe4d4, 0xe4d4, "* PUT BASIC'S INPUT POINTER THERE"),
        (0xe4d7, 0xe4d7, 'NOT TOKEN?'),
        (0xe4d9, 0xe4d9, 'NO'),
        (0xe4db, 0xe4db, "'NOT' PRECEDENCE FLAG"),
        (0xe4dd, 0xe4dd, "PROCESS OPERATION FOLLOWING 'NOT'"),
        (0xe4e0, 0xe4e0, 'CONVERT FPA0 TO INTEGER IN ACCD'),
        (0xe4e3, 0xe4e3, "* 'NOT' THE INTEGER"),
        (0xe4e5, 0xe4e5, 'CONVERT ACCD TO FLOATING POINT (FPA0)'),
        (0xe4e8, 0xe4e8, 'CHECK FOR TOKENS PRECEEDED BY $FF'),
        (0xe4e9, 0xe4e9, 'IT WAS PRECEEDED BY $FF'),
        (0xe4eb, 0xe4eb, "SYNTAX CHECK FOR A '('"),
        (0xe4ed, 0xe4ed, 'EVALUATE EXPRESSIONS WITHIN PARENTHESES AT'),
        (0xe4f0, 0xe4f0, "SYNTAX CHECK FOR ')'"),
        (0xe4f2, 0xe4f2, 'SKIP 2 BYTES'),
        (0xe4f3, 0xe4f3, "SYNTAX CHECK FOR '('"),
        (0xe4f5, 0xe4f5, 'SKIP 2 BYTES'),
        (0xe4f6, 0xe4f6, 'SYNTAX CHECK FOR COMMA'),
        (0xe4f8, 0xe4f8, '* COMPARE ACCB TO CURRENT INPUT'),
        (0xe4fc, 0xe4fc, '* CHARACTER - SYNTAX ERROR IF NO MATCH'),
        (0xe4fe, 0xe4fe, 'GET A CHARACTER FROM BASIC'),
        (0xe500, 0xe500, 'SYNTAX ERROR'),
        (0xe502, 0xe502, 'JUMP TO ERROR HANDLER'),
        (0xe505, 0xe505, 'MINUS (UNARY) PRECEDENCE FLAG'),
        (0xe507, 0xe507, "PROCESS OPERATION FOLLOWING 'UNARY' NEGATION"),
        (0xe50a, 0xe50a, 'CHANGE SIGN OF FPA0 MANTISSA'),
        (0xe50d, 0xe50d, 'FIND THE DESCRIPTOR ADDRESS OF A VARIABLE'),
        (0xe510, 0xe510, 'SAVE DESCRIPTOR ADDRESS IN FPA0'),
        (0xe512, 0xe512, 'TEST VARIABLE TYPE'),
        (0xe514, 0xe514, 'RETURN IF STRING'),
        (0xe516, 0xe516, 'COPY A FP NUMBER FROM (X) TO FPA0'),
        (0xe519, 0xe519, 'GET AN INPUT CHARACTER (SECONDARY TOKEN)'),
        (0xe51b, 0xe51b, 'SAVE IT IN ACCB'),
        (0xe51d, 0xe51d, 'X2 & BET RID OF BIT 7'),
        (0xe51e, 0xe51e, 'GET ANOTHER INPUT CHARACTER'),
        (0xe520, 0xe520, '29 SECONDARY FUNCTIONS - 1'),
        (0xe522, 0xe522, 'BRANCH IF COLOR BASIC TOKEN'),
        (0xe524, 0xe524, 'SYNTAX ERROR'),
        (0xe527, 0xe527, 'SAVE TOKEN OFFSET ON STACK'),
        (0xe529, 0xe529, 'CHECK FOR TOKEN WITH AN ARGUMENT'),
        (0xe52b, 0xe52b, 'DO SECONDARIES STRING$ OR LESS'),
        (0xe52f, 0xe52f, '* DO SECONDARIES $92 (INKEY$) OR >'),
        (0xe531, 0xe531, "SYNTAX CHECK FOR A '('"),
        (0xe533, 0xe533, 'GET TOKEN NUMBER'),
        (0xe535, 0xe535, 'EVALUATE FIRST STRING IN ARGUMENT'),
        (0xe538, 0xe538, 'SYNTAX CHECK FOR A COMMA'),
        (0xe53a, 0xe53a, "'TM' ERROR IF NUMERIC VARiABLE"),
        (0xe53d, 0xe53d, 'GET TOKEN OFFSET FROM STACK'),
        (0xe53f, 0xe53f, 'POINT U TO STRING DESCRIPTOR'),
        (0xe541, 0xe541, 'SAVE TOKEN OFFSET AND DESCRIPTOR ADDRESS'),
        (0xe543, 0xe543, 'EVALUATE FIRST NUMERIC ARGUMENT'),
        (0xe546, 0xe546, 'GET TOKEN OFFSET FROM STACK'),
        (0xe548, 0xe548, 'SAVE TOKEN OFFSET AND NUMERIC ARGUMENT'),
        (0xe54a, 0xe54a, 'OP CODE OF LDX# - SKlP 2 BYTES'),
        (0xe54b, 0xe54b, "SYNTAX CHECK FOR A '('"),
        (0xe54d, 0xe54d, 'GET TOKEN OFFSET'),
        (0xe54f, 0xe54f, 'GET SECONDARY FUNCTION JUMP TABLE ADDRESS'),
        (0xe552, 0xe552, 'ADD IN COMMAND OFFSET'),
        (0xe553, 0xe553, 'GO DO AN SECONDARY FUNCTION'),
        (0xe555, 0xe555, "'TM' ERROR IF VARIABLE TYPE = STRING"),
        (0xe558, 0xe558, "SKIP ONE BYTE - 'OR' FLAG = $4F"),
        (0xe559, 0xe559, 'AND FLAG = 0'),
        (0xe55a, 0xe55a, 'AND/OR FLAG'),
        (0xe55c, 0xe55c, 'CONVERT FPA0 INTO AN INTEGER IN ACCD'),
        (0xe55f, 0xe55f, 'TEMP SAVE ACCD'),
        (0xe561, 0xe561, 'MOVE FPA1 TO FPA0'),
        (0xe564, 0xe564, 'CONVERT FPA0 INTO AN INTEGER IN ACCD'),
        (0xe567, 0xe567, 'CHECK AND/OR FLAG'),
        (0xe569, 0xe569, 'BRANCH IF OR'),
        (0xe56b, 0xe56b, "* 'AND' ACCD WITH FPA0 INTEGER"),
        (0xe56d, 0xe56d, '* STORED IN ENDCHR'),
        (0xe56f, 0xe56f, 'CONVERT TO FP'),
        (0xe571, 0xe571, "* 'OR' ACCD WITH FPA0 INTEGER"),
        (0xe573, 0xe573, '* STORED IN CHARAC'),
        (0xe575, 0xe575, 'CONVERT THE VALUE IN ACCD INTO A FP NUMBER'),
        (0xe578, 0xe578, "'TM' ERROR IF TYPE MISMATCH"),
        (0xe57b, 0xe57b, 'BRANCH IF STRING VARIABLE'),
        (0xe57d, 0xe57d, "* 'PACK' THE MANTISSA"),
        (0xe57f, 0xe57f, '* SIGN OF FPA1 INTO'),
        (0xe581, 0xe581, '* BIT 7 OF THE'),
        (0xe583, 0xe583, '* MANTISSA MS BYTE'),
        (0xe585, 0xe585, 'POINT X TO FPA1'),
        (0xe588, 0xe588, 'COMPARE FPA0 TO FPA1'),
        (0xe58b, 0xe58b, 'CHECK TRUTH OF RELATIONAL COMPARISON'),
        (0xe58d, 0xe58d, 'SET VARIABLE TYPE TO NUMERIC'),
        (0xe58f, 0xe58f, 'REMOVE STRING TYPE FLAG (BIT0=1 FOR STRINGS) FROM THE'),
        (0xe591, 0xe591, 'GET LENGTH AND ADDRESS OF STRING WHOSE'),
        (0xe594, 0xe594, '* SAVE LENGTH AND ADDRESS IN TEMPORARY'),
        (0xe596, 0xe596, '* DESCRIPTOR (STRING B)'),
        (0xe598, 0xe598, '= RETURN LENGTH AND ADDRESS OF STRING'),
        (0xe59a, 0xe59a, '= WHOSE DESCRIPTOR ADDRESS IS STORED IN FPA1+2'),
        (0xe59d, 0xe59d, 'LOAD ACCA WITH LENGTH OF STRING B'),
        (0xe59f, 0xe59f, 'SAVE LENGTH A ON STACK'),
        (0xe5a1, 0xe5a1, 'SUBTRACT LENGTH A FROM LENGTH B'),
        (0xe5a3, 0xe5a3, 'BRANCH IF STRINGS OF EQUAL LENGTH'),
        (0xe5a5, 0xe5a5, 'TRUE FLAG'),
        (0xe5a7, 0xe5a7, 'TRUE IF LENGTH B > LENGTH A'),
        (0xe5a9, 0xe5a9, 'LOAD ACCB WITH LENGTH B'),
        (0xe5ab, 0xe5ab, 'SET FLAG = FALSE (1FF)'),
        (0xe5ac, 0xe5ac, 'SAVE TRUE/FALSE FLAG'),
        (0xe5ae, 0xe5ae, 'POINT U TO START OF STRING'),
        (0xe5b0, 0xe5b0, 'COMPENSATE FOR THE DECB BELOW'),
        (0xe5b1, 0xe5b1, 'DECREMENT SHORTER STRING LENGTH'),
        (0xe5b2, 0xe5b2, 'BRANCH IF ALL OF STRING NOT COMPARED'),
        (0xe5b4, 0xe5b4, 'GET TRUE/FALSE FLAB'),
        (0xe5b6, 0xe5b6, 'CHECK TRUTH OF RELATIONAL COMPARISON'),
        (0xe5b8, 0xe5b8, 'GET A BYTE FROM STRING A'),
        (0xe5ba, 0xe5ba, 'COMPARE TO STRING B'),
        (0xe5bc, 0xe5bc, 'CHECK ANOTHER CHARACTER IF ='),
        (0xe5be, 0xe5be, 'FALSE FLAG IF STRING A > B'),
        (0xe5c0, 0xe5c0, 'BRANCH IF STRING A > STRING B'),
        (0xe5c2, 0xe5c2, 'SET FLAG = TRUE'),
        (0xe5c3, 0xe5c3, 'CONVERT $FF,0,1 TO 0,1,2'),
        (0xe5c5, 0xe5c5, "NOW IT'S 1,2,4 FOR > = <"),
        (0xe5c6, 0xe5c6, "'AND' THE ACTUAL COMPARISON WITH THE DESIRED -"),
        (0xe5c8, 0xe5c8, 'BRANCH IF FALSE (NO MATCHING BITS)'),
        (0xe5ca, 0xe5ca, 'TRUE FLAG'),
        (0xe5cc, 0xe5cc, 'CONVERT ACCB INTO FP NUMBER IN FPA0'),
        (0xe5cf, 0xe5cf, 'SYNTAX CHECK FOR COMMA'),
        (0xe5d2, 0xe5d2, 'DIMENSION FLAG'),
        (0xe5d4, 0xe5d4, 'SAVE ARRAY SPACE FOR THIS VARIABLE'),
        (0xe5d6, 0xe5d6, 'GET CURRENT INPUT CHARACTER'),
        (0xe5d8, 0xe5d8, 'KEEP DIMENSIONING IF NOT END OF LINE'),
        (0xe5db, 0xe5db, 'DIMENSION FLAG = 0; DO NOT SET UP AN ARRAY'),
        (0xe5dc, 0xe5dc, 'GET CURRENT INPUT CHARACTER'),
        (0xe5de, 0xe5de, 'SAVE ARRAY FLAG'),
        (0xe5e0, 0xe5e0, 'SAVE INPUT CHARACTER'),
        (0xe5e2, 0xe5e2, 'GET CURRENT INPUT CHARACTER'),
        (0xe5e4, 0xe5e4, 'SET CARRY IF NOT ALPHA'),
        (0xe5e6, 0xe5e6, 'SYNTAX ERROR IF NOT ALPHA'),
        (0xe5ea, 0xe5ea, 'DEFAULT 2ND VARIABLE CHARACTER TO ZERO'),
        (0xe5eb, 0xe5eb, 'SET VARIABLE TYPE TO NUMERIC'),
        (0xe5ed, 0xe5ed, 'GET ANOTHER CHARACTER FROM BASIC'),
        (0xe5ef, 0xe5ef, 'BRANCH IF NUMERIC (2ND CHARACTER IN'),
        (0xe5f1, 0xe5f1, 'SET CARRY IF NOT ALPHA'),
        (0xe5f3, 0xe5f3, 'BRANCH IF NOT ALPHA'),
        (0xe5f5, 0xe5f5, 'SAVE 2ND CHARACTER IN ACCB'),
        (0xe5f7, 0xe5f7, 'GET AN INPUT CHARACTER'),
        (0xe5f9, 0xe5f9, 'BRANCH IF NUMERIC'),
        (0xe5fb, 0xe5fb, 'SET CARRY IF NOT ALPHA'),
        (0xe5fd, 0xe5fd, 'BRANCH IF ALPHA'),
        (0xe5ff, 0xe5ff, 'CHECK FOR A STRING VARIABLE'),
        (0xe601, 0xe601, 'BRANCH IF IT IS NOT A STRING'),
        (0xe603, 0xe603, 'SET VARIABLE TYPE TO STRING'),
        (0xe605, 0xe605, 'SET BIT 7 OF 2ND CHARACTER (STRING)'),
        (0xe607, 0xe607, 'GET AN INPUT CHARACTER'),
        (0xe609, 0xe609, 'SAVE 2ND CHARACTER IN VARNAM+1'),
        (0xe60b, 0xe60b, 'OR IN THE ARRAY DISABLE FLAG - IF = $80,'),
        (0xe60d, 0xe60d, 'IS THIS AN ARRAY VARIABLE?'),
        (0xe60f, 0xe60f, 'BRANCH IF IT IS'),
        (0xe613, 0xe613, 'RESET THE ARRAY DISABLE FLAG'),
        (0xe615, 0xe615, 'POINT X TO THE START OF VARIABLES'),
        (0xe617, 0xe617, 'GET VARIABLE IN QUESTION'),
        (0xe619, 0xe619, 'COMPARE X TO THE END OF VARIABLES'),
        (0xe61b, 0xe61b, 'BRANCH IF END OF VARIABLES'),
        (0xe61d, 0xe61d, '* COMPARE VARIABLE IN QUESTION TO CURRENT'),
        (0xe620, 0xe620, '* VARIABLE AND BRANCH IF MATCH'),
        (0xe622, 0xe622, '= MOVE POINTER TO NEXT VARIABLE AND'),
        (0xe624, 0xe624, '= KEEP LOOKING'),
        (0xe626, 0xe626, "* CARRY SET IF < 'A'"),
        (0xe62a, 0xe62a, '='),
        (0xe62c, 0xe62c, '5'),
        (0xe62f, 0xe62f, 'POINT X TO ZERO LOCATION'),
        (0xe632, 0xe632, 'GET CURRENT RETURN ADDRESS'),
        (0xe634, 0xe634, "DID WE COME FROM 'EVALUATE ALPHA EXPR'?"),
        (0xe638, 0xe638, 'YES - RETURN A ZERO VALUE'),
        (0xe63a, 0xe63a, '* GET END OF ARRAYS ADDRESS AND'),
        (0xe63c, 0xe63c, '* SAVE IT AT V43'),
        (0xe63e, 0xe63e, '= ADD 7 TO END OF ARRAYS (EACH'),
        (0xe641, 0xe641, '= VARIABLE = 7 BYTES) AND SAVE AT V41'),
        (0xe643, 0xe643, '* GET END OF VARIABLES AND SAVE AT V47'),
        (0xe647, 0xe647, 'MAKE A SEVEN BYTE SLOT FOR NEW VARIABLE AT'),
        (0xe64a, 0xe64a, '= GET NEW END OF ARRAYS AND SAVE IT'),
        (0xe64c, 0xe64c, '='),
        (0xe64e, 0xe64e, '* GET NEW END OF VARIABLES AND SAVE IT'),
        (0xe652, 0xe652, 'GET OLD END OF VARIABLES'),
        (0xe654, 0xe654, 'GET NEW VARIABLE NAME'),
        (0xe656, 0xe656, 'SAVE VARIABLE NAME'),
        (0xe658, 0xe658, '* ZERO OUT THE FP VALUE OF THE NUMERIC'),
        (0xe659, 0xe659, '* VARIABLE OR THE LENGTH AND ADDRESS'),
        (0xe65a, 0xe65a, '* OF A STRING VARIABLE'),
        (0xe660, 0xe660, 'STORE ADDRESS OF VARIABLE VALUE'),
        (0xe663, 0xe663, '* FLOATING POINT -32768'),
        (0xe668, 0xe668, 'GET AN INPUT CHARACTER FROM BASIC'),
        (0xe66a, 0xe66a, 'GO EVALUATE NUMERIC EXPRESSION'),
        (0xe66d, 0xe66d, 'GET FPA0 MANTISSA SIGN'),
        (0xe66f, 0xe66f, "'FC' ERROR IF NEGATIVE NUMBER"),
        (0xe671, 0xe671, "'TM' ERROR IF STRING VARIABLE"),
        (0xe674, 0xe674, 'GET FPA0 EXPONENT'),
        (0xe676, 0xe676, '* COMPARE TO 32768 - LARGEST INTEGER EXPONENT AND'),
        (0xe678, 0xe678, '* BRANCH IF FPA0 < 32768'),
        (0xe67a, 0xe67a, 'POINT X TO FP VALUE OF -32768'),
        (0xe67d, 0xe67d, 'COMPARE -32768 TO FPA0'),
        (0xe680, 0xe680, "'FC' ERROR IF NOT ="),
        (0xe682, 0xe682, 'CONVERT FPA0 TO A TWO BYTE INTEGER'),
        (0xe685, 0xe685, 'GET THE INTEGER'),
        (0xe688, 0xe688, 'GET ARRAY FLAG AND VARIABLE TYPE'),
        (0xe68a, 0xe68a, 'SAVE THEM ON STACK'),
        (0xe68c, 0xe68c, 'DEAD SPACE CAUSED BY 1.2 REVISION'),
        (0xe68d, 0xe68d, 'RESET DIMENSION COUNTER'),
        (0xe68e, 0xe68e, 'GET VARIABLE NAME'),
        (0xe690, 0xe690, 'SAVE VARIABLE NAME AND DIMENSION COUNTER'),
        (0xe692, 0xe692, 'EVALUATE EXPRESSION (DIMENSlON LENGTH)'),
        (0xe694, 0xe694, 'PULL OFF VARIABLE NAME, DIMENSlON COUNTER,'),
        (0xe696, 0xe696, 'SAVE VARIABLE NAME AND VARIABLE TYPE'),
        (0xe698, 0xe698, 'GET DIMENSION LENGTH'),
        (0xe69a, 0xe69a, 'SAVE DIMENSION LENGTH, ARRAY FLAG, VARIABLE TYPE'),
        (0xe69c, 0xe69c, 'INCREASE DIMENSION COUNTER'),
        (0xe69d, 0xe69d, 'GET CURRENT INPUT CHARACTER'),
        (0xe69f, 0xe69f, 'CHECK FOR ANOTHER DIMENSION'),
        (0xe6a1, 0xe6a1, 'BRANCH IF MORE'),
        (0xe6a3, 0xe6a3, 'SAVE DIMENSION COUNTER'),
        (0xe6a5, 0xe6a5, "SYNTAX CHECK FOR A ')'"),
        (0xe6a8, 0xe6a8, '* RESTORE VARIABLE TYPE AND ARRAY'),
        (0xe6aa, 0xe6aa, '* FLAG - LEAVE DIMENSION LENGTH ON STACK'),
        (0xe6ac, 0xe6ac, 'GET START OF ARRAYS'),
        (0xe6ae, 0xe6ae, 'COMPARE TO END OF ARRAYS'),
        (0xe6b0, 0xe6b0, 'BRANCH IF NO MATCH FOUND'),
        (0xe6b2, 0xe6b2, 'GET VARIABLE IN QUESTION'),
        (0xe6b4, 0xe6b4, 'COMPARE TO CURRENT VARIABLE'),
        (0xe6b7, 0xe6b7, 'BRANCH IF ='),
        (0xe6b9, 0xe6b9, 'GET OFFSET TO NEXT ARRAY VARIABLE'),
        (0xe6bb, 0xe6bb, 'ADD TO CURRENT POINTER'),
        (0xe6bd, 0xe6bd, 'KEEP SEARCHING'),
        (0xe6bf, 0xe6bf, "'REDIMENSIONED ARRAY' ERROR"),
        (0xe6c1, 0xe6c1, '* TEST ARRAY FLAG - IF <>0 YOU ARE TRYING'),
        (0xe6c3, 0xe6c3, '* TO REDIMENSION AN ARRAY'),
        (0xe6c5, 0xe6c5, 'GET NUMBER OF DIMENSIONS IN ARRAY'),
        (0xe6c7, 0xe6c7, 'COMPARE TO THIS ARRAYS DIMENSIONS'),
        (0xe6c9, 0xe6c9, 'BRANCH IF ='),
        (0xe6cb, 0xe6cb, "'BAD SUBSCRIPT'"),
        (0xe6cd, 0xe6cd, 'SKIP TWO BYTES'),
        (0xe6ce, 0xe6ce, "'ILLEGAL FUNCTION CALL'"),
        (0xe6d0, 0xe6d0, 'JUMP TO ERROR SERVICING ROUTINE'),
        (0xe6d3, 0xe6d3, '* 5 BYTES/ARRAY ENTRY SAVE AT COEFPT'),
        (0xe6d8, 0xe6d8, '= GET NAME OF ARRAY AND SAVE IN'),
        (0xe6da, 0xe6da, '= FIRST 2 BYTES OF DESCRIPTOR'),
        (0xe6dc, 0xe6dc, 'GET NUMBER OF DIMENSIONS AND SAVE IN'),
        (0xe6de, 0xe6de, '* 5TH BYTE OF DESCRIPTOR'),
        (0xe6e0, 0xe6e0, 'CHECK FOR ROOM FOR DESCRIPTOR IN FREE RAM'),
        (0xe6e3, 0xe6e3, 'TEMPORARILY SAVE DESCRIPTOR ADDRESS'),
        (0xe6e5, 0xe6e5, '* DEFAULT DIMENSION VALUE:X(10)'),
        (0xe6e8, 0xe6e8, '= CHECK ARRAY FLAG AND BRANCH IF'),
        (0xe6ea, 0xe6ea, '= NOT DIMENSIONING AN ARRAY'),
        (0xe6ec, 0xe6ec, 'GET DIMENSION LENGTH'),
        (0xe6ee, 0xe6ee, 'ADD ONE (X(0) HAS A LENGTH OF ONE)'),
        (0xe6f1, 0xe6f1, 'SAVE LENGTH OF ARRAY DIMENSION'),
        (0xe6f3, 0xe6f3, 'MULTIPLY ACCUM ARRAY SIZE NUMBER LENGTH'),
        (0xe6f5, 0xe6f5, 'TEMP STORE NEW CURRENT ACCUMULATED ARRAY SIZE'),
        (0xe6f7, 0xe6f7, 'BUMP POINTER UP TWO'),
        (0xe6f9, 0xe6f9, '* DECREMENT DIMENSION COUNTER AND BRANCH IF'),
        (0xe6fb, 0xe6fb, '* NOT DONE WITH ALL DIMENSIONS'),
        (0xe6fd, 0xe6fd, 'SAVE ADDRESS OF (END OF ARRAY DESCRIPTOR - 5)'),
        (0xe6ff, 0xe6ff, 'ADD TOTAL SIZE OF NEW ARRAY'),
        (0xe701, 0xe701, "'OM' ERROR IF > $FFFF"),
        (0xe705, 0xe705, 'SAVE END OF ARRAY IN X'),
        (0xe707, 0xe707, 'MAKE SURE THERE IS ENOUGH FREE RAM FOR ARRAY'),
        (0xe70a, 0xe70a, 'SUBTRACT OUT THE (STACK BUFFER - 5)'),
        (0xe70d, 0xe70d, 'SAVE NEW END OF ARRAYS'),
        (0xe70f, 0xe70f, 'ZERO = TERMINATOR BYTE'),
        (0xe710, 0xe710, '* STORE TWO TERMINATOR BYTES AT'),
        (0xe712, 0xe712, '* THE END OF THE ARRAY DESCRIPTOR'),
        (0xe718, 0xe718, 'GET ADDRESS OF START OF DESCRIPTOR'),
        (0xe71a, 0xe71a, 'GET MSB OF END OF ARRAYS; LSB ALREADY THERE'),
        (0xe71c, 0xe71c, 'SUBTRACT OUT ADDRESS OF START OF DESCRIPTOR'),
        (0xe71e, 0xe71e, 'SAVE LENGTH OF (ARRAY AND DESCRIPTOR)'),
        (0xe720, 0xe720, '* GET ARRAY FLAG AND BRANCH'),
        (0xe722, 0xe722, '* BACK IF DIMENSIONING'),
        (0xe724, 0xe724, 'GET THE NUMBER OF DIMENSIONS'),
        (0xe726, 0xe726, 'TEMPORARILY SAVE'),
        (0xe728, 0xe728, '* INITIALIZE POINTER'),
        (0xe729, 0xe729, '* TO ZERO'),
        (0xe72a, 0xe72a, 'SAVE ACCUMULATED POINTER'),
        (0xe72c, 0xe72c, '* PULL DIMENSION ARGUMENT OFF THE'),
        (0xe72e, 0xe72e, '* STACK AND SAVE IT'),
        (0xe730, 0xe730, "COMPARE TO STORED 'DIM' ARGUMENT"),
        (0xe733, 0xe733, '\'BS\' ERROR IF > = "DIM" ARGUMENT'),
        (0xe735, 0xe735, '* GET ACCUMULATED POINTER AND'),
        (0xe737, 0xe737, '* BRANCH IF 1ST DIMENSION'),
        (0xe739, 0xe739, '= MULTIPLY ACCUMULATED POINTER AND DIMENSION'),
        (0xe73b, 0xe73b, '= LENGTH AND ADD TO CURRENT ARGUMENT'),
        (0xe73d, 0xe73d, 'MOVE POINTER TO NEXT DIMENSION'),
        (0xe73f, 0xe73f, '* DECREMENT DIMENSION COUNTER AND'),
        (0xe741, 0xe741, '* BRANCH IF ANY DIMENSIONS LEFT'),
        (0xe746, 0xe746, 'TIMES 2'),
        (0xe748, 0xe748, 'TIMES 4'),
        (0xe749, 0xe749, 'TIMES 5'),
        (0xe74b, 0xe74b, 'ADD OFFSET TO START OF ARRAY'),
        (0xe74d, 0xe74d, 'ADJUST POINTER FOR SIZE OF DESCRIPTOR'),
        (0xe74f, 0xe74f, 'SAVE POINTER TO ARRAY VALUE'),
        (0xe752, 0xe752, '16 SHIFTS TO DO A MULTIPLY'),
        (0xe754, 0xe754, 'SHIFT COUNTER'),
        (0xe756, 0xe756, '* GET SIZE OF DIMENSION'),
        (0xe758, 0xe758, '* AND SAVE IT'),
        (0xe75a, 0xe75a, '* ZERO'),
        (0xe75b, 0xe75b, '* ACCD'),
        (0xe75c, 0xe75c, '= SHIFT ACCB LEFT'),
        (0xe75d, 0xe75d, '= ONE BIT'),
        (0xe75e, 0xe75e, "BS' ERROR IF CARRY"),
        (0xe760, 0xe760, '* SHIFT MULTIPLICAND LEFT ONE'),
        (0xe762, 0xe762, '* BIT - ADD MULTIPLIER TO ACCUMULATOR'),
        (0xe764, 0xe764, '* IF CARRY <> 0'),
        (0xe766, 0xe766, 'ADD MULTIPLIER TO ACCD'),
        (0xe768, 0xe768, "BS' ERROR IF CARRY (>$FFFF)"),
        (0xe76a, 0xe76a, '* DECREMENT SHIFT COUNTER'),
        (0xe76c, 0xe76c, '* IF NOT DONE'),
        (0xe76f, 0xe76f, "BS' ERROR"),
        (0xe772, 0xe772, 'PUT STACK POINTER INTO ACCD'),
        (0xe774, 0xe774, 'SUBTRACT END OF ARRAYS'),
        (0xe776, 0xe776, 'SKIP ONE BYTE'),
        (0xe777, 0xe777, 'CLEAR MS BYTE OF ACCD'),
        (0xe778, 0xe778, 'SET VARIABLE TYPE TO NUMERIC'),
        (0xe77a, 0xe77a, 'SAVE ACCD IN TOP OF FACA'),
        (0xe77c, 0xe77c, 'EXPONENT REQUIRED IF THE TOP TWO BYTES'),
        (0xe77e, 0xe77e, 'CONVERT THE REST OF FPA0 TO AN INTEGER'),
        (0xe781, 0xe781, "TM' ERROR IF STRING VARIABLE"),
        (0xe784, 0xe784, '*CONVERT FP NUMBER TO ASCII STRING IN'),
        (0xe787, 0xe787, '*THE STRING BUFFER'),
        (0xe78a, 0xe78a, 'PURGE THE RETURN ADDRESS FROM THE STACK'),
        (0xe78c, 0xe78c, '*POINT X TO STRING BUFFER AND SAVE'),
        (0xe78f, 0xe78f, '*THE STRING IN THE STRING SPACE'),
        (0xe791, 0xe791, 'SAVE X IN V4D'),
        (0xe793, 0xe793, 'RESERVE ACCB BYTES IN STRING SPACE'),
        (0xe795, 0xe795, 'SAVE NEW STRING ADDRESS'),
        (0xe797, 0xe797, 'SAVE LENGTH OF RESERVED BLOCK'),
        (0xe79a, 0xe79a, 'MOVE POINTER BACK ONE'),
        (0xe79c, 0xe79c, '* INITIALIZE'),
        (0xe79e, 0xe79e, '* TERMINATORS'),
        (0xe7a0, 0xe7a0, '* TO "'),
        (0xe7a2, 0xe7a2, 'MOVE POINTER UP ONE'),
        (0xe7a4, 0xe7a4, 'TEMPORARILY SAVE START OF STRING'),
        (0xe7a6, 0xe7a6, 'SAVE START OF STRING IN TEMP DESCRIPTOR'),
        (0xe7a8, 0xe7a8, 'INITIALIZE CHARACTER COUNTER TO - 1'),
        (0xe7aa, 0xe7aa, 'INCREMENT CHARACTER COUNTER'),
        (0xe7ab, 0xe7ab, 'GET CHARACTER'),
        (0xe7ad, 0xe7ad, 'BRANCH IF END OF LINE'),
        (0xe7af, 0xe7af, '* CHECK FOR TERMINATORS'),
        (0xe7b1, 0xe7b1, '* IN CHARAC AND ENDCHR'),
        (0xe7b3, 0xe7b3, "* DON'T MOVE POINTER BACK"),
        (0xe7b5, 0xe7b5, '* ONE IF TERMINATOR IS "MATCHED"'),
        (0xe7b7, 0xe7b7, '= COMPARE CHARACTER TO STRING DELIMITER'),
        (0xe7b9, 0xe7b9, "= & DON'T MOVE POINTER BACK IF SO"),
        (0xe7bb, 0xe7bb, 'MOVE POINTER BACK ONE'),
        (0xe7bd, 0xe7bd, 'SAVE END OF STRING ADDRESS'),
        (0xe7bf, 0xe7bf, 'SAVE STRING LENGTH IN TEMP DESCRIPTOR'),
        (0xe7c1, 0xe7c1, 'GET INITlAL STRING START'),
        (0xe7c3, 0xe7c3, 'COMPARE TO START OF STRING BUFFER'),
        (0xe7c7, 0xe7c7, 'BRANCH IF > START OF STRING BUFFER'),
        (0xe7c9, 0xe7c9, 'GO RESERVE SPACE FOR THE STRING'),
        (0xe7cb, 0xe7cb, 'POINT X TO THE BEGINNING OF THE STRING'),
        (0xe7cd, 0xe7cd, 'MOVE (B) BYTES FROM (X) TO'),
        (0xe7d0, 0xe7d0, 'GET NEXT AVAILABLE STRING STACK DESCRIPTOR'),
        (0xe7d2, 0xe7d2, 'COMPARE TO TOP OF STRING DESCRIPTOR STACK - WAS #CFNBUF'),
        (0xe7d5, 0xe7d5, 'FORMULA O.K.'),
        (0xe7d7, 0xe7d7, "STRING FORMULA TOO COMPLEX' ERROR"),
        (0xe7d9, 0xe7d9, 'JUMP TO ERROR SERVICING ROUTINE'),
        (0xe7dc, 0xe7dc, '* GET LENGTH OF STRING AND SAVE IT'),
        (0xe7de, 0xe7de, '0'),
        (0xe7e0, 0xe7e0, '= GET START ADDRESS OF ACTUAL STRING'),
        (0xe7e2, 0xe7e2, '= AND SAVE IN BYTES 2,3 OF DESCRIPTOR'),
        (0xe7e4, 0xe7e4, '* VARIABLE TYPE = STRING'),
        (0xe7e6, 0xe7e6, '* SAVE IN VARIABLE TYPE FLAG'),
        (0xe7e8, 0xe7e8, '= SAVE START OF DESCRIPTOR'),
        (0xe7ea, 0xe7ea, '= ADDRESS IN LASTPT AND FPA0'),
        (0xe7ec, 0xe7ec, '5 BYTES/STRING DESCRIPTOR'),
        (0xe7ee, 0xe7ee, 'NEXT AVAILABLE STRING VARIABLE DESCRIPTOR'),
        (0xe7f1, 0xe7f1, 'CLEAR STRING REORGANIZATION FLAG'),
        (0xe7f3, 0xe7f3, '* PUSH THE LENGTH OF THE'),
        (0xe7f4, 0xe7f4, '* STRING ONTO THE STACK'),
        (0xe7f6, 0xe7f6, 'GET START OF STRING VARIABLES'),
        (0xe7f8, 0xe7f8, 'SUBTRACT STRING LENGTH'),
        (0xe7fa, 0xe7fa, 'COMPARE TO START OF STRING STORAGE'),
        (0xe7fd, 0xe7fd, 'IF BELOW START, THEN REORGANIZE'),
        (0xe7ff, 0xe7ff, 'SAVE NEW START OF STRING VARIABLES'),
        (0xe801, 0xe801, 'GET START OF STRING VARIABLES'),
        (0xe803, 0xe803, 'ADD ONE'),
        (0xe805, 0xe805, 'SAVE START ADDRESS OF NEWLY RESERVED SPACE'),
        (0xe807, 0xe807, 'RESTORE NUMBER OF BYTES RESERVED AND RETURN'),
        (0xe809, 0xe809, "OUT OF STRING SPACE' ERROR"),
        (0xe80b, 0xe80b, 'TOGGLE REORGANIZATiON FLAG'),
        (0xe80d, 0xe80d, 'ERROR IF FRESHLY REORGANIZED'),
        (0xe80f, 0xe80f, 'GO REORGANIZE STRING SPACE'),
        (0xe811, 0xe811, 'GET BACK THE NUMBER OF BYTES TO RESERVE'),
        (0xe813, 0xe813, 'TRY TO RESERVE ACCB BYTES AGAIN'),
        (0xe815, 0xe815, 'GET THE TOP OF STRING SPACE'),
        (0xe817, 0xe817, 'SAVE TOP OF UNORGANIZED STRING SPACE'),
        (0xe819, 0xe819, '* ZERO OUT ACCD'),
        (0xe81a, 0xe81a, '* AND RESET VARIABLE'),
        (0xe81b, 0xe81b, '* POINTER TO 0'),
        (0xe81d, 0xe81d, 'POINT X TO START OF STRING SPACE'),
        (0xe81f, 0xe81f, 'SAVE POINTER IN V47'),
        (0xe821, 0xe821, 'POINT X TO START OF STRING DESCRIPTOR STACK'),
        (0xe824, 0xe824, 'COMPARE TO ADDRESS OF NEXT AVAILABLE DESCRIPTOR'),
        (0xe826, 0xe826, 'BRANCH IF TOP OF STRING STACK'),
        (0xe828, 0xe828, 'CHECK FOR STRING IN UNORGANIZED STRING SPACE'),
        (0xe82a, 0xe82a, 'KEEP CHECKING'),
        (0xe82c, 0xe82c, 'GET THE END OF BASIC PROGRAM'),
        (0xe82e, 0xe82e, 'COMPARE TO END OF VARIABLES'),
        (0xe830, 0xe830, 'BRANCH IF AT TOP OF VARIABLES'),
        (0xe832, 0xe832, 'CHECK FOR STRING IN UNORGANIZED STRING SPACE'),
        (0xe834, 0xe834, 'KEEP CHECKING VARIABLES'),
        (0xe836, 0xe836, 'SAVE ADDRESS OF THE END OF VARIABLES'),
        (0xe838, 0xe838, 'GET CURRENT ARRAY POINTER'),
        (0xe83a, 0xe83a, 'COMPARE TO THE END OF ARRAYS'),
        (0xe83c, 0xe83c, 'BRANCH IF AT END OF ARRAYS'),
        (0xe83e, 0xe83e, 'GET LENGTH OF ARRAY AND DESCRIPTOR'),
        (0xe840, 0xe840, '* ADD TO CURRENT ARRAY POINTER'),
        (0xe842, 0xe842, '* AND SAVE IT'),
        (0xe844, 0xe844, 'GET 1ST CHARACTER OF VARIABLE NAME'),
        (0xe846, 0xe846, 'BRANCH IF NUMERIC ARRAY'),
        (0xe848, 0xe848, 'GET THE NUMBER OF DIMENSIONS IN THIS ARRAY'),
        (0xe84a, 0xe84a, 'MULTIPLY BY 2'),
        (0xe84b, 0xe84b, 'ADD FIVE BYTES (VARIABLE NAME, ARRAY'),
        (0xe84d, 0xe84d, 'X NOW POINTS TO START OF ARRAY ELEMENTS'),
        (0xe84e, 0xe84e, 'AT END OF THIS ARRAY?'),
        (0xe850, 0xe850, 'YES - CHECK FOR ANOTHER'),
        (0xe852, 0xe852, 'CHECK FOR STRING LOCATED IN'),
        (0xe854, 0xe854, 'KEEP CHECKING ELEMENTS IN THIS ARRAY'),
        (0xe856, 0xe856, 'GET F1RST BYTE OF VARIABLE NAME'),
        (0xe858, 0xe858, 'MOVE POINTER TO DESCRIPTOR'),
        (0xe85a, 0xe85a, 'BRANCH IF VARIABLE IS NUMERIC'),
        (0xe85c, 0xe85c, 'GET THE LENGTH OF THE STRING'),
        (0xe85e, 0xe85e, 'BRANCH IF NULL - NO STRING'),
        (0xe860, 0xe860, 'GET STARTING ADDRESS OF THE STRING'),
        (0xe862, 0xe862, 'COMPARE TO THE START OF STRING VARIABLES'),
        (0xe865, 0xe865, 'BRANCH IF THIS STRING IS STORED IN'),
        (0xe867, 0xe867, 'COMPARE TO START OF STRING SPACE'),
        (0xe86a, 0xe86a, 'BRANCH IF NOT STORED IN THE STRING SPACE'),
        (0xe86c, 0xe86c, 'SAVE VARIABLE POINTER IF STORED IN STRING SPACE'),
        (0xe86e, 0xe86e, 'SAVE STRING STARTING ADDRESS'),
        (0xe870, 0xe870, 'MOVE TO NEXT VARIABLE DESCRIPTOR'),
        (0xe873, 0xe873, 'GET ADDRESS OF THE DESCRIPTOR FOR THE'),
        (0xe875, 0xe875, 'BRANCH IF NONE FOUND AND REORGANIZATION DONE'),
        (0xe877, 0xe877, 'CLEAR MS BYTE OF LENGTH'),
        (0xe878, 0xe878, 'GET LENGTH OF STRING'),
        (0xe87a, 0xe87a, 'SUBTRACT ONE'),
        (0xe87b, 0xe87b, 'ADD LENGTH OF STRING TO ITS STARTING ADDRESS'),
        (0xe87d, 0xe87d, 'SAVE AS MOVE STARTING ADDRESS'),
        (0xe87f, 0xe87f, 'POINT X TO THE START OF ORGANIZED STRING VARIABLES'),
        (0xe881, 0xe881, 'SAVE AS MOVE ENDING ADDRESS'),
        (0xe883, 0xe883, 'MOVE STRING FROM CURRENT POSITION TO THE'),
        (0xe886, 0xe886, 'POINT X TO STRING DESCRIPTOR'),
        (0xe888, 0xe888, '* GET NEW STARTING ADDRESS OF STRING AND'),
        (0xe88a, 0xe88a, '* SAVE IT IN DESCRIPTOR'),
        (0xe88c, 0xe88c, 'GET NEW TOP OF UNORGANIZED STRING SPACE'),
        (0xe88e, 0xe88e, 'MOVE POINTER BACK ONE'),
        (0xe890, 0xe890, 'JUMP BACK AND REORGANIZE SOME MORE'),
        (0xe893, 0xe893, '* GET DESCRIPTOR ADDRESS OF STRING A'),
        (0xe895, 0xe895, '* AND SAVE IT ON THE STACK'),
        (0xe897, 0xe897, 'GET DESCRIPTOR ADDRESS OF STRING B'),
        (0xe89a, 0xe89a, "TM' ERROR IF NUMERIC VARIABLE"),
        (0xe89d, 0xe89d, '* POINT X TO STRING A DESCRIPTOR'),
        (0xe89f, 0xe89f, '* ADDRESS AND SAVE IT IN RESSGN'),
        (0xe8a1, 0xe8a1, 'GET LENGTH OF STRING A'),
        (0xe8a3, 0xe8a3, 'POINT X TO DESCRIPTOR OF STRING B'),
        (0xe8a5, 0xe8a5, 'ADD LENGTH OF STRING B TO STR1NG A'),
        (0xe8a7, 0xe8a7, 'BRANCH IF LENGTH < 256'),
        (0xe8a9, 0xe8a9, "STRING TOO LONG' ERROR IF LENGTH > 255"),
        (0xe8ab, 0xe8ab, 'JUMP TO ERROR SERVICING ROUTINE'),
        (0xe8ae, 0xe8ae, 'RESERVE ROOM IN STRING SPACE FOR NEW STRING'),
        (0xe8b1, 0xe8b1, 'GET DESCRIPTOR ADDRESS OF STRING A'),
        (0xe8b3, 0xe8b3, 'GET LENGTH OF STRING A'),
        (0xe8b5, 0xe8b5, 'MOVE STRING A INTO RESERVED BUFFER IN STRING SPACE'),
        (0xe8b7, 0xe8b7, 'GET DESCRIPTOR ADDRESS OF STRING B'),
        (0xe8b9, 0xe8b9, 'GET LENGTH AND ADDRESS OF STRING B'),
        (0xe8bb, 0xe8bb, 'MOVE STRING B INTO REST OF RESERVED BUFFER'),
        (0xe8bd, 0xe8bd, 'POINT X TO DESCRIPTOR OF STRING A'),
        (0xe8bf, 0xe8bf, 'DELETE STRING A IF LAST STRING ON STRING STACK'),
        (0xe8c1, 0xe8c1, 'PUT STRING DESCRIPTOR ON THE STRING STACK'),
        (0xe8c4, 0xe8c4, 'BRANCH BACK TO EXPRESSION EVALUATION'),
        (0xe8c7, 0xe8c7, 'POINT X TO SOURCE ADDRESS'),
        (0xe8c9, 0xe8c9, 'POINT U TO DESTINATION ADDRESS'),
        (0xe8cb, 0xe8cb, 'COMPENSATION FOR THE DECB BELOW'),
        (0xe8cc, 0xe8cc, 'GO MOVE THE BYTES'),
        (0xe8ce, 0xe8ce, '* GET A SOURCE BYTE AND MOVE IT'),
        (0xe8d0, 0xe8d0, '* TO THE DESTINATION'),
        (0xe8d2, 0xe8d2, 'DECREMENT BYTE COUNTER'),
        (0xe8d3, 0xe8d3, 'BRANCH IF ALL BYTES NOT MOVED'),
        (0xe8d5, 0xe8d5, 'SAVE ENDING ADDRESS IN FRESPC'),
        (0xe8d8, 0xe8d8, "TM' ERROR IF VARIABLE TYPE = NUMERIC"),
        (0xe8db, 0xe8db, 'GET ADDRESS OF SELECTED STRING DESCRIPTOR'),
        (0xe8dd, 0xe8dd, 'GET LENGTH OF STRING'),
        (0xe8df, 0xe8df, '* CHECK TO SEE IF THIS STRING DESCRIPTOR WAS'),
        (0xe8e1, 0xe8e1, '* THE LAST ONE PUT ON THE STRING STACK AND'),
        (0xe8e3, 0xe8e3, 'GET START ADDRESS OF STRING JUST REMOVED'),
        (0xe8e5, 0xe8e5, 'MOVE POINTER DOWN ONE'),
        (0xe8e7, 0xe8e7, 'COMPARE TO START OF STRING VARIABLES'),
        (0xe8e9, 0xe8e9, 'BRANCH IF THIS STRING IS NOT AT THE BOTTOM'),
        (0xe8eb, 0xe8eb, 'SAVE LENGTH; ACCA WAS CLEARED'),
        (0xe8ed, 0xe8ed, '* ADD THE LENGTH OF THE JUST REMOVED STRING'),
        (0xe8ef, 0xe8ef, '* TO THE START OF STRING VARIABLES - THIS WILL'),
        (0xe8f1, 0xe8f1, 'RESTORE LENGTH'),
        (0xe8f3, 0xe8f3, 'ADD ONE TO POINTER'),
        (0xe8f6, 0xe8f6, '*POINT X TO ADDRESS OF STRING NOT'),
        (0xe8f8, 0xe8f8, '*ON THE STRING STACK'),
        (0xe8f9, 0xe8f9, '*COMPARE TO LAST USED DESCRIPTOR ADDRESS'),
        (0xe8fb, 0xe8fb, '*ON THE STRING STACK, RETURN IF DESCRIPTOR'),
        (0xe8fd, 0xe8fd, 'SAVE LAST USED DESCRIPTOR AS NEXT AVAILABLE'),
        (0xe8ff, 0xe8ff, '* MOVE LAST USED DESCRIPTOR BACK 5 BYTES'),
        (0xe901, 0xe901, '* AND SAVE AS THE LAST USED DESCRIPTOR ADDR'),
        (0xe903, 0xe903, 'SET ZERO FLAG'),
        (0xe905, 0xe905, 'POINT X TO PROPER STRING AND GET LENGTH'),
        (0xe907, 0xe907, 'CONVERT ACCB TO FP NUMBER IN FPA0'),
        (0xe90a, 0xe90a, 'GET LENGTH AND ADDRESS OF STRING'),
        (0xe90c, 0xe90c, 'SET VARIABLE TYPE TO NUMERIC'),
        (0xe90e, 0xe90e, 'SET FLAGS ACCORDING TO LENGTH'),
        (0xe910, 0xe910, 'CONVERT FPA0 TO AN INTEGER IN ACCD'),
        (0xe913, 0xe913, '* RESERVE ONE BYTE IN'),
        (0xe915, 0xe915, '* THE STRING SPACE'),
        (0xe918, 0xe918, 'GET ASCII STRING VALUE'),
        (0xe91a, 0xe91a, 'SAVE RESERVED STRING DESCRIPTOR IN TEMP DESCRIPTOR'),
        (0xe91d, 0xe91d, "SAVE THE STRING (IT'S ONLY ONE BYTE)"),
        (0xe91f, 0xe91f, 'PURGE THE RETURN ADDRESS OFF OF THE STACK'),
        (0xe921, 0xe921, 'PUT TEMP DESCRIPTOR DATA ONTO STRING STACK'),
        (0xe924, 0xe924, 'PUT 1ST CHARACTER OF STRING INTO ACCB'),
        (0xe926, 0xe926, 'CONVERT ACCB INTO FP NUMBER IN FPA0'),
        (0xe928, 0xe928, 'POINT X TO STRING DESCRIPTOR'),
        (0xe92a, 0xe92a, "FC' ERROR IF NULL STRING"),
        (0xe92c, 0xe92c, 'GET FIRST BYTE OF STRING'),
        (0xe92f, 0xe92f, 'GET ARGUMENTS FROM STACK'),
        (0xe931, 0xe931, 'CLEAR STRING POINTER OFFSET - OFFSET = 0 FOR LEFT$'),
        (0xe932, 0xe932, '* COMPARE LENGTH PARAMETER TO LENGTH OF'),
        (0xe934, 0xe934, '* STRING AND BRANCH IF LENGTH OF STRING'),
        (0xe936, 0xe936, 'USE LENGTH OF STRING OTHERWISE'),
        (0xe938, 0xe938, 'CLEAR STRING POINTER OFFSET (0 FOR LEFT$)'),
        (0xe939, 0xe939, 'PUSH PARAMETERS ONTO STACK'),
        (0xe93b, 0xe93b, 'RESERVE ACCB BYTES IN THE STRING SPACE'),
        (0xe93e, 0xe93e, 'POINT X TO STRING DESCRIPTOR'),
        (0xe940, 0xe940, 'GET ADDRESS OF OLD STRING (X=ADDRESS)'),
        (0xe942, 0xe942, '* PULL STRING POINTER OFFSET OFF OF THE STACK'),
        (0xe944, 0xe944, '* AND ADD IT TO STRING ADDRESS'),
        (0xe945, 0xe945, 'PULL LENGTH PARAMETER OFF OF THE STACK'),
        (0xe947, 0xe947, 'MOVE ACCB BYTES FROM (X) TO [FRESPC]'),
        (0xe94a, 0xe94a, 'PUT TEMP STRING DESCRIPTOR ONTO THE STRING STACK'),
        (0xe94c, 0xe94c, 'GET ARGUMENTS FROM STACK'),
        (0xe94e, 0xe94e, 'ACCA=LENGTH PARAMETER - LENGTH OF OLD STRING'),
        (0xe950, 0xe950, 'NOW ACCA = LENGTH OF OLD STRING'),
        (0xe951, 0xe951, 'PUT NEW STRING IN THE STRING SPACE'),
        (0xe953, 0xe953, '* GET DEFAULT VALUE OF LENGTH AND'),
        (0xe955, 0xe955, '* SAVE IT IN FPA0'),
        (0xe957, 0xe957, 'GET CURRENT CHARACTER FROM BASIC'),
        (0xe959, 0xe959, 'ARGUMENT DELIMITER?'),
        (0xe95b, 0xe95b, 'YES - NO LENGTH PARAMETER GIVEN'),
        (0xe95d, 0xe95d, 'SYNTAX CHECK FOR COMMA'),
        (0xe960, 0xe960, 'EVALUATE NUMERIC EXPRESSION (LENGTH)'),
        (0xe962, 0xe962, 'GET ARGUMENTS FROM STACK'),
        (0xe964, 0xe964, "FC' ERROR IF NULL STRING"),
        (0xe966, 0xe966, 'CLEAR LENGTH COUNTER (DEFAULT VALUE)'),
        (0xe967, 0xe967, '*SUOTRACT ONE FROM POSITION PARAMETER (THESE'),
        (0xe968, 0xe968, '*ROUTINES EXPECT 1ST POSITION TO BE ZERO, NOT ONE)'),
        (0xe96a, 0xe96a, 'IF POSITION > LENGTH OF OLD STRING, THEN NEW'),
        (0xe96c, 0xe96c, 'SAVE ABSOLUTE POSITION PARAMETER IN ACCB'),
        (0xe96e, 0xe96e, 'ACCB=POSITION-LENGTH OF OLD STRING'),
        (0xe970, 0xe970, 'NOW ACCB=LENGTH OF OLDSTRING-POSITION'),
        (0xe971, 0xe971, '*IF THE AMOUNT OF OLD STRING TO THE RIGHT OF'),
        (0xe973, 0xe973, '*POSITION IS <= THE LENGTH PARAMETER, BRANCH AND'),
        (0xe975, 0xe975, 'GET LENGTH OF NEW STRING'),
        (0xe977, 0xe977, 'PUT NEW STRING IN STRING SPACE'),
        (0xe979, 0xe979, 'SYNTAX CHECK FOR A ")"'),
        (0xe97c, 0xe97c, 'LOAD THE RETURN ADDRESS INTO U REGISTER'),
        (0xe97e, 0xe97e, '* GET ADDRESS OF STRING AND'),
        (0xe980, 0xe980, '* SAVE IT IN V4D'),
        (0xe982, 0xe982, '= PUT LENGTH OF STRING IN'),
        (0xe984, 0xe984, '= BOTH ACCA AND ACCB'),
        (0xe986, 0xe986, 'REMOVE DESCRIPTOR AND RETURN ADDRESS FROM STACK'),
        (0xe988, 0xe988, 'JUMP TO ADDRESS IN U REGISTER'),
        (0xe98a, 0xe98a, "ILLEGAL FUNCTION CALL'"),
        (0xe98d, 0xe98d, 'GET NEXT BASIC INPUT CHARACTER'),
        (0xe98f, 0xe98f, 'EVALUATE A NUMERIC EXPRESSION'),
        (0xe992, 0xe992, 'CONVERT FPA0 TO INTEGER IN ACCD'),
        (0xe995, 0xe995, 'TEST MS BYTE OF INTEGER'),
        (0xe996, 0xe996, "FC' ERROR IF EXPRESSION > 255"),
        (0xe998, 0xe998, 'GET CURRENT INPUT CHARACTER FROM BASIC'),
        (0xe99a, 0xe99a, 'POINT X TO STRING ADDRESS'),
        (0xe99d, 0xe99d, 'IF NULL STRING SET FPA0'),
        (0xe9a1, 0xe9a1, 'SAVE INPUT POINTER IN REGISTER U'),
        (0xe9a3, 0xe9a3, 'POINT INPUT POINTER TO ADDRESS OF STRING'),
        (0xe9a5, 0xe9a5, 'TO END OF STRING TERMINATOR'),
        (0xe9a6, 0xe9a6, 'GET LAST BYTE OF STRING'),
        (0xe9a8, 0xe9a8, 'SAVE INPUT POINTER, STRING TERMINATOR'),
        (0xe9aa, 0xe9aa, 'CLEAR STRING TERMINATOR : FOR ASCII - FP CONVERSION'),
        (0xe9ac, 0xe9ac, 'GET CURRENT CHARACTER FROM BASIC'),
        (0xe9ae, 0xe9ae, 'CONVERT AN ASCII STRING TO FLOATING POINT'),
        (0xe9b1, 0xe9b1, 'RESTORE CHARACTERS AND POINTERS'),
        (0xe9b3, 0xe9b3, 'REPLACE STRING TERMINATOR'),
        (0xe9b5, 0xe9b5, 'RESTORE INPUT CHARACTER'),
        (0xe9b8, 0xe9b8, '* EVALUATE AN EXPRESSION, RETURN'),
        (0xe9ba, 0xe9ba, '* THE VALUE IN X; STORE IT IN BINVAL'),
        (0xe9bc, 0xe9bc, 'SYNTAX CHECK FOR A COMMA'),
        (0xe9bf, 0xe9bf, 'EVALUATE EXPRESSION IN RANGE 0 <= X < 256'),
        (0xe9c1, 0xe9c1, 'EVALUATE NUMERIC EXPRESSION'),
        (0xe9c4, 0xe9c4, 'GET SIGN OF FPA0 MANTISSA'),
        (0xe9c6, 0xe9c6, "ILLEGAL FUNCTION CALL' IF NEGATIVE"),
        (0xe9c8, 0xe9c8, 'GET EXPONENT OF FPA0'),
        (0xe9ca, 0xe9ca, 'COMPARE TO LARGEST POSITIVE INTEGER'),
        (0xe9cc, 0xe9cc, "ILLEGAL FUNCTION CALL' IF TOO LARGE"),
        (0xe9ce, 0xe9ce, 'SHIFT BINARY POINT TO EXTREME RIGHT OF FPA0'),
        (0xe9d1, 0xe9d1, 'LOAD X WITH LOWER TWO BYTES OF FPA0'),
        (0xe9d4, 0xe9d4, 'CONVERT FPA0 TO INTEGER IN REGISTER X'),
        (0xe9d6, 0xe9d6, "GET THE VALUE BEING 'PEEK'ED"),
        (0xe9d8, 0xe9d8, 'CONVERT ACCB INTO A FP NUMBER'),
        (0xe9db, 0xe9db, 'EVALUATE 2 EXPRESSIONS'),
        (0xe9dd, 0xe9dd, "GET THE ADDRESS TO BE 'POKE'ED"),
        (0xe9df, 0xe9df, 'STORE THE DATA IN THAT ADDRESS'),
        (0xe9e2, 0xe9e2, 'SAVE ZERO FLAG ON STACK'),
        (0xe9e4, 0xe9e4, 'CONVERT DECIMAL LINE NUMBER TO BINARY'),
        (0xe9e7, 0xe9e7, '* FIND RAM ADDRESS OF THAT LINE NUMBER AND'),
        (0xe9ea, 0xe9ea, '* SAVE IT IN LSTTXT'),
        (0xe9ec, 0xe9ec, 'GET ZERO FLAG FROM STACK'),
        (0xe9ee, 0xe9ee, 'BRANCH IF END OF LINE'),
        (0xe9f0, 0xe9f0, 'GET CURRENT CHARACTER FROM BASIC'),
        (0xe9f2, 0xe9f2, 'BRANCH IF END OF LINE'),
        (0xe9f4, 0xe9f4, 'MINUS TOKEN (IS IT A RANGE OF LINE NUMBERS?)'),
        (0xe9f6, 0xe9f6, 'NO - RETURN'),
        (0xe9f8, 0xe9f8, 'GET NEXT CHARACTER FROM BASIC'),
        (0xe9fa, 0xe9fa, 'BRANCH IF END OF LINE'),
        (0xe9fc, 0xe9fc, 'GET ENDING LINE NUMBER'),
        (0xe9ff, 0xe9ff, 'BRANCH IF LEGAL LINE NUMBER'),
        (0xea02, 0xea02, '* SET THE DEFAULT ENDING LINE NUMBER'),
        (0xea05, 0xea05, '* TO $FFFF'),
        (0xea07, 0xea07, 'PURGE RETURN ADDRESS FROM THE STACK'),
        (0xea09, 0xea09, 'POINT X TO STARTING LINE ADDRESS'),
        (0xea0b, 0xea0b, 'MOVE CURSOR TO START OF A NEW LINE'),
        (0xea0e, 0xea0e, 'CHECK FOR A BREAK OR PAUSE'),
        (0xea11, 0xea11, 'GET ADDRESS OF NEXT BASIC LINE'),
        (0xea13, 0xea13, 'BRANCH IF NOT END OF PROGRAM'),
        (0xea15, 0xea15, "RETURN TO BASIC'S MAIN INPUT LOOP"),
        (0xea18, 0xea18, 'SAVE NEW STARTING LINE ADDRESS'),
        (0xea1a, 0xea1a, '* GET THE LINE NUMBER OF THIS LINE AND'),
        (0xea1c, 0xea1c, '* COMPARE IT TO ENDING LINE NUMBER'),
        (0xea1f, 0xea1f, 'EXIT IF LINE NUMBER > ENDING LINE NUMBER'),
        (0xea21, 0xea21, 'PRINT THE NUMBER IN ACCD ON SCREEN IN DECIMAL'),
        (0xea24, 0xea24, 'SEND A SPACE TO CONSOLE OUT'),
        (0xea27, 0xea27, 'GET RAM ADDRESS OF THIS LINE'),
        (0xea29, 0xea29, 'UNCRUNCH A LINE'),
        (0xea2b, 0xea2b, 'POINT X TO START OF NEXT LINE'),
        (0xea2f, 0xea2f, 'POINT U TO BUFFER FULL OF UNCRUNCHED LINE'),
        (0xea32, 0xea32, 'GET A BYTE FROM THE BUFFER'),
        (0xea34, 0xea34, 'BRANCH IF END OF BUFFER'),
        (0xea36, 0xea36, 'SEND CHARACTER TO CONSOLE OUT'),
        (0xea39, 0xea39, 'GET ANOTHER CHARACTER'),
        (0xea3b, 0xea3b, 'MOVE POINTER PAST ADDRESS OF NEXT LINE AND LINE NUMBER'),
        (0xea3d, 0xea3d, 'UNCRUNCH LINE INTO LINE INPUT BUFFER'),
        (0xea41, 0xea41, 'GET A CHARACTER'),
        (0xea43, 0xea43, 'BRANCH IF END OF LINE'),
        (0xea45, 0xea45, "BRANCH IF IT'S A TOKEN"),
        (0xea47, 0xea47, 'CHECK FOR END OF SUB LINE'),
        (0xea49, 0xea49, 'BRNCH IF NOT END OF SUB LINE'),
        (0xea4b, 0xea4b, 'GET CHARACTER FOLLOWING COLON'),
        (0xea4d, 0xea4d, 'TOKEN FOR ELSE?'),
        (0xea4f, 0xea4f, "YES - DON'T PUT IT IN BUFFER"),
        (0xea51, 0xea51, 'TOKEN FOR REMARK?'),
        (0xea53, 0xea53, "YES - DON'T PUT IT IN BUFFER"),
        (0xea55, 0xea55, 'SKIP TWO BYTES'),
        (0xea56, 0xea56, 'EXCLAMATION POINT'),
        (0xea58, 0xea58, 'PUT CHARACTER IN BUFFER'),
        (0xea5a, 0xea5a, 'GET ANOTHER CHARACTER'),
        (0xea5c, 0xea5c, 'FIRST DO COMMANDS'),
        (0xea5f, 0xea5f, 'CHECK FOR SECONDARY TOKEN'),
        (0xea61, 0xea61, 'BRANCH IF NON SECONDARY TOKEN'),
        (0xea63, 0xea63, 'GET SECONDARY TOKEN'),
        (0xea65, 0xea65, 'BUMP IT UP TO SECONDARY FUNCTIONS'),
        (0xea67, 0xea67, 'MASK OFF BIT 7 OF TOKEN'),
        (0xea69, 0xea69, 'MOVE TO NEXT COMMAND TABLE'),
        (0xea6b, 0xea6b, 'IS THIS TABLE ENABLED?'),
        (0xea6d, 0xea6d, 'NO - ILLEGAL TOKEN'),
        (0xea6f, 0xea6f, 'SUBTRACT THE NUMBER OF TOKENS FROM THE CURRENT TOKEN NUMBER'),
        (0xea71, 0xea71, 'BRANCH IF TOKEN NOT IN THIS TABLE'),
        (0xea73, 0xea73, 'RESTORE TOKEN NUMBER RELATIVE TO THIS TABLE'),
        (0xea75, 0xea75, 'POINT U TO COMMAND DICTIONARY TABLE'),
        (0xea77, 0xea77, 'DECREMENT TOKEN NUMBER'),
        (0xea78, 0xea78, 'BRANCH IF THIS IS THE CORRECT TOKEN'),
        (0xea7a, 0xea7a, 'GRAB A BYTE'),
        (0xea7c, 0xea7c, 'BRANCH IF BIT 7 NOT SET'),
        (0xea7e, 0xea7e, 'GO SEE IF THIS IS THE CORRECT TOKEN'),
        (0xea80, 0xea80, 'GET A CHARACTER FROM DICTIONARY TABLE'),
        (0xea82, 0xea82, 'PUT CHARACTER IN BUFFER'),
        (0xea84, 0xea84, 'CHECK FOR START OF NEXT TOKEN'),
        (0xea86, 0xea86, 'BRANCH IF NOT DONE WITH THIS TOKEN'),
        (0xea88, 0xea88, 'GO GET ANOTHER CHARACTER'),
        (0xea8a, 0xea8a, 'TEST FOR END OF LINE INPUT BUFFER'),
        (0xea8e, 0xea8e, 'BRANCH IF AT END OF BUFFER'),
        (0xea90, 0xea90, 'MASK OFF BIT 7'),
        (0xea92, 0xea92, '* SAVE CHARACTER IN BUFFER AND'),
        (0xea94, 0xea94, '* CLEAR NEXT CHARACTER SLOT IN BUFFER'),
        (0xea97, 0xea97, "GET BASIC'S INPUT POINTER ADDRESS"),
        (0xea99, 0xea99, 'POINT X TO LINE INPUT BUFFER'),
        (0xea9c, 0xea9c, 'CLEAR ILLEGAL TOKEN FLAG'),
        (0xea9e, 0xea9e, 'CLEAR DATA FLAG'),
        (0xeaa0, 0xeaa0, 'GET INPUT CHAR'),
        (0xeaa2, 0xeaa2, 'BRANCH IF END OF LINE'),
        (0xeaa4, 0xeaa4, '* CHECK ILLEGAL TOKEN FLAG & BRANCH IF NOT'),
        (0xeaa6, 0xeaa6, '* PROCESSING AN ILLEGAL TOKEN'),
        (0xeaa8, 0xeaa8, 'SET CARRY IF NOT UPPER CASE ALPHA'),
        (0xeaab, 0xeaab, 'BRANCH IF UPPER CASE ALPHA'),
        (0xeaad, 0xeaad, "* DON'T CRUNCH ASCII NUMERIC CHARACTERS"),
        (0xeaaf, 0xeaaf, '* BRANCH IF NOT NUMERIC'),
        (0xeab3, 0xeab3, '* BRANCH IF NUMERIC'),
        (0xeab5, 0xeab5, 'CLEAR ILLEGAL TOKEN FLAG'),
        (0xeab7, 0xeab7, 'SPACE?'),
        (0xeab9, 0xeab9, 'DO NOT REMOVE SPACES'),
        (0xeabb, 0xeabb, 'SAVE INPUT CHARACTER AS SCAN DELIMITER'),
        (0xeabd, 0xeabd, 'CHECK FOR STRING DELIMITER'),
        (0xeabf, 0xeabf, 'BRANCH IF STRING'),
        (0xeac1, 0xeac1, '* CHECK DATA FLAG AND BRANCH IF CLEAR'),
        (0xeac3, 0xeac3, '* DO NOT CRUNCH DATA'),
        (0xeac5, 0xeac5, 'SAVE CHARACTER IN BUFFER'),
        (0xeac7, 0xeac7, 'BRANCH IF END OF LINE'),
        (0xeac9, 0xeac9, '* CHECK FOR END OF SUBLINE'),
        (0xeacb, 0xeacb, '* AND RESET FLAGS IF END OF SUBLINE'),
        (0xeacd, 0xeacd, 'GO GET ANOTHER CHARACTER'),
        (0xeacf, 0xeacf, '* DOUBLE ZERO AT END OF LINE'),
        (0xead3, 0xead3, 'SAVE ADDRESS OF END OF LINE IN ACCD'),
        (0xead5, 0xead5, 'LENGTH OF LINE IN ACCD'),
        (0xead8, 0xead8, '* SET THE INPUT POINTER TO ONE BEFORE'),
        (0xeadb, 0xeadb, '* THE START OF THE CRUNCHED LINE'),
        (0xeadd, 0xeadd, "CRUNCH'"),
        (0xeade, 0xeade, 'CHECK FOR "?" - PRINT ABBREVIATION'),
        (0xeae0, 0xeae0, 'BRANCH IF NOT PRINT ABBREVIATION'),
        (0xeae2, 0xeae2, '* GET THE PRINT TOKEN AND SAVE IT'),
        (0xeae4, 0xeae4, '* IN BUFFER'),
        (0xeae6, 0xeae6, 'APOSTROPHE IS SAME AS REM'),
        (0xeae8, 0xeae8, 'BRANCH IF NOT REMARK'),
        (0xeaea, 0xeaea, 'COLON, REM TOKEN'),
        (0xeaed, 0xeaed, 'SAVE IN BUFFER'),
        (0xeaef, 0xeaef, 'SET DELIMITER = 0 (END OF LINE)'),
        (0xeaf1, 0xeaf1, 'SCAN TILL WE MATCH [V42]'),
        (0xeaf3, 0xeaf3, 'BRANCH IF END OF LINE'),
        (0xeaf5, 0xeaf5, 'DELIMITER?'),
        (0xeaf7, 0xeaf7, 'BRANCH OUT IF SO'),
        (0xeaf9, 0xeaf9, "DON'T CRUNCH REMARKS OR STRINGS"),
        (0xeafb, 0xeafb, 'GO GET MORE STRING OR REMARK'),
        (0xeafd, 0xeafd, '* LESS THAN ASCII ZERO?'),
        (0xeaff, 0xeaff, '* BRANCH IF SO'),
        (0xeb01, 0xeb01, '= CHECK FOR NUMERIC VALUE, COLON OR SEMICOLON'),
        (0xeb03, 0xeb03, '= AND INSERT IN BUFFER IF SO'),
        (0xeb05, 0xeb05, 'MOVE INPUT POINTER BACK ONE'),
        (0xeb07, 0xeb07, 'SAVE POINTERS TO INPUT STRING, OUTPUT STRING'),
        (0xeb09, 0xeb09, 'TOKEN FLAG 0 = COMMAND, FF = SECONDARY'),
        (0xeb0b, 0xeb0b, 'POINT U TO COMMAND INTERPRETATION'),
        (0xeb0e, 0xeb0e, 'INITIALIZE V42 AS TOKEN COUNTER'),
        (0xeb10, 0xeb10, 'MOVE TO NEXT COMMAND INTERPRETATION TABLE'),
        (0xeb12, 0xeb12, 'GET NUMBER OF COMMANDS'),
        (0xeb14, 0xeb14, 'GO DO SECONDARY FUNCTIONS IF NO COMMAND TABLE'),
        (0xeb16, 0xeb16, 'POINT Y TO COMMAND DICTIONARY TABLE'),
        (0xeb19, 0xeb19, 'GET POINTER TO INPUT STRING'),
        (0xeb1b, 0xeb1b, 'GET A BYTE FROM DICTIONARY TABLE'),
        (0xeb1d, 0xeb1d, 'SUBTRACT INPUT CHARACTER'),
        (0xeb1f, 0xeb1f, 'LOOP IF SAME'),
        (0xeb21, 0xeb21, 'LAST CHAR IN RESERVED WORD TABLE HAD'),
        (0xeb23, 0xeb23, 'BRANCH IF NO MATCH - CHECK ANOTHER COMMAND'),
        (0xeb25, 0xeb25, 'DELETE OLD INPUT POINTER FROM STACK'),
        (0xeb27, 0xeb27, 'GET POINTER TO OUTPUT STRING'),
        (0xeb29, 0xeb29, 'OR IN THE TABLE POSITION TO MAKE THE TOKEN'),
        (0xeb2b, 0xeb2b, '* CHECK TOKEN FLAG AND BRANCH'),
        (0xeb2d, 0xeb2d, '* IF SECONDARY'),
        (0xeb2f, 0xeb2f, 'IS IT ELSE TOKEN?'),
        (0xeb31, 0xeb31, 'NO'),
        (0xeb33, 0xeb33, 'PUT A COLON (SUBLINE) BEFORE ELSE TOKEN'),
        (0xeb35, 0xeb35, 'SECONDARY TOKENS PRECEEDED BY $FF'),
        (0xeb37, 0xeb37, 'GO PROCESS MORE INPUT CHARACTERS'),
        (0xeb39, 0xeb39, 'SAVE THIS TOKEN'),
        (0xeb3b, 0xeb3b, 'DATA TOKEN?'),
        (0xeb3d, 0xeb3d, 'NO'),
        (0xeb3f, 0xeb3f, 'SET DATA FLAG'),
        (0xeb41, 0xeb41, 'REM TOKEN?'),
        (0xeb43, 0xeb43, 'YES'),
        (0xeb45, 0xeb45, 'GO PROCESS MORE INPUT CHARACTERS'),
        (0xeb47, 0xeb47, 'NOW DO SECONDARY FUNCTIONS'),
        (0xeb4a, 0xeb4a, 'TOGGLE THE TOKEN FLAG'),
        (0xeb4c, 0xeb4c, 'BRANCH IF NOW CHECKING SECONDARY COMMANDS'),
        (0xeb4e, 0xeb4e, 'RESTORE INPUT AND OUTPUT POINTERS'),
        (0xeb50, 0xeb50, '* MOVE THE FIRST CHARACTER OF AN'),
        (0xeb52, 0xeb52, '* ILLEGAL TOKEN'),
        (0xeb54, 0xeb54, 'SET CARRY IF NOT ALPHA'),
        (0xeb57, 0xeb57, 'BRANCH IF NOT ALPHA'),
        (0xeb59, 0xeb59, 'SET ILLEGAL TOKEN FLAG IF UPPER CASE ALPHA'),
        (0xeb5b, 0xeb5b, 'PROCESS MORE INPUT CHARACTERS'),
        (0xeb5d, 0xeb5d, 'INCREMENT TOKEN COUNTER'),
        (0xeb5f, 0xeb5f, 'DECR COMMAND COUNTER'),
        (0xeb60, 0xeb60, 'GET ANOTHER COMMAND TABLE IF DONE W/THIS ONE'),
        (0xeb62, 0xeb62, 'MOVE POINTER BACK ONE'),
        (0xeb64, 0xeb64, '* GET TO NEXT'),
        (0xeb66, 0xeb66, '* RESERVED WORD'),
        (0xeb68, 0xeb68, 'GO SEE IF THIS WORD IS A MATCH'),
        (0xeb6a, 0xeb6a, 'BRANCH IF NO ARGUMENT'),
        (0xeb6c, 0xeb6c, 'CHECK FOR ALL PRINT OPTIONS'),
        (0xeb6f, 0xeb6f, 'CALL EXTENDED BASIC ADD-IN'),
        (0xeb72, 0xeb72, 'RETURN IF END OF LINE'),
        (0xeb74, 0xeb74, 'TOKEN FOR TAB( ?'),
        (0xeb76, 0xeb76, 'YES'),
        (0xeb78, 0xeb78, 'COMMA?'),
        (0xeb7a, 0xeb7a, 'YES - ADVANCE TO NEXT TAB FIELD'),
        (0xeb7c, 0xeb7c, 'SEMICOLON?'),
        (0xeb7e, 0xeb7e, 'YES - DO NOT ADVANCE CURSOR'),
        (0xeb80, 0xeb80, 'EVALUATE EXPRESSION'),
        (0xeb83, 0xeb83, '* GET VARIABLE TYPE AND'),
        (0xeb85, 0xeb85, '* SAVE IT ON THE STACK'),
        (0xeb87, 0xeb87, 'BRANCH IF STRING VARIABLE'),
        (0xeb89, 0xeb89, 'CONVERT FP NUMBER TO AN ASCII STRING'),
        (0xeb8c, 0xeb8c, 'PARSE A STRING FROM (X-1) AND PUT'),
        (0xeb8f, 0xeb8f, 'PRINT STRING POINTED TO BY X'),
        (0xeb91, 0xeb91, 'GET VARIABLE TYPE BACK'),
        (0xeb93, 0xeb93, 'SET UP TAB WIDTH ZONE, ETC'),
        (0xeb96, 0xeb96, 'CHECK CURRENT PRINT POSITION'),
        (0xeb97, 0xeb97, 'BRANCH IF NOT AT START OF LINE'),
        (0xeb99, 0xeb99, 'GET CURRENT INPUT CHARACTER'),
        (0xeb9b, 0xeb9b, 'COMMA?'),
        (0xeb9d, 0xeb9d, 'SKIP TO NEXT TAB FIELD'),
        (0xeb9f, 0xeb9f, 'SEND A SPACE TO CONSOLE OUT'),
        (0xeba1, 0xeba1, 'GET CURRENT INPUT CHARACTER'),
        (0xeba3, 0xeba3, 'BRANCH IF NOT END OF LINE'),
        (0xeba5, 0xeba5, '* SEND A CR TO'),
        (0xeba7, 0xeba7, '* CONSOLE OUT'),
        (0xeba9, 0xeba9, 'SET UP TAB WIDTH, ZONE ETC'),
        (0xebac, 0xebac, 'BRANCH IF WIDTH = ZERO'),
        (0xebae, 0xebae, 'GET PRINT POSITION'),
        (0xebb0, 0xebb0, 'BRANCH IF NOT AT START OF LINE'),
        (0xebb3, 0xebb3, 'SET UP TAB WIDTH, ZONE ETC'),
        (0xebb6, 0xebb6, 'BRANCH IF LINE WIDTH = 0 (CASSETTE)'),
        (0xebb8, 0xebb8, 'GET CURRENT POSITION'),
        (0xebba, 0xebba, 'COMPARE TO LAST TAB ZONE'),
        (0xebbc, 0xebbc, 'BRANCH IF < LAST TAB ZONE'),
        (0xebbe, 0xebbe, 'SEND A CARRIAGE RETURN TO CONSOLE OUT'),
        (0xebc0, 0xebc0, 'GET MORE DATA'),
        (0xebc4, 0xebc4, '* SUBTRACT TAB FIELD WIDTH FROM CURRENT'),
        (0xebc6, 0xebc6, '* POSITION UNTIL CARRY SET - NEGATING THE'),
        (0xebc8, 0xebc8, '* REMAINDER LEAVES THE NUMBER OF SPACES TO NEXT'),
        (0xebc9, 0xebc9, 'GO ADVANCE TO NEXT TAB ZONE'),
        (0xebcb, 0xebcb, 'EVALUATE EXPRESSION - RETURN VALUE IN B'),
        (0xebce, 0xebce, "* 'SYNTAX' ERROR IF NOT ')'"),
        (0xebd4, 0xebd4, 'SET UP TAB WIDTH, ZONE ETC'),
        (0xebd7, 0xebd7, 'GET DIFFERENCE OF PRINT POSITION & TAB POSITION'),
        (0xebd9, 0xebd9, 'BRANCH IF TAB POSITION < CURRENT POSITION'),
        (0xebdb, 0xebdb, 'SEND A SPACE TO CONSOLE OUT'),
        (0xebdd, 0xebdd, 'DECREMENT DIFFERENCE COUNT'),
        (0xebde, 0xebde, 'BRANCH UNTIL CURRENT POSITION = TAB POSITION'),
        (0xebe0, 0xebe0, 'GET NEXT CHARACTER FROM BASIC'),
        (0xebe2, 0xebe2, 'LOOK FOR MORE PRINT DATA'),
        (0xebe5, 0xebe5, 'PARSE A STRING FROM X AND PUT'),
        (0xebe8, 0xebe8, 'GET LENGTH OF STRING AND REMOVE'),
        (0xebeb, 0xebeb, 'COMPENSATE FOR DECB BELOW'),
        (0xebec, 0xebec, 'DECREMENT COUNTER'),
        (0xebed, 0xebed, 'EXIT ROUTINE'),
        (0xebef, 0xebef, 'GET A CHARACTER FROM X'),
        (0xebf1, 0xebf1, 'SEND TO CONSOLE OUT'),
        (0xebf3, 0xebf3, 'KEEP LOOPING'),
        (0xebf5, 0xebf5, 'SPACE TO CONSOLE OUT'),
        (0xebf7, 0xebf7, 'SKIP NEXT TWO BYTES'),
        (0xebf8, 0xebf8, 'QUESTION MARK TO CONSOLE OUT'),
        (0xebfa, 0xebfa, 'JUMP TO CONSOLE OUT'),
        (0xebfd, 0xebfd, 'FLOATING POINT CONSTANT (.5)'),
        (0xec00, 0xec00, 'ADD .5 TO FPA0'),
        (0xec02, 0xec02, 'COPY PACKED FP DATA FROM (X) TO FPA1'),
        (0xec05, 0xec05, 'CHANGE MANTISSA SIGN OF FPA0'),
        (0xec07, 0xec07, 'REVERSE RESULT SIGN FLAG'),
        (0xec09, 0xec09, 'GO ADD FPA1 AND FPA0'),
        (0xec0b, 0xec0b, 'UNPACK PACKED FP DATA FROM (X) TO'),
        (0xec0e, 0xec0e, 'CHECK EXPONENT OF FPA0'),
        (0xec0f, 0xec0f, 'COPY FPA1 TO FPA0 IF FPA0 ='),
        (0xec13, 0xec13, 'POINT X TO FPA1'),
        (0xec16, 0xec16, 'PUT EXPONENT OF FPA1 INTO ACCB'),
        (0xec18, 0xec18, 'CHECK EXPONENT'),
        (0xec19, 0xec19, 'RETURN IF EXPONENT = 0 (ADDING 0 TO FPA0)'),
        (0xec1b, 0xec1b, 'SUBTRACT EXPONENT OF FPA0 FROM EXPONENT OF FPA1'),
        (0xec1d, 0xec1d, 'BRANCH IF EXPONENTS ARE EQUAL'),
        (0xec1f, 0xec1f, 'BRANCH IF EXPONENT FPA0 > FPA1'),
        (0xec21, 0xec21, 'REPLACE FPA0 EXPONENT WITH FPA1 EXPONENT'),
        (0xec23, 0xec23, '* REPLACE FPA0 MANTISSA SIGN'),
        (0xec25, 0xec25, '* WITH FPA1 MANTISSA SIGN'),
        (0xec27, 0xec27, 'POINT X TO FPA0'),
        (0xec2a, 0xec2a, 'NEGATE DIFFERENCE OF EXPONENTS'),
        (0xec2b, 0xec2b, 'TEST DIFFERENCE OF EXPONENTS'),
        (0xec2d, 0xec2d, 'BRANCH IF DIFFERENCE OF EXPONENTS <= 8'),
        (0xec2f, 0xec2f, 'CLEAR OVERFLOW BYTE'),
        (0xec30, 0xec30, 'SHIFT MS BYTE OF MANTISSA; BIT 7 = 0'),
        (0xec32, 0xec32, 'GO SHIFT MANTISSA OF (X) TO THE RIGHT (B) TIMES'),
        (0xec35, 0xec35, 'GET SIGN FLAG'),
        (0xec37, 0xec37, 'BRANCH IF FPA0 AND FPA1 SIGNS ARE THE SAME'),
        (0xec39, 0xec39, '* COMPLEMENT MANTISSA POINTED'),
        (0xec3b, 0xec3b, '* TO BY (X) THE'),
        (0xec3d, 0xec3d, '* ADCA BELOW WILL'),
        (0xec3f, 0xec3f, '* CONVERT THIS OPERATION'),
        (0xec41, 0xec41, '* INTO A NEG (MANTISSA)'),
        (0xec42, 0xec42, 'ADD ONE TO ACCA - COMA ALWAYS SETS THE CARRY FLAG'),
        (0xec44, 0xec44, 'SAVE FPA SUB BYTE'),
        (0xec46, 0xec46, '* ADD LS BYTE'),
        (0xec48, 0xec48, '* OF MANTISSA'),
        (0xec4a, 0xec4a, 'SAVE IN FPA0 LSB'),
        (0xec4c, 0xec4c, '* ADD NEXT BYTE'),
        (0xec4e, 0xec4e, '* OF MANTISSA'),
        (0xec50, 0xec50, 'SAVE IN FPA0'),
        (0xec52, 0xec52, '* ADD NEXT BYTE'),
        (0xec54, 0xec54, '* OF MANTISSA'),
        (0xec56, 0xec56, 'SAVE IN FPA0'),
        (0xec58, 0xec58, '* ADD MS BYTE'),
        (0xec5a, 0xec5a, '* OF MANTISSA'),
        (0xec5c, 0xec5c, 'SAVE IN FPA0'),
        (0xec5e, 0xec5e, 'FLAG'),
        (0xec5f, 0xec5f, 'BRANCH IF FPA0 & FPA1 SIGNS WERE ALIKE'),
        (0xec61, 0xec61, 'BRANCH IF POSITIVE MANTISSA'),
        (0xec63, 0xec63, 'NEGATE FPA0 MANTISSA'),
        (0xec65, 0xec65, 'CLEAR TEMPORARY EXPONENT ACCUMULATOR'),
        (0xec66, 0xec66, 'TEST MSB OF MANTISSA'),
        (0xec68, 0xec68, 'BRANCH IF <> 0'),
        (0xec6a, 0xec6a, '* IF THE MSB IS'),
        (0xec6c, 0xec6c, '* 0, THEN SHIFT THE'),
        (0xec6e, 0xec6e, '* MANTISSA A WHOLE BYTE'),
        (0xec70, 0xec70, '* AT A TIME. THIS'),
        (0xec72, 0xec72, '* IS FASTER THAN ONE'),
        (0xec74, 0xec74, '* BIT AT A TIME'),
        (0xec76, 0xec76, '* BUT USES MORE MEMORY.'),
        (0xec78, 0xec78, '* FPSBYT, THE CARRY IN'),
        (0xec7a, 0xec7a, '* BYTE, REPLACES THE MATISSA LSB.'),
        (0xec7c, 0xec7c, 'SHIFTING ONE BYTE = 8 BIT SHIFTS; ADD 8 TO EXPONENT'),
        (0xec7e, 0xec7e, 'CHECK FOR 5 SHIFTS'),
        (0xec80, 0xec80, 'BRANCH IF < 5 SHIFTS, IF > 5, THEN MANTISSA = 0'),
        (0xec82, 0xec82, 'A ZERO EXPONENT = 0 FLOATING POINT'),
        (0xec83, 0xec83, 'ZERO OUT THE EXPONENT'),
        (0xec85, 0xec85, 'ZERO OUT THE MANTISSA SIGN'),
        (0xec88, 0xec88, 'SHIFT FPA0 MANTISSA TO RIGHT'),
        (0xec8a, 0xec8a, 'CLEAR CARRY FLAG'),
        (0xec8d, 0xec8d, 'ADD ONE TO EXPONENT ACCUMULATOR'),
        (0xec8e, 0xec8e, 'SHIFT SUB BYTE ONE LEFT'),
        (0xec90, 0xec90, 'SHIFT LS BYTE'),
        (0xec92, 0xec92, 'SHIFT NS BYTE'),
        (0xec94, 0xec94, 'SHIFT NS BYTE'),
        (0xec96, 0xec96, 'SHIFT MS BYTE'),
        (0xec98, 0xec98, 'BRANCH IF NOT YET NORMALIZED'),
        (0xec9a, 0xec9a, 'GET CURRENT EXPONENT'),
        (0xec9c, 0xec9c, 'SAVE EXPONENT MODIFIER CAUSED BY NORMALIZATION'),
        (0xec9e, 0xec9e, 'SUBTRACT ACCUMULATED EXPONENT MODIFIER'),
        (0xeca0, 0xeca0, 'SAVE AS NEW EXPONENT'),
        (0xeca2, 0xeca2, 'SET FPA0 = 0 IF THE NORMALIZATION CAUSED'),
        (0xeca4, 0xeca4, 'SKIP 2 BYTES'),
        (0xeca5, 0xeca5, 'BRANCH IF MANTISSA OVERFLOW'),
        (0xeca7, 0xeca7, 'SUB BYTE BIT 7 TO CARRY - USE AS ROUND-OFF'),
        (0xeca9, 0xeca9, 'CLRA, BUT DO NOT CHANGE CARRY FLAG'),
        (0xecab, 0xecab, 'CLEAR THE SUB BYTE'),
        (0xecad, 0xecad, 'GO ROUND-OFF RESULT'),
        (0xecaf, 0xecaf, 'INCREMENT EXPONENT - MULTIPLY BY 2'),
        (0xecb1, 0xecb1, 'OVERFLOW ERROR IF CARRY PAST $FF'),
        (0xecb3, 0xecb3, '* SHIFT MANTISSA'),
        (0xecb5, 0xecb5, '* ONE TO'),
        (0xecb7, 0xecb7, '* THE RIGHT -'),
        (0xecb9, 0xecb9, '* DIVIDE BY TWO'),
        (0xecbb, 0xecbb, 'BRANCH IF NO ROUND-OFF NEEDED'),
        (0xecbd, 0xecbd, 'ADD ONE TO MANTISSA - ROUND OFF'),
        (0xecbf, 0xecbf, 'BRANCH iF OVERFLOW - MANTISSA = 0'),
        (0xecc2, 0xecc2, 'TOGGLE SIGN OF MANTISSA'),
        (0xecc4, 0xecc4, '* COMPLEMENT ALL 4 MANTISSA BYTES'),
        (0xeccc, 0xeccc, '* GET BOTTOM 2 MANTISSA'),
        (0xecce, 0xecce, '* BYTES, ADD ONE TO'),
        (0xecd0, 0xecd0, '* THEM AND SAVE THEM'),
        (0xecd2, 0xecd2, 'BRANCH IF NO OVERFLOW'),
        (0xecd4, 0xecd4, '* IF OVERFLOW ADD ONE'),
        (0xecd6, 0xecd6, '* TO TOP 2 MANTISSA'),
        (0xecd8, 0xecd8, '* BYTES AND SAVE THEM'),
        (0xecdb, 0xecdb, "OV' OVERFLOW ERROR"),
        (0xecdd, 0xecdd, 'PROCESS AN ERROR'),
        (0xece0, 0xece0, 'POINT X TO FPA2'),
        (0xece3, 0xece3, 'GET LS BYTE OF MANTISSA (X)'),
        (0xece5, 0xece5, 'SAVE IN FPA SUB BYTE'),
        (0xece7, 0xece7, '* SHIFT THE NEXT THREE BYTES OF THE'),
        (0xece9, 0xece9, '* MANTISSA RIGHT ONE COMPLETE BYTE.'),
        (0xecf3, 0xecf3, 'GET THE CARRY IN BYTE'),
        (0xecf5, 0xecf5, 'STORE AS THE MS MANTISSA BYTE OF (X)'),
        (0xecf7, 0xecf7, 'ADD 8 TO DIFFERENCE OF EXPONENTS'),
        (0xecf9, 0xecf9, 'BRANCH IF EXPONENT DIFFERENCE < -8'),
        (0xecfb, 0xecfb, 'GET FPA SUB BYTE'),
        (0xecfd, 0xecfd, 'CAST OUT THE 8 ADDED IN ABOVE'),
        (0xecff, 0xecff, 'BRANCH IF EXPONENT DIFFERENCE = 0'),
        (0xed01, 0xed01, '* SHIFT MANTISSA AND SUB BYTE ONE BIT TO THE RIGHT'),
        (0xed0a, 0xed0a, 'ADD ONE TO EXPONENT DIFFERENCE'),
        (0xed0b, 0xed0b, 'BRANCH IF EXPONENTS NOT ='),
        (0xed0e, 0xed0e, 'FLOATING POINT CONSTANT 1.0'),
        (0xed13, 0xed13, 'MOVE PACKED FPA FROM (X) TO FPA1'),
        (0xed15, 0xed15, 'BRANCH IF EXPONENT OF FPA0 = 0'),
        (0xed17, 0xed17, 'CALCULATE EXPONENT OF PRODUCT'),
        (0xed19, 0xed19, '* ZERO OUT MANTISSA OF FPA2'),
        (0xed23, 0xed23, 'GET LS BYTE OF FPA0'),
        (0xed25, 0xed25, 'MULTIPLY BY FPA1'),
        (0xed27, 0xed27, '* TEMPORARILY SAVE SUB BYTE 4'),
        (0xed2b, 0xed2b, 'GET NUMBER 3 MANTISSA BYTE OF FPA0'),
        (0xed2d, 0xed2d, 'MULTIPLY BY FPA1'),
        (0xed2f, 0xed2f, '* TEMPORARILY SAVE SUB BYTE 3'),
        (0xed33, 0xed33, 'GET NUMBER 2 MANTISSA BYTE OF FPA0'),
        (0xed35, 0xed35, 'MULTIPLY BY FPA1'),
        (0xed37, 0xed37, '* TEMPORARILY SAVE SUB BYTE 2'),
        (0xed3b, 0xed3b, 'GET MS BYTE OF FPA0 MANTISSA'),
        (0xed3d, 0xed3d, 'MULTIPLY BY FPA1'),
        (0xed3f, 0xed3f, '* TEMPORARILY SAVE SUB BYTE 1'),
        (0xed43, 0xed43, 'COPY MANTISSA FROM FPA2 TO FPA0'),
        (0xed46, 0xed46, 'NORMALIZE FPA0'),
        (0xed49, 0xed49, 'SHIFT FPA2 ONE BYTE TO RIGHT'),
        (0xed4b, 0xed4b, 'SET CARRY FLAG'),
        (0xed4c, 0xed4c, 'GET FPA2 MS BYTE'),
        (0xed4e, 0xed4e, 'CARRY FLAG INTO SHIFT COUNTER;'),
        (0xed4f, 0xed4f, 'BRANCH WHEN 8 SHIFTS DONE'),
        (0xed51, 0xed51, 'DO NOT ADD FPA1 IF DATA BIT = 0'),
        (0xed53, 0xed53, '* ADD MANTISSA LS BYTE'),
        (0xed59, 0xed59, '= ADD MANTISSA NUMBER 3 BYTE'),
        (0xed5b, 0xed5b, '='),
        (0xed5d, 0xed5d, '='),
        (0xed5f, 0xed5f, '* ADD MANTISSA NUMBER 2 BYTE'),
        (0xed65, 0xed65, '= ADD MANTISSA MS BYTE'),
        (0xed67, 0xed67, '='),
        (0xed69, 0xed69, 'CARRY INTO MS BYTE'),
        (0xed6c, 0xed6c, '= ROTATE FPA2 ONE BIT TO THE RIGHT'),
        (0xed6e, 0xed6e, '='),
        (0xed70, 0xed70, '='),
        (0xed72, 0xed72, '='),
        (0xed74, 0xed74, 'CLEAR CARRY FLAG'),
        (0xed75, 0xed75, 'KEEP LOOPING'),
        (0xed78, 0xed78, 'GET TWO MSB BYTES OF MANTISSA FROM'),
        (0xed7a, 0xed7a, 'SAVE PACKED MANTISSA SIGN BYTE'),
        (0xed7c, 0xed7c, 'FORCE BIT 7 OF MSB MANTISSA = 1'),
        (0xed7e, 0xed7e, 'SAVE 2 MSB BYTES IN FPA1'),
        (0xed80, 0xed80, '* GET PACKED MANTISSA SIGN BYTE. EOR W/FPA0'),
        (0xed82, 0xed82, '* SIGN - NEW SIGN POSITION IF BOTH OLD SIGNS ALIKE,'),
        (0xed84, 0xed84, '* NEG IF BOTH OLD SIGNS DIFF. SAVE ADJUSTED'),
        (0xed86, 0xed86, '= GET 2 LSB BYTES OF MANTISSA'),
        (0xed88, 0xed88, '= AND PUT IN FPA1'),
        (0xed8a, 0xed8a, '* GET EXPONENT FROM (X) AND'),
        (0xed8c, 0xed8c, '* PUT IN EXPONENT OF FPA1'),
        (0xed8e, 0xed8e, 'GET EXPONENT OF FPA0'),
        (0xed91, 0xed91, 'TEST EXPONENT OF FPA1'),
        (0xed92, 0xed92, 'PURGE RETURN ADDRESS & SET FPA0 = 0'),
        (0xed94, 0xed94, 'ADD FPA1 EXPONENT TO FPA0 EXPONENT'),
        (0xed96, 0xed96, 'ROTATE CARRY INTO BIT 7; BIT 0 INTO CARRY'),
        (0xed97, 0xed97, 'SET OVERFLOW FLAG'),
        (0xed98, 0xed98, 'BRANCH IF EXPONENT TOO LARGE OR SMALL'),
        (0xed9a, 0xed9a, 'ADD $80 BIAS TO EXPONENT'),
        (0xed9c, 0xed9c, 'SAVE NEW EXPONENT'),
        (0xed9e, 0xed9e, 'SET FPA0'),
        (0xeda0, 0xeda0, 'GET MANTISSA SIGN'),
        (0xeda2, 0xeda2, 'SAVE AS MANTISSA SIGN OF FPA0'),
        (0xeda5, 0xeda5, 'GET MANTISSA SIGN OF FPA0'),
        (0xeda7, 0xeda7, 'CHANGE SIGN OF FPA0 MANTISSA'),
        (0xedaa, 0xedaa, 'PURGE RETURN ADDRESS FROM STACK'),
        (0xedac, 0xedac, 'ZERO FPA0 MANTISSA SIGN & EXPONENT'),
        (0xedb0, 0xedb0, "OV' OVERFLOW ERROR"),
        (0xedb3, 0xedb3, 'TRANSFER FPA0 TO FPA1'),
        (0xedb6, 0xedb6, 'BRANCH IF EXPONENT = 0'),
        (0xedb8, 0xedb8, 'ADD 2 TO EXPONENT (TIMES 4)'),
        (0xedba, 0xedba, "OV' ERROR IF EXPONENT > $FF"),
        (0xedbc, 0xedbc, 'CLEAR RESULT SIGN BYTE'),
        (0xedbe, 0xedbe, 'ADD FPA1 TO FPA0 (TIMES 5)'),
        (0xedc1, 0xedc1, 'ADD ONE TO EXPONENT (TIMES 10)'),
        (0xedc3, 0xedc3, "OV' ERROR IF EXPONENT > $FF"),
        (0xedc6, 0xedc6, 'FLOATING POINT CONSTANT 10'),
        (0xedcb, 0xedcb, 'MOVE FPA0 TO FPA1'),
        (0xedce, 0xedce, 'POINT TO FLOATING POINT CONSTANT 10'),
        (0xedd1, 0xedd1, 'ZERO MANTISSA SIGN BYTE'),
        (0xedd2, 0xedd2, 'STORE THE QUOTIENT MANTISSA SIGN BYTE'),
        (0xedd4, 0xedd4, 'UNPACK AN FP NUMBER FROM (X) INTO FPA0'),
        (0xedd7, 0xedd7, 'SKIP TWO BYTES'),
        (0xedd8, 0xedd8, 'GET FP NUMBER FROM (X) TO FPA1'),
        (0xedda, 0xedda, "/0' DIVIDE BY ZERO ERROR"),
        (0xeddc, 0xeddc, 'GET EXPONENT OF RECIPROCAL OF DIVISOR'),
        (0xedde, 0xedde, 'CALCULATE EXPONENT OF QUOTIENT'),
        (0xede0, 0xede0, 'INCREMENT EXPONENT'),
        (0xede2, 0xede2, "OV' OVERFLOW ERROR"),
        (0xede4, 0xede4, 'POINT X TO MANTISSA OF FPA2 - HOLD'),
        (0xede7, 0xede7, '5 BYTE DIVIDE'),
        (0xede9, 0xede9, 'SAVE BYTE COUNTER'),
        (0xedeb, 0xedeb, 'SHIFT COUNTER-AND TEMPORARY QUOTIENT BYTE'),
        (0xeded, 0xeded, '* COMPARE THE TWO MS BYTES'),
        (0xedef, 0xedef, '* OF FPA0 AND FPA1 AND'),
        (0xedf1, 0xedf1, '* BRANCH IF <>'),
        (0xedf3, 0xedf3, '= COMPARE THE NUMBER 2'),
        (0xedf5, 0xedf5, '= BYTES AND'),
        (0xedf7, 0xedf7, '= BRANCH IF <>'),
        (0xedf9, 0xedf9, '* COMPARE THE NUMBER 3'),
        (0xedfb, 0xedfb, '* BYTES AND'),
        (0xedfd, 0xedfd, '* BRANCH IF <>'),
        (0xedff, 0xedff, '= COMPARE THE LS BYTES'),
        (0xee01, 0xee01, '= AND BRANCH'),
        (0xee03, 0xee03, '= IF <>'),
        (0xee05, 0xee05, 'SET CARRY FLAG IF FPA0 = FPA1'),
        (0xee06, 0xee06, 'SAVE CARRY FLAG STATUS IN ACCA; CARRY'),
        (0xee08, 0xee08, 'ROTATE CARRY INTO TEMPORARY QUOTIENT BYTE'),
        (0xee09, 0xee09, 'CARRY WILL BE SET AFTER 8 SHIFTS'),
        (0xee0b, 0xee0b, 'SAVE TEMPORARY QUOTIENT'),
        (0xee0d, 0xee0d, 'DECREMENT BYTE COUNTER'),
        (0xee0f, 0xee0f, 'BRANCH IF DONE'),
        (0xee11, 0xee11, 'BRANCH IF LAST BYTE'),
        (0xee13, 0xee13, 'RESET SHIFT COUNTER AND TEMPORARY QUOTIENT BYTE'),
        (0xee15, 0xee15, 'RESTORE CARRY FLAG AND'),
        (0xee17, 0xee17, 'BRANCH IF FPA0 =< FPA1'),
        (0xee19, 0xee19, '* SHIFT FPA1 MANTISSA 1 BIT TO LEFT'),
        (0xee21, 0xee21, 'BRANCH IF CARRY - ADD ONE TO PARTIAL QUOTIENT'),
        (0xee23, 0xee23, 'IF MSB OF HIGH ORDER MANTISSA BYTE IS'),
        (0xee25, 0xee25, 'CARRY IS CLEAR, CHECK ANOTHER BIT'),
        (0xee27, 0xee27, '* SUBTRACT THE LS BYTES OF MANTISSA'),
        (0xee2d, 0xee2d, '= THEN THE NEXT BYTE'),
        (0xee2f, 0xee2f, '='),
        (0xee31, 0xee31, '='),
        (0xee33, 0xee33, '* AND THE NEXT'),
        (0xee39, 0xee39, '= AND FINALLY, THE MS BYTE OF MANTISSA'),
        (0xee3b, 0xee3b, '='),
        (0xee3d, 0xee3d, '='),
        (0xee3f, 0xee3f, 'GO SHIFT FPA1'),
        (0xee41, 0xee41, 'USE ONLY TWO BITS OF THE LAST BYTE (FIFTH)'),
        (0xee43, 0xee43, 'GO SHIFT THE LAST BYTE'),
        (0xee45, 0xee45, 'CARRY (ALWAYS SET HERE) INTO'),
        (0xee46, 0xee46, 'AND MOVE'),
        (0xee47, 0xee47, '1,0 TO BITS 7,6'),
        (0xee48, 0xee48, 'SAVE SUB BYTE'),
        (0xee4a, 0xee4a, 'MOVE MANTISSA OF FPA2 TO FPA0'),
        (0xee4c, 0xee4c, 'NORMALIZE FPA0'),
        (0xee4f, 0xee4f, "/0' ERROR"),
        (0xee51, 0xee51, 'PROCESS THE ERROR'),
        (0xee54, 0xee54, '* MOVE TOP 2 BYTES'),
        (0xee58, 0xee58, '= MOVE BOTTOM 2 BYTES'),
        (0xee5a, 0xee5a, '='),
        (0xee5d, 0xee5d, 'SAVE ACCA'),
        (0xee5f, 0xee5f, 'GET TOP TWO MANTISSA BYTES'),
        (0xee61, 0xee61, 'SAVE MS BYTE OF MANTISSA AS MANTISSA SIGN'),
        (0xee63, 0xee63, 'UNPACK MS BYTE'),
        (0xee65, 0xee65, 'SAVE UNPACKED TOP 2 MANTISSA BYTES'),
        (0xee67, 0xee67, 'CLEAR MANTISSA SUB BYTE'),
        (0xee69, 0xee69, 'GET EXPONENT TO ACCB'),
        (0xee6b, 0xee6b, '* MOVE LAST 2'),
        (0xee6d, 0xee6d, '* MANTISSA BYTES'),
        (0xee6f, 0xee6f, 'SAVE EXPONENT'),
        (0xee71, 0xee71, 'RESTORE ACCA AND RETURN'),
        (0xee73, 0xee73, 'POINT X TO MANTISSA OF FPA4'),
        (0xee76, 0xee76, 'MOVE FPA0 TO FPA4'),
        (0xee78, 0xee78, 'POINT X TO MANTISSA OF FPA3'),
        (0xee7b, 0xee7b, 'SKIP TWO BYTES'),
        (0xee7c, 0xee7c, 'POINT X TO VARIABLE DESCRIPTOR IN VARDES'),
        (0xee7e, 0xee7e, '* COPY EXPONENT'),
        (0xee82, 0xee82, 'GET MANTISSA SIGN BIT'),
        (0xee84, 0xee84, 'MASK THE BOTTOM 7 BITS'),
        (0xee86, 0xee86, 'AND BIT 7 OF MANTISSA SIGN INTO BIT 7 OF MS BYTE'),
        (0xee88, 0xee88, 'SAVE MS BYTE'),
        (0xee8a, 0xee8a, '* MOVE 2ND MANTISSA BYTE'),
        (0xee8e, 0xee8e, '= MOVE BOTTOM 2 MANTISSA BYTES'),
        (0xee90, 0xee90, '='),
        (0xee93, 0xee93, '* COPY MANTISSA SIGN FROM'),
        (0xee95, 0xee95, '* FPA1 TO FPA0'),
        (0xee97, 0xee97, '= COPY EXPONENT + MS BYTE FROM'),
        (0xee99, 0xee99, '= FPA1 TO FPA0'),
        (0xee9b, 0xee9b, 'CLEAR MANTISSA SUB BYTE'),
        (0xee9d, 0xee9d, '* COPY 2ND MANTISSA BYTE'),
        (0xee9f, 0xee9f, '* FROM FPA1 TO FPA0'),
        (0xeea1, 0xeea1, 'GET MANTISSA SIGN'),
        (0xeea3, 0xeea3, '* COPY 3RD AND 4TH MANTISSA BYTE'),
        (0xeea5, 0xeea5, '* FROM FPA1 TO FPA0'),
        (0xeea8, 0xeea8, '* TRANSFER EXPONENT & MS BYTE'),
        (0xeeac, 0xeeac, '= TRANSFER MIDDLE TWO BYTES'),
        (0xeeae, 0xeeae, '='),
        (0xeeb0, 0xeeb0, '* TRANSFER BOTTOM TWO BYTES'),
        (0xeeb4, 0xeeb4, 'SET FLAGS ACCORDING TO EXPONENT'),
        (0xeeb6, 0xeeb6, 'GET EXPONENT'),
        (0xeeb8, 0xeeb8, 'BRANCH IF FPA0 = 0'),
        (0xeeba, 0xeeba, 'GET SIGN OF MANTISSA'),
        (0xeebc, 0xeebc, 'BIT 7 TO CARRY'),
        (0xeebd, 0xeebd, 'NEGATIVE FLAG'),
        (0xeebf, 0xeebf, 'BRANCH IF NEGATIVE MANTISSA'),
        (0xeec1, 0xeec1, 'ACCB = 1 IF POSITIVE MANTISSA'),
        (0xeec3, 0xeec3, 'SET ACCB ACCORDING TO SIGN OF FPA0'),
        (0xeec5, 0xeec5, 'SAVE ACCB IN FPA0'),
        (0xeec7, 0xeec7, 'CLEAR NUMBER 2 MANTISSA BYTE OF FPA0'),
        (0xeec9, 0xeec9, 'EXPONENT REQUIRED IF FPA0 IS TO BE AN INTEGER'),
        (0xeecb, 0xeecb, 'GET MS BYTE OF MANTISSA'),
        (0xeecd, 0xeecd, 'SET CARRY IF POSITIVE MANTISSA'),
        (0xeecf, 0xeecf, 'SAVE EXPONENT'),
        (0xeed1, 0xeed1, '* ZERO OUT ACCD AND'),
        (0xeed3, 0xeed3, '* BOTTOM HALF OF FPA0'),
        (0xeed5, 0xeed5, 'CLEAR SUB BYTE'),
        (0xeed7, 0xeed7, 'CLEAR SIGN OF FPA0 MANTISSA'),
        (0xeed9, 0xeed9, 'GO NORMALIZE FPA0'),
        (0xeedc, 0xeedc, 'FORCE MANTISSA SIGN OF FPA0 POSITIVE'),
        (0xeedf, 0xeedf, 'CHECK EXPONENT OF (X)'),
        (0xeee1, 0xeee1, 'BRANCH IF FPA = 0'),
        (0xeee3, 0xeee3, 'GET MS BYTE OF MANTISSA OF (X)'),
        (0xeee5, 0xeee5, 'EOR WITH SIGN OF FPA0'),
        (0xeee7, 0xeee7, 'BRANCH IF SIGNS NOT ='),
        (0xeee9, 0xeee9, '* GET EXPONENT OF'),
        (0xeeeb, 0xeeeb, '* FPA0, COMPARE TO EXPONENT OF'),
        (0xeeed, 0xeeed, '* (X) AND BRANCH IF <>.'),
        (0xeeef, 0xeeef, '* GET MS BYTE OF (X), KEEP ONLY'),
        (0xeef1, 0xeef1, "* THE SIGN BIT - 'AND' THE BOTTOM 7"),
        (0xeef3, 0xeef3, '* BITS OF FPA0 INTO ACCB'),
        (0xeef5, 0xeef5, '= COMPARE THE BOTTOM 7 BITS OF THE MANTISSA'),
        (0xeef7, 0xeef7, '= MS BYTE AND BRANCH IF <>'),
        (0xeef9, 0xeef9, '* COMPARE 2ND BYTE'),
        (0xeefb, 0xeefb, '* OF MANTISSA,'),
        (0xeefd, 0xeefd, '* BRANCH IF <>'),
        (0xeeff, 0xeeff, '= COMPARE 3RD BYTE'),
        (0xef01, 0xef01, '= OF MANTISSA,'),
        (0xef03, 0xef03, '= BRANCH IF <>'),
        (0xef05, 0xef05, '* SUBTRACT LS BYTE'),
        (0xef07, 0xef07, '* OF (X) FROM LS BYTE OF'),
        (0xef09, 0xef09, '* FPA0, BRANCH IF <>'),
        (0xef0b, 0xef0b, 'RETURN IF FP (X) = FPA0'),
        (0xef0c, 0xef0c, 'SHIFT CARRY TO BIT 7; CARRY SET IF FPA0 < (X)'),
        (0xef0d, 0xef0d, 'TOGGLE SIZE COMPARISON BIT IF FPA0 IS NEGATIVE'),
        (0xef0f, 0xef0f, 'GO SET ACCB ACCORDING TO COMPARISON'),
        (0xef11, 0xef11, 'GET EXPONENT OF FPA0'),
        (0xef13, 0xef13, 'ZERO MANTISSA IF FPA0 = 0'),
        (0xef15, 0xef15, 'SUBTRACT $A0 FROM FPA0 EXPONENT T THIS WILL YIELD'),
        (0xef17, 0xef17, 'TEST SIGN OF FPA0 MANTISSA'),
        (0xef19, 0xef19, 'BRANCH IF POSITIVE'),
        (0xef1b, 0xef1b, 'COMPLEMENT CARRY IN BYTE'),
        (0xef1d, 0xef1d, 'NEGATE MANTISSA OF FPA0'),
        (0xef20, 0xef20, 'POINT X TO FPA0'),
        (0xef23, 0xef23, 'EXPONENT DIFFERENCE < -8?'),
        (0xef25, 0xef25, 'YES'),
        (0xef27, 0xef27, 'SHIFT FPA0 RIGHT UNTIL FPA0 EXPONENT = $A0'),
        (0xef2a, 0xef2a, 'CLEAR CARRY IN BYTE'),
        (0xef2d, 0xef2d, 'CLEAR CARRY IN BYTE'),
        (0xef2f, 0xef2f, '* GET SIGN OF FPA0 MANTISSA'),
        (0xef31, 0xef31, '* ROTATE IT INTO THE CARRY FLAG'),
        (0xef32, 0xef32, 'ROTATE CARRY (MANTISSA SIGN) INTO BIT 7'),
        (0xef34, 0xef34, 'DE-NORMALIZE FPA0'),
        (0xef37, 0xef37, 'GET EXPONENT OF FPA0'),
        (0xef39, 0xef39, 'LARGEST POSSIBLE INTEGER EXPONENT'),
        (0xef3b, 0xef3b, 'RETURN IF FPA0 >= 32768'),
        (0xef3d, 0xef3d, 'SHIFT THE BINARY POINT ONE TO THE RIGHT OF THE'),
        (0xef3f, 0xef3f, 'ACCB = 0: ZERO OUT THE SUB BYTE'),
        (0xef41, 0xef41, 'GET MANTISSA SIGN'),
        (0xef43, 0xef43, 'FORCE MANTISSA SIGN TO BE POSITIVE'),
        (0xef45, 0xef45, 'SET CARRY IF MANTISSA'),
        (0xef47, 0xef47, '* GET DENORMALIZED EXPONENT AND'),
        (0xef49, 0xef49, '* SAVE IT IN FPA0 EXPONENT'),
        (0xef4b, 0xef4b, '= GET LS BYTE OF FPA0 AND'),
        (0xef4d, 0xef4d, '= SAVE IT IN CHARAC'),
        (0xef4f, 0xef4f, 'NORMALIZE FPA0'),
        (0xef52, 0xef52, '* LOAD MANTISSA OF FPA0 WITH CONTENTS OF ACCB'),
        (0xef5b, 0xef5b, '(X) = 0'),
        (0xef5d, 0xef5d, '* ZERO OUT FPA0 & THE SIGN FLAG (COEFCT)'),
        (0xef65, 0xef65, 'INITIALIZE EXPONENT & EXPONENT SIGN FLAG TO ZERO'),
        (0xef67, 0xef67, 'INITIALIZE RIGHT DECIMAL CTR & DECIMAL PT FLAG TO 0'),
        (0xef69, 0xef69, 'IF CARRY SET (NUMERIC CHARACTER), ASSUME ACCA CONTAINS FIRST'),
        (0xef6b, 0xef6b, 'CALL EXTENDED BASIC ADD-IN'),
        (0xef6e, 0xef6e, '* CHECK FOR A LEADING MINUS SIGN AND BRANCH'),
        (0xef70, 0xef70, '* IF NO MINUS SIGN'),
        (0xef72, 0xef72, 'TOGGLE SIGN; 0 = +; FF = -'),
        (0xef74, 0xef74, 'INTERPRET THE REST OF THE STRING'),
        (0xef76, 0xef76, '* CHECK FOR LEADING PLUS SlGN AND BRANCH'),
        (0xef78, 0xef78, '* IF NOT A PLUS SIGN'),
        (0xef7a, 0xef7a, 'GET NEXT INPUT CHARACTER FROM BASIC'),
        (0xef7c, 0xef7c, 'BRANCH IF NUMERIC CHARACTER'),
        (0xef7e, 0xef7e, 'DECIMAL POlNT?'),
        (0xef80, 0xef80, 'YES'),
        (0xef82, 0xef82, '"E" SHORTHAND FORM (SCIENTIFIC NOTATION)?'),
        (0xef84, 0xef84, 'NO'),
        (0xef86, 0xef86, 'GET NEXT INPUT CHARACTER FROM BASIC'),
        (0xef88, 0xef88, 'BRANCH IF NUMERIC'),
        (0xef8a, 0xef8a, 'MINUS TOKEN?'),
        (0xef8c, 0xef8c, 'YES'),
        (0xef8e, 0xef8e, 'ASCII MINUS?'),
        (0xef90, 0xef90, 'YES'),
        (0xef92, 0xef92, 'PLUS TOKEN?'),
        (0xef94, 0xef94, 'YES'),
        (0xef96, 0xef96, 'ASCII PLUS?'),
        (0xef98, 0xef98, 'YES'),
        (0xef9a, 0xef9a, 'BRANCH IF NO SIGN FOUND'),
        (0xef9c, 0xef9c, 'SET EXPONENT SIGN FLAG TO NEGATIVE'),
        (0xef9e, 0xef9e, 'GET NEXT INPUT CHARACTER FROM BASIC'),
        (0xefa0, 0xefa0, 'IF NUMERIC CHARACTER, CONVERT TO BINARY'),
        (0xefa2, 0xefa2, '* CHECK EXPONENT SIGN FLAG'),
        (0xefa4, 0xefa4, '* AND BRANCH IF POSITIVE'),
        (0xefa6, 0xefa6, 'NEGATE VALUE OF EXPONENT'),
        (0xefaa, 0xefaa, '*TOGGLE DECIMAL PT FLAG AND INTERPRET ANOTHER'),
        (0xefac, 0xefac, '*CHARACTER IF <> 0 - TERMINATE INTERPRETATION'),
        (0xefae, 0xefae, '* GET EXPONENT, SUBTRACT THE NUMBER OF'),
        (0xefb0, 0xefb0, '* PLACES TO THE RIGHT OF DECIMAL POINT'),
        (0xefb2, 0xefb2, '* AND RESAVE IT.'),
        (0xefb4, 0xefb4, 'EXIT ROUTINE IF ADJUSTED EXPONENT = ZERO'),
        (0xefb6, 0xefb6, 'BRANCH IF POSITIVE EXPONENT'),
        (0xefb8, 0xefb8, 'DIVIDE FPA0 BY 10'),
        (0xefbb, 0xefbb, 'INCREMENT EXPONENT COUNTER (MULTIPLY BY 10)'),
        (0xefbd, 0xefbd, 'KEEP MULTIPLYING'),
        (0xefbf, 0xefbf, 'EXIT ROUTINE'),
        (0xefc1, 0xefc1, 'MULTIPLY FPA0 BY 10'),
        (0xefc4, 0xefc4, 'DECREMENT EXPONENT COUNTER (DIVIDE BY 10)'),
        (0xefc6, 0xefc6, 'KEEP MULTIPLYING'),
        (0xefc8, 0xefc8, 'GET THE SIGN FLAG'),
        (0xefca, 0xefca, 'RETURN IF POSITIVE'),
        (0xefcc, 0xefcc, 'TOGGLE MANTISSA SIGN OF FPA0, IF NEGATIVE'),
        (0xefcf, 0xefcf, '*GET THE RIGHT DECIMAL COUNTER AND SUBTRACT'),
        (0xefd1, 0xefd1, '*THE DECIMAL POINT FLAG FROM IT. IF DECIMAL POINT'),
        (0xefd3, 0xefd3, '*FLAG=0, NOTHING HAPPENS. IF DECIMAL POINT FLAG IS'),
        (0xefd5, 0xefd5, 'SAVE NEW DIGIT ON STACK'),
        (0xefd7, 0xefd7, 'MULTIPLY FPA0 BY 10'),
        (0xefda, 0xefda, 'GET NEW DIGIT BACK'),
        (0xefdc, 0xefdc, 'MASK OFF ASCII'),
        (0xefde, 0xefde, 'ADD ACCB TO FPA0'),
        (0xefe0, 0xefe0, 'GET ANOTHER CHARACTER FROM BASIC'),
        (0xefe2, 0xefe2, 'PACK FPA0 AND SAVE IT IN FPA3'),
        (0xefe5, 0xefe5, 'CONVERT ACCB TO FP NUMBER IN FPA0'),
        (0xefe8, 0xefe8, '* ADD FPA0 TO'),
        (0xefeb, 0xefeb, '* FPA3'),
        (0xeff0, 0xeff0, 'TIMES 2'),
        (0xeff1, 0xeff1, 'TIMES 4'),
        (0xeff2, 0xeff2, 'ADD 1 = TIMES 5'),
        (0xeff4, 0xeff4, 'TIMES 10'),
        (0xeff5, 0xeff5, '*MASK OFF ASCII FROM ACCA, PUSH'),
        (0xeff7, 0xeff7, '*RESULT ONTO THE STACK AND'),
        (0xeff9, 0xeff9, 'ADD lT TO ACCB'),
        (0xeffb, 0xeffb, 'SAVE IN V47'),
        (0xeffd, 0xeffd, 'INTERPRET ANOTHER CHARACTER'),
        (0xefff, 0xefff, '* 99999999.9'),
        (0xf004, 0xf004, '* 999999999'),
        (0xf009, 0xf009, '* 1E + 09'),
        (0xf00e, 0xf00e, 'POINT X TO " IN " MESSAGE'),
        (0xf011, 0xf011, 'COPY A STRING FROM (X) TO CONSOLE OUT'),
        (0xf013, 0xf013, 'GET CURRENT BASIC LINE NUMBER TO ACCD'),
        (0xf015, 0xf015, 'SAVE ACCD IN TOP HALF OF FPA0'),
        (0xf017, 0xf017, "REQ'D EXPONENT IF TOP HALF OF ACCD = INTEGER"),
        (0xf019, 0xf019, 'SET CARRY FLAG - FORCE POSITIVE MANTISSA'),
        (0xf01a, 0xf01a, 'ZERO BOTTOM HALF AND SIGN OF FPA0, THEN'),
        (0xf01d, 0xf01d, 'CONVERT FP NUMBER TO ASCII STRING'),
        (0xf01f, 0xf01f, 'COPY A STRING FROM (X) TO CONSOLE OUT'),
        (0xf022, 0xf022, 'POINT U TO BUFFER WHICH WILL NOT CAUSE'),
        (0xf025, 0xf025, 'SPACE = DEFAULT SIGN FOR POSITIVE #'),
        (0xf027, 0xf027, 'GET SIGN OF FPA0'),
        (0xf029, 0xf029, 'BRANCH IF POSITIVE'),
        (0xf02b, 0xf02b, 'ASCII MINUS SIGN'),
        (0xf02d, 0xf02d, 'STORE SIGN OF NUMBER'),
        (0xf02f, 0xf02f, 'SAVE BUFFER POINTER'),
        (0xf031, 0xf031, 'SAVE SIGN (IN ASCII)'),
        (0xf033, 0xf033, 'ASCII ZERO IF EXPONENT = 0'),
        (0xf035, 0xf035, 'GET FPA0 EXPONENT'),
        (0xf037, 0xf037, 'BRANCH IF FPA0 = 0'),
        (0xf03b, 0xf03b, 'BASE 10 EXPONENT=0 FOR FP NUMBER > 1'),
        (0xf03c, 0xf03c, 'CHECK EXPONENT'),
        (0xf03e, 0xf03e, 'BRANCH IF FP NUMBER > 1'),
        (0xf040, 0xf040, 'POINT X TO FP 1E+09'),
        (0xf043, 0xf043, 'MULTIPLY FPA0 BY (X)'),
        (0xf046, 0xf046, 'BASE 10 EXPONENT = -9'),
        (0xf048, 0xf048, 'BASE 10 EXPONENT'),
        (0xf04a, 0xf04a, 'POINT X TO FP 999,999,999'),
        (0xf04d, 0xf04d, 'COMPARE FPA0 TO 999,999,999'),
        (0xf050, 0xf050, 'BRANCH IF > 999,999,999'),
        (0xf052, 0xf052, 'POINT X TO FP 99,999,999.9'),
        (0xf055, 0xf055, 'COMPARE FPA0 TO 99,999,999.9'),
        (0xf058, 0xf058, 'BRANCH IF > 99,999,999.9 (IN RANGE)'),
        (0xf05a, 0xf05a, 'MULTIPLY FPA0 BY 10'),
        (0xf05d, 0xf05d, 'SUBTRACT ONE FROM DECIMAL OFFSET'),
        (0xf05f, 0xf05f, 'PSEUDO - NORMALIZE SOME MORE'),
        (0xf061, 0xf061, 'DIVIDE FPA0 BY 10'),
        (0xf064, 0xf064, 'ADD ONE TO BASE 10 EXPONENT'),
        (0xf066, 0xf066, 'PSEUDO - NORMALIZE SOME MORE'),
        (0xf068, 0xf068, 'ADD .5 TO FPA0 (ROUND OFF)'),
        (0xf06b, 0xf06b, 'CONVERT FPA0 TO AN INTEGER'),
        (0xf06e, 0xf06e, 'DEFAULT DECIMAL POINT FLAG (FORCE IMMED DECIMAL PT)'),
        (0xf070, 0xf070, '* GET BASE 10 EXPONENT AND ADD TEN TO IT'),
        (0xf072, 0xf072, "* (NUMBER 'NORMALIZED' TO 9 PLACES & DECIMAL PT)"),
        (0xf074, 0xf074, 'BRANCH IF NUMBER < 1.0'),
        (0xf076, 0xf076, 'NINE PLACES MAY BE DISPLAYED WITHOUT'),
        (0xf078, 0xf078, 'BRANCH IF SCIENTIFIC NOTATION REQUIRED'),
        (0xf07a, 0xf07a, '* SUBTRACT 1 FROM MODIFIED BASE 10 EXPONENT CTR'),
        (0xf07b, 0xf07b, '* AND SAVE IT IN ACCB (DECiMAL POINT FLAG)'),
        (0xf07d, 0xf07d, "FORCE EXPONENT = 0 - DON'T USE SCIENTIFIC NOTATION"),
        (0xf07f, 0xf07f, '* SUBTRACT TWO (WITHOUT AFFECTING CARRY)'),
        (0xf080, 0xf080, '* FROM BASE 10 EXPONENT'),
        (0xf081, 0xf081, 'SAVE EXPONENT - ZERO EXPONENT = DO NOT DISPLAY'),
        (0xf083, 0xf083, 'DECIMAL POINT FLAG - NUMBER OF PLACES TO'),
        (0xf085, 0xf085, 'BRANCH IF >= 1'),
        (0xf087, 0xf087, 'POINT U TO THE STRING BUFFER'),
        (0xf089, 0xf089, '* STORE A PERIOD'),
        (0xf08b, 0xf08b, '* IN THE BUFFER'),
        (0xf08d, 0xf08d, 'POINT FLAG'),
        (0xf08e, 0xf08e, 'BRANCH IF NOTHING TO LEFT OF DECIMAL POINT'),
        (0xf090, 0xf090, '* STORE A ZERO'),
        (0xf092, 0xf092, '* IN THE BUFFER'),
        (0xf094, 0xf094, 'POINT X TO FP POWER OF 10 MANTISSA'),
        (0xf097, 0xf097, 'INITIALIZE DIGIT COUNTER TO 0+$80'),
        (0xf099, 0xf099, '* ADD MANTISSA LS'),
        (0xf09b, 0xf09b, '* BYTE OF FPA0'),
        (0xf09d, 0xf09d, '* AND (X)'),
        (0xf09f, 0xf09f, '= ADD MANTISSA'),
        (0xf0a1, 0xf0a1, '= NUMBER 3 BYTE OF'),
        (0xf0a3, 0xf0a3, '= FPA0 AND (X)'),
        (0xf0a5, 0xf0a5, '* ADD MANTISSA'),
        (0xf0a7, 0xf0a7, '* NUMBER 2 BYTE OF'),
        (0xf0a9, 0xf0a9, '* FPA0 AND (X)'),
        (0xf0ab, 0xf0ab, '= ADD MANTISSA'),
        (0xf0ad, 0xf0ad, '= MS BYTE OF'),
        (0xf0af, 0xf0af, '= FPA0 AND (X)'),
        (0xf0b1, 0xf0b1, 'ADD ONE TO DIGIT COUNTER'),
        (0xf0b2, 0xf0b2, 'CARRY INTO BIT 7'),
        (0xf0b3, 0xf0b3, '*SET OVERFLOW FLAG AND BRANCH IF CARRY = 1 AND'),
        (0xf0b4, 0xf0b4, '*POSITIVE MANTISSA OR CARRY = 0 AND NEG MANTISSA'),
        (0xf0b6, 0xf0b6, 'BRANCH IF NEGATIVE MANTISSA'),
        (0xf0b8, 0xf0b8, "* TAKE THE 9'S COMPLEMENT IF"),
        (0xf0ba, 0xf0ba, '* ADDING MANTISSA'),
        (0xf0bb, 0xf0bb, 'ADD ASCII OFFSET TO DIGIT'),
        (0xf0bd, 0xf0bd, 'MOVE TO NEXT POWER OF 10 MANTISSA'),
        (0xf0bf, 0xf0bf, 'SAVE DIGIT IN ACCA'),
        (0xf0c1, 0xf0c1, 'MASK OFF BIT 7 (ADD/SUBTRACT FLAG)'),
        (0xf0c3, 0xf0c3, 'STORE DIGIT IN STRING BUFFER'),
        (0xf0c5, 0xf0c5, 'DECREMENT DECIMAL POINT FLAG'),
        (0xf0c7, 0xf0c7, 'BRANCH IF NOT TIME FOR DECIMAL POINT'),
        (0xf0c9, 0xf0c9, '* STORE DECIMAL POINT IN'),
        (0xf0cb, 0xf0cb, '* STRING BUFFER'),
        (0xf0cd, 0xf0cd, 'TOGGLE BIT 7 (ADD/SUBTRACT FLAG)'),
        (0xf0ce, 0xf0ce, 'MASK OFF ALL BUT ADD/SUBTRACT FLAG'),
        (0xf0d0, 0xf0d0, 'COMPARE X TO END OF MANTISSA TABLE'),
        (0xf0d3, 0xf0d3, 'BRANCH IF NOT AT END OF TABLE'),
        (0xf0d5, 0xf0d5, 'GET THE LAST CHARACTER; MOVE POINTER BACK'),
        (0xf0d7, 0xf0d7, 'WAS IT A ZERO?'),
        (0xf0d9, 0xf0d9, 'IGNORE TRAILING ZEROS IF SO'),
        (0xf0db, 0xf0db, 'CHECK FOR DECIMAL POINT'),
        (0xf0dd, 0xf0dd, 'BRANCH IF NOT DECIMAL POINT'),
        (0xf0df, 0xf0df, 'STEP OVER THE DECIMAL POINT'),
        (0xf0e1, 0xf0e1, 'ASCII PLUS SIGN'),
        (0xf0e3, 0xf0e3, 'GET SCIENTIFIC NOTATION EXPONENT'),
        (0xf0e5, 0xf0e5, 'BRANCH IF NOT SCIENTIFIC NOTATION'),
        (0xf0e7, 0xf0e7, 'BRANCH IF POSITIVE EXPONENT'),
        (0xf0e9, 0xf0e9, 'ASCII MINUS SIGN'),
        (0xf0eb, 0xf0eb, 'NEGATE EXPONENT IF NEGATIVE'),
        (0xf0ec, 0xf0ec, 'STORE EXPONENT SIGN IN STRING'),
        (0xf0ee, 0xf0ee, "* GET ASCII 'E' (SCIENTIFIC NOTATION"),
        (0xf0f0, 0xf0f0, '* FLAG) AND SAVE IT IN THE STRING'),
        (0xf0f2, 0xf0f2, 'INITIALIZE ACCA TO ASCII ZERO'),
        (0xf0f4, 0xf0f4, "ADD ONE TO 10'S DIGIT OF EXPONENT"),
        (0xf0f5, 0xf0f5, 'SUBTRACT 10 FROM ACCB'),
        (0xf0f7, 0xf0f7, "ADD 1 TO 10'S DIGIT IF NO CARRY"),
        (0xf0f9, 0xf0f9, 'CONVERT UNITS DIGIT TO ASCII'),
        (0xf0fb, 0xf0fb, 'SAVE EXPONENT IN STRING'),
        (0xf0fd, 0xf0fd, 'CLEAR LAST BYTE (TERMINATOR)'),
        (0xf0ff, 0xf0ff, 'GO RESET POINTER'),
        (0xf101, 0xf101, 'STORE LAST CHARACTER'),
        (0xf103, 0xf103, 'CLEAR LAST BYTE (TERMINATOR - REQUIRED BY'),
        (0xf105, 0xf105, 'RESET POINTER TO START OF BUFFER'),
        (0xf109, 0xf109, 'FLOATING POINT .5'),
        (0xf10e, 0xf10e, '-100000000'),
        (0xf112, 0xf112, '10000000'),
        (0xf116, 0xf116, '-1000000'),
        (0xf11a, 0xf11a, '100000'),
        (0xf11e, 0xf11e, '-10000'),
        (0xf122, 0xf122, '1000'),
        (0xf126, 0xf126, '-100'),
        (0xf12a, 0xf12a, '10'),
        (0xf12e, 0xf12e, '-1'),
        (0xf132, 0xf132, 'GET EXPONENT OF FPA0'),
        (0xf134, 0xf134, 'BRANCH IF FPA0 = 0'),
        (0xf136, 0xf136, 'TOGGLE MANTISSA SIGN OF FPA0'),
        (0xf139, 0xf139, 'SAVE COEFFICIENT TABLE POINTER'),
        (0xf13b, 0xf13b, 'MOVE FPA0 TO FPA3'),
        (0xf13e, 0xf13e, 'MULTIPLY FPA3 BY FPA0'),
        (0xf140, 0xf140, 'EXPAND POLYNOMIAL'),
        (0xf142, 0xf142, 'POINT X TO FPA3'),
        (0xf145, 0xf145, 'MULTIPLY (X) BY FPA0'),
        (0xf148, 0xf148, 'SAVE COEFFICIENT TABLE POINTER'),
        (0xf14a, 0xf14a, 'MOVE FPA0 TO FPA4'),
        (0xf14d, 0xf14d, 'GET THE COEFFICIENT POINTER'),
        (0xf14f, 0xf14f, 'GET THE TOP OF COEFFICIENT TABLE TO'),
        (0xf151, 0xf151, '* USE AND STORE IT IN TEMPORARY COUNTER'),
        (0xf153, 0xf153, 'SAVE NEW COEFFICIENT POINTER'),
        (0xf155, 0xf155, 'MULTIPLY (X) BY FPA0'),
        (0xf157, 0xf157, '*GET COEFFICIENT POINTER'),
        (0xf159, 0xf159, '*MOVE TO NEXT FP NUMBER'),
        (0xf15b, 0xf15b, '*SAVE NEW COEFFICIENT POINTER'),
        (0xf15d, 0xf15d, 'ADD (X) AND FPA0'),
        (0xf160, 0xf160, 'POINT (X) TO FPA4'),
        (0xf163, 0xf163, 'DECREMENT TEMP COUNTER'),
        (0xf165, 0xf165, 'BRANCH IF MORE COEFFICIENTS LEFT'),
        (0xf168, 0xf168, 'TEST FPA0'),
        (0xf16b, 0xf16b, 'BRANCH IF FPA0 = NEGATIVE'),
        (0xf16d, 0xf16d, 'BRANCH IF FPA0 = 0'),
        (0xf16f, 0xf16f, 'CONVERT FPA0 TO AN INTEGER'),
        (0xf171, 0xf171, 'PACK FPA0 TO FPA3'),
        (0xf174, 0xf174, 'GET A RANDOM NUMBER: FPA0 < 1.0'),
        (0xf176, 0xf176, 'POINT (X) TO FPA3'),
        (0xf179, 0xf179, 'MULTIPLY (X) BY FPA0'),
        (0xf17b, 0xf17b, 'POINT (X) TO FP VALUE OF 1.0'),
        (0xf17e, 0xf17e, 'ADD 1.0 TO FPA0'),
        (0xf181, 0xf181, 'CONVERT FPA0 TO AN INTEGER'),
        (0xf184, 0xf184, '* MOVE VARIABLE'),
        (0xf186, 0xf186, '* RANDOM NUMBER'),
        (0xf188, 0xf188, '* SEED TO'),
        (0xf18a, 0xf18a, '* FPA0'),
        (0xf18c, 0xf18c, '= MOVE FIXED'),
        (0xf18f, 0xf18f, '= RANDOM NUMBER'),
        (0xf191, 0xf191, '= SEED TO'),
        (0xf194, 0xf194, '= MANTISSA OF FPA0'),
        (0xf196, 0xf196, 'MULTIPLY FPA0 X FPA1'),
        (0xf199, 0xf199, 'GET THE TWO LOWEST ORDER PRODUCT BYTES'),
        (0xf19b, 0xf19b, 'ADD A CONSTANT'),
        (0xf19e, 0xf19e, 'SAVE NEW LOW ORDER VARIABLE RANDOM # SEED'),
        (0xf1a0, 0xf1a0, 'SAVE NEW LOW ORDER BYTES OF FPA0 MANTISSA'),
        (0xf1a2, 0xf1a2, 'GET 2 MORE LOW ORDER PRODUCT BYTES'),
        (0xf1a4, 0xf1a4, 'ADD A CONSTANT'),
        (0xf1a6, 0xf1a6, 'ADD A CONSTANT'),
        (0xf1a8, 0xf1a8, 'SAVE NEW HIGH ORDER VARIABLE RANDOM # SEED'),
        (0xf1aa, 0xf1aa, 'SAVE NEW HIGH ORDER FPA0 MANTISSA'),
        (0xf1ac, 0xf1ac, 'FORCE FPA0 MANTISSA = POSITIVE'),
        (0xf1ae, 0xf1ae, '* SET FPA0 BIASED EXPONENT'),
        (0xf1b0, 0xf1b0, '* TO 0 1 < FPA0 < 0'),
        (0xf1b2, 0xf1b2, 'GET A BYTE FROM FPA2 (MORE RANDOMNESS)'),
        (0xf1b4, 0xf1b4, 'SAVE AS SUB BYTE'),
        (0xf1b6, 0xf1b6, 'NORMALIZE FPA0'),
        (0xf1b9, 0xf1b9, '*CONSTANT RANDOM NUMBER GENERATOR SEED'),
        (0xf1bd, 0xf1bd, 'COPY FPA0 TO FPA1'),
        (0xf1c0, 0xf1c0, 'POINT (X) TO 2*PI'),
        (0xf1c3, 0xf1c3, '*GET MANTISSA SIGN OF FPA1'),
        (0xf1c5, 0xf1c5, '*AND DIVIDE FPA0 BY 2*PI'),
        (0xf1c8, 0xf1c8, 'COPY FPA0 TO FPA1'),
        (0xf1cb, 0xf1cb, 'CONVERT FPA0 TO AN INTEGER'),
        (0xf1cd, 0xf1cd, 'SET RESULT SIGN = POSITIVE'),
        (0xf1cf, 0xf1cf, '*GET EXPONENT OF FPA1'),
        (0xf1d1, 0xf1d1, '*GET EXPONENT OF FPA0'),
        (0xf1d3, 0xf1d3, '*SUBTRACT FPA0 FROM FPA1'),
        (0xf1d6, 0xf1d6, 'POINT X TO FP (.25)'),
        (0xf1d9, 0xf1d9, 'SUBTRACT FPA0 FROM .25 (PI/2)'),
        (0xf1dc, 0xf1dc, 'GET MANTISSA SIGN OF FPA0'),
        (0xf1de, 0xf1de, 'SAVE IT ON STACK'),
        (0xf1e0, 0xf1e0, 'BRANCH IF MANTISSA POSITIVE'),
        (0xf1e2, 0xf1e2, 'ADD .5 (PI) TO FPA0'),
        (0xf1e5, 0xf1e5, 'GET SIGN OF FPA0'),
        (0xf1e7, 0xf1e7, 'BRANCH IF NEGATIVE'),
        (0xf1e9, 0xf1e9, 'COM IF +(3*PI)/2 >= ARGUMENT >+ PI/2 (QUADRANT FLAG)'),
        (0xf1eb, 0xf1eb, 'TOGGLE MANTISSA SIGN OF FPA0'),
        (0xf1ee, 0xf1ee, 'POINT X TO FP (.25)'),
        (0xf1f1, 0xf1f1, 'ADD .25 (PI/2) TO FPA0'),
        (0xf1f4, 0xf1f4, 'GET OLD MANTISSA SIGN'),
        (0xf1f6, 0xf1f6, '* BRANCH IF OLD'),
        (0xf1f7, 0xf1f7, '* SIGN WAS POSITIVE'),
        (0xf1f9, 0xf1f9, 'TOGGLE MANTISSA SIGN'),
        (0xf1fc, 0xf1fc, 'POINT X TO TABLE OF COEFFICIENTS'),
        (0xf1ff, 0xf1ff, 'GO CALCULATE POLYNOMIAL VALUE'),
        (0xf202, 0xf202, '6.28318531 (2*PI)'),
        (0xf207, 0xf207, '.25'),
        (0xf20c, 0xf20c, 'SIX COEFFICIENTS'),
        (0xf20d, 0xf20d, '* -((2*PI)**11)/11!'),
        (0xf212, 0xf212, '* ((2*PI)**9)/9!'),
        (0xf217, 0xf217, '* -((2*PI)**7)/7!'),
        (0xf21c, 0xf21c, '* ((2*PI)**5)/5!'),
        (0xf221, 0xf221, '* -((2*PI)**3)/3!'),
        (0xf22b, 0xf22b, 'UNUSED GARBAGE BYTES'),
        (0xf230, 0xf230, 'UNUSED GARBAGE BYTES'),
        (0xf235, 0xf235, 'POINT X TO FP CONSTANT (P1/2)'),
        (0xf238, 0xf238, 'ADD FPA0 TO (X)'),
        (0xf23b, 0xf23b, 'JUMP TO SIN ROUTINE'),
        (0xf23e, 0xf23e, 'PACK FPA0 AND MOVE IT TO FPA3'),
        (0xf241, 0xf241, 'RESET QUADRANT FLAG'),
        (0xf243, 0xf243, 'CALCULATE SIN OF ARGUMENT'),
        (0xf245, 0xf245, 'POINT X TO FPA5'),
        (0xf248, 0xf248, 'PACK FPA0 AND MOVE IT TO FPA5'),
        (0xf24b, 0xf24b, 'POINT X TO FPA3'),
        (0xf24e, 0xf24e, 'MOVE FPA3 TO FPA0'),
        (0xf251, 0xf251, 'FORCE FPA0 MANTISSA TO BE POSITIVE'),
        (0xf253, 0xf253, 'GET THE QUADRANT FLAG - COS NEGATIVE IN QUADS 2,3'),
        (0xf255, 0xf255, 'CALCULATE VALUE OF COS(FPA0)'),
        (0xf257, 0xf257, 'CHECK EXPONENT OF FPA0'),
        (0xf259, 0xf259, "'OV' ERROR IF COS(X)=0"),
        (0xf25d, 0xf25d, 'POINT X TO FPA5'),
        (0xf260, 0xf260, 'DIVIDE (X) BY FPA0 - SIN(X)/COS(X)'),
        (0xf263, 0xf263, 'SAVE SIGN FLAG ON STACK'),
        (0xf265, 0xf265, 'EXPAND POLYNOMIAL'),
        (0xf268, 0xf268, '1.57079633 (PI/2)'),
        (0xf26d, 0xf26d, '* GET THE SIGN OF THE MANTISSA AND'),
        (0xf26f, 0xf26f, '* SAVE IT ON THE STACK'),
        (0xf271, 0xf271, 'BRANCH IF POSITIVE MANTISSA'),
        (0xf273, 0xf273, 'CHANGE SIGN OF FPA0'),
        (0xf275, 0xf275, '* GET EXPONENT OF FPA0 AND'),
        (0xf277, 0xf277, '* SAVE IT ON THE STACK'),
        (0xf279, 0xf279, 'IS FPAO < 1.0?'),
        (0xf27b, 0xf27b, 'YES'),
        (0xf27d, 0xf27d, 'POINT X TO FP CONSTANT 1.0'),
        (0xf280, 0xf280, 'GET RECIPROCAL OF FPA0'),
        (0xf282, 0xf282, 'POINT (X) TO TAYLOR SERIES COEFFICIENTS'),
        (0xf285, 0xf285, 'EXPAND POLYNOMIAL'),
        (0xf288, 0xf288, 'GET EXPONENT OF ARGUMENT'),
        (0xf28a, 0xf28a, 'WAS ARGUMENT < 1.0?'),
        (0xf28c, 0xf28c, 'YES'),
        (0xf28e, 0xf28e, 'POINT (X) TO FP NUMBER (PI/2)'),
        (0xf291, 0xf291, 'SUBTRACT FPA0 FROM (PI/2)'),
        (0xf294, 0xf294, '* GET SIGN OF INITIAL ARGUMENT MANTISSA'),
        (0xf296, 0xf296, '* AND SET FLAGS ACCORDING TO IT'),
        (0xf297, 0xf297, 'RETURN IF ARGUMENT WAS POSITIVE'),
        (0xf299, 0xf299, 'CHANGE MANTISSA SIGN OF FPA0'),
        (0xf29d, 0xf29d, 'TWELVE COEFFICIENTS'),
        (0xf29e, 0xf29e, '-6.84793912E-04 1/23'),
        (0xf2a3, 0xf2a3, '+4.85094216E-03 1/21'),
        (0xf2a8, 0xf2a8, '-0.0161117018'),
        (0xf2ad, 0xf2ad, '0.0342096381'),
        (0xf2b2, 0xf2b2, '-0.0542791328'),
        (0xf2b7, 0xf2b7, '0.0724571965'),
        (0xf2bc, 0xf2bc, '-0.0898023954'),
        (0xf2c1, 0xf2c1, '0.110932413'),
        (0xf2c6, 0xf2c6, '-0.142839808'),
        (0xf2cb, 0xf2cb, '0.199999121'),
        (0xf2d0, 0xf2d0, '-0.333333316'),
        (0xf2d5, 0xf2d5, '1'),
        (0xf2da, 0xf2da, 'FOUR COEFFICIENTS'),
        (0xf2db, 0xf2db, '0.434255942'),
        (0xf2e0, 0xf2e0, '0.576584541'),
        (0xf2e5, 0xf2e5, '0.961800759'),
        (0xf2ea, 0xf2ea, '2.88539007'),
        (0xf2ef, 0xf2ef, '1/SQR(2)'),
        (0xf2f4, 0xf2f4, 'SQR(2)'),
        (0xf2f9, 0xf2f9, '-0.5'),
        (0xf2fe, 0xf2fe, 'LN(2)'),
        (0xf303, 0xf303, 'CHECK STATUS OF FPA0'),
        (0xf306, 0xf306, "'FC' ERROR IF NEGATIVE OR ZERO"),
        (0xf30a, 0xf30a, 'POINT (X) TO FP NUMBER (1/SQR(2))'),
        (0xf30d, 0xf30d, '*GET EXPONENT OF ARGUMENT'),
        (0xf30f, 0xf30f, '*SUBTRACT OFF THE BIAS AND'),
        (0xf311, 0xf311, '*SAVE IT ON THE STACK'),
        (0xf317, 0xf317, 'ADD FPA0 TO (X)'),
        (0xf31a, 0xf31a, 'POINT X TO SQR(2)'),
        (0xf31d, 0xf31d, 'DIVIDE SQR(2) BY FPA0'),
        (0xf320, 0xf320, 'POINT X TO FP VALUE OF 1.00'),
        (0xf323, 0xf323, 'SUBTRACT FPA0 FROM (X)'),
        (0xf326, 0xf326, 'POINT X TO TABLE OF COEFFICIENTS'),
        (0xf329, 0xf329, 'EXPAND POLYNOMIAL'),
        (0xf32c, 0xf32c, 'POINT X TO FP VALUE OF (-.5)'),
        (0xf32f, 0xf32f, 'ADD FPA0 TO X'),
        (0xf332, 0xf332, 'GET EXPONENT OF ARGUMENT BACK (WITHOUT BIAS)'),
        (0xf334, 0xf334, 'ADD ACCB TO FPA0'),
        (0xf337, 0xf337, 'POINT X TO LN(2)'),
        (0xf33a, 0xf33a, 'MULTIPLY FPA0 * LN(2)'),
        (0xf33d, 0xf33d, 'MOVE FPA0 TO FPA1'),
        (0xf340, 0xf340, 'POINT (X) TO FP NUMBER (.5)'),
        (0xf343, 0xf343, 'COPY A PACKED NUMBER FROM (X) TO FPA0'),
        (0xf346, 0xf346, 'DO A NATURAL EXPONENTIATION IF EXPONENT = 0'),
        (0xf348, 0xf348, '*CHECK VALUE BEING EXPONENTIATED'),
        (0xf349, 0xf349, '*AND BRANCH IF IT IS <> 0'),
        (0xf34b, 0xf34b, 'FPA0=0 IF RAISING ZERO TO A POWER'),
        (0xf34e, 0xf34e, '* PACK FPA0 AND SAVE'),
        (0xf351, 0xf351, "* IT IN FPA5 (ARGUMENT'S EXPONENT)"),
        (0xf354, 0xf354, 'ACCB=DEFAULT RESULT SIGN FLAG; 0=POSITIVE'),
        (0xf355, 0xf355, '*CHECK THE SIGN OF ARGUMENT'),
        (0xf357, 0xf357, '*BRANCH IF POSITIVE'),
        (0xf359, 0xf359, 'CONVERT EXPONENT INTO AN INTEGER'),
        (0xf35c, 0xf35c, 'POINT X TO FPA5 (ORIGINAL EXPONENT)'),
        (0xf35f, 0xf35f, 'GET MANTISSA SIGN OF FPA1 (ARGUMENT)'),
        (0xf361, 0xf361, '*COMPARE FPA0 TO (X) AND'),
        (0xf364, 0xf364, '*BRANCH IF NOT EQUAL'),
        (0xf366, 0xf366, 'TOGGLE FPA1 MANTISSA SIGN - FORCE POSITIVE'),
        (0xf367, 0xf367, 'GET LS BYTE OF INTEGER VALUE OF EXPONENT (RESULT SIGN FLAG)'),
        (0xf369, 0xf369, 'COPY FPA1 TO FPA0; ACCA = MANTISSA SIGN'),
        (0xf36c, 0xf36c, 'PUT RESULT SIGN FLAG ON THE STACK'),
        (0xf371, 0xf371, 'POINT (X) TO FPA5'),
        (0xf374, 0xf374, 'MULTIPLY FPA0 BY FPA5'),
        (0xf377, 0xf377, 'CALCULATE E**(FPA0)'),
        (0xf379, 0xf379, '* GET RESULT SIGN FLAG FROM THE STACK'),
        (0xf37b, 0xf37b, 'IF NEGATIVE'),
        (0xf37c, 0xf37c, 'CHANGE SIGN OF FPA0 MANTISSA'),
        (0xf381, 0xf381, '1.44269504 ( CF )'),
        (0xf386, 0xf386, 'EIGHT COEFFICIENTS'),
        (0xf387, 0xf387, '2.14987637E-05: 1/(7!*(CF**7))'),
        (0xf38c, 0xf38c, '1.4352314E-04 : 1/(6!*(CF**6))'),
        (0xf391, 0xf391, '1.34226348E-03: 1/(5!*(CF**5))'),
        (0xf396, 0xf396, '9.61401701E-03: 1/(4!*(CF**4))'),
        (0xf39b, 0xf39b, '0.0555051269'),
        (0xf3a0, 0xf3a0, '0.240226385'),
        (0xf3a5, 0xf3a5, '0.693147186'),
        (0xf3aa, 0xf3aa, '1'),
        (0xf3af, 0xf3af, 'POINT X TO THE CORRECTION FACTOR'),
        (0xf3b2, 0xf3b2, 'MULTIPLY FPA0 BY (X)'),
        (0xf3b5, 0xf3b5, 'PACK FPA0 AND STORE IT IN FPA3'),
        (0xf3b8, 0xf3b8, '*GET EXPONENT OF FPA0 AND'),
        (0xf3ba, 0xf3ba, '*COMPARE TO THE MAXIMUM VALUE'),
        (0xf3bc, 0xf3bc, 'BRANCH IF FPA0 < 128'),
        (0xf3be, 0xf3be, "SET FPA0 = 0 OR 'OV' ERROR"),
        (0xf3c1, 0xf3c1, 'CONVERT FPA0 TO INTEGER'),
        (0xf3c4, 0xf3c4, 'GET LS BYTE OF INTEGER'),
        (0xf3c6, 0xf3c6, '* WAS THE ARGUMENT =127, IF SO'),
        (0xf3c8, 0xf3c8, "* THEN 'OV' ERROR; THIS WILL ALSO ADD THE $80 BIAS"),
        (0xf3ca, 0xf3ca, 'DECREMENT ONE FROM THE EXPONENT, BECAUSE $81, NOT $80 WAS USED ABOVE'),
        (0xf3cb, 0xf3cb, 'SAVE EXPONENT OF INTEGER PORTION ON STACK'),
        (0xf3cd, 0xf3cd, 'POINT (X) TO FPA3'),
        (0xf3d0, 0xf3d0, 'SUBTRACT FPA0 FROM (X) - GET FRACTIONAL PART OF ARGUMENT'),
        (0xf3d3, 0xf3d3, 'POINT X TO COEFFICIENTS'),
        (0xf3d6, 0xf3d6, 'EVALUATE POLYNOMIAL FOR FRACTIONAL PART'),
        (0xf3d9, 0xf3d9, 'FORCE THE MANTISSA TO BE POSITIVE'),
        (0xf3db, 0xf3db, 'GET INTEGER EXPONENT FROM STACK'),
        (0xf3dd, 0xf3dd, '* CALCULATE EXPONENT OF NEW FPA0 BY ADDING THE EXPONENTS OF THE'),
        (0xf3e1, 0xf3e1, 'CHECK STATUS OF FPA0'),
        (0xf3e4, 0xf3e4, 'BRANCH IF FPA0 = NEGATIVE'),
        (0xf3e6, 0xf3e6, 'CONVERT FPA0 TO INTEGER'),
        (0xf3e9, 0xf3e9, 'TOGGLE SIGN OF FPA0 MANTISSA'),
        (0xf3eb, 0xf3eb, 'CONVERT FPA0 TO INTEGER'),
        (0xf3ed, 0xf3ed, 'TOGGLE SIGN OF FPA0'),
        (0xf3f0, 0xf3f0, 'GET LINE NUMBER FROM BASIC'),
        (0xf3f3, 0xf3f3, 'RETURN ADDRESS OFF OF THE STACK'),
        (0xf3f5, 0xf3f5, "'LIST' FLAG"),
        (0xf3f7, 0xf3f7, 'SET FLAG TO LIST LINE'),
        (0xf3f9, 0xf3f9, 'GO FIND THE LINE NUMBER IN PROGRAM'),
        (0xf3fc, 0xf3fc, "#7 'UNDEFINED LINE #'"),
        (0xf400, 0xf400, 'GO UNCRUNCH LINE INTO BUFFER AT LINBUF+1'),
        (0xf403, 0xf403, 'PUT ABSOLUTE ADDRESS OF END OF LINE TO ACCD'),
        (0xf405, 0xf405, 'SUBTRACT OUT THE START OF LINE'),
        (0xf408, 0xf408, 'SAVE LENGTH OF LINE'),
        (0xf40a, 0xf40a, 'GET THE HEX VALUE OF LINE NUMBER'),
        (0xf40c, 0xf40c, 'LIST THE LINE NUMBER ON THE SCREEN'),
        (0xf40f, 0xf40f, 'PRINT A SPACE'),
        (0xf412, 0xf412, 'POINT X TO BUFFER'),
        (0xf415, 0xf415, '* CHECK TO SEE IF LINE IS TO BE'),
        (0xf417, 0xf417, '* LISTED TO SCREEN - BRANCH IF IT IS'),
        (0xf419, 0xf419, 'RESET DIGIT ACCUMULATOR - DEFAULT VALUE'),
        (0xf41a, 0xf41a, 'GET KEY STROKE'),
        (0xf41d, 0xf41d, 'SET CARRY IF NOT NUMERIC'),
        (0xf420, 0xf420, 'BRANCH IF NOT NUMERIC'),
        (0xf422, 0xf422, 'OFF ASCII'),
        (0xf424, 0xf424, 'IT ON STACK'),
        (0xf426, 0xf426, 'NUMBER BEING CONVERTED IS BASE 10'),
        (0xf428, 0xf428, 'ACCUMULATED VALUE BY BASE (10)'),
        (0xf429, 0xf429, 'DIGIT TO ACCUMULATED VALUE'),
        (0xf42b, 0xf42b, 'CHECK FOR ANOTHER DIGIT'),
        (0xf42d, 0xf42d, 'REPEAT PARAMETER IN ACCB; IF IT'),
        (0xf42f, 0xf42f, "0, THEN MAKE IT '1'"),
        (0xf431, 0xf431, 'BORT?'),
        (0xf433, 0xf433, 'NO'),
        (0xf435, 0xf435, 'PRINT CARRIAGE RETURN TO SCREEN'),
        (0xf438, 0xf438, 'RESTART EDIT PROCESS - CANCEL ALL CHANGES'),
        (0xf43a, 0xf43a, 'IST?'),
        (0xf43c, 0xf43c, 'NO'),
        (0xf43e, 0xf43e, 'LIST THE LINE'),
        (0xf440, 0xf440, "RESET THE LIST FLAG TO 'NO LIST'"),
        (0xf442, 0xf442, 'PRINT CARRIAGE RETURN'),
        (0xf445, 0xf445, 'GO INTERPRET ANOTHER EDIT COMMAND'),
        (0xf447, 0xf447, 'RETURN ADDRESS OFF OF THE STACK'),
        (0xf449, 0xf449, 'KEY?'),
        (0xf44b, 0xf44b, 'NO'),
        (0xf44d, 0xf44d, 'ECHO THE LINE TO THE SCREEN'),
        (0xf44f, 0xf44f, 'PRINT CARRIAGE RETURN'),
        (0xf452, 0xf452, "* RESET BASIC'S INPUT POINTER"),
        (0xf455, 0xf455, '* TO THE LINE INPUT BUFFER'),
        (0xf457, 0xf457, 'GO PUT LINE BACK IN PROGRAM'),
        (0xf45a, 0xf45a, 'XIT?'),
        (0xf45c, 0xf45c, 'YES - SAME AS ENTER EXCEPT NO ECHO'),
        (0xf45e, 0xf45e, 'UIT?'),
        (0xf460, 0xf460, 'NO'),
        (0xf462, 0xf462, 'PRINT CARRIAGE RETURN TO SCREEN'),
        (0xf465, 0xf465, 'GO TO COMMAND LEVEL - MAKE NO CHANGES'),
        (0xf468, 0xf468, 'INTERPRET THE REMAINING COMMANDS AS SUBROUTINES'),
        (0xf46a, 0xf46a, 'GO INTERPRET ANOTHER EDIT COMMAND'),
        (0xf46c, 0xf46c, 'SPACE BAR?'),
        (0xf46e, 0xf46e, 'NO'),
        (0xf470, 0xf470, 'SKIP TWO BYTES'),
        (0xf471, 0xf471, '250 BYTES MAX IN BUFFER'),
        (0xf473, 0xf473, 'GET A CHARACTER FROM BUFFER'),
        (0xf475, 0xf475, "EXIT IF IT'S A 0"),
        (0xf477, 0xf477, 'SEND CHAR TO CONSOLE OUT'),
        (0xf47a, 0xf47a, 'POINTER UP ONE'),
        (0xf47c, 0xf47c, 'CHARACTER COUNTER'),
        (0xf47d, 0xf47d, 'LOOP IF NOT DONE'),
        (0xf480, 0xf480, 'ELETE?'),
        (0xf482, 0xf482, 'NO'),
        (0xf484, 0xf484, '* CHECK FOR END OF LINE'),
        (0xf486, 0xf486, '* AND BRANCH IF SO'),
        (0xf488, 0xf488, 'REMOVE A CHARACTER'),
        (0xf48a, 0xf48a, 'REPEAT PARAMETER'),
        (0xf48b, 0xf48b, 'BRANCH IF NOT DONE'),
        (0xf48e, 0xf48e, 'DECREMENT LENGTH OF BUFFER'),
        (0xf490, 0xf490, 'POINT Y TO ONE BEFORE CURRENT BUFFER POINTER'),
        (0xf492, 0xf492, 'TEMPORARY BUFFER POINTER'),
        (0xf494, 0xf494, 'GET NEXT CHARACTER'),
        (0xf496, 0xf496, 'PUT IT IN CURRENT POSITION'),
        (0xf498, 0xf498, 'BRANCH IF NOT END OF LINE'),
        (0xf49b, 0xf49b, 'NSERT?'),
        (0xf49d, 0xf49d, 'YES'),
        (0xf49f, 0xf49f, 'XTEND?'),
        (0xf4a1, 0xf4a1, 'YES'),
        (0xf4a3, 0xf4a3, 'ACK?'),
        (0xf4a5, 0xf4a5, 'NO'),
        (0xf4a7, 0xf4a7, 'TURN CURRENT BUFFER POINTER INTO END OF LINE FLAG'),
        (0xf4a9, 0xf4a9, 'PUT CURRENT BUFFER POINTER IN ACCD'),
        (0xf4ab, 0xf4ab, 'SUBTRACT INITIAL POINTER POSITION'),
        (0xf4ae, 0xf4ae, 'SAVE NEW BUFFER LENGTH'),
        (0xf4b0, 0xf4b0, 'DISPLAY THE LINE ON THE SCREEN'),
        (0xf4b2, 0xf4b2, 'GET A KEYSTROKE'),
        (0xf4b5, 0xf4b5, 'KEY?'),
        (0xf4b7, 0xf4b7, 'YES - INTERPRET ANOTHER COMMAND - PRINT LINE'),
        (0xf4b9, 0xf4b9, 'SCAPE?'),
        (0xf4bb, 0xf4bb, "YES - RETURN TO COMMAND LEVEL - DON'T PRINT LINE"),
        (0xf4bd, 0xf4bd, 'SPACE?'),
        (0xf4bf, 0xf4bf, 'NO'),
        (0xf4c1, 0xf4c1, 'COMPARE POINTER TO START OF BUFFER'),
        (0xf4c4, 0xf4c4, 'DO NOT ALLOW BS IF AT START'),
        (0xf4c6, 0xf4c6, 'MOVE POINTER BACK ONE, BS TO SCREEN'),
        (0xf4c8, 0xf4c8, 'REMOVE ONE CHARACTER FROM BUFFER'),
        (0xf4ca, 0xf4ca, 'GET INSERT SUB COMMAND'),
        (0xf4cc, 0xf4cc, 'HANGE?'),
        (0xf4ce, 0xf4ce, 'NO'),
        (0xf4d0, 0xf4d0, 'CHECK CURRENT BUFFER CHARACTER'),
        (0xf4d2, 0xf4d2, 'BRANCH IF END OF LINE'),
        (0xf4d4, 0xf4d4, 'GET A KEYSTROKE'),
        (0xf4d7, 0xf4d7, 'BRANCH IF LEGITIMATE KEY'),
        (0xf4d9, 0xf4d9, 'TRY AGAIN IF ILLEGAL KEY'),
        (0xf4db, 0xf4db, 'INSERT NEW CHARACTER INTO BUFFER'),
        (0xf4dd, 0xf4dd, 'SEND NEW CHARACTER TO SCREEN'),
        (0xf4df, 0xf4df, 'REPEAT PARAMETER'),
        (0xf4e0, 0xf4e0, 'BRANCH IF NOT DONE'),
        (0xf4e3, 0xf4e3, 'GET LENGTH OF LINE'),
        (0xf4e5, 0xf4e5, 'COMPARE TO MAXIMUM LENGTH'),
        (0xf4e7, 0xf4e7, 'BRANCH IF NOT AT MAXIMUM'),
        (0xf4e9, 0xf4e9, 'IGNORE INPUT IF LINE AT MAXIMUM LENGTH'),
        (0xf4eb, 0xf4eb, 'CURRENT BUFFER POINTER'),
        (0xf4ed, 0xf4ed, '* SCAN THE LINE UNTIL END OF'),
        (0xf4ef, 0xf4ef, '* LINE (0) IS FOUND'),
        (0xf4f1, 0xf4f1, 'DECR TEMP LINE POINTER AND GET A CHARACTER'),
        (0xf4f3, 0xf4f3, 'PUT CHARACTER BACK DOWN ONE SPOT'),
        (0xf4f5, 0xf4f5, 'WE REACHED STARTING POINT?'),
        (0xf4f7, 0xf4f7, 'NO - KEEP GOING'),
        (0xf4f9, 0xf4f9, 'BUFFER POINTER FROM STACK'),
        (0xf4fb, 0xf4fb, 'INSERT NEW CHARACTER INTO THE LINE'),
        (0xf4fd, 0xf4fd, 'SEND A CHARACTER TO CONSOLE OUT'),
        (0xf4ff, 0xf4ff, 'ADD ONE TO BUFFER LENGTH'),
        (0xf501, 0xf501, 'GET INSERT SUB COMMAND'),
        (0xf503, 0xf503, 'CKSPACE?'),
        (0xf505, 0xf505, 'NO'),
        (0xf507, 0xf507, 'MOVE POINTER BACK 1, SEND BS TO SCREEN'),
        (0xf509, 0xf509, 'REPEAT PARAMETER'),
        (0xf50a, 0xf50a, 'LOOP UNTIL DONE'),
        (0xf50d, 0xf50d, 'COMPARE POINTER TO START OF BUFFER'),
        (0xf510, 0xf510, 'DO NOT ALLOW BS IF AT START'),
        (0xf512, 0xf512, 'MOVE POINTER BACK ONE'),
        (0xf514, 0xf514, 'BACK SPACE'),
        (0xf516, 0xf516, 'SEND TO CONSOLE OUT'),
        (0xf519, 0xf519, 'ILL?'),
        (0xf51b, 0xf51b, 'YES'),
        (0xf51d, 0xf51d, 'EARCH?'),
        (0xf51f, 0xf51f, 'YES'),
        (0xf522, 0xf522, 'KILL/SEARCH FLAG ON STACK'),
        (0xf524, 0xf524, '* GET A KEYSTROKE (TARGET CHARACTER)'),
        (0xf526, 0xf526, 'SAVE IT ON STACK'),
        (0xf528, 0xf528, 'GET CURRENT BUFFER CHARACTER'),
        (0xf52a, 0xf52a, 'AND RETURN IF END OF LINE'),
        (0xf52c, 0xf52c, 'CHECK KILL/SEARCH FLAG'),
        (0xf52e, 0xf52e, 'BRANCH IF KILL'),
        (0xf530, 0xf530, 'SEND A CHARACTER TO CONSOLE OUT'),
        (0xf532, 0xf532, 'BUFFER POINTER'),
        (0xf534, 0xf534, 'CHECK NEXT INPUT CHARACTER'),
        (0xf536, 0xf536, 'REMOVE ONE CHARACTER FROM BUFFER'),
        (0xf539, 0xf539, 'GET CURRENT INPUT CHARACTER'),
        (0xf53b, 0xf53b, 'TO TARGET CHARACTER'),
        (0xf53d, 0xf53d, 'BRANCH IF NO MATCH'),
        (0xf53f, 0xf53f, 'REPEAT PARAMETER'),
        (0xf540, 0xf540, 'BRANCH IF NOT DONE'),
        (0xf542, 0xf542, 'Y PULL WILL CLEAN UP THE STACK FOR THE 2 PSHS A'),
        (0xf544, 0xf544, 'CALL CONSOLE IN : DEV NBR=SCREEN'),
        (0xf547, 0xf547, 'CHARACTER?'),
        (0xf549, 0xf549, 'YES - GET ANOTHER CHAR'),
        (0xf54b, 0xf54b, 'UP ARROW (QUIT INSERT)'),
        (0xf54d, 0xf54d, 'NO'),
        (0xf54f, 0xf54f, 'REPLACE W/ESCAPE CODE'),
        (0xf551, 0xf551, 'KEY'),
        (0xf553, 0xf553, 'YES'),
        (0xf555, 0xf555, 'SCAPE?'),
        (0xf557, 0xf557, 'YES'),
        (0xf559, 0xf559, 'CKSPACE?'),
        (0xf55b, 0xf55b, 'YES'),
        (0xf55d, 0xf55d, 'SPACE'),
        (0xf55f, 0xf55f, 'GET ANOTHER CHAR IF CONTROL CHAR'),
        (0xf561, 0xf561, 'CARRY'),
        (0xf564, 0xf564, 'SKIP ONE BYTE AND LDA #$4F'),
        (0xf565, 0xf565, 'TROFF FLAG'),
        (0xf566, 0xf566, 'TRON/TROFF FLAG:0=TROFF, <> 0=TRON'),
        (0xf569, 0xf569, 'GET DEVICE NUMBER'),
        (0xf56b, 0xf56b, 'GET PRINT POSITION'),
        (0xf56d, 0xf56d, 'CONVERT ACCB TO 2 DIGIT SIGNED INTEGER'),
        (0xf56e, 0xf56e, 'CONVERT ACCD TO FLOATING POINT'),
        (0xf571, 0xf571, "SYNTAX CHECK FOR '('"),
        (0xf574, 0xf574, 'GET ADDR OF END OF ARRAYS'),
        (0xf576, 0xf576, 'SAVE IT ON STACK'),
        (0xf578, 0xf578, 'GET VARIABLE DESCRIPTOR'),
        (0xf57b, 0xf57b, "SYNTAX CHECK FOR ')'"),
        (0xf57e, 0xf57e, 'GET END OF ARRAYS ADDR BACK'),
        (0xf580, 0xf580, 'SWAP END OF ARRAYS AND VARIABLE DESCRIPTOR'),
        (0xf582, 0xf582, 'COMPARE TO NEW END OF ARRAYS'),
        (0xf584, 0xf584, "'FC' ERROR IF VARIABLE WAS NOT DEFINED PRIOR TO CALLING VARPTR"),
        (0xf586, 0xf586, 'CONVERT VARIABLE DESCRIPTOR INTO A FP NUMBER'),
        (0xf589, 0xf589, 'GET INPUT CHAR FROM BASIC'),
        (0xf58b, 0xf58b, "SYNTAX CHECK FOR '('"),
        (0xf58e, 0xf58e, '* GET VARIABLE DESCRIPTOR ADDRESS AND'),
        (0xf591, 0xf591, '* SAVE IT ON THE STACK'),
        (0xf593, 0xf593, 'POINT ACCD TO START OF OLDSTRING'),
        (0xf595, 0xf595, 'COMPARE TO START OF CLEARED SPACE'),
        (0xf598, 0xf598, 'BRANCH IF <='),
        (0xf59a, 0xf59a, 'SUBTRACT OUT TOP OF CLEARED SPACE'),
        (0xf59c, 0xf59c, 'BRANCH IF STRING IN STRING SPACE'),
        (0xf59e, 0xf59e, 'GET LENGTH OF OLDSTRING'),
        (0xf5a0, 0xf5a0, 'RESERVE ACCB BYTES IN STRING SPACE'),
        (0xf5a3, 0xf5a3, 'SAVE RESERVED SPACE STRING ADDRESS ON STACK'),
        (0xf5a5, 0xf5a5, 'POINT X TO OLDSTRING DESCRIPTOR'),
        (0xf5a7, 0xf5a7, 'MOVE OLDSTRING INTO STRING SPACE'),
        (0xf5aa, 0xf5aa, '* GET OLDSTRING DESCRIPTOR ADDRESS AND RESERVED STRING'),
        (0xf5ac, 0xf5ac, '* ADDRESS AND SAVE RESERVED ADDRESS AS OLDSTRING ADDRESS'),
        (0xf5ae, 0xf5ae, 'SAVE OLDSTRING DESCRIPTOR ADDRESS'),
        (0xf5b0, 0xf5b0, 'SYNTAX CHECK FOR COMMA AND EVALUATE LENGTH EXPRESSION'),
        (0xf5b3, 0xf5b3, 'SAVE POSITION PARAMETER ON STACK'),
        (0xf5b5, 0xf5b5, 'POSITION PARAMETER AND BRANCH'),
        (0xf5b6, 0xf5b6, '* IF START OF STRING'),
        (0xf5b8, 0xf5b8, 'DEFAULT REPLACEMENT LENGTH = $FF'),
        (0xf5ba, 0xf5ba, '* CHECK FOR END OF MID$ STATEMENT AND'),
        (0xf5bc, 0xf5bc, '* BRANCH IF AT END OF STATEMENT'),
        (0xf5be, 0xf5be, 'SYNTAX CHECK FOR COMMA AND EVALUATE LENGTH EXPRESSION'),
        (0xf5c1, 0xf5c1, 'SAVE LENGTH PARAMETER ON STACK'),
        (0xf5c3, 0xf5c3, "SYNTAX CHECK FOR ')'"),
        (0xf5c6, 0xf5c6, 'TOKEN FOR ='),
        (0xf5c8, 0xf5c8, 'SYNTAX CHECK FOR "=\''),
        (0xf5cb, 0xf5cb, 'EVALUATE REPLACEMENT STRING'),
        (0xf5cd, 0xf5cd, 'SAVE REPLACEMENT STRING ADDRESS IN U'),
        (0xf5cf, 0xf5cf, 'POINT X TO OLOSTRING DESCRIPTOR ADDRESS'),
        (0xf5d1, 0xf5d1, 'GET LENGTH OF OLDSTRING'),
        (0xf5d3, 0xf5d3, 'SUBTRACT POSITION PARAMETER'),
        (0xf5d5, 0xf5d5, 'INSERT REPLACEMENT STRING INTO OLDSTRING'),
        (0xf5d7, 0xf5d7, "'FC' ERROR IF POSITION > LENGTH OF OLDSTRING"),
        (0xf5da, 0xf5da, '* NOW ACCA = NUMBER OF CHARACTERS TO THE RIGHT'),
        (0xf5dd, 0xf5dd, 'BRANCH IF NEW STRING WILL FIT IN OLDSTRING'),
        (0xf5df, 0xf5df, 'IF NOT, USE AS MUCH OF LENGTH PARAMETER AS WILL FIT'),
        (0xf5e1, 0xf5e1, 'GET POSITION PARAMETER'),
        (0xf5e3, 0xf5e3, 'ACCA=LENGTH OF REPL STRING, ACCB=POSITION PARAMETER'),
        (0xf5e5, 0xf5e5, 'POINT X TO OLDSTRING ADDRESS'),
        (0xf5e7, 0xf5e7, "* BASIC'S POSITION PARAMETER STARTS AT 1; THIS ROUTINE"),
        (0xf5e8, 0xf5e8, 'POINT X TO POSITION IN OLDSTRING WHERE THE REPLACEMENT WILL GO'),
        (0xf5e9, 0xf5e9, '* IF THE LENGTH OF THE REPLACEMENT STRING IS ZERO'),
        (0xf5ea, 0xf5ea, '* THEN RETURN'),
        (0xf5ee, 0xf5ee, 'ADJUSTED LENGTH PARAMETER, THEN BRANCH'),
        (0xf5f0, 0xf5f0, 'OTHERWISE USE AS MUCH ROOM AS IS AVAILABLE'),
        (0xf5f2, 0xf5f2, 'SAVE NUMBER OF BYTES TO MOVE IN ACCB'),
        (0xf5f4, 0xf5f4, 'SWAP SOURCE AND DESTINATION POINTERS'),
        (0xf5f6, 0xf5f6, 'MOVE (B) BYTES FROM (X) TO (U)'),
        (0xf5f9, 0xf5f9, 'PC'),
        (0xf5fb, 0xf5fb, 'EVALUATE EXPRESSION'),
        (0xf5fe, 0xf5fe, "*'TM' ERROR IF NUMERIC; RETURN WITH X POINTING"),
        (0xf601, 0xf601, "SYNTAX CHECK FOR '('"),
        (0xf604, 0xf604, 'EVALUATE EXPRESSION; ERROR IF > 255'),
        (0xf607, 0xf607, 'SAVE LENGTH OF STRING'),
        (0xf609, 0xf609, 'SYNTAX CHECK FOR COMMA'),
        (0xf60c, 0xf60c, 'EVALUATE EXPRESSION'),
        (0xf60f, 0xf60f, "SYNTAX CHECK FOR ')'"),
        (0xf612, 0xf612, 'GET VARIABLE TYPE'),
        (0xf614, 0xf614, 'BRANCH IF STRING'),
        (0xf616, 0xf616, 'CONVERT FPA0 INTO AN INTEGER IN ACCB'),
        (0xf619, 0xf619, 'SAVE THE STRING IN STRING SPACE'),
        (0xf61b, 0xf61b, 'GET FIRST BYTE OF STRING'),
        (0xf61e, 0xf61e, 'SAVE FIRST BYTE OF EXPRESSION'),
        (0xf620, 0xf620, 'GET LENGTH OF STRING'),
        (0xf622, 0xf622, 'RESERVE ACCB BYTES IN STRING SPACE'),
        (0xf625, 0xf625, 'GET LENGTH OF STRING AND CHARACTER'),
        (0xf627, 0xf627, 'BRANCH IF NULL STRING'),
        (0xf629, 0xf629, 'SAVE A CHARACTER IN STRING SPACE'),
        (0xf62b, 0xf62b, 'DECREMENT LENGTH'),
        (0xf62c, 0xf62c, 'BRANCH IF NOT DONE'),
        (0xf62e, 0xf62e, 'PUT STRING DESCRIPTOR ONTO STRING STACK'),
        (0xf631, 0xf631, "SYNTAX CHECK FOR '('"),
        (0xf634, 0xf634, 'EVALUATE EXPRESSION'),
        (0xf637, 0xf637, 'DEFAULT POSITION = 1 (SEARCH START)'),
        (0xf639, 0xf639, 'SAVE START'),
        (0xf63b, 0xf63b, 'GET VARIABLE TYPE'),
        (0xf63d, 0xf63d, 'BRANCH IF STRING'),
        (0xf63f, 0xf63f, 'CONVERT FPA0 TO INTEGER IN ACCB'),
        (0xf642, 0xf642, 'SAVE START SEARCH VALUE'),
        (0xf644, 0xf644, 'BRANCH IF START SEARCH AT ZERO'),
        (0xf646, 0xf646, 'SYNTAX CHECK FOR COMMA'),
        (0xf649, 0xf649, 'EVALUATE EXPRESSION - SEARCH STRING'),
        (0xf64c, 0xf64c, "'TM' ERROR IF NUMERIC"),
        (0xf64f, 0xf64f, 'SEARCH STRING DESCRIPTOR ADDRESS'),
        (0xf651, 0xf651, 'SAVE ON THE STACK'),
        (0xf653, 0xf653, 'SYNTAX CHECK FOR COMMA'),
        (0xf656, 0xf656, 'EVALUATE TARGET STRING EXPRESSION'),
        (0xf659, 0xf659, 'SAVE ADDRESS AND LENGTH ON STACK'),
        (0xf65b, 0xf65b, "SYNTAX CHECK FOR ')'"),
        (0xf65e, 0xf65e, '* LOAD X WITH SEARCH STRING DESCRIPTOR ADDRESS'),
        (0xf660, 0xf660, '* AND GET THE LENGTH ANDADDRESS OF SEARCH STRING'),
        (0xf663, 0xf663, 'SAVE LENGTH ON STACK'),
        (0xf665, 0xf665, 'COMPARE LENGTH OF SEARCH STRING TO START'),
        (0xf667, 0xf667, 'POSITION; RETURN 0 IF LENGTH < START'),
        (0xf669, 0xf669, 'GET LENGTH OF TARGET STRING'),
        (0xf66b, 0xf66b, 'BRANCH IF TARGET STRING = NULL'),
        (0xf66d, 0xf66d, 'GET START POSITION'),
        (0xf66f, 0xf66f, 'MOVE BACK ONE'),
        (0xf670, 0xf670, 'TO POSITION IN SEARCH STRING WHERE SEARCHING WILL START'),
        (0xf671, 0xf671, 'POINT Y TO SEARCH POSITION'),
        (0xf673, 0xf673, 'POINT U TO START OF TARGET'),
        (0xf675, 0xf675, 'LOAD ACCB WITH LENGTH OF TARGET'),
        (0xf677, 0xf677, 'LOAD ACCA WITH LENGTH OF SEARCH'),
        (0xf679, 0xf679, 'SUBTRACT SEARCH POSITION FROM SEARCH LENGTH'),
        (0xf67b, 0xf67b, 'ADD ONE'),
        (0xf67c, 0xf67c, 'COMPARE TO TARGET LENGTH'),
        (0xf67e, 0xf67e, "RETURN 0 IF TARGET LENGTH > WHAT'S LEFT OF SEARCH STRING"),
        (0xf680, 0xf680, 'GET A CHARACTER FROM SEARCH STRING'),
        (0xf682, 0xf682, 'COMPARE IT TO TARGET STRING'),
        (0xf684, 0xf684, 'BRANCH IF NO MATCH'),
        (0xf686, 0xf686, 'DECREMENT TARGET LENGTH'),
        (0xf687, 0xf687, 'CHECK ANOTHER CHARACTER'),
        (0xf689, 0xf689, 'GET MATCH POSITION'),
        (0xf68b, 0xf68b, 'SKIP NEXT BYTE'),
        (0xf68c, 0xf68c, 'MATCH ADDRESS = 0'),
        (0xf68d, 0xf68d, 'CLEAN UP THE STACK'),
        (0xf68f, 0xf68f, 'CONVERT ACCB TO FP NUMBER'),
        (0xf692, 0xf692, 'INCREMENT SEARCH POSITION'),
        (0xf694, 0xf694, 'MOVE X TO NEXT SEARCH POSITION'),
        (0xf696, 0xf696, 'KEEP LOOKING FOR A MATCH'),
        (0xf69a, 0xf69a, '* RETURN IF NOT HEX OR OCTAL VARIABLE'),
        (0xf69c, 0xf69c, 'PURGE RETURN ADDRESS FROM STACK'),
        (0xf69e, 0xf69e, '* CLEAR BOTTOM TWO'),
        (0xf6a0, 0xf6a0, '* BYTES OF FPA0'),
        (0xf6a2, 0xf6a2, 'BYTES 2,3 OF FPA0 = (TEMPORARY ACCUMULATOR)'),
        (0xf6a5, 0xf6a5, 'GET A CHARACTER FROM BASIC'),
        (0xf6a9, 0xf6a9, 'YES'),
        (0xf6ad, 0xf6ad, 'YES'),
        (0xf6af, 0xf6af, 'GET CURRENT INPUT CHARACTER'),
        (0xf6b1, 0xf6b1, 'DEFAULT TO OCTAL (&O)'),
        (0xf6b9, 0xf6b9, 'BASE 8 MULTIPLIER'),
        (0xf6bb, 0xf6bb, 'ADD DIGIT TO TEMPORARY ACCUMULATOR'),
        (0xf6bd, 0xf6bd, 'GET A CHARACTER FROM BASIC'),
        (0xf6bf, 0xf6bf, 'BRANCH IF NUMERIC'),
        (0xf6c1, 0xf6c1, '* CLEAR 2 HIGH ORDER'),
        (0xf6c3, 0xf6c3, '* BYTES OF FPA0'),
        (0xf6c5, 0xf6c5, 'SET VARXABLE TYPE TO NUMERIC'),
        (0xf6c7, 0xf6c7, 'ZERO OUT SUB BYTE OF FPA0'),
        (0xf6c9, 0xf6c9, 'ZERO OUT MANTISSA SIGN OF FPA0'),
        (0xf6cb, 0xf6cb, '* SET EXPONENT OF FPA0'),
        (0xf6cf, 0xf6cf, 'GO NORMALIZE FPA0'),
        (0xf6d2, 0xf6d2, 'GET A CHARACTER FROM BASIC'),
        (0xf6d4, 0xf6d4, 'BRANCH IF NUMERIC'),
        (0xf6d6, 0xf6d6, 'SET CARRY IF NOT ALPHA'),
        (0xf6d9, 0xf6d9, 'BRANCH IF NOT ALPHA OR NUMERIC'),
        (0xf6db, 0xf6db, 'CHECK FOR LETTERS A-F'),
        (0xf6dd, 0xf6dd, 'BRANCH IF >= G (ILLEGAL HEX LETTER)'),
        (0xf6df, 0xf6df, 'SUBTRACT ASCII DIFFERENCE BETWEEN A AND 9'),
        (0xf6e1, 0xf6e1, 'BASE 16 DIGIT MULTIPLIER = 2**4'),
        (0xf6e3, 0xf6e3, 'ADD DIGIT TO TEMPORARY ACCUMULATOR'),
        (0xf6e5, 0xf6e5, 'KEEP EVALUATING VARIABLE'),
        (0xf6e7, 0xf6e7, '* MULTIPLY TEMPORARY'),
        (0xf6e9, 0xf6e9, '* ACCUMULATOR BY TWO'),
        (0xf6eb, 0xf6eb, "'OV' OVERFLOW ERROR"),
        (0xf6ef, 0xf6ef, 'DECREMENT SHIFT COUNTER'),
        (0xf6f0, 0xf6f0, 'MULTIPLY TEMPORARY ACCUMULATOR AGAIN'),
        (0xf6f2, 0xf6f2, 'MASK OFF ASCII'),
        (0xf6f4, 0xf6f4, '* ADD DIGIT TO TEMPORARY'),
        (0xf6f6, 0xf6f6, '* ACCUMULATOR AND SAVE IT'),
        (0xf6f9, 0xf6f9, 'PULL RETURN ADDRESS AND SAVE IN U REGISTER'),
        (0xf6fb, 0xf6fb, 'SET VARIABLE TYPE TO NUMERIC'),
        (0xf6fd, 0xf6fd, 'CURRENT INPUT POINTER TO X'),
        (0xf6ff, 0xf6ff, 'GET CHARACTER FROM BASIC'),
        (0xf701, 0xf701, 'HEX AND OCTAL VARIABLES ARE PRECEEDED BY &'),
        (0xf703, 0xf703, "PROCESS A '&' VARIABLE"),
        (0xf705, 0xf705, 'TOKEN FOR FN'),
        (0xf707, 0xf707, 'PROCESS FN CALL'),
        (0xf709, 0xf709, 'CHECK FOR SECONDARY TOKEN'),
        (0xf70b, 0xf70b, 'NOT SECONDARY'),
        (0xf70d, 0xf70d, 'GET CHARACTER FROM BASIC'),
        (0xf70f, 0xf70f, 'TOKEN FOR USR'),
        (0xf711, 0xf711, 'PROCESS USR CALL'),
        (0xf715, 0xf715, "RESTORE BASIC'S INPUT POINTER"),
        (0xf717, 0xf717, 'RETURN TO CALLING ROUTINE'),
        (0xf719, 0xf719, 'GET CURRENT LINE NUMBER'),
        (0xf71b, 0xf71b, 'IN DIRECT MODE?'),
        (0xf71d, 0xf71d, 'RETURN IF NOT IN DIRECT MODE'),
        (0xf71f, 0xf71f, "'ILLEGAL DIRECT STATEMENT' ERROR"),
        (0xf721, 0xf721, 'PROCESS ERROR'),
        (0xf724, 0xf724, 'GET TWO INPUT CHARS'),
        (0xf728, 0xf728, 'TOKEN FOR USR'),
        (0xf72b, 0xf72b, 'BRANCH IF DEF USR'),
        (0xf72f, 0xf72f, 'GET DESCRIPTOR ADDRESS FOR FN VARIABLE NAME'),
        (0xf731, 0xf731, "DON'T ALLOW DEF FN IF IN DIRECT MODE"),
        (0xf733, 0xf733, "SYNTAX CHECK FOR '('"),
        (0xf736, 0xf736, '* GET THE FLAG TO INDICATE ARRAY VARIABLE SEARCH DISABLE'),
        (0xf738, 0xf738, '* AND SAVE IT IN THE ARRAY DISABLE FLAG'),
        (0xf73a, 0xf73a, 'GET VARIABLE DESCRIPTOR'),
        (0xf73d, 0xf73d, "'TM' ERROR IF STRING"),
        (0xf73f, 0xf73f, "SYNTAX CHECK FOR ')'"),
        (0xf742, 0xf742, "TOKEN FOR '='"),
        (0xf744, 0xf744, 'DO A SYNTAX CHECK FOR ='),
        (0xf747, 0xf747, 'GET THE ADDRESS OF THE FN NAME DESCRIPTOR'),
        (0xf749, 0xf749, '* GET THE CURRENT INPUT POINTER ADDRESS AND'),
        (0xf74b, 0xf74b, '* SAVE IT IN FIRST 2 BYTES OF THE DESCRIPTOR'),
        (0xf74d, 0xf74d, '= GET THE DESCRIPTOR ADDRESS OF THE ARGUMENT'),
        (0xf74f, 0xf74f, '= VARIABLE AND SAVE IT IN THE DESCRIPTOR OF THE FN NAME'),
        (0xf751, 0xf751, 'MOVE INPUT POINTER TO END OF LINE OR SUBLINE'),
        (0xf754, 0xf754, 'TOKEN FOR FN'),
        (0xf756, 0xf756, 'DO A SYNTAX CHECK FOR FN'),
        (0xf759, 0xf759, '* GET THE FLAG TO INDICATE ARRAY VARIABLE SEARCH DISABLE FLAG'),
        (0xf75b, 0xf75b, '* AND SAVE IT IN ARRAY VARIABLE FLAG'),
        (0xf75d, 0xf75d, 'SET BIT 7 OF CURRENT INPUT CHARACTER TO INDICATE AN FN VARIABLE'),
        (0xf75f, 0xf75f, '* GET THE DESCRIPTOR ADDRESS OF THIS'),
        (0xf762, 0xf762, '* VARIABLE AND SAVE IT IN V4B'),
        (0xf764, 0xf764, "'TM' ERROR IF STRING VARIABLE"),
        (0xf767, 0xf767, '* GET THE DESCRIPTOR OF THE FN NAME'),
        (0xf769, 0xf769, '* VARIABLE AND SAVE IT ON THE STACK'),
        (0xf76b, 0xf76b, "SYNTAX CHECK FOR '(' & EVALUATE EXPR"),
        (0xf76e, 0xf76e, "'TM' ERROR IF STRING VARIABLE"),
        (0xf770, 0xf770, 'POINT U TO FN NAME DESCRIPTOR'),
        (0xf772, 0xf772, "'UNDEFINED FUNCTION CALL' ERROR"),
        (0xf774, 0xf774, 'POINT X TO ARGUMENT VARIABLE DESCRIPTOR'),
        (0xf776, 0xf776, 'BRANCH TO ERROR HANDLER'),
        (0xf778, 0xf778, 'SAVE CURRENT INPUT POINTER IN Y'),
        (0xf77b, 0xf77b, '* POINT U TO START OF FN FORMULA AND'),
        (0xf77d, 0xf77d, '* SAVE IT IN INPUT POINTER'),
        (0xf77f, 0xf77f, '= GET FP VALUE OF'),
        (0xf781, 0xf781, '= ARGUMENT VARIABLE, CURRENT INPUT'),
        (0xf783, 0xf783, '= POINTER, AND ADDRESS OF START'),
        (0xf785, 0xf785, '= OF FN FORMULA AND SAVE'),
        (0xf787, 0xf787, '= THEM ON THE STACK'),
        (0xf789, 0xf789, 'PACK FPA0 AND SAVE IT IN (X)'),
        (0xf78c, 0xf78c, 'EVALUATE FN EXPRESSION'),
        (0xf78f, 0xf78f, 'RESTORE REGISTERS'),
        (0xf791, 0xf791, '* GET THE FP'),
        (0xf793, 0xf793, '* VALUE OF THE ARGUMENT'),
        (0xf795, 0xf795, '* VARIABLE OFF OF THE'),
        (0xf797, 0xf797, '* STACK AND RE-SAVE IT'),
        (0xf799, 0xf799, 'GET FINAL CHARACTER OF THE FN FORMULA'),
        (0xf79b, 0xf79b, "'SYNTAX' ERROR IF NOT END OF LINE"),
        (0xf79f, 0xf79f, 'RESTORE INPUT POINTER'),
        (0xf7a3, 0xf7a3, 'SKIP PAST SECOND BYTE OF DEF USR TOKEN'),
        (0xf7a5, 0xf7a5, 'GET FN NUMBER'),
        (0xf7a7, 0xf7a7, 'SAVE FN EXEC ADDRESS STORAGE LOC'),
        (0xf7a9, 0xf7a9, 'CALCULATE EXEC ADDRESS'),
        (0xf7ab, 0xf7ab, 'GET FN EXEC ADDRESS STORAGE LOC'),
        (0xf7ad, 0xf7ad, 'SAVE EXEC ADDRESS'),
        (0xf7b0, 0xf7b0, 'DEFAULT TO USR0 IF NO ARGUMENT'),
        (0xf7b1, 0xf7b1, 'GET A CHARACTER FROM BASIC'),
        (0xf7b3, 0xf7b3, 'BRANCH IF NOT NUMERIC'),
        (0xf7b5, 0xf7b5, 'MASK OFF ASCII'),
        (0xf7b7, 0xf7b7, 'SAVE USR NUMBER IN ACCB'),
        (0xf7b9, 0xf7b9, 'GET A CHARACTER FROM BASIC'),
        (0xf7bb, 0xf7bb, 'GET ADDRESS OF STORAGE LOCs FOR USR ADDRESS'),
        (0xf7bd, 0xf7bd, 'X2 - 2 BYTES/USR ADDRESS'),
        (0xf7be, 0xf7be, 'ADD OFFSET TO START ADDRESS OF STORAGE LOCs'),
        (0xf7c0, 0xf7c0, 'GET STORAGE LOC OF EXEC ADDRESS FOR USR N'),
        (0xf7c2, 0xf7c2, '* GET EXEC ADDRESS AND'),
        (0xf7c4, 0xf7c4, '* PUSH IT ONTO STACK'),
        (0xf7c6, 0xf7c6, "SYNTAX CHECK FOR '(' & EVALUATE EXPR"),
        (0xf7c9, 0xf7c9, 'POINT X TO FPA0'),
        (0xf7cc, 0xf7cc, 'GET VARIABLE TYPE'),
        (0xf7ce, 0xf7ce, 'BRANCH IF NUMERIC, STRING IF <> 0'),
        (0xf7d0, 0xf7d0, 'GET LENGTH & ADDRESS OF STRING VARIABLE'),
        (0xf7d3, 0xf7d3, 'GET POINTER TO STRING DESCRIPTOR'),
        (0xf7d5, 0xf7d5, 'GET VARIABLE TYPE'),
        (0xf7d7, 0xf7d7, 'JUMP TO USR ROUTINE (PSHS X ABOVE)'),
        (0xf7d8, 0xf7d8, "TOKEN FOR '='"),
        (0xf7da, 0xf7da, 'DO A SYNTAX CHECK FOR ='),
        (0xf7dd, 0xf7dd, 'EVALUATE EXPRESSION, RETURN VALUE IN X'),
        (0xf7e0, 0xf7e0, "FC' ERROR IF NO ARGUMENT"),
        (0xf7e4, 0xf7e4, 'CONVERT A DECIMAL BASiC NUMBER TO BINARY'),
        (0xf7e7, 0xf7e7, 'FIND RAM ADDRESS OF START OF A BASIC LINE'),
        (0xf7ea, 0xf7ea, 'SAVE RAM ADDRESS OF STARTING LINE NUMBER'),
        (0xf7ec, 0xf7ec, 'GET CURRENT INPUT CHARACTER'),
        (0xf7ee, 0xf7ee, 'BRANCH IF END OF LINE'),
        (0xf7f0, 0xf7f0, "TOKEN FOR '-'"),
        (0xf7f2, 0xf7f2, "TERMINATE COMMAND IF LINE NUMBER NOT FOLLOWED BY '-'"),
        (0xf7f4, 0xf7f4, 'GET A CHARACTER FROM BASIC'),
        (0xf7f6, 0xf7f6, 'IF END OF LINE, USE DEFAULT ENDING LINE NUMBER'),
        (0xf7f8, 0xf7f8, '* CONVERT ENDING LINE NUMBER TO BINARY'),
        (0xf7fa, 0xf7fa, '* AND SAVE IT IN BINVAL'),
        (0xf7fc, 0xf7fc, '= USE $FFXX AS DEFAULT ENDING'),
        (0xf7fe, 0xf7fe, '= LINE NUMBER - SAVE IT IN BINVAL'),
        (0xf800, 0xf800, 'POINT U TO STARTING LINE NUMBER ADDRESS'),
        (0xf802, 0xf802, 'SKIP TWO BYTES'),
        (0xf803, 0xf803, 'POINT U TO START OF NEXT LINE'),
        (0xf805, 0xf805, 'CHECK FOR END OF PROGRAM'),
        (0xf807, 0xf807, 'BRANCH IF END OF PROGRAM'),
        (0xf809, 0xf809, "LOAD ACCD WITH THIS LINE'S NUMBER"),
        (0xf80b, 0xf80b, 'SUBTRACT ENDING LINE NUMBER ADDRESS'),
        (0xf80d, 0xf80d, 'BRANCH IF = < ENDING LINE NUMBER'),
        (0xf80f, 0xf80f, 'GET STARTING LINE NUMBER'),
        (0xf811, 0xf811, 'MOVE (U) TO (X) UNTIL END OF PROGRAM'),
        (0xf813, 0xf813, "RESET BASIC'S INPUT POINTER AND ERASE VARIABLES"),
        (0xf816, 0xf816, 'GET STARTING LINE NUMBER ADDRESS'),
        (0xf818, 0xf818, 'RECOMPUTE START OF NEXT LINE ADDRESSES'),
        (0xf81b, 0xf81b, "JUMP TO BASIC'S MAIN COMMAND LOOP"),
        (0xf81e, 0xf81e, 'GO GET LINE NUMBER CONVERTED TO BINARY'),
        (0xf821, 0xf821, "MAKE SURE THERE'S NO MORE ON THIS LINE"),
        (0xf824, 0xf824, 'GET A BYTE FROM (U)'),
        (0xf826, 0xf826, 'MOVE THE BYTE TO (X)'),
        (0xf828, 0xf828, 'COMPARE TO END OF BASIC'),
        (0xf82b, 0xf82b, 'BRANCH IF NOT AT END'),
        (0xf82d, 0xf82d, 'SAVE (X) AS NEW END OF BASIC'),
        (0xf830, 0xf830, "'BS' ERROR IF IN DIRECT MODE"),
        (0xf833, 0xf833, 'GET A CHAR FROM BASIC'),
        (0xf835, 0xf835, 'CHECK FOR PROMPT STRING'),
        (0xf837, 0xf837, 'BRANCH IF NO PROMPT STRING'),
        (0xf839, 0xf839, 'STRIP OFF PROMPT STRING & PUT IT ON STRING STACK'),
        (0xf83e, 0xf83e, '* DO A SYNTAX CHECK FOR;'),
        (0xf841, 0xf841, 'REMOVE PROMPT STRING FROM STRING STACK & SEND TO CONSOLE OUT'),
        (0xf844, 0xf844, 'RESERVE TWO STORAGE SLOTS ON STACK'),
        (0xf846, 0xf846, 'INPUT A LINE FROM CURRENT INPUT DEVICE'),
        (0xf849, 0xf849, 'CLEAN UP THE STACK'),
        (0xf84b, 0xf84b, 'SEARCH FOR A VARIABLE'),
        (0xf84e, 0xf84e, 'SAVE POINTER TO VARIABLE DESCRIPTOR'),
        (0xf850, 0xf850, "'TM' ERROR IF VARIABLE TYPE = NUMERIC"),
        (0xf853, 0xf853, 'POINT X TO THE STRING BUFFER WHERE THE INPUT STRING WAS STORED'),
        (0xf856, 0xf856, 'TERMINATOR CHARACTER 0 (END OF LINE)'),
        (0xf857, 0xf857, 'PARSE THE INPUT STRING AND STORE IT IN THE STRING SPACE'),
        (0xf85a, 0xf85a, 'REMOVE DESCRIPTOR FROM STRING STACK'),
        (0xf85d, 0xf85d, 'STRIP A DECIMAL NUMBER FROM BASIC INPUT LINE'),
        (0xf860, 0xf860, 'GET BINARY VALUE'),
        (0xf863, 0xf863, 'GET CURRENT OLD NUMBER BEING RENUMBERED'),
        (0xf865, 0xf865, 'SAVE THE LINE NUMBER BEING SEARCHED FOR'),
        (0xf867, 0xf867, 'GO FIND THE LINE NUMBER IN BASIC PROGRAM'),
        (0xf86a, 0xf86a, 'ERASE VARIABLES'),
        (0xf86d, 0xf86d, 'DEFAULT LINE NUMBER INTERVAL'),
        (0xf870, 0xf870, 'SAVE DEFAULT RENUMBER START LINE NUMBER'),
        (0xf872, 0xf872, 'SAVE DEFAULT INTERVAL'),
        (0xf874, 0xf874, 'NOW ACCD = 0'),
        (0xf875, 0xf875, 'DEFAULT LINE NUMBER OF WHERE TO START RENUMBERING'),
        (0xf877, 0xf877, 'GET CURRENT INPUT CHARACTER'),
        (0xf879, 0xf879, 'BRANCH IF NOT NUMERIC'),
        (0xf87b, 0xf87b, 'CONVERT DECIMAL NUMBER IN BASIC PROGRAM TO BINARY'),
        (0xf87d, 0xf87d, 'SAVE LINE NUMBER WHERE RENUMBERING STARTS'),
        (0xf87f, 0xf87f, 'GET CURRENT INPUT CHARACTER'),
        (0xf881, 0xf881, 'BRANCH IF END OF LINE'),
        (0xf883, 0xf883, 'SYNTAX CHECK FOR COMMA'),
        (0xf886, 0xf886, 'BRANCH IF NEXT CHARACTER NOT NUMERIC'),
        (0xf888, 0xf888, 'CONVERT DECIMAL NUMBER IN BASIC PROGRAM TO BINARY'),
        (0xf88a, 0xf88a, 'SAVE NEW RENUMBER LINE'),
        (0xf88c, 0xf88c, 'GET CURRENT INPUT CHARACTER'),
        (0xf88e, 0xf88e, 'BRANCH IF END OF LINE'),
        (0xf890, 0xf890, 'SYNTAX CHECK FOR COMMA'),
        (0xf893, 0xf893, 'BRANCH IF NEXT CHARACTER NOT NUMERIC'),
        (0xf895, 0xf895, 'CONVERT DECIMAL NUMBER IN BASIC PROGRAM TO BINARY'),
        (0xf897, 0xf897, 'SAVE NEW INTERVAL'),
        (0xf899, 0xf899, "'FC' ERROR"),
        (0xf89b, 0xf89b, "CHECK FOR MORE CHARACTERS ON LINE - 'SYNTAX' ERROR IF ANY"),
        (0xf89e, 0xf89e, 'GO GET ADDRESS OF OLD NUMBER BEING RENUMBERED'),
        (0xf8a0, 0xf8a0, 'SAVE ADDRESS'),
        (0xf8a2, 0xf8a2, 'GET NEXT RENUMBERED LINE NUMBER TO USE'),
        (0xf8a4, 0xf8a4, 'FIND THE LINE NUMBER IN THE BASIC PROGRAM'),
        (0xf8a6, 0xf8a6, 'COMPARE TO ADDRESS OF OLD LINE NUMBER'),
        (0xf8a8, 0xf8a8, "'FC' ERROR IF NEW ADDRESS < OLD ADDRESS"),
        (0xf8aa, 0xf8aa, 'MAKE SURE RENUMBERED LINE NUMBERS WILL BE IN RANGE'),
        (0xf8ac, 0xf8ac, "CONVERT ASCII LINE NUMBERS TO 'EXPANDED' BINARY"),
        (0xf8af, 0xf8af, 'RECALCULATE NEXT LINE RAM ADDRESSES'),
        (0xf8b2, 0xf8b2, 'GET RAM ADDRESS OF FIRST LINE TO BE RENUMBERED'),
        (0xf8b4, 0xf8b4, 'SAVE IT'),
        (0xf8b6, 0xf8b6, 'MAKE SURE LINE NUMBERS EXIST'),
        (0xf8b8, 0xf8b8, 'INSERT NEW LINE NUMBERS IN LINE HEADERS'),
        (0xf8ba, 0xf8ba, 'INSERT NEW LINE NUMBERS IN PROGRAM STATEMENTS'),
        (0xf8bc, 0xf8bc, 'CONVERT PACKED BINARY LINE NUMBERS TO ASCII'),
        (0xf8bf, 0xf8bf, 'ERASE VARIABLES'),
        (0xf8c2, 0xf8c2, 'RECALCULATE NEXT LINE RAM ADDRESS'),
        (0xf8c5, 0xf8c5, "GO BACK TO BASIC'S MAIN LOOP"),
        (0xf8c8, 0xf8c8, 'SKIP ONE BYTE - LDA #$4F'),
        (0xf8c9, 0xf8c9, 'NEW LINE NUMBER FLAG - 0; INSERT NEW LINE NUMBERS'),
        (0xf8ca, 0xf8ca, 'SAVE NEW LINE NUMBER FLAG; 0 = INSERT NEW NUMBERS'),
        (0xf8cc, 0xf8cc, 'GET ADDRESS OF OLD LINE NUMBER BEING RENUMBERED'),
        (0xf8ce, 0xf8ce, 'GET THE CURRENT RENUMBERED LINE NUMBER'),
        (0xf8d0, 0xf8d0, 'RETURN IF END OF PROGRAM'),
        (0xf8d2, 0xf8d2, 'CHECK NEW LINE NUMBER FLAG'),
        (0xf8d4, 0xf8d4, 'BRANCH IF NOT INSERTING NEW LINE NUMBERS'),
        (0xf8d6, 0xf8d6, 'STORE THE NEW LINE NUMBER IN THE BASIC PROGRAM'),
        (0xf8d8, 0xf8d8, 'POINT X TO THE NEXT LINE IN BASIC'),
        (0xf8da, 0xf8da, 'RETURN IF END OF PROGRAM'),
        (0xf8dc, 0xf8dc, 'ADD INTERVAL TO CURRENT RENUMBERED LINE NUMBER'),
        (0xf8de, 0xf8de, "'FC' ERROR IF LINE NUMBER > $FFFF"),
        (0xf8e0, 0xf8e0, 'LARGEST LINE NUMBER = $F9FF'),
        (0xf8e2, 0xf8e2, 'BRANCH IF LEGAL LINE NUMBER'),
        (0xf8e4, 0xf8e4, "'FC' ERROR IF LINE NUMBER MS BYTE > $F9"),
        (0xf8e7, 0xf8e7, 'SAVE ACCD'),
        (0xf8e9, 0xf8e9, 'TEST THE 2 BYTES POINTED TO BY X'),
        (0xf8eb, 0xf8eb, 'RESTORE ACCD'),
        (0xf8ed, 0xf8ed, 'BRANCH IF NOT END OF PROGRAM'),
        (0xf8ef, 0xf8ef, 'PURGE RETURN ADDRESS FROM STACK'),
        (0xf8f2, 0xf8f2, 'GET START OF BASIC PROGRAM'),
        (0xf8f4, 0xf8f4, 'MOVE POINTER BACK ONE'),
        (0xf8f6, 0xf8f6, 'MOVE POINTER UP ONE'),
        (0xf8f8, 0xf8f8, 'RETURN IF END OF PROGRAM'),
        (0xf8fa, 0xf8fa, 'SKIP OVER NEXT LINE ADDRESS AND LINE NUMBER'),
        (0xf8fc, 0xf8fc, 'MOVE POINTER TO NEXT CHARACTER'),
        (0xf8fe, 0xf8fe, 'CHECK CURRENT CHARACTER'),
        (0xf900, 0xf900, 'BRANCH IF END OF LINE'),
        (0xf902, 0xf902, 'SAVE CURRENT POINTER'),
        (0xf904, 0xf904, '='),
        (0xf905, 0xf905, '=BRANCH IF START OF PACKED NUMERIC LINE'),
        (0xf908, 0xf908, '*BRANCH IF LINE NUMBER EXISTS'),
        (0xf90a, 0xf90a, '='),
        (0xf90b, 0xf90b, '=MOVE TO NEXT CHARACTER IF > 3'),
        (0xf90d, 0xf90d, '* SET 1ST BYTE = 3 TO INDICATE LINE'),
        (0xf90f, 0xf90f, "* NUMBER DOESN'T CURRENTLY EXIST"),
        (0xf911, 0xf911, 'GO GET ANOTHER CHARACTER'),
        (0xf913, 0xf913, 'GET MS BYTE OF LINE NUMBER'),
        (0xf915, 0xf915, 'DECREMENT ZERO CHECK BYTE'),
        (0xf917, 0xf917, 'BRANCH IF MS BYTE <> 0'),
        (0xf919, 0xf919, 'CLEAR MS BYTE'),
        (0xf91a, 0xf91a, 'GET LS BYTE OF LINE NUMBER'),
        (0xf91c, 0xf91c, 'DECREMENT ZERO CHECK FLAG'),
        (0xf91e, 0xf91e, 'BRANCH IF IS BYTE <> 0'),
        (0xf920, 0xf920, 'CLEAR LS BYTE'),
        (0xf921, 0xf921, 'SAVE BINARY LINE NUMBER'),
        (0xf923, 0xf923, 'SAVE TRIAL LINE NUMBER'),
        (0xf925, 0xf925, 'FIND RAM ADDRESS OF A BASIC LINE NUMBER'),
        (0xf928, 0xf928, 'GET BACK POINTER TO START OF PACKED LINE NUMBER'),
        (0xf92a, 0xf92a, 'BRANCH IF NO LINE NUMBER MATCH FOUND'),
        (0xf92c, 0xf92c, 'GET START ADDRESS OF LINE NUMBER'),
        (0xf92e, 0xf92e, '* SET 1ST BYTE = 2, TO INDICATE LINE NUMBER EXISTS IF CHECKING FOR'),
        (0xf930, 0xf930, 'SAVE RAM ADDRESS OF CORRECT LINE NUMBER'),
        (0xf932, 0xf932, 'GO GET ANOTHER CHARACTER'),
        (0xf934, 0xf934, 'CLEAR CARRY FLAG AND 1ST BYTE'),
        (0xf936, 0xf936, 'POINT X TO RAM ADDRESS OF CORRECT LINE NUMBER'),
        (0xf938, 0xf938, 'PUT CORRECT LINE NUMBER INTO (X)'),
        (0xf93a, 0xf93a, 'SAVE IT TEMPORARILY'),
        (0xf93c, 0xf93c, 'GO INSERT IT INTO BASIC LINE'),
        (0xf93e, 0xf93e, 'GET BEGINNING OF BASIC PROGRAM'),
        (0xf942, 0xf942, '*GET CURRENT INPUT POINTER'),
        (0xf944, 0xf944, '*AND BUMP IT ONE'),
        (0xf946, 0xf946, 'RETURN IF END OF PROGRAM'),
        (0xf948, 0xf948, 'SKIP PAST NEXT LINE ADDRESS'),
        (0xf94a, 0xf94a, 'ADVANCE POINTER BY ONE'),
        (0xf94c, 0xf94c, 'SAVE NEW BASIC INPUT POINTER'),
        (0xf94e, 0xf94e, 'GET NEXT CHARACTER FROM BASIC'),
        (0xf950, 0xf950, 'CHECK THE CHARACTER'),
        (0xf951, 0xf951, 'BRANCH IF END OF LINE'),
        (0xf953, 0xf953, 'BRANCH IF NOT A TOKEN'),
        (0xf955, 0xf955, 'GET CURRENT INPUT POINTER'),
        (0xf957, 0xf957, 'IS THIS A SECONDARY TOKEN?'),
        (0xf959, 0xf959, 'YES - IGNORE IT'),
        (0xf95b, 0xf95b, 'TOKEN FOR THEN?'),
        (0xf95d, 0xf95d, 'YES'),
        (0xf95f, 0xf95f, 'TOKEN FOR ELSE?'),
        (0xf961, 0xf961, 'YES'),
        (0xf963, 0xf963, 'TOKEN FOR GO?'),
        (0xf965, 0xf965, 'NO'),
        (0xf967, 0xf967, 'GET A CHARACTER FROM BASIC'),
        (0xf969, 0xf969, 'TOKEN FOR TO?'),
        (0xf96b, 0xf96b, 'YES'),
        (0xf96d, 0xf96d, 'TOKEN FOR SUB?'),
        (0xf96f, 0xf96f, 'NO'),
        (0xf971, 0xf971, 'GET A CHARACTER FROM BASIC'),
        (0xf973, 0xf973, 'BRANCH IF NUMERIC'),
        (0xf975, 0xf975, 'GET CURRENT BASIC INPUT CHARRACTER'),
        (0xf977, 0xf977, 'KEEP CHECKING THE LINE'),
        (0xf979, 0xf979, 'GET CURRENT INPUT ADDRESS'),
        (0xf97b, 0xf97b, 'SAVE IT ON THE STACK'),
        (0xf97d, 0xf97d, 'CONVERT DECIMAL BASIC NUMBER TO BINARY'),
        (0xf980, 0xf980, 'GET CURRENT INPUT POINTER'),
        (0xf982, 0xf982, 'GET PREVIOUS INPUT CHARACTER'),
        (0xf984, 0xf984, 'CLEAR CARRY IF NUMERIC INPUT VALUE'),
        (0xf987, 0xf987, 'BRANCH IF NON-NUMERIC'),
        (0xf989, 0xf989, 'MOVE POINTER UP ONE'),
        (0xf98b, 0xf98b, 'NOW ACCD POINTS TO ONE PAST END OF LINE NUMBER'),
        (0xf98d, 0xf98d, 'SUBTRACT PRE-NUMERIC POINTER LS BYTE'),
        (0xf98f, 0xf98f, 'MAKE SURE THERE ARE AT LEAST 5 CHARACTERS IN THE NUMERIC LINE'),
        (0xf991, 0xf991, 'BRANCH IF EXACTLY 5'),
        (0xf993, 0xf993, 'BRANCH IF < 5'),
        (0xf995, 0xf995, 'TRANSFER X TO U'),
        (0xf997, 0xf997, 'NEGATE B'),
        (0xf998, 0xf998, 'MOVE X BACK B BYTES'),
        (0xf99a, 0xf99a, '*MOVE BYTES FROM (U) TO (X) UNTIL'),
        (0xf99f, 0xf99f, 'SAVE END OF NUMERIC VALUE'),
        (0xf9a1, 0xf9a1, 'GET END OF BASIC PROGRAM'),
        (0xf9a3, 0xf9a3, 'SAVE IT'),
        (0xf9a5, 0xf9a5, 'NEGATE B'),
        (0xf9a6, 0xf9a6, 'ADD IT TO END OF NUMERIC POiNTER'),
        (0xf9a8, 0xf9a8, 'SAVE POINTER'),
        (0xf9aa, 0xf9aa, 'STORE END OF BASIC PROGRAM'),
        (0xf9ac, 0xf9ac, 'ACCD = TOP OF ARRAYS - CHECK FOR ENOUGH ROOM'),
        (0xf9af, 0xf9af, '* GET AND SAVE THE'),
        (0xf9b1, 0xf9b1, '* NEW CURRENT INPUT POINTER'),
        (0xf9b3, 0xf9b3, 'RESTORE POINTER TO START OF NUMERIC VALUE'),
        (0xf9b5, 0xf9b5, 'NEW LINE NUMBER FLAG'),
        (0xf9b7, 0xf9b7, '* SAVE NEW LINE FLAG'),
        (0xf9bd, 0xf9bd, 'GET MS BYTE OF BINARY LINE NUMBER'),
        (0xf9bf, 0xf9bf, 'BRANCH IF IT IS NOT ZERO'),
        (0xf9c1, 0xf9c1, 'SAVE A 1 IF BYTE IS 0; OTHERWISE, BASIC WILL'),
        (0xf9c3, 0xf9c3, 'IF 2,X = 2, THEN PREVIOUS BYTE WAS A ZERO'),
        (0xf9c5, 0xf9c5, 'SAVE MS BYTE OF BINARY LINE NUMBER'),
        (0xf9c7, 0xf9c7, 'GET IS BYTE OF BINARY LINE NUMBER'),
        (0xf9c9, 0xf9c9, 'BRANCH IF NOT A ZERO BYTE'),
        (0xf9cb, 0xf9cb, 'SAVE A 1 IF BYTE IS A 0'),
        (0xf9cd, 0xf9cd, 'IF 4,X = 2, THEN PREVIOUS BYTE WAS A 0'),
        (0xf9cf, 0xf9cf, 'SAVE LS BYTE OF BINARY LINE NUMBER'),
        (0xf9d1, 0xf9d1, 'GET CURRENT INPUT CHARACTER'),
        (0xf9d3, 0xf9d3, 'IS IT A COMMA?'),
        (0xf9d5, 0xf9d5, 'YES - PROCESS ANOTHER NUMERIC VALUE'),
        (0xf9d7, 0xf9d7, 'NO - GO GET AND PROCESS AN INPUT CHARACTER'),
        (0xf9d9, 0xf9d9, 'POINT X TO START OF BASIC PROGRAM'),
        (0xf9db, 0xf9db, 'MOVE POINTER BACK ONE'),
        (0xf9dd, 0xf9dd, 'MOVE POINTER UP ONE'),
        (0xf9df, 0xf9df, 'GET ADDRESS OF NEXT LINE'),
        (0xf9e1, 0xf9e1, 'SAVE IT IN CURLIN'),
        (0xf9e3, 0xf9e3, 'RETURN IF END OF PROGRAM'),
        (0xf9e6, 0xf9e6, 'SKIP OVER ADDRESS OF NEXT LINE AND 1ST BYTE OF LINE NUMBER'),
        (0xf9e8, 0xf9e8, 'MOVE POINTER UP ONE'),
        (0xf9ea, 0xf9ea, 'GET CURRENT CHARACTER'),
        (0xf9ec, 0xf9ec, 'BRANCH IF END OF LINE'),
        (0xf9ee, 0xf9ee, 'INPUT CHARACTER = 1? - VALID LINE NUMBER'),
        (0xf9ef, 0xf9ef, 'YES'),
        (0xf9f1, 0xf9f1, 'INPUT CHARACTER 3? - UL LINE NUMBER'),
        (0xf9f3, 0xf9f3, 'NO'),
        (0xf9f5, 0xf9f5, 'SAVE CURRENT POSITION OF INPUT POINTER'),
        (0xf9f7, 0xf9f7, "POINT X TO 'UL' MESSAGE"),
        (0xf9fa, 0xf9fa, 'PRINT STRING TO THE SCREEN'),
        (0xf9fd, 0xf9fd, 'GET INPUT POINTER'),
        (0xf9ff, 0xf9ff, 'GET THE UNDEFINED LINE NUMBER'),
        (0xfa01, 0xfa01, 'CONVERT NUMBER IN ACCD TO DECIMAL AND DISPLAY IT'),
        (0xfa04, 0xfa04, "PRINT 'IN XXXX' XXXX = CURRENT LINE NUMBER"),
        (0xfa07, 0xfa07, 'SEND A CR TO CONSOLE OUT'),
        (0xfa0a, 0xfa0a, 'GET INPUT POINTER BACK'),
        (0xfa0c, 0xfa0c, 'SAVE CURRENT POSITION OF INPUT POINTER'),
        (0xfa0e, 0xfa0e, 'LOAD ACCD WITH BINARY VALUE OF LINE NUMBER'),
        (0xfa10, 0xfa10, 'SAVE IN BOTTOM 2 BYTES OF FPA0'),
        (0xfa12, 0xfa12, 'ADJUST REST OF FPA0 AS AN INTEGER'),
        (0xfa15, 0xfa15, 'CONVERT FPA0 TO ASCII, STORE IN LINE NUMBER'),
        (0xfa18, 0xfa18, 'LOAD U WITH PREVIOUS ADDRESS OF INPUT POINTER'),
        (0xfa1a, 0xfa1a, 'EACH EXPANDED LINE NUMBER USES 5 BYTES'),
        (0xfa1c, 0xfa1c, 'MOVE POINTER FORWARD ONE'),
        (0xfa1e, 0xfa1e, 'GET AN ASCII BYTE'),
        (0xfa20, 0xfa20, 'BRANCH IF END OF NUMBER'),
        (0xfa22, 0xfa22, 'DECREMENT BYTE COUNTER'),
        (0xfa23, 0xfa23, 'STORE ASCII NUMBER IN BASIC LINE'),
        (0xfa25, 0xfa25, 'CHECK FOR ANOTHER DIGIT'),
        (0xfa27, 0xfa27, 'TRANSFER NEW LINE POINTER TO (X)'),
        (0xfa29, 0xfa29, 'NEW LINE NUMBER REQUIRE 5 BYTES?'),
        (0xfa2a, 0xfa2a, 'YES - GO GET ANOTHER INPUT CHARACTER'),
        (0xfa2c, 0xfa2c, 'SAVE NEW LINE POINTER IN Y'),
        (0xfa2e, 0xfa2e, 'POINT U TO END OF 5 BYTE PACKED LINE NUMBER BLOCK'),
        (0xfa30, 0xfa30, 'MOVE BYTES FROM (U) TO (X) UNTIL END OF PROGRAM'),
        (0xfa33, 0xfa33, 'LOAD (X) WITH NEW LINE POINTER'),
        (0xfa35, 0xfa35, 'GO GET ANOTHER INPUT CHARACTER'),
        (0xfa37, 0xfa37, 'UNKNOWN LINE NUMBER MESSAGE'),
        (0xfa3b, 0xfa3b, 'CONVERT FPA0 INTO A POSITIVE 2 BYTE INTEGER'),
        (0xfa3e, 0xfa3e, 'POINT TO TEMPORARY BUFFER'),
        (0xfa41, 0xfa41, 'CONVERT 4 NIBBLES'),
        (0xfa43, 0xfa43, 'SAVE NIBBLE COUNTER'),
        (0xfa45, 0xfa45, 'CLEAR CARRY FLAG'),
        (0xfa46, 0xfa46, '4 SHIFTS'),
        (0xfa48, 0xfa48, '* SHIFT BOTTOM TWO BYTES OF'),
        (0xfa4a, 0xfa4a, '* FPA0 LEFT ONE BIT (X2)'),
        (0xfa4c, 0xfa4c, 'IF OVERFLOW, ACCB <> 0'),
        (0xfa4d, 0xfa4d, '* DECREMENT SHIFT COUNTER AND'),
        (0xfa4e, 0xfa4e, '* BRANCH IF NOT DONE'),
        (0xfa50, 0xfa50, 'OVERFLOW'),
        (0xfa51, 0xfa51, 'BRANCH IF OVERFLOW'),
        (0xfa53, 0xfa53, '* GET NIBBLE COUNTER,'),
        (0xfa55, 0xfa55, '* DECREMENT IT AND'),
        (0xfa56, 0xfa56, '* BRANCH IF DONE'),
        (0xfa58, 0xfa58, 'DO NOT DO A CONVERSION UNTIL A NON-ZERO'),
        (0xfa5b, 0xfa5b, 'BYTE IS FOUND - LEADING ZERO SUPPRESSION'),
        (0xfa5d, 0xfa5d, 'ADD IN ASCII ZERO'),
        (0xfa5f, 0xfa5f, 'COMPARE TO ASCII 9'),
        (0xfa61, 0xfa61, 'BRANCH IF < 9'),
        (0xfa63, 0xfa63, 'ADD ASCII OFFSET IF HEX LETTER'),
        (0xfa65, 0xfa65, 'STORE HEX VALUE AND ADVANCE POINTER'),
        (0xfa67, 0xfa67, 'CLEAR NEXT BYTE - END OF STRING FLAG'),
        (0xfa69, 0xfa69, '* GET NIBBLE COUNTER,'),
        (0xfa6b, 0xfa6b, '* DECREMENT IT AND'),
        (0xfa6c, 0xfa6c, '* BRANCH IF NOT DONE'),
        (0xfa6e, 0xfa6e, 'PURGE RETURN ADDRESS OFF OF STACK'),
        (0xfa70, 0xfa70, 'RESET POINTER'),
        (0xfa73, 0xfa73, 'SAVE STRING ON STRING STACK'),
        (0xfa76, 0xfa76, '* SET SPACES'),
        (0xfa78, 0xfa78, '* COUNTER = 1'),
        (0xfa7a, 0xfa7a, 'DECREMENT FORMAT STRING LENGTH COUNTER'),
        (0xfa7b, 0xfa7b, "SEND A '+' TO CONSOLE OUT IF VDA <>0"),
        (0xfa7e, 0xfa7e, 'GET CURRENT INPUT CHARACTER'),
        (0xfa80, 0xfa80, 'EXIT PRINT USING IF END OF LINE'),
        (0xfa84, 0xfa84, 'SAVE REMAINDER FORMAT STRING LENGTH'),
        (0xfa86, 0xfa86, 'EVALUATE EXPRESSION'),
        (0xfa89, 0xfa89, "'TM' ERROR IF NUMERIC VARIABLE"),
        (0xfa8c, 0xfa8c, '* GET ITEM - LIST DESCRIPTOR ADDRESS'),
        (0xfa8e, 0xfa8e, '* AND SAVE IT IN V4D'),
        (0xfa90, 0xfa90, 'GET SPACES COUNTER'),
        (0xfa92, 0xfa92, 'PUT ACCB BYTES INTO STRING SPACE & PUT DESCRIPTOR ON STRING STACK'),
        (0xfa95, 0xfa95, 'PRINT THE FORMATTED STRING TO CONSOLE OUT'),
        (0xfa98, 0xfa98, 'POINT X TO FORMATTED STRING DESCRIPTOR ADDRESS'),
        (0xfa9a, 0xfa9a, 'GET SPACES COUNTER'),
        (0xfa9c, 0xfa9c, 'SUBTRACT LENGTH OF FORMATTED STRING'),
        (0xfa9e, 0xfa9e, 'DECREMENT DIFFERENCE'),
        (0xfa9f, 0xfa9f, 'GO INTERPRET ANOTHER ITEM - LIST'),
        (0xfaa3, 0xfaa3, 'PAD FORMAT STRING WITH A SPACE'),
        (0xfaa6, 0xfaa6, 'KEEP PADDING'),
        (0xfaa8, 0xfaa8, '* SAVE THE CURRENT FORMAT STRING'),
        (0xfaaa, 0xfaaa, '* COUNTER AND POINTER'),
        (0xfaac, 0xfaac, 'INITIAL SPACES COUNTER = 2'),
        (0xfaae, 0xfaae, 'SAVE IN SPACES COUNTER'),
        (0xfab0, 0xfab0, 'GET A CHARACTER FROM FORMAT STRING'),
        (0xfab2, 0xfab2, 'COMPARE TO TERMINATOR CHARACTER'),
        (0xfab4, 0xfab4, 'BRANCH IF END OF SPACES COMMAND'),
        (0xfab6, 0xfab6, 'BLANK'),
        (0xfab8, 0xfab8, 'BRANCH IF ILLEGAL CHARACTER'),
        (0xfaba, 0xfaba, 'ADD ONE TO SPACES COUNTER'),
        (0xfabc, 0xfabc, 'MOVE FORMAT POINTER UP ONE'),
        (0xfabe, 0xfabe, 'DECREMENT LENGTH COUNTER'),
        (0xfabf, 0xfabf, 'BRANCH IF NOT END OF FORMAT STRING'),
        (0xfac1, 0xfac1, '* RESTORE CURRENT FORMAT STRING COUNTER'),
        (0xfac3, 0xfac3, '* AND POINTER TO POSITION BEFORE SPACES COMMAND'),
        (0xfac5, 0xfac5, "SEND A '%' TO CONSOLE OUT AS A DEBUGGING AID"),
        (0xfac7, 0xfac7, "SEND A '+' TO CONSOLE OUT IF VDA <> 0"),
        (0xfaca, 0xfaca, 'SEND CHARACTER TO CONSOLE OUT'),
        (0xfacd, 0xfacd, 'GET NEXT CHARACTER IN FORMAT STRING'),
        (0xfacf, 0xfacf, 'USING TOKEN'),
        (0xfad1, 0xfad1, 'BRANCH IF PRINT USING'),
        (0xfad4, 0xfad4, 'PURGE RETURN ADDRESS OFF THE STACK'),
        (0xfad6, 0xfad6, 'EVALUATE FORMAT STRING'),
        (0xfad9, 0xfad9, "'TM' ERROR IF VARIABLE TYPE = NUMERIC"),
        (0xfadc, 0xfadc, 'CHECK FOR ITEM LIST SEPARATOR'),
        (0xfade, 0xfade, 'SYNTAX CHECK FOR ;'),
        (0xfae1, 0xfae1, '* GET FORMAT STRING DESCRIPTOR ADDRESS'),
        (0xfae3, 0xfae3, '* AND SAVE IT IN VD5'),
        (0xfae5, 0xfae5, 'GO PROCESS FORMAT STRING'),
        (0xfae7, 0xfae7, '*CHECK NEXT PRINT ITEM FLAG AND'),
        (0xfae9, 0xfae9, "*'FC' ERROR IF NO FURTHER PRINT ITEMS"),
        (0xfaeb, 0xfaeb, 'RESET FORMAT STRING POINTER TO START OF STRING'),
        (0xfaed, 0xfaed, 'RESET NEXT PRINT ITEM FLAG'),
        (0xfaef, 0xfaef, 'GET LENGTH OF FORMAT STRING'),
        (0xfaf1, 0xfaf1, 'INTERPRET FORMAT STRING IF LENGTH > 0'),
        (0xfaf3, 0xfaf3, "'FC' ERROR IF FORMAT STRING = NULL"),
        (0xfaf6, 0xfaf6, 'POINT X TO START OF FORMAT STRING'),
        (0xfaf8, 0xfaf8, 'CLEAR THE STATUS BYTE'),
        (0xfafa, 0xfafa, 'CLEAR LEFT DIGIT COUNTER'),
        (0xfafc, 0xfafc, 'GET A CHARACTER FROM FORMAT STRING'),
        (0xfafe, 0xfafe, 'EXCLAMATION POINT?'),
        (0xfb00, 0xfb00, 'YES - STRING TYPE FORMAT'),
        (0xfb04, 0xfb04, 'NUMBER SIGN? (DIGIT LOCATOR)'),
        (0xfb06, 0xfb06, 'YES - NUMERIC TYPE FORMAT'),
        (0xfb08, 0xfb08, 'DECREMENT FORMAT STRING LENGTH'),
        (0xfb09, 0xfb09, 'BRANCH IF NOT DONE'),
        (0xfb0b, 0xfb0b, "SEND A '+' TO CONSOLE OUT IF VDA <> 0"),
        (0xfb0e, 0xfb0e, 'SEND CHARACTER TO CONSOLE OUT'),
        (0xfb11, 0xfb11, 'GET CURRENT CHARACTER FROM BASIC'),
        (0xfb13, 0xfb13, 'BRANCH IF NOT END OF LINE'),
        (0xfb15, 0xfb15, 'GET NEXT PRINT ITEM FLAG'),
        (0xfb17, 0xfb17, 'BRANCH IF MORE PRINT ITEMS'),
        (0xfb19, 0xfb19, 'SEND A CARRIAGE RETURN TO CONSOLE OUT'),
        (0xfb1c, 0xfb1c, 'POINT X TO FORMAT STRING DESCRIPTOR'),
        (0xfb1e, 0xfb1e, 'RETURN ADDRESS AND LENGTH OF FORMAT STRING - EXIT PRINT USING'),
        (0xfb21, 0xfb21, "CHECK FOR '+' (PRE-SIGN FORCE)"),
        (0xfb23, 0xfb23, 'NO PLUS'),
        (0xfb25, 0xfb25, "SEND A '+' TO CONSOLE OUT IF VDA <> 0"),
        (0xfb28, 0xfb28, '* LOAD THE STATUS BYTE WITH 8;'),
        (0xfb2a, 0xfb2a, '* PRE-SIGN FORCE FLAG'),
        (0xfb2c, 0xfb2c, 'INTERPRET THE REST OF THE FORMAT STRING'),
        (0xfb2e, 0xfb2e, 'DECIMAL POINT?'),
        (0xfb30, 0xfb30, 'YES'),
        (0xfb32, 0xfb32, 'PERCENT SIGN?'),
        (0xfb34, 0xfb34, 'YES'),
        (0xfb38, 0xfb38, 'COMPARE THE PRESENT FORMAT STRING INPUT'),
        (0xfb3a, 0xfb3a, 'NO MATCH - ILLEGAL CHARACTER'),
        (0xfb3c, 0xfb3c, 'DOLLAR SIGN?'),
        (0xfb3e, 0xfb3e, 'YES - MAKE THE DOLLAR SIGN FLOAT'),
        (0xfb40, 0xfb40, 'ASTERISK?'),
        (0xfb42, 0xfb42, 'NO - ILLEGAL CHARACTER'),
        (0xfb44, 0xfb44, '* GRAB THE STATUS BYTE AND BET BIT 5'),
        (0xfb46, 0xfb46, '* TO INDICATE THAT THE OUTPUT WILL'),
        (0xfb48, 0xfb48, '* BE LEFT PADDED WITH ASTERISKS'),
        (0xfb4a, 0xfb4a, '* CHECK TO SEE IF THE $$ ARE THE LAST TWO'),
        (0xfb4c, 0xfb4c, '* CHARACTERS IN THE FORMAT STRING AND BRANCH IF SO'),
        (0xfb4e, 0xfb4e, 'GET THE NEXT CHARACTER AFTER **'),
        (0xfb50, 0xfb50, 'CHECK FOR **$'),
        (0xfb52, 0xfb52, 'CHECK FOR MORE CHARACTERS'),
        (0xfb54, 0xfb54, 'DECREMENT STRING LENGTH COUNTER'),
        (0xfb55, 0xfb55, 'MOVE FORMAT STRING POINTER UP ONE'),
        (0xfb57, 0xfb57, 'ADD ONE TO LEFT DIGIT COUNTER - FOR ASTERISK PAD AND'),
        (0xfb59, 0xfb59, '* GET THE STATUS BYTE AND SET'),
        (0xfb5b, 0xfb5b, '* BIT 4 TO INDICATE A'),
        (0xfb5d, 0xfb5d, '* FLOATING DOLLAR SIGN'),
        (0xfb5f, 0xfb5f, 'MOVE FORMAT STRING POINTER UP ONE'),
        (0xfb61, 0xfb61, 'ADD ONE TO LEFT DIGIT (FLOATING $ OR ASTERISK PAD)'),
        (0xfb63, 0xfb63, 'CLEAR THE RIGHT DIGIT COUNTER'),
        (0xfb65, 0xfb65, 'ADD ONE TO LEFT DIGIT COUNTER'),
        (0xfb67, 0xfb67, 'DECREMENT FORMAT STRING LENGTH COUNTER'),
        (0xfb68, 0xfb68, 'BRANCH IF END OF FORMAT STRING'),
        (0xfb6a, 0xfb6a, 'GET THE NEXT FORMAT CHARACTER'),
        (0xfb6c, 0xfb6c, 'DECIMAL POINT?'),
        (0xfb6e, 0xfb6e, 'YES'),
        (0xfb70, 0xfb70, 'NUMBER SIGN?'),
        (0xfb72, 0xfb72, 'YES'),
        (0xfb74, 0xfb74, 'COMMA?'),
        (0xfb76, 0xfb76, 'NO'),
        (0xfb78, 0xfb78, '* GET THE STATUS BYTE'),
        (0xfb7a, 0xfb7a, '* AND SET BIT 6 WHICH IS THE'),
        (0xfb7c, 0xfb7c, '* COMMA SEPARATOR FLAG'),
        (0xfb7e, 0xfb7e, 'PROCESS MORE CHARACTERS TO LEFT OF DECIMAL POINT'),
        (0xfb80, 0xfb80, 'GET NEXT FORMAT CHARACTER'),
        (0xfb82, 0xfb82, 'IS IT A NUMBER SIGN?'),
        (0xfb84, 0xfb84, 'NO'),
        (0xfb88, 0xfb88, '* SET THE RIGHT DIGIT COUNTER TO 1 -'),
        (0xfb8a, 0xfb8a, '* ALLOW ONE SPOT FOR DECIMAL POINT'),
        (0xfb8c, 0xfb8c, 'MOVE FORMAT POINTER UP ONE'),
        (0xfb8e, 0xfb8e, 'ADD ONE TO RIGHT DIGIT COUNTER'),
        (0xfb90, 0xfb90, 'DECREMENT FORMAT LENGTH COUNTER'),
        (0xfb91, 0xfb91, 'BRANCH IF END OF FORMAT STRING'),
        (0xfb93, 0xfb93, 'GET A CHARACTER FROM FORMAT STRING'),
        (0xfb95, 0xfb95, 'IS IT NUMBER SIGN?'),
        (0xfb97, 0xfb97, 'YES - KEEP CHECKING'),
        (0xfb99, 0xfb99, 'CHECK FOR UP ARROW'),
        (0xfb9b, 0xfb9b, 'NO UP ARROW'),
        (0xfb9d, 0xfb9d, 'IS THE NEXT CHARACTER AN UP ARROW?'),
        (0xfb9f, 0xfb9f, 'NO'),
        (0xfba1, 0xfba1, 'AND THE NEXT CHARACTER?'),
        (0xfba3, 0xfba3, 'NO'),
        (0xfba5, 0xfba5, 'HOW ABOUT THE 4TH CHARACTER?'),
        (0xfba7, 0xfba7, 'NO, ALSO'),
        (0xfba9, 0xfba9, '* CHECK TO SEE IF THE 4 UP ARROWS ARE IN THE'),
        (0xfbab, 0xfbab, '* FORMAT STRING AND BRANCH IF NOT'),
        (0xfbad, 0xfbad, '* MOVE POINTER UP 4 AND SUBTRACT'),
        (0xfbaf, 0xfbaf, '* FOUR FROM LENGTH'),
        (0xfbb1, 0xfbb1, 'STATUS BYTE - EXPONENTIAL FORM'),
        (0xfbb3, 0xfbb3, 'MOVE POINTER BACK ONE'),
        (0xfbb5, 0xfbb5, 'ADD ONE TO LEFT DIGIT COUNTER FOR PRE-SIGN FORCE'),
        (0xfbb7, 0xfbb7, '* PRE-SIGN'),
        (0xfbb9, 0xfbb9, '* FORCE AND'),
        (0xfbbb, 0xfbbb, '* BRANCH IF SET'),
        (0xfbbd, 0xfbbd, 'DECREMENT LEFT DIGIT - NO PRE-SIGN FORCE'),
        (0xfbbf, 0xfbbf, 'LENGTH COUNTER AND BRANCH'),
        (0xfbc0, 0xfbc0, '* IF END OF FORMAT STRING'),
        (0xfbc2, 0xfbc2, 'GET NEXT FORMAT STRING CHARACTER'),
        (0xfbc4, 0xfbc4, 'CHECK FOR MINUS SIGN'),
        (0xfbc6, 0xfbc6, 'BRANCH IF MINUS SIGN'),
        (0xfbc8, 0xfbc8, "* WAS CMPA #('+')-('-')"),
        (0xfbca, 0xfbca, 'BRANCH IF NO PLUS SIGN'),
        (0xfbcc, 0xfbcc, 'GET THE PRE-SIGN FORCE FLAG'),
        (0xfbce, 0xfbce, "'OR' IN POST-SIGN FORCE FLAG"),
        (0xfbd0, 0xfbd0, "'OR' IN THE STATUS BYTE"),
        (0xfbd2, 0xfbd2, 'SAVE THE STATUS BYTE'),
        (0xfbd4, 0xfbd4, 'DECREMENT FORMAT STRING LENGTH'),
        (0xfbd5, 0xfbd5, 'GET CURRENT CHARACTER'),
        (0xfbd7, 0xfbd7, 'BRANCH IF END OF LINE'),
        (0xfbdb, 0xfbdb, 'SAVE FORMAT STRING LENGTH WHEN FORMAT EVALUATION ENDED'),
        (0xfbdd, 0xfbdd, 'EVALUATE EXPRESSION'),
        (0xfbe0, 0xfbe0, 'GET THE LEFT DIGIT COUNTER'),
        (0xfbe2, 0xfbe2, 'ADD IT TO THE RIGHT DIGIT COUNTER'),
        (0xfbe6, 0xfbe6, "*'FC' ERROR IF MORE THAN 16 DIGITS AND DECIMAL POiNT"),
        (0xfbea, 0xfbea, 'CONVERT ITEM-LIST TO FORMATTED ASCII STRING'),
        (0xfbed, 0xfbed, 'MOVE BUFFER POINTER BACK ONE'),
        (0xfbef, 0xfbef, 'DISPLAY THE FORMATTED STRING TO CONSOLE OUT'),
        (0xfbf2, 0xfbf2, 'RESET NEXT PRINT ITEM FLAG'),
        (0xfbf4, 0xfbf4, 'GET CURRENT INPUT CHARACTER'),
        (0xfbf6, 0xfbf6, 'BRANCH IF END OF LINE'),
        (0xfbf8, 0xfbf8, 'SAVE CURRENT CHARACTER (<>0) IN NEXT PRINT ITEM FLAG'),
        (0xfbfa, 0xfbfa, '* CHECK FOR ; - ITEM-LIST SEPARATOR AND'),
        (0xfbfc, 0xfbfc, '* BRANCH IF SEMICOLON'),
        (0xfbfe, 0xfbfe, 'SYNTAX CHECK FOR COMMA'),
        (0xfc01, 0xfc01, 'PROCESS NEXT PRINT ITEM'),
        (0xfc03, 0xfc03, 'GET NEXT INPUT CHARACTER'),
        (0xfc05, 0xfc05, 'GET FORMAT STRING DESCRIPTOR ADDRESS'),
        (0xfc07, 0xfc07, 'GET LENGTH OF FORMAT STRING'),
        (0xfc09, 0xfc09, 'SUBTRACT AMOUNT OF FORMAT STRING LEFT AFTER LAST PRINT ITEM'),
        (0xfc0b, 0xfc0b, '*GET FORMAT STRING START ADDRESS AND ADVANCE'),
        (0xfc0d, 0xfc0d, 'TO START OF UNUSED FORMAT STRING'),
        (0xfc0e, 0xfc0e, '* GET AMOUNT OF UNUSED FORMAT STRING'),
        (0xfc10, 0xfc10, '* REINTERPRET FORMAT STRING FROM THAT POINT'),
        (0xfc14, 0xfc14, 'REINTERPRET FORMAT STRING FROM THE START IF ENTIRELY'),
        (0xfc17, 0xfc17, 'RESTORE ACCA AND RETURN'),
        (0xfc19, 0xfc19, 'GET ASCII PLUS SIGN'),
        (0xfc1b, 0xfc1b, '* CHECK THE STATUS BYTE AND'),
        (0xfc1d, 0xfc1d, '* RETURN IF = 0'),
        (0xfc1f, 0xfc1f, 'SEND A CHARACTER TO CONSOLE OUT'),
        (0xfc22, 0xfc22, 'RETURN ACCA AND RETURN'),
        (0xfc24, 0xfc24, 'POINT U TO STRING BUFFER'),
        (0xfc27, 0xfc27, 'BLANK'),
        (0xfc29, 0xfc29, '* GET THE STATUS FLAG AND'),
        (0xfc2b, 0xfc2b, '* CHECK FOR A PRE-SIGN FORCE'),
        (0xfc2d, 0xfc2d, '* BRANCH IF NO PRE-SIGN FORCE'),
        (0xfc2f, 0xfc2f, 'PLUS SIGN'),
        (0xfc31, 0xfc31, 'CHECK THE SIGN OF FPA0'),
        (0xfc33, 0xfc33, 'BRANCH IF POSITIVE'),
        (0xfc35, 0xfc35, 'FORCE FPA0 SIGN TO BE POSITIVE'),
        (0xfc37, 0xfc37, 'MINUS SIGN'),
        (0xfc39, 0xfc39, 'SAVE THE SIGN IN BUFFER'),
        (0xfc3b, 0xfc3b, '* PUT A ZERO INTO THE BUFFER'),
        (0xfc3f, 0xfc3f, '* CHECK THE EXPONENTIAL FORCE FLAG IN'),
        (0xfc41, 0xfc41, '* THE STATUS BYTE - BRANCH IF ACTIVE'),
        (0xfc45, 0xfc45, 'POINT X TO FLOATING POINT 1E + 09'),
        (0xfc48, 0xfc48, 'COMPARE FPA0 TO (X)'),
        (0xfc4b, 0xfc4b, 'BRANCH IF FPA0 < 1E+09'),
        (0xfc4d, 0xfc4d, 'CONVERT FP NUMBER TO ASCII STRING'),
        (0xfc50, 0xfc50, '* ADVANCE POINTER TO END OF'),
        (0xfc52, 0xfc52, '* ASCII STRING (ZERO BYTE)'),
        (0xfc54, 0xfc54, 'MOVE THE'),
        (0xfc56, 0xfc56, 'ENTIRE STRING'),
        (0xfc58, 0xfc58, 'UP ONE'),
        (0xfc5b, 0xfc5b, 'BYTE'),
        (0xfc5d, 0xfc5d, '* INSERT A % SIGN AT START OF'),
        (0xfc5f, 0xfc5f, '* STRING - OVERFLOW ERROR'),
        (0xfc62, 0xfc62, 'GET EXPONENT OF FPA0'),
        (0xfc64, 0xfc64, 'AND SAVE IT IN V74'),
        (0xfc66, 0xfc66, 'BRANCH IF FPA0 = 0'),
        (0xfc68, 0xfc68, 'CONVERT FPA0 TO NUMBER WITH 9 SIGNIFICANT'),
        (0xfc6b, 0xfc6b, 'GET BASE 10 EXPONENT OFFSET'),
        (0xfc6d, 0xfc6d, 'BRANCH IF FPA0 < 100,000,000'),
        (0xfc71, 0xfc71, '* CALCULATE THE NUMBER OF LEADING ZEROES TO INSERT -'),
        (0xfc72, 0xfc72, '* SUBTRACT BASE 10 EXPONENT OFFSET AND 9 (FPA0 HAS'),
        (0xfc74, 0xfc74, '* 9 PLACES TO LEFT OF EXPONENT) FROM LEFT DIGIT COUNTER'),
        (0xfc76, 0xfc76, 'PUT ACCA ZEROES IN STRING BUFFER'),
        (0xfc79, 0xfc79, 'INITIALIZE DECIMAL POINT AND COMMA COUNTERS'),
        (0xfc7c, 0xfc7c, 'CONVERT FPA0 TO DECIMAL ASCII IN THE STRING BUFFER'),
        (0xfc7f, 0xfc7f, '* GET BASE 10 EXPONENT AND PUT THAT MANY'),
        (0xfc81, 0xfc81, '* ZEROES IN STRING BUFFER - STOP AT DECIMAL POINT'),
        (0xfc84, 0xfc84, 'WASTED INSTRUCTION - SERVES NO PURPOSE'),
        (0xfc86, 0xfc86, 'CHECK FOR DECIMAL POINT'),
        (0xfc89, 0xfc89, 'GET THE RIGHT DIGIT COUNTER'),
        (0xfc8b, 0xfc8b, 'BRANCH IF RIGHT DIGlT COUNTER <> 0'),
        (0xfc8d, 0xfc8d, '* MOVE BUFFER POINTER BACK ONE - DELETE'),
        (0xfc8f, 0xfc8f, 'SUBTRACT ONE (DECIMAL POINT)'),
        (0xfc90, 0xfc90, 'PUT ACCA ZEROES INTO BUFFER (TRAILING ZEROES)'),
        (0xfc93, 0xfc93, 'INSERT ASTERISK PADDING, FLOATING $, AND POST-SIGN'),
        (0xfc96, 0xfc96, 'WAS THERE A POST-SIGN?'),
        (0xfc97, 0xfc97, 'NO'),
        (0xfc99, 0xfc99, 'IS THE FIRST CHARACTER AN $?'),
        (0xfc9b, 0xfc9b, 'YES'),
        (0xfc9d, 0xfc9d, 'STORE THE POST-SIGN'),
        (0xfc9f, 0xfc9f, 'CLEAR THE LAST CHARACTER IN THE BUFFER'),
        (0xfca1, 0xfca1, 'POINT X TO THE START OF THE BUFFER'),
        (0xfca4, 0xfca4, 'MOVE BUFFER POINTER UP ONE'),
        (0xfca6, 0xfca6, 'SAVE BUFFER POINTER IN TEMPTR'),
        (0xfca8, 0xfca8, '* GET ADDRESS OF DECIMAL POINT IN BUFFER, SUBTRACT'),
        (0xfcaa, 0xfcaa, '* CURRENT POSITION AND SUBTRACT LEFT DIGIT COUNTER -'),
        (0xfcac, 0xfcac, '* THE RESULT WILL BE ZERO WHEN TEMPTR+1 IS POINTING'),
        (0xfcae, 0xfcae, 'RETURN IF NO DIGITS TO LEFT OF THE DECiMAL POINT'),
        (0xfcb0, 0xfcb0, 'GET THE CURRENT BUFFER CHARACTER'),
        (0xfcb2, 0xfcb2, 'SPACE?'),
        (0xfcb4, 0xfcb4, 'YES - ADVANCE POINTER'),
        (0xfcb6, 0xfcb6, 'ASTERISK?'),
        (0xfcb8, 0xfcb8, 'YES - ADVANCE POINTER'),
        (0xfcba, 0xfcba, 'A ZERO ON THE STACK IS END OF DATA POINTER'),
        (0xfcbb, 0xfcbb, 'PUSH A CHARACTER ONTO THE STACK'),
        (0xfcbd, 0xfcbd, 'GET NEXT CHARACTER FROM BUFFER'),
        (0xfcbf, 0xfcbf, 'MINUS SIGN?'),
        (0xfcc1, 0xfcc1, 'YES'),
        (0xfcc3, 0xfcc3, 'PLUS SIGN?'),
        (0xfcc5, 0xfcc5, 'YES'),
        (0xfcc7, 0xfcc7, 'DOLLAR SIGN?'),
        (0xfcc9, 0xfcc9, 'YES'),
        (0xfccb, 0xfccb, 'ZERO?'),
        (0xfccd, 0xfccd, 'NO - ERROR'),
        (0xfccf, 0xfccf, 'GET CHARACTER FOLLOWING ZERO'),
        (0xfcd1, 0xfcd1, 'CLEAR CARRY IF NUMERIC'),
        (0xfcd3, 0xfcd3, 'BRANCH IF NOT A NUMERIC CHARACTER - ERROR'),
        (0xfcd5, 0xfcd5, '* PULL A CHARACTER OFF OF THE STACK'),
        (0xfcd7, 0xfcd7, '* AND PUT IT BACK IN THE STRING BUFFER'),
        (0xfcd9, 0xfcd9, '* KEEP GOING UNTIL ZERO FLAG'),
        (0xfcdb, 0xfcdb, 'KEEP CLEANING UP THE INPUT BUFFER'),
        (0xfcdf, 0xfcdf, '* THE STACK AND EXIT WHEN'),
        (0xfce0, 0xfce0, '* ZERO FLAG FOUND'),
        (0xfce2, 0xfce2, 'GET THE STRING BUFFER START POINTER'),
        (0xfce4, 0xfce4, '* PUT A % SIGN BEFORE THE ERROR POSITION TO'),
        (0xfce6, 0xfce6, '* INDICATE AN ERROR'),
        (0xfce9, 0xfce9, 'ASCII ZERO'),
        (0xfceb, 0xfceb, 'RETURN IF ACCA < ASCII 0'),
        (0xfced, 0xfced, "*  #'9'+1"),
        (0xfcef, 0xfcef, "* #-('9'+1)  CARRY CLEAR IF NUMERIC"),
        (0xfcf2, 0xfcf2, 'GET RIGHT DIGIT COUNTER'),
        (0xfcf4, 0xfcf4, 'BRANCH IF NO FORMATTED DIGITS TO THE RIGHT OF DECIMAL PT'),
        (0xfcf6, 0xfcf6, 'SUBTRACT ONE FOR DECIMAL POINT'),
        (0xfcf7, 0xfcf7, '*ADD THE BASE 10 EXPONENT OFFSET - ACCA CONTAINS THE'),
        (0xfcf9, 0xfcf9, 'IF ACCA >= 0 THEN NO SHIFTS ARE REQUIRED'),
        (0xfcfb, 0xfcfb, 'FORCE SHIFT COUNTER = 0'),
        (0xfcfc, 0xfcfc, 'SAVE INITIAL SHIFT COUNTER ON THE STACK'),
        (0xfcfe, 0xfcfe, 'EXIT ROUTINE IF POSITIVE'),
        (0xfd00, 0xfd00, 'SAVE SHIFT COUNTER ON STACK'),
        (0xfd02, 0xfd02, 'DIVIDE FPA0 BY 10 - SHIFT ONE DIGIT TO RIGHT'),
        (0xfd05, 0xfd05, 'GET SHIFT COUNTER FROM THE STACK'),
        (0xfd07, 0xfd07, 'BUMP SHIFT COUNTER UP BY ONE'),
        (0xfd08, 0xfd08, 'CHECK FOR FURTHER DIVISION'),
        (0xfd0a, 0xfd0a, '* GET BASE 10 EXPONENT OFFSET, ADD INITIAL SHIFT COUNTER'),
        (0xfd0c, 0xfd0c, '* AND SAVE NEW BASE 10 EXPONENT OFFSET - BECAUSE'),
        (0xfd0e, 0xfd0e, '* FPA0 WAS SHIFTED ABOVE'),
        (0xfd10, 0xfd10, '* ADD NINE (SIGNIFICANT PLACES) AND BRANCH IF THERE ARE NO'),
        (0xfd12, 0xfd12, '* ZEROES TO THE LEFT OF THE DECIMAL POINT IN THIS PRINT ITEM'),
        (0xfd14, 0xfd14, '*DETERMINE HOW MANY FILLER ZEROES TO THE LEFT OF THE DECIMAL'),
        (0xfd16, 0xfd16, '*POINT. GET THE NUMBER OF FORMAT PLACES TO LEFT OF DECIMAL'),
        (0xfd18, 0xfd18, '*POINT, SUBTRACT THE BASE 10 EXPONENT OFFSET AND THE CONSTANT 9'),
        (0xfd1a, 0xfd1a, '*(UNNORMALIZATION)-THEN OUTPUT THAT MANY ZEROES TO THE BUFFER'),
        (0xfd1c, 0xfd1c, 'INITIALIZE DECIMAL POINT AND COMMA COUNTERS'),
        (0xfd1f, 0xfd1f, 'PROCESS THE REMAINDER OF THE PRINT ITEM'),
        (0xfd21, 0xfd21, 'SAVE ZERO COUNTER'),
        (0xfd23, 0xfd23, '* INSERT A ZERO INTO'),
        (0xfd25, 0xfd25, '* THE BUFFER'),
        (0xfd27, 0xfd27, 'RESTORE ZERO COUNTER'),
        (0xfd29, 0xfd29, 'DECREMENT ZERO COUNTER'),
        (0xfd2a, 0xfd2a, 'BRANCH IF NOT DONE'),
        (0xfd2d, 0xfd2d, '* GET THE LEFT DIGIT COUNTER AND PUT'),
        (0xfd2f, 0xfd2f, '* THAT MANY ZEROES IN THE STRiNG BUFFER'),
        (0xfd31, 0xfd31, 'PUT THE DECIMAL POINT IN THE STRING BUFFER'),
        (0xfd34, 0xfd34, '*DETERMINE HOW MANY FILLER ZEROES BETWEEN THE DECIMAL POINT'),
        (0xfd36, 0xfd36, '*AND SIGNIFICANT DATA. SUBTRACT BASE 10 EXPONENT FROM -9'),
        (0xfd38, 0xfd38, '*(UNNORMALIZATION) AND OUTPUT THAT MANY ZEROES TO BUFFER'),
        (0xfd3a, 0xfd3a, 'CLEAR THE DECIMAL POINT COUNTER - SUPPRESS THE DECIMAL POINT'),
        (0xfd3c, 0xfd3c, 'CLEAR THE COMMA COUNTER - SUPPRESS COMMAS'),
        (0xfd3e, 0xfd3e, 'DECODE FPA0 INTO A DECIMAL ASCII STRING'),
        (0xfd41, 0xfd41, 'GET THE RIGHT DIGIT COUNTER'),
        (0xfd43, 0xfd43, 'BRANCH IF RIGHT DIGIT COUNTER <> 0'),
        (0xfd45, 0xfd45, 'RESET BUFFER PTR TO THE DECIMAL POINT IF NO DIGITS TO RIGHT'),
        (0xfd47, 0xfd47, '*ADD BASE 10 EXPONENT - A POSITIVE ACCA WILL CAUSE THAT MANY'),
        (0xfd49, 0xfd49, 'INSERT LEADING ASTERISKS, FLOATING DOLLAR SIGN, ETC'),
        (0xfd4c, 0xfd4c, '* GET EXPONENT OF FPA0 AND'),
        (0xfd4e, 0xfd4e, '* SAVE IT ON THE STACK'),
        (0xfd50, 0xfd50, 'BRANCH IF FPA0 = 0'),
        (0xfd52, 0xfd52, '*CONVERT FPA0 INTO A NUMBER WITH 9 SIGNIFICANT'),
        (0xfd55, 0xfd55, 'GET THE RIGHT DIGIT COUNTER'),
        (0xfd57, 0xfd57, 'BRANCH IF NO FORMATTED DIGITS TO THE RIGHT'),
        (0xfd59, 0xfd59, 'SUBTRACT ONE FOR THE DECIMAL POINT'),
        (0xfd5a, 0xfd5a, 'ADD TO THE LEFT DIGIT COUNTER'),
        (0xfd5c, 0xfd5c, 'CLEAR BUFFER BYTE AS TEMPORARY STORAGE LOCATION'),
        (0xfd5f, 0xfd5f, '* GET THE STATUS BYTE FOR A'),
        (0xfd61, 0xfd61, '* POST-BYTE FORCE; BRANCH IF'),
        (0xfd63, 0xfd63, '* A POST-BYTE FORCE'),
        (0xfd65, 0xfd65, 'TOGGLE BUFFER BYTE TO -1 IF NO POST-BYTE FORCE'),
        (0xfd68, 0xfd68, 'SUBTRACT 1 IF NO POST BYTE FORCE'),
        (0xfd6b, 0xfd6b, '*SUBTRACT 9 (DUE TO THE CONVERSION TO 9'),
        (0xfd6d, 0xfd6d, '* SAVE SHIFT COUNTER ON THE STACK - ACCA CONTAINS THE NUMBER'),
        (0xfd6f, 0xfd6f, 'NO MORE SHIFTS WHEN ACCA >= 0'),
        (0xfd71, 0xfd71, 'SAVE SHIFT COUNTER'),
        (0xfd73, 0xfd73, 'DIVIDE FPA0 BY 10 - SHIFT TO RIGHT ONE'),
        (0xfd76, 0xfd76, 'RESTORE THE SHIFT COUNTER'),
        (0xfd78, 0xfd78, 'ADD 1 TO SHIFT COUNTER'),
        (0xfd79, 0xfd79, 'CHECK FOR FURTHER SHIFTING (DIVISION)'),
        (0xfd7b, 0xfd7b, '*GET THE INITIAL VALUE OF THE SHIFT COUNTER'),
        (0xfd7d, 0xfd7d, '*AND BRANCH IF SHIFTING HAS TAKEN PLACE'),
        (0xfd7f, 0xfd7f, 'RESET ACCA IF NO SHIFTING HAS TAKEN PLACE'),
        (0xfd80, 0xfd80, '*CALCULATE THE POSITION OF THE DECIMAL POINT BY'),
        (0xfd81, 0xfd81, '*NEGATING SHIFT COUNTER, ADDING THE LEFT DIGIT COUNTER'),
        (0xfd83, 0xfd83, '*PLUS ONE AND THE POST-BYTE POSlTION, IF USED'),
        (0xfd87, 0xfd87, 'SAVE DECIMAL POINT COUNTER'),
        (0xfd89, 0xfd89, 'CLEAR COMMA COUNTER - NO COMMAS INSERTED'),
        (0xfd8b, 0xfd8b, 'CONVERT FPA0 INTO ASCII DECIMAL STRING'),
        (0xfd8e, 0xfd8e, '* GET THE INITIAL VALUE OF SHIFT COUNTER AND'),
        (0xfd90, 0xfd90, '* INSERT THAT MANY ZEROES INTO THE BUFFER'),
        (0xfd93, 0xfd93, '*GET THE RIGHT DIGIT COUNTER AND BRANCH'),
        (0xfd95, 0xfd95, '*IF NOT ZERO'),
        (0xfd97, 0xfd97, 'MOVE BUFFER POINTER BACK ONE'),
        (0xfd99, 0xfd99, 'GET ORIGINAL EXPONENT OF FPA0'),
        (0xfd9b, 0xfd9b, 'BRANCH IF EXPONENT = 0'),
        (0xfd9d, 0xfd9d, 'GET BASE 10 EXPONENT'),
        (0xfd9f, 0xfd9f, 'ADD 9 FOR 9 SIGNIFICANT DIGIT CONVERSION'),
        (0xfda1, 0xfda1, 'SUBTRACT LEFT DIGIT COUNTER'),
        (0xfda3, 0xfda3, 'ADD ONE TO EXPONENT IF POST-SIGN FORCE'),
        (0xfda6, 0xfda6, 'PLUS SIGN'),
        (0xfda8, 0xfda8, 'XPONENT'),
        (0xfda9, 0xfda9, 'BRANCH IF POSITIVE EXPONENT'),
        (0xfdab, 0xfdab, 'MINUS SIGN'),
        (0xfdad, 0xfdad, 'CONVERT EXPONENT TO POSITIVE NUMBER'),
        (0xfdae, 0xfdae, 'PUT SIGN OF EXPONENT IN STRING BUFFER'),
        (0xfdb0, 0xfdb0, "* PUT AN 'E' (EXPONENTIATION FLAG) IN"),
        (0xfdb2, 0xfdb2, '* BUFFER AND SKIP OVER THE SIGN'),
        (0xfdb4, 0xfdb4, "* WAS LDA #'0'-1"),
        (0xfdb6, 0xfdb6, 'ADD ONE TO TENS DIGIT COUNTER'),
        (0xfdb7, 0xfdb7, '*SUBTRACT 10 FROM EXPONENT AND ADD ONE TO TENS'),
        (0xfdb9, 0xfdb9, '* DIGIT IF NO CARRY. TENS DIGIT DONE IF THERE IS A CARRY'),
        (0xfdbb, 0xfdbb, "WAS ADDB #'9'+1"),
        (0xfdbd, 0xfdbd, 'SAVE EXPONENT IN BUFFER'),
        (0xfdbf, 0xfdbf, 'CLEAR FINAL BYTE IN BUFFER - PRINT TERMINATOR'),
        (0xfdc1, 0xfdc1, 'INSERT ASTERISK PADDING, FLOATING DOLLAR SIGN, ETC.'),
        (0xfdc4, 0xfdc4, 'POINT X TO START OF PRINT ITEM BUFFER'),
        (0xfdc7, 0xfdc7, '* GET SIGN BYTE OF ITEM-LIST BUFFER'),
        (0xfdc9, 0xfdc9, '* AND SAVE IT ON THE STACK'),
        (0xfdcb, 0xfdcb, 'DEFAULT PAD WITH BLANKS'),
        (0xfdcd, 0xfdcd, '* GET STATUS BYTE AND CHECK FOR'),
        (0xfdcf, 0xfdcf, '* ASTERISK LEFT PADDING'),
        (0xfdd1, 0xfdd1, 'GET SIGN BYTE AGAIN'),
        (0xfdd3, 0xfdd3, 'BRANCH IF NO PADDING'),
        (0xfdd5, 0xfdd5, 'PAD WITH ASTERISK'),
        (0xfdd7, 0xfdd7, 'WAS THE FIRST BYTE A BLANK (POSITIVE)?'),
        (0xfdd9, 0xfdd9, 'NO'),
        (0xfddb, 0xfddb, 'TRANSFER PAD CHARACTER TO ACCB'),
        (0xfddd, 0xfddd, 'SAVE FIRST CHARACTER ON STACK'),
        (0xfddf, 0xfddf, 'STORE PAD CHARACTER IN BUFFER'),
        (0xfde1, 0xfde1, 'GET NEXT CHARACTER IN BUFFER'),
        (0xfde3, 0xfde3, 'INSERT A ZERO IF END OF BUFFER'),
        (0xfde5, 0xfde5, "* CHECK FOR AN 'E' AND"),
        (0xfde7, 0xfde7, '* PUT A ZERO BEFORE IT'),
        (0xfde9, 0xfde9, '* REPLACE LEADING ZEROES WITH'),
        (0xfdeb, 0xfdeb, '* PAD CHARACTERS'),
        (0xfded, 0xfded, '* REPLACE LEADING COMMAS'),
        (0xfdef, 0xfdef, '* WITH PAD CHARACTERS'),
        (0xfdf1, 0xfdf1, '* CHECK FOR DECIMAL POINT'),
        (0xfdf3, 0xfdf3, "* AND DON'T PUT A ZERO BEFORE IT"),
        (0xfdf5, 0xfdf5, '* REPLACE PREVIOUS CHARACTER'),
        (0xfdf7, 0xfdf7, '* WITH A ZERO'),
        (0xfdf9, 0xfdf9, '* GET STATUS BYTE, CHECK'),
        (0xfdfb, 0xfdfb, '* FOR FLOATING $'),
        (0xfdfd, 0xfdfd, '* BRANCH IF NO FLOATING $'),
        (0xfdff, 0xfdff, '* STORE A $ IN'),
        (0xfe01, 0xfe01, '* BUFFER'),
        (0xfe03, 0xfe03, 'CHECK PRE-SIGN FLAG'),
        (0xfe05, 0xfe05, 'GET SIGN CHARACTER'),
        (0xfe07, 0xfe07, 'RETURN IF POST-SIGN REQUIRED'),
        (0xfe09, 0xfe09, 'STORE FIRST CHARACTER'),
        (0xfe0c, 0xfe0c, 'SAVE BUFFER POINTER'),
        (0xfe0e, 0xfe0e, 'INITIAL EXPONENT OFFSET = 0'),
        (0xfe0f, 0xfe0f, 'SAVE EXPONENT OFFSET'),
        (0xfe11, 0xfe11, 'GET EXPONENT OF FPA0'),
        (0xfe13, 0xfe13, '* COMPARE TO EXPONENT OF .5'),
        (0xfe15, 0xfe15, '* AND BRANCH IF FPA0 > = 1.0'),
        (0xfe17, 0xfe17, 'POINT X TO FP NUMBER (1E+09)'),
        (0xfe1a, 0xfe1a, 'MULTIPLY FPA0 BY 1E+09'),
        (0xfe1d, 0xfe1d, 'GET EXPONENT OFFSET'),
        (0xfe1f, 0xfe1f, 'SUBTRACT 9 (BECAUSE WE MULTIPLIED BY 1E+09 ABOVE)'),
        (0xfe21, 0xfe21, 'CHECK TO SEE IF > 1.0'),
        (0xfe23, 0xfe23, 'DIVIDE FPA0 BY 10'),
        (0xfe26, 0xfe26, 'INCREMENT EXPONENT OFFSET'),
        (0xfe28, 0xfe28, 'POINT X TO FP NUMBER (999,999,999)'),
        (0xfe2b, 0xfe2b, 'COMPARE FPA0 TO X'),
        (0xfe2e, 0xfe2e, 'BRANCH IF FPA0 > 999,999,999'),
        (0xfe30, 0xfe30, 'POINT X TO FP NUMBER (99,999,999.9)'),
        (0xfe33, 0xfe33, 'COMPARE FPA0 TO X'),
        (0xfe36, 0xfe36, 'RETURN IF 999,999,999 > FPA0 > 99,999,999.9'),
        (0xfe38, 0xfe38, 'MULTIPLY FPA0 BY 10'),
        (0xfe3b, 0xfe3b, 'DECREMENT EXPONENT OFFSET'),
        (0xfe3d, 0xfe3d, 'KEEP UNNORMALIZING'),
        (0xfe3f, 0xfe3f, 'RESTORE BUFFER POINTER AND RETURN'),
        (0xfe41, 0xfe41, 'SAVE BUFFER POINTER'),
        (0xfe43, 0xfe43, 'ADD .5 TO FPA0 (ROUND OFF)'),
        (0xfe46, 0xfe46, 'CONVERT FPA0 TO INTEGER FORMAT'),
        (0xfe49, 0xfe49, 'RESTORE BUFFER POINTER'),
        (0xfe4b, 0xfe4b, 'POINT X TO UNNORMALIZED POWERS OF 10'),
        (0xfe4e, 0xfe4e, 'INITIALIZE DIGIT COUNTER TO 0 + $80.'),
        (0xfe50, 0xfe50, 'CHECK FOR COMMA INSERTION'),
        (0xfe52, 0xfe52, "* 'ADD' A POWER OF 10 MANTISSA TO FPA0."),
        (0xfe54, 0xfe54, '* IF THE MANTISSA IS NEGATIVE, A SUBTRACTION'),
        (0xfe56, 0xfe56, '* WILL BE WHAT REALLY TAKES PLACE.'),
        (0xfe6a, 0xfe6a, 'ADD ONE TO DIGIT COUNTER'),
        (0xfe6b, 0xfe6b, 'CARRY INTO BIT 7'),
        (0xfe6c, 0xfe6c, '* SET OVERFLOW FLAG - BRANCH IF CARRY SET AND'),
        (0xfe6d, 0xfe6d, '* ADDING MANTISSA OR CARRY CLEAR AND SUBTRACTING MANTISSA'),
        (0xfe6f, 0xfe6f, 'BRANCH IF SUBTRACTING MANTISSA'),
        (0xfe71, 0xfe71, 'WAS SUBB #10+1'),
        (0xfe73, 0xfe73, '* IF ADDING MANTISSA'),
        (0xfe74, 0xfe74, "WAS ADDB #'0'-1"),
        (0xfe76, 0xfe76, 'MOVE TO NEXT POWER OF 10 MANTISSA'),
        (0xfe78, 0xfe78, 'SAVE DIGIT IN ACCA'),
        (0xfe7a, 0xfe7a, 'MASK OFF ADD/SUBTRACT FLAG (BIT 7)'),
        (0xfe7c, 0xfe7c, 'STORE DIGIT IN BUFFER'),
        (0xfe7e, 0xfe7e, 'TOGGLE ADD/SUBTRACT FLAG'),
        (0xfe7f, 0xfe7f, 'MASK OFF EVERYTHING BUT ADD/SUB FLAG'),
        (0xfe81, 0xfe81, 'COMPARE TO END OF UNNORMALIZED POWERS OF 10'),
        (0xfe84, 0xfe84, 'BRANCH IF NOT DONE'),
        (0xfe86, 0xfe86, 'PUT A ZERO AT END OF INTEGER'),
        (0xfe88, 0xfe88, 'DECREMENT DECIMAL POINT COUNTER'),
        (0xfe8a, 0xfe8a, 'NOT TIME FOR DECIMAL POINT'),
        (0xfe8c, 0xfe8c, 'SAVE BUFFER POINTER-POSITION OF THE DECIMAL POINT'),
        (0xfe8e, 0xfe8e, '* STORE A DECIMAL'),
        (0xfe90, 0xfe90, '* POINT IN THE OUTPUT BUFFER'),
        (0xfe92, 0xfe92, '* CLEAR COMMA COUNTER - NOW IT WILL TAKE 255'),
        (0xfe95, 0xfe95, 'DECREMENT COMMA COUNTER'),
        (0xfe97, 0xfe97, 'RETURN IF NOT TIME FOR COMMA'),
        (0xfe99, 0xfe99, '* RESET COMMA COUNTER TO 3; THREE'),
        (0xfe9b, 0xfe9b, '* DIGITS BETWEEN COMMAS'),
        (0xfe9d, 0xfe9d, '* PUT A COMMA INTO'),
        (0xfe9f, 0xfe9f, '* THE BUFFER'),
        (0xfea2, 0xfea2, 'GET THE BASE 10 EXPONENT OFFSET'),
        (0xfea4, 0xfea4, "* ADD 10 (FPA0 WAS 'NORMALIZED' TO 9 PLACES LEFT"),
        (0xfea6, 0xfea6, '* OF DECIMAL POINT) - SAVE IN DECIMAL POINT COUNTER'),
        (0xfea8, 0xfea8, 'ADD ONE FOR THE DECIMAL POINT'),
        (0xfea9, 0xfea9, '* DIVIDE DECIMAL POINT COUNTER BY 3; LEAVE'),
        (0xfeab, 0xfeab, '* THE REMAINDER IN ACCA'),
        (0xfead, 0xfead, 'CONVERT REMAINDER INTO A NUMBER FROM 1-3'),
        (0xfeaf, 0xfeaf, 'SAVE COMMA COUNTER'),
        (0xfeb1, 0xfeb1, 'GET STATUS BYTE'),
        (0xfeb3, 0xfeb3, 'CHECK FOR COMMA FLAG'),
        (0xfeb5, 0xfeb5, 'BRANCH IF COMMA FLAG ACTIVE'),
        (0xfeb7, 0xfeb7, 'CLEAR COMMA COUNTER - 255 DIGITS OUTPUT BEFORE A COMMA'),
        (0xfeba, 0xfeba, 'SAVE ZEROES COUNTER'),
        (0xfebc, 0xfebc, 'CHECK FOR DECIMAL POINT'),
        (0xfebe, 0xfebe, 'RESTORE ZEROES COUNTER'),
        (0xfec0, 0xfec0, '* DECREMENT ZEROES COUNTER AND'),
        (0xfec1, 0xfec1, '* RETURN IF < 0'),
        (0xfec3, 0xfec3, 'SAVE ZEROES COUNTER'),
        (0xfec5, 0xfec5, '* PUT A ZERO INTO'),
        (0xfec7, 0xfec7, '* THE BUFFER'),
        (0xfec9, 0xfec9, 'RESTORE THE ZEROES COUNTER'),
        (0xfecb, 0xfecb, 'BRANCH IF NOT DONE'),
        (0xfece, 0xfece, "'INPUT' TOKEN"),
        (0xfed0, 0xfed0, "GO DO 'LINE INPUT' COMMAND"),
        (0xfed4, 0xfed4, '\'SYNTAX ERROR\' IF NOT "LINE INPUT"'),
        (0xfff0, 0xfff0, 'RESERVED'),
        (0xfff2, 0xfff2, 'SWI3'),
        (0xfff4, 0xfff4, 'SWI2'),
        (0xfff6, 0xfff6, 'FIRQ'),
        (0xfff8, 0xfff8, 'IRQ'),
        (0xfffa, 0xfffa, 'SWI'),
        (0xfffc, 0xfffc, 'NMI'),
        (0xfffe, 0xfffe, 'RESET'),

        # manually inserted:

        (0x0000, 0x7FFF, "32K RAM"),
        (0x8000, 0x9FFF, "FREE SPACE (8K)"),
        (0xA000, 0xBFFF, "SERIAL INTERFACE"),
        (0xC000, 0xFFFF, "16K ROM"),
        (0xDB00, 0xFFFF, "BASIC Interpreter"),

        (0xdb00, 0xdb13, "Console in"),
        (0xdb14, 0xdb39, "Console out"),
        (0xdb3a, 0xdb45, "Wait for serial data"),
        (0xdc3e, 0xdc8a, "ROUTINE THAT GETS AN INPUT LINE FOR BASIC"),
        (0xe0a3, 0xe0b8, "Break check"),
        (0xeb6a, 0xeb6e, "PRINT"),
    )


def print_out(txt):
    print(txt)


def get_simple6809_meminfo():
    return Simple6809MemInfo(log.debug)


if __name__ == "__main__":
    mem_info = Simple6809MemInfo(print_out)

    mem_info(0xa500)  # SERIAL INTERFACE
