"""
    DragonPy - 6809 emulator in Python
    ==================================

    Dragon ROM Downloads from:
    http://archive.worldofdragon.org/archive/index.php?dir=Software/Dragon/Dragon%20Data%20Ltd/Dragon%20Firmware/

    But Dragon 64 ROMs currently wrong, see:
    https://archive.worldofdragon.org/phpBB3/viewtopic.php?f=3&t=10883

    :created: 2015 by Jens Diemer - www.jensdiemer.de
    :copyleft: 2015-2020 by the DragonPy team, see AUTHORS for more details.
    :license: GNU GPL v3 or above, see LICENSE for more details.
"""


from dragonpy.components.rom import ARCHIVE_EXT_ZIP, ROMFile


class Dragon64RomIC17(ROMFile):
    ARCHIVE_EXT = ARCHIVE_EXT_ZIP
    URL = r"https://archive.worldofdragon.org/phpBB3/download/file.php?id=4556"
    DOWNLOAD_SHA1 = "b3e734af642d9bb6f4338352b4347764dab24383"  # downloaded .zip archive
    FILE_COUNT = 1  # How many files are in the archive?
    RENAME_DATA = {"Dragon Data Ltd - Dragon 64 - IC17.ROM": "d64_ic17.rom"}
    SHA1 = "f119506eaa3b4b70b9aa0dd83761e8cbe043d042"  # extracted ROM
    FILENAME = "d64_ic17.rom"


class Dragon64RomIC18(ROMFile):
    ARCHIVE_EXT = ARCHIVE_EXT_ZIP
    URL = r"https://archive.worldofdragon.org/phpBB3/download/file.php?id=4557"
    DOWNLOAD_SHA1 = "bf86bfa57a4cf2a8bec23457b4b6a41d8cc7d597"  # downloaded .zip archive
    RENAME_DATA = {"Dragon Data Ltd - Dragon 64 - IC18.ROM": "d64_ic18.rom"}
    FILE_COUNT = 1  # How many files are in the archive?
    SHA1 = "e3c8986bb1d44269c4587b04f1ca27a70b0aaa2e"  # extracted ROM
    FILENAME = "d64_ic18.rom"
