![GW150914](https://raw.githubusercontent.com/gwastro/pycbc-logo/master/pycbc_logo_name.png)

[PyCBC](http://pycbc.org) is a software package used to explore astrophysical sources of gravitational waves.
It contains algorithms to analyze gravitational-wave data,
detect coalescing compact binaries, and make bayesian inferences from gravitational-wave data.
PyCBC was used in the [first direct detection of gravitational waves](https://journals.aps.org/prl/abstract/10.1103/PhysRevLett.116.061102) and
is used in flagship analyses of LIGO and Virgo data.

PyCBC is collaboratively developed by the community and is lead by a team of GW astronomers with the
aim to build accessible tools for gravitational-wave data analysis.

The PyCBC home page is located on github at

 * https://pycbc.org/

Documentation is automatically built from the latest master version

 * https://pycbc.org/pycbc/latest/html/

For the detailed installation instructions of PyCBC

 * https://pycbc.org/pycbc/latest/html/install.html

Want to get going using PyCBC?

 * [Try out our tutorials](https://github.com/gwastro/PyCBC-Tutorials). No software installation required and these can run entirely from the browser.

Quick Installation
```
pip install pycbc
```

To test the code on your machine
```
pip install pytest "tox<4.0.0"
tox
```

If you use any code from PyCBC in a scientific publication, then please see our [citation guidelines](http://pycbc.org/pycbc/latest/html/credit.html) for more details on how to cite pycbc algorithms and
programs.

For the citation of the ``pycbc library``,  please use a bibtex entry and DOI for the
appropriate release of the PyCBC software (or the latest available release).
A bibtex key and DOI for each release is avaliable from [Zenodo](http://zenodo.org/).

[![DOI](https://zenodo.org/badge/31596861.svg)](https://zenodo.org/badge/latestdoi/31596861) [![Build Status](https://travis-ci.org/gwastro/pycbc.svg?branch=master)](https://travis-ci.org/gwastro/pycbc)
[![PyPI version](https://badge.fury.io/py/PyCBC.svg)](https://badge.fury.io/py/PyCBC) ![PyPI - Downloads](https://img.shields.io/pypi/dm/pycbc) [![Anaconda-Server Badge](https://anaconda.org/conda-forge/pycbc/badges/version.svg)](https://anaconda.org/conda-forge/pycbc) [![Anaconda-Server Badge](https://anaconda.org/conda-forge/pycbc/badges/downloads.svg)](https://anaconda.org/conda-forge/pycbc)
[![astropy](http://img.shields.io/badge/powered%20by-AstroPy-orange.svg?style=flat)](http://www.astropy.org/)
