(self["webpackChunkjupyterlab_visualpython"] = self["webpackChunkjupyterlab_visualpython"] || []).push([["lib_index_js"],{

/***/ "./lib/VpPanel.js":
/*!************************!*\
  !*** ./lib/VpPanel.js ***!
  \************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
	__webpack_require__(/*! @jupyterlab/ui-components */ "webpack/sharing/consume/default/@jupyterlab/ui-components"),
	__webpack_require__(/*! @lumino/widgets */ "webpack/sharing/consume/default/@lumino/widgets"),
	__webpack_require__(/*! ../style/icon.svg */ "./style/icon.svg"),
	__webpack_require__(/*! text */ "./lib/visualpython/lib/require/text.js"), 
	__webpack_require__(/*! css */ "./lib/visualpython/lib/require/css.min.js"), 
	__webpack_require__(/*! jquery */ "webpack/sharing/consume/default/jquery/jquery"), 
	__webpack_require__(/*! jquery-ui */ "webpack/sharing/consume/default/jquery-ui/jquery-ui"), 
	__webpack_require__(/*! jquery-ui-css */ "./lib/visualpython/lib/jquery/jquery-ui.min_org.css"),
	__webpack_require__(/*! codemirror/lib/codemirror */ "./lib/visualpython/lib/codemirror/lib/codemirror.js"), 
	// __VP_CSS_LOADER__('codemirror/lib/codemirror'), // INTEGRATION: unified version of css loader 
	__webpack_require__(/*! vp_base/js/loadVisualpython */ "./lib/visualpython/js/loadVisualpython.js"),
	__webpack_require__(/*! vp_base/js/com/com_Config */ "./lib/visualpython/js/com/com_Config.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(
	{ LabIcon }, { Panel, Widget }, 
	vpIcon, 
	text, css, $, 
	ui, uiCss,
	codemirror, 
	// cmCss, 
	loadVisualpython, com_Config) {

	const { 
		JUPYTER_HEADER_SPACING,
		VP_MIN_WIDTH, 
		MENU_MIN_WIDTH,
		BOARD_MIN_WIDTH,
		MENU_BOARD_SPACING
	} = com_Config;

   	class VpPanel extends Panel {
		/**
		 * Constructor
		 */
		constructor(app) {
			super();

			// codemirror
			__webpack_require__.g.codemirror = codemirror;

			this.app = app;
			this.vpFrame = loadVisualpython.initVisualpython();

			this.id = 'visualpython_vpPanel';
			// LabIcon with svg : @jupyterlab/ui-components/lib/icon/labicon.js
			this.title.icon = new LabIcon({ name: 'visualpython:toggle', svgstr: vpIcon.default });
			this.title.caption = 'Visual Python';
			
			// register node using jquery to element
			this.node = this.vpFrame.renderMainFrame().get(4);
		}

		onResize(msg) {
			super.onResize(msg);
			var { type, width, height } = msg;
			this._resizeVp(width);
			$('#vp_wrapper').css({'left': '', 'height': ''});
		}

		_resizeVp(currentWidth) {
            // calculate inner frame width
            var menuWidth = $('#vp_menuFrame').width();
            var boardWidth = 0;
            var showBoard = $('#vp_boardFrame').is(':visible');
            if (showBoard) {
                boardWidth = currentWidth - menuWidth - MENU_BOARD_SPACING;
                if (boardWidth < BOARD_MIN_WIDTH + MENU_BOARD_SPACING) {
                    boardWidth = BOARD_MIN_WIDTH;
                    menuWidth = currentWidth - (BOARD_MIN_WIDTH + MENU_BOARD_SPACING);
                }
            } else {
                // resize menuWidth if board is hidden
                menuWidth = currentWidth - MENU_BOARD_SPACING;
            }
            $('#vp_menuFrame').width(menuWidth);
            $('#vp_boardFrame').width(boardWidth);

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'resizing wrapper to ', currentWidth, 'with', menuWidth, boardWidth);

            $('#vp_wrapper').width(currentWidth);

            // save current page info
            vpConfig.setMetadata({
                vp_position: { width: currentWidth },
                vp_menu_width: menuWidth,
                vp_note_width: boardWidth
            });
        }

		onBeforeShow() {
			// show #vp_wrapper
			$(this.node).show();
			this.vpFrame.openVp();
			// LAB: FIXME: select which is not toggled to task bar
			// $('.vp-popup-frame').show();
		}

		onAfterHide() {
			// hide #vp_wrapper
			$(this.node).hide();
			// LAB: FIXME: select which is not toggled to task bar
			// hide .vp-popup-frame
			// $('.vp-popup-frame').hide();
		}

		onAfterAttach() {
			this.vpFrame.afterAttach();
		}

		onAfterDetach() {
		}

		onCloseRequest(msg) {
			super.onCloseRequest(msg);
			this.dispose();
		}
    }

    return VpPanel;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/index.js":
/*!**********************!*\
  !*** ./lib/index.js ***!
  \**********************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var __dirname = "/";
const path = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
const $ = __webpack_require__(/*! jquery */ "webpack/sharing/consume/default/jquery/jquery");
__webpack_require__(/*! jquery-ui */ "webpack/sharing/consume/default/jquery-ui/jquery-ui");

__webpack_require__.g.__VP_CSS_LOADER__ = function(path) {
    return path + '.css';
}

__webpack_require__.g.__VP_TEXT_LOADER__ = function(path) {
    return '!!text-loader!' + path;
}

__webpack_require__.g.__VP_RAW_LOADER__ = function(path) {
    return path;
}

__webpack_require__.g.$ = $;
__webpack_require__.g.vpBase = path.resolve(__dirname, "lib") + '/';
module.exports = [{
    id: 'visualpython:entry',
    autoStart: true,
    activate: function (app) {
        console.log(
            'JupyterLab extension visualpython is activated!'
        );
        
        __webpack_require__.g.vpExtType = 'lab';
        __webpack_require__.g.vpLab = app;

        const VpPanel = __webpack_require__(/*! ./VpPanel */ "./lib/VpPanel.js");

        // Add vp to the right area:
        var vpPanel = new VpPanel(app);
        app.shell.add(vpPanel, 'right', { rank: 900, type: 'Visual Python' });
    }
}];

/***/ }),

/***/ "./lib/visualpython/data/m_library/numpyLibrary.js":
/*!*********************************************************!*\
  !*** ./lib/visualpython/data/m_library/numpyLibrary.js ***!
  \*********************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    /**
     * name
     * library
     * description
     * code
     * options: [
     *      {
     *          name
     *          label
     *          [optional]
     *          component : 
     *              - 1darr / 2darr / ndarr / scalar / param / dtype / tabblock
     *          default
     *          required
     *          asParam
     *          code
     *      }
     * ]
     */
    var NUMPY_LIBRARIES = {
        'np_array': {
            name: 'array',
            library: 'numpy',
            description: '',
            code: '${o0} = np.array(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_zeros': {
            name: 'zeros',
            library: 'numpy',
            description: '',
            code: '${o0} = np.zeros(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1dlen', '2dlen', 'ndarr'],
                    componentCode: ['', '(${i0})', '(${i0})'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_ones': {
            name: 'ones',
            library: 'numpy',
            description: '',
            code: '${o0} = np.ones(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1dlen', '2dlen', 'ndarr'],
                    componentCode: ['', '(${i0})', '(${i0})'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_empty': {
            name: 'empty',
            library: 'numpy',
            description: '',
            code: '${o0} = np.empty(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1dlen', '2dlen', 'ndarr'],
                    componentCode: ['', '(${i0})', '(${i0})'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_copy': {
            name: 'copy',
            library: 'numpy',
            description: '',
            code: '${o0} = np.copy(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Parameter Variable',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_arange': {
            name: 'arange',
            library: 'numpy',
            description: '',
            code: '${o0} = np.arange(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    placeholder: '(start, stop, step)',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_concatenate': {
            name: 'concatenate',
            library: 'numpy',
            description: '',
            code: '${o0} = np.concatenate(${i0}${axis}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['ndarr'],
                    componentCode: ['(${i0})'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'axis',
                    label: 'Select Axis',
                    code: ', axis=${axis}',
                    component: ['option_select'],
                    options: [0,1]
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_stack': {
            name: 'stack',
            library: 'numpy',
            description: '',
            code: '${o0} = np.stack((${i0})${axis})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'axis',
                    label: 'Select Axis',
                    code: ', axis=${axis}',
                    component: ['option_select'],
                    options: [0,1]
                }
            ]
        },
        'np_dstack': {
            name: 'dstack',
            library: 'numpy',
            description: '',
            code: '${o0} = np.dstack((${i0}))',
            options: [
                {
                    name: 'i0',
                    label: 'Input Stacking Array',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_hstack': {
            name: 'hstack',
            library: 'numpy',
            description: '',
            code: '${o0} = np.hstack((${i0}))',
            options: [
                {
                    name: 'i0',
                    label: 'Input Stacking Array',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_vstack': {
            name: 'vstack',
            library: 'numpy',
            description: '',
            code: '${o0} = np.vstack((${i0}))',
            options: [
                {
                    name: 'i0',
                    label: 'Input Stacking Array',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_split': {
            name: 'split',
            library: 'numpy',
            description: '',
            code: '${o0} = np.split(${param},(${i0})${axis})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Stacking Array',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'param',
                    label: 'Parameter Variable',
                    placeholder: 'Input Variable',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'axis',
                    label: 'Select Axis',
                    code: ', axis=${axis}',
                    component: ['option_select'],
                    options: [0,1]
                }
            ]
        },
        'np_dsplit': {
            name: 'dsplit',
            library: 'numpy',
            description: '',
            code: '${o0} = np.dsplit(${param},(${i0}))',
            options: [
                {
                    name: 'i0',
                    label: 'Input Stacking Array',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'param',
                    label: 'Parameter Variable',
                    placeholder: 'Input Variable',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_hsplit': {
            name: 'hsplit',
            library: 'numpy',
            description: '',
            code: '${o0} = np.hsplit(${param},(${i0}))',
            options: [
                {
                    name: 'i0',
                    label: 'Input Stacking Array',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'param',
                    label: 'Parameter Variable',
                    placeholder: 'Input Variable',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_vsplit': {
            name: 'vsplit',
            library: 'numpy',
            description: '',
            code: '${o0} = np.vsplit(${param},(${i0}))',
            options: [
                {
                    name: 'i0',
                    label: 'Input Stacking Array',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'param',
                    label: 'Parameter Variable',
                    placeholder: 'Input Variable',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_reshape': {
            name: 'reshape',
            library: 'numpy',
            description: '',
            code: '${o0} = ${i0}.reshape(${param})',
            options: [
                {
                    name: 'param',
                    label: 'Input Parameter',
                    component: ['1dlen', '2dlen', '3dlen'],
                    required: true
                },
                {
                    name: 'i0',
                    label: 'Call Variable',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_transpose': {
            name: 'transpose',
            library: 'numpy',
            description: '',
            code: '${o0} = np.transpose(${param},(${i0}))',
            options: [
                {
                    name: 'param',
                    label: 'Parameter Variable',
                    placeholder: 'Input Variable',
                    required: true
                },
                {
                    name: 'i0',
                    label: 'Input Axis',
                    component: ['ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_T': {
            name: 'T',
            library: 'numpy',
            description: '',
            code: '${o0} = ${i0}.T()',
            options: [
                {
                    name: 'i0',
                    label: 'Call Variable',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_flatten': {
            name: 'flatten',
            library: 'numpy',
            description: '',
            code: '${o0} = ${i0}.flatten()',
            options: [
                {
                    name: 'i0',
                    label: 'Call Variable',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_mean': {
            name: 'mean',
            library: 'numpy',
            description: '',
            code: '${o0} = np.mean(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_var': {
            name: 'var',
            library: 'numpy',
            description: '',
            code: '${o0} = np.var(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_std': {
            name: 'std',
            library: 'numpy',
            description: '',
            code: '${o0} = np.std(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_max': {
            name: 'max',
            library: 'numpy',
            description: '',
            code: '${o0} = np.max(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_min': {
            name: 'min',
            library: 'numpy',
            description: '',
            code: '${o0} = np.min(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_median': {
            name: 'median',
            library: 'numpy',
            description: '',
            code: '${o0} = np.median(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_percentile': {
            name: 'percentile',
            library: 'numpy',
            description: '',
            code: '${o0} = np.percentile(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_linalg_inv': {
            name: 'linalg.inv',
            library: 'numpy',
            description: '',
            code: '${o0} = np.linalg.inv(${i0}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['param', '2darr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_linalg_det': {
            name: 'linalg.det',
            library: 'numpy',
            description: '',
            code: '${o0} = np.linalg.det(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['2darr', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_linalg_eig': {
            name: 'linalg.eig',
            library: 'numpy',
            description: '',
            code: '${o0} = np.linalg.eig(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['2darr', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_linalg_svd': {
            name: 'linalg.svd',
            library: 'numpy',
            description: '',
            code: '${o0} = np.linalg.svd(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['2darr', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_trace': { // FIXME:
            name: 'trace',
            library: 'numpy',
            description: '',
            code: '${o0} = np.trace(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Parameter',
                    component: ['2darr', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                }
            ]
        },
        'np_dot': {
            name: 'dot',
            library: 'numpy',
            description: '',
            code: '${o0} = np.dot(${i0}, ${i1}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'First Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Second Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        'np_add': {
            name: 'add',
            library: 'numpy',
            description: '',
            code: '${o0} = np.add(${i0}, ${i1}${dtype})',
            options: [
                {
                    name: 'i0',
                    label: 'First Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Second Input Parameter',
                    component: ['1darr', '2darr', 'scalar', 'param'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to',
                    placeholder: 'New variable'
                },
                {
                    name: 'dtype',
                    label: 'Select Data Type',
                    code: ', dtype=${dtype}',
                    component: ['dtype']
                }
            ]
        },
        "np_divide": {
            "name": "divide",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.divide(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_floor_divide": {
            "name": "floor_divide",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.floor_divide(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_fmax": {
            "name": "fmax",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.fmax(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_fmin": {
            "name": "fmin",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.fmin(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_maxmimum": {
            "name": "maxmimum",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.maxmimum(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_sum": {
            "name": "sum",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.sum(${i0}${axis})",
            "options": [
                {
                    "name": "i0",
                    "label": "Parameter Variable",
                    "placeholder": "Input variable",
                    "required": true
                },
                {
                    name: 'axis',
                    label: 'Select Axis',
                    code: ', axis=${axis}',
                    component: ['option_select'],
                    options: [0,1]
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        "np_mod": {
            "name": "mod",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.mod(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_multiply": {
            "name": "multiply",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.multiply(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_prod": {
            "name": "prod",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.prod(${i0}${axis})",
            "options": [
                {
                    "name": "i0",
                    "label": "Parameter Variable",
                    "placeholder": "Input variable",
                    "required": true
                },
                {
                    name: 'axis',
                    label: 'Select Axis',
                    code: ', axis=${axis}',
                    component: ['option_select'],
                    options: [0,1]
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        "np_power": {
            "name": "power",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.power(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_subtract": {
            "name": "subtract",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.subtract(${i0}, ${i1}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_abs": {
            "name": "abs",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.abs(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_ceil": {
            "name": "ceil",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.ceil(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_exp": {
            "name": "exp",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.exp(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_fabs": {
            "name": "fabs",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.fabs(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_floor": {
            "name": "floor",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.floor(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_log": {
            "name": "log",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.log(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_log1p": {
            "name": "log1p",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.log1p(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_log2": {
            "name": "log2",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.log2(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_log10": {
            "name": "log10",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.log10(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_modf": {
            "name": "modf",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.modf(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_rint": {
            "name": "rint",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.rint(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_sqrt": {
            "name": "sqrt",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.sqrt(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_square": {
            "name": "square",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.square(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_sin": {
            "name": "sin",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.sin(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_cos": {
            "name": "cos",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.cos(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_tan": {
            "name": "tan",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.tan(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_arcsin": {
            "name": "arcsin",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.arcsin(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_arccos": {
            "name": "arccos",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.arccos(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_arctan": {
            "name": "arctan",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.arctan(${i0}${dtype})",
            "options": [
                {
                    "name": "i0",
                    "label": "Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
        "np_equal": {
            "name": "equal",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.equal(${i0}, ${i1})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        "np_greater": {
            "name": "greater",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.greater(${i0}, ${i1})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        "np_greater_equal": {
            "name": "greater_equal",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.greater_equal(${i0}, ${i1})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        "np_less": {
            "name": "less",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.less(${i0}, ${i1})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        "np_less_equal": {
            "name": "less_equal",
            "library": "numpy",
            "description": "",
            "code": "${o0} = np.less_equal(${i0}, ${i1})",
            "options": [
                {
                    "name": "i0",
                    "label": "First Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "i1",
                    "label": "Second Input Parameter",
                    "component": [
                        "1darr",
                        "2darr",
                        "scalar",
                        "param"
                    ],
                    "required": true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        'np_randint': {
            name: 'randint',
            library: 'numpy',
            description: '',
            code: "${o0} = np.random.randint(${i0})",
            options: [
                {
                    "name": "i0",
                    "label": "Input Number",
                    "placeholder": "Input Number",
                    required: true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                }
            ]
        },
        'np_rand': {
            name: 'rand',
            library: 'numpy',
            description: '',
            code: "${o0} = np.random.rand(${i0}, ${i1}${dtype})",
            options: [
                {
                    "name": "i0",
                    "label": "First Input Number",
                    "placeholder": "Input Number",
                    required: true
                },
                {
                    "name": "i1",
                    "label": "Second Input Number",
                    "placeholder": "Input Number",
                    required: true
                },
                {
                    "name": "o0",
                    "label": "Allocate to",
                    "placeholder": "New variable"
                },
                {
                    "name": "dtype",
                    "label": "Select Data Type",
                    "code": ", dtype=${dtype}",
                    "component": [
                        "dtype"
                    ]
                }
            ]
        },
    };

    return { 
        NUMPY_LIBRARIES: NUMPY_LIBRARIES
    };

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/data/m_library/pandasLibrary.js":
/*!**********************************************************!*\
  !*** ./lib/visualpython/data/m_library/pandasLibrary.js ***!
  \**********************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    // TEST
    /**
     * Replaced with
    '([a-zA-Z0-9_.]*)'[ ]*: (\{[\n\t ]*id:)[ ]*'([a-zA-Z0-9]*)'
    '$3': $2 '$1'
    */
    var PANDAS_FUNCTION = {
        'pdPdo_series': {
            id: 'Series',
            name: 'Series',
            library: 'pandas',
            description: '1 dimension array with same data types',
            code: '${o0} = pd.Series(${i0}${v})',
            input: [
                {
                    name:'i0',
                    type:['var', 'list', 'dict'],
                    label: 'Data'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to',
                    component: 'input_single'
                }
            ],
            variable: [
                {
                    name:'index',
                    type:'list',
                    label: 'Index'
                },
                {
                    name:'name',
                    type:'text',
                    label:'Series Name'
                }
            ]
        },
        'pdPdo_dataframe': {
            id: 'Dataframe',
            name: 'DataFrame',
            library: 'pandas',
            description: '2 dimension data table type pandas variable',
            code: '${o0} = pd.DataFrame(${i0}${v})',
            input: [
                {
                    name:'i0',
                    type:['var', 'list2d', 'dict'],
                    label: 'Data',
                    component: 'table'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'index',
                    type:'list',
                    label:'Index List'
                },
                {
                    name:'columns',
                    type:'list',
                    label:'Column List'
                }
            ]
        },
        'pdPdo_index': {
            id: 'Index',
            name: 'Index',
            library: 'pandas',
            description: 'Create index object',
            code: '${o0} = pd.Index(${data}${v})',
            input: [
                {
                    name: 'data',
                    type: ['list', 'var'],
                    label: 'Data'
                }
            ],
            variable: [
                {
                    name: 'dtype',
                    type: 'var',
                    label: 'Numpy Dtype',
                    component: 'option_select',
                    options: ["'object'", 'None', "'int32'", "'int64'", "'float32'", "'float64'", "'string'", "'complex64'", "'bool'"],
                    default: "'object'"
                },
                {
                    name: 'copy',
                    type: 'bool',
                    label: 'Copy',
                    component: 'bool_checkbox',
                    default: 'False'
                },
                {
                    name: 'name',
                    type: 'var',
                    label: 'Index Name'
                },
                {
                    name: 'tupleize_cols',
                    type: 'bool',
                    label: 'Create Multiindex',
                    default: 'True',
                    component: 'bool_checkbox'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]

        },
        'pd004': {
            id: 'read_csv',
            name: 'Read CSV',
            library: 'pandas',
            description: '',
            code: '${o0} = pd.read_csv(${i0}${v}${etc})',
            input: [
                {
                    name:'i0',
                    type:'text',
                    label: 'File Path',
                    component: 'file'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'encoding',
                    type: 'text',
                    label: 'Encoding'
                },
                {
                    name: 'header',
                    type: 'int',
                    label: 'Header',
                    component: 'option_suggest',
                    options: ['None', '0']
                },
                {
                    name: 'sep',
                    type: 'text',
                    label: 'Seperator'
                },
                {
                    name: 'names',
                    type: 'list',
                    label: 'Columns'
                },
                {
                    name: 'usecols',
                    type: 'list',
                    label: 'Column List To Use'
                },
                {
                    name: 'index_col',
                    type: 'var',
                    label: 'Column To Use As Index'
                },
                {
                    name: 'na_values',
                    type: 'list',
                    label: 'Na Values'
                },
                {
                    name: 'skiprows',
                    type: 'list',
                    label: 'Rows To Skip'
                },
                {
                    name: 'chunksize',
                    type: 'int',
                    label: 'Chunksize'
                }
            ]
        },
        'pd005': {
            id: 'to_csv',
            name: 'To CSV',
            library: 'pandas',
            description: 'dataframe to csv',
            code: '${i0}.to_csv(${i1}${v}${etc})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'DataFrame',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name:'i1',
                    type:'text',
                    label: 'File Path',
                    component: 'file'
                }
            ],
            output: [
            ],
            variable: [
                {
                    name: 'encoding',
                    type: 'text',
                    label: 'Encoding'
                },
                {
                    name: 'header',
                    type: ['bool', 'list'],
                    label: 'Header',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'index',
                    type: 'bool',
                    label: 'Index',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'sep',
                    type: 'text',
                    label: 'Seperator'
                },
                {
                    name: 'na_rep',
                    type: 'text',
                    label: 'Na Replacing Value'
                },
                {
                    name: 'columns',
                    type: 'list',
                    label: 'Columns'
                }
            ]
        },
        'pdFunc_merge': {
            id: 'merge',
            name: 'Merge',
            library: 'pandas',
            description: 'Merge 2 objects',
            code: '${o0} = pd.merge(${i0}, ${i1}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Left Dataframe',
                    component: 'var_select',
                    var_type: ['DataFrame']
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Right Dataframe',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'left_on',
                    type:'text',
                    label: 'Left Key'
                },
                {
                    name:'right_on',
                    type:'text',
                    label: 'Right Key'
                },
                {
                    name:'how',
                    type:'text',
                    label: 'Merge Type',
                    component: 'option_select',
                    options: ['left', 'right', 'inner', 'outer']
                },
                {
                    name:'sort',
                    type:'bool',
                    label: 'Sort'
                }
            ]
        },
        'pd009': {
            id: 'join',
            name: 'Join',
            library: 'pandas',
            description: 'Merge multiple objects',
            code: '${o0} = ${i0}.join(${i1}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Dataframe To Join',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'on',
                    type:'text',
                    label: 'Key'
                },
                {
                    name:'how',
                    type:'text',
                    label: 'Type',
                    component: 'option_select',
                    options: ['left', 'right', 'inner', 'outer']
                },
                {
                    name:'sort',
                    type:'bool',
                    label: 'Sort',
                    component: 'bool_checkbox'
                },
                {
                    name:'lsuffix',
                    type:'text',
                    label: 'Left Suffix'
                },
                {
                    name:'rsuffix',
                    type:'text',
                    label: 'Right Suffix'
                }
            ]
        },
        'pdFunc_concat': {
            id: 'concat',
            name: 'Concat',
            library: 'pandas',
            description: 'Merge multiple objects',
            code: '${o0} = pd.concat([${i0}]${v})',
            guide: [
                's1 = pd.Series([0, 1],    index=["a", "b"])',
                's2 = pd.Series([2, 3, 4], index=["c", "d", "e"])',
                '_concat = pd.concat([s1, s2], keys=["one", "two"], axis=1, sort=False, join="outer")',
                '_concat'
            ],
            input: [
                {
                    name:'i0',
                    type:'list',
                    label: 'Target Variable',
                    component: 'var_multi',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'index',
                    type:'list',
                    label:'Index List'
                },
                {
                    name:'axis',
                    type:'int',
                    label:'Axis',
                    help:'0:row / 1:column',
                    options:[0, 1],
                    options_label:['row', 'column'],
                    component:'option_select'
                },
                {
                    name:'sort',
                    type:'bool',
                    label:'Sort',
                    component: 'bool_checkbox'
                },
                {
                    name:'join',
                    type:'text',
                    label:'Join',
                    options: ['inner', 'outer'],
                    component: 'option_select'
                }
            ]
        },
        'pdSdt_sortByIndex': {
            id: 'sort_index',
            name: 'Sort By Index',
            library: 'pandas',
            description: 'Sort by index',
            code: '${o0} = ${i0}.sort_index(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'axis',
                    type:'int',
                    label: 'Sort By',
                    help: '0:row / 1:column',
                    component: 'option_select',
                    default: 0,
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name:'ascending',
                    type:'bool',
                    label: 'Ascending Sort',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name:'inplace',
                    type:'bool',
                    label: 'Inplace',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'kind',
                    type: 'text',
                    label: 'Sort Kind',
                    default: 'quicksort',
                    component: 'option_select',
                    options: ['quicksort', 'mergesort', 'heapsort'],
                    options_label: ['quicksort', 'mergesort', 'heapsort']
                }
            ]
        },
        'pdGrp_groupby': {
            id: 'groupby',
            name: 'Group By',
            library: 'pandas',
            description: 'Group DataFrame/Series',
            code: '${o0} = ${i0}.groupby(${level}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name:'level',
                    type:['var', 'int', 'text'],
                    label: 'Grouping Column'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'axis',
                    type:'int',
                    label: 'Axis',
                    help: '0:row / 1:column',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name:'sort',
                    type:'bool',
                    label:'Sort',
                    component: 'bool_checkbox'
                }, 
                {
                    name: 'as_index',
                    type: 'bool',
                    label: 'Remove Index',
                    help: 'same as reset_index()',
                    component: 'bool_checkbox',
                    default: 'True'
                }
            ]
        },
        'pdParr_period': {
            id: 'period',
            name: 'Period',
            library: 'pandas',
            description: 'Create Period object',
            code: '${o0} = pd.Period(${i0}${v})',
            input: [
                {
                    name:'i0',
                    type:['int', 'text'],
                    label: 'Date'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'freq',
                    label: 'Frequency',
                    type: 'var',
                    component: 'option_select',
                    options: ['s', 'T', 'H', 'D', 'B', 'W', 'W-MON', 'M'],
                    options_label: ['second', 'minute', 'hour', 'day', 'weekdays', 'week(Sunday)', 'week(Monday)', 'last day of month']
                },
                {
                    index : 1,
                    name: 'year',
                    type: 'int',
                    label: 'Year'
                },
                {
                    index : 2,
                    name: 'month',
                    type: 'int',
                    label: 'Month'                
                },
                {
                    index : 3,
                    name: 'day',
                    type: 'int',
                    label: 'Day'
                }
            ]
        },
        'pdFunc_dropNA': {
            id: 'dropna',
            name: 'Drop NA',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.dropna(${v})',
            guide: [
                'from numpy import nan as NA',
                'data = Series([1, NA, 3.5, NA, 7])',
                'cleaned = data.dropna()'
            ],
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type:'int',
                    label: 'Axis',
                    help: '0:row / 1:column',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'how',
                    type: 'text',
                    label: 'How',
                    help: 'any: drop if na exist more than one\nall: drop if na exist every row/column',
                    component: 'option_select',
                    options: ['any', 'all']
                },
                {
                    name: 'thresh',
                    type: 'int',
                    label: 'Na Minimum Standard',
                }
            ]
        },
        'pdFunc_fillNA': {
            id: 'fillna',
            name: 'Fill NA',
            library: 'pandas',
            description: 'replace null using value',
            code: '${o0} = ${i0}.fillna(${v})',
            guide: [
                'from numpy import nan as NA',
                '',
                'df = pd.DataFrame([[1,2,3,NA],[4,NA,1,2],[0,9,6,7]])',
                'df.fillna({1: 0.5, 3: -1})',
                'df.fillna(0, inplace=True)'
            ],
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'value',
                    type: ['var', 'int', 'dict'],
                    label: 'Value To Fill'
                },
                {
                    name: 'axis',
                    type:'int',
                    label: 'Axis',
                    help: '0:row / 1:column',
                    component: 'option_select',
                    default: 0,
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'method',
                    type: 'var',
                    label: 'How',
                    help: 'ffill:fill with before value\nbfill:fill with after value',
                    component: 'option_select',
                    default: 'None',
                    options: ['None', "'ffill'", "'bfill'"]
                },
                {
                    name: 'inplace',
                    type: 'bool',
                    label: 'Inplace',
                    component: 'bool_checkbox'
                },
                {
                    name: 'limit',
                    type: 'int',
                    label: 'Gap Limit'

                }
            ]
        },
        'pdFunc_isDuplicated': {
            id: 'duplicated',
            name: 'Get Duplicates',
            library: 'pandas',
            description: 'Get duplicates',
            code: '${o0} = ${i0}.duplicated(${v})',
            guide: [
                'data.duplicated()'
            ],
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'keep',
                    type:'var',
                    label: 'Mark Duplicated When',
                    component: 'option_select',
                    default: "'first'",
                    options: ["'first'", "'last'", 'False']
                }
            ]
        },
        'pdFunc_dropDuplicates': {
            id: 'drop_duplicates',
            name: 'Drop Duplicates',
            library: 'pandas',
            description: 'Drop duplicates',
            code: '${o0} = ${i0}.drop_duplicates(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'keep',
                    type:'var',
                    label: 'Mark Duplicated When',
                    component: 'option_select',
                    default: "'first'",
                    options: ["'first'", "'last'", 'False']
                }
            ]
        },
        'pdFunc_replace': {
            id: 'replace_scala',
            name: 'Scala Replace',
            library: 'pandas',
            description: 'Replace scala value',
            code: '${o0} = ${i0}.replace(${v})',
            guide: [
                `s = pd.Series([0, 1, 2, 3, 4])`,
                `s.replace(0, 5)`,
                `df = pd.DataFrame({'A': [0, 1, 2, 3, 4],`,
                `                   'B': [5, 6, 7, 8, 9],`,
                `                   'C': ['a', 'b', 'c', 'd', 'e']})`,
                `df.replace(0, 5)`
            ],
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'to_replace',
                    type:'int',
                    label: 'To Replace',
                    required: true
                },
                {
                    name:'value',
                    type:'int',
                    label: 'Replace Value',
                },
                {
                    name: 'method',
                    type:'var',
                    label: 'Method',
                    options: ["'ffill'", "'bfill'", 'None'],
                    component: 'option_select',
                    default: "'ffill'"
                }
            ]
        },
        'pd019': {
            id: 'replace_list',
            name: 'List-like Replace',
            library: 'pandas',
            description: 'Replace values using list',
            code: '${o0} = ${i0}.replace(${v})',
            guide: [
                `df.replace([0, 1, 2, 3], 4)`,
                `df.replace([0, 1, 2, 3], [4, 3, 2, 1])`,
                `s.replace([1, 2], method='bfill')`
            ],
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'to_replace',
                    type:'list',
                    label: 'To Replace',
                    required: true
                },
                {
                    name:'value',
                    type:['int', 'list'],
                    label: 'Value',
                },
                {
                    name: 'method',
                    type:'var',
                    label: 'Method',
                    options: ["'ffill'", "'bfill'", 'None'],
                    component: 'option_select',
                    default: "'ffill'"
                }
            ]
        },
        'pd020': {
            id: 'replace_dict',
            name: 'Dict-like Replace',
            library: 'pandas',
            description: 'Replace values using dictionary',
            code: '${o0} = ${i0}.replace(${v})',
            guide: [
                `df.replace({0: 10, 1: 100})`,
                `df.replace({'A': 0, 'B': 5}, 100)`,
                `df.replace({'A': {0: 100, 4: 400}})`
            ],
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'to_replace',
                    type:'dict',
                    label: 'To Replace',
                    required: true
                },
                {
                    name:'value',
                    type:['int', 'dict'],
                    label: 'Value',
                },
                {
                    name: 'method',
                    type:'var',
                    label: 'Method',
                    options: ["'ffill'", "'bfill'", 'None'],
                    component: 'option_select',
                    default: "'ffill'"
                }
            ]
        },
        // TODO: PENDING
        'pd021': {
            id: 'replace_regex',
            name: 'Regular Expression Replace',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.replace(${v})',
            guide: [
                `df = pd.DataFrame({'A': ['bat', 'foo', 'bait'],`,
                `                   'B': ['abc', 'bar', 'xyz']})`,
                `df.replace(to_replace=r'^ba.$', value='new', regex=True)`,
                `df.replace({'A': r'^ba.$'}, {'A': 'new'}, regex=True)`,
                `df.replace(regex=r'^ba.$', value='new')`,
                `df.replace(regex={r'^ba.$': 'new', 'foo': 'xyz'})`,
                `df.replace(regex=[r'^ba.$', 'foo'], value='new')`
            ],
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'to_replace',
                    type:'dict',
                    label: 'To Replace',
                    required: true
                },
                {
                    name:'value',
                    type:['text', 'dict'],
                    label: 'Value',
                },
                {
                    name: 'method',
                    type:'var',
                    label: 'Method',
                    options: ["'ffill'", "'bfill'", 'None'],
                    component: 'option_select',
                    default: "'ffill'"
                },
                {
                    name: 'regex',
                    type:'bool',
                    label:'Regex',
                    options: [true, false]
                }
            ]
        },
        'pdGrp_sum': {
            id: 'sum',
            name: 'Sum',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.sum(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na Value',
                    component: 'bool_checkbox',
                    default: 'True'
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level',
                }
            ]
        },
        'pdGrp_mean': {
            id: 'mean',
            name: 'Mean',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.mean(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na Value',
                    component: 'bool_checkbox',
                    default: 'True'
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                }
            ]
        },
        'pdGrp_count': {
            id: 'count',
            name: 'Count',
            library: 'pandas',
            description: 'Count except NA values',
            code: '${o0} = ${i0}.count(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na Value',
                    component: 'bool_checkbox',
                    default: 'True'
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                }
            ]
        },
        'pdGrp_max': {
            id: 'max',
            name: 'Max',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.max(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na Value',
                    component: 'bool_checkbox',
                    default: 'True'
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                }
            ]
        },
        'pdGrp_min': {
            id: 'min',
            name: 'Min',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.min(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na Value',
                    component: 'bool_checkbox',
                    default: 'True'
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                }
            ]
        },
        'pdGrp_median': {
            id: 'median',
            name: 'Median',
            library: 'pandas',
            description: 'Median(50%)',
            code: '${o0} = ${i0}.median(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na Value',
                    component: 'bool_checkbox',
                    default: 'True'

                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'numeric_only',
                    label: 'Numeric Only',
                    var_type: ['DataFrame'],
                    type: 'var',
                    component: 'option_select',
                    default: 'None',
                    options: ['None', "'false'", "'true'"]
                }
            ]
        },
        'pdGrp_std': {
            id: 'std',
            name: 'Std',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.std(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na Value',
                    component: 'bool_checkbox',
                    default: 'True'
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'numeric_only',
                    label: 'Numeric Only',
                    var_type: ['DataFrame'],
                    type: 'var',
                    component: 'option_select',
                    default: 'None',
                    options: ['None', "'false'", "'true'"]
                }
            ]
        },
        'pdGrp_quantile': {
            id: 'quantile',
            name: 'Quantile',
            library: 'pandas',
            description: 'Calculate quantile between 0 and 1',
            code: '${o0} = ${i0}.quantile(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'q',
                    type: ['float', 'list'],
                    label: 'Percentile',
                    placeholder: '(0 ~ 1)',
                    description: '',
                    default: 0.5
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'numeric_only',
                    label: 'Numeric Only',
                    var_type: ['DataFrame'],
                    type: 'var',
                    component: 'option_select',
                    options: ['False', 'True']
                },
                {
                    name: 'interpolation',
                    label: 'Interpolation',
                    type: 'text',
                    component: 'option_select',
                    options: ['linear','lower', 'higher', 'nearest', 'midpoint'],
                    default: 'linear'
                }
            ]
        },
        'pdEdtRC_dropRowCol': {
            id: 'drop',
            name: 'Drop Row/Column',
            library: 'pandas',
            description: 'Drop row and column',
            code: '${o0} = ${i0}.drop(${i1}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name:'i1',
                    type: ['var', 'int', 'text'],
                    label: 'Index',
                    // component: 'var_select',
                    var_type: ['column', 'index'],
                    var_para: ['i0']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'axis',
                    type:'int',
                    label:'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                }
            ]
        },
        'pd031': {
            id: 'date_range',
            name: 'date_range',
            library: 'pandas',
            description: 'Create DatetimeIndex type timestamp',
            code: '${o0} = pd.date_range(${v})',
            input: [
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'start',
                    label: 'Start Date',
                    placeholder: 'yyyy-MM-dd',
                    type: 'text'
                },
                {
                    name: 'end',
                    label: 'End Date',
                    placeholder: 'yyyy-MM-dd',
                    type: 'text'
                },
                {
                    name: 'periods',
                    type: 'int',
                    label: 'Periods',
                    help: 'input number of date index to create'
                },
                {
                    name: 'freq',
                    label: 'Frequency',
                    type: 'text',
                    component: 'option_select',
                    options: ['s', 'T', 'H', 'D', 'B', 'W', 'W-MON', 'MS', 'M', 'BMS', 'BM'],
                    options_label: ['second', 'minute', 'hour', 'day', 'weekdays', 'week(Sunday)', 'week(Monday)', 
                        'first day of month', 'last day of month', 'first weekday of month', 'last weekday of month']
                }
            ]
        },
        'pdSdt_sortByValues': {
            id: 'sort_values',
            name: 'Sort By Values',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.sort_values(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'by',
                    type: ['list', 'text'],
                    label: 'Sort By',
                    required: true
                },
                {
                    name:'axis',
                    type:'int',
                    label: 'Axis',
                    help: '0:Row / 1:Column',
                    component: 'option_select',
                    default: 0,
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name:'ascending',
                    type:'bool',
                    label: 'Ascending',
                    component: 'bool_checkbox',
                    default: 'True'
                },
                {
                    name:'inplace',
                    type:'bool',
                    label: 'Inplace',
                    component: 'bool_checkbox',
                    default: 'False'
                },
                {
                    name: 'kind',
                    type: 'text',
                    label: 'Sort Type',
                    component: 'option_select',
                    default: 'quicksort',
                    options: ['quicksort', 'mergesort', 'heapsort']
                }
            ]
        },
        'pdFunc_isNull': {
            id: 'isnull',
            name: 'Is Null',
            library: 'pandas',
            description: 'Find null',
            code: '${o0} = pd.isnull(${i0})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
            ]
        },
        'pdFunc_notNull': {
            id: 'notnull',
            name: 'Not Null',
            library: 'pandas',
            description: 'Find not null',
            code: '${o0} = pd.notnull(${i0})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
            ]
        },
        'pdIdt_transpose': {
            id: '.T',
            name: 'Transpose',
            library: 'pandas',
            description: 'Transpose row and column',
            code: '${o0} = ${i0}.T',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_columns': {
            id: '.columns',
            name: 'Get columns',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.columns',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_index': {
            id: '.index',
            name: 'Get index',
            library: 'pandas',
            description: 'Get index',
            code: '${o0} = ${i0}.index',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_values': {
            id: '.values',
            name: 'Values',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.values',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd039': {
            id: '.name',
            name: 'name',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.name',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd040': {
            id: 'loc',
            name: 'Loc',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.loc[${i1}]',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'i1',
                    type: ['text', 'list'],
                    label: 'Row/Column Name To Find'
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd041': {
            id: 'iloc',
            name: 'iLoc',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.iloc[${i1}]',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'i1',
                    type: ['text', 'list'],
                    label: 'row/column to count'
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd042': {
            id: '.array',
            name: 'array',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.array',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd043': {
            id: '.axes',
            name: 'axes',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.axes',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd044': {
            id: '.hasnans',
            name: 'hasnans',
            library: 'pandas',
            description: 'Check if it has NaN values',
            code: '${o0} = ${i0}.hasnans',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd045': {
            id: '.shape',
            name: 'shape',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.shape',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd046': {
            id: '.dtype',
            name: 'dtype',
            library: 'pandas',
            description: 'Check data type of Index',
            code: '${o0} = ${i0}.dtype',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_len': {
            id: 'len',
            name: 'Length',
            library: 'pandas',
            description: '',
            code: '${o0} = len(${i0})',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_unique': {
            id: 'unique',
            name: 'Unique',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.unique()',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_valueCounts': {
            id: 'value_counts',
            name: 'get data counts',
            library: 'pandas',
            description: 'get data value counts',
            code: '${o0} = ${i0}.value_counts()',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    // component: 'var_select',
                    // var_type: ['DataFrame', 'Series', 'Index']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_info': {
            id: 'info',
            name: 'Info',
            library: 'pandas',
            description: 'DataFrame info(info per columns, data type, memory usage, ...)',
            code: '${o0} = ${i0}.info()',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_describe': {
            id: 'describe',
            name: 'Describe',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.describe()',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd052': {
            id: 'add',
            name: 'Add',
            library: 'pandas',
            description: 'DataFrame/Series addition',
            code: '${o0} = ${i0}.add(${i1}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name:'i1',
                    type:['var', 'int'],
                    label: 'Adding Object',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['Row(index)', 'Col(columns)']
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'fill_value',
                    type: 'float',
                    label: 'Fill Value'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd053': {
            id: 'sub',
            name: 'Subtract',
            library: 'pandas',
            description: 'DataFrame/Series subtraction',
            code: '${o0} = ${i0}.sub(${i1}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name:'i1',
                    type:['var', 'int'],
                    label: 'Subtracting Object',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['Index', 'Columns']
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'fill_value',
                    type: 'float',
                    label: 'Fill Value'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd054': {
            id: 'div',
            name: 'Divide',
            library: 'pandas',
            description: 'DataFrame/Series division',
            code: '${o0} = ${i0}.div(${i1}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name:'i1',
                    type:['var', 'int'],
                    label: 'Dividing Object',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['Index', 'Columns']
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'fill_value',
                    type: 'float',
                    label: 'Fill Value'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd055': {
            id: 'mul',
            name: 'Multiply',
            library: 'pandas',
            description: 'DataFrame/Series multipy',
            code: '${o0} = ${i0}.mul(${i1}${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name:'i1',
                    type:['var', 'int'],
                    label: 'DataFrame/Series',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['Index', 'Columns']
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'fill_value',
                    type: 'float',
                    label: 'Fill Value'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdEdtRC_insertColumn': {
            id: 'insert_column',
            name: 'Insert Column',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.insert(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            variable: [
                {
                    name: 'loc',
                    type: 'int',
                    label: 'Location',
                    required: true
                },
                {
                    name: 'column',
                    type: ['int', 'text', 'var', 'dict'],
                    label: 'Column Name',
                    required: true
                },
                {
                    name: 'value',
                    type: ['int', 'var', 'list'],
                    label: 'Value',
                    required: true
                },
                {
                    name: 'allow_duplicates',
                    label: 'Allow Duplicates',
                    type: 'bool',
                    default: 'False',
                    component: 'bool_checkbox'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd057': {
            id: 'insert_column_value',
            name: 'Insert Column Value',
            library: 'pandas',
            description: '',
            code: '${i0}[${i1}] = ${i2}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                },
                {
                    name:'i1',
                    type:'text',
                    label: 'Column Name',
                    var_type: ['columns']
                },
                {
                    name:'i2',
                    type: ['var', 'int', 'text', 'list'],
                    label: 'Value'
                }
            ],
            variable: [],
            output: []
        },
        'pdEdtRC_insertRow': {
            id: 'insert_row_loc',
            name: 'Insert Row Value',
            library: 'pandas',
            description: '',
            code: '${i0}.loc[${i1}] = ${i2}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                },
                {
                    name:'i1',
                    type:['int', 'text'],
                    label: 'Row Name/Index',
                    var_type: ['index']
                },
                {
                    name:'i2',
                    type: ['var', 'int', 'text', 'list'],
                    label: 'Value'
                }
            ],
            variable: [],
            output: []
        },
        'pdGrp_groups': {
            id: '.groups',
            name: 'Groups',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.groups',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'GroupBy Object',
                    component: 'var_select',
                    var_type: ['GroupBy']
                }
            ],
            variable: [],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdFunc_reindex': {
            id: 'reindex',
            name: 'Reindex',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.reindex(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                }
            ],
            variable: [
                {
                    name: 'labels',
                    type: 'list',
                    label: 'New Labels'
                },
                {
                    name: 'index',
                    type: 'list',
                    label: 'New Indexes'
                },
                {
                    name: 'columns',
                    type: 'list',
                    label: 'New Columns'
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    component: 'option_select'
                },
                {
                    name: 'method',
                    type: 'text',
                    label: 'Method',
                    help: 'ffill:fill with front value\nbfill:fill with back value',
                    component: 'option_select',
                    options: ['ffill', 'bfill', 'nearest']
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdFunc_setIndex': {
            id: 'set_index',
            name: 'Set Index Values',
            library: 'pandas',
            description: 'create index using column',
            code: '${o0} = ${i0}.set_index(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            variable: [
                {
                    name: 'keys',
                    type: ['text', 'list'],
                    label: 'Keys',
                    required: true
                },
                {
                    name: 'drop',
                    type: 'bool',
                    label: 'Drop',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'append',
                    type: 'bool',
                    label: 'Append',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'inplace',
                    type: 'bool',
                    label: 'Inplace',
                    default: 'False',
                    component: 'bool_checkbox'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdFunc_resetIndex': {
            id: 'reset_index',
            name: 'Reset Index Values',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.reset_index(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [
                {
                    name: 'level',
                    type: ['int', 'text', 'list'],
                    label: 'Level',
                    default: 'None'
                },
                {
                    name: 'drop',
                    type: 'bool',
                    label: 'Drop',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'inplace',
                    type: 'bool',
                    label: 'Inplace',
                    default: 'False',
                    component: 'bool_checkbox'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd063': {
            id: 'edit_row_data',
            name: 'Edit Row Data',
            library: 'pandas',
            description: '',
            code: '${i0}[${i1}] = ${i2}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'i1',
                    type: 'var',
                    label: 'Column Name',
                },
                {
                    name: 'i2',
                    type: ['var', 'list', 'text', 'int'],
                    label: 'Value'
                }
            ],
            variable: [],
            output: []  
        },
        'pdIdt_head': {
            id: 'head',
            name: 'Head',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.head(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [
                {
                    name: 'n',
                    type: 'int',
                    label: 'Count',
                    default: 5
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_tail': {
            id: 'tail',
            name: 'Tail',
            library: 'pandas',
            description : '',
            code: '${o0} = ${i0}.tail(${v})',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            variable: [
                {
                    name: 'n',
                    type: 'int',
                    label: 'Count',
                    default: 5
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_take': {
            id: 'take',
            name: 'Take',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.take(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                },
                {
                    name: 'i1',
                    type: 'list',
                    label: 'Search Index'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    options: [0, 1, 'None'],
                    options_label: ['Row', 'Column', 'None'],
                    component: 'option_select',
                    default: 0
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd067': {
            id: 'op_add',
            name: '+',
            library: 'pandas',
            description: 'Addition',
            code: '${o0} = ${i0} + ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd068': {
            id: 'op_sub',
            name: '-',
            library: 'pandas',
            description: 'Subtract',
            code: '${o0} = ${i0} - ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd069': {
            id: 'op_mul',
            name: '*',
            library: 'pandas',
            description: 'Multiply',
            code: '${o0} = ${i0} * ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd070': {
            id: 'op_pow',
            name: 'power',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0} ** ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd071': {
            id: 'op_div',
            name: '/',
            library: 'pandas',
            description: 'Divide',
            code: '${o0} = ${i0} / ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd072': {
            id: 'op_mod',
            name: '//',
            library: 'pandas',
            description: 'Quotient',
            code: '${o0} = ${i0} // ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd073': {
            id: 'op_mod_left',
            name: '%',
            library: 'pandas',
            description: 'Remainder',
            code: '${o0} = ${i0} % ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd074': {
            id: 'bool',
            name: 'bool',
            library: 'pandas',
            description: 'bool',
            code: '${o0} = ${i0} ${i2} ${i1}',
            input: [
                {
                    name:'i0',
                    type:'var',
                    label: 'Variable 1'
                },
                {
                    name:'i1',
                    type:'var',
                    label: 'Variable 2'
                },
                {
                    name:'i2',
                    type:'var',
                    label: 'Operator',
                    component: 'option_select',
                    options: ['==', '!=', '<', '<=', '>', '>=']
                }
            ],
            variable: [],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label: 'Allocate to'
                },
            ]
        },
        'pdPdo_copy': {
            id: 'copy',
            name: 'copy',
            library: 'pandas',
            description: 'Copy data',
            code: '${o0} = ${i0}.copy(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                }
            ],
            variable: [
                {
                    name: 'deep',
                    type: 'bool',
                    label: 'Deep',
                    default: 'True',
                    component: 'bool_checkbox'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type:'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd076': {
            id: 'read_json',
            name: 'Read Json',
            library: 'pandas',
            description: 'json to pandas object',
            code: '${o0} = pd.read_json(${i0}${v}${etc})',
            input: [
                {
                    name:'i0',
                    type:'text',
                    label: 'File Path',
                    component: 'file'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name:'typ',
                    type:'text',
                    label: 'Type',
                    component: 'option_select',
                    options: ['frame', 'series'],
                    default: 'frame'
                },
                {
                    name: 'orient',
                    type: 'text',
                    label: 'JSON Orient',
                    component: 'option_select',
                    options: ['split', 'records', 'index', 'columns', 'values', 'table'],
                    default: 'columns' // if typ==series, index is default
                },
                {
                    name:'convert_dates',
                    type: 'list',
                    label: 'Convert Dates'
                },
                {
                    name:'index_col',
                    type:'text',
                    label: 'Indexing Column'
                },
                {
                    name: 'encoding',
                    type: 'text',
                    label: 'Encoding',
                    default: 'utf-8'
                },
                {
                    name: 'chunksize',
                    type: 'int',
                    label: 'Chunk Size'
                }
            ]
        },
        'pd077': {
            id: 'to_json',
            name: 'To Json',
            library: 'pandas',
            description: 'DataFrame/Series to Json file',
            code: '${o0} = ${i0}.to_json(${v}${etc})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'DataFrame',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'path_or_buf',
                    type: 'text',
                    label: 'file path/variable'
                }, 
                {
                    name: 'orient',
                    type: 'text',
                    label: 'Orient',
                    component: 'option_select',
                    // options: series 0~3 / dataframe *
                    options: ['split', 'records', 'index', 'table', 'columns', 'values']
                }
            ]
        },
        'pd078': {
            id: 'to_pickle',
            name: 'To Pickle',
            library: 'pandas',
            description: 'DataFrame/Series to Pickle file',
            code: '${i0}.to_pickle(${path}${etc})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'DataFrame',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'path',
                    type: 'text',
                    label: 'file path/variable',
                    required: true
                }
            ],
            variable: [
                
            ]
        },
        'pd079': {
            id: 'read_pickle',
            name: 'Read Pickle',
            library: 'pandas',
            description: 'Pickle to pandas object',
            code: '${o0} = pd.read_pickle(${i0}${v}${etc})',
            input: [
                {
                    name: 'i0',
                    type: 'text',
                    label: 'file path/object',
                    component: 'file'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
            ]
        },
        'pdFunc_combineFirst': {
            id: 'combine_first',
            name: 'Combine First',
            library: 'pandas',
            description: 'Use same position of target data as substitue value for missing value',
            code: '${o0} = ${i0}.combine_first(${i1})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'i1',
                    type:'var',
                    label: 'Combine Object',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [ ]
        },
        'pdFunc_stack': {
            id: 'stack',
            name: 'Stack',
            library: 'pandas',
            description: 'Add column to index level',
            code: '${o0} = ${i0}.stack(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'level',
                    type: ['int', 'text', 'list'],
                    label: 'Level',
                    default: -1,
                },
                {
                    name: 'dropna',
                    type: 'bool',
                    label: 'Drop Na',
                    default: 'True',
                    component: 'bool_checkbox'
                }
            ]
        },
        'pdFunc_unstack': {
            id: 'unstack',
            name: 'Unstack',
            library: 'pandas',
            description: 'Convert specific index level to column',
            code: '${o0} = ${i0}.unstack(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'level',
                    type: ['int', 'text', 'list'],
                    label: 'Level',
                    default: -1,
                },
                {
                    name: 'fill_value',
                    type: ['int', 'text', 'var', 'dict'],
                    label: 'Fill Value'
                }
            ]
        },
        'pdFunc_pivot': {
            id: 'pivot',
            name: 'Pivot',
            library: 'pandas',
            description: 'Pivot data',
            code: '${o0} = ${i0}.pivot(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'index',
                    type: ['text', 'var'],
                    label: 'Index'
                },
                {
                    name: 'columns',
                    type: ['text', 'var'],
                    label: 'Columns'
                },
                {
                    name: 'values',
                    type: ['text', 'var', 'list'],
                    label: 'Values'
                }
            ]
        },
        'pdFunc_melt': {
            id: 'melt',
            name: 'Melt',
            library: 'pandas',
            description: 'Melt data',
            code: '${o0} = ${i0}.melt(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'id_vars',
                    type: ['var', 'list'],
                    label: 'Id Variables'
                },
                {
                    name: 'value_vars',
                    type: ['var', 'list'],
                    label: 'Value Variables'
                },
                {
                    name: 'var_name',
                    type: 'int',
                    label: 'Variable Name'
                },
                {
                    name: 'value_name',
                    type: 'int',
                    label: 'Value Name'
                },
                {
                    name: 'col_level',
                    type: ['int', 'text'],
                    label: 'Column Level'
                }
            ]
        },
        'pd085': {
            id: 'map',
            name: 'Map',
            library: 'pandas',
            description: 'Map data using function or argument',
            code: '${o0} = ${i0}.map(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series', 'Index']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'arg',
                    type: ['var', 'dict'],
                    label: 'Mapping Arguments',
                    required: true
                },
                {
                    name: 'na_action',
                    type: 'var',
                    label: 'Na Action',
                    component: 'option_select',
                    options: ['None', "'ignore'"],
                    options_label: ['None', 'Ignore NA'],
                    default: 'None'
                }
            ]
        },
        'pd086': {
            id: 'apply',
            name: 'Apply',
            library: 'pandas',
            description: 'Change data using function',
            code: '${o0} = ${i0}.apply(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy', 'Rolling']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'func',
                    type: 'var',
                    label: 'Function',
                    component: 'var_select',
                    var_type: ['function'],
                    required: true
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                },
                {
                    name: 'raw',
                    type: 'bool',
                    label: 'Raw',
                    default: 'False',
                    component: 'option_select',
                    options: ['False', 'True'],
                    options_label: ['Series', 'ndarray']
                }
            ]
        },
        'pd087': {
            id: 'applymap',
            name: 'ApplyMap',
            library: 'pandas',
            description: 'Map data using function',
            code: '${o0} = ${i0}.applymap(${i1})',
            guide: [
                'df = pd.DataFrame([[1, 2.12], [3.356, 4.567]])',
                'df.applymap(lambda x: len(str(x)))',
                'df.applymap(lambda x: x**2)'
            ],
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                },
                {
                    name: 'i1',
                    type: 'var',
                    label: 'Function',
                    var_type: ['function']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: []
        },
        'pd088': {
            id: 'cut',
            name: 'Cut',
            library: 'pandas',
            description: 'Cut data for ranging',
            code: '${o0} = pd.cut(${i0}, ${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:['var', 'list'],
                    label: '1-dimension Array'
                },
                {
                    name: 'i1',
                    type:['int', 'var'],
                    label: 'Divide By'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'right',
                    type: 'bool',
                    label: 'Include Right',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'labels',
                    type: ['list', 'bool'],
                    label: 'Labels'
                },
                {
                    name: 'precision',
                    type: 'int',
                    label: 'Precision',
                    default: 3
                }
            ]
        },
        'pd089': {
            id: 'qcut',
            name: 'Qcut',
            library: 'pandas',
            description: 'Q-cut',
            code: '${o0} = pd.qcut(${i0}, ${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:['var', 'list'],
                    label: 'List/Series',
                    var_type: ['list', 'Series']
                },
                {
                    name: 'i1',
                    type:['int', 'var'],
                    label: 'Divide By'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'labels',
                    type: ['list', 'bool'],
                    label: 'Labels'
                },
                {
                    name: 'precision',
                    type: 'int',
                    label: 'Precision',
                    default: 3
                }
            ]
        },
        'pd090': {
            id: 'sample',
            name: 'Sample',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.sample(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                // cannot use n and func on same time
                {
                    name: 'n',
                    type: 'int',
                    label: 'Number of Rows'
                },
                {
                    name: 'frac',
                    type: 'float',
                    label: 'Percentage of Rows'
                },
                {
                    name: 'replace',
                    type: 'bool',
                    label: 'Replace Duplicates',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'weights',
                    type: ['text', 'list', 'list2d'],
                    label: 'Weights'
                },
                {
                    name: 'random_state',
                    type: ['var', 'int'],
                    label: 'Random State',
                    var_type: ['RandomState']
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                }
            ]
        },
        'pd091': {
            id: 'get_dummies',
            name: 'Get Dummies',
            library: 'pandas',
            description: 'One-Hot Encoding',
            code: '${o0} = pd.get_dummies(${i0}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'prefix',
                    type: ['text', 'list', 'dict'],
                    label: 'Header Prefix'
                },
                {
                    name: 'prefix_sep',
                    type: ['text'],
                    label: 'Header Seperator',
                    default: '_'
                },
                {
                    name: 'dummy_na',
                    type: 'bool',
                    label: 'Dummy NA',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'columns',
                    type: 'list',
                    label: 'Columns'
                },
                {
                    name: 'drop_first',
                    type: 'bool',
                    label: 'Drop First Column',
                    default: 'False',
                    component: 'bool_checkbox'
                }
            ]
        },
        'pd092': {
            id: '.str',
            name: '.Str',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.str',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series', 'Index']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: []
        },
        'pd093': {
            id: 'var',
            name: 'Var',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.var(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy', 'EWM', 'Rolling']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'level',
                    type: 'int',
                    label: 'Level'
                },
                {
                    index: 3, 
                    name: 'ddof',
                    type: 'int',
                    label: 'Delta'
                },
                {
                    name: 'numeric_only',
                    type: 'var',
                    label: 'Include Numeric Only',
                    component: 'option_select',
                    options: ['None', "'True'", "'False'"],
                    options_label: ['None', 'Yes', 'No'],
                    default: 'None'
                }
            ]
        },
        'pd094': {
            id: 'prod',
            name: 'Prod',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.prod(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'skipna',
                    type: 'bool',
                    label: 'Skip Na',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'level',
                    type: 'int',
                    label: 'Level'
                },
                {
                    name: 'numeric_only',
                    type: 'var',
                    label: 'Include Numeric Only',
                    component: 'option_select',
                    options: ['None', "'True'", "'False'"],
                    options_label: ['None', 'Yes', 'No'],
                    default: 'None'
                },
                {
                    name: 'min_count',
                    type: 'int',
                    label: 'Minimum Count',
                    default: 0
                }
            ]
        },
        'pd095': {
            id: 'first',
            name: 'First',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.first(${i1})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                },
                {
                    name: 'i1', // offset
                    type: ['text','var'],
                    label: 'Date Offset'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [

            ]
        },
        'pd096': {
            id: 'last',
            name: 'Last',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.last(${i1})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                },
                {
                    name: 'i1', // offset
                    type: ['text','var'],
                    label: 'Date Offset'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
            ]
        },
        'pdGrp_agg': {
            id: 'agg',
            name: 'Aggregation',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.agg(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                },
                {
                    name: 'i1',
                    type: ['var', 'list', 'dict'],
                    label: 'Aggregation Type',
                    options: ['sum', 'mean', 'min', 'max', 'count', 'std', 'quantile']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                }
            ]
        },
        'pd098': {
            id: 'transform',
            name: 'Transform',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.transform(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                },
                {
                    name: 'i1',
                    type: ['var', 'list', 'dict'],
                    label: 'Aggregate Functions',
                    options: ['sum', 'mean', 'min', 'max', 'count']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                }
            ]
        },
        'pdFunc_pivotTable': {
            id: 'pivot_table',
            name: 'Pivot Table',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.pivot_table(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'values',
                    type: 'var',
                    label: 'Values'
                },
                {
                    name: 'index',
                    type: ['var', 'list'],
                    label: 'Indexes'
                },
                {
                    name: 'columns',
                    type: ['var', 'list'],
                    label: 'Columns'
                },
                {
                    name: 'aggfunc',
                    type: ['var', 'list'],
                    label: 'Aggregate Functions'
                },
                {
                    name: 'fill_value',
                    type: ['var', 'int', 'float', 'bool'],
                    label: 'Fill Value'
                },
                {
                    name: 'margins',
                    type: 'bool',
                    label: 'Margins',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'dropna',
                    type: 'bool',
                    label: 'Drop Na',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'margins_name',
                    type: 'text',
                    label: 'Margins Name',
                    default: 'All'
                }
            ]
        },
        'pd100': {
            id: 'crosstab',
            name: 'CrossTable',
            library: 'pandas',
            description: '',
            code: '${o0} = pd.crosstab(${i0}, ${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Index Series/list',
                    component: 'var_select',
                    var_type: ['Series', 'list']
                },
                {
                    name: 'i1',
                    type:'var',
                    label: 'Column Series/list',
                    component: 'var_select',
                    var_type: ['Series', 'list']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'values',
                    type: 'list',
                    label: 'Values'
                },
                {
                    name: 'rownames',
                    type: 'list',
                    label: 'Row Names'
                },
                {
                    name: 'colnames',
                    type: 'list',
                    label: 'Column Names'
                },
                {
                    name: 'aggfunc',
                    type: 'var',
                    label: 'Aggregate Functions',
                    options: ['sum', 'mean', 'min', 'max', 'count']
                },
                {
                    name: 'margins',
                    type: 'bool',
                    label: 'Margins',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'margins_name',
                    type: 'text',
                    label: 'Margins Name',
                    default: 'All'
                },
                {
                    name: 'dropna',
                    type: 'bool',
                    label: 'Drop Na',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'normalize',
                    type: 'bool',
                    label: 'Normalize Rate',
                    default: 'True',
                    component: 'bool_checkbox'
                }
            ]
        },
        'pd101': {
            id: 'to_datetime',
            name: 'To Datetime',
            library: 'pandas',
            description: '',
            code: '${o0} = pd.to_datetime(${i0}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Date List',
                    component: 'var_select',
                    var_type: ['list', 'DataFrame', 'Series', 'int', 'float', 'text', 'datetime']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'

                }
            ],
            variable: [
                {
                    name: 'errors',
                    type: 'text',
                    label: 'Errors',
                    component: 'option_select',
                    default: 'raise',
                    options: ['raise', 'ignore', 'coerce']
                },
                {
                    name: 'dayfirst',
                    type: 'bool',
                    label: 'Day First',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'yearfirst',
                    type: 'bool',
                    label: 'Year First',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'format',
                    type: 'text',
                    label: 'Format',
                    help: '%d/%m/%Y'
                }
            ]
        },
        'pd102': {
            id: '.is_unique',
            name: 'Is Unique',
            library: 'pandas',
            description: '', // TODO:
            code: '${o0} = ${i0}.is_unique',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['Series', 'Index']
                },
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'

                }
            ],
            variable: []
        },
        'pd103': {
            id: 'resample',
            name: 'Resample',
            library: 'pandas',
            description: '', // TODO:
            code: '${o0} = ${i0}.resample(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'i1',
                    type: 'var',
                    label: 'Offset',
                    options: ['5T', '10T', '20T', '1H', '1D', '1W', '1M', 'Q', '1Y'],
                    options_label: [
                        '5 min', '10 min', '20 min', '1 hour',
                        '1 day', '1 week', '1 month', '1 quarter', '1 year'
                    ]
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'

                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                }
            ]
        },
        'pd104': {
            id: 'shift',
            name: 'Shift',
            library: 'pandas',
            description: '', // TODO:
            code: '${o0} = ${i0}.shift(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                },
                {
                    name: 'i1', // periods
                    type: 'int',
                    label: 'Shift Periods'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to',
                    var_type: ['Series']
                }
            ],
            variable: [
                {
                    name: 'freq',
                    type: 'var',
                    label: 'Frequency Offset',
                    options: ['M', 'D', '90T'],
                    options_label: ['Month', 'Day', '90 hour']
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                },
                {
                    name: 'fill_value',
                    type: 'var',
                    label: 'Fill Value'
                }
            ]
        },
        'pd105': {
            id: 'tshift',
            name: 'TShift',
            library: 'pandas',
            description: '', // TODO:
            code: '${o0} = ${i0}.tshift(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index', 'GroupBy']
                },
                {
                    name: 'i1', // periods
                    type: 'int',
                    label: 'Shift Periods'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to',
                    var_type: ['Series', 'DataFrame']
                }
            ],
            variable: [
                {
                    name: 'freq',
                    type: 'var',
                    label: 'Frequency Offset',
                    options: ['M', 'D', '90T'],
                    options_label: ['Month', 'Day', '90 hour']
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                }
            ]
        },
        'pd106': {
            id: 'date_shift',
            name: 'Date Shift Operation',
            library: 'pandas',
            description: '', // TODO:
            code: '${o0} = ${i0} ${i1} ${i2}',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'First Date',
                    options: ['datetime', 'Day()', 'MonthEnd()']
                },
                {
                    name: 'i1', // periods
                    type: 'int',
                    label: 'Shift Periods',
                    component: 'option_select',
                    options: ['+', '-', '*', '/']

                },
                {
                    name: 'i2',
                    type:'var',
                    label: 'Second Date',
                    options: ['datetime', 'Day()', 'MonthEnd()']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: []
        },
        'pd107': {
            id: 'tz_localize',
            name: 'Timezone Localize',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.tz_localize(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Timestamp', 'DatetimeIndex']
                },
                {
                    name: 'i1', // tz
                    type: ['text', 'var'],
                    label: 'Time Zone',
                    options: [
                        'UTC'
                    ]
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to',
                    var_type: ['Series', 'DataFrame']
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'copy',
                    type: 'bool',
                    label: 'Copy',
                    component: 'bool_checkbox',
                    default: 'True'
                }
            ]
        },
        'pd108': {
            id: 'tz_convert',
            name: 'Timezone Convert',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.tz_convert(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Timestamp', 'DatetimeIndex']
                },
                {
                    name: 'i1', // tz
                    type: ['text', 'var'],
                    label: 'Time Zone',
                    options: [
                        'UTC',
                        'Asia/Seoul',
                        'America/New_York',
                        'Europe/Berlin'
                    ]
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to',
                    var_type: ['Series', 'DataFrame']
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                },
                {
                    name: 'level',
                    type: ['int', 'text'],
                    label: 'Level'
                },
                {
                    name: 'copy',
                    type: 'bool',
                    label: 'Copy',
                    component: 'bool_checkbox',
                    default: 'True'
                }
            ]
        },
        'pdParr_timestamp': {
            id: 'Timestamp',
            name: 'Timestamp',
            library: 'pandas',
            description: 'Create Timestamp object',
            code: '${o0} = pd.Timestamp(${v})',
            input: [
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'ts_input',
                    type: ['var', 'text', 'int', 'float'],
                    label: 'Timestamp Source'
                },
                {
                    name: 'freq',
                    type: ['text', 'var'],
                    label: 'Frequency Offset'
                },
                {
                    name: 'year',
                    type: 'int',
                    label: 'Year'
                },
                {
                    name: 'month',
                    type: 'int',
                    label: 'Month'
                },
                {
                    name: 'day',
                    type: 'int',
                    label: 'Day'
                },
                {
                    name: 'hour',
                    type: 'int',
                    label: 'Hour',
                    default: 0
                },
                {
                    name: 'minute',
                    type: 'int',
                    label: 'Minute',
                    default: 0
                },
                {
                    name: 'second',
                    type: 'int',
                    label: 'Second',
                    default: 0
                },
                {
                    name: 'tz',
                    type: ['text', 'var'],
                    label: 'Time Zone'
                }
            ]
        },
        'pd110': {
            id: 'period_range',
            name: 'Period Range',
            library: 'pandas',
            description: '',
            code: '${o0} = pd.period_range(${v})',
            input: [
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: 
            [
                {
                    name: 'start',
                    type: 'text',
                    label: 'Start'
                },
                {
                    name: 'end',
                    type: 'text',
                    label: 'End'
                },
                {
                    name: 'periods',
                    type: 'int',
                    label: 'Periods'
                },
                {
                    name: 'freq',
                    type: ['text', 'var'],
                    label: 'Frequency'
                },
                {
                    name: 'name',
                    type: 'text',
                    label: 'PeriodIndex Name'
                }
            ]
        },
        'pd111': {
            id: 'asfreq',
            name: 'as Frequency',
            library: 'pandas',
            description: '', // TODO:
            code: '${o0} = ${i0}.asfreq(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Period', 'PeriodIndex', 'Resampler']
                },
                {
                    name: 'i1', // freq
                    type: ['text', 'var'],
                    label: 'Frequency Offset',
                    options: [
                        'UTC',
                        'Asia/Seoul',
                        'America/New_York',
                        'Europe/Berlin'
                    ]
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to',
                    var_type: ['Series', 'DataFrame']
                }
            ],
            variable: [
                {
                    name: 'method',
                    type: 'var',
                    label: 'Method',
                    component: 'option_select',
                    default: 'None',
                    options: ['None', "'ffill'", "'bfill'"]
                },
                {
                    name: 'normalize',
                    type: 'bool',
                    label: 'Normalize',
                    component: 'bool_checkbox',
                    default: 'False'
                },
                {
                    name: 'fill_value',
                    type: 'var',
                    label: 'Fill Value'
                }
            ]
        },
        'pd112': {
            id: 'to_period',
            name: 'To Period',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.to_period(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Timestamp', 'DatetimeIndex']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'freq',
                    label: 'Frequency',
                    type: 'text',
                    options: ['s', 'T', 'H', 'D', 'B', 'W', 'W-MON', 'MS', 'M', 'BMS', 'BM'],
                    options_label: ['second', 'minute', 'hour', 'day', 'weekdays', 'week(Sunday)', 'week(Monday)', 
                        'first day of month', 'last day of month', 'first weekday of month', 'last weekday of month']
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                },
                {
                    name: 'copy',
                    type: 'bool',
                    label: 'Copy',
                    component: 'bool_checkbox',
                    default: 'True'
                }
            ]
        },
        'pd113': {
            id: 'to_timestamp',
            name: 'To Timestamp',
            library: 'pandas',
            description: 'Convert from PeriodIndex to DatetimeIndex',
            code: '${o0} = ${i0}.to_timestamp(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Timestamp', 'DatetimeIndex']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'freq',
                    label: 'Frequency',
                    type: 'text',
                    options: ['s', 'T', 'H', 'D', 'B', 'W', 'W-MON', 'MS', 'M', 'BMS', 'BM'],
                    options_label: ['second', 'minute', 'hour', 'day', 'weekdays', 'week(Sunday)', 'week(Monday)', 
                    'first day of month', 'last day of month', 'first weekday of month', 'last weekday of month']
                },
                {
                    name: 'how',
                    label: 'How', // TODO:
                    type: 'text',
                    component: 'option_select',
                    options : ['start', 'end']
                },
                            {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                },
                {
                    name: 'copy',
                    type: 'bool',
                    label: 'Copy',
                    component: 'bool_checkbox',
                    default: 'True'
                }
            ]
        },
        'pdParr_periodIndex': {
            id: 'PeriodIndex',
            name: 'PeriodIndex',
            library: 'pandas',
            description: 'Create PeriodIndex',
            code: '${o0} = pd.PeriodIndex(${v})',
            input: [
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'data',
                    type: 'list',
                    label: 'Data'
                },
                {
                    index: 1, 
                    name: 'copy',
                    type: 'bool',
                    label: 'Deep Copy',
                    component: 'bool_checkbox',
                    default: 'False'
                },
                {
                    name: 'freq',
                    type: 'text',
                    label: 'Frequency',
                    component: 'option_select',
                    options: ['s', 'T', 'H', 'D', 'B', 'W', 'W-MON', 'MS', 'M', 'BMS', 'BM'],
                    options_label: ['second', 'minute', 'hour', 'day', 'weekdays', 'week(Sunday)', 'week(Monday)', 
                    'first day of month', 'last day of month', 'first weekday of month', 'last weekday of month']
                },
                {
                    name: 'year',
                    type: ['int', 'list', 'Series'],
                    label: 'Year'
                },
                {
                    name: 'month',
                    type: ['int', 'list', 'Series'],
                    label: 'Month'
                },
                {
                    name: 'quarter',
                    type: ['int', 'list', 'Series'],
                    label: 'Quarter'
                },
                {
                    name: 'day',
                    type: ['int', 'list', 'Series'],
                    label: 'Day'
                },
                {
                    name: 'hour',
                    type: ['int', 'list', 'Series'],
                    label: 'Hour',
                    default: 0
                },
                {
                    name: 'minute',
                    type: ['int', 'list', 'Series'],
                    label: 'Minute',
                    default: 0
                },
                {
                    name: 'second',
                    type: ['int', 'list', 'Series'],
                    label: 'Second',
                    default: 0
                },
                {
                    name: 'tz',
                    type: ['text', 'var'],
                    label: 'Timezone'
                }
            ]
        },
        'pd115': {
            id: 'rolling',
            name: 'Rolling',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.rolling(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'i1', // window
                    type: ['int', 'text'],
                    label: 'Data Count'
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'min_periods',
                    type: 'int',
                    label: 'Minimum Periods',
                },
                {
                    name: 'center',
                    type: 'bool',
                    label: 'Center',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'win_type',
                    type: 'text',
                    label: 'Rolling View Type',
                    component: 'option_select',
                    options: ['boxcar', 'triang', 'blackman', 'hamming', 'bartlett', 'parzen', 'bohman', 'blackmanharris', 'nuttall', 'barthann']

                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    default: 0
                }
            ]
        },
        'pd116': {
            id: 'ewm',
            name: 'EWM',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.ewm(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'com',
                    type: 'float',
                    label: 'Com',
                    help: 'com≥0, α=1/(1+com)'
                },
                {
                    name: 'span',
                    type: 'float',
                    label: 'Span',
                    help: 'span≥1, α=2/(span+1)'
                },
                {
                    name: 'halflife',
                    type: 'float',
                    label: 'Half Life', 
                    help: 'halflife>0, α=1−exp(log(0.5)/halflife)'
                },
                {
                    name: 'alpha',
                    type: 'float',
                    label: 'Alpha',
                    help: '0<α≤1'
                },
                {
                    name: 'min_periods',
                    type: 'int',
                    label: 'Minimum Periods',
                    help: '',
                    default: 0
                },
                {
                    name: 'adjust',
                    type: 'bool',
                    label: 'Adjust',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'ignore_na',
                    type: 'bool',
                    label: 'Ignore NA',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    default: 0,
                    component: 'option_select',
                    options: [0, 1],
                    options_label: ['row', 'column']
                }
            ]
        },
        'pd117': {
            id: 'pct_change',
            name: 'PCT Change',
            library: 'pandas',
            description: '',
            code: '${o0} = ${i0}.pct_change(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'periods',
                    type: 'int',
                    label: 'Periods',
                    default: 1
                },
                {
                    name: 'fill_method',
                    type: 'text',
                    label: 'Fill Method',
                    default: 'ffill',
                    options: ["'ffill'", "'bfill'"],
                    options_label: ['fill with front value', 'fill with back value']
                },
                {
                    name: 'limit',
                    type: 'int',
                    label: 'Limit'
                },
                {
                    name: 'freq',
                    type: ['text','var'],
                    label: 'Frequency',
                    options: ['s', 'T', 'H', 'D', 'B', 'W', 'W-MON', 'MS', 'M', 'BMS', 'BM'],
                    options_label: ['second', 'minute', 'hour', 'day', 'weekdays', 'week(Sunday)', 'week(Monday)', 
                        'first day of month', 'last day of month', 'first weekday of month', 'last weekday of month']
                },
            ]
        },
        'pd118': {
            id: 'corr',
            name: 'Correlation',
            library: 'pandas',
            description: 'correlation between columns',
            code: '${o0} = ${i0}.corr(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'GroupBy', 'EWM']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'method',
                    type: ['text', 'var'],
                    label: 'Method',
                    default: 'pearson',
                    component: 'option_select',
                    options: ['pearson', 'kendall', 'spearman'],
                },
                {
                    name: 'min_periods',
                    type: 'int',
                    label: 'Minimum Periods'
                }
            ]
        },
        'pd119': {
            id: 'corrwith',
            name: 'Correlation With',
            library: 'pandas',
            description: 'correlation',
            code: '${o0} = ${i0}.corrwith(${i1}${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'DataFrameGroupBy']
                },
                {
                    name: 'i1',
                    type:'var',
                    label: 'Object To Compare',
                    component: 'var_select',
                    var_type: ['DataFrame', 'DataFrameGroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'axis',
                    type: 'int',
                    label: 'Axis',
                    default: 0,
                    options: [0, 1],
                    options_label: ['row', 'column'],
                    component: 'option_select'
                },
                {
                    name: 'drop',
                    type: 'bool',
                    label: 'Drop Empty',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'method',
                    type: ['text', 'var'],
                    label: 'Method',
                    default: 'pearson',
                    component: 'option_select',
                    options: ['pearson', 'kendall', 'spearman'],
                }
            ]
        },
        'pd120': {
            id: 'cov',
            name: 'Covariance',
            library: 'pandas',
            description: 'covariance between all features',
            code: '${o0} = ${i0}.cov(${v})',
            input: [
                {
                    name: 'i0',
                    type:'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'DataFrameGroupBy']
                }
            ],
            output: [
                {
                    name:'o0',
                    type:'var',
                    label:'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'min_periods',
                    type: 'int',
                    label: 'Minimum Periods'
                }
            ]
        },
        'pd_plot': {
            id: 'plot',
            name: 'Plot',
            library: 'pandas',
            description: 'create chart',
            code: '${i0}.plot(${v}${etc})\nplt.show()',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'DataFrame',
                    var_type: ['DataFrame', 'Series'],
                    required: true
                }
            ],
            output: [
            ],
            variable: [
                {
                    name: 'kind',
                    type: 'text',
                    label: 'Chart Type',
                    default: 'line',
                    component: 'option_select',
                    options: ['line', 'bar', 'barh', 'hist', 'box', 'kde', 'area', 'pie', 'scatter', 'hexbin'],
                    options_label: ['Line', 'Bar', 'Barh', 'Hist', 'Box', 'Kernel Density Estimation', 'Area', 'Pie', 'Scatter', 'Hexbin']
                },
                {
                    name: 'title',
                    type: 'text',
                    label: 'Chart Title'
                },
                {
                    name: 'figsize',
                    type: 'tuple',
                    label: 'Figure Size',
                    placeholder: '(width, height)'
                },
                {
                    name: 'fontsize',
                    type: 'int',
                    component: 'input_number',
                    label: 'Font Size'
                },
                {
                    name: 'colormap',
                    type: 'text',
                    label: 'Color Map',
                    component: 'option_select',
                    options: [
                        'viridis', 'plasma', 'inferno', 'magma', 'cividis', 'Pastel1', 'Pastel2', 'Paired', 'Accent', 'Dark2', 'Set1', 'Set2', 'Set3', 'tab10', 'tab20', 'tab20b', 'tab20c'
                    ],
                    options_label: [
                        'viridis', 'plasma', 'inferno', 'magma', 'cividis', 'Pastel1', 'Pastel2', 'Paired', 'Accent', 'Dark2', 'Set1', 'Set2', 'Set3', 'tab10', 'tab20', 'tab20b', 'tab20c'
                    ]
                },
                {
                    name: 'grid',
                    type: 'bool',
                    label: 'Show Grid',
                    component: 'bool_checkbox',
                    default: 'False'
                },
                {
                    name: 'legend',
                    type: 'bool',
                    label: 'Show Legend',
                    component: 'bool_checkbox',
                    default: 'False'
                },
                {
                    name: 'rot',
                    type: 'int',
                    component: 'input_number',
                    label: 'X Label Rotation'
                },
                {
                    name: 'xlabel',
                    type: 'text',
                    label: 'X Label'
                },
                {
                    name: 'ylabel',
                    type: 'text',
                    label: 'Y Label'
                },
                {
                    name: 'xlim',
                    type: ['var', 'list'], //tuple
                    label: 'X Limit',
                    placeholder: '(start, end)'
                },
                {
                    name: 'ylim',
                    type: ['var', 'list'], //tuple
                    label: 'Y Limit',
                    placeholder: '(start, end)'
                },
                {
                    name: 'xticks',
                    type: 'list',
                    label: 'X Ticks',
                    placeholder: "['tick', ...]"
                },
                {
                    name: 'yticks',
                    type: 'list',
                    label: 'Y Ticks',
                    placeholder: "['tick', ...]"
                },
                {
                    name: 'style',
                    type: ['list', 'dict'],
                    label: 'Style',
                    placeholder: '["-", "--", "-.", ":"]',
                    help: 'Length of columns and style list must be same'
                },
                {
                    name: 'x',
                    type: ['text', 'int'],
                    label: 'X Column'
                },
                {
                    name: 'y',
                    type: ['text', 'int'],
                    label: 'Y Column'
                },
                {
                    name: 'subplots',
                    type: 'bool',
                    label: 'Subplots Per Column',
                    default: 'False',
                    component: 'bool_checkbox'
                },
                {
                    name: 'layout',
                    type: 'tuple',
                    label: 'Subplot Layout',
                    placeholder: '(row, column)'
                },
                {
                    name: 'use_index',
                    type: 'bool',
                    label: 'Use Index On X Ticks',
                    default: 'True',
                    component: 'bool_checkbox'
                },
                {
                    name: 'stacked',
                    type: 'bool',
                    label: 'Stacked',
                    default: 'False',//true in area
                    component: 'bool_checkbox'
                }
            ],
        },
        'pd123': {
            id: 'readExcel',
            name: 'Read Excel',
            library: 'pandas',
            description: 'excel to pandas object',
            code: '${o0} = pd.read_excel(${i0}${v}${etc})',
            input: [
                {
                    name: 'i0',
                    type: 'text',
                    label: 'File Path',
                    component: 'file'
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ],
            variable: [
                {
                    name: 'sheet_name',
                    type: 'text',
                    label: 'Sheet Name'
                }
            ]
        },
        'pd124': {
            id: 'to_excel',
            name: 'To Excel',
            library: ['pandas', 'xlwt', 'openpyxl'], // TODO: required packages
            description: 'DataFrame to excel file',
            code: '${i0}.to_excel(${i1}${v}${etc})',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'DataFrame',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series']
                },
                {
                    name: 'i1',
                    type: 'text',
                    label: 'File Path',
                    component: 'file'
                }
            ],
            output: [
            ],
            variable: [
                {
                    name: 'sheet_name',
                    type: 'text',
                    label: 'Sheet Name'
                }
            ]
        },
        'pd125': {
            id: 'subset',
            name: 'Subset',
            library: 'pandas',
            description : 'subset pandas object',
            code: '${o0} = ${i0}',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Subset Code',
                    component: 'var_select',
                    var_type: ['DataFrame']
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pd126': {
            id: 'frame_editor',
            name: 'Frame Editor',
            library: 'pandas',
            description : 'pandas object editor',
            code: '${o0} = ${i0}',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Code',
                    component: 'textarea',
                    var_type: ['DataFrame']
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdIdt_size': {
            id: 'size',
            name: 'Size', 
            library: 'pandas',
            description: 'pandas object size info',
            code: '${o0} = ${i0}.size',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['DataFrame', 'Series', 'Index']
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        },
        'pdGrp_size': {
            id: 'groupby_size',
            name: 'Size',
            library: 'pandas',
            description: 'groupby size info',
            code: '${o0} = ${i0}.size()',
            input: [
                {
                    name: 'i0',
                    type: 'var',
                    label: 'Target Variable',
                    component: 'var_select',
                    var_type: ['GroupBy']
                }
            ],
            output: [
                {
                    name: 'o0',
                    type: 'var',
                    label: 'Allocate to'
                }
            ]
        }
    }

    return {
        PANDAS_FUNCTION: PANDAS_FUNCTION
    };
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/data/m_library/pythonLibrary.js":
/*!**********************************************************!*\
  !*** ./lib/visualpython/data/m_library/pythonLibrary.js ***!
  \**********************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    /**
     * name
     * library
     * description
     * code
     * options: [
     *      {
     *          name
     *          label
     *          [optional]
     *          component : 
     *              - 1darr / 2darr / ndarr / scalar / param / dtype / tabblock
     *          default
     *          required
     *          usePair
     *          code
     *      }
     * ]
     */
    var PYTHON_LIBRARIES = {
        'pyBuilt_abs': {
            name: 'abs',
            library: 'python',
            description: '',
            code: '${o0} = abs(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Number',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_all': {
            name: 'all',
            library: 'python',
            description: '',
            code: '${o0} = all(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_any': {
            name: 'any',
            library: 'python',
            description: '',
            code: '${o0} = any(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_ascii': {
            name: 'ascii',
            library: 'python',
            description: '',
            code: '${o0} = ascii(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_bin': {
            name: 'bin',
            library: 'python',
            description: '',
            code: '${o0} = bin(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Number',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_bool': {
            name: 'bool',
            library: 'python',
            description: '',
            code: '${o0} = bool(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Expression'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_breakpoint': {
            name: 'breakpoint',
            library: 'python',
            description: '',
            code: 'breakpoint()',
            options: [
            ]
        },
        'pyBuilt_bytearray': {
            name: 'bytearray',
            library: 'python',
            description: '',
            code: '${o0} = bytearray(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Source',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_bytes': {
            name: 'bytes',
            library: 'python',
            description: '',
            code: '${o0} = bytes(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Source',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_callable': {
            name: 'callable',
            library: 'python',
            description: '',
            code: '${o0} = callable(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_chr': {
            name: 'chr',
            library: 'python',
            description: '',
            code: '${o0} = chr(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input ASCII',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_classmethod': {
            name: 'classmethod',
            library: 'python',
            description: '',
            code: '${o0} = classmethod(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Function',
                    component: ['var_select'],
                    var_type: ['function'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_complex': {
            name: 'complex',
            library: 'python',
            description: '',
            code: '${o0} = complex(${i0}${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Real',
                    placeholder: 'real/expression'
                },
                {
                    name: 'i1',
                    label: 'Input Imag',
                    code: ', ${i1}',
                    component: ['input_number']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_delattr': {
            name: 'delattr',
            library: 'python',
            description: '',
            code: '${o0} = delattr(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Attribute Name',
                    type: 'text',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_dict': {
            name: 'dict',
            library: 'python',
            description: '',
            code: '${o0} = dict(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_dir': {
            name: 'dir',
            library: 'python',
            description: '',
            code: '${o0} = dir(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Data',
                    component: ['var_select'],
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_divmod': {
            name: 'divmod',
            library: 'python',
            description: '',
            code: '${o0} = divmod(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Number to Divide',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Input Divider',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_enumerate': {
            name: 'enumerate',
            library: 'python',
            description: '',
            code: '${o0} = enumerate(${i0}${start})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'start',
                    label: 'Start Index',
                    component: ['input_number'],
                    code: ', start=${start}'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_eval': {
            name: 'eval',
            library: 'python',
            description: '',
            code: '${o0} = eval(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_exec': {
            name: 'exec',
            library: 'python',
            description: '',
            code: '${o0} = exec(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_filter': {
            name: 'filter',
            library: 'python',
            description: '',
            code: '${o0} = filter(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Function',
                    component: ['var_select'],
                    var_type: ['function'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Input Iterable Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_float': {
            name: 'float',
            library: 'python',
            description: '',
            code: '${o0} = float(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_format': {
            name: 'format',
            library: 'python',
            description: '',
            code: '${o0} = format(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_frozenset': {
            name: 'frozenset',
            library: 'python',
            description: '',
            code: '${o0} = frozenset(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select', 'ndarr', '1darr'],
                    componentCode: ['', '(${i0})', '']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_getattr': {
            name: 'getattr',
            library: 'python',
            description: '',
            code: '${o0} = getattr(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Attribute Name',
                    type: 'text',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_globals': {
            name: 'globals',
            library: 'python',
            description: '',
            code: '${o0} = globals()',
            options: [
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_hasattr': {
            name: 'hasattr',
            library: 'python',
            description: '',
            code: '${o0} = hasattr(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Attribute Name',
                    type: 'text',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_hash': {
            name: 'hash',
            library: 'python',
            description: '',
            code: '${o0} = hash(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_help': {
            name: 'help',
            library: 'python',
            description: '',
            code: 'help(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Object',
                    component: ['var_select']
                }
            ]
        },
        'pyBuilt_hex': {
            name: 'hex',
            library: 'python',
            description: '',
            code: '${o0} = hex(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Number',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_id': {
            name: 'id',
            library: 'python',
            description: '',
            code: '${o0} = id(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_input': {
            name: 'input',
            library: 'python',
            description: '',
            code: '${o0} = input(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Prompt'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_int': {
            name: 'int',
            library: 'python',
            description: '',
            code: '${o0} = int(${i0}${base})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    required: true
                },
                {
                    name: 'base',
                    label: 'Base',
                    component: ['input_number'],
                    placeholder: '10',
                    code: ", base=${base}"
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_isinstance': {
            name: 'isinstance',
            library: 'python',
            description: '',
            code: '${o0} = isinstance(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Class Info',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_issubclass': {
            name: 'issubclass',
            library: 'python',
            description: '',
            code: '${o0} = issubclass(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Class Info',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_iter': {
            name: 'iter',
            library: 'python',
            description: '',
            code: '${o0} = iter(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_len': {
            name: 'len',
            library: 'python',
            description: '',
            code: '${o0} = len(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_list': {
            name: 'list',
            library: 'python',
            description: '',
            code: '${o0} = list(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Object',
                    component: ['var_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_locals': {
            name: 'locals',
            library: 'python',
            description: '',
            code: '${o0} = locals()',
            options: [
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_map': {
            name: 'map',
            library: 'python',
            description: '',
            code: '${o0} = map(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Function',
                    component: ['var_select'],
                    var_type: ['function'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Input Iterable Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_max': {
            name: 'max',
            library: 'python',
            description: '',
            code: '${o0} = max(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select', 'ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_memoryview': {
            name: 'memoryview',
            library: 'python',
            description: '',
            code: '${o0} = memoryview(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Data',
                    var_type: ['bytes', 'bytearray'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_min': {
            name: 'min',
            library: 'python',
            description: '',
            code: '${o0} = min(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select', 'ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_next': {
            name: 'next',
            library: 'python',
            description: '',
            code: '${o0} = next(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_object': {
            name: 'object',
            library: 'python',
            description: '',
            code: '${o0} = object()',
            options: [
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_oct': {
            name: 'oct',
            library: 'python',
            description: '',
            code: '${o0} = oct(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Number',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_open': { // FIXME:
            name: 'open',
            library: 'python',
            description: '',
            code: '${o0} = open(${i0}${mode}${buffering}${encoding}${errors})',
            options: [
                {
                    name: 'i0',
                    label: 'Select File',
                    component: ['file'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                },
                {
                    name: 'mode',
                    label: 'Mode',
                    usePair: true,
                    component: ['option_select']
                },
                {
                    name: 'buffering',
                    label: 'Buffering',
                    usePair: true,
                    component: ['input_number']
                },
                {
                    name: 'encoding',
                    label: 'Encoding',
                    usePair: true,
                    component: ['option_suggest'],
                    type: 'text',
                    options: ['utf8', 'cp949', 'ascii'],
                    placeholder: 'encoding option'
                },
                {
                    name: 'error',
                    label: 'Errors',
                    usePair: true,
                    component: ['option_suggest'],
                    type: 'text',
                    options: ['strict', 'ignore', 'replace', 'surrogateescape', 
                        'xmlcharrefreplace', 'backslashreplace', 'namereplace']
                }
            ]
        },
        'pyBuilt_ord': {
            name: 'ord',
            library: 'python',
            description: '',
            code: '${o0} = ord(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Enter Character',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_pow': {
            name: 'pow',
            library: 'python',
            description: '',
            code: '${o0} = pow(${i0}, ${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Base',
                    placeholder: 'base/expression',
                    required: true
                },
                {
                    name: 'i0',
                    label: 'Exponent',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_print': {
            name: 'print',
            library: 'python',
            description: '',
            code: '${o0} = print(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Print Data'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_property': {
            name: 'property',
            library: 'python',
            description: '',
            code: 'property(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Getter',
                    component: ['var_select'],
                    var_type: ['function'],
                    required: true
                },
                {
                    name: 'i0',
                    label: 'Setter',
                    component: ['var_select'],
                    var_type: ['function'],
                    required: true
                }
            ]
        },
        'pyBuilt_range': {
            name: 'range',
            library: 'python',
            description: '',
            code: '${o0} = range(${i0}${i1}${i2})',
            options: [
                {
                    name: 'i0',
                    label: 'Start Number',
                    component: ['input_number'],
                    code: '${i0}, '
                },
                {
                    name: 'i1',
                    label: 'Stop Number',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'i2',
                    label: 'Step Number',
                    component: ['input_number'],
                    code: ', ${i2}'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_repr': {
            name: 'repr',
            library: 'python',
            description: '',
            code: '${o0} = repr(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_reversed': {
            name: 'reversed',
            library: 'python',
            description: '',
            code: '${o0} = reversed(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_round': {
            name: 'round',
            library: 'python',
            description: '',
            code: '${o0} = round(${i0}${ndigits})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Number',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'ndigits',
                    label: 'Number Digits',
                    component: ['input_number'],
                    usePair: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_set': {
            name: 'set',
            library: 'python',
            description: '',
            code: '${o0} = set(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Data',
                    component: ['var_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_setattr': {
            name: 'setattr',
            library: 'python',
            description: '',
            code: '${o0} = setattr(${i0}, ${i1}, ${i2})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'i1',
                    label: 'Attribute Name',
                    type: 'text',
                    required: true
                },
                {
                    name: 'i2',
                    label: 'Attribute Value',
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_slice': {
            name: 'slice',
            library: 'python',
            description: '',
            code: '${o0} = slice(${i0}${i1}${i2})',
            options: [
                {
                    name: 'i0',
                    label: 'Start Number',
                    component: ['input_number'],
                    code: '${i0}, '
                },
                {
                    name: 'i1',
                    label: 'Stop Number',
                    component: ['input_number'],
                    required: true
                },
                {
                    name: 'i2',
                    label: 'Step Number',
                    component: ['input_number'],
                    code: ', ${i2}'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_sorted': {
            name: 'sorted',
            library: 'python',
            description: '',
            code: '${o0} = sorted(${i0}${reverse})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'reverse',
                    label: 'Reverse',
                    usePair: true,
                    component: ['bool_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_staticmethod': {
            name: 'staticmethod',
            library: 'python',
            description: '',
            code: '${o0} = staticmethod(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Function',
                    component: ['var_select'],
                    var_type: ['function'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_str': {
            name: 'str',
            library: 'python',
            description: '',
            code: '${o0} = str(${i0}${encoding})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data'
                },
                {
                    name: 'encoding',
                    label: 'Encoding',
                    usePair: true,
                    component: ['option_suggest'],
                    type: 'text',
                    options: ['utf8', 'cp949', 'ascii'],
                    placeholder: 'encoding option'
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_sum': {
            name: 'sum',
            library: 'python',
            description: '',
            code: '${o0} = sum(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select', 'ndarr'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_super': {
            name: 'super',
            library: 'python',
            description: '',
            code: '${o0} = super(${i0}${i1})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Type'
                },
                {
                    name: 'i1',
                    label: 'Input Object or Type',
                    code: ', ${i1}',
                    component: ['var_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_tuple': {
            name: 'tuple',
            library: 'python',
            description: '',
            code: '${o0} = tuple(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_type': {
            name: 'type',
            library: 'python',
            description: '',
            code: '${o0} = type(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Data',
                    component: ['var_select'],
                    required: true
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_vars': {
            name: 'vars',
            library: 'python',
            description: '',
            code: '${o0} = vars(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Select Object',
                    component: ['var_select']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        },
        'pyBuilt_zip': {
            name: 'zip',
            library: 'python',
            description: '',
            code: '${o0} = zip(${i0})',
            options: [
                {
                    name: 'i0',
                    label: 'Input Object',
                    component: ['ndarr']
                },
                {
                    name: 'o0',
                    label: 'Allocate to'
                }
            ]
        }
    }
    return { PYTHON_LIBRARIES: PYTHON_LIBRARIES };
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/data/m_ml/mlLibrary.js":
/*!*************************************************!*\
  !*** ./lib/visualpython/data/m_ml/mlLibrary.js ***!
  \*************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    /**
     * name
     * library
     * description
     * code
     * options: [
     *      {
     *          name
     *          label
     *          [optional]
     *          component : 
     *              - 1darr / 2darr / ndarr / scalar / param / dtype / tabblock
     *          default
     *          required
     *          usePair
     *          code
     *      }
     * ]
     */
    var ML_LIBRARIES = {
        /** Data Sets */
        'load_boston': {
            name: 'load_boston',
            import: 'from sklearn.datasets import load_boston',
            code: 'load_boston()',
            options: [

            ]
        },
        'load_iris': {
            name: 'load_iris',
            import: 'from sklearn.datasets import load_iris',
            code: 'load_iris()',
            options: [

            ]
        },
        'load_diabetes': {
            name: 'load_diabetes',
            import: 'from sklearn.datasets import load_diabetes',
            code: 'load_diabetes()',
            options: [

            ]
        },
        'load_digits': {
            name: 'load_digits',
            import: 'from sklearn.datasets import load_digits',
            code: 'load_digits(${n_class})',
            options: [
                { name: 'n_class', component: ['input_number'], default: 10, usePair: true },
            ]
        },
        'load_linnerud': {
            name: 'load_linnerud',
            import: 'from sklearn.datasets import load_linnerud',
            code: 'load_linnerud()',
            options: [

            ]
        },
        'load_wine': {
            name: 'load_wine',
            import: 'from sklearn.datasets import load_wine',
            code: 'load_wine()',
            options: [

            ]
        },
        'load_breast_cancer': {
            name: 'load_breast_cancer',
            import: 'from sklearn.datasets import load_breast_cancer',
            code: 'load_breast_cancer()',
            options: [

            ]
        },
        'make_classification': {
            name: 'make_classification',
            import: 'from sklearn.datasets import make_classification',
            code: 'make_classification(${n_samples}${n_features}${n_repeated}${n_classes}${shuffle}${random_state}${etc})',
            options: [
                { name: 'n_samples', component: ['input_number'], default: 100, usePair: true },
                { name: 'n_features', component: ['input_number'], default: 20, usePair: true },
                { name: 'n_repeated', component: ['input_number'], default: 0, usePair: true },
                { name: 'n_classes', component: ['input_number'], default: 2, usePair: true },
                { name: 'shuffle', component: ['bool_select'], default: 'True', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'make_blobs': {
            name: 'make_blobs',
            import: 'from sklearn.datasets import make_blobs',
            code: 'make_blobs(${n_samples}${n_features}${shuffle}${random_state}${etc})',
            options: [
                { name: 'n_samples', component: ['input_number'], default: 100, usePair: true },
                { name: 'n_features', component: ['input_number'], default: 20, usePair: true },
                { name: 'shuffle', component: ['bool_select'], default: 'True', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'make_circles': {
            name: 'make_circles',
            import: 'from sklearn.datasets import make_circles',
            code: 'make_circles(${n_samples}${shuffle}${noise}${random_state}${factor}${etc})',
            options: [
                { name: 'n_samples', component: ['input_number'], default: 100, usePair: true },
                { name: 'shuffle', component: ['bool_select'], default: 'True', usePair: true },
                { name: 'noise', component: ['input_number'], usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true },
                { name: 'factor', component: ['input_number'], default: 0.8, usePair: true }
            ]
        },
        'make_moons': {
            name: 'make_moons',
            import: 'from sklearn.datasets import make_moons',
            code: 'make_moons(${n_samples}${shuffle}${noise}${random_state}${etc})',
            options: [
                { name: 'n_samples', component: ['input_number'], default: 100, usePair: true },
                { name: 'shuffle', component: ['bool_select'], default: 'True', usePair: true },
                { name: 'noise', component: ['input_number'], usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        /** Data Preparation - Encoding */
        'prep-onehot': {
            name: 'OneHotEncoder',
            import: 'from sklearn.preprocessing import OneHotEncoder',
            code: 'OneHotEncoder(${sparse}${handle_unknown}${etc})',
            options: [
                { name: 'sparse', component: ['bool_select'], default: 'False', usePair: true },
                { name: 'handle_unknown', component: ['option_suggest'], usePair: true, 
                    options: ['error', 'ignore'], default: 'error' },
            ]
        },
        'prep-label': {
            name: 'LabelEncoder',
            import: 'from sklearn.preprocessing import LabelEncoder',
            code: 'LabelEncoder()',
            options: [
                
            ]
        },
        'prep-ordinal': {
            name: 'OrdinalEncoder',
            import: 'from sklearn.preprocessing import OrdinalEncoder',
            code: 'OrdinalEncoder(${handle_unknown}${unknown_values}${etc})',
            options: [
                { name: 'handle_unknown', component: ['option_suggest'], usePair: true, 
                    options: ['error', 'use_encoded_value'], default: 'error' },
                { name: 'unknown_values', component: ['input'], usePair: true }
            ]
        },
        'prep-target': {
            name: 'TargetEncoder',
            install: '!pip install category_encoders',
            import: 'from category_encoders.target_encoder import TargetEncoder',
            code: 'TargetEncoder(${cols}${handle_missing}${handle_unknown}${smoothing}${etc})',
            options: [
                { name: 'cols', component: ['var_suggest', '1darr'], usePair: true },
                { name: 'handle_missing', component: ['option_suggest'], usePair: true,
                    options: ['error', 'return_nan', 'value'], default: 'value' },
                { name: 'handle_unknown', component: ['option_suggest'], usePair: true,
                    options: ['error', 'return_nan', 'value'], default: 'value' },
                { name: 'smoothing', component: ['input_number'], default: 1.0, usePair: true }
            ]
        },
        'prep-smote': {
            name: 'SMOTE',
            install: '!pip install imblearn',
            import: 'from imblearn.over_sampling import SMOTE',
            code: 'SMOTE(${random_state}${k_neighbors}${etc})',
            options: [
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true },
                { name: 'k_neighbors', component: ['input_number'], default: 5, usePair: true }
            ]
        },
        /** Data Preparation - Scaling */
        'prep-standard': {
            name: 'StandardScaler',
            import: 'from sklearn.preprocessing import StandardScaler',
            code: 'StandardScaler(${with_mean}${with_std}${etc})',
            options: [
                { name: 'with_mean', component: ['bool_select'], default: 'True', usePair: true },
                { name: 'with_std', component: ['bool_select'], default: 'True', usePair: true }
            ]
        },
        'prep-robust': {
            name: 'RobustScaler',
            import: 'from sklearn.preprocessing import RobustScaler',
            code: 'RobustScaler(${with_centering}${with_scaling}${etc})',
            options: [
                { name: 'with_centering', component: ['bool_select'], default: 'True', usePair: true },
                { name: 'with_scaling', component: ['bool_select'], default: 'True', usePair: true }
            ]
        },
        'prep-minmax': {
            name: 'MinMaxScaler',
            import: 'from sklearn.preprocessing import MinMaxScaler',
            code: 'MinMaxScaler(${feature_range}${etc})',
            options: [
                { name: 'feature_range', component: ['input'], placeholder: '(min, max)', default: '(0, 1)', usePair: true }
            ]
        },
        'prep-normalizer': {
            name: 'Normalizer',
            import: 'from sklearn.preprocessing import Normalizer',
            code: 'Normalizer(${norm}${etc})',
            options: [
                { name: 'norm', component: ['option_suggest'], usePair: true,
                    options: ['l1', 'l2', 'max'], default: 'l2' },
            ]
        },
        'prep-func-trsfrm-log': {
            name: 'Log Scaling',
            import: 'from sklearn.preprocessing import FunctionTransformer',
            code: 'FunctionTransformer(np.log1p${etc})',
            options: [

            ]
        },
        'prep-func-trsfrm-exp': {
            name: 'Exponential Scaling',
            import: 'from sklearn.preprocessing import FunctionTransformer',
            code: 'FunctionTransformer(np.expm1${etc})',
            options: [

            ]
        },
        'prep-poly-feat': {
            name: 'Polynomial Features',
            import: 'from sklearn.preprocessing import PolynomialFeatures',
            code: 'PolynomialFeatures(${etc})',
            options: [

            ]
        },
        'prep-kbins-discretizer': {
            name: 'KBins Discretizer',
            import: 'from sklearn.preprocessing import KBinsDiscretizer',
            code: 'KBinsDiscretizer(${n_bins}${strategy}${encode}${etc})',
            options: [
                { name: 'n_bins', component: ['input_number'], default: 5, usePair: true },
                { name: 'strategy', component: ['option_select'], type: 'text', default: 'quantile', usePair: true,
                    options: ['uniform', 'quantiile', 'kmeans'] },
                { name: 'encode', component: ['option_select'], type: 'text', default: 'onehot', usePair: true,
                    options: ['onehot', 'onehot-dense', 'ordinal'] }
            ]
        },
        'make-column-transformer': {
            name: 'MakeColumnTransformer',
            import: 'from sklearn.compose import make_column_transformer',
            code: 'make_column_transformer(${mct_code})',
            options: [

            ]
        },
        /** Regression */
        'ln-rgs': {
            name: 'LinearRegression',
            import: 'from sklearn.linear_model import LinearRegression',
            code: 'LinearRegression(${fit_intercept}${etc})',
            options: [
                { name: 'fit_intercept', component: ['bool_select'], default: 'True', usePair: true }
            ]
        },
        'ridge': {
            name: 'Ridge',
            import: 'from sklearn.linear_model import Ridge',
            code: 'Ridge(${alpha}${etc})',
            options: [
                { name: 'alpha', component: ['input_number'], default: 1.0, usePair: true }
            ]
        },
        'lasso': {
            name: 'Lasso',
            import: 'from sklearn.linear_model import Lasso',
            code: 'Lasso(${alpha}${etc})',
            options: [
                { name: 'alpha', component: ['input_number'], default: 1.0, usePair: true }
            ]
        },
        'elasticnet': {
            name: 'ElasticNet',
            import: 'from sklearn.linear_model import ElasticNet',
            code: 'ElasticNet(${alpha}${l1_ratio}${etc})',
            options: [
                { name: 'alpha', component: ['input_number'], default: 1.0, usePair: true },
                { name: 'l1_ratio', component: ['input_number'], default: 0.5, usePair: true }
            ]
        },
        'sv-rgs': {
            name: 'SVR',
            import: 'from sklearn.svm import SVR',
            code: 'SVR(${C}${kernel}${degree}${gamma}${coef0}${random_state}${etc})',
            options: [
                { name: 'C', component: ['input_number'], placeholder: '1.0', usePair: true, step: 0.1, min: 0 },
                { name: 'kernel', component: ['option_select'], type: 'text', usePair: true, 
                    options: ['linear', 'poly', 'rbf', 'sigmoid', 'precomputed'], default: 'rbf' },
                { name: 'degree', component: ['input_number'], placeholder: '3', usePair: true },
                { name: 'gamma', component: ['option_suggest'], usePair: true,
                    options: ["'scale'", "'auto'"], default: "'scale'" },
                { name: 'coef0', component: ['input_number'], placeholder: '0.0', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'dt-rgs': {
            name: 'DecisionTreeRegressor',
            import: 'from sklearn.tree import DecisionTreeRegressor',
            code: 'DecisionTreeRegressor(${criterion}${max_depth}${min_samples_split}${random_state}${etc})',
            options: [
                { name: 'criterion', component: ['option_select'], type: 'text', default: 'squared_error', type:'text',
                    options: ['squared_error', 'friedman_mse', 'absolute_error', 'poisson'] },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'min_samples_split', component: ['input_number'], default: 2, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'rf-rgs': {
            name: 'RandomForestRegressor',
            import: 'from sklearn.ensemble import RandomForestRegressor',
            code: 'RandomForestRegressor(${n_estimators}${criterion}${max_depth}${min_samples_split}${n_jobs}${random_state}${etc})',
            options: [
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'criterion', component: ['option_select'], type: 'text', default: 'squared_error', type:'text', usePair: true,
                    options: ['squared_error', 'absolute_error', 'poisson'] },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'min_samples_split', component: ['input_number'], default: 2, usePair: true },
                { name: 'n_jobs', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'gbm-rgs': {
            name: 'GradientBoostingRegressor',
            import: 'from sklearn.ensemble import GradientBoostingRegressor',
            code: 'GradientBoostingRegressor(${loss}${learning_rate}${n_estimators}${criterion}${random_state}${etc})',
            options: [
                { name: 'loss', component: ['option_select'], type: 'text', default: 'squared_error', type:'text', usePair: true,
                    options: ['squared_error', 'absolute_error', 'huber', 'quantile'] },
                { name: 'learning_rate', component: ['input_number'], default: 0.1, usePair: true },
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'criterion', component: ['option_select'], type: 'text', default: 'friedman_mse', type:'text', usePair: true,
                    options: ['friedman_mse', 'squared_error', 'mse', 'mae'] },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'xgb-rgs': {
            name: 'XGBRegressor',
            install: '!pip install xgboost',
            import: 'from xgboost import XGBRegressor',
            code: 'XGBRegressor(${n_estimators}${max_depth}${learning_rate}${gamma}${random_state}${etc})',
            options: [
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'learning_rate', component: ['input_number'], placeholder: 0.1, usePair: true },
                { name: 'gamma', component: ['input_number'], placeholder: 0.1, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'lgbm-rgs': {
            name: 'LGBMRegressor',
            install: '!pip install lightgbm',
            import: 'from lightgbm import LGBMRegressor',
            code: 'LGBMRegressor(${boosting_type}${max_depth}${learning_rate}${n_estimators}${random_state}${etc})',
            options: [
                { name: 'boosting_type', component: ['option_select'], type: 'text', default: 'gbdt', type: 'text', usePair: true,
                    options: ['gbdt', 'dart', 'goss', 'rf']},
                { name: 'max_depth', component: ['input_number'], placeholder: '-1', usePair: true },
                { name: 'learning_rate', component: ['input_number'], default: 0.1, usePair: true },
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },  
        'cb-rgs': {
            name: 'CatBoostRegressor',
            install: '!pip install catboost',
            import: 'from catboost import CatBoostRegressor',
            code: 'CatBoostRegressor(${learning_rate}${loss_function}${task_type}${max_depth}${n_estimators}${random_state}${etc})',
            options: [
                { name: 'learning_rate', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'loss_function', component: ['option_select'], type: 'text', default: 'RMSE', type:'text', usePair: true,
                    options: ['RMSE', 'absolute_error', 'huber', 'quantile'] },
                { name: 'task_type', component: ['option_select'], type: 'text', default: 'CPU', usePair: true,
                    options: ['CPU', 'GPU'] },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'n_estimators', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        /** Classification */
        'lg-rgs': {
            name: 'LogisticRegression',
            import: 'from sklearn.linear_model import LogisticRegression',
            code: 'LogisticRegression(${penalty}${C}${random_state}${etc})',
            options: [
                { name: 'penalty', component: ['option_select'], type: 'text', default: 'l2', usePair: true, options: ['l1', 'l2', 'elasticnet', 'none']},
                { name: 'C', component: ['input_number'], placeholder: '1.0', usePair: true, step: 0.1, min: 0 },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'bern-nb': {
            name: 'BernoulliNB',
            import: 'from sklearn.naive_bayes import BernoulliNB',
            code: 'BernoulliNB(${etc})',
            options: [
                //TODO:
            ]
        },
        'mulnom-nb': {
            name: 'MultinomialNB',
            import: 'from sklearn.naive_bayes import MultinomialNB',
            code: 'MultinomialNB(${etc})',
            options: [
                //TODO:
            ]
        },
        'gaus-nb': {
            name: 'GaussianNB',
            import: 'from sklearn.naive_bayes import GaussianNB',
            code: 'GaussianNB(${etc})',
            options: [
                //TODO:
            ]
        },
        'sv-clf': {
            name: 'SVC',
            import: 'from sklearn.svm import SVC',
            code: 'SVC(${C}${kernel}${degree}${gamma}${coef0}${random_state}${etc})',
            options: [
                { name: 'C', component: ['input_number'], placeholder: '1.0', usePair: true, step: 0.1, min: 0 },
                { name: 'kernel', component: ['option_select'], type: 'text', usePair: true, 
                    options: ['linear', 'poly', 'rbf', 'sigmoid', 'precomputed'], default: 'rbf' },
                { name: 'degree', component: ['input_number'], placeholder: '3', usePair: true },
                { name: 'gamma', component: ['option_suggest'], usePair: true,
                    options: ["'scale'", "'auto'"], default: "'scale'" },
                { name: 'coef0', component: ['input_number'], placeholder: '0.0', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'dt-clf': {
            name: 'DecisionTreeClassifier',
            import: 'from sklearn.tree import DecisionTreeClassifier',
            code: 'DecisionTreeClassifier(${criterion}${max_depth}${min_samples_split}${random_state}${etc})',
            options: [
                { name: 'criterion', component: ['option_select'], type: 'text', default: 'squared_error', type:'text',
                    options: ['squared_error', 'friedman_mse', 'absolute_error', 'poisson'], usePair: true },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'min_samples_split', component: ['input_number'], default: 2, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'rf-clf': {
            name: 'RandomForestClassifier',
            import: 'from sklearn.ensemble import RandomForestClassifier',
            code: 'RandomForestClassifier(${n_estimators}${criterion}${max_depth}${min_samples_split}${n_jobs}${random_state}${etc})',
            options: [
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'criterion', component: ['option_select'], type: 'text', default: 'gini', type:'text', usePair: true,
                    options: ['gini', 'entropy'] },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'min_samples_split', component: ['input_number'], default: 2, usePair: true },
                { name: 'n_jobs', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'gbm-clf': {
            name: 'GradientBoostingClassifier',
            import: 'from sklearn.ensemble import GradientBoostingClassifier',
            code: 'GradientBoostingClassifier(${loss}${learning_rate}${n_estimators}${criterion}${random_state}${etc})',
            options: [
                { name: 'loss', component: ['option_select'], type: 'text', default: 'deviance', type: 'text', usePair: true,
                    options: ['deviance', 'exponential'] },
                { name: 'learning_rate', component: ['input_number'], default: 0.1, usePair: true },
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'criterion', component: ['option_select'], type: 'text', default: 'friedman_mse', type:'text', usePair: true,
                    options: ['friedman_mse', 'squared_error', 'mse', 'mae'] },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'xgb-clf': {
            name: 'XGBClassifier',
            install: '!pip install xgboost',
            import: 'from xgboost import XGBClassifier',
            code: 'XGBClassifier(${n_estimators}${max_depth}${learning_rate}${gamma}${random_state}${etc})',
            options: [
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'learning_rate', component: ['input_number'], placeholder: 0.1, usePair: true },
                { name: 'gamma', component: ['input_number'], placeholder: 0.1, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'lgbm-clf': {
            name: 'LGBMClassifier',
            install: '!pip install lightgbm',
            import: 'from lightgbm import LGBMClassifier',
            code: 'LGBMClassifier(${boosting_type}${max_depth}${learning_rate}${n_estimators}${random_state}${etc})',
            options: [
                { name: 'boosting_type', component: ['option_select'], type: 'text', default: 'gbdt', type: 'text', usePair: true,
                    options: ['gbdt', 'dart', 'goss', 'rf']},
                { name: 'max_depth', component: ['input_number'], placeholder: '-1', usePair: true },
                { name: 'learning_rate', component: ['input_number'], default: 0.1, usePair: true },
                { name: 'n_estimators', component: ['input_number'], default: 100, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },  
        'cb-clf': {
            name: 'CatBoostClassifier',
            install: '!pip install catboost',
            import: 'from catboost import CatBoostClassifier',
            code: 'CatBoostClassifier(${learning_rate}${loss_function}${task_type}${max_depth}${n_estimators}${random_state}${etc})',
            options: [
                { name: 'learning_rate', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'loss_function', component: ['option_select'], type: 'text', default: 'RMSE', type:'text', usePair: true,
                    options: ['RMSE', 'absolute_error', 'huber', 'quantile'] },
                { name: 'task_type', component: ['option_select'], type: 'text', default: 'CPU', usePair: true,
                    options: ['CPU', 'GPU'] },
                { name: 'max_depth', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'n_estimators', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        /** Auto ML */
        'auto-sklearn-rgs': {
            name: 'AutoSklearnRegressor (Linux only)',
            install: '!pip install auto-sklearn',
            import: 'from autosklearn.regression import AutoSklearnRegressor',
            link: 'https://automl.github.io/auto-sklearn/master/api.html#regression',
            code: 'AutoSklearnRegressor(${etc})',
            options: [
                
            ]
        },
        'tpot-rgs': {
            name: 'TPOTRegressor',
            install: '!pip install tpot',
            import: 'from tpot import TPOTRegressor',
            code: 'TPOTRegressor(${generation}${population_size}${cv}${random_state}${etc})',
            options: [
                { name: 'generation', component: ['input_number'], default: 100, usePair: true },
                { name: 'population_size', component: ['input_number'], default: 100, usePair: true },
                { name: 'cv', component: ['input_number'], default: 5, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'auto-sklearn-clf': {
            name: 'AutoSklearnClassifier (Linux only)',
            install: '!pip install auto-sklearn',
            import: 'from autosklearn.classification import AutoSklearnClassifier',
            link: 'https://automl.github.io/auto-sklearn/master/api.html#classification',
            code: 'AutoSklearnClassifier(${etc})',
            options: [
                
            ]
        },
        'tpot-clf': {
            name: 'TPOTClassifier',
            install: '!pip install tpot',
            import: 'from tpot import TPOTClassifier',
            code: 'TPOTClassifier(${generation}${population_size}${cv}${random_state}${etc})',
            options: [
                { name: 'generation', component: ['input_number'], default: 100, usePair: true },
                { name: 'population_size', component: ['input_number'], default: 100, usePair: true },
                { name: 'cv', component: ['input_number'], default: 5, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        /** Clustering */
        'k-means': {
            name: 'KMeans',
            import: 'from sklearn.cluster import KMeans',
            code: 'KMeans(${n_clusters}${random_state}${etc})',
            options: [
                { name: 'n_clusters', component: ['input_number'], default: 8, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'agg-cls': {
            name: 'AgglomerativeClustering',
            import: 'from sklearn.cluster import AgglomerativeClustering',
            code: 'AgglomerativeClustering(${n_clusters}${random_state}${etc})',
            options: [
                { name: 'n_clusters', component: ['input_number'], default: 2, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'gaus-mix': {
            name: 'GaussianMixture',
            import: 'from sklearn.mixture import GaussianMixture',
            code: 'GaussianMixture(${n_components}${random_state}${etc})',
            options: [
                { name: 'n_components', component: ['input_number'], default: 1, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'dbscan': {
            name: 'DBSCAN',
            import: 'from sklearn.cluster import DBSCAN',
            code: 'DBSCAN(${eps}${min_samples}${etc})',
            options: [
                { name: 'eps', component: ['input_number'], default: 0.5, usePair: true },
                { name: 'min_samples', component: ['input_number'], default: 5, usePair: true }
            ]
        },
        /** Dimension Reduction */
        'pca': {
            name: 'PCA(Principal Component Analysis)',
            import: 'from sklearn.decomposition import PCA',
            code: 'PCA(${n_components}${random_state}${etc})',
            options: [
                { name: 'n_components', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'lda': {
            name: 'LDA(Linear Discriminant Analysis)',
            import: 'from sklearn.discriminant_analysis import LinearDiscriminantAnalysis',
            code: 'LinearDiscriminantAnalysis(${n_components}${etc})',
            options: [
                { name: 'n_components', component: ['input_number'], placeholder: 'None', usePair: true }
            ]
        },
        'svd': {
            name: 'Truncated SVD',
            import: 'from sklearn.decomposition import TruncatedSVD',
            code: 'TruncatedSVD(${n_components}${random_state}${etc})',
            options: [
                { name: 'n_components', component: ['input_number'], default: 2, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'nmf': {
            name: 'NMF(Non-Negative Matrix Factorization)',
            import: 'from sklearn.decomposition import NMF',
            code: 'NMF(${n_components}${random_state}${etc})',
            options: [
                { name: 'n_components', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        },
        'tsne': {
            name: 'TSNE(T-distributed Stochastic Neighbor Embedding)',
            import: 'from sklearn.manifold import TSNE',
            code: 'TSNE(${n_components}${learning_rate}${random_state}${etc})',
            options: [
                { name: 'n_components', component: ['input_number'], placeholder: 'None', usePair: true },
                { name: 'learning_rate', component: ['input_number'], default: 200.0, usePair: true },
                { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true }
            ]
        }
    }

    return ML_LIBRARIES;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/data/m_visualize/plotlyLibrary.js":
/*!************************************************************!*\
  !*** ./lib/visualpython/data/m_visualize/plotlyLibrary.js ***!
  \************************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    /**
     * name
     * library
     * description
     * code
     * options: [
     *      {
     *          name
     *          label
     *          [optional]
     *          component : 
     *              - 1darr / 2darr / ndarr / scalar / param / dtype / tabblock
     *          default
     *          required
     *          usePair
     *          code
     *      }
     * ]
     */
    var PLOTLY_LIBRARIES = {
        //========================================================================
        // Basics
        //========================================================================
        'scatter': {
            name: 'Scatter Plot',
            code: '${allocateTo} = px.scatter(${data}${x}${y}${color}${etc})',
            description: 'Draw a scatter plot with possibility of several semantic groupings.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'line': {
            name: 'Line Plot',
            code: '${allocateTo} = px.line(${data}${x}${y}${color}${etc})',
            description: 'Draw a line plot with possibility of several semantic groupings.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'area': {
            name: 'Line Plot',
            code: '${allocateTo} = px.area(${data}${x}${y}${color}${etc})',
            description: 'Draw a area plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'bar': {
            name: 'Bar Plot',
            code: '${allocateTo} = px.bar(${data}${x}${y}${color}${etc})',
            description: 'Draw a bar plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'funnel': {
            name: 'Funnel Plot',
            code: '${allocateTo} = px.funnel(${data}${x}${y}${color}${etc})',
            description: 'Draw a funnel plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'timeline': {
            name: 'Timeline Plot',
            code: '${allocateTo} = px.timeline(${data}${x_start}${x_end}${y}${color}${etc})',
            description: 'Draw a timeline plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x_start', label: 'X start', component: ['col_select'], usePair: true },
                { name: 'x_end', label: 'X end', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        //========================================================================
        // Part-of-Whole
        //========================================================================
        'pie': {
            name: 'Pie Plot',
            code: '${allocateTo} = px.pie(${data}${values}${names}${color}${etc})',
            description: 'Draw a pie plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'values', label: 'Values', component: ['col_select'], usePair: true },
                { name: 'names', label: 'Names', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'sunburst': {
            name: 'Sunburst',
            code: '${allocateTo} = px.sunburst(${data}${values}${names}${color}${parents}${path}${etc})',
            description: 'Draw a sunburst plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'values', label: 'Values', component: ['col_select'], usePair: true },
                { name: 'names', label: 'Names', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'parents', label: 'Parents', component: ['col_select'], usePair: true },
                { name: 'path', label: 'Path', component: ['data_select'], var_type: ['ndarray', 'list'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'treemap': {
            name: 'Treemap',
            code: '${allocateTo} = px.treemap(${data}${values}${names}${color}${parents}${path}${etc})',
            description: 'Draw a treemap plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'values', label: 'Values', component: ['col_select'], usePair: true },
                { name: 'names', label: 'Names', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'parents', label: 'Parents', component: ['col_select'], usePair: true },
                { name: 'path', label: 'Path', component: ['data_select'], var_type: ['ndarray', 'list'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'icicle': {
            name: 'Icicle',
            code: '${allocateTo} = px.icicle(${data}${values}${names}${color}${parents}${path}${etc})',
            description: 'Draw a icicle plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'values', label: 'Values', component: ['col_select'], usePair: true },
                { name: 'names', label: 'Names', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'parents', label: 'Parents', component: ['col_select'], usePair: true },
                { name: 'path', label: 'Path', component: ['data_select'], var_type: ['ndarray', 'list'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'funnel_area': {
            name: 'Funnel area',
            code: '${allocateTo} = px.funnel_area(${data}${values}${names}${color}${etc})',
            description: 'Draw a funnel area.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'values', label: 'Values', component: ['col_select'], usePair: true },
                { name: 'names', label: 'Names', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        //========================================================================
        // 1D Distributions
        //========================================================================
        'histogram': {
            name: 'Histogram',
            code: '${allocateTo} = px.histogram(${data}${x}${y}${color}${etc})',
            description: 'Draw a histogram plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'box': {
            name: 'Box plot',
            code: '${allocateTo} = px.box(${data}${x}${y}${color}${etc})',
            description: 'Draw a box plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'violin': {
            name: 'Violin plot',
            code: '${allocateTo} = px.violin(${data}${x}${y}${color}${etc})',
            description: 'Draw a violin plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'strip': {
            name: 'Strip plot',
            code: '${allocateTo} = px.strip(${data}${x}${y}${color}${etc})',
            description: 'Draw a strip plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'ecdf': {
            name: 'Ecdf plot',
            code: '${allocateTo} = px.ecdf(${data}${x}${y}${color}${etc})',
            description: 'Draw a ecdf plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        //========================================================================
        // 2D Distributions
        //========================================================================
        'density_heatmap': {
            name: 'Density heatmap',
            code: '${allocateTo} = px.density_heatmap(${data}${x}${y}${z}${etc})',
            description: 'Draw a density heatmap plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'z', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'density_contour': {
            name: 'Density contour',
            code: '${allocateTo} = px.density_contour(${data}${x}${y}${z}${color}${etc})',
            description: 'Draw a density contour plot.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'z', component: ['col_select'], usePair: true },
                { name: 'color', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        //========================================================================
        // Matrix or Image Input
        //========================================================================
        'imshow': {
            name: 'Imshow',
            code: '${allocateTo} = px.imshow(${data}${x}${y}${origin}${etc})', // zmin, zmax, origin
            description: 'Display an image, i.e. data on a 2D regular raster.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'] },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'origin', label: 'Origin', component: ['option_select'], options: ['upper', 'lower'], default: 'upper', usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        //========================================================================
        // 3-Dimensional
        //========================================================================

        //========================================================================
        // Mutidimensional
        //========================================================================

        //========================================================================
        // Tile Maps
        //========================================================================

        //========================================================================
        // Outline Maps
        //========================================================================

        //========================================================================
        // Polar Charts
        //========================================================================

        //========================================================================
        // Ternary Charts
        //========================================================================

    }

    return PLOTLY_LIBRARIES;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/data/m_visualize/seabornLibrary.js":
/*!*************************************************************!*\
  !*** ./lib/visualpython/data/m_visualize/seabornLibrary.js ***!
  \*************************************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    /**
     * name
     * library
     * description
     * code
     * options: [
     *      {
     *          name
     *          label
     *          [optional]
     *          component : 
     *              - 1darr / 2darr / ndarr / scalar / param / dtype / tabblock
     *          default
     *          required
     *          usePair
     *          code
     *      }
     * ]
     */
    var SEABORN_LIBRARIES = {
        /** Relational plots */
        'scatterplot': {
            name: 'Scatter Plot',
            code: '${allocateTo} = sns.scatterplot(${data}${x}${y}${hue}${etc})',
            description: 'Draw a scatter plot with possibility of several semantic groupings.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'lineplot': {
            name: 'Line Plot',
            code: '${allocateTo} = sns.lineplot(${data}${x}${y}${hue}${etc})',
            description: 'Draw a line plot with possibility of several semantic groupings.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        /** Distribution plots */
        'histplot': {
            name: 'Histogram Plot',
            code: '${allocateTo} = sns.histplot(${data}${x}${y}${hue}${bins}${kde}${stat}${etc})',
            description: 'Plot univariate or bivariate histograms to show distributions of datasets.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'bins', component: ['input_number'], usePair: true },
                { name: 'kde', component: ['option_select'], usePair: true },
                { name: 'stat', component: ['bool_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'kdeplot': {
            name: 'Kernel Density Plot',
            code: '${allocateTo} = sns.kdeplot(${data}${x}${y}${hue}${etc})',
            description: 'Plot univariate or bivariate distributions using kernel density estimation.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'rugplot': {
            name: 'Rug Plot',
            code: '${allocateTo} = sns.rugplot(${data}${x}${y}${hue}${etc})',
            description: 'Plot marginal distributions by drawing ticks along the x and y axes.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        /** Categorical plots */
        'stripplot': {
            name: 'Strip Plot',
            code: '${allocateTo} = sns.stripplot(${data}${x}${y}${hue}${etc})',
            description: 'Draw a scatterplot where one variable is categorical.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'swarmplot': {
            name: 'Swarm Plot',
            code: '${allocateTo} = sns.swarmplot(${data}${x}${y}${hue}${etc})',
            description: 'Draw a categorical scatterplot with non-overlapping points.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'boxplot': {
            name: 'Box Plot',
            code: '${allocateTo} = sns.boxplot(${data}${x}${y}${hue}${etc})',
            description: 'Draw a box plot to show distributions with respect to categories.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'violinplot': {
            name: 'Violin Plot',
            code: '${allocateTo} = sns.violinplot(${data}${x}${y}${hue}${etc})',
            description: 'Draw a combination of boxplot and kernel density estimate.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'pointplot': {
            name: 'Point Plot',
            code: '${allocateTo} = sns.pointplot(${data}${x}${y}${hue}${etc})',
            description: 'Show point estimates and confidence intervals using scatter plot glyphs.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'barplot': {
            name: 'Bar Plot',
            code: '${allocateTo} = sns.barplot(${data}${x}${y}${hue}${etc})',
            description: 'Show point estimates and confidence intervals as rectangular bars.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        },
        'countplot': {
            name: 'Count Plot',
            code: '${allocateTo} = sns.countplot(${data}${x}${y}${hue}${etc})',
            description: 'Show the counts of observations in each categorical bin using bars.',
            options: [
                { name: 'data', component: ['var_select'], var_type: ['DataFrame', 'Series', 'list'], usePair: true },
                { name: 'x', component: ['col_select'], usePair: true },
                { name: 'y', component: ['col_select'], usePair: true },
                { name: 'hue', component: ['col_select'], usePair: true },
                { name: 'allocateTo', label: 'Allocate To', component: ['input'], usePair: true }
            ]
        }
    }

    return SEABORN_LIBRARIES;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/MainFrame.js":
/*!******************************************!*\
  !*** ./lib/visualpython/js/MainFrame.js ***!
  \******************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : MainFrame.js
 *    Author          : Black Logic
 *    Note            : Render and load main frame
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 13
 *    Change Date     :
 */

//============================================================================
// Load main frame
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/mainFrame.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/mainFrame.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/mainFrame.css */ "./lib/visualpython/css/mainFrame.css"), // INTEGRATION: unified version of css loader

    // load module
    __webpack_require__(/*! ./com/com_Config */ "./lib/visualpython/js/com/com_Config.js"),
    __webpack_require__(/*! ./com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! ./com/com_Event */ "./lib/visualpython/js/com/com_Event.js"),
    __webpack_require__(/*! ./com/component/PopupComponent */ "./lib/visualpython/js/com/component/PopupComponent.js"),
    __webpack_require__(/*! ./menu/MenuFrame */ "./lib/visualpython/js/menu/MenuFrame.js"),
    __webpack_require__(/*! ./board/BoardFrame */ "./lib/visualpython/js/board/BoardFrame.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(vpHtml, vpCss, com_Config, com_Const, com_Event, PopupComponent, 
            MenuFrame, BoardFrame) {
	'use strict';

    // visualpython minimum width
    const { 
        JUPYTER_HEADER_SPACING,
        VP_MIN_WIDTH, 
        MENU_MIN_WIDTH,
        BOARD_MIN_WIDTH,
        MENU_BOARD_SPACING
    } = com_Config;

    const { 
        TOOLBAR_BTN_INFO,
        JUPYTER_NOTEBOOK_ID,
        JUPYTER_HEADER_ID
    } = com_Const;

    class MainFrame {
        constructor() {
            this.$pageDom = null;
            this._menuFrame = null;
            this._boardFrame = null;
            this._nowTask = null;
            this._focusedPage = null;
            
            // Task bar options list
            this._taskPopupList = [];
            this._blockPopupList = [];

            // page info
            this.minWidth = VP_MIN_WIDTH;
            this.width = VP_MIN_WIDTH;
        }
        //========================================================================
        // Internal call function
        //========================================================================
        /**
         * Bind event for inner components under vp_wrapper
         */
        _bindEvent() {
            var that = this;

            // window resize event
            $(window).resize(function(evt){
                that._resizeWindow();
            });

            // CHROME: colab header toggle
            if (vpConfig.extensionType === 'colab') {
                $('#toggle-header-button').click(function(evt) {
                    console.log('[vp] click toggle header ')
                    // change height
                    let colabHeaderVisible = $('#header').is(':visible');
                    let colabHeaderHeight = $('#header').height() * colabHeaderVisible;
                    let colabFooterHeight = $('colab-status-bar').height();

                    let colabHeight = colabHeaderHeight + colabFooterHeight + 2;

                    $('#vp_wrapper').css( { 
                        height:  'calc(100% - ' + colabHeight + 'px)',
                        top: colabHeaderHeight + 'px' 
                    });
                });
            }

            window.vpEvent = new com_Event(this);
        }

        /**
         * Bind $.resizable event
         * // TODO: get a param to re-position vp_wrapper to the left or right
         */
        _bindResizable() {
            var that = this;

            // get visualpython minimum width
            // resizable setting
            // $('#vp_wrapper').resizable('disable');
            if (vpConfig.extensionType !== 'lab') {
                $('#vp_wrapper').resizable({
                    // alsoResize: '#vp_menuFrame',
                    helper: 'vp-wrapper-resizer',
                    handles: 'w',
                    // resizeHeight: false,
                    minWidth: this.minWidth,
                    // maxWidth: 0,
                    start: function(event, ui) {
                        
                    },
                    resize: function(event, ui) {
                        // resize #vp_wrapper with currentWidth and resize jupyter area
                        var currentWidth = ui.size.width;
                        that._resizeVp(currentWidth);
                    },
                    stop: function(event, ui) {
                        $('#vp_wrapper').css({'left': '', 'height': ''});
                    }
                });  
            }
        }

        _resizeWindow() {
            // CHROME: resize colab
            if (vpConfig.extensionType === 'notebook') {
                let jupyterHeadHeight = $('#' + JUPYTER_HEADER_ID).height();
                let jupyterBodyHeight = $('#' + JUPYTER_NOTEBOOK_ID).height();

                let vpWidth = $('#vp_wrapper')[0].getBoundingClientRect().width;
                let vpHeight = $(window).height() - jupyterHeadHeight;

                $('#vp_wrapper').css( { height: vpHeight + 'px' });
                this._resizeNotebook(vpWidth);
            } else if (vpConfig.extensionType === 'colab') {
                let colabHeaderVisible = $('#header').is(':visible');
                let colabHeaderHeight = $('#header').height() * colabHeaderVisible;
                let colabFooterHeight = $('colab-status-bar').height();

                let colabHeight = colabHeaderHeight + colabFooterHeight + 2;

                let vpWidth = $('#vp_wrapper')[0].getBoundingClientRect().width;

                $('#vp_wrapper').css( { 
                    height:  'calc(100% - ' + colabHeight + 'px)',
                    top: colabHeaderHeight + 'px'
                });
                this._resizeNotebook(vpWidth);
            } else if (vpConfig.extensionType === 'lab') {
                // LAB: do nothing
            }
        }

        _resizeVp(currentWidth) {
            // calculate inner frame width
            var menuWidth = $('#vp_menuFrame').width();
            var boardWidth = 0;
            var showBoard = $('#vp_boardFrame').is(':visible');
            if (showBoard) {
                boardWidth = currentWidth - menuWidth - MENU_BOARD_SPACING;
                if (boardWidth < BOARD_MIN_WIDTH + MENU_BOARD_SPACING) {
                    boardWidth = BOARD_MIN_WIDTH;
                    menuWidth = currentWidth - (BOARD_MIN_WIDTH + MENU_BOARD_SPACING);
                }
            } else {
                // resize menuWidth if board is hidden
                menuWidth = currentWidth - MENU_BOARD_SPACING;
            }
            $('#vp_menuFrame').width(menuWidth);
            $('#vp_boardFrame').width(boardWidth);

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'resizing wrapper to ', currentWidth, 'with', menuWidth, boardWidth);

            $('#vp_wrapper').width(currentWidth);

            // save current page info
            vpConfig.setMetadata({
                vp_position: { width: currentWidth },
                vp_menu_width: menuWidth,
                vp_note_width: boardWidth
            });

            this._resizeNotebook(currentWidth);
        }

        /**
         * Resize jupyternotebook
         */
        _resizeNotebook(vpWidth) {
            let baseWidth = $(window).width();

            // manual padding between notebook and visualpython area
            const DIV_PADDING = 2;
            // if vp area is available, add padding
            if (vpWidth > 0) {
                vpWidth += DIV_PADDING;
            }
            // calculate notebook resizing width
            let nbWidth = baseWidth - vpWidth;
            let nbContainerWidth = nbWidth - 60;
            // apply resized width
            // CHROME: resize colab
            if (vpConfig.extensionType === 'notebook') {
                $('#' + JUPYTER_NOTEBOOK_ID).css({ 'width': nbWidth + 'px' });
                $('#notebook-container').css({ 'width': nbContainerWidth + 'px' });
            } else if (vpConfig.extensionType === 'colab') {
                $('.notebook-horizontal').css({ 'width': nbWidth + 'px' });
                // $('#notebook-container').css({ 'width': nbContainerWidth + 'px' });
            }
        }

        _getMenuGroupRootType(menu) {
            // ex) visualpython - apps - frame
            let path = menu.path;
            let pathList = path.split(' - ');
            return pathList[1];
        }

        //========================================================================
        // External call function
        //========================================================================
        renderMainFrame() {
            this.$pageDom = $(vpHtml);
            this.$pageDom.addClass(vpConfig.extensionType);
            return this.$pageDom;
        }
        afterAttach() {
            // set vp width using metadata
            let metadata = vpConfig.getMetadata();
            let { vp_position, vp_note_display, vp_menu_width, vp_note_width } = metadata;
            if (vp_position) {
                $('#vp_wrapper').width(vp_position.width);
            }

            if (!vp_note_display) {
                this.minWidth = MENU_MIN_WIDTH + MENU_BOARD_SPACING;
            }
            
            // load menu & board
            this._menuFrame = new MenuFrame($('#vp_wrapper'), 
                { vp_menu_width: vp_menu_width }, 
                { parent: this }
            );
            this._boardFrame = new BoardFrame($('#vp_wrapper'), 
                { vp_note_display: vp_note_display, vp_note_width: vp_note_width }, 
                { parent: this }
            );
            
            // consider height and width
            this._resizeWindow();
            
            // bind event
            this._bindEvent();
            this._bindResizable();
        }
        /**
         * Load main frame
         */
        loadMainFrame() {
            // load vp_wrapper into jupyter base
            this.renderMainFrame();
            
            // prepend
            $(this.$pageDom).prependTo(document.body);

            this.afterAttach();

            return this.$pageDom;
        }

        toggleVp() {
            let vpDisplay = $('#vp_wrapper').is(':visible');
            let vpWidth = $('#vp_wrapper')[0].clientWidth;

            let metadata = vpConfig.getMetadata();
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'toggle vp with metadata', metadata);
            let { vp_position, vp_menu_width, vp_note_width, vp_note_display } = metadata;
            let newMetadata = { vp_section_display: !vpDisplay };
            if (vpDisplay) {
                // hide
                vpWidth = 0;
                $('#vp_wrapper').hide();
            } else {
                // show
                if (!vp_position || vp_position.width <= 0) {
                    vpWidth = (vp_menu_width + vp_note_width + MENU_BOARD_SPACING);
                    if (!vpWidth) {
                        vpWidth = com_Config.MENU_MIN_WIDTH + (vp_note_display? com_Config.BOARD_MIN_WIDTH: 0) + com_Config.MENU_BOARD_SPACING;
                    }
                    newMetadata['vp_position'] = { width: vpWidth };
                    $('#vp_wrapper').css({ width: vpWidth });
                } else {
                    vpWidth = vp_position.width;
                }
                $('#vp_wrapper').show();
            }

            // set current width
            vpConfig.setMetadata(newMetadata);

            this._resizeNotebook(vpWidth);

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'vp toggled');
        }

        openVp() {
            $('#vp_wrapper').show();

            if ($('#vp_wrapper').length > 0) {
                let vpWidth = $('#vp_wrapper')[0].clientWidth;
                this._resizeNotebook(vpWidth);
            }

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'vp opened');
        }

        //========================================================================
        // Child components control function
        //========================================================================

        toggleNote() {
            let vpWidth = $('#vp_wrapper')[0].getBoundingClientRect().width;
            let newVpWidth = vpWidth;
            let menuWidth = $('#vp_menuFrame')[0].getBoundingClientRect().width;

            let isNoteVisible = $('#vp_boardFrame').is(':visible');
            if (isNoteVisible) {
                // hide note
                this.boardFrame.hide();
                newVpWidth = menuWidth + MENU_BOARD_SPACING;
                $('#vp_wrapper').width(newVpWidth);
                if (vpConfig.extensionType === 'lab') {
                    // LAB: set parent width and position, min-width
                    let target = $('#vp_wrapper').parent();
                    let prevWidth = target[0].getBoundingClientRect().width;
                    let prevLeft = $(target).position().left;
                    let widthDiff = newVpWidth - vpWidth;
                    $(target).css({
                        width: prevWidth + widthDiff,
                        left: prevLeft - widthDiff
                    });
                    $('#vp_wrapper').attr('style', `min-width: ${MENU_MIN_WIDTH + MENU_BOARD_SPACING}px !important`);
                    if (vpLab.shell.rightCollapsed == false) {
                        vpLab.shell.collapseRight();
                        vpLab.shell.expandRight();
                    }
                    let relativeSizes = vpLab.shell._hsplitPanel.layout.relativeSizes();
                    let absoluteSizes = vpLab.shell._hsplitPanel.layout.absoluteSizes();
                    let newSize = absoluteSizes[1] - widthDiff;
                    let totalWidth = absoluteSizes.reduce((x, a) => x + a, 0);
                    vpLab.shell._hsplitPanel.layout.setRelativeSizes([relativeSizes[0], newSize/totalWidth, newVpWidth/totalWidth]);
                } else {
                    $('#vp_wrapper').resizable({ minWidth: MENU_MIN_WIDTH + MENU_BOARD_SPACING });
                }
                this.menuFrame._unbindResizable();
                
            } else {
                // show note
                this.boardFrame.show();
                newVpWidth = vpWidth + BOARD_MIN_WIDTH + MENU_BOARD_SPACING;
                $('#vp_wrapper').width(newVpWidth);
                if (vpConfig.extensionType === 'lab') {
                    // LAB: set parent width and position, min-width
                    let target = $('#vp_wrapper').parent();
                    let prevWidth = target[0].getBoundingClientRect().width;
                    let prevLeft = $(target).position().left;
                    let widthDiff = newVpWidth - vpWidth;
                    $(target).css({
                        width: prevWidth + widthDiff,
                        left: prevLeft - widthDiff
                    });
                    $('#vp_wrapper').attr('style', `min-width: ${VP_MIN_WIDTH}px !important`);
                    if (vpLab.shell.rightCollapsed == false) {
                        vpLab.shell.collapseRight();
                        vpLab.shell.expandRight();
                    }
                    let relativeSizes = vpLab.shell._hsplitPanel.layout.relativeSizes();
                    let absoluteSizes = vpLab.shell._hsplitPanel.layout.absoluteSizes();
                    let newSize = absoluteSizes[1] - widthDiff;
                    let totalWidth = absoluteSizes.reduce((x, a) => x + a, 0);
                    vpLab.shell._hsplitPanel.layout.setRelativeSizes([relativeSizes[0], newSize/totalWidth, newVpWidth/totalWidth]);
                } else {
                    $('#vp_wrapper').resizable({ minWidth: VP_MIN_WIDTH });
                }
                this.menuFrame._bindResizable();
            }
            // save current page info
            vpConfig.setMetadata({
                // vp_note_display: !isNoteVisible, // save in boardFrame.show/hide()
                vp_position: { width: newVpWidth },
                vp_menu_width: menuWidth
            });

            this._resizeVp(newVpWidth);
        }

        /**
         * Create popup
         * @param {Array} popupStateList [{ menuId, menuState, blockType, position, createChild, afterAction }]
         * - {String} menuId
         * - {Object} menuState   : { blockState, taskState }
         * -------- optional parameters ---------------------------
         * - {String} blockType   : task / block
         * - {int}    position    : 0 ~ n
         * - {bool}   createChild : true / false
         * - {String} afterAction : run / add / open
         */
        createPopup(popupStateList) {
            // set popup state's default values
            let defaultPopupState = {
                blockType: 'task',
                position: this.blockPopupList.length,
                createChild: true,
                menuId: '',
                menuState: {}, // taskState, blockState
                afterAction: ''
            };
            let that = this;
            let loadMenuList = [];  // menu list to require
            let loadStateList = []; // menu state list
            // get menu configurations
            for (let i=0; i<popupStateList.length; i++) {
                let popupState = popupStateList[i];
                let menuConfig = this.menuFrame.getMenuLibrary(popupState.menuId);
                if (menuConfig) {
                    let fileName = menuConfig.file;
                    if (menuConfig.useAuto) {
                        // if useAuto is true, use LibraryComponent to auto-generate page
                        fileName = 'com/component/LibraryComponent';
                    }
                    if (menuConfig.useAutoV2) {
                        // FIXME: must merge LibraryComponent and NumpyComponent
                        fileName = 'com/component/NumpyComponent';
                    }
                    // add to menu list
                    let filePath = 'vp_base/js/' + fileName;
                    let menuArgIdx = loadMenuList.indexOf(filePath);
                    if (menuArgIdx < 0) {
                        loadMenuList.push(filePath);
                        menuArgIdx = loadMenuList.length - 1;
                    }
                    let tmpState = {};
                    Object.keys(defaultPopupState).forEach(key => {
                        if (popupState.hasOwnProperty(key) && popupState[key] != undefined) {
                            tmpState[key] = popupState[key];
                        } else {
                            tmpState[key] = defaultPopupState[key];
                        }
                    });
                    tmpState = {
                        ...tmpState,
                        file: fileName, // set fileName 
                        argIdx: menuArgIdx,
                        menuConfig: menuConfig
                    }
                    loadStateList.push(tmpState);
                    // if createChild, get childStateInfo
                    if (tmpState.blockType == 'block' && tmpState.createChild) {
                        let childStates = this.getChildState(tmpState.menuId, tmpState.position);
                        popupStateList.splice(i+1, 0, ...childStates);
                    }
                } else {
                    vpLog.display(VP_LOG_TYPE.ERROR, 'Menu is not found (menu id: '+popupState.menuId+')');
                }
            }

            try {
                // loading bar enable
                this.boardFrame.showLoadingBar();
                // create components
                // LAB: use require
                if (vpConfig.extensionType === 'lab') {
                    let parentBlock = null;
                    let prevBlock = null;
                    loadStateList.forEach(obj => {
                        let { blockType, menuId, menuState, menuConfig, argIdx, position, afterAction } = obj;
                        // get OptionComponent Object
                        // LAB: relative path needed
                        let OptionComponent = __webpack_require__("./lib/visualpython/js sync recursive ^\\.\\/.*$")("./" + menuConfig.file);
                        if (OptionComponent) {
                            let taskState = menuState.taskState;
                            let blockState = menuState.blockState;
                            let tmpState = menuState.tmpState;
                            let state = {
                                ...taskState,
                                config: menuConfig
                            };
                            // create popup instance
                            let popup = new OptionComponent(state);
                            let newBlock = null;
                            if (blockType === 'block') {
                                // add to block list
                                newBlock = that.addBlock(popup, position, blockState);
                                if (parentBlock == null) {
                                    parentBlock = newBlock; // set parent block of created block
                                } else {
                                    if (!(blockState && blockState.depth != undefined) && prevBlock != null && !newBlock.isGroup) {
                                        let newDepth = prevBlock.getChildDepth();
                                        if (tmpState && tmpState.relativeDepth) {
                                            newDepth = parentBlock.getChildDepth() + tmpState.relativeDepth;
                                        }
                                        newBlock.setDepth(newDepth);
                                    }
                                }
                                vpLog.display(VP_LOG_TYPE.DEVELOP, 'new block ' + position + ' with depth ' + newBlock.depth);
                                prevBlock = newBlock;
                            } else {
                                // add to task list
                                that.addTask(popup);
                            }
                            // after action
                            if (afterAction && afterAction != '') {
                                switch (afterAction) {
                                    case 'run':
                                        popup.run();
                                        break;
                                    case 'add':
                                        popup.run(false);
                                        break;
                                    case 'open':
                                        that.openPopup(popup);
                                        break;
                                }
                            }
                        } else {
                            vpLog.display(VP_LOG_TYPE.ERROR, 'Not implemented or available menu. (menu id: '+menuConfig.id+')');
                        }
                    });
                    // focus created popup
                    if (parentBlock && parentBlock.isGroup) {
                        parentBlock.focusItem();
                        // scroll to new block
                        that.boardFrame.scrollToBlock(parentBlock);
                    }
                    that.boardFrame.hideLoadingBar();
                    that.boardFrame.reloadBlockList();
                } else {
                    window.require(loadMenuList, function() {
                        let parentBlock = null;
                        let prevBlock = null;
                        loadStateList.forEach(obj => {
                            let { blockType, menuId, menuState, menuConfig, argIdx, position, afterAction } = obj;
                            // get OptionComponent Object
                            let OptionComponent = arguments[argIdx];
                            if (OptionComponent) {
                                let taskState = menuState.taskState;
                                let blockState = menuState.blockState;
                                let tmpState = menuState.tmpState;
                                let state = {
                                    ...taskState,
                                    config: menuConfig
                                };
                                // create popup instance
                                let popup = new OptionComponent(state);
                                let newBlock = null;
                                if (blockType === 'block') {
                                    // add to block list
                                    newBlock = that.addBlock(popup, position, blockState);
                                    if (parentBlock == null) {
                                        parentBlock = newBlock; // set parent block of created block
                                    } else {
                                        if (!(blockState && blockState.depth != undefined) && prevBlock != null && !newBlock.isGroup) {
                                            let newDepth = prevBlock.getChildDepth();
                                            if (tmpState && tmpState.relativeDepth) {
                                                newDepth = parentBlock.getChildDepth() + tmpState.relativeDepth;
                                            }
                                            newBlock.setDepth(newDepth);
                                        }
                                    }
                                    vpLog.display(VP_LOG_TYPE.DEVELOP, 'new block ' + position + ' with depth ' + newBlock.depth);
                                    prevBlock = newBlock;
                                } else {
                                    // add to task list
                                    that.addTask(popup);
                                }
                                // after action
                                if (afterAction && afterAction != '') {
                                    switch (afterAction) {
                                        case 'run':
                                            popup.run();
                                            break;
                                        case 'add':
                                            popup.run(false);
                                            break;
                                        case 'open':
                                            that.openPopup(popup);
                                            break;
                                    }
                                }
                            } else {
                                vpLog.display(VP_LOG_TYPE.ERROR, 'Not implemented or available menu. (menu id: '+menuConfig.id+')');
                            }
                        });
                        // focus created popup
                        if (parentBlock && parentBlock.isGroup) {
                            parentBlock.focusItem();
                            // scroll to new block
                            that.boardFrame.scrollToBlock(parentBlock);
                        }
                        that.boardFrame.hideLoadingBar();
                        that.boardFrame.reloadBlockList();
                    }, function (err) {
                        vpLog.display(VP_LOG_TYPE.ERROR, 'Error on creating popup (' + err.message + ')');
                        that.boardFrame.hideLoadingBar();
                    });
                }
                
            } catch(err) {
                vpLog.display(VP_LOG_TYPE.ERROR, 'Error on creating popup (' + err.message + ')');
                that.boardFrame.hideLoadingBar();
            }
        }

        getChildState(parentId, position) {
            let menuId = parentId;
            let childBlocks = [];
            switch (menuId) {
                case 'lgDef_class':
                    childBlocks = [
                        { 
                            menuId: 'lgDef_def', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                },
                                taskState: {
                                    v1: '__init__', 
                                    v2: [{ param: 'self' }] 
                                }
                            }
                        },
                        { 
                            menuId: 'lgExe_code', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                }
                            }
                        },
                        { 
                            menuId: 'lgCtrl_return', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                }
                            }
                        }
                    ]
                    break;
                case 'lgDef_def':
                    childBlocks = [
                        { 
                            menuId: 'lgExe_code', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                }
                            }
                        },
                        { 
                            menuId: 'lgCtrl_return', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                }
                            }
                        }
                    ]
                    break;
                case 'lgCtrl_try':
                    childBlocks = [
                        { 
                            menuId: 'lgCtrl_pass', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                }
                            }
                        },
                        { 
                            menuId: 'lgCtrl_except', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                },
                                tmpState: {
                                    relativeDepth: -1
                                }
                            }
                        },
                        { 
                            menuId: 'lgCtrl_pass', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                }
                            }
                        }

                    ];
                    break;
                case 'lgCtrl_for':
                case 'lgCtrl_while':
                case 'lgCtrl_if':
                case 'lgCtrl_elif':
                case 'lgCtrl_except':
                case 'lgCtrl_else':
                case 'lgCtrl_finally':
                    childBlocks = [
                        { 
                            menuId: 'lgCtrl_pass', 
                            menuState: { 
                                blockState: {
                                    isGroup: false
                                }
                            }
                        }
                    ];
                    break;
            }

            for (let i = 0; i < childBlocks.length; i++) {
                childBlocks[i]['blockType'] = 'block';
                childBlocks[i]['position'] = position + i + 1;
                childBlocks[i]['createChild'] = false;
            }
            return childBlocks;
        }
        
        /**
         * Open Popupcomponent
         * @param {PopupComponent} component 
         */
        openPopup(component) {
            if (component && component.isHidden()) {
                // hide other tasks
                this.hideAllPopup();
    
                // open it and focus it
                this._nowTask = component;
                component.open();
            }
        }

        /**
         * Close PopupComponent
         * @param {PopupComponent} component 
         */
        closePopup(component) {
            if (component) {
                component.close();
            }
        }

        /**
         * Apply task to board block
         * - remove from taskList
         * - add to blockList
         * - close component
         * @param {PopupComponent} component 
         */
        applyPopup(component) {
            let taskType = component.getTaskType();
            if (taskType == 'task') {
                // remove from taskBlockList
                this.removeTask(component);
                component.close();

                this.createPopup([{
                    menuId: component.id,
                    menuState: {
                        taskState: component.state
                    },
                    blockType: 'block'
                }]);
                // close and focus block (sequence is important)
                // newBlock.focusItem();
            } else {
                component.close();
            }
            // render board frame
            this.boardFrame.reloadBlockList();
        }

        /**
         * Remove PopupComponent
         * @param {PopupComponent} component 
         */
        removePopup(component) {
            if (component) {
                if (component.getTaskType() === 'block') {
                    // block
                    this.boardFrame.removeBlock(component);
                } else {
                    // task
                    this.removeTask(component);
                }
                component.remove();
            } else {
                vpLog.display(VP_LOG_TYPE.WARN, 'Component to remove is not available.');
            }
        }

        /**
         * Focus on PopupComponent
         * @param {PopupComponent} component 
         */
        focusPopup(component) {
            component.focus();
            this.setFocusedPage(component);
        }

        /**
         * Blur PopupComponent
         * @param {PopupComponent} component 
         */
        blurPopup(component=null) {
            if (component && (component instanceof PopupComponent)) {
                component.blur();
            } else {
                // blur all
                $('.vp-popup-frame').removeClass('vp-focused');
            }
            this.setFocusedPage(null);
        }

        /**
         * Hide all PopupComponent
         */
        hideAllPopup() {
            this.taskPopupList.forEach(task => {
                task.hide();
            });
            this.blockPopupList.forEach(task => {
                task.hide();
            });
        }

        /**
         * Focus popup page using its object
         * @param {PopupComponent} focusedPage 
         */
        setFocusedPage(focusedPage) {
            this.focusedPage = focusedPage;
        }

        checkDuplicatedTask(menuId) {
            // find on task list
            let dupTask = this._taskPopupList.filter(t => t && menuId === t.id);
            if (dupTask.length > 0) {
                return dupTask[0];
            }
            // not available
            return null;
        }

        addBlock(option, position=-1, blockState={}) {
            this._blockPopupList.push(option);
            let newBlock = this.boardFrame.addBlock(option, position, blockState);
            // render board frame
            this.boardFrame.reloadBlockList();
            return newBlock;
        }

        /**
         * Add task to task list and render TaskBar
         * @param {PopupComponent} option 
         */
        addTask(option) {
            this._taskPopupList.push(option);

            // render task bar
            this.menuFrame.renderTaskBar(this._taskPopupList);
        }

        /**
         * Remove task from task list and render TaskBar
         * @param {PopupComponent} option 
         */
        removeTask(option) {
            const taskToRemove = this._taskPopupList.find(function(item) { return item.uuid === option.uuid });
            const taskIdx = this._taskPopupList.indexOf(taskToRemove);
            if (taskIdx > -1) {
                taskToRemove.removeBlock();
                this._taskPopupList.splice(taskIdx, 1);
                // render task bar
                this.menuFrame.renderTaskBar(this._taskPopupList);
            } else {
                vpLog.display(VP_LOG_TYPE.WARN, 'No option task to remove');
            }
        }

        //========================================================================
        // Getter Setter
        //========================================================================
        get menuFrame() {
            return this._menuFrame;
        }

        get boardFrame() {
            return this._boardFrame;
        }

        get focusedPage() {
            return this._focusedPage;
        }

        set focusedPage(component) {
            this._focusedPage = component;
        }

        get taskPopupList() {
            return this._taskPopupList;
        }

        get blockPopupList() {
            return this._blockPopupList;
        }

        
    }
	
    

    return MainFrame;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/* End of file */

/***/ }),

/***/ "./lib/visualpython/js/__init__.py":
/*!*****************************************!*\
  !*** ./lib/visualpython/js/__init__.py ***!
  \*****************************************/
/***/ (() => {

print('Visual Python')


/***/ }),

/***/ "./lib/visualpython/js/board/Block.js":
/*!********************************************!*\
  !*** ./lib/visualpython/js/board/Block.js ***!
  \********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : Block.js
 *    Author          : Black Logic
 *    Note            : Render block
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 13
 *    Change Date     :
 */

//============================================================================
// [CLASS] Block
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! ../com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! ../com/com_String */ "./lib/visualpython/js/com/com_String.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(Component, com_String) {
	'use strict';

    const BLOCK_PADDING = 20;
	
    /**
     * @class Block
     * @constructor
     */
     class Block extends Component {
        constructor(parent, state) {
            super($('.vp-board-body'), state, { parent: parent });
            /**
             * state.task: PopupComponent
             * prop.parent : BoardFrame
             */
        }

        _getMenuGroupRootType(idx=1) {
            // ex) visualpython - apps - frame -> apps
            let path = this.state.task.path;
            let pathList = path.split(' - ');
            return pathList[idx];
        }

        _getMenuGroupType() {
            // ex) visualpython - apps - frame -> apps-frame
            let path = this.state.task.path;
            let pathList = path.split(' - ');
            return pathList.slice(1, pathList.length - 1).join('-');
        }

        _init() {
            this.state = {
                isGroup: true,
                leftHolderHeight: 0,
                depth: 0,
                blockNumber: $('.vp-block.vp-block-group').length + 1,
                elseFlag: false,
                finallyFlag: false,
                ...this.state
            }

            this.task = this.state.task;
            this.task.setTaskItem(this);

            this.classes = [];
        }

        _bindEvent() {
            let that = this;
            // hover run button click event
            $(this.wrapSelector('.vp-block-num-info')).on('click', function(evt) {
                // run popup
                that.prop.parent.runBlock(that);
            });
            // click event - emphasize TaskItem & open/hide PopupComponent
            $(this.wrapSelector('.vp-block-header')).single_double_click(function(evt) {
                /** single click */
                let isFocused = $(that.wrapSelector()).hasClass('vp-focus');
                if (isFocused) {
                    that.blurItem();
                } else {
                    that.focusItem();
                }
                evt.stopPropagation();
            }, function(evt) {
                /** double click */
                let isSorting = $(that.wrapSelector()).hasClass('ui-sortable-helper');
                if (isSorting) {
                    return;
                }
                let isHidden = that.task.isHidden();
                if (isHidden) {
                    that.openPopup();
                } else {
                    that.closePopup();
                }
            });
            // right click event - blockMenu
            $(this.wrapSelector('.vp-block-header')).on('contextmenu', function(evt) {
                that.prop.parent.showMenu(that, evt.pageX, evt.pageY);
                evt.preventDefault();
            });

            // click event - block button
            $(this.wrapSelector('.vp-block-button')).on('click', function(evt) {
                let menu = $(this).data('menu');
                switch (menu) {
                    case 'else':
                        that.prop.parent.toggleElseBlock(that);
                        break;
                    case 'elif':
                        that.prop.parent.addElifBlock(that);
                        break;
                    case 'except':
                        that.prop.parent.addExceptBlock(that);
                        break;
                    case 'finally':
                        that.prop.parent.toggleFinallyBlock(that);
                        break;
                }
                that.focusItem();
            })
        }

        checkTaskAvailable() {
            return this.task != undefined;
        }

        getColorLabel() {
            let root = this._getMenuGroupRootType();
            let label = root;
            switch(root) {
                case 'logic':
                    let subRoot = this._getMenuGroupRootType(2);
                    label = 'logic-' + subRoot;
                    break;
                case 'library':
                    break;
            }

            return label;
        }

        /**
         * Generate template
         */
        template() {
            let blockType = this.blockType;
            let taskId = this.id;
            let header = this.header;
            let isGroup = this.isGroup;
            let depth = this.depth;
            let blockNumber = this.blockNumber;
            let addedClass = this.classes.join(' ');

            var page = new com_String();
            page.appendFormatLine('<div class="vp-block {0} {1} {2}" style="padding-left: {3}px" >'
                                , isGroup?'vp-block-group':'', blockType, addedClass, depth*BLOCK_PADDING);
            page.appendFormatLine('<div class="vp-block-header">{0}</div>', header);
            page.appendFormatLine('<div class="vp-block-left-holder"></div>');
            page.appendFormatLine('<div class="vp-block-depth-info" style="left: {0}px">{1}</div>'
                                , depth*BLOCK_PADDING + BLOCK_PADDING, depth);
            page.appendFormatLine('<div class="vp-block-num-info" {0} title="{1}">{2}</div>'
                                , isGroup?'':'style="display:none;"', 'Run this group', blockNumber);

            // template for block button
            let { elseFlag, finallyFlag } = this.state; 
            if (taskId == 'lgCtrl_for' || taskId == 'lgCtrl_while') {
                page.appendLine('<div class="vp-block-button-group">');
                page.appendFormatLine('<div class="vp-block-button {0}" data-menu="{1}">{2}</div>', 'else', 'else', 'else ' + (elseFlag?'off':'on'));
                page.appendLine('</div>');
            }
            if (taskId == 'lgCtrl_if') {
                page.appendLine('<div class="vp-block-button-group">');
                page.appendFormatLine('<div class="vp-block-button {0}" data-menu="{1}">{2}</div>', 'elif', 'elif', '+ elif');
                page.appendFormatLine('<div class="vp-block-button {0}" data-menu="{1}">{2}</div>', 'else', 'else', 'else ' + (elseFlag?'off':'on'));
                page.appendLine('</div>');
            }
            if (taskId == 'lgCtrl_try') {
                page.appendLine('<div class="vp-block-button-group">');
                page.appendFormatLine('<div class="vp-block-button {0}" data-menu="{1}">{2}</div>', 'except', 'except', '+ except');
                page.appendFormatLine('<div class="vp-block-button {0}" data-menu="{1}">{2}</div>', 'else', 'else', 'else ' + (elseFlag?'off':'on'));
                page.appendFormatLine('<div class="vp-block-button {0}" data-menu="{1}">{2}</div>', 'finally', 'finally', 'finally ' + (finallyFlag?'off':'on'));
                page.appendLine('</div>');
            }
            page.appendLine('</div>');
            return page.toString();
        }

        render() {
            super.render();

            $(this.wrapSelector()).data('block', this);
            $(this.wrapSelector()).data('color', this.blockType);
            $(this.wrapSelector()).data('name', this.name);
            $(this.wrapSelector()).data('menu', this.id);

            // emphasize it if its task is visible
            if (!this.task.isHidden()) {
                this.focusItem();
            }

            // Deprecated: show markdown as other DA blocks
            // if markdown, set its height to fit-content
            // if (this.id == 'apps_markdown') {
            //     $(this.wrapSelector()).addClass('vp-block-markdown');
            // }

            // if viewDepthNumber, show it
            let viewDepthNumber = this.prop.parent.state.viewDepthNumber;
            if (this.depth > 0 && viewDepthNumber) {
                $(this.wrapSelector('.vp-block-depth-info')).css({ opacity: 1 });
            }
        }

        //========================================================================
        // Block control
        //========================================================================

        show() {
            $(this.wrapSelector()).show();
        }

        hide() {
            $(this.wrapSelector()).hide();
        }

        focusItem() {
            this.prop.parent.blurAllblock();
            $(this.wrapSelector()).addClass('vp-focus');
            this.addClass('vp-focus');

            this.getGroupedBlocks().forEach(block => {
                block.focusChild();
            });
        }
        
        blurItem() {
            this.classes = [];
            $(this.wrapSelector()).removeClass('vp-focus');
            this.removeClass('vp-focus');

            this.getGroupedBlocks().forEach(block => {
                block.blurChild();
            });
        }
        
        focusChild() {
            $(this.wrapSelector()).addClass('vp-focus-child');
            this.addClass('vp-focus-child');
        }

        blurChild() {
            $(this.wrapSelector()).removeClass('vp-focus-child');
            this.removeClass('vp-focus-child');
        }

        removeItem() {
            $(this.wrapSelector()).remove();
        }

        addClass(className) {
            this.classes.push(className);
        }

        removeClass(className) {
            let idx = this.classes.indexOf(className);
            this.classes.splice(idx, 1);
        }

        //========================================================================
        // Popup control
        //========================================================================
        openPopup() {
            // open task
            this.focusItem();
            $('#vp_wrapper').trigger({
                type: 'open_option_page',
                component: this.task
            });
        }
        
        closePopup() {
            // hide task if it's already opened
            this.blurItem();
            // close task
            $('#vp_wrapper').trigger({
                type: 'close_option_page'
            });   
        }
        //========================================================================
        // Get Set methods
        //========================================================================
        get id() {
            return this.task.id;
        }
        get name() {
            return this.task.name;
        }
        get menuGroup() {
            let groupCode = this._getMenuGroupRootType();
            let groupLabel = vpConfig.getMenuGroupLabel(groupCode);
            if (groupLabel == undefined || groupLabel === '') {
                return groupCode;
            }
            return groupLabel;
        }
        get blockType() {
            return this.getColorLabel();
        }
        get header() {
            let header = this.name;
            // if logic, show code
            if (this._getMenuGroupRootType() == 'logic') {
                header = this.task.generateCode();
            }
            // Deprecated: show markdown as other blocks
            // if (this.id == 'apps_markdown') {
            //     header = this.task.getPreview();
            // }
            this.state.header = header;
            return header;
        }
        get isGroup() {
            return this.state.isGroup;
        }
        get isHeadBlock() {
            return this.prop.parent.headBlocks.includes(this.id);
        }
        get isSubBlock() {
            return this.prop.parent.subBlocks.includes(this.id);
        }
        get blockNumber() {
            return this.state.blockNumber;
        }
        get depth() {
            return this.state.depth;
        }
        get popup() {
            return this.task;
        }
        get sigText() {
            return this.menuGroup + ' > ' + this.name;
        }
        canMakeChild() {
            let innerList = [
                'lgDef_class', 'lgDef_def', 
                'lgCtrl_for', 'lgCtrl_while', 'lgCtrl_if', 'lgCtrl_try',
                'lgCtrl_elif', 'lgCtrl_else', 'lgCtrl_except', 'lgCtrl_finally'
            ];
            if (innerList.includes(this.id)) {
                return true;
            }
            return false;
        }
        getChildDepth() {
            let depth = this.depth;
            if (this.canMakeChild()) {
                return depth + 1;
            }
            return depth;
        }
        /**
         * Get head group block of this group
         */
        getGroupBlock() {
            return this.prop.parent.getGroupBlock(this);
        }
        getGroupedBlocks() {
            return this.prop.parent.getGroupedBlocks(this);
        }
        setHeader(text) {
            this.state.header = text;
        }
        /**
         * Set block's blockNumber
          * @param {int} blockNumber
          */
        setNumber(blockNumber) {
            this.state.blockNumber = blockNumber;
        }
        /**
         * Set block's depth
         * @param {int} depth 
         */
        setDepth(depth) {
            this.state.depth = depth;
        }
        /**
         * Set block as group block
          */
        setGroupBlock() {
            let depthDiff = 0 - this.state.depth;
            this.state.isGroup = true;

            // change grouped block's depth ( depth + 1 )
            this.setGroupedBlocksState(block => { block.setDepth(block.depth + depthDiff)});
        }
        /**
         * Set block as child block of given block
         */
        setChildBlock(newDepth) {
            let depthDiff = newDepth - this.state.depth;
            this.state.isGroup = false;

            // change grouped block's depth ( depth + 1 )
            this.setGroupedBlocksState(block => { block.setDepth(block.depth + depthDiff)});
        }

        /**
         * Set grouped blocks state using setter function
         * Example:
         *  block.setGroupedBlocksState(block => { block.setDepth(block.depth + 1)})
         * @param {Function} setter 
         */
        setGroupedBlocksState(setter) {
            let groupedBlocks = this.getGroupedBlocks();
            groupedBlocks.forEach(block => {
                setter(block);
            });
        }

        //========================================================================
        // Block load/save
        //========================================================================
        toJson() {
            let state = this.task.getState();
            // delete config info
            delete state['config'];
            let jsonBlock = {
                isGroup: this.isGroup,
                depth: this.depth,
                blockNumber: this.blockNumber,
                taskId: this.id,
                taskState: state
            };
            return jsonBlock;
        }

        fromJson(jsonObject) {
            let {
                isGroup, depth, blockNumber, taskId, taskState
            } = obj;
            this.state = {
                isGroup: isGroup,
                depth: depth,
                blockNumber: blockNumber,
                ...taskState
            };
        }
    }

    return Block;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/board/BlockMenu.js":
/*!************************************************!*\
  !*** ./lib/visualpython/js/board/BlockMenu.js ***!
  \************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : BlockMenu.js
 *    Author          : Black Logic
 *    Note            : Render block menu
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 12. 13
 *    Change Date     :
 */

//============================================================================
// [CLASS] Block
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! ./CodeView */ "./lib/visualpython/js/board/CodeView.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function (com_util, com_String, Component, CodeView) {
    'use strict';

    class BlockMenu extends Component {
        constructor(boardFrame) {
            super($('#vp_boardFrame'), {}, {boardFrame: boardFrame});
        }

        _init() {
            this.boardFrame = this.prop.boardFrame;
            this.block = undefined;

            this.position = {
                left: 0,
                top: 0
            };

            this.prevBlockCodeview = null;
        }

        _bindEvent() {
            var that = this;
            /** edit block */
            $(this.wrapSelector('#vp_block_menu_edit')).on('click', function () {
                that.block.openPopup();
                that.close();
            });
            /** run block */
            $(this.wrapSelector('#vp_block_menu_run')).on('click', function () {
                that.boardFrame.runBlock(that.block);
                that.close();
            });
            /** add block */
            $(this.wrapSelector('#vp_block_menu_add')).on('click', function () {
                that.boardFrame.runBlock(that.block, true, false);
                that.close();
            });
            /** duplicate block */
            $(this.wrapSelector('#vp_block_menu_duplicate')).on('click', function () {
                // duplicate block
                that.boardFrame.copyBlock(that.block);
                that.close();
            });
            /** delete block */
            $(this.wrapSelector('#vp_block_menu_delete')).on('click', function () {
                that.boardFrame.removeBlock(that.block);
                that.close();
            });
            /** code view */
            $(this.wrapSelector('#vp_block_menu_codeview')).on('click', function() {
                let overallCode = new com_String();
                let groupCode = that.boardFrame.runBlock(that.block, false, false);
                if (that.block.id == 'apps_markdown') {
                    // if markdown, add #
                    groupCode = '#' + groupCode.replaceAll('\n', '\n# ');
                }
                overallCode.appendFormatLine('# Visual Python: {0} > {1}', that.block.name, that.block.name);
                overallCode.append(groupCode);

                // open codeview
                let codeview = new CodeView({ 
                    codeview: overallCode.toString(),
                    config: {
                        id: 'blockCodeview',
                        name: 'Block Codeview',
                        path: ''
                    }
                });
                if (that.prevBlockCodeview != null) {
                    // remove prev code view
                    that.prevBlockCodeview.remove();
                }
                that.prevBlockCodeview = codeview;
                codeview.open();

                that.close();
            });
        }

        template() {
            var sbBlockMenu = new com_String();
            sbBlockMenu.appendFormatLine('<div id="vp_block_menubox"  style="0" class="vp-block-menu-box vp-close-on-blur">',
                'display: none; position: fixed;');
            // edit button
            sbBlockMenu.appendLine('<div id="vp_block_menu_edit" class="vp-block-menu-item">Edit</div>');
            sbBlockMenu.appendLine('<hr class="vp-extra-menu-line" id="vp_block_menu_line_1">');
            // run button
            sbBlockMenu.appendLine('<div id="vp_block_menu_run" class="vp-block-menu-item">Run</div>');
            // add button
            sbBlockMenu.appendLine('<div id="vp_block_menu_add" class="vp-block-menu-item">Code to cell</div>');
            // duplicate button
            sbBlockMenu.appendLine('<div id="vp_block_menu_duplicate" class="vp-block-menu-item">Duplicate</div>');
            // delete button
            sbBlockMenu.appendLine('<div id="vp_block_menu_delete" class="vp-block-menu-item">Delete</div>');
            // codeview button
            sbBlockMenu.appendLine('<hr class="vp-extra-menu-line" id="vp_block_menu_line_2">');
            sbBlockMenu.appendLine('<div id="vp_block_menu_codeview" class="vp-block-menu-item">Code view</div>');
            sbBlockMenu.appendLine('</div>');
            return sbBlockMenu.toString();
        }

        open(block, left, top) {
            this.block = block;
            this.position = {
                left: left,
                top: top
            };

            // handling menu box to show inside visible area
            let docWidth = $(document).width();
            let docHeight = $(document).height();
            let menuWidth = $(this.wrapSelector()).outerWidth();
            let menuHeight = $(this.wrapSelector()).outerHeight();
            if (docWidth < left + menuWidth) {
                // horizontally out of view
                this.position.left -= menuWidth;
            }
            if (docHeight < top + menuHeight) {
                // vertically out of view
                this.position.top -= menuHeight;
            }
            
            $(this.wrapSelector()).css(this.position);
            // show items
            $(this.wrapSelector('.vp-block-menu-item')).show();
            $(this.wrapSelector('.vp-extra-menu-line')).show();
            $(this.wrapSelector()).show();

            // filter menu depends on block
            let noContentBlocks = ['lgCtrl_try', 'lgCtrl_else', 'lgCtrl_finally'];
            if (this.block.isSubBlock) {
                // no duplicate
                $(this.wrapSelector('#vp_block_menu_duplicate')).hide();
            } 
            if (noContentBlocks.includes(this.block.id)) {
                // no edit mode
                $(this.wrapSelector('#vp_block_menu_edit')).hide();
                $(this.wrapSelector('#vp_block_menu_line_1')).hide();
            }
        }
        
        close() {
            this.block = undefined;
            $(this.wrapSelector()).hide();
        }
        
    }

    return BlockMenu;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/board/BoardFrame.js":
/*!*************************************************!*\
  !*** ./lib/visualpython/js/board/BoardFrame.js ***!
  \*************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : BoardFrame.js
 *    Author          : Black Logic
 *    Note            : Render and load board frame
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 13
 *    Change Date     :
 */

//============================================================================
// [CLASS] BoardFrame
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!../../html/boardFrame.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/boardFrame.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! ../../css/boardFrame.css */ "./lib/visualpython/css/boardFrame.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! ../com/com_Config */ "./lib/visualpython/js/com/com_Config.js"),
    __webpack_require__(/*! ../com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! ../com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! ../com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! ../com/com_interface */ "./lib/visualpython/js/com/com_interface.js"),
    __webpack_require__(/*! ../com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! ../com/component/FileNavigation */ "./lib/visualpython/js/com/component/FileNavigation.js"),
    __webpack_require__(/*! ./Block */ "./lib/visualpython/js/board/Block.js"),
    __webpack_require__(/*! ./BlockMenu */ "./lib/visualpython/js/board/BlockMenu.js"),
    __webpack_require__(/*! ./CodeView */ "./lib/visualpython/js/board/CodeView.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(boardFrameHtml, boardFrameCss, com_Config, com_Const, com_String, com_util, com_interface, 
            Component, FileNavigation, Block, BlockMenu, CodeView) {
	'use strict';
    //========================================================================
    // Define Variable
    //========================================================================
    const BLOCK_PADDING = 20;
	
    /**
     * BoardFrame
     */
     class BoardFrame extends Component{
        //========================================================================
        // Constructor
        //========================================================================
        constructor($target, state, prop) {
            super($target, state, prop);
            /*
             * state.vp_note_display
             * state.vp_note_width
             * prop.parent: MainFrame
             */
        }

        //========================================================================
        // Internal call function
        //========================================================================
        _init() {
            // selected block
            this.selectedBlock = null;
            this._blockList = {
                'default': {
                    title: '',
                    blockList: []
                }
            }

            // state
            this.state = {
                vp_note_display: true,
                viewDepthNumber: false,
                indentCount: 4,
                ...this.state
            };

            // temporary state
            this.tmpState = {
                boardTitle: 'Untitled',
                boardPath: null,
                copy: {
                    start: 0,
                    end: 0
                }
            }

            this.headBlocks = ['lgCtrl_if', 'lgCtrl_for', 'lgCtrl_try'];
            this.subBlocks = ['lgCtrl_elif', 'lgCtrl_else', 'lgCtrl_except', 'lgCtrl_finally'];
        }

        get blockList() {
            let sessionId = 'default';
            // LAB: get session id
            if (vpConfig.extensionType === 'lab') {
                let panelId = vpKernel.getLabPanelId();
                if (panelId) {
                    sessionId = panelId;
                }
            }
            if (sessionId in this._blockList) {
                return this._blockList[sessionId].blockList;
            }
            return [];
        }

        set blockList(val) {
            let sessionId = 'default';
            // LAB: get session id
            if (vpConfig.extensionType === 'lab') {
                let panelId = vpKernel.getLabPanelId();
                if (panelId) {
                    sessionId = panelId;
                }
            }
            if (sessionId in this._blockList) {
                this._blockList[sessionId].blockList = val;
            } else {
                this._blockList[sessionId] = {
                    title: '',
                    blockList: val
                }
            }
            return true;
        }

        addToBlockList(newVal, position=-1) {
            let sessionId = 'default';
            // LAB: get session id
            if (vpConfig.extensionType === 'lab') {
                let panelId = vpKernel.getLabPanelId();
                if (panelId) {
                    sessionId = panelId;
                } else {
                    // No Session
                    sessionId = null;
                }
            }
            if (sessionId == null) {
                // No session
                return false;
            } else {
                if (sessionId in this._blockList) {
                    if (position >= 0) {
                        this._blockList[sessionId].blockList.splice(position, 0, newVal);
                    } else {
                        this._blockList[sessionId].blockList.push(newVal);
                    }
                } else {
                    this._blockList[sessionId] = {
                        title: '',
                        blockList: [ newVal ]
                    };
                }
            }
            return true;
        }

        removeFromBlockList(removeVal) {
            let sessionId = 'default';
            // LAB: get session id
            if (vpConfig.extensionType === 'lab') {
                let panelId = vpKernel.getLabPanelId();
                if (panelId) {
                    sessionId = panelId;
                }
            }
            if (sessionId in this._blockList) {
                this._blockList[sessionId].blockList.splice(
                    this._blockList[sessionId].blockList.indexOf(removeVal), 1
                );
            } else {
                return false;
            }
            return true;
        }

        getTitle() {
            let sessionId = 'default';
            // LAB: get session id
            if (vpConfig.extensionType === 'lab') {
                let panelId = vpKernel.getLabPanelId();
                if (panelId) {
                    sessionId = panelId;
                }
            }
            if (sessionId in this._blockList) {
                return this._blockList[sessionId].title;
            } else {
                return '';
            }
        }

        setTitle(newTitle) {
            let sessionId = 'default';
            // LAB: get session id
            if (vpConfig.extensionType === 'lab') {
                let panelId = vpKernel.getLabPanelId();
                if (panelId) {
                    sessionId = panelId;
                }
            }
            if (sessionId in this._blockList) {
                this._blockList[sessionId].title = newTitle;
            } else {
                this._blockList[sessionId] = {
                    title: newTitle,
                    blockList: [ ]
                };
            }
        }

        _bindEvent() {
            let that = this;
            // board menu toggle button
            $(this.wrapSelector('.vp-board-header-button')).on('click', function(evt) {
                $(that.wrapSelector('.vp-board-header-button-inner')).toggle();
                evt.stopPropagation();
            });
            // board menu button click
            $(this.wrapSelector('.vp-board-header-button-inner ul li')).on('click', function() {
                let menu = $(this).data('menu');
                switch (menu) {
                    case 'new':
                        that.createNewNoteWithChecking();
                        break;
                    case 'open':
                        that.openNote();
                        break;
                    case 'save':
                        that.saveNote();
                        break;
                    case 'save-as':
                        that.saveAsNote();
                        break;
                    case 'run-all':
                        that.runAll();
                        break;
                    case 'code-view':
                        that.viewCode();
                        break;
                    case 'code-export':
                        that.exportCode();
                        break;
                    case 'clear':
                        that.clearBoardWithChecking();
                        break;
                }
            });
            // footer +code, +text button
            $('.vp-board-footer-buttons button').on('click', function() {
                let menu = $(this).data('menu');
                if (menu === 'code') {
                    // code
                    $('#vp_wrapper').trigger({
                        type: 'create_option_page',
                        blockType: 'block',
                        menuId: 'lgExe_code',
                        menuState: {}
                    });
                } else if (menu === 'text') {
                    // text
                    $('#vp_wrapper').trigger({
                        type: 'create_option_page',
                        blockType: 'block',
                        menuId: 'apps_markdown',
                        menuState: {}
                    });
                }
            });
            // change of boardTitle
            $(this.wrapSelector('#vp_boardTitle')).on('change', function() {
                let fileName = $(this).val();
                that.setTitle(fileName); // LAB: session note title
                that.tmpState.boardTitle = fileName;
                that.tmpState.boardPath = null;
            });
            // click board - blur block
            $(this.wrapSelector()).on('click', function() {
                that.blurAllblock();
            });
        }

        _bindSortable() {
            let that = this;
            let parent = this.prop.parent;
            let position = -1;
            let targetBlock = null;
            let targetId = '';
            let groupedBlocks = null;
            let parentBlock = null;
            let depth = 0;
            let revert = false;
            $('.vp-board-body').sortable({
                items: '> .vp-block',
                axis: 'y',
                scroll: true,
                revert: false,
                cursor: 'move',
                handle: '.vp-block-header',
                helper: function(evt, currentItem) {
                    let header = currentItem.data('name');
                    let tag = new com_String();
                    tag.appendLine('<div class="vp-sortable-helper" style="z-index: 199;">');
                    tag.appendFormatLine('<div>{0}</div>', header);
                    tag.appendLine('</div>');
                    return tag.toString();
                },
                placeholder: {
                    element: function(currentItem) {
                        let block = currentItem.data('block');
                        let color = currentItem.data('color');
                        targetId = currentItem.data('menu');
                        if (block) {
                            let tag = new com_String();
                            tag.appendFormatLine('<div class="vp-block vp-block-group vp-sortable-placeholder {0}" style="z-index: 199;">', block.getColorLabel());
                            tag.appendFormatLine('<div class="vp-block-header">{0}</div>', block.name);
                            tag.appendLine('</div>');
                            return tag.toString();
                        } else {
                            let header = currentItem.find('.vp-block-header').text();
                            let tag = new com_String();
                            tag.appendFormatLine('<div class="vp-block vp-block-group vp-sortable-placeholder {0}" style="z-index: 199;">', color);
                            tag.appendFormatLine('<div class="vp-block-header">{0}</div>', header);
                            tag.appendLine('</div>');
                            return tag.toString();
                        }
                    },
                    update: function(container, p) {
                        // container: container
                        // p: placeholder object
                        return;
                    }
                },
                start: function(evt, ui) {
                    position = ui.item.index();
                    targetBlock = that.blockList[position];
                    if (targetBlock) {
                        if (targetBlock.isSubBlock) {
                            revert = true;
                            return;
                        }
                        // hide grouped item
                        groupedBlocks = targetBlock.getGroupedBlocks();
                        groupedBlocks.forEach(block => {
                            block.hide();
                        });
                    } else {
                        // hide original item
                        ui.item.hide();
                    }
                },
                sort: function(evt, ui) {
                    let tmpPos = ui.placeholder.index();
                    let currCursorX = evt.clientX; 
                    let currCursorY = evt.clientY; 

                    if (position < tmpPos && groupedBlocks) {
                        tmpPos += (1 - groupedBlocks.length);
                    }

                    // sorting is not allowed for sub blocks (elif, else, except, finally)
                    if (revert) {
                        ui.placeholder.removeClass('vp-block-group');
                        ui.placeholder.insertAfter($('.vp-block:not(.vp-draggable-helper):not(.vp-sortable-placeholder):nth('+(position - 1)+')'));
                        return;
                    }

                    let befBlockTag = $('.vp-block:not(.vp-draggable-helper):not(.vp-sortable-placeholder):nth('+(tmpPos - 1)+')');
                    if (befBlockTag && befBlockTag.length > 0) {
                        let befBlock = befBlockTag.data('block');
                        let befGroupBlock = befBlock.getGroupBlock();
                        let rect = befBlockTag[0].getBoundingClientRect();
                        let befStart = rect.y;
                        let befRange = rect.y + rect.height;
                        let befGroupRange = befRange + (rect.height/2);
                        let befDepth = befBlock.getChildDepth();
                        
                        let isMarkdown = false; // if befBlock or thisBlock is markdown
                        // check if thisBlock is markdown block or befBlock is markdown block
                        if (targetId == 'apps_markdown' || (befBlock && befBlock.id == 'apps_markdown')) {
                            isMarkdown = true;
                        }
                        
                        if (isMarkdown) {
                            let befGroupedBlocks = befGroupBlock.getGroupedBlocks();
                            let befGroupLastBlock = befGroupedBlocks[befGroupedBlocks.length - 1]; // last block of previous group
                            if (!befBlock.equals(befGroupLastBlock)) {
                                ui.placeholder.insertAfter(befGroupLastBlock.getTag());
                                return;
                            }
                        }

                        if (!isMarkdown) {
                            if (befBlock.isSubBlock || (befStart < currCursorY && currCursorY < befRange)) {
                                // sort as child of befBlock (except Markdown)
                                // - if befBlock is subBlock, no group block is allowed
                                parentBlock = befBlock;
                                depth = befDepth;
                                ui.placeholder.removeClass('vp-block-group');
                                ui.placeholder.css({ 'padding-left': depth*BLOCK_PADDING + 'px'});
                                return;
                            }
                            if (befRange <= currCursorY && currCursorY < befGroupRange) {
                                // sort as child of befGroupBlock (except Markdown)
                                parentBlock = befGroupBlock;
                                depth = befGroupBlock.getChildDepth();
                                ui.placeholder.removeClass('vp-block-group');
                                ui.placeholder.css({ 'padding-left': depth*BLOCK_PADDING + 'px'});
                                return;
                            }
                        }
                        // sort after befBlock
                        parentBlock = null;
                        if (!ui.placeholder.hasClass('vp-block-group')) {
                            ui.placeholder.addClass('vp-block-group');
                        }
                        ui.placeholder.css({ 'padding-left': 0});
                        depth = 0;
                    }
                },
                stop: function(evt, ui) {
                    var spos = position;
                    var epos = ui.item.index();

                    if (revert) {
                        revert = false;
                        return;
                    }

                    if (spos < epos && groupedBlocks) {
                        epos += (1 - groupedBlocks.length);
                    }

                    if (epos > -1) {
                        // move list element
                        if (parentBlock) {
                            that.moveBlock(spos, epos, parentBlock);
                        } else {
                            that.moveBlock(spos, epos);
                        }
                    }

                    if (targetBlock && groupedBlocks) {
                        // show grouped block
                        groupedBlocks.forEach(block => {
                            block.show();
                        });
                    } else {
                        // show original item
                        ui.item.show();
                    }
                }
            }).disableSelection();
        }

        //========================================================================
        // External call function
        //========================================================================
        /**
         * Make template
         */
        template() {
            return boardFrameHtml.replaceAll('${vp_base}', com_Const.BASE_PATH);
        }

        /**
         * Render and load on parentDom, bind events
         */
        render() {
            super.render();

            // display note
            if (!this.state.vp_note_display) {
                this.hide();
            }

            // set width using metadata
            $(this.wrapSelector()).width(this.state.vp_note_width);

            // render taskBar
            this.renderBlockList([]);
            this._bindSortable();

            this.blockMenu = new BlockMenu(this);

            if (vpConfig.extensionType === 'lab') {
                let that = this;
                vpLab.shell._currentChanged.connect(function(sender, value) {
                    // if lab tab changed, reset title and reload board
                    that.reloadBlockList();
                });
            }
        }

        /**
         * Render block list
         */
        renderBlockList(blockPopupList) {
            let that = this;
            let parent = this.prop.parent;
            $('.vp-board-body').html('');
            blockPopupList && blockPopupList.forEach(task => {
                let block = new Block(this, { task: task });
                // LAB: add session queue to blockList
                // that.blockList.push(block); 
                that.addToBlockList(block);
            });
        }

        /**
         * Reload block list on the board
         */
        reloadBlockList() {
            let num = 1;
            // reset boardframe title
            $(this.wrapSelector('#vp_boardTitle')).val(this.getTitle());
            // init boardframe body
            $(this.wrapSelector('.vp-board-body')).html('');
            // render block list
            this.blockList.forEach(block => {
                // if it's already rendered and block
                if (block && block instanceof Block) {
                    if (block.isGroup) {
                        block.setNumber(num++);
                    }
                    block.render();
                }
            })
            this.renderInfo();
        }

        renderInfo() {
            let num = 1;
            $('.vp-block.vp-block-group').each(function(i, block) {
                let numInfo = $(block).find('.vp-block-num-info');
                $(numInfo).html(num++);
            });
        }

        show() {
            // show note area
            $(this.wrapSelector()).show();
            $('#vp_toggleBoard').removeClass('vp-hide');
            $('#vp_toggleBoard').attr('title', 'Hide VP Note');
            // set width 
            let boardWidth = com_Config.BOARD_MIN_WIDTH;
            $(this.wrapSelector()).width(boardWidth);
            // save as metadata
            vpConfig.setMetadata({ vp_note_display: true, vp_note_width: boardWidth });
        }
        
        hide() {
            // hide note area
            $(this.wrapSelector()).hide();
            if (!$('#vp_toggleBoard').hasClass('vp-hide')) {
                $('#vp_toggleBoard').addClass('vp-hide');
            }
            $('#vp_toggleBoard').attr('title', 'Show VP Note');
            // set width
            let boardWidth = 0;
            $(this.wrapSelector()).width(boardWidth);
            // save as metadata
            vpConfig.setMetadata({ vp_note_display: false, vp_note_width: boardWidth });
        }
        
        showLoadingBar() {
            $(this.wrapSelector('#vp_boardLoading')).show();
        }

        hideLoadingBar() {
            $(this.wrapSelector('#vp_boardLoading')).hide();
        }
        //========================================================================
        // Note control
        //========================================================================
        /**
         * Check if note has changes to save
         */
        checkNote() {
            if (this.blockList.length > 0) {
                return true;
            }
            return false;
        }
        createNewNoteWithChecking() {
            // alert before closing
            let that = this;
            if (this.checkNote()) {
                // render update modal
                com_util.renderModal({
                    title: 'Unsaved changes', 
                    message: 'Do you want to save?',
                    buttons: ['Cancel', 'No', 'Save'],
                    defaultButtonIdx: 0,
                    buttonClass: ['cancel', '', 'activated'],
                    finish: function(clickedBtnIdx) {
                        switch (clickedBtnIdx) {
                            case 0:
                                // cancel - do nothing
                                return;
                            case 1:
                                // don't save
                                that.createNewNote();
                                break;
                            case 2:
                                // save
                                that.saveAsNote(function() {
                                    that.createNewNote();
                                });
                                break;
                        }
                    }
                });

                return;
            }

            this.createNewNote();
        }
        createNewNote() {
            // clear board before create new note
            this.clearBoard();

            let defaultTitle = 'Untitled';

            // set title to Untitled
            this.tmpState.boardTitle = defaultTitle;
            // set path to empty
            this.tmpState.boardPath = null;

            // set title
            $(this.wrapSelector('#vp_boardTitle')).val(defaultTitle);
            this.setTitle(defaultTitle); // LAB: session note title
        }
        openNote() {
            // TODO: check save as

            let that = this;
            // open file navigation
            let fileNavi = new FileNavigation({ 
                type: 'open',
                extensions: ['vp'],
                finish: function(filesPath, status, error) {
                    // clear board before open note
                    that.clearBoard();
                    
                    let vpFilePath = filesPath[0].path;
                    let vpFileName = filesPath[0].file;
                    // read file
                    if (vpConfig.extensionType === 'lab') {
                        // LAB: read file using python open
                        vpKernel.readFile(vpFilePath).then(function(resultObj) {
                            try {
                                var jsonList = JSON.parse(resultObj.result);
                                // load blocks
                                that.jsonToBlock(jsonList);
    
                                var indexVp = vpFileName.indexOf('.vp');
                                var saveFileName = vpFileName.slice(0,indexVp);
                
                                // show title of board and path
                                $('#vp_boardTitle').val(saveFileName);
                                that.setTitle(saveFileName); // LAB: session note title
                                that.tmpState.boardTitle = saveFileName;
                                that.tmpState.boardPath = vpFilePath;
    
                                com_util.renderSuccessMessage('Successfully opened file. (' + vpFileName + ')');
                            } catch (ex) {
                                com_util.renderAlertModal('Not applicable file contents with vp format! (JSON)');
                            }
                        }).catch(function(err) {
                            vpLog.display(VP_LOG_TYPE.ERROR, err);
                        })
                    } else {
                        fetch(vpFilePath).then(function(file) {
                            if (file.status != 200) {
                                com_util.renderAlertModal('The file format is not valid. (file: '+file+')');
                                return;
                            }
                    
                            file.text().then(function(data) {
                                // var parsedData = decodeURIComponent(data);
                                try {
                                    var jsonList = JSON.parse(data);
                                    // load blocks
                                    that.jsonToBlock(jsonList);
        
                                    var indexVp = vpFileName.indexOf('.vp');
                                    var saveFileName = vpFileName.slice(0,indexVp);
                    
                                    // show title of board and path
                                    $('#vp_boardTitle').val(saveFileName);
                                    that.setTitle(saveFileName); // LAB: session note title
                                    that.tmpState.boardTitle = saveFileName;
                                    that.tmpState.boardPath = vpFilePath;
        
                                    com_util.renderSuccessMessage('Successfully opened file. (' + vpFileName + ')');
                                } catch (ex) {
                                    com_util.renderAlertModal('Not applicable file contents with vp format! (JSON)');
                                }
                            });
                        }).catch(function(err) {
                            vpLog.display(VP_LOG_TYPE.ERROR, err);
                        });
                    }
                    
                }
            });
            fileNavi.open();
        }
        saveNote() {
            let { boardPath, boardTitle } = this.tmpState;
            // if path exists, save note
            if (boardPath && boardPath != '') {
                // save vp file
                let idx = boardTitle.lastIndexOf('.vp');
                if (idx < 0) {
                    boardTitle += '.vp';
                }
                let saveData = this.blockToJson(this.blockList);
                let saveDataStr = JSON.stringify(saveData);
                vpKernel.saveFile(boardTitle, boardPath, saveDataStr);
                return;
            }

            this.saveAsNote();
        }
        saveAsNote(callback) {
            let that = this;
            // save file navigation
            let fileNavi = new FileNavigation({ 
                type: 'save',
                fileName: this.tmpState.boardTitle,
                extensions: ['vp'],
                finish: function(filesPath, status, error) {
                    let boardTitle = filesPath[0].file;
                    let boardPath = filesPath[0].path;

                    // save vp file
                    let saveData = that.blockToJson(that.blockList);
                    let saveDataStr = JSON.stringify(saveData);
                    vpKernel.saveFile(boardTitle, boardPath, saveDataStr);

                    // save it in tmpState
                    // detach extension
                    let idx = boardTitle.lastIndexOf('.vp');
                    boardTitle = boardTitle.substring(0, idx);
                    that.tmpState.boardTitle = boardTitle;
                    that.tmpState.boardPath = boardPath;
                    $('#vp_boardTitle').val(boardTitle);
                    that.setTitle(boardTitle); // LAB: session note title

                    if (callback != undefined && typeof callback === 'function') {
                        callback();
                    }
                }
            });
            fileNavi.open();
        }
        runBlock(block, execute=true, addcell=true) {
            if (block.id == 'apps_markdown') {
                // if markdown, run single
                return block.popup.run(execute, addcell);
            }
            let rootBlockDepth = block.depth;
            let groupedBlocks = block.getGroupedBlocks();
            let code = new com_String();
            let indentCount = this.state.indentCount;
            groupedBlocks.forEach((groupBlock, idx) => {
                let prevNewLine = idx > 0?'\n':'';
                let indent = ' '.repeat((groupBlock.depth - rootBlockDepth) * indentCount);
                let thisBlockCode = groupBlock.popup.generateCode();
                if (Array.isArray(thisBlockCode)) {
                    for (let i = 0; i < thisBlockCode.length; i++) {
                        thisBlockCode[i] = thisBlockCode[i].replaceAll('\n', '\n' + indent);
                    }
                    if (addcell) {
                        // insert single cell using prev code
                        com_interface.insertCell('code', code.toString(), execute, block.sigText);
                        code = new com_String();
                        // insert cells using this block code list
                        com_interface.insertCells('code', thisBlockCode, execute, block.sigText);
                    }
                } else {
                    // set indent to every line of thisblockcode
                    thisBlockCode = thisBlockCode.replaceAll('\n', '\n' + indent);
                    code.appendFormat('{0}{1}{2}', prevNewLine, indent, thisBlockCode);
                }
            });
            if (addcell) {
                com_interface.insertCell('code', code.toString(), execute, block.sigText);
            }
            return code.toString();
        }
        runAll() {
            let that = this;
            this.blockList.forEach(block => {
                if (block.isGroup) {
                    that.runBlock(block);
                }
            })
        }
        getOverallCode() {
            let overallCode = new com_String();
            let that = this;
            this.blockList.forEach((block) => {
                if (block.isGroup) {
                    if (overallCode.toString() != '') {
                        overallCode.appendLine();
                        overallCode.appendLine();
                    }
                    let groupCode = that.runBlock(block, false, false);
                    if (block.id == 'apps_markdown') {
                        // if markdown, add #
                        groupCode = '#' + groupCode.replaceAll('\n', '\n# ');
                    }
                    overallCode.appendFormatLine('# Visual Python: {0} > {1}', block.name, block.name,
                        block.id == 'apps_markdown'? ' - Markdown':'');
                    overallCode.append(groupCode);
                }
            });
            return overallCode.toString();
        }
        viewCode() {
            let overallCode = this.getOverallCode();
            let codeview = new CodeView({ 
                codeview: overallCode,
                config: {
                    id: 'boardCodeview',
                    name: 'Overall Codeview',
                    path: ''
                }
            });
            codeview.open();
        }
        exportCode() {
            let that = this;
            // save .py file
            let fileNavi = new FileNavigation({
                type: 'save',
                fileName: this.tmpState.boardTitle,
                extensions: ['py'],
                finish: function(filesPath, status, error) {
                    let fileName = filesPath[0].file;
                    let filePath = filesPath[0].path;

                    // save py file
                    let overallCode = that.getOverallCode();
                    vpKernel.saveFile(fileName, filePath, overallCode);
                }
            });
            fileNavi.open();
        }
        /**
         * Deprecated on v2.0.2.
         */
        // viewDepthInfo() {
        //     this.state.viewDepthNumber = !this.state.viewDepthNumber;

        //     if (this.state.viewDepthNumber) {
        //         $(this.wrapSelector('.vp-board-header-button-inner li[data-menu="view-depth"]')).text('Hide Depth Number');
        //     } else {
        //         $(this.wrapSelector('.vp-board-header-button-inner li[data-menu="view-depth"]')).text('View Depth Number');
        //     }

        //     // reloadBlockList
        //     this.reloadBlockList();
        // }
        clearBoardWithChecking() {
            // alert before closing
            let that = this;
            if (this.checkNote()) {
                // render update modal
                com_util.renderModal({
                    title: 'Unsaved changes', 
                    message: 'Do you want to save?',
                    buttons: ['Cancel', "No", 'Save'],
                    defaultButtonIdx: 0,
                    buttonClass: ['cancel', '', 'activated'],
                    finish: function(clickedBtnIdx) {
                        switch (clickedBtnIdx) {
                            case 0:
                                // cancel - do nothing
                                return;
                            case 1:
                                // don't save
                                that.clearBoard();
                                break;
                            case 2:
                                // save
                                that.saveAsNote(function() {
                                    that.clearBoard();
                                });
                                break;
                        }
                    }
                });

                return;
            }

            this.clearBoard();
        }
        clearBoard() {
            // clear board
            this.blockList.forEach(block => {
                block.popup.remove();
            })
            this.blockList = [];
            // render block list  
            this.reloadBlockList();
        }
        /**
         * Deprecated on v2.0.2.
         */
        // closeBoard() {
        //     this.createNewNote();
        // }
        //========================================================================
        // Block control
        //========================================================================
        createBlock(component, state) {
            let createdBlock = new Block(this, state);
            component.setTaskItem(createdBlock);

            return createdBlock;
        }

        addBlock(option, position=-1, blockState={}) {
            let block = new Block(this, { task: option, ...blockState });
            option.setTaskItem(block);
            if (position < 0) {
                // add to the end
                // this.blockList.push(block);
                this.addToBlockList(block);
                position = this.blockList.length;
            } else {
                // add to specific position
                // this.blockList.splice(position, 0, block);
                this.addToBlockList(block, position);
            }
            return block;
        }

        removeBlock(blockToRemove) {
            let that = this;
            // if sub block, change group block's state
            let groupBlock = blockToRemove.getGroupBlock();
            if (blockToRemove.id === 'lgCtrl_else') {
                groupBlock.state.elseFlag = false;
            }
            if (blockToRemove.id === 'lgCtrl_finally') {
                groupBlock.state.finallyFlag = false;
            }

            // remove grouped blocks (under this depth)
            let groupedBlocks = blockToRemove.getGroupedBlocks();
            groupedBlocks.forEach(block => {
                // remove block
                if (blockToRemove.isGroup || blockToRemove.equals(block) || block.depth > blockToRemove.depth) {
                    // const blockIdx = that.blockList.indexOf(block);
                    block.popup.remove();
                    // that.blockList.splice(blockIdx, 1);
                    that.removeFromBlockList(block);
                }
            });
            // render block list  
            this.reloadBlockList();
        }

        /**
         * Change position of task in  blockPopupList
         * @param {int} startIdx 
         * @param {int} endIdx 
         */
        moveBlock(startIdx, endIdx, parentBlock=null) {
            let sessionId = 'default';
            // LAB: get session id
            if (vpConfig.extensionType === 'lab') {
                let panelId = vpKernel.getLabPanelId();
                if (panelId) {
                    sessionId = panelId;
                }
            }
            var movingBlock = this._blockList[sessionId].boardList[startIdx];
            if (movingBlock) {
                let groupBlocks = this.getGroupedBlocks(movingBlock);
                this._blockList[sessionId].boardList.splice(startIdx, groupBlocks.length);
                this._blockList[sessionId].boardList.splice(endIdx, 0, ...groupBlocks);
                // move tag
                if (parentBlock != null) {
                    // set this movingBlock as child of parentBlock
                    movingBlock.setChildBlock(parentBlock.getChildDepth());
                } else {
                    // set group block
                    movingBlock.setGroupBlock();
                }
                this.reloadBlockList();
            }
        }

        copyBlock(block) {
            const blockIdx = this.blockList.indexOf(block);
            let groupedBlocks = block.getGroupedBlocks();
            let dupPosition = blockIdx + groupedBlocks.length;
            let groupedBlockStateList = [];
            groupedBlocks.forEach((groupBlock, idx) => {
                let menuId = groupBlock.id;
                let popupState = groupBlock.popup.state;
                groupedBlockStateList.push({
                    blockType: 'block',
                    menuId: menuId,
                    menuState: { 
                        taskState: JSON.parse(JSON.stringify(popupState)),
                        blockState: {
                            isGroup: groupBlock.isGroup,
                            depth: groupBlock.depth
                        }
                    },
                    position: dupPosition + idx,
                    createChild: false
                });
            });
            this.prop.parent.createPopup(groupedBlockStateList);
        }

        showMenu(block, left, top) {
            this.blockMenu.open(block, left, top);
        }

        getGroupedBlocks(parentBlock) {
            const parentIdx = this.blockList.indexOf(parentBlock);
            let nextGroupIdx = parentIdx + 1;
            if (parentBlock.canMakeChild()) {
                while (nextGroupIdx < this.blockList.length) {
                    let block = this.blockList[nextGroupIdx];
                    let isGroup = block.isGroup;
                    if (isGroup) {
                        // find next group block
                        break;
                    }
                    let isSubBlock = (this.headBlocks.includes(parentBlock.id) && block.depth == parentBlock.depth && this.subBlocks.includes(block.id));
                    if (!parentBlock.isGroup && !isSubBlock && block.depth <= parentBlock.depth) {
                        break;
                    }
                    nextGroupIdx++;
                }
            }
            // grouped blocks (include this parentBlock)
            let groupedBlocks = this.blockList.slice(parentIdx, nextGroupIdx);
            return groupedBlocks;
        }

        getGroupBlock(thisBlock) {
            if (thisBlock.isGroup) {
                return thisBlock;
            }

            let groupBlockIdx = this.blockList.indexOf(thisBlock) - 1;
            while (groupBlockIdx > 0) {
                if (this.blockList[groupBlockIdx].isGroup) {
                    break;
                }
                groupBlockIdx--;
            }
            return this.blockList[groupBlockIdx];
        }

        blurAllblock() {
            this.blockList.forEach(block => {
                block.blurItem();
            });
        }

        scrollToBlock(block) {
            $(this.wrapSelector('#vp_boardBody')).animate({scrollTop: $(block.getTag()).position().top}, "fast");
        }
        //========================================================================
        // Block sub block control
        //========================================================================
        checkFlag(block) {
            let groupedBlocks = block.getGroupedBlocks();
            let elseBlock = groupedBlocks.filter(obj => (obj.id === 'lgCtrl_else' && obj.depth === block.depth));
            let finallyBlock = groupedBlocks.find(obj => (obj.id === 'lgCtrl_finally' && obj.depth === block.depth));
            block.state.elseFlag = elseBlock!=undefined?true:false;
            block.state.finallyFlag = finallyBlock!=undefined?true:false;
        }
        toggleElseBlock(block) {
            const blockIdx = this.blockList.indexOf(block);
            let groupedBlocks = block.getGroupedBlocks();
            let position = blockIdx + groupedBlocks.length; // add position
            // check if it has else block
            let elseFlag = block.state.elseFlag;
            if (!elseFlag) {
                // if finally is available, change add position
                if (block.state.finallyFlag) {
                    let finallyBlock = groupedBlocks.find(obj => (obj.id === 'lgCtrl_finally' && obj.depth === block.depth));
                    let finallyPosition = this.blockList.indexOf(finallyBlock);
                    position = finallyPosition;
                }
                // add else
                let blockState = {
                    isGroup: false,
                    depth: block.depth
                }
                this.prop.parent.createPopup([{ 
                    blockType: 'block', 
                    menuId: 'lgCtrl_else', 
                    menuState: { blockState: blockState }, 
                    position: position
                }]);
                block.state.elseFlag = true;
                setTimeout(function() {
                    block.focusItem();
                }, 100);
            } else {
                // remove else
                let elseBlock = groupedBlocks.filter(obj => (obj.id === 'lgCtrl_else' && obj.depth === block.depth));
                if (elseBlock.length > 0) {
                    this.removeBlock(elseBlock[0]);
                }
                // focus it
                setTimeout(function() {
                    block.focusItem();
                }, 100);
            }
        }

        toggleFinallyBlock(block) {
            const blockIdx = this.blockList.indexOf(block);
            let groupedBlocks = block.getGroupedBlocks();
            let position = blockIdx + groupedBlocks.length; // add position
            
            // check if it has finally block
            let finallyFlag = block.state.finallyFlag;
            if (!finallyFlag) {
                // add finally
                let blockState = {
                    isGroup: false,
                    depth: block.depth
                }
                this.prop.parent.createPopup([{
                    blockType: 'block', 
                    menuId: 'lgCtrl_finally', 
                    menuState: { blockState: blockState }, 
                    position: position
                }]);
                block.state.finallyFlag = true;
                setTimeout(function() {
                    block.focusItem();
                }, 100);
            } else {
                // remove finally
                let finallyBlock = groupedBlocks.find(obj => (obj.id === 'lgCtrl_finally' && obj.depth === block.depth));
                if (finallyBlock) {
                    this.removeBlock(finallyBlock);
                }
                // focus it
                setTimeout(function() {
                    block.focusItem();
                }, 100);
            }
        }

        addElifBlock(block) {
            const blockIdx = this.blockList.indexOf(block);
            let groupedBlocks = block.getGroupedBlocks();
            let position = blockIdx + groupedBlocks.length; // add position
            // if else is available, change add position
            if (block.state.elseFlag) {
                let elseBlock = groupedBlocks.find(obj => (obj.id === 'lgCtrl_else' && obj.depth === block.depth));
                let elsePosition = this.blockList.indexOf(elseBlock);
                position = elsePosition;
            }
            // add elif
            let blockState = {
                isGroup: false,
                depth: block.depth
            }
            this.prop.parent.createPopup([{
                blockType: 'block', 
                menuId: 'lgCtrl_elif', 
                menuState: { blockState: blockState },
                position: position
            }]);
            setTimeout(function() {
                block.focusItem();
            }, 100);
        }

        addExceptBlock(block) {
            const blockIdx = this.blockList.indexOf(block);
            let groupedBlocks = block.getGroupedBlocks();
            let position = blockIdx + groupedBlocks.length; // add position
            // if finally is available, change add position
            if (block.state.finallyFlag) {
                let finallyBlock = groupedBlocks.find(obj => (obj.id === 'lgCtrl_finally' && obj.depth === block.depth));
                let finallyPosition = this.blockList.indexOf(finallyBlock);
                position = finallyPosition;
            }
            // if else is available, change add position
            if (block.state.elseFlag) {
                let elseBlock = groupedBlocks.find(obj => (obj.id === 'lgCtrl_else' && obj.depth === block.depth));
                let elsePosition = this.blockList.indexOf(elseBlock);
                position = elsePosition;
            }
            // add except
            let blockState = {
                isGroup: false,
                depth: block.depth
            }
            this.prop.parent.createPopup([{
                blockType: 'block', 
                menuId: 'lgCtrl_except', 
                menuState: { blockState: blockState },
                position: position
            }]);
            setTimeout(function() {
                block.focusItem();
            }, 100);
        }

        //========================================================================
        // Block save/load
        //========================================================================
        blockToJson(blockList) {
            let result = [];
            blockList && blockList.forEach(block => {
                let jsonBlock = block.toJson();
                result.push(jsonBlock);
            });
            return result;
        }

        jsonToBlock(jsonList) {
            let parent = this.prop.parent; // MainFrame
            let blockList = [];
            jsonList && jsonList.forEach((obj, idx) => {
                let {
                    isGroup, depth, blockNumber, taskId, taskState
                } = obj;
                let state = {
                    taskState: taskState,
                    blockState: {
                        isGroup: isGroup,
                        depth: depth,
                        blockNumber: blockNumber
                    }
                };
                blockList.push({
                    blockType: 'block', 
                    menuId: taskId, 
                    menuState: state, 
                    position: idx, 
                    createChild: false
                });
            });
            parent.createPopup(blockList);
        }
    } // class

    return BoardFrame;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
/* End of file */

/***/ }),

/***/ "./lib/visualpython/js/board/CodeView.js":
/*!***********************************************!*\
  !*** ./lib/visualpython/js/board/CodeView.js ***!
  \***********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : CodeView.js
 *    Author          : Black Logic
 *    Note            : Render Code view
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 13
 *    Change Date     :
 */

//============================================================================
// [CLASS] CodeView
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! ../com/component/PopupComponent */ "./lib/visualpython/js/com/component/PopupComponent.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(PopupComponent) {
	'use strict';
	
    /**
     * @class CodeView
     * @constructor
     */
    class CodeView extends PopupComponent {
        _init() {
            super._init();

            this.config.footer = false;
            this.config.sizeLevel = 1;

            this.state = {
                codeview: '',
                ...this.state
            }

            this._addCodemirror('codeview', this.wrapSelector('#codeview'), "readonly");
        }

        templateForBody() {
            return `<textarea id="codeview">${this.state.codeview}</textarea>`;
        }
    }

    return CodeView;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/board/__init__.py":
/*!***********************************************!*\
  !*** ./lib/visualpython/js/board/__init__.py ***!
  \***********************************************/
/***/ (() => {

print('Visual Python')


/***/ }),

/***/ "./lib/visualpython/js/com/__init__.py":
/*!*********************************************!*\
  !*** ./lib/visualpython/js/com/__init__.py ***!
  \*********************************************/
/***/ (() => {

print('Visual Python')


/***/ }),

/***/ "./lib/visualpython/js/com/com_Config.js":
/*!***********************************************!*\
  !*** ./lib/visualpython/js/com/com_Config.js ***!
  \***********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_Config.js
 *    Author          : Black Logic
 *    Note            : Configuration and settings control
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 16
 *    Change Date     :
 */
//============================================================================
// [CLASS] Configuration
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! ./com_Const */ "./lib/visualpython/js/com/com_Const.js"), 
    __webpack_require__(/*! ./com_util */ "./lib/visualpython/js/com/com_util.js"), 
    __webpack_require__(/*! ./com_interface */ "./lib/visualpython/js/com/com_interface.js"),
    __webpack_require__(/*! !!text-loader!vp_base/python/userCommand.py */ "./node_modules/text-loader/index.js!./lib/visualpython/python/userCommand.py"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! !!text-loader!vp_base/python/printCommand.py */ "./node_modules/text-loader/index.js!./lib/visualpython/python/printCommand.py"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! !!text-loader!vp_base/python/fileNaviCommand.py */ "./node_modules/text-loader/index.js!./lib/visualpython/python/fileNaviCommand.py"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! !!text-loader!vp_base/python/pandasCommand.py */ "./node_modules/text-loader/index.js!./lib/visualpython/python/pandasCommand.py"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! !!text-loader!vp_base/python/variableCommand.py */ "./node_modules/text-loader/index.js!./lib/visualpython/python/variableCommand.py"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! !!text-loader!vp_base/python/visualizationCommand.py */ "./node_modules/text-loader/index.js!./lib/visualpython/python/visualizationCommand.py") // INTEGRATION: unified version of text loader
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_Const, com_util, com_interface, 
            userCommandFile, printCommand, fileNaviCommand, pandasCommand, variableCommand, visualizationCommand) {
	'use strict';
    //========================================================================
    // Define Inner Variable
    //========================================================================
    /**
     * Type of mode
     */
    const _MODE_TYPE = {
        DEVELOP : 0,
        RELEASE : 1
    }

    //========================================================================
    // Declare Class
    //========================================================================
    /**
     * Configuration and settings
     */
    class Config {
        //========================================================================
        // Constructor
        //========================================================================
        /**
         * 
         * @param {*} initialData 
         * @param {*} extensionType      extension type: notebook/colab/lab
         */
        constructor(extensionType='notebook', initialData={}) {
            // initial mode
            this.extensionType = extensionType;
            this.parentSelector = 'body';
            if (extensionType === 'notebook') {
                this.parentSelector = '#site';
            } else if (extensionType === 'colab' || extensionType === 'lab') {
                // this.parentSelector = '.notebook-horizontal';
                this.parentSelector = 'body';
            }
            // initial configuration
            this.data = {
                // Configuration
                'vpcfg': {
                    
                },
                // User defined code for Snippets
                'vpudf': {
                    'default import': [
                        'import numpy as np',
                        'import pandas as pd',
                        'import matplotlib.pyplot as plt',
                        '%matplotlib inline',
                        'import seaborn as sns',
                        'import plotly.express as px'
                    ],
                    'matplotlib customizing': [
                        'import matplotlib.pyplot as plt',
                        '%matplotlib inline',
                        '',
                        "plt.rc('figure', figsize=(12, 8))",
                        '',
                        'from matplotlib import rcParams',
                        "rcParams['font.family'] = 'New Gulim'",
                        "rcParams['font.size'] = 10",
                        "rcParams['axes.unicode_minus'] = False"
                    ],
                    'as_float': [
                        'def as_float(x):',
                        '    """',
                        "    usage: df['col'] = df['col'].apply(as_float)",
                        '    """',
                        '    if not isinstance(x, str):',
                        '        return 0.0',
                        '    else:',
                        '        try:',
                        '            result = float(x)',
                        '            return result',
                        '        except ValueError:',
                        '            return 0.0'
                    ],
                    'as_int': [
                        'def as_int(x):',
                        '    """',
                        "    usage: df['col'] = df['col'].apply(as_int)",
                        '    """',
                        '    if not isinstance(x, str):',
                        '        return 0',
                        '    else:',
                        '        try:',
                        '            result = int(x)',
                        '            return result',
                        '        except ValueError:',
                        '            return 0.0'
                    ]
                },
                'vpimport': [
                    { library: 'numpy', alias:'np' },
                    { library: 'pandas', alias:'pd' },
                    { library: 'matplotlib.pyplot', alias:'plt',
                        include: [
                            '%matplotlib inline'
                        ]
                    },
                    { library: 'seaborn', alias:'sns' },
                    {
                        library: 'plotly.express', alias: 'px',
                        include: [
                            'from plotly.offline import init_notebook_mode',
                            'init_notebook_mode(connected=True)'
                        ]
                    }
                ]
            }

            this.data = {
                ...this.data,
                ...initialData
            }

            this.defaultConfig = {};
            this.metadataSettings = {};

            this.moduleDict = {
                'np': {
                    code: 'import numpy as np',
                    type: 'package'
                },
                'pd': {
                    code: 'import pandas as pd',
                    type: 'package'
                },
                'plt': {
                    code: 'import matplotlib.pyplot as plt\n%matplotlib inline',
                    type: 'package'
                },
                'sns': {
                    code: 'import seaborn as sns',
                    type: 'package'
                },
                'metrics': {
                    code: 'from sklearn import metrics',
                    type: 'package'
                },
                'ProfileReport': {
                    code: 'from pandas_profiling import ProfileReport',
                    type: 'package'
                },
                'px': {
                    code: 'import plotly.express as px\nfrom plotly.offline import init_notebook_mode\ninit_notebook_mode(connected=True)',
                    type: 'package'
                },
                'WordCloud': {
                    code: 'from wordcloud import WordCloud',
                    type: 'package'
                },
                'fitz': {
                    code: 'import fitz',
                    type: 'package'
                },
                'nltk': {
                    code: "import nltk\nnltk.download('punkt')",
                    type: 'package'
                },
                'Counter': {
                    code: 'from collections import Counter',
                    type: 'package'
                }
            }

            this._readDefaultConfig();
            this._readUserCommandList();
            
        }

        /**
         * Read dejault config
         */
        _readDefaultConfig() {
            // default values for system-wide configurable parameters
            this.defaultConfig = {
                indent: 4
            };
            // default values for per-notebook configurable parameters
            this.metadataSettings = {
                vp_config_version: '1.0.0',
                vp_signature: 'VisualPython',
                vp_position: {},
                // CHROME: default to display vp
                vp_section_display: true,
                vp_note_display: false,
                vp_menu_width: Config.MENU_MIN_WIDTH,
                vp_note_width: Config.BOARD_MIN_WIDTH
            };
            
            let vp_width = Config.MENU_MIN_WIDTH + (this.metadataSettings.vp_note_display? Config.BOARD_MIN_WIDTH: 0) + Config.MENU_BOARD_SPACING;
            this.metadataSettings['vp_position'] = {
                // height: 'calc(100% - 110px)',
                // width: vp_width + 'px',
                // right: '0px',
                // top: '110px',
                width: vp_width
            }
        
            // merge default config
            $.extend(true, this.defaultConfig, this.metadataSettings);
        }

        _readUserCommandList() {
            let divider = '#'.repeat(6);
            // get list of codes (ignore first 2 items)
            let tmpList = userCommandFile.split(divider).slice(2);

            // match key-codes-description
            // { 'func_name': { code: '', description: '' } }
            let funcDict = {};
            let reg = /^def (.+)\(/;
            let name = '';
            let code = '';
            let desc = '';
            let packageAlias = {
                '_vp_np': 'np',
                '_vp_pd': 'pd',
                '_vp_plt': 'plt'
            }

            for (let i = 0; i < tmpList.length; i += 2) {
                desc = tmpList[i].trim();
                code = tmpList[i + 1].trim();
                let regResult = reg.exec(code);
                if (regResult !== null) {
                    name = regResult[1];
                    // convert code's package alias
                    Object.keys(packageAlias).forEach(key => {
                        let desAlias = packageAlias[key];
                        code = code.replaceAll(key + '.', desAlias + '.');
                    });
                    // list up
                    funcDict[name] = { code: code, type: 'function', description: desc };
                }
            }

            this.moduleDict = {
                ...this.moduleDict,
                ...funcDict
            }
        }

        /**
         * Read kernel functions for using visualpython
         * - manually click restart menu (MenuFrame.js)
         * - automatically restart on jupyter kernel restart (loadVisualpython.js)
         */
        readKernelFunction() {
            // CHROME: change method to load py files ($.get -> require)
            return new Promise(function(resolve, reject) {
                var libraryList = [ 
                    printCommand, fileNaviCommand, pandasCommand, variableCommand, visualizationCommand
                ];
                let promiseList = [];
                // libraryList.forEach(libName => {
                //     var libPath = com_Const.PYTHON_PATH + libName;
                //     $.get(libPath).done(function(data) {
                //         var code_init = data;
                //         promiseList.push(vpKernel.execute(code_init, true));
                //     }).fail(function() {
                //         console.log('visualpython - failed to read library file', libName);
                //     });
                // });
                libraryList.forEach(libCode => {
                    promiseList.push(vpKernel.execute(libCode, true));
                });
                
                // run all promises
                let failed = false;
                Promise.all(promiseList).then(function(resultObj) {
                    ;
                }).catch(function(resultObj) {
                    failed = true;
                    console.log('visualpython - failed to load library', resultObj);
                    // TODO: show to restart kernel
                }).finally(function() {
                    if (!failed) {
                        console.log('visualpython - loaded libraries', libraryList);
                        resolve(true);
                    } else {
                        reject(false);
                    }
                });
            });
            
        }

        getMode() {
            return Config.serverMode;
        }

        _checkMounted() {
            return new Promise(function(resolve, reject) {
                try {
                    vpKernel.getColabMounted().then(function(result) {
                        if (result==='True') {
                            resolve(true);
                        } else {
                            reject(false);
                        }
                    }).catch(function(err) {
                        reject(false);
                    })
                } catch (ex) {
                    reject(false);
                }
            });
        }

        /**
         * CHROME: Read from colab
         * @param {*} configKey config key to read
         */
        _readFromColab(configKey='vpudf') {
            return new Promise(function(resolve, reject) {
                // mounted
                // read /content/drive/MyDrive/.visualpython
                vpKernel.getColabConfig(configKey).then(function(resultObj) {
                    let { result } = resultObj;
                    try {
                        if (result && result.trim() != '') {
                            let parsedResult = JSON.parse(result);
                            resolve(parsedResult);
                        } else {
                            resolve({});
                        }
                    } catch (err) {
                        reject(err);
                    }
                }).catch(function(err) {
                    reject(err);
                })
            });
        }

        /**
         * CHROME: Write to colab
         * @param {*} data data to write
         */
        _writeToColab(data={}, configKey='vpudf') {
            return new Promise(function(resolve, reject) {
                // mounted
                // write to /content/drive/MyDrive/.visualpython
                vpKernel.setColabConfig(JSON.stringify(data), configKey).then(function(result) {
                    resolve(result);
                }).catch(function(err) {
                    reject(err);
                });
            });
        }

        /**
         * LAB: Read from lab
         * @param {*} configKey config key to read
         */
        _readFromLab(configKey='vpudf') {
            return new Promise(function(resolve, reject) {
                // mounted
                // read USER_PATH/.visualpython
                vpKernel.getLabConfig(configKey).then(function(resultObj) {
                    let { result } = resultObj;
                    try {
                        if (result && result.trim() != '') {
                            let parsedResult = JSON.parse(result);
                            resolve(parsedResult);
                        } else {
                            resolve({});
                        }
                    } catch (err) {
                        reject(err);
                    }
                }).catch(function(err) {
                    reject(err);
                })
            });
        }

        /**
         * LAB: Write to lab
         * @param {*} data data to write
         */
        _writeToLab(data={}, configKey='vpudf') {
            return new Promise(function(resolve, reject) {
                // write to USER_PATH/.visualpython
                vpKernel.setLabConfig(JSON.stringify(data), configKey).then(function(result) {
                    resolve(result);
                }).catch(function(err) {
                    reject(err);
                });
            });
        }

        loadData(configKey = 'vpudf') {
            let that = this;
            return new Promise(function(resolve, reject) {
                if (that.extensionType === 'notebook') {
                    Jupyter.notebook.config.load();
                    Jupyter.notebook.config.loaded.then(function() {
                        var data = Jupyter.notebook.config.data[configKey];
                        if (data == undefined) {
                            data = {};
                        }
                        resolve(data);
                    });
                } else if (that.extensionType === 'colab') {
                    // CHROME: edited to use .visualpython files
                    that._checkMounted().then(function() {
                        that._readFromColab('', configKey).then(function(result) {
                            resolve(result);
                        }).catch(function(err) {
                            reject(err);
                        })
                    }).catch(function() {
                        // not mounted
                        reject('Colab Drive is not mounted!');
                    })
                } else if (that.extensionType === 'lab') {
                    // CHROME: edited to use .visualpython files
                    that._readFromLab('', configKey).then(function(result) {
                        resolve(result);
                    }).catch(function(err) {
                        reject(err);
                    })
                }
            });
        };

        /**
         * Get configuration data (on server)
         * @param {String} dataKey 
         * @param {String} configKey 
         * @returns 
         */
        getData(dataKey='', configKey='vpudf') {
            let that = this;
            return new Promise(function(resolve, reject) {
                if (that.extensionType === 'notebook') {
                    Jupyter.notebook.config.load();
                    Jupyter.notebook.config.loaded.then(function() {
                        var data = Jupyter.notebook.config.data[configKey];
                        if (data == undefined) {
                            resolve(data);
                            return;
                        }
                        if (dataKey == '') {
                            resolve(data);
                            return;
                        }
                        if (Object.keys(data).length > 0) {
                            resolve(data[dataKey]);
                            return;
                        }
                        reject('No data available.');
                    });
                } else if (that.extensionType === 'colab') {
                    // CHROME: use drive .visualpython files
                    that._checkMounted().then(function() {
                        that._readFromColab(configKey).then(function(result) {
                            let data = result;
                            if (data == undefined || data == {}) {
                                resolve(data);
                                return;
                            }
                            if (dataKey == '') {
                                resolve(data);
                                return;
                            }
                            if (Object.keys(data).length > 0) {
                                resolve(data[dataKey]);
                                return;
                            }
                            reject('No data available.');
                        }).catch(function(err) {
                            reject(err);
                        })
                    }).catch(function() {
                        // not mounted
                        reject('Colab Drive is not mounted!');
                    })
                } else if (that.extensionType === 'lab') {
                    // LAB: use local .visualpython files
                    that._readFromLab(configKey).then(function(result) {
                        let data = result;
                        if (data == undefined || data == {}) {
                            resolve(data);
                            return;
                        }
                        if (dataKey == '') {
                            resolve(data);
                            return;
                        }
                        if (Object.keys(data).length > 0) {
                            resolve(data[dataKey]);
                            return;
                        }
                        reject('No data available.');
                    }).catch(function(err) {
                        reject(err);
                    })
                }
            });
        }

        getDataSimple(dataKey='', configKey='vpudf') {
            if (this.extensionType === 'notebook') {
                Jupyter.notebook.config.load();
                var data = Jupyter.notebook.config.data[configKey];
                if (data == undefined) {
                    return undefined;
                }
                if (dataKey == '') {
                    return data;
                }
                if (Object.keys(data).length > 0) {
                    return data[dataKey];
                }
            } else if (this.extensionType === 'colab') {
                // CHROME: TODO: no way to simply get data
                return undefined;
            }
            
            return undefined;
        }

        /**
         * Set configuration data (on server)
         * @param {Object} dataObj 
         * @param {String} configKey 
         */
        setData(dataObj, configKey='vpudf') {
            let that = this;
            return new Promise(function(resolve, reject) {
                if (that.extensionType === 'notebook') {
                    // set data using key
                    Jupyter.notebook.config.loaded.then(function() {
                        Jupyter.notebook.config.update({[configKey]: dataObj});
                        resolve(true);
                    });
                } else if (that.extensionType === 'colab') {
                    // CHROME: use .visualpython files
                    that.getData('', configKey).then(function(data) {
                        let newDataObj = {};
                        if (data && typeof data === 'object') {
                            newDataObj = {
                                ...data
                            };
                        }
                        newDataObj = {
                            ...newDataObj,
                            ...dataObj
                        }
                        that._writeToColab(newDataObj, configKey).then(function() {
                            resolve();
                        }).catch(function() {
                            reject();
                        });
                    });
                } else if (that.extensionType === 'lab') {
                    // LAB: use .visualpython files
                    that.getData('', configKey).then(function(data) {
                        let newDataObj = {};
                        if (data && typeof data === 'object') {
                            newDataObj = {
                                ...data
                            };
                        }
                        newDataObj = {
                            ...newDataObj,
                            ...dataObj
                        }
                        that._writeToLab(newDataObj, configKey).then(function() {
                            resolve();
                        }).catch(function() {
                            reject();
                        });
                    });
                }
            });
        }

        removeData(key, configKey = 'vpudf') {
            let that = this;
            return new Promise(function(resolve, reject) {
                if (that.extensionType === 'notebook') {
                    // if set value to null, it removes from config data
                    Jupyter.notebook.config.loaded.then(function() {
                        Jupyter.notebook.config.update({[configKey]: {[key]: null}});
                    });
                    resolve(true);
                } else if (that.extensionType === 'colab') {
                    // CHROME: use .visualpython files
                    that.getData('', configKey).then(function(data) {
                        let dataObj = data;
                        delete dataObj[key];
                        that._writeToColab(dataObj, configKey).then(function() {
                            resolve(true);
                        }).catch(function() {
                            reject(false);
                        });
                    }).catch(function(err) {
                        reject(false);
                    })
                } else if (that.extensionType === 'lab') {
                    // LAB: use .visualpython files
                    that.getData('', configKey).then(function(data) {
                        let dataObj = data;
                        delete dataObj[key];
                        that._writeToLab(dataObj, configKey).then(function() {
                            resolve(true);
                        }).catch(function() {
                            reject(false);
                        });
                    }).catch(function(err) {
                        reject(false);
                    })
                }
            });
        }

        /**
         * Get metadata (on jupyter file)
         * @param {String} dataKey 
         * @param {String} configKey 
         */
        getMetadata(dataKey='', configKey='vp') {
            if (this.extensionType === 'notebook') {
                let metadata = Jupyter.notebook.metadata[configKey];
                if (metadata) {
                    // update this metadataSetting
                    this.metadataSettings = {
                        ...this.metadataSettings,
                        ...metadata
                    };
                    // no datakey, return all metadata
                    if (dataKey == '') {
                        return metadata;
                    }
                    return metadata[dataKey];
                }
            } else if (this.extensionType === 'colab') {
                // CHROME: use colab.global.notebookModel.metadata
                let metadata = colab.global.notebookModel.metadata[configKey];
                if (metadata) {
                    // update this metadataSetting
                    this.metadataSettings = {
                        ...this.metadataSettings,
                        ...metadata
                    };
                    // no datakey, return all metadata
                    if (dataKey == '') {
                        return metadata;
                    }
                    return metadata[dataKey];
                }
            } 
            return {};
        }

        /**
         * Set metadata (on jupyter file)
         * @param {Object} dataObj 
         * @param {String} configKey 
         */
        setMetadata(dataObj, configKey='vp') {
            if (this.extensionType === 'notebook') {
                let oldData = Jupyter.notebook.metadata[configKey];
                Jupyter.notebook.metadata[configKey] = {
                    ...oldData,
                    ...dataObj
                };
                Jupyter.notebook.set_dirty();

            } else if (this.extensionType === 'colab') {
                // CHROME: use colab.global.notebookModel.metadata
                let oldData = colab.global.notebookModel.metadata[configKey];
                colab.global.notebookModel.metadata[configKey] = {
                    ...oldData,
                    ...dataObj
                };
            }

            // update this metadataSetting
            this.metadataSettings = {
                ...this.metadataSettings,
                ...dataObj
            };
        }

        /**
         * Reset metadata (on jupyter file)
         * @param {String} configKey 
         */
        resetMetadata(configKey='vp') {
            if (this.extensionType === 'notebook') {
                Jupyter.notebook.metadata[configKey] = {};
            } else if (this.extensionType === 'colab') {
                // CHROME: use colab.global.notebookModel.metadata
                colab.global.notebookModel.metadata[configKey] = {};
            }
        }

        /**
         * Check vp pypi package version (Promise)
         * usage:
         *  vpConfig.getPackageVersion('visualpython').then(function(version) {
         *      // do something after loading version
         *      ...
         *  }).catch(function(err) {
         *      // error handling
         *      ...
         *  })
         */
        getPackageVersion(packName='visualpython') {
            let url = `https://pypi.org/pypi/${packName}/json`;
            // using the Fetch API
            return new Promise(function(resolve, reject) {
                try {
                    fetch(url).then(function (response) {
                        // if (response.statusCode === 200) {
                        //     return response.json();
                        // } else if (response.statusCode === 204) {
                        //     throw new Error('No Contents', response);
                        // } else if (response.statusCode === 404) {
                        //     throw new Error('Page Not Found', response);
                        // } else if (response.statusCode === 500) {
                        //     throw new Error('Internal Server Error', response);
                        // } else {
                        //     throw new Error('Unexpected Http Status Code', response);
                        // }
                        if (response.ok) {
                            return response.json();
                        } else {
                            throw new Error('Error', response);
                        }
                    }).then(function (data) {
                        resolve(data.info.version);
                    }).catch(function(err) {
                        let errMsg = err.message;
                        if (errMsg.includes('Failed to fetch')) {
                            errMsg = 'Network connection error';
                        }
                        reject(errMsg);
                    });
                } catch (err) {
                    reject(err);
                }
            });
        }
        
        getVpInstalledVersion() {
            return Config.version;
        }

        checkVpVersion(background=false) {
            let that = this;
            let nowVersion = this.getVpInstalledVersion();
            this.getPackageVersion().then(function(latestVersion) {
                if (nowVersion === latestVersion) {
                    // if it's already up to date
                    // hide version update icon
                    $('#vp_versionUpdater').hide();
                    if (background) {
                        ;
                    } else {
                        let msg = com_util.formatString('Visual Python is up to date. ({0})', latestVersion);
                        com_util.renderInfoModal(msg);
                    }
                    // update version_timestamp
                    that.setData({ 'version_timestamp': new Date().getTime() }, 'vpcfg');
                } else {
                    let msg = com_util.formatString('Visual Python updates are available.<br/>(Latest version: {0} / Your version: {1})', 
                                    latestVersion, nowVersion);
                    // show version update icon
                    $('#vp_versionUpdater').attr('title', msg.replace('<br/>', ''));
                    $('#vp_versionUpdater').data('version', latestVersion);
                    $('#vp_versionUpdater').show();
                    
                    // render update modal
                    com_util.renderModal({
                        title: 'Update version', 
                        message: msg,
                        buttons: ['Cancel', 'Update'],
                        defaultButtonIdx: 0,
                        buttonClass: ['cancel', 'activated'],
                        finish: function(clickedBtnIdx) {
                            switch (clickedBtnIdx) {
                                case 0:
                                    // cancel
                                    break;
                                case 1:
                                    // update
                                    if (that.extensionType === 'notebook') {
                                        let info = [
                                            '## Visual Python Upgrade',
                                            'NOTE: ',
                                            '- Refresh your web browser to start a new version.',
                                            '- Save VP Note before refreshing the page.'
                                        ];
                                        com_interface.insertCell('markdown', info.join('\n'));
                                        com_interface.insertCell('code', '!pip install visualpython --upgrade');
                                        com_interface.insertCell('code', '!visualpy install');
                                    } else if (that.extensionType === 'colab') {
                                        // CHROME: update chrome extension
                                        let info = [
                                            '## Visual Python Upgrade',
                                            'NOTE: ',
                                            '- Go to chrome webstore and update visualpython',
                                            '- Refresh your web browser to start a new version.',
                                            '- Save VP Note before refreshing the page.'
                                        ];
                                        com_interface.insertCell('markdown', info.join('\n'));
                                    } else if (that.extensionType === 'lab') {
                                        // LAB: update lab extension
                                        let info = [
                                            '## Visual Python Upgrade',
                                            'NOTE: ',
                                            '- Refresh your web browser to start a new version.',
                                            '- Save VP Note before refreshing the page.'
                                        ];
                                        com_interface.insertCell('markdown', info.join('\n'));
                                        com_interface.insertCell('code', '!pip install jupyterlab-visualpython --upgrade');
                                    }

                                    // update version_timestamp
                                    that.setData({ 'version_timestamp': new Date().getTime() }, 'vpcfg');
                                    // hide updater
                                    $('#vp_versionUpdater').hide();
                                    break;
                            }
                        }
                    });
                }
            }).catch(function(err) {
                if (background) {
                    vpLog.display(VP_LOG_TYPE.ERROR, 'Version Checker - ' + err);
                } else {
                    com_util.renderAlertModal(err);
                }
            })
        }

        getMenuGroupLabel(key = '') {
            return Config.MENU_GROUP_DICT[key];
        }

        getMenuGroupDict() {
            return Config.MENU_GROUP_DICT;
        }

        getDataTypes() {
            return Config.DATA_TYPES;
        }

        getMLDataDict(key = '') {
            if (key == '') {
                return Config.ML_DATA_DICT;
            }
            return Config.ML_DATA_DICT[key];
        }

        getMLDataTypes() {
            return Config.ML_DATA_TYPES;
        }

        getMLCategories() {
            return Object.keys(Config.ML_DATA_DICT);
        }

        getModuleCode(modName='') {
            if (modName == '') {
                return this.moduleDict;
            }
            try {
                return this.moduleDict[modName];
            } catch {
                return null;
            }
        }

    }

    //========================================================================
    // Define static variable
    //========================================================================
    /**
     * FIXME: before release, change it to _MODE_TYPE.RELEASE
     */
    // Config.serverMode = _MODE_TYPE.DEVELOP;
    Config.serverMode = _MODE_TYPE.RELEASE; 

    /**
     * Version
     */
    Config.version = "2.3.0";

    /**
     * Type of mode
     */
    Config.MODE_TYPE = _MODE_TYPE;

    /**
     * Frame size settings
     */
    Config.JUPYTER_HEADER_SPACING = 110;
    Config.MENU_MIN_WIDTH = 273;
    Config.BOARD_MIN_WIDTH = 263;
    Config.MENU_BOARD_SPACING = 5;
    Config.VP_MIN_WIDTH = Config.MENU_MIN_WIDTH + Config.BOARD_MIN_WIDTH + Config.MENU_BOARD_SPACING; // = MENU_MIN_WIDTH + BOARD_MIN_WIDTH + MENU_BOARD_SPACING

    /**
     * Menu group codes
     */
    Config.MENU_GROUP_DICT = {
        '': '',
        'logic': 'Logic',
        'library': 'Library',
        'apps': 'Data Analysis',
        'visualization': 'Visualization',
        'machine_learning': 'Machine Learning'
    }    
    /**
     * Data types
     */
    Config.DATA_TYPES = [
        // pandas object
        'DataFrame', 'Series', 'Index', 'Period', 'GroupBy', 'Timestamp'
        // Index type object
        , 'RangeIndex', 'CategoricalIndex', 'MultiIndex', 'IntervalIndex', 'DatetimeIndex', 'TimedeltaIndex', 'PeriodIndex', 'Int64Index', 'UInt64Index', 'Float64Index'
        // GroupBy type object
        , 'DataFrameGroupBy', 'SeriesGroupBy'
        // Plot type
        , 'Figure', 'AxesSubplot'
        // Numpy
        , 'ndarray'
        // Python variable
        , 'str', 'int', 'float', 'bool', 'dict', 'list', 'tuple'
    ]

    /**
     * Data types using for searching model variables
     */
    Config.ML_DATA_DICT = {
        'Data Preparation': [
            /** Encoding */
            'OneHotEncoder', 'LabelEncoder', 'OrdinalEncoder', 'TargetEncoder', 'SMOTE',
            /** Scaling */
            'StandardScaler', 'RobustScaler', 'MinMaxScaler', 'Normalizer', 'FunctionTransformer', 'PolynomialFeatures', 'KBinsDiscretizer',
            /** ETC */
            'ColumnTransformer'
        ],
        'Regression': [
            'LinearRegression', 'Ridge', 'Lasso', 'ElasticNet', 'SVR', 'DecisionTreeRegressor', 'RandomForestRegressor', 'GradientBoostingRegressor', 'XGBRegressor', 'LGBMRegressor', 'CatBoostRegressor',
        ],
        'Classification': [
            'LogisticRegression', 'BernoulliNB', 'MultinomialNB', 'GaussianNB', 'SVC', 'DecisionTreeClassifier', 'RandomForestClassifier', 'GradientBoostingClassifier', 'XGBClassifier', 'LGBMClassifier', 'CatBoostClassifier',
        ],
        'Clustering': [
            'KMeans', 'AgglomerativeClustering', 'GaussianMixture', 'DBSCAN',
        ],
        'Dimension Reduction': [
            'PCA', 'LinearDiscriminantAnalysis', 'TruncatedSVD', 'NMF', 'TSNE'
        ],
        'Auto ML': [
            'AutoSklearnRegressor', 'AutoSklearnClassifier', 'TPOTRegressor', 'TPOTClassifier'
        ]
    };

    Config.ML_DATA_TYPES = [
        ...Config.ML_DATA_DICT['Data Preparation'],
        ...Config.ML_DATA_DICT['Regression'],
        ...Config.ML_DATA_DICT['Classification'],
        ...Config.ML_DATA_DICT['Clustering'],
        ...Config.ML_DATA_DICT['Dimension Reduction'],
        ...Config.ML_DATA_DICT['Auto ML']
    ];

    return Config;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/* End of file */


/***/ }),

/***/ "./lib/visualpython/js/com/com_Const.js":
/*!**********************************************!*\
  !*** ./lib/visualpython/js/com/com_Const.js ***!
  \**********************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_Const.js
 *    Author          : Black Logic
 *    Note            : Define constant value
 *    License         : GPLv3 (GNU General Public License v3.0)
 *    Date            : 2021. 08. 14
 *    Change Date     :
 */

//============================================================================
// Define constant
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
    "use strict";

    class Constants { }

    Constants.TOOLBAR_BTN_INFO = {
        HELP: "Visual Python 2.3.0"
        , ICON: "vp-main-icon"
        , ID: "vpBtnToggle"
        , NAME: "toggle-vp"
        , PREFIX: "vp"
        , ICON_CONTAINER: ""
    }

    //========================================================================
    // Base Path Constants
    //========================================================================
    Constants.PATH_SEPARATOR = "/";
    // CHROME: edited
    // Constants.BASE_PATH = Jupyter.notebook.base_url + "nbextensions" + Constants.PATH_SEPARATOR + "visualpython" + Constants.PATH_SEPARATOR;
    Constants.BASE_PATH = vpBase + "visualpython" + Constants.PATH_SEPARATOR;
    
    Constants.SOURCE_PATH   = Constants.BASE_PATH + "js" + Constants.PATH_SEPARATOR;
    Constants.IMAGE_PATH = Constants.BASE_PATH + "img" + Constants.PATH_SEPARATOR;
    Constants.STYLE_PATH    = Constants.BASE_PATH + "css" + Constants.PATH_SEPARATOR;
    Constants.DATA_PATH     = Constants.BASE_PATH + "data" + Constants.PATH_SEPARATOR;
    Constants.PYTHON_PATH   = Constants.BASE_PATH + "python" + Constants.PATH_SEPARATOR;

    Constants.MAIN_CSS_URL  = Constants.STYLE_PATH + "index.css";
    Constants.VP_LIBRARIES_JSON_URL = Constants.DATA_PATH + "libraries.json";

    //========================================================================
    // HTML selectors
    //========================================================================
    Constants.VP_CONTAINER_ID = 'vp_wrapper';
    Constants.JUPYTER_NOTEBOOK_ID = 'site';
    Constants.JUPYTER_HEADER_ID = 'header';

    return Constants;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/com_Event.js":
/*!**********************************************!*\
  !*** ./lib/visualpython/js/com/com_Event.js ***!
  \**********************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_Event.js
 *    Author          : Black Logic
 *    Note            : Manage global trigger events
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 10
 *    Change Date     :
 */

//============================================================================
// [CLASS] Event
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
	'use strict';

    //========================================================================
    // Declare Class
    //========================================================================
    class Event {

        constructor(mainFrame) {
            this.mainFrame = mainFrame;
            this.useHotkey = true;

            var that = this;

            /** GLOBAL keyBoardManager */
            this.keyManager = {
                keyCode : {
                    ctrlKey: 17,
                    cmdKey: 91,
                    shiftKey: 16,
                    altKey: 18,
                    enter: 13,
                    escKey: 27,
                    vKey: 86,
                    cKey: 67
                },
                keyCheck : {
                    ctrlKey: false,
                    shiftKey: false
                }
            };

            this._globalEvent = [
                {
                    method: 'click focus',
                    operation: (evt) => {
                        var target = evt.target;
                        // Focus recognization
                        // blurred on popup frame
                        if ($('.vp-popup-frame').has(target).length <= 0) {
                            $('#vp_wrapper').trigger({
                                type: 'blur_option_page'
                            });
                        }
                        // Close on blur
                        // if (!$(target).hasClass('vp-close-on-blur-btn') && !$(target).hasClass('vp-close-on-blur')) {
                        if ($('.vp-close-on-blur-btn').find(target).length == 0 
                            && !$(target).hasClass('vp-close-on-blur') 
                            && $('.vp-close-on-blur').find(target).length == 0) {
                            $('.vp-close-on-blur').hide();
                        }
                        // VarSelector filter box
                        if ($('.vp-vs-blur-btn').find(target).length == 0 
                            && !$(target).hasClass('vp-vs-blur-btn')
                            && $('.vp-vs-blur-btn').find(target).length == 0) {
                            $('.vp-vs-blur').removeClass('vp-inline-block');
                        }
                    }
                },
                { 
                    method: 'click', 
                    selector: '.vp-accordian', 
                    operation: (evt) => {
                        var target = evt.currentTarget;
                        if ($(target).hasClass('vp-open')) {
                            // open -> close
                            $(target).removeClass('vp-open');
                            $(target).addClass('vp-close');

                        } else {
                            // close -> open
                            $(target).removeClass('vp-close');
                            $(target).addClass('vp-open');
                        }
                    }
                },
                {
                    method: 'create_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        // blockType: block/task / menuItem: menu id / menuState: saved state
                        let { blockType, menuId, menuState, position, createChild, afterAction } = evt;
                        let dupTask = that.mainFrame.checkDuplicatedTask(menuId);
                        if (blockType == 'task' && dupTask) {
                            // if duplicated, open its task
                            that.mainFrame.openPopup(dupTask);
                        } else {
                            that.mainFrame.createPopup([{
                                blockType: blockType, 
                                menuId: menuId, 
                                menuState: menuState, 
                                position: position, 
                                createChild: createChild, 
                                afterAction: afterAction
                            }]);
                        }
                    }
                },
                {
                    method: 'open_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        var { component } = evt;
                        that.mainFrame.openPopup(component);
                    }
                },
                {
                    method: 'close_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        var { component } = evt;
                        that.mainFrame.closePopup(component);
                    }
                },
                {
                    method: 'apply_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        var { component } = evt;
                        that.mainFrame.applyPopup(component);
                    }
                },
                {
                    method: 'focus_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        var { component } = evt;
                        that.mainFrame.focusPopup(component);
                    }
                },
                {
                    method: 'blur_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        var { component } = evt;
                        that.mainFrame.blurPopup(component);
                    }
                },
                {
                    method: 'blur_all_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        that.mainFrame.blurPopup();
                    }
                },
                {
                    method: 'remove_option_page',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        var { component } = evt;
                        that.mainFrame.removePopup(component);
                    }
                },
                {
                    method: 'disable_vp_hotkey',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        // disable vp hotkey
                        that.disableHotkey();
                    }
                },
                {
                    method: 'enable_vp_hotkey',
                    selector: '#vp_wrapper',
                    operation: (evt) => {
                        // enable vp hotkey
                        that.enableHotkey();
                    }
                }
            ]

            this._keyEvent = [
                {
                    method: 'keydown',
                    selector: document,
                    operation: (evt) => {
                        if (evt.keyCode == that.keyManager.keyCode.ctrlKey || evt.keyCode == that.keyManager.keyCode.cmdKey) {
                            that.keyManager.keyCheck.ctrlKey = true;
                        }
                        if (evt.keyCode == that.keyManager.keyCode.shiftKey) {
                            that.keyManager.keyCheck.shiftKey = true;
                        }
                    }
                },
                {
                    method: 'keyup',
                    selector: document,
                    operation: (evt) => {
                        if (evt.keyCode == that.keyManager.keyCode.ctrlKey || evt.keyCode == that.keyManager.keyCode.cmdKey) {
                            that.keyManager.keyCheck.ctrlKey = false;
                        }
                        if (evt.keyCode == that.keyManager.keyCode.shiftKey) {
                            that.keyManager.keyCheck.shiftKey = false;
                        }
                        if (evt.keyCode == that.keyManager.keyCode.escKey) {
                            // check if there is visible data selector : DataSelector
                            if ($('.vp-dataselector-base:visible').length > 0) {
                                // close data selector
                                $('.vp-dataselector-base:visible').remove();
                            }
                            // check if there is visible inner popup
                            else if ($('.vp-popup-frame > .vp-inner-popup-box:visible').length > 0) {
                                // close inner popup on esc
                                that.mainFrame.focusedPage && that.mainFrame.focusedPage.closeInnerPopup();
                            } else {
                                // close popup on esc
                                $('#vp_wrapper').trigger({
                                    type: 'close_option_page',
                                    component: that.mainFrame.focusedPage
                                });
                            }
                        }
                        if (evt.keyCode == that.keyManager.keyCode.enter) {
                            // blur on enter
                            var target = evt.target;
                            if ($(target).hasClass('vp-blur-on-enter')) {
                                $(target).blur();
                            }
                        }
                    }
                }
            ]

            this._loadKeyEvent();
            this._loadGlobalEvent();

            // jquery custom method : single double click event
            $.fn.single_double_click = function(single_click_callback, double_click_callback, timeout) {
                return this.each(function(){
                    var clicks = 0, 
                        self = this;
                    $(this).click(function(event){
                        clicks++;
                        if (clicks == 1) {
                            setTimeout(function(){
                                if(clicks == 1) {
                                    single_click_callback.call(self, event);
                                } else {
                                    double_click_callback.call(self, event);
                                }
                                clicks = 0;
                            }, timeout || 300);
                        }
                    });
                });
            }
        }

        _loadGlobalEvent() {
            var globalEvent = this._globalEvent;
            globalEvent.forEach(event => {
                let { method, selector, operation } = event;
                if (selector != undefined) {
                    $(document).on(method, selector, operation);
                } else {
                    $(document).on(method, operation);
                }
            });
        }

        _loadKeyEvent() {
            var keyEvent = this._keyEvent;
            keyEvent.forEach(event => {
                let { method, selector, operation } = event;
                $(document).on(method, operation);
            });
        }   

        enableHotkey() {
            this.useHotkey = true;
        }

        disableHotkey() {
            this.useHotkey = false;
        }
    }

    return Event;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/* End of file */


/***/ }),

/***/ "./lib/visualpython/js/com/com_Kernel.js":
/*!***********************************************!*\
  !*** ./lib/visualpython/js/com/com_Kernel.js ***!
  \***********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_Kernel.js
 *    Author          : Black Logic
 *    Note            : Interface between vp and jupyter
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 16
 *    Change Date     :
 */
//============================================================================
// [CLASS] Kernel
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! ./com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! ./com_String */ "./lib/visualpython/js/com/com_String.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_util, com_String) {

    /**
     * Kernel interface class
     */
    class Kernel {
        /** constructor */
        constructor(app=null) {
            this.app = app; // LAB: app needed for kernel
            this.data = [
                { varName: 'df1', varType: 'DataFrame' },
                { varName: 'df2', varType: 'DataFrame' },
                { varName: 'df3', varType: 'DataFrame' },
                { varName: 's1', varType: 'Series' },
                { varName: 's2', varType: 'Series' },
                { varName: 's3', varType: 'Series' },
                { varName: 'l1', varType: 'List' },
                { varName: 'l2', varType: 'List' },
                { varName: 'l3', varType: 'List' }
            ]

            this.config = {
                'vpcfg': {

                },
                'vpudf': {

                },
                'vpimport': {

                }
            }
        }

        getNotebookPath() {
            if (vpConfig.extensionType === 'notebook') {
                return Jupyter.notebook.notebook_path;
            } else if (vpConfig.extensionType === 'colab') {
                return colab.global.notebookModel.metadata.colab.name;
            }
            return '';
        }

        //====================================================================
        // Executing command api
        //====================================================================
        execute(command, isSilent = false) {
            let that = this;
            return new Promise(function(resolve, reject) {
                if (vpConfig.extensionType === 'notebook') {
                    Jupyter.notebook.kernel.execute(
                        command,
                        {
                            iopub: {
                                output: function (msg) {
                                    var result = '';
                                    var type = '';
                                    if (msg.msg_type == 'error') {
                                        reject({result: msg.content, type: 'error', msg: msg});
                                    } else {
                                        if (msg.content) {
                                            try {
                                                if (msg.content['name'] == 'stderr') {
                                                    reject(msg);
                                                } else {
                                                    if (msg.content['text']) {
                                                        result = String(msg.content['text']);
                                                        type = 'text';
                                                    } else if (msg.content.data) {
                                                        if (msg.content.data['text/plain']) {
                                                            result = String(msg.content.data['text/plain']);
                                                            type = 'text/plain';
                                                        } else if (msg.content.data['text/html']) {
                                                            result = String(msg.content.data['text/html']);
                                                            type = 'text/html';
                                                        } else if (msg.content.data['image/png']) {
                                                            result = String(msg.content.data['image/png']);
                                                            type = 'image/png';
                                                        }
                                                    }
                                                    resolve({result: result, type: type, msg: msg});
                                                }
                                            } catch(ex) {
                                                reject(ex);
                                            }
                                        } else {
                                            resolve({result: result, type: type, msg: msg});
                                        }
                                    }
                                }
                            }
                        },
                        { silent: isSilent }
                    );
                } else if (vpConfig.extensionType === 'colab') {
                    // CHROME: TODO: 3: return background execution
                    if (isSilent) {
                        if (!colab.global.notebook.kernel.isConnected()) {
                            reject({status: 'error', ename: 'Kernel Error', evalue: 'Kernel is not connected...'});
                            return;
                        }
                        if (!colab.global.notebook.kernel.isRunning()) {
                            reject({status: 'error', ename: 'Kernel Error', evalue: 'Kernel is not running...'});
                            return;
                        }
                        colab.global.notebook.kernel.execute(command).then(function(msg) {
                            if (msg.status === 'ok') {
                                resolve(true);
                            } else {
                                reject(msg);
                            }
                        }).catch(function(msg) {
                            reject(msg);
                        });
                        return;
                    }
                    // get focused index
                    let lastFocusedCellId = '';
                    let lastFocusedCellIdx = 0;
                    try {
                        // get focused cell id
                        lastFocusedCellId = colab.global.notebook.focusedCell? colab.global.notebook.focusedCell.getId() : null;
                        // get focused cell index
                        lastFocusedCellIdx = colab.global.notebook.cells.findIndex(cell => cell.getId() === lastFocusedCellId);
                    } catch (err) { 
                        vpLog.display(VP_LOG_TYPE.ERROR, err);
                    }
                    // create cell to execute
                    colab.global.notebook.insertCell('code', {after:true, index:lastFocusedCellIdx});

                    // get cell
                    let cell = colab.global.notebook.focusedCell;
                    // hide cell using class
                    // cell.element_.style.display = "none";
                    $(cell.element_).addClass('vp-background-cell');
                    // set cell command
                    cell.setText(command);
                    // add execution complete listener
                    cell.model.listenOnce('execution_completed', function() {
                        let result = '';
                        let type = '';
                        let msg = {
                            content: {
                                name: type
                            }
                        };
                        let cellJson = cell.model.toJson();
                        if (cellJson.outputs.length > 0) {
                            // {output_type: 'stream', name: 'stdout', text: Array(1)}
                            /**
                             * {
                             *  output_type: stream/execute_result/display_data/error
                             *  name: stdout,
                             * // if output_type==stream
                             *  text: [ ... ] 
                             * // if output_type==execute_result/display_data
                             *  data: {
                             *    'image/png': '...'
                             *    'text/html': '...'
                             *    'text/plain': '...'
                             *  }
                             * // if output_type==error
                             *  ename: 'NameError/...'
                             *  evalue: 'ignored/...'
                             * }
                             */
                            cellJson.outputs.forEach(output => {
                                vpLog.display(VP_LOG_TYPE.DEVELOP, 'kernel output', cellJson.outputs);
                                try {
                                    if (output.output_type === 'error') {
                                        // convert traceback as evalue
                                        let simpleEvalue = '';
                                        let convertedEvalue = '';
                                        if (output.traceback.length > 0) {
                                            let traceback = output.traceback.join('\n');
                                            convertedEvalue = traceback.replace(/[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/g, '');
                                            simpleEvalue = output.traceback[output.traceback.length - 1].replace(/[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-ORZcf-nqry=><]/g, '');
                                        }
                                        reject({result: output, type: 'error', msg: { content: { ename: output.ename, evalue: simpleEvalue, detail: convertedEvalue } }});
                                    } else {
                                        if (output.output_type === 'stream') {
                                            result = String(output.text[0]);
                                            type = 'text';
                                            msg = {
                                                content: {
                                                    name: type,
                                                    [type]: result
                                                }
                                            };
                                        } else if (output.output_type === 'execute_result' || output.output_type === 'display_data') {
                                            if (output.data['image/png']) {
                                                result = String(output.data['image/png']);
                                                type = 'image/png';
                                            } else if (output.data['text/html']) {
                                                result = String(output.data['text/html'].join(''));
                                                type = 'text/html';
                                            } else if (output.data['text/plain']) {
                                                result = String(output.data['text/plain'].join(''));
                                                type = 'text/plain';
                                            }
                                            msg = {
                                                content: {
                                                    name: type,
                                                    data: {
                                                        [type]: result
                                                    }
                                                }
                                            };
                                        }
                                        resolve({result: result, type: type, msg: msg});
                                    }
                                } catch(ex) {
                                    reject(ex);
                                }
                            });
                        }
                        // delete cell
                        colab.global.notebook.notebookModel.deleteCells([cell.model]);
                        // set last focused cell
                        // colab.global.notebook.focusCell(lastFocusedCellId);
                    })
                    // run cell
                    cell.runButton.click();
                    // set last focused cell
                    colab.global.notebook.focusCell(lastFocusedCellId);
                } else if (vpConfig.extensionType === 'lab') {
                    // LAB: 
                    // { code, stdin, stop_on_error, silent, ... } 
                    var codeObj = {
                        code: command,
                        silent: isSilent,
                        stop_on_error: true
                    } 
                    var kernelConnection = that.getLabKernel();
                    if (kernelConnection) {
                        var future = kernelConnection.requestExecute(codeObj);
                        future.onIOPub  = (msg) => {
                            const msgType = msg.header.msg_type;
                            switch(msgType) {
                                case 'status':
                                    // if(!isExpectingOutput){
                                    //     if(msg.content.execution_state === 'idle'){
                                    //         resolve();
                                    //     }
                                    // }
                                    return;
                                case 'execute_input':
                                    // var content = msg.content;
                                    // resolve({
                                    //     result: content, 
                                    //     type: type, 
                                    //     msg: {
                                    //         content: {
                                    //             name: type,
                                    //             data: {
                                    //                 [type]: content
                                    //             }
                                    //         }
                                    //     }
                                    // });	
                                    return;
                                case 'stream':
                                    var content = msg.content;
                                    var type = content.name;
                                    switch(type){
                                        case 'stdout':
                                            var message = content.text;    	    		    	    
                                            resolve({
                                                result: message, 
                                                type: type, 
                                                msg: {
                                                    content: {
                                                        name: type,
                                                        data: {
                                                            [type]: message
                                                        }
                                                    }
                                                }
                                            });				
                                            break;
                                        case 'stderr':
                                            var message = content.text;    	    		    	    				    
                                            reject({status: 'stderr', ename: 'stderr', evalue: message});
                                            break;
                                        default:
                                            var message = '[jupyterLabTerminal]: Unknown stream type ' + type;												    
                                            reject({status: 'error', ename: 'Unknown stream type', evalue: message});
                                    } 
                                    break;   	    		    
                                case 'error':    
                                    //stderr does not yield output for all errors	    
                                    // var message = msg.content.ename + '\n' + msg.content.evalue;
                                    reject({status: 'error', ename: msg.content.ename, evalue: msg.content.evalue});
                                    break;						
                                case 'execute_result':
                                    var type = 'text';
                                    if (msg.content) {
                                        try {
                                            if (msg.content['text']) {
                                                result = String(msg.content['text']);
                                                type = 'text';
                                            } else if (msg.content.data) {
                                                if (msg.content.data['image/png']) {
                                                    result = String(msg.content.data['image/png']);
                                                    type = 'image/png';
                                                } else if (msg.content.data['text/plain']) {
                                                    result = String(msg.content.data['text/plain']);
                                                    type = 'text/plain';
                                                } else if (msg.content.data['text/html']) {
                                                    result = String(msg.content.data['text/html']);
                                                    type = 'text/html';
                                                }
                                            }
                                            resolve({result: result, type: type, msg: msg});
                                        } catch(ex) {
                                            reject(ex);
                                        }
                                    } else {
                                        resolve({result: result, type: type, msg: msg});
                                    }		
                                    break;
                                case 'display_data':
                                    var type = 'text';
                                    if (msg.content) {
                                        try {
                                            if (msg.content['text']) {
                                                result = String(msg.content['text']);
                                                type = 'text';
                                            } else if (msg.content.data) {
                                                if (msg.content.data['image/png']) {
                                                    result = String(msg.content.data['image/png']);
                                                    type = 'image/png';
                                                } else if (msg.content.data['text/plain']) {
                                                    result = String(msg.content.data['text/plain']);
                                                    type = 'text/plain';
                                                } else if (msg.content.data['text/html']) {
                                                    result = String(msg.content.data['text/html']);
                                                    type = 'text/html';
                                                }
                                            }
                                            resolve({result: result, type: type, msg: msg});
                                        } catch(ex) {
                                            reject(ex);
                                        }
                                    } else {
                                        resolve({result: result, type: type, msg: msg});
                                    }											
                                    break;
                                case 'update_display_data':
                                    var result = msg.content;
                                    resolve({
                                        result: result, 
                                        type: msgType, 
                                        msg: {
                                            content: {
                                                name: msgType,
                                                data: {
                                                    [msgType]: result
                                                }
                                            }
                                        }
                                    });										
                                    break;
                                default:
                                    var message = '[jupyterLabTerminal]: Unknown message type ' + msgType;					  				    
                                    reject({status: 'error', ename: 'Unknown message type', evalue: message});

                            };
                            return;
                        };
                    }
                    
                }
            });
        }

        /** 
         * LAB: get lab notebook panel
        */
        getLabKernel(){
            var notebookPanel = this.getLabNotebookPanel(); 
            if (notebookPanel) {
                var kernelConnection = notebookPanel.sessionContext.session?.kernel;
                return kernelConnection;
            }
            return null;
        }

        async executeLabCell(pythonCode, cellType='code'){
            var { NotebookActions } = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
            var notebookPanel = this.getLabNotebookPanel();
        
            return new Promise(async (resolve, reject) => {
                if (notebookPanel){
                    var notebook = notebookPanel.content;
                    var notebookModel = notebook.model;
                    var sessionContext = notebookPanel.sessionContext;	
            
                    var options = {	};
                    var cellModel = notebookModel.contentFactory.createCell(cellType, options);				
                    cellModel.value.text = pythonCode;
            
                    const activeCellIndexBackup = notebook.activeCellIndex;
                    // 셀 추가
                    notebookModel.cells.insert(activeCellIndexBackup + 1, cellModel);				
                    notebook.activeCellIndex = newCellIndex;
            
                    var cell = notebook.activeCell;
                    
                    try{
                        await NotebookActions.run(notebook, sessionContext)
                        .catch(error=>{
                            reject(error);
                        });
                    } catch(error){
                        reject(error);
                    } 
                    
                    var htmlArray = [];
            
                    for(var output of cell.outputArea.node.children){								
                        htmlArray.push(output.innerHTML);
                    }					
                    
                    // 셀 삭제
                    //    await NotebookActions.deleteCells(notebook);
                    //    notebook.activeCellIndex = activeCellIndexBackup;
            
                    resolve(htmlArray);
                }				
                
            }); 	
        }

        createLabCell(code, type='code') {
            var { CellModel, CodeCellModel, MarkdownCellModel } = __webpack_require__(/*! @jupyterlab/cells */ "webpack/sharing/consume/default/@jupyterlab/cells");
            return new CellModel({
                cell_type: 'code',
                source: "print('hi')",
                metadata: { trusted: false }
            })
        }

        /** 
         * LAB: get lab notebook panel
        */
        getLabNotebookPanel(){
            var mainWidgets = this.app.shell.widgets('main');
            var widget = mainWidgets.next();
            while(widget){
                if(widget.sessionContext){
                    var type = widget.sessionContext.type;
                    if(type == 'notebook' || type == 'console'){  //other wigets might be of type DocumentWidget
                        if (widget.isVisible){
                            return widget;
                        }
                    }
                }
                widget = mainWidgets.next();
            }
            return null;
        }

        get labWidgets() {
            let mainWidgets = this.app.shell.widgets('main');
            let widget = mainWidgets.next();
            let widgetList = [];
            while (widget) {
                if (widget.sessionContext) {
                    widgetList.push(widget);
                }
                widget = mainWidgets.next();
            }
            return widgetList;
        }

        getLabPanelId() {
            let currentPanel = vpKernel.getLabNotebookPanel();
            if (currentPanel) { 
                return currentPanel.id;
            }
            return undefined;
        }

        /**
         * Check if module/function is loaded already
         * @param {*} moduleList 
         */
        checkModule(moduleList) {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute(com_util.formatString('_vp_print(_vp_check_module_loaded({0}))', JSON.stringify(moduleList))).then(function(resultObj) {
                    // resolve
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        getDataList(dataTypeList=[], excludeList=[]) {
            // use function command to get variable list of selected data types
            var cmdSB = '_vp_print(_vp_get_variables_list(None))';
            if (!dataTypeList || dataTypeList.length <= 0) {
                dataTypeList = [];
            }
            cmdSB = com_util.formatString('_vp_print(_vp_get_variables_list({0}, {1}))', JSON.stringify(dataTypeList), JSON.stringify(excludeList));
            
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute(cmdSB.toString()).then(function(resultObj) {
                    // resolve
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            })
        }

        getColumnList(dataframe) {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute(com_util.formatString('_vp_print(_vp_get_columns_list({0}))', dataframe))
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }
    
        getCommonColumnList(dataframeList) {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute(com_util.formatString('_vp_print(_vp_get_multi_columns_list([{0}]))', dataframeList.join(',')))
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        getColumnCategory(dataframe, columnName) {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute(com_util.formatString('_vp_print(_vp_get_column_category({0}, {1}))', dataframe, columnName))
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }
    
        /**
         * Get rows list
         * @param {*} dataframe 
         * @returns 
         */
        getRowList(dataframe) {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute(com_util.formatString('_vp_print(_vp_get_rows_list({0}))', dataframe))
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }
    
        getProfilingList() {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute('_vp_print(_vp_get_profiling_list())')
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        //====================================================================
        // FileNavigation 
        //====================================================================
        getCurrentDirectory() {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute('%pwd')
                .then(function(resultObj) {
                    resolve(resultObj.result);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        getFileList(path, useFunction=false) {
            var that = this;
            if (path === '') {
                path = '.';
            }
            if (!useFunction) {
                path = "'" + path + "'";
            }
            var cmd = com_util.formatString('_vp_print(_vp_search_path({0}))', path);
            return new Promise(function(resolve, reject) {
                that.execute(cmd)
                .then(function(resultObj) {
                    resolve(resultObj.result);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        /**
         * Get if colab mounted (If mounted, create .visualpython directory)
         * - '/content/drive/MyDrive/.visualpython'
         * @returns Promise(resolve(true/false), reject(err))
         */
        getColabMounted() {
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute('_vp_get_colab_mounted()')
                .then(function(resultObj) {
                    resolve(resultObj.result);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        /**
         * Get colab's vp config file content
         * @param {String} configType vpudf, vpcfg 
         * @returns 
         */
        getColabConfig(configType='vpudf') {
            var that = this;
            var configFile = '';
            switch (configType) {
                case 'vpudf':
                    configFile = 'snippets';
                    break;
                case 'vpcfg':
                    configFile = 'configure';
                    break;
                case 'vpimport':
                    configFile = 'import';
                    break;
            }
            var cmd = com_util.formatString("print(_vp_get_colab_vpcfg('{0}'))", configFile);
            return new Promise(function(resolve, reject) {
                that.execute(cmd)
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        /**
         * Set colab's vp config file content
         * @param {String} content file content to write
         * @param {String} configType vpudf, vpcfg 
         * @returns 
         */
        setColabConfig(content, configType='vpudf') {
            var that = this;
            var configFile = '';
            switch (configType) {
                case 'vpudf':
                    configFile = 'snippets';
                    break;
                case 'vpcfg':
                    configFile = 'configure';
                    break;
                case 'vpimport':
                    configFile = 'import';
                    break;
            }
            // write file
            var sbfileSaveCmd = new com_String();
            sbfileSaveCmd.appendFormatLine('%%writefile "/content/drive/MyDrive/.visualpython/{0}"', configFile);
            sbfileSaveCmd.appendLine(content);
            return new Promise(function(resolve, reject) {
                that.execute(sbfileSaveCmd.toString())
                .then(function(resultObj) {
                    resolve(resultObj.result);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        /**
         * Get jupyterlab's vp config file content
         * @param {String} configType vpudf, vpcfg 
         * @returns 
         */
        getLabConfig(configType='vpudf') {
            var that = this;
            var configFile = '';
            switch (configType) {
                case 'vpudf':
                    configFile = 'snippets';
                    break;
                case 'vpcfg':
                    configFile = 'configure';
                    break;
                case 'vpimport':
                    configFile = 'import';
                    break;
            }
            var cmd = com_util.formatString("print(_vp_get_lab_vpcfg('{0}'))", configFile);
            return new Promise(function(resolve, reject) {
                that.execute(cmd)
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        /**
         * Set jupyterlab's vp config file content
         * @param {String} content file content to write
         * @param {String} configType vpudf, vpcfg 
         * @returns 
         */
        setLabConfig(content, configType='vpudf') {
            var that = this;
            var configFile = '';
            switch (configType) {
                case 'vpudf':
                    configFile = 'snippets';
                    break;
                case 'vpcfg':
                    configFile = 'configure';
                    break;
                case 'vpimport':
                    configFile = 'import';
                    break;
            }
            // write file
            var sbfileSaveCmd = new com_String();
            sbfileSaveCmd.appendFormat("_vp_set_lab_vpcfg('{0}', '{1}')", configFile, content);
            return new Promise(function(resolve, reject) {
                that.execute(sbfileSaveCmd.toString())
                .then(function(resultObj) {
                    resolve(resultObj.result);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }
        //====================================================================
        // Image data 
        //====================================================================
        getImageFile(path) {
            var that = this;
            let code = com_util.formatString("_vp_get_image_by_path('{0}')", path);
            return new Promise(function(resolve, reject) {
                that.execute(code)
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        //====================================================================
        // Read File 
        //====================================================================
        readFile(filePath) {
            let that = this;
            let code = com_util.formatString("print(_vp_read_file('{0}'))", filePath);
            return new Promise(function(resolve, reject) {
                that.execute(code)
                .then(function(resultObj) {
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            });
        }

        //====================================================================
        // Write File 
        //====================================================================
        saveFile(fileName, filePath, saveData) {
            let that = this;
            fetch(filePath).then(function(data) {
                // overwrite confirmation
                if (data.status == 200) {
                    if (!confirm(com_util.formatString("{0} already exists.\nDo you want to replace it?", fileName))) {
                        return false;
                    }
                }
                
                // write file
                var sbfileSaveCmd = new com_String();
                sbfileSaveCmd.appendFormatLine('%%writefile "{0}"', filePath);
                sbfileSaveCmd.appendLine(saveData);
                
                that.execute(sbfileSaveCmd.toString()).then(function(resultObj) {
                    com_util.renderSuccessMessage('Successfully saved file. (' + fileName + ')');
                }).catch(function(err) {
                    com_util.renderAlertModal("Couldn't save file. "+err.message);
                    vpLog.display(VP_LOG_TYPE.ERROR, err);
                });
            });
        }

        //====================================================================
        // Machine Learning
        //====================================================================
        getModelList(modelCategory='') {
            // use function command to get variable list of selected data types
            var cmdSB = `_vp_print(_vp_get_variables_list(${JSON.stringify(vpConfig.getMLDataTypes())}))`;
            if (modelCategory != '') {
                cmdSB = `_vp_print(_vp_get_variables_list(${JSON.stringify(vpConfig.getMLDataDict(modelCategory))}))`;
            }
            var that = this;
            return new Promise(function(resolve, reject) {
                that.execute(cmdSB).then(function(resultObj) {
                    // resolve
                    resolve(resultObj);
                }).catch(function(err) {
                    // reject
                    reject(err);
                })
            })
        }

        //====================================================================
        // Configuration api
        //====================================================================
        loadConfig() {

        }

        getConfig() {

        }

        setConfig() {

        }

    }

    return Kernel;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/com_Log.js":
/*!********************************************!*\
  !*** ./lib/visualpython/js/com/com_Log.js ***!
  \********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_Log.js
 *    Author          : Black Logic
 *    Note            : Log control
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 13
 *    Change Date     :
 */

//============================================================================
// Load extension
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! ./com_Config */ "./lib/visualpython/js/com/com_Config.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_Config) {
	'use strict';
    //========================================================================
    // Define Inner Variable
    //========================================================================
    /**
     * Type of log
     * DEVELOP 0 : log for developing/testing. if mode
     */
    const _LOG_TYPE = {
        ERROR   : -1,
        DEVELOP : 0,
        LOG     : 1,
        WARN    : 4
    }
    /**
     * Log label
     */
    const _LOG_LABEL = {
        [_LOG_TYPE.DEVELOP]  : 'VP_Test',
        [_LOG_TYPE.LOG]      : 'VP_Log',

        [_LOG_TYPE.ERROR]    : 'VP_ERROR',
        [_LOG_TYPE.WARN]     : 'VP_WARN'
    }

    //========================================================================
    // Declare Class
    //========================================================================
    /**
     * Log util class
     */
    class Log {
        //========================================================================
        // Constructor
        //========================================================================
        constructor() {
            this.currentMode = com_Config.serverMode;
        }

        //========================================================================
        // Internal call function
        //========================================================================
        /**
         * Get current mode
         */
        get _mode() {
            return this.currentMode;
        }
        
        //========================================================================
        // External call function
        //========================================================================
        /**
         * Display logs
         * @param {Log.LOG_TYPE}    logType     Log type : DEVELOP 0/LOG 1/ERROR -1
         * @param {String}          displayArgs  Log string text
         */
        display(logType, ...displayArgs) {
            // on RELEASE mode, do not show develop/test logs
            if (this._mode == com_Config.MODE_TYPE.RELEASE) {
                if (logType == _LOG_TYPE.DEVELOP) {
                    return;
                }
            }
            if (displayArgs.length == 1) {
                console.log('[' + _LOG_LABEL[logType] + ']', displayArgs[0]);
            } else {
                console.log('[' + _LOG_LABEL[logType] + ']', displayArgs);
            }
        }
    }

    //========================================================================
    // Define Static Variable
    //========================================================================
    /**
     * Type of log
     * DEVELOP 0 : log for developing/testing. if mode
     */
    Log.LOG_TYPE = _LOG_TYPE;
    /**
     * Log label
     */
    Log.LOG_LABEL = _LOG_LABEL;
    

    return Log;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/com_Popup.js":
/*!**********************************************!*\
  !*** ./lib/visualpython/js/com/com_Popup.js ***!
  \**********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_Popup.js
 *    Author          : Black Logic
 *    Note            : [CLASS] Popup page
 *    License         : GPLv3 (GNU General Public License v3.0)
 *    Date            : 2021. 08. 14
 *    Change Date     :
 */

//============================================================================
// [CLASS] Popup page
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! codemirror/lib/codemirror */ "./lib/visualpython/lib/codemirror/lib/codemirror.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_Const, com_util, codemirror) {
    'use strict';

    //========================================================================
    // Define variable
    //========================================================================
    const VP_PP           = 'vp-pp';
    const VP_PP_CONTAINER = 'vp-pp-container';
    const VP_PP_TITLE     = 'vp-pp-title';
    const VP_PP_CLOSE     = 'vp-pp-close';
    const VP_PP_BODY      = 'vp-pp-body';

    const VP_PP_PREVIEW_BOX    = 'vp-pp-preview-box';
    const VP_PP_BUTTON_BOX     = 'vp-pp-btn-box';
    const VP_PP_BUTTON_PREVIEW = 'vp-pp-btn-preview';
    const VP_PP_BUTTON_CANCEL  = 'vp-pp-btn-cancel';
    const VP_PP_BUTTON_RUNADD  = 'vp-pp-btn-runadd';
    const VP_PP_BUTTON_RUN     = 'vp-pp-btn-run';
    const VP_PP_BUTTON_DETAIL  = 'vp-pp-btn-detail';
    const VP_PP_DETAIL_BOX     = 'vp-pp-detail-box';
    const VP_PP_DETAIL_ITEM    = 'vp-pp-detail-item';

    //========================================================================
    // [CLASS] com_Popup
    //========================================================================
    class com_Popup {

        /**
         * constructor
         * @param {object} pageThis
         * @param {string} targetId
         */
        constructor(pageThis, targetId) {
            this.pageThis = pageThis;
            this.targetId = targetId;
            this.uuid = 'u' + com_util.getUUID();

            this.config = {
                title: '',
                width: '95%',
                height: '95%',
                pageDom: $('<div>Empty</div>')
            };

            this.cmReadonlyConfig = {
                mode: {
                    name: 'python',
                    version: 3,
                    singleLineStringErrors: false
                },
                height: '100%',
                width: '100%',
                indentUnit: 4,
                matchBrackets: true,
                readOnly: true,
                autoRefresh: true,
                theme: 'ipython',
                extraKeys: { 'Enter': 'newlineAndIndentContinueMarkdownList' },
                scrollbarStyle: 'null'
            };
            this.previewOpened = false;
        }

        /**
         * Wrap selector
         */
        wrapSelector(selector = '') {
            return com_util.formatString('.{0} {1}', this.uuid, selector);
        }

        /**
         * Initialize
         */
        init() {
            com_util.loadCss(com_Const.STYLE_PATH + 'common/popupPage.css');
            this.renderPopup();
            this.bindEvent();
        }

        /**
         * Render popup page
         */
        renderPopup() {
            var { title, width, height, pageDom } = this.config;

            var page = new MakeString();
            page.appendFormatLine('<div class="{0} {1}">', VP_PP, this.uuid);
            page.appendFormatLine('<div class="{0}" style="width: {1}; height: {2};">', VP_PP_CONTAINER, width, height);

            // title
            page.appendFormat('<div class="{0}">{1}</div>',
                VP_PP_TITLE,
                title);

            // close button
            page.appendFormatLine('<div class="{0}"><i class="{1}"></i></div>',
                VP_PP_CLOSE, 'fa fa-close');

            // body start
            page.appendFormatLine('<div class="{0} {1}">', VP_PP_BODY, 'vp-apiblock-scrollbar');
            page.appendLine('</div>'); // body end


            // Snippets menu don't use buttons
            if (title != 'Snippets') {

                // preview box
                page.appendFormatLine('<div class="{0} {1}">', VP_PP_PREVIEW_BOX, 'vp-apiblock-scrollbar');
                page.appendFormatLine('<textarea id="{0}" name="code"></textarea>', 'vp_codePreview');
                page.appendLine('</div>');

                // button box
                page.appendFormatLine('<div class="{0}">', VP_PP_BUTTON_BOX);
                page.appendFormatLine('<button type="button" class="{0} {1} {2}">{3}</button>',
                    'vp-button', 'vp-pp-btn', VP_PP_BUTTON_PREVIEW, 'Code view');
                page.appendFormatLine('<button type="button" class="{0} {1} {2}">{3}</button>',
                    'vp-button cancel', 'vp-pp-btn', VP_PP_BUTTON_CANCEL, 'Cancel');
                page.appendFormatLine('<div class="{0}">', VP_PP_BUTTON_RUNADD);
                page.appendFormatLine('<button type="button" class="{0} {1}" title="{2}">{3}</button>',
                    'vp-button activated', VP_PP_BUTTON_RUN, 'Apply to Board & Run Cell', 'Run');
                page.appendFormatLine('<button type="button" class="{0} {1}"><i class="{2}"></i></button>',
                    'vp-button activated', VP_PP_BUTTON_DETAIL, 'fa fa-sort-up');
                page.appendFormatLine('<div class="{0} {1}">', VP_PP_DETAIL_BOX, 'vp-cursor');
                page.appendFormatLine('<div class="{0}" data-type="{1}" title="{2}">{3}</div>', VP_PP_DETAIL_ITEM, 'apply', 'Apply to Board', 'Apply');
                page.appendFormatLine('<div class="{0}" data-type="{1}" title="{2}">{3}</div>', VP_PP_DETAIL_ITEM, 'add', 'Apply to Board & Add Cell', 'Add');
                page.appendLine('</div>'); // VP_PP_DETAIL_BOX
                page.appendLine('</div>'); // VP_PP_BUTTON_RUNADD
                page.appendLine('</div>'); // VP_PP_BUTTON_BOX
            }

            page.appendLine('</div>'); // container end
            page.appendLine('</div>'); // VP_PP end

            $('#vp-wrapper').append(page.toString());

            $(pageDom).appendTo($(this.wrapSelector('.' + VP_PP_BODY)));
            $(this.wrapSelector()).hide();

            return page.toString();
        }

        /**
         * Open
         */
        open(config) {
            this.config = {
                ...this.config,
                ...config
            };

            this.init();
            $(this.wrapSelector()).show();

            if (!this.cmpreview) {
                // codemirror setting
                this.cmpreview = codemirror.fromTextArea($('#vp_codePreview')[0], this.cmReadonlyConfig);
            } else {
                this.cmpreview.refresh();
            }
        }

        /**
         * Close
         */
        close() {
            this.unbindEvent();
            $(this.wrapSelector()).remove();
        }

        /**
         * Apply
         */
        apply(addCell = false, runCell = false) {
            if (this.pageThis) {
                var code = this.pageThis.generateCode(false, false);
                $(com_util.wrapSelector('#' + this.targetId)).val(code);
                $(com_util.wrapSelector('#' + this.targetId)).trigger({
                    type: 'popup_run',
                    title: this.config.title,
                    code: code,
                    addCell: addCell,
                    runCell: runCell
                });
            }
        }

        /**
         * Open preview
         */
        openPreview() {
            if (this.pageThis) {
                var code = this.pageThis.generateCode(false, false);
                this.cmpreview.setValue(code);
                this.cmpreview.save();
                this.cmpreview.focus();

                var that = this;
                setTimeout(function () {
                    that.cmpreview.refresh();
                }, 1);

                this.previewOpened = true;
                $(this.wrapSelector('.' + VP_PP_PREVIEW_BOX)).show();
            }
        }

        /**
         * Close preview
         */
        closePreview() {
            this.previewOpened = false;
            $(this.wrapSelector('.' + VP_PP_PREVIEW_BOX)).hide();
        }

        /**
         * Bind event
         */
        bindEvent() {
            var that = this;

            // close popup
            $(document).on('click', this.wrapSelector('.' + VP_PP_CLOSE), function (event) {
                that.close();
            });

            // click preview
            $(document).on('click', this.wrapSelector('.' + VP_PP_BUTTON_PREVIEW), function (evt) {
                evt.stopPropagation();
                if (that.previewOpened) {
                    that.closePreview();
                } else {
                    that.openPreview();
                }
            });

            // click cancel
            $(document).on('click', this.wrapSelector('.' + VP_PP_BUTTON_CANCEL), function () {
                that.close();
            });

            // click run
            $(document).on('click', this.wrapSelector('.' + VP_PP_BUTTON_RUN), function () {
                that.apply(true, true);
                that.close();
            });

            // click detail button
            $(document).on('click', this.wrapSelector('.' + VP_PP_BUTTON_DETAIL), function (evt) {
                evt.stopPropagation();
                $(that.wrapSelector('.' + VP_PP_DETAIL_BOX)).show();
            });

            // click add / apply
            $(document).on('click', this.wrapSelector('.' + VP_PP_DETAIL_ITEM), function () {
                var type = $(this).data('type');
                if (type == 'add') {
                    that.apply(true);
                    that.close();
                } else if (type == 'apply') {
                    that.apply();
                    that.close();
                }
            });

            // click other
            $(document).on('click.' + this.uuid, function (evt) {
                if (!$(evt.target).hasClass('.' + VP_PP_BUTTON_DETAIL)) {
                    $(that.wrapSelector('.' + VP_PP_DETAIL_BOX)).hide();
                }
                if (!$(evt.target).hasClass('.' + VP_PP_BUTTON_PREVIEW)
                    && $(that.wrapSelector('.' + VP_PP_PREVIEW_BOX)).has(evt.target).length === 0) {
                    that.closePreview();
                }
            });

            this.keyboardManager = {
                keyCode: {
                    ctrlKey: 17,
                    cmdKey: 91,
                    shiftKey: 16,
                    altKey: 18,
                    enter: 13,
                    escKey: 27
                },
                keyCheck: {
                    ctrlKey: false,
                    shiftKey: false
                }
            };
            $(document).on('keydown.' + this.uuid, function (e) {
                var keyCode = that.keyboardManager.keyCode;
                if (e.keyCode == keyCode.ctrlKey || e.keyCode == keyCode.cmdKey) {
                    that.keyboardManager.keyCheck.ctrlKey = true;
                }
                if (e.keyCode == keyCode.shiftKey) {
                    that.keyboardManager.keyCheck.shiftKey = true;
                }
            }).on('keyup.' + this.uuid, function (e) {
                var keyCode = that.keyboardManager.keyCode;
                if (e.keyCode == keyCode.ctrlKey || e.keyCode == keyCode.cmdKey) {
                    that.keyboardManager.keyCheck.ctrlKey = false;
                }
                if (e.keyCode == keyCode.shiftKey) {
                    that.keyboardManager.keyCheck.shiftKey = false;
                }
                if (e.keyCode == keyCode.escKey) {
                    // close on esc
                    that.close();
                }
            });
        }

        /**
         * Unbind event
         */
        unbindEvent() {
            $(document).unbind(com_util.formatString(".{0} .{1}", this.uuid, VP_PP_BODY));
            $(document).off('click', this.wrapSelector('.' + VP_PP_CLOSE));
            $(document).off('click', this.wrapSelector('.' + VP_PP_BUTTON_PREVIEW));
            $(document).off('click', this.wrapSelector('.' + VP_PP_BUTTON_CANCEL));
            $(document).off('click', this.wrapSelector('.' + VP_PP_BUTTON_RUN));
            $(document).off('click', this.wrapSelector('.' + VP_PP_BUTTON_DETAIL));
            $(document).off('click', this.wrapSelector('.' + VP_PP_DETAIL_ITEM));
            $(document).off('click.' + this.uuid);

            $(document).off('keydown.' + this.uuid);
            $(document).off('keyup.' + this.uuid);
        }
    }

    return com_Popup;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)); /* function, define */

/* End of file */


/***/ }),

/***/ "./lib/visualpython/js/com/com_String.js":
/*!***********************************************!*\
  !*** ./lib/visualpython/js/com/com_String.js ***!
  \***********************************************/
/***/ ((module, exports) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_String.js
 *    Author          : Black Logic
 *    Note            : [CLASS] Make string
 *    License         : GPLv3 (GNU General Public License v3.0)
 *    Date            : 2021. 08. 14
 *    Change Date     :
 */

//============================================================================
// [CLASS] Make string
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    'use strict';

    //========================================================================
    // [CLASS] com_String
    //========================================================================
    class com_String {

        // constructor
        constructor() {
            this.buffer = new Array();
        }

        // Append string
        append(str) {
            this.buffer[this.buffer.length] = str;
        }

        // Append string & newline
        appendLine(str) {
            this.append((str == null ? '' : str) + '\n');
        }

        // Append format string: appendFormat('str_base {0} {1}','str0','str1')
        appendFormat() {
            var cnt = arguments.length;
            if (cnt < 2)
                return '';

            var str = arguments[0];
            for (var idx = 1; idx < cnt; idx++)
                str = str.replace('{' + (idx - 1) + '}', arguments[idx]);
            this.buffer[this.buffer.length] = str;
        }

        // Append format string & newline: appendFormatLine('str_base {0} {1}','str0','str1')
        appendFormatLine() {
            var cnt = arguments.length;
            if (cnt < 2)
                return '';

            var str = arguments[0];
            for (var idx = 1; idx < cnt; idx++)
                str = str.replace('{' + (idx - 1) + '}', arguments[idx]);
            this.buffer[this.buffer.length] = str + '\n';
        }

        // Replace string
        replace(from, to) {
            for (var i = this.buffer.length - 1; i >= 0; i--)
                this.buffer[i] = this.buffer[i].replace(new RegExp(from, 'g'), to);
        }

        // Get string
        toString() {
            return this.buffer.join('');
        }

        // Clear string
        clear() {
            this.buffer = new Array();
        }

        // get Length
        get length() {
            return this.buffer.length;
        }
    }

    return com_String;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)); /* function, define */

/* End of file */


/***/ }),

/***/ "./lib/visualpython/js/com/com_generator.js":
/*!**************************************************!*\
  !*** ./lib/visualpython/js/com/com_generator.js ***!
  \**************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_generator.js
 *    Author          : Black Logic
 *    Note            : Generator for library options
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 12. 17
 *    Change Date     :
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/com_makeDom */ "./lib/visualpython/js/com/com_makeDom.js"),
    __webpack_require__(/*! vp_base/js/com/component/SuggestInput */ "./lib/visualpython/js/com/component/SuggestInput.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function (com_util, com_makeDom, SuggestInput) {
    /**
     * show result after code executed
     */
    var _VP_SHOW_RESULT = true;

    const _VP_BOOL_OPTIONS = [
        { label: 'Select option...', value: ''},
        { label: 'True', value: 'True' },
        { label: 'False', value: 'False' }
    ]

     /**
     * Generate page interface based on package configuration
     * @param {*} package 
     */
    var vp_showInterfaceOnPage = function(selector, package) {

        let autoCols = {};

        // generate input variable tag
        var tblInput = $(selector+' #vp_inputOutputBox table tbody');
        package.input && package.input.forEach(function(o, i) {
            var obj = JSON.parse(JSON.stringify(o));
            tblInput.append(vp_createTag(selector, obj, true, (obj.required == false? false: true)));
            if (obj.component === 'col_select') {
                if (autoCols[obj.target] != undefined) {
                    autoCols[obj.target].push(obj.name);
                } else {
                    autoCols[obj.target] = [ obj.name ];
                }
            }
        });

        // generate option variable tag
        var tblOption = $(selector+' #vp_optionBox table tbody');
        package.variable && package.variable.forEach(function(o, i) {
            // cell metadata test
            var obj = JSON.parse(JSON.stringify(o)); // deep copy
            tblOption.append(vp_createTag(selector, obj, true, (obj.required == true)));
            if (obj.component === 'col_select') {
                if (autoCols[obj.target] != undefined) {
                    autoCols[obj.target].push(obj.name);
                } else {
                    autoCols[obj.target] = [ obj.name ];
                }
            }
        });

        // generate output variable tag
        var tblOutput = $(selector+' #vp_inputOutputBox table tbody');
        package.output && package.output.forEach(function(o, i) {
            var obj = JSON.parse(JSON.stringify(o)); // deep copy
            tblOutput.append(vp_createTag(selector, obj, true, (obj.required == true)));
            if (obj.component === 'col_select') {
                if (autoCols[obj.target] != undefined) {
                    autoCols[obj.target].push(obj.name);
                } else {
                    autoCols[obj.target] = [ obj.name ];
                }
            }
        });

        // bind column list FIXME: change event not triggered on changing df input
        Object.keys(autoCols).forEach(target => {
            let targetSelector = selector + ' #' + target;
            vp_bindColumnSource(selector, targetSelector, autoCols[target]);
            // on change event
            $(targetSelector).on('change', function() {
                // console.log('change event ', selector, targetSelector, autoCols[target]);
                vp_bindColumnSource(selector, this, autoCols[target]);
            });
        });
    }

    /**
     * Generate tag using type
     * @param {object} divTag
     * @param {*} obj 
     * @param {boolean} getValue 
     * @returns {HTMLTableRowElement} tblRow (tr tag)
     */
    var vp_createTag = function(divTag, obj, getValue=false, required=false) {
        // TR tag & TD label tag
        var tblRow = document.createElement('tr');
        var tblLabel = document.createElement('td');
        var tblInput = document.createElement('td');

        var lbl = document.createElement('label');
        var requiredFontStyle = required? 'vp-orange-text' : '';
        $(lbl).attr({
            'for': obj.name,
            'class': requiredFontStyle,
            'title': '(' + obj.name + ')'
        });
        lbl.innerText = obj.label;
        tblLabel.appendChild(lbl);

        // create as component type
        switch (obj.component) {
            case 'bool_checkbox':
                // True False select box
                var optSlct = $(`<select id="${obj.name}" class="vp-select vp-state"></select>`);
                _VP_BOOL_OPTIONS.forEach((opt, idx) => {
                    var option = $(`<option>${opt.label}${obj.default==opt.value?' (default)':''}</option>`).attr({
                        // 'id':opt,
                        'index':obj.index,
                        'name':obj.name,
                        // 'value':(obj.default==opt.value?'':opt.value)
                        'value':opt.value

                    });
                    // cell metadata test
                    if (getValue && obj.value != undefined) {
                        // set as saved value
                        if (obj.value == opt) {
                            $(option).attr({
                                'selected':'selected'
                            });
                        }
                    } else if (obj.default == opt.value) {
                        // set default value
                        // $(option).attr({
                        //     'selected':'selected'
                        // });
                    }
                    optSlct.append(option);
                });
                $(tblInput).append(optSlct);
                break;
            case 'option_select':
                var optSlct = document.createElement('select');
                $(optSlct).attr({
                    'class':'vp-select option-select vp-state',
                    'id':obj.name
                });
                // if required, no default option
                if (required != true) {
                    $(optSlct).append($('<option value="">Select option...</option>'));
                }
                obj.options.forEach((opt, idx, arr) => {
                    var label = (obj.options_label != undefined? obj.options_label[idx]:opt);
                    var option = document.createElement('option');
                    $(option).attr({
                        // 'id':opt,
                        'index':obj.index,
                        'name':obj.name,
                        'value':opt
                    });
                    // cell metadata test
                    if (getValue && obj.value != undefined) {
                        // set as saved value
                        if (obj.value == opt) {
                            $(option).attr({
                                'selected':'selected'
                            });
                        }
                    }
                    option.append(document.createTextNode(label));
                    optSlct.appendChild(option);
                });
                tblInput.appendChild(optSlct);
                break;
            case 'option_suggest':
                    // suggest input tag
                    // 1. Target Variable
                    var suggestInput = new SuggestInput();
                    suggestInput.setComponentID(obj.name);
                    suggestInput.addClass('vp-input vp-state');
                    suggestInput.setSuggestList(function() { return obj.options; });
                    suggestInput.setNormalFilter(obj.useFilter == undefined?false:obj.useFilter);
                    suggestInput.setValue(obj.value);
                    if (obj.placeholder != undefined) {
                        suggestInput.setPlaceholder(obj.placeholder);
                    } else {
                        suggestInput.setPlaceholder('Type or Select value');
                    }
                    if (required === true) {
                        suggestInput.addAttribute('required', true);
                    }
                    suggestInput.setSelectEvent(function(selectedValue) {
                        // trigger change
                        $(pageThis.wrapSelector('#' + obj.name)).val(selectedValue);
                        $(pageThis.wrapSelector('#' + obj.name)).trigger('change');
                    });
                    tblInput.appendChild($(suggestInput.toTagString())[0]);
                    break;
            case 'var_select':
                // suggest input tag
                var tag = document.createElement('input');
                $(tag).attr({
                    'type': 'text',
                    'id': obj.name,
                    'class': 'vp-input vp-state',
                    'required': required === true
                });
                vp_generateVarSuggestInput(divTag, obj, required);
                tblInput.appendChild(tag);
                break;
            case 'var_multi':
                // select tag with multiple selection
                var tag = document.createElement('select');
                $(tag).attr({
                    'id': obj.name,
                    'class': 'vp-select var-multi vp-state',
                    // multiple selection true
                    'multiple': true
                });
                vp_generateVarSelect(tag, obj.var_type, obj.value);
                tblInput.appendChild(tag);
                break;
            case 'col_select':
                var tag = document.createElement('input');
                $(tag).attr({
                    'type': 'text',
                    'id': obj.name,
                    'class': 'vp-input vp-state'
                });
                tblInput.appendChild(tag);
                break;
            case 'textarea':
                var textarea = $(`<textarea id="${obj.name}" class="vp-textarea vp-state">${(obj.default==undefined?'':obj.default)}</textarea>`);
                // cell metadata test
                if (getValue && obj.value != undefined) {
                    // set as saved value
                    textarea.val(obj.value);
                }
                $(tblInput).append(textarea);
                break;
            case 'input_number':
                var input = com_makeDom.renderInput({
                    'type': 'number',
                    'class': 'vp-input vp-state',
                    'id': obj.name,
                    'placeholder': (obj.placeholder==undefined?'':obj.placeholder),
                    'value': (obj.default==undefined?'':obj.default),
                    'title': (obj.help==undefined?'':obj.help),
                    'required': required === true
                });
                // cell metadata test
                if (getValue && obj.value != undefined) {
                    // set as saved value
                    input.attr({
                        'value': obj.value
                    });
                }
                $(tblInput).append(input);
                break;
            case 'table':
                // break;
            case 'file':
                // break;
                // default : input_single
            default:
                // FIXME: use makedom
                var input = com_makeDom.renderInput({
                    'type':'text',
                    'class':'vp-input input-single vp-state',
                    'id':obj.name,
                    'placeholder':(obj.placeholder==undefined?'':obj.placeholder),
                    'value':(obj.default==undefined?'':obj.default),
                    'title':(obj.help==undefined?'':obj.help),
                    'required': required === true
                });
                // cell metadata test
                if (getValue && obj.value != undefined) {
                    // set as saved value
                    input.attr({
                        'value': obj.value
                    });
                }
                $(tblInput).append(input);
        }
        tblRow.appendChild(tblLabel);
        tblRow.appendChild(tblInput);
        
        return tblRow;
    }

    /**
     * Generate suggest input
     * @param {object} obj
     */
    var vp_generateVarSuggestInput = function(divTag, obj, required=false) {
        var types = obj.var_type;
        var defaultValue = obj.value;

        // Include various index types for Index type
        var INDEX_TYPES = ['RangeIndex', 'CategoricalIndex', 'MultiIndex', 'IntervalIndex', 'DatetimeIndex', 'TimedeltaIndex', 'PeriodIndex', 'Int64Index', 'UInt64Index', 'Float64Index'];
        // Include various groupby types for Groupby type
        var GROUPBY_TYPES = ['DataFrameGroupBy', 'SeriesGroupBy']
        if (types.indexOf('Index') >= 0) {
            types = types.concat(INDEX_TYPES);
        }
        if (types.indexOf('GroupBy') >= 0) {
            types = types.concat(GROUPBY_TYPES);
        }

        vpKernel.getDataList(types).then((resultObj) => {
            let { result, type, msg } = resultObj;
            var varList = JSON.parse(result);
            varList = varList.map(function(v) {
                return { label: v.varName, value: v.varName, dtype: v.varType };
            });
            // 1. Target Variable
            var suggestInput = new SuggestInput();
            suggestInput.setComponentID(obj.name);
            suggestInput.addClass('vp-input vp-state');
            suggestInput.setSuggestList(function() { return varList; });
            suggestInput.setNormalFilter(false);
            suggestInput.setValue($(divTag + ' #' + obj.name).val());
            if (obj.placeholder != undefined) {
                suggestInput.setPlaceholder(obj.placeholder);
            }
            if (required === true) {
                suggestInput.addAttribute('required', true);
            }
            suggestInput.setSelectEvent(function(selectedValue) {
                // trigger change
                $(divTag + ' #' + obj.name).val(selectedValue);
                $(divTag + ' #' + obj.name).trigger('change');
            });
            $(divTag + ' #' + obj.name).replaceWith(function() {
                return suggestInput.toTagString();
            });
        }).catch(err => {
            vpLog.display(VP_LOG_TYPE.ERROR, 'Error on generating var suggest input', err);
        });
    }

    /**
     * Generate variable select tag
     * @param {object} tag 
     * @param {Array<string>} types 
     * @param {string} defaultValue 
     */
    var vp_generateVarSelect = function(tag, types, defaultValue = '') {
        // Include various index types for Index type
        var INDEX_TYPES = ['RangeIndex', 'CategoricalIndex', 'MultiIndex', 'IntervalIndex', 'DatetimeIndex', 'TimedeltaIndex', 'PeriodIndex', 'Int64Index', 'UInt64Index', 'Float64Index'];
        // Include various groupby types for Groupby type
        var GROUPBY_TYPES = ['DataFrameGroupBy', 'SeriesGroupBy']
        if (types.indexOf('Index') >= 0) {
            types = types.concat(INDEX_TYPES);
        }
        if (types.indexOf('GroupBy') >= 0) {
            types = types.concat(GROUPBY_TYPES);
        }

        vpKernel.getDataList(types).then(function(resultObj) {
            let { result, type, msg } = resultObj;
            var jsonVars = result.replace(/'/gi, `"`);
            var varList = JSON.parse(jsonVars);
            
            // option tags
            varList.forEach(listVar => {
                if (types.includes(listVar.varType) && listVar.varName[0] !== '_') {
                    var option = document.createElement('option');
                    $(option).attr({
                        'value':listVar.varName,
                        'text':listVar.varName,
                        'data-type':listVar.varType
                    });
                    // cell metadata test : defaultValue as selected
                    if (listVar.varName == defaultValue) {
                        $(option).prop('selected', true);
                    }
                    option.append(document.createTextNode(listVar.varName));
                    $(tag).append(option);
                }
            });

            // val-multi(select multiple) value list registration
            var classname = $(tag).attr('class');
            if (classname == 'var-multi') {
                $(tag).val(defaultValue);
            }

            // trigger change
            $(tag).trigger('change');
        }).catch(err => {
            vpLog.display(VP_LOG_TYPE.ERROR, 'Error on generating var selector', err);
        });
    }

    /**
     * pageId wrap selector
     * @param {string} pageId vp-option-page uuid
     * @param {string} query 
     */
    var vp_wrapSelector = function(pageId, query) {
        return '.'+pageId+' '+query;
    }

    /**
     * Get tag value
     * @param {string} pageId vp-option-page uuid
     * @param {*} obj 
     * @returns {string} tag's value
     */
    var vp_getTagValue = function(pageId, obj) {
        var value = '';
        switch (obj.component) {
            case 'input_multi':
                value = $(vp_wrapSelector(pageId, '#'+obj.name)).val();
                break;
            case 'option_radio':
                var input = $(vp_wrapSelector(pageId, "input[name='"+obj.name+"']:checked")).val();
                // same as default
                if (input == obj.default) break;
                value = input;
                break;
            case 'option_checkbox':
                var checked = $(vp_wrapSelector(pageId, "input[name='"+obj.name+"']:checked")).val();

                for (var i = 0; i < checked.length; i++) {
                    value += "'" + $(checked[i]).val() + "',";
                }
                value = value.substr(0, value.length-1);
                break;
            case 'option_select':
                var input = $(vp_wrapSelector(pageId, '#'+obj.name)).val();
                // same as default
                // if (input == obj.default) break;
                value = input;
                break;
            case 'var_select':
                value = $(vp_wrapSelector(pageId, '#'+obj.name)).val();
                break;
            case 'var_multi':
                value = $(vp_wrapSelector(pageId, '#'+obj.name)).val();
                break;
            case 'col_select':
                value = $(vp_wrapSelector(pageId, '#'+obj.name)).val();
                break;
            case 'table':
            case 'file':
            case 'option_suggest':
            case 'input_number':
            default:
                var input = $(vp_wrapSelector(pageId, '#'+obj.name)).val();
                // same as default
                if (input == obj.default) break;
                value = input;
        }
        return value;
    }

    /**
     * Generate code
     * @param {string} pageId vp-option-page uuid
     * @param {Object} package 
     * @param {string} etcOptions [optional] userOptionCode addition ex) ", test='TEST'"
     * @returns {string} generated code / if error, null
     */
    var vp_codeGenerator = function(pageId, package, etcOptions = '') {
        var code = package.code;
        
        try {
            // input codes
            package.input && package.input.forEach(function(v, i) {
                var val = vp_getTagValue(pageId, v);
                var id = '${' + v.name + '}';
                if (val == undefined || val == ''){
                    if (v.required == undefined || v.required == true) {
                        // throw new Error("'" + v.label + "' is required.");
                    }
                    // if no value, replace it
                    code = code.split(id).join('');
                } else {
                    // text quotation
                    if (v.type == 'text') {
                        val = "'"+val+"'";
                    } 
                    code = code.split(id).join(val);
                }
            });

            // option codes
            var opt_params = ``;
            package.variable && package.variable.forEach(function(v, i) {
                var val = vp_getTagValue(pageId, v);
                // if required
                if (val == undefined || val == ''){
                    if (v.required == true) {
                        // throw new Error("'" + v.label + "' is required.");
                    }
                }
                else {
                    // text quotation
                    if (v.type == 'text') {
                        val = "'"+val+"'";
                    }
                    opt_params += ', '+v.name+'='+val;
                }
            })
            code = code.split('${v}').join(opt_params);

            // output codes
            package.output && package.output.forEach(function(v, i) {
                var val = vp_getTagValue(pageId, v);
                var id = '${' + v.name + '}'
                if (val == undefined || val == ''){
                    if (v.required == true) {
                        // throw new Error("'" + v.label + "' is required.");
                    }
                    // if no output exists, replace it
                    code = code.split(id).join('');
                    code = code.split(' = ').join('');
                } else {
                    // text quotation
                    if (v.type == 'text') {
                        val = "'"+val+"'";
                    }
                    code = code.split(id).join(val);
                }
            });

            // additional userOptionCode
            code = code.split('${etc}').join(etcOptions);

            // () prevent code: (, ${v})
            code = code.split('(, ').join('(');

            // show_result 
            if (_VP_SHOW_RESULT && package.output && package.output.length > 0) {
                var outputVariable = vp_getTagValue(pageId, package.output[0]);
                if (outputVariable != '') {
                    code += '\n'+ outputVariable
                }
            }

        } catch (e) {
            vpLog.display(VP_LOG_TYPE.ERROR, 'com_generator code generation error ' + e.message);
            return null;
        }
        return code;
    }

    /**
     * Bind columns source function
     * @param {string} selector thisWrapSelector 
     * @param {object} target 
     * @param {array} columnInputIdList 
     * Usage : 
     *  $(document).on('change', this.wrapSelector('#dataframe_tag_id'), function() {
     *      pdGen.vp_bindColumnSource(that.wrapSelector(), this, ['column_input_id']);
     *  });
     */
    var vp_bindColumnSource = function(selector, target, columnInputIdList) {
        var varName = '';
        if ($(target).length > 0) {
            varName = $(target).val();
        }
        if (varName === '') {
            // reset with no source
            columnInputIdList && columnInputIdList.forEach(columnInputId => {
                var suggestInputX = new SuggestInput();
                suggestInputX.setComponentID(columnInputId);
                suggestInputX.addClass('vp-input vp-state');
                suggestInputX.setNormalFilter(false);
                suggestInputX.setValue($(selector + ' #' + columnInputId).val());
                $(selector + ' #' + columnInputId).replaceWith(function() {
                    return suggestInputX.toTagString();
                });
            });
            return ;
        }
        // get result and show on detail box
        vpKernel.getColumnList(varName).then(function(resultObj) {
            try {
                let { result, type, msg } = resultObj;
                var varResult = JSON.parse(result);

                // columns using suggestInput
                columnInputIdList && columnInputIdList.forEach(columnInputId => {
                    var suggestInputX = new SuggestInput();
                    suggestInputX.setComponentID(columnInputId);
                    suggestInputX.addClass('vp-input vp-state');
                    suggestInputX.setPlaceholder("column name");
                    suggestInputX.setSuggestList(function() { return varResult; }); //FIXME:
                    suggestInputX.setNormalFilter(false);
                    suggestInputX.setValue($(selector + ' #' + columnInputId).val());
                    $(selector + ' #' + columnInputId).replaceWith(function() {
                        return suggestInputX.toTagString();
                    });
                });
            } catch (e) {
                vpLog.display(VP_LOG_TYPE.ERROR, 'com_generator - bindColumnSource: not supported data type. ', e);
            }
        });

    }

    return {
        vp_showInterfaceOnPage: vp_showInterfaceOnPage,
        vp_codeGenerator: vp_codeGenerator,
        vp_generateVarSelect: vp_generateVarSelect,
        vp_getTagValue: vp_getTagValue,
        vp_bindColumnSource: vp_bindColumnSource
    };
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/com_generatorV2.js":
/*!****************************************************!*\
  !*** ./lib/visualpython/js/com/com_generatorV2.js ***!
  \****************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_generator_v2.js
 *    Author          : Black Logic
 *    Note            : Generator for library options
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 12. 17
 *    Change Date     :
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/com_makeDom */ "./lib/visualpython/js/com/com_makeDom.js"),
    __webpack_require__(/*! vp_base/js/com/component/SuggestInput */ "./lib/visualpython/js/com/component/SuggestInput.js"),
    __webpack_require__(/*! vp_base/js/com/component/VarSelector2 */ "./lib/visualpython/js/com/component/VarSelector2.js"),
    __webpack_require__(/*! vp_base/js/com/component/DataSelector */ "./lib/visualpython/js/com/component/DataSelector.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function (com_util, com_makeDom, SuggestInput, VarSelector2, DataSelector) {
    /**
     * show result after code executed
     */
    var _VP_SHOW_RESULT = true;

    const _VP_COMP_TYPE_LABEL = {
        '1dlen': '1D Length',
        '2dlen': '2D Length',
        '3dlen': '3D Length',
        '1darr': '1D Array',
        '2darr': '2D Array',
        'ndarr': 'ND Array',
        'scalar': 'Scalar Value',
        'param': 'Param Value',
        'dtype': 'Dtype',
        'bool_checkbox': 'Boolean',
        'bool_select': 'Select Boolean',
        'option_select': 'Select option',
        'option_suggest': 'Input option',
        'data_select': 'Select data',
        'var_select': 'Select Variable',
        'var_multi': 'Select N-Variables',
        'col_select': 'Select Column',
        'textarea': 'Input textarea',
        'input_number': 'Input number',
        'input_text': 'Input text', 
        'input': 'Input value'
    }

    const _VP_BOOL_OPTIONS = [
        { label: 'Select option...', value: ''},
        { label: 'True', value: 'True' },
        { label: 'False', value: 'False' }
    ]

    const _VP_NP_DTYPES = [
        {
            name: 'Default',
            value: ''
        },
        {
            name: 'None',
            value: 'None'
        },
        {
            name: 'Int8',
            value: 'np.int8'
        },
        {
            name: 'Int16',
            value: 'np.int16'
        },
        {
            name: 'Int32',
            value: 'np.int32'
        },
        {
            name: 'Int64',
            value: 'np.int64'
        },
        {
            name: 'Intp',
            value: 'np.intp'
        },
        {
            name: 'uInt8',
            value: 'np.uint8'
        },
        {
            name: 'uInt16',
            value: 'np.uint16'
        },
        {
            name: 'uInt32',
            value: 'np.uint32'
        },
        {
            name: 'uInt64',
            value: 'np.uint64'
        },
        {
            name: 'Float16',
            value: 'np.float16'
        },
        {
            name: 'Float32',
            value: 'np.float32'
        },
        {
            name: 'Float64',
            value: 'np.float64'
        },
        {
            name: 'Bool',
            value: 'np.bool'
        },
        {
            name: 'String',
            value: 'np.string_'
        }
    ];

     /**
     * Generate page interface based on package configuration
     * @param {Component} pageThis
     * @param {*} package 
     */
    var vp_showInterfaceOnPage = function(pageThis, package, state={}) {

        // generate input variable tag
        var tblInput = $(pageThis.wrapSelector()+' #vp_inputOutputBox table tbody');
        // generate option variable tag
        var tblOption = $(pageThis.wrapSelector()+' #vp_optionBox table tbody');

        package.options && package.options.forEach(function(o, i) {
            var obj = JSON.parse(JSON.stringify(o));
            let newTag = vp_createTag(pageThis, obj, state);
            if (obj.required) {
                tblInput.append(newTag);
            } else {
                tblOption.append(newTag);
            }
        });

        // TODO: userOption

        bindAutoComponentEvent(pageThis);
    }

    /**
     * Generate tag using type
     * @param {String} selector
     * @param {Object} obj 
     * @param {Object} state
     */
    var vp_createTag = function(pageThis, obj, state) {
        // TR tag & TD label tag
        var tblRow = $('<tr></tr>')
        var tblLabel = $('<td></td>');
        var tblContent = $('<td></td>');

        
        let { name, label, component, required } = obj;
        let value = state[name];
        
        var requiredFontStyle = required == true? 'vp-orange-text' : '';
        var lblTag = $(`<label>${label}</label>`).attr({
            'for': name,
            'class': requiredFontStyle,
            'title': '(' + name + ')'
        });
        $(tblLabel).append(lblTag);

        let componentType = 'input';
        if (component) {
            if (component.length == 1) {
                componentType = component[0];
            } else {
                let compSlct = $('<select></select>').attr({
                    'class': 'vp-select vp-state vp-auto-component-selector',
                    'id': name + '_type'
                });
                compSlct.data('obj', obj);
                let defaultCompIdx = 0;
                component.forEach((comp, idx) => {
                    let compLabel = _VP_COMP_TYPE_LABEL[comp];
                    let option = $(`<option>${compLabel}</option>`).attr({
                        'index': idx,
                        'value': comp
                    });
                    // set as previous data 
                    if (state[name + '_type'] != undefined) {
                        // set as saved value
                        if (state[name + '_type'] == comp) {
                            $(option).attr({
                                'selected':'selected'
                            });
                            defaultCompIdx = idx;
                        }
                    }
                    compSlct.append(option);
                });
                tblContent.append(compSlct);
                // set default component type
                componentType = component[defaultCompIdx];
            }
        }
        // render content
        let contentTag = $('<div class="vp-auto-component-content"></div>');
        contentTag.append(renderContent(pageThis, componentType, obj, state));
        tblContent.append(contentTag);
        
        tblRow.append(tblLabel);
        tblRow.append(tblContent);
        
        return tblRow;
    }

    var renderContent = function(pageThis, componentType, obj, state={}) {
        let content = '';
        let value = state[obj.name];
        if (value == undefined) {
            if (obj.value != undefined) {
                value = obj.value;
            } else if (obj.default != undefined) {
                value = obj.default;
            } else {
                value = '';
            }
        } else {
            obj.value = value;
        }
        // create as component type
        switch (componentType) {
            case '1dlen':
                content = render1dLen(pageThis, obj, state);
                break;
            case '2dlen':
                content = render2dLen(pageThis, obj, state);
                break;
            case '3dlen':
                content = render3dLen(pageThis, obj, state);
                break;
            case '1darr':
                content = render1dArr(pageThis, obj, state);
                break;
            case '2darr':
                content = render2dArr(pageThis, obj, state);
                break;
            case 'ndarr':
                content = renderNdArr(pageThis, obj, state);
                break;
            case 'scalar':
                content = renderScalar(pageThis, obj, state);
                break;
            case 'param':
                content = renderParam(pageThis, obj, state);
                break;
            case 'dtype':
                content = renderDtypeSelector(pageThis, obj, state);
                break;
            case 'tabblock':
                content = renderTabBlock(pageThis, obj, state);
                break;
            case 'bool_checkbox':
                content = $(`<input type="checkbox" id="${obj.name}" class="vp-checkbox"/>`);
                if (value != undefined) {
                    // set as saved value
                    $(content).attr({
                        'checked': value
                    });
                }
                break;
            case 'bool_select':
                // True False select box
                var optSlct = $(`<select id="${obj.name}" class="vp-select vp-state"></select>`);
                _VP_BOOL_OPTIONS.forEach((opt, idx) => {
                    var option = $(`<option>${opt.label}${obj.default==opt.value?' (default)':''}</option>`).attr({
                        // 'id':opt,
                        'index':obj.index,
                        'name':obj.name,
                        // 'value':(obj.default==opt.value?'':opt.value)
                        'value':opt.value
                    });
                    // cell metadata test
                    if (value != undefined) {
                        // set as saved value
                        if (value == opt.value) {
                            $(option).attr({
                                'selected':'selected'
                            });
                        }
                    } else {
                        // set default value
                        // if (value == opt.default) {
                        //     $(option).attr({
                        //         'selected':'selected'
                        //     });
                        // }
                    }
                    optSlct.append(option);
                });
                content = optSlct;
                break;
            case 'option_select':
                var optSlct = $('<select></select>').attr({
                    'class':'vp-select option-select vp-state',
                    'id':obj.name
                });
                obj.options.forEach((opt, idx, arr) => {
                    var label = (obj.options_label != undefined? obj.options_label[idx]:opt);
                    let isDefault = false;
                    if (obj.required != true && obj.default != undefined && obj.default == opt) {
                        isDefault = true;
                        label += ' (default)';
                    }
                    var option = $(`<option>${label}</option>`).attr({
                        // 'id':opt,
                        'index':obj.index,
                        'name':obj.name,
                        'value':(isDefault? '': opt)
                    });
                    // saved data
                    if ((value == opt)
                        || ((value == undefined || value == '') && isDefault)) {
                        // set as saved value
                        $(option).attr({
                            'selected':'selected'
                        });
                    }
                    optSlct.append(option);
                });
                content = optSlct;
                break;
            case 'option_suggest':
                // suggest input tag
                // 1. Target Variable
                var suggestInput = new SuggestInput();
                suggestInput.setComponentID(obj.name);
                suggestInput.addClass('vp-input vp-state');
                suggestInput.setSuggestList(function() { return obj.options; });
                suggestInput.setNormalFilter(obj.useFilter == undefined?false:obj.useFilter);
                suggestInput.setValue(value);
                if (obj.placeholder != undefined) {
                    suggestInput.setPlaceholder(obj.placeholder);
                }
                if (obj.required === true) {
                    suggestInput.addAttribute('required', true);
                }
                suggestInput.setSelectEvent(function(selectedValue) {
                    // trigger change
                    $(pageThis.wrapSelector('#' + obj.name)).val(selectedValue);
                    $(pageThis.wrapSelector('#' + obj.name)).trigger('change');
                });
                content = $(suggestInput.toTagString());
                break;
            case 'data_select':
                let dataSelector = new DataSelector({
                    pageThis: pageThis, 
                    id: obj.name,
                    allowDataType: obj.var_type, 
                    placeholder: obj.placeholder || 'Select data',
                    value: value,
                    required: obj.required === true
                });
                content = $(dataSelector.toTagString());
                break;
            case 'var_select':
                // suggest input tag
                var tag = $('<input/>').attr({
                    type: 'text',
                    id: obj.name,
                    class: 'vp-input vp-state',
                    required: obj.required === true
                });
                vp_generateVarSuggestInput(pageThis.wrapSelector(), obj);
                content = tag;
                break;
            case 'var_multi':
                // select tag with multiple selection
                var tag = $('<select></select>').attr({
                    'id': obj.name,
                    'class': 'vp-select var-multi vp-state',
                    // multiple selection true
                    'multiple': true
                });
                vp_generateVarSelect(tag, obj.var_type, obj.value);
                content = tag;
                break;
            case 'col_select':
                var tag = $('<input/>').attr({
                    'type': 'text',
                    'id': obj.name,
                    'class': 'vp-input vp-state'
                });
                content = tag;
                break;
            case 'textarea':
                var textarea = $(`<textarea id="${obj.name}" class="vp-textarea vp-state">${(obj.default==undefined?'':obj.default)}</textarea>`);
                // cell metadata test
                if (value != undefined) {
                    // set as saved value
                    textarea.val(value);
                }
                content = textarea;
                break;
            case 'input_number':
                var input = $('<input/>').attr({
                    type: 'number',
                    class: 'vp-input vp-state',
                    id: obj.name,
                    placeholder: (obj.placeholder==undefined?'Input Number':obj.placeholder),
                    value: (obj.default==undefined?'':obj.default),
                    title: (obj.help==undefined?'':obj.help),
                    required: obj.required === true
                });
                if (obj.step != undefined) {
                    $(input).attr({ 'step': obj.step });
                }
                if (obj.min != undefined) {
                    $(input).attr({ 'min': obj.min });
                }
                if (obj.max != undefined) {
                    $(input).attr({ 'max': obj.max });
                }
                // cell metadata test
                if (value != undefined) {
                    // set as saved value
                    $(input).attr({
                        'value': value
                    });
                }
                content = input;
                break;
            case 'table':
                // break;
            case 'file':
                // break;
            // default : input_single
            default:
                var input = $('<input/>').attr({
                    type: 'text',
                    class: 'vp-input input-single vp-state',
                    id: obj.name,
                    placeholder: (obj.placeholder==undefined?'Input Data':obj.placeholder),
                    value: (obj.default==undefined?'':obj.default),
                    title: (obj.help==undefined?'':obj.help),
                    required: obj.required == true
                });
                // cell metadata test
                if (value != undefined) {
                    // set as saved value
                    $(input).attr({
                        'value': value
                    });
                }
                content = input;
                break;
        }

        return content;
    }

    /**
     * Generate suggest input
     * @param {object} obj
     */
    var vp_generateVarSuggestInput = function(divTag, obj) {
        var types = obj.var_type;
        var defaultValue = obj.value;
        if (obj.value == undefined && obj.default != undefined) {
            defaultValue = obj.default;
        }

        if (types == undefined) {
            types = [];
        }

        // Include various index types for Index type
        var INDEX_TYPES = ['RangeIndex', 'CategoricalIndex', 'MultiIndex', 'IntervalIndex', 'DatetimeIndex', 'TimedeltaIndex', 'PeriodIndex', 'Int64Index', 'UInt64Index', 'Float64Index'];
        // Include various groupby types for Groupby type
        var GROUPBY_TYPES = ['DataFrameGroupBy', 'SeriesGroupBy']
        if (types && types.indexOf('Index') >= 0) {
            types = types.concat(INDEX_TYPES);
        }
        if (types && types.indexOf('GroupBy') >= 0) {
            types = types.concat(GROUPBY_TYPES);
        }

        vpKernel.getDataList(types).then((resultObj) => {
            let { result, type, msg } = resultObj;
            var varList = JSON.parse(result);
            varList = varList.map(function(v) {
                return { label: v.varName, value: v.varName, dtype: v.varType };
            });
            // 1. Target Variable
            var suggestInput = new SuggestInput();
            suggestInput.setComponentID(obj.name);
            suggestInput.addClass('vp-input vp-state');
            suggestInput.setSuggestList(function() { return varList; });
            suggestInput.setNormalFilter(false);
            suggestInput.setValue(defaultValue);
            if (obj.required === true) {
                suggestInput.addAttribute('required', true);
            }
            if (obj.placeholder != undefined) {
                suggestInput.setPlaceholder(obj.placeholder);
            }
            suggestInput.setSelectEvent(function(selectedValue) {
                // trigger change
                $(divTag + ' #' + obj.name).val(selectedValue);
                $(divTag + ' #' + obj.name).trigger('change');
            });
            $(divTag + ' #' + obj.name).replaceWith(function() {
                return suggestInput.toTagString();
            });
        }).catch(err => {
            vpLog.display(VP_LOG_TYPE.ERROR, 'Error on generating var suggest input', err);
        });
    }

    /**
     * Generate variable select tag
     * @param {object} tag 
     * @param {Array<string>} types 
     * @param {string} defaultValue 
     */
    var vp_generateVarSelect = function(tag, types, defaultValue = '') {
        // Include various index types for Index type
        var INDEX_TYPES = ['RangeIndex', 'CategoricalIndex', 'MultiIndex', 'IntervalIndex', 'DatetimeIndex', 'TimedeltaIndex', 'PeriodIndex', 'Int64Index', 'UInt64Index', 'Float64Index'];
        // Include various groupby types for Groupby type
        var GROUPBY_TYPES = ['DataFrameGroupBy', 'SeriesGroupBy']
        if (types.indexOf('Index') >= 0) {
            types = types.concat(INDEX_TYPES);
        }
        if (types.indexOf('GroupBy') >= 0) {
            types = types.concat(GROUPBY_TYPES);
        }

        vpKernel.getDataList(types).then(function(resultObj) {
            let { result, type, msg } = resultObj;
            var jsonVars = result.replace(/'/gi, `"`);
            var varList = JSON.parse(jsonVars);
            
            // option tags
            varList.forEach(listVar => {
                if (types.includes(listVar.varType) && listVar.varName[0] !== '_') {
                    var option = document.createElement('option');
                    $(option).attr({
                        'value':listVar.varName,
                        'text':listVar.varName,
                        'data-type':listVar.varType
                    });
                    // cell metadata test : defaultValue as selected
                    if (listVar.varName == defaultValue) {
                        $(option).prop('selected', true);
                    }
                    option.append(document.createTextNode(listVar.varName));
                    $(tag).append(option);
                }
            });

            // val-multi(select multiple) value list registration
            var classname = $(tag).attr('class');
            if (classname == 'var-multi') {
                $(tag).val(defaultValue);
            }

            // trigger change
            $(tag).trigger('change');
        }).catch(err => {
            vpLog.display(VP_LOG_TYPE.ERROR, 'Error on generating var selector', err);
        });
    }

    /**
     * Get tag value
     * @param {Object} pageThis
     * @param {*} obj 
     * @returns {string} tag's value
     */
    var vp_getTagValue = function(pageThis, obj) {
        var value = '';
        let componentType = 'input';
        if (obj.component && obj.component.length == 1) {
            componentType = obj.component[0];
        } else {
            componentType = $(pageThis.wrapSelector('#' + obj.name + '_type')).val();
        }
        switch (componentType) {
            case 'option_radio':
                var input = $(pageThis.wrapSelector("input[name='"+obj.name+"']:checked")).val();
                // same as default
                if (input == obj.default) break;
                value = input;
                break;
            case 'option_checkbox':
                let checked = $(pageThis.wrapSelector("input[name='"+obj.name+"']:checked")).val();

                for (var i = 0; i < checked.length; i++) {
                    value += "'" + $(checked[i]).val() + "',";
                }
                value = value.substr(0, value.length-1);
                break;
            case 'bool_checkbox':
                let isChecked = $(pageThis.wrapSelector('#'+obj.name)).prop('checked');
                value = isChecked?'True':'False';
                break;
            case 'input_multi':
            case 'bool_select':
            case 'data_select':
            case 'var_select':
            case 'var_multi':
            case 'col_select':
            case 'dtype':
                value = $(pageThis.wrapSelector('#'+obj.name)).val();
                break;
            case 'table':
            case 'file':
            case 'option_select':
            case 'option_suggest':
            case 'input_number':
            default:
                var input = $(pageThis.wrapSelector('#'+obj.name)).val();
                // same as default
                if (input == obj.default) break;
                value = input;
        }
        return value;
    }

    /**
     * Generate code
     * @param {Object} pageThis
     * @param {Object} package 
     * @param {string} etcOptions [optional] userOptionCode addition ex) ", test='TEST'"
     * @returns {string} generated code / if error, null
     */
    var vp_codeGenerator = function(pageThis, package, state = {}, etcOptions = '') {
        var code = package.code;
        
        try {
            package.options && package.options.forEach(function(v, i) {
                var val = state[v.name];
                if (val == undefined || val == '' || val == v.default) {
                    val = vp_getTagValue(pageThis, v);
                }
                var id = '${' + v.name + '}';
                if (val == undefined || val.trim() == '') {
                    if (v.required == true) {
                        // throw new Error("'" + v.label + "' is required.");
                    }
                    // if no value, replace it
                    code = code.split(id).join('');
                } else {
                    // text quotation
                    if (v.type == 'text') {
                        val = "'"+val+"'";
                    } 
                    // code completion
                    if (v.code != undefined) {
                        val = v.code.split(id).join(val);
                    }
                    // code completion 2
                    if (v.usePair == true) {
                        val = ', ' + v.name + '=' + val;
                    }
                    // code completion 3
                    if (v.component != undefined && v.componentCode != undefined) {
                        let autoSelector = state[v.name + '_type'];
                        let compIdx = v.component.indexOf(autoSelector);
                        if (compIdx < 0) {
                            compIdx = 0;
                        }
                        let compCode = v.componentCode[compIdx];
                        if (compCode != '') {
                            val = compCode.split(id).join(val);
                        }
                    }
                    code = code.split(id).join(val);
                }
            });

            // additional userOptionCode
            code = code.split('${etc}').join(etcOptions);

            // () prevent code: (, ${v})
            code = code.split('(, ').join('(');

            // prevent code: no allocation variable ( = pd.DataFrame())
            if (code.startsWith(' = ')) {
                code = code.substr(3);
            }

        } catch (e) {
            vpLog.display(VP_LOG_TYPE.ERROR, 'com_generator v2 code generation error ' + e.message);
            return null;
        }
        return code;
    }

    /**
     * Bind columns source function
     * @param {object} pageThis
     * @param {object} targetId 
     * @param {array} columnInputIdList 
     * @param {string} tagType input / select (tag type)
     * @param {array/boolean} columnWithEmpty boolean array or value to decide whether select tag has empty space
     * @param {array/boolean} columnWithIndex boolean array or value to decide whether select tag has index option
     * Usage : 
     *  $(document).on('change', this.wrapSelector('#dataframe_tag_id'), function() {
     *      pdGen.vp_bindColumnSource(that, 'dataframe_tag_id', ['column_input_id'], 'select', [true, true, true]);
     *  });
     */
    var vp_bindColumnSource = function(pageThis, targetId, columnInputIdList, tagType="input", columnWithEmpty=false, columnWithIndex=false) {
        var varName = pageThis.state[targetId];
        if (varName === '') {
            // reset with no source
            columnInputIdList && columnInputIdList.forEach(columnInputId => {
                let defaultValue = pageThis.state[columnInputId];
                if (defaultValue === null || defaultValue === undefined) {
                    defaultValue = '';
                }
                if (tagType == 'input') {
                    var suggestInputX = new SuggestInput();
                    suggestInputX.setComponentID(columnInputId);
                    suggestInputX.addClass('vp-input vp-state');
                    suggestInputX.setNormalFilter(false);
                    suggestInputX.setValue(defaultValue);
                    $(selector + ' #' + columnInputId).replaceWith(function() {
                        return suggestInputX.toTagString();
                    });
                } else {
                    // option tags
                    var tag = $('<select></select>').attr({
                        'id': columnInputId,
                        'class': 'vp-select vp-state'
                    });
                    $(selector + ' #' + columnInputId).replaceWith(function() {
                        return $(tag);
                    });
                }
            });
            return ;
        }
        // get result and show on detail box
        vpKernel.getColumnList(varName).then(function(resultObj) {
            try {
                let { result, type, msg } = resultObj;
                var varResult = JSON.parse(result);

                // check if it needs to add index option
                let addIndex = false;
                if (Array.isArray(columnWithIndex)) {
                    addIndex = columnWithIndex[idx];
                } else {
                    addIndex = columnWithIndex;
                }
                if (addIndex == true) {
                    varResult = [
                        {value: varName + '.index', label: 'index'},
                        ...varResult
                    ]
                }

                // check if it needs to add empty option
                let addEmpty = false;
                if (Array.isArray(columnWithEmpty)) {
                    addEmpty = columnWithEmpty[idx];
                } else {
                    addEmpty = columnWithEmpty;
                }
                if (addEmpty == true) {
                    varResult = [
                        {value: '', label: 'Select option...'},
                        ...varResult
                    ]
                }

                // columns using suggestInput
                columnInputIdList && columnInputIdList.forEach((columnInputId, idx) => {
                    let defaultValue = pageThis.state[columnInputId];
                    if (defaultValue === null || defaultValue === undefined) {
                        defaultValue = '';
                    }
                    // create tag
                    if (tagType == 'input') {
                        var suggestInputX = new SuggestInput();
                        suggestInputX.setComponentID(columnInputId);
                        suggestInputX.addClass('vp-input vp-state');
                        suggestInputX.setPlaceholder("column name");
                        suggestInputX.setSuggestList(function() { return varResult; }); //FIXME:
                        suggestInputX.setNormalFilter(false);
                        suggestInputX.setValue(defaultValue);
                        $(selector + ' #' + columnInputId).replaceWith(function() {
                            return suggestInputX.toTagString();
                        });
                    } else {
                        var tag = $('<select></select>').attr({
                            'id': columnInputId,
                            'class': 'vp-select vp-state'
                        });
                        // make tag
                        varResult.forEach(listVar => {
                            var option = document.createElement('option');
                            $(option).attr({
                                'value':listVar.value,
                                'text':listVar.label,
                                'data-type':listVar.dtype
                            });
                            // cell metadata test : defaultValue as selected
                            if (listVar.value === defaultValue) {
                                $(option).prop('selected', true);
                            }
                            option.append(document.createTextNode(listVar.label));
                            $(tag).append(option);
                        });
                        $(pageThis.wrapSelector('#' + columnInputId)).replaceWith(function() {
                            return $(tag);
                        });
                    }
                }).catch(function(err) {
                    vpLog.display(VP_LOG_TYPE.ERROR, 'com_generator - bindColumnSource error ', err)
                });
                
                
            } catch (e) {
                vpLog.display(VP_LOG_TYPE.ERROR, 'com_generator - bindColumnSource: not supported data type. ', e);
            }
        });
    }

    //========================================================================
    // Render components
    //========================================================================
    var render1dLen = function(pageThis, obj, state) {
        state = {
            [obj.name]: '',
            ...state
        };
        return $(`<div class="vp-numpy-style-flex-row">
            <div class="vp-numpy-style-flex-row" style="margin-right:10px;">
                <span class="vp-numpy-style-flex-column-center mr5">
                    Length
                </span>
                <input type="text" id="${obj.name}" value="${state[obj.name]}" class="vp-input vp-state" style="width:200px;" placeholder="Input Number">
            </div>
        </div>`)
    }

    var render2dLen = function(pageThis, obj, state) {
        state = {
            [obj.name + '_row']: '',
            [obj.name + '_col']: '',
            ...state
        }
        return $(`<div class="vp-numpy-style-flex-row">
            <div class="vp-numpy-style-flex-row" style="margin-right:10px;">
                <span class="vp-numpy-style-flex-column-center" style="margin-right:5px;">
                    Row
                </span>
                <input type="text" id="${obj.name}_row" data-id="${obj.name}" value="${state[obj.name+'_row']}" class="vp-input vp-state vp-numpy-2dlen-item" style="width:150px;" placeholder="Number">
            </div>
            <div class="vp-numpy-style-flex-row" style="margin-right:10px;">
                <span class="vp-numpy-style-flex-column-center" style="margin-right:5px;">
                    Col
                </span>
                <input type="text" id="${obj.name}_col" data-id="${obj.name}"  value="${state[obj.name+'_col']}" class="vp-input vp-state vp-numpy-2dlen-item" style="width:150px;" placeholder="Number">
            </div>
            <input type="hidden" class="vp-state" id="${obj.name}" value="${state[obj.name]}">
        </div>`);
    }

    var render3dLen = function(pageThis, obj, state) {
        state = {
            [obj.name + '_plane']: '',
            [obj.name + '_row']: '',
            [obj.name + '_col']: '',
            ...state
        }
        return $(`<div class="vp-numpy-style-flex-row">
            <div class="vp-numpy-style-flex-row" style="margin-right:10px;">
                <span class="vp-numpy-style-flex-column-center" style="margin-right:5px;">
                    Plane
                </span>
                <input type="text" id="${obj.name}_plane" data-id="${obj.name}" value="${state[obj.name+'_plane']}" class="vp-input vp-state vp-numpy-3dlen-item" style="width:150px;" placeholder="Number">
            </div>
            <div class="vp-numpy-style-flex-row" style="margin-right:10px;">
                <span class="vp-numpy-style-flex-column-center" style="margin-right:5px;">
                    Row
                </span>
                <input type="text" id="${obj.name}_row" data-id="${obj.name}" value="${state[obj.name+'_row']}" class="vp-input vp-state vp-numpy-3dlen-item" style="width:150px;" placeholder="Number">
            </div>
            <div class="vp-numpy-style-flex-row" style="margin-right:10px;">
                <span class="vp-numpy-style-flex-column-center" style="margin-right:5px;">
                    Col
                </span>
                <input type="text" id="${obj.name}_col" data-id="${obj.name}"  value="${state[obj.name+'_col']}" class="vp-input vp-state vp-numpy-3dlen-item" style="width:150px;" placeholder="Number">
            </div>
            <input type="hidden" class="vp-state" id="${obj.name}" value="${state[obj.name]}">
        </div>`);
    }

    var render1dArr = function(pageThis, obj, state) {
        let arrKey = obj.name + '_1darr';
        let arrState = [ 0 ];
        let value = `[${arrState.join(',')}]`;
        if (state[arrKey] == undefined) {
            pageThis.setState({ [arrKey]: arrState });
            pageThis.setState({ [obj.name]: value});
        } else {
            arrState = state[arrKey];
            value = `[${arrState.join(',')}]`;
        }

        let contentTag = $(`<div class="vp-numpy-1darr-box"></div>`);
        $(contentTag).attr({
            'data-id': obj.name
        });
        contentTag.data('obj', obj);
        // Length setting
        contentTag.append($(`<div class="vp-numpy-style-flex-row-center">
            <div style="margin:0 5px;">
                <span>Length : </span>
                <input class="vp-input vp-numpy-1darr-set-num" style="width:50px;"
                    value="${arrState.length}" type="number">
            </div>
            <button class="vp-button vp-numpy-1darr-set">
                Set
            </button>
            <input type="hidden" class="vp-state" id="${obj.name}" value="${value}">
        </div>`));
        // Array Items
        let arrItems = $(`<div class="vp-numpy-style-flex-row-wrap vp-numpy-1darr-item-box"></div>`);
        arrState.forEach((item, idx) => {
            arrItems.append(render1dArrItem(idx, item));
        });
        contentTag.append(arrItems);
        // add button
        contentTag.append($(`<button class="vp-button vp-numpy-1darr-add">+ Add</button>`));
        return contentTag;
    }

    var render1dArrItem = function(idx, value=0) {
        return $(`<div class="vp-numpy-style-flex-column" style="margin-top:10px;;margin-bottom:10px;">
            <div class="text-center" style="margin-top:10px;;margin-bottom:10px;">
                ${idx}
            </div>
            <input class="vp-input vp-numpy-1darr-item" style="width:40px;" type="text" data-idx="${idx}" value="${value}">
            <button class="vp-button vp-numpy-1darr-del" style="width:40px;">
                x
            </button>
        </div>`);
    }

    var render2dArr = function(pageThis, obj, state) {
        let arrKey = obj.name + '_2darr';
        let arrState = [[0]];
        let value = `[[0]]`;
        if (state[arrKey] == undefined) {
            pageThis.setState({ [arrKey]: arrState });
            pageThis.setState({ [obj.name]: value});
        } else {
            arrState = state[arrKey];
            value = `[${arrState.map(ele => '[' + ele.join(',') + ']').join(',')}]`;
        }

        let contentTag = $(`<div class="vp-numpy-2darr-box"></div>`);
        $(contentTag).attr({
            'data-id': obj.name
        });
        contentTag.data('obj', obj);
        // Length setting
        let rowLength = arrState.length;
        let colLength = 0;
        if (arrState.length > 0) {
            colLength = Math.max(...arrState.map(ele => ele.length));
        }
        contentTag.append(`<div class="vp-numpy-style-flex-row-center">
            <div style="margin:0 5px;">
                <span>Row : </span>
                <input class="vp-input vp-numpy-2darr-set-row" style="width:50px;" value="${rowLength}" type="text">
            </div>
            <div style="margin:0 5px;">
                <span>Col : </span>
                <input class="vp-input vp-numpy-2darr-set-col" style="width:50px;" value="${colLength}" type="text">
            </div>
            <button class="vp-button vp-numpy-2darr-set">Set</button>
            <input type="hidden" class="vp-state" id="${obj.name}" value="${value}">
        </div>`)
        // Array Items
        let arrItems = $(`<div class="vp-numpy-style-flex-column vp-numpy-2darr-item-box"></div>`);
        arrState.forEach((item, idx) => {
            arrItems.append(render2dArrItem(idx, item));
        });
        contentTag.append(arrItems);
        // row add button
        contentTag.append($(`<button class="vp-button vp-numpy-2darr-row-add" style="width: 100%;">+ Row</button>`));
        return contentTag;
    }

    var render2dArrItem = function(rowIdx, item) {
        let arrRowBox = $(`<div class="vp-numpy-arrayEditor-row-block vp-numpy-style-flex-row vp-numpy-box-border"></div>`);
        let arrRows = $(`<div class="vp-numpy-style-flex-row" style="width: 80%; margin-top:5px; margin-bottom:5px;"></div>`);
        // row index
        arrRows.append($(`<div class="vp-numpy-style-flex-column-center vp-bold vp-numpy-2darr-row" data-idx="${rowIdx}" style="width: 10%;">
            ${rowIdx}
        </div>`))
        // columns
        let arrColBox = $(`<div class="vp-numpy-style-flex-column" style="width: 90%;"></div>`);
        let arrCols = $(`<div class="vp-numpy-array-row-container vp-numpy-style-flex-row-wrap" style="width:100%;"></div>`);
        item.forEach((col, idx) => {
            arrCols.append($(`<div class="vp-numpy-style-flex-column" style="margin-top:5px">
                <span class="vp-numpy-style-flex-row-center vp-bold">
                    ${idx}
                </span>
                <input class="vp-input vp-numpy-2darr-item" style="width:40px;" value="${col}" data-rowidx="${rowIdx}" data-idx="${idx}" type="text">
                <button class="vp-button vp-numpy-2darr-col-del" style="width:40px;" title="Delete column">
                    x
                </button>
            </div>`));
        });
        arrColBox.append(arrCols);
        arrRows.append(arrColBox);
        arrRowBox.append(arrRows);
        // col add button
        arrRowBox.append($(`<div class="vp-numpy-style-flex-column-center" style="width:10%;">
            <button class="vp-button vp-numpy-2darr-col-add" style="width: 100%;height:40px;max-height:80px;" title="Add column">+</button>
        </div>`));
        // row delete button
        arrRowBox.append($(`<div class="vp-numpy-style-flex-column-center" style="width:10%;">
            <button class="vp-button vp-numpy-2darr-row-del" style="width: 100%;height:40px;max-height:80px;" title="Delete row">x</button>
        </div>`));
        return arrRowBox;
    }

    var renderNdArr = function(pageThis, obj, state) {
        let arrKey = obj.name + '_ndarr';
        let arrState = [ '' ];
        let value = `${arrState.join(',')}`;
        if (state[arrKey] == undefined) {
            pageThis.setState({ [arrKey]: arrState });
            pageThis.setState({ [obj.name]: value});
        } else {
            arrState = state[arrKey];
            value = `${arrState.join(',')}`;
        }

        let contentTag = $(`<div class="vp-numpy-ndarr-box"></div>`);
        $(contentTag).attr({
            'data-id': obj.name
        });
        contentTag.data('obj', obj);
        // Array Items
        let arrItems = $(`<div class="vp-numpy-style-flex-row-between-wrap vp-scrollbar" style="max-height: 200px; overflow: auto;"></div>`);
        arrState.forEach((item, idx) => {
            arrItems.append($(`<div class="vp-numpy-style-flex-row">
                <div class="vp-numpy-style-flex-column-center vp-bold mr5 w10">
                    ${idx + 1}
                </div>
                <input class="vp-numpy-input vp-numpy-ndarr-item" data-idx="${idx}" value="${item}" type="text" placeholder="Value">
                <button class="vp-button vp-numpy-ndarr-del w30">x</button>
            </div>`));
        });
        contentTag.append(arrItems);
        // add button
        contentTag.append($(`<button class="vp-button vp-numpy-ndarr-add w30">+</button>`));
        return contentTag;
    }

    var renderScalar = function(pageThis, obj, state) {
        let placeholder = 'Input Scalar';
        if (obj.placeholder) {
            placeholder = obj.placeholder;
        }
        return $(`<input class="vp-input vp-state" id="${obj.name}" placeholder="${placeholder}" value="${state[obj.name]}"/>`);
    }

    var renderParam = function(pageThis, obj, defaultValue) {
        let placeholder = 'Input Param';
        if (obj.placeholder) {
            placeholder = obj.placeholder;
        }
        return $(`<input class="vp-input vp-state" id="${obj.name}" placeholder="${placeholder}" value="${state[obj.name]}"/>`);
    }

    var renderDtypeSelector = function(pageThis, obj, defaultValue) {
        let slctTag = $('<select></select>').attr({
            class: 'vp-select vp-state',
            id: obj.name
        });
        _VP_NP_DTYPES.forEach(dtypeObj => {
            let { name, value } = dtypeObj;
            let option = $(`<option>${name}</option>`).attr({
                'value': value
            });
            if (value != undefined && value == defaultValue) {
                $(option).attr({
                    'selected':'selected'
                });
            }
            slctTag.append(option);
        });
        return slctTag;
    }

    var renderTabBlock = function(pageThis, obj, defaultValue) {
        return $('<input value="tabblock"/>');
    }

    var bindAutoComponentEvent = function(pageThis) {
        let selector = pageThis.wrapSelector();
        // Auto-component selector
        $(selector).on('change', '.vp-auto-component-selector', function() {
            let contentTag = $(this).parent().find('.vp-auto-component-content');
            let newType = $(this).val();
            let obj = $(this).data('obj');
            $(contentTag).html(renderContent(pageThis, newType, obj, pageThis.getState()));
        }); 

        //====================================================================
        // Event for 2dLen
        //====================================================================
        $(selector).on('change', '.vp-numpy-2dlen-item', function() {
            let id = $(this).data('id');
            let newValue = pageThis.getState(id+'_row') + ',' + pageThis.getState(id+'_col');
            $(pageThis.wrapSelector('#' + id)).val(newValue);
            $(pageThis.wrapSelector('#' + id)).trigger('change');
        }); 

        //====================================================================
        // Event for 3dLen
        //====================================================================
        $(selector).on('change', '.vp-numpy-3dlen-item', function() {
            let id = $(this).data('id');
            let newValue = pageThis.getState(id+'_plane') + ',' + pageThis.getState(id+'_row') + ',' + pageThis.getState(id+'_col');
            $(pageThis.wrapSelector('#' + id)).val(newValue);
            $(pageThis.wrapSelector('#' + id)).trigger('change');
        }); 

        //====================================================================
        // Event for 1dArr
        //====================================================================
        $(selector).on('click', '.vp-numpy-1darr-set', function() {
            let id = $(this).closest('.vp-numpy-1darr-box').data('id');
            let arrId = id + '_1darr';
            let len = $(this).parent().find('.vp-numpy-1darr-set-num').val();
            // update state
            let state = Array(parseInt(len)).fill(0);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-1darr-box').data('obj');
            $(this).closest('.vp-numpy-1darr-box').replaceWith(function() {
                return render1dArr(pageThis, obj, pageThis.getState());
            });
        }); 

        $(selector).on('click', '.vp-numpy-1darr-del', function() {
            let id = $(this).closest('.vp-numpy-1darr-box').data('id');
            let arrId = id + '_1darr';
            let idx = $(this).parent().find('.vp-numpy-1darr-item').data('idx');
            // update state
            let state = pageThis.getState(arrId);
            state.splice(idx, 1);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-1darr-box').data('obj');
            $(this).closest('.vp-numpy-1darr-box').replaceWith(function() {
                return render1dArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('click', '.vp-numpy-1darr-add', function() {
            let id = $(this).closest('.vp-numpy-1darr-box').data('id');
            let arrId = id + '_1darr';
            let idx = 0;
            // update state
            let state = pageThis.getState(arrId);
            if (!state) {
                state = [];
            } else {
                idx = state.length;
            }
            state.push(0);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-1darr-box').data('obj');
            $(this).closest('.vp-numpy-1darr-box').replaceWith(function() {
                return render1dArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('change', '.vp-numpy-1darr-item', function() {
            let id = $(this).closest('.vp-numpy-1darr-box').data('id');
            let arrId = id + '_1darr';
            let idx = $(this).data('idx');
            let value = $(this).val();
            // update state
            let state = pageThis.getState(arrId);
            state[idx] = value;
            let code = `[${state.join(',')}]`;
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: code });
            $(pageThis.wrapSelector('#'+id)).val(code);
        });

        //====================================================================
        // Event for 2dArr
        //====================================================================
        $(selector).on('click', '.vp-numpy-2darr-set', function() {
            let id = $(this).closest('.vp-numpy-2darr-box').data('id');
            let arrId = id + '_2darr';
            let row = $(this).parent().find('.vp-numpy-2darr-set-row').val();
            let col = $(this).parent().find('.vp-numpy-2darr-set-col').val();
            // update state
            let state = Array(parseInt(row));
            for (let i = 0; i < state.length; i++) {
                state[i] = Array(parseInt(col)).fill(0);
            }
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.map(ele => '[' + ele.join(',') + ']').join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-2darr-box').data('obj');
            $(this).closest('.vp-numpy-2darr-box').replaceWith(function() {
                return render2dArr(pageThis, obj, pageThis.getState());
            });
        }); 

        $(selector).on('click', '.vp-numpy-2darr-row-del', function() {
            let id = $(this).closest('.vp-numpy-2darr-box').data('id');
            let arrId = id + '_2darr';
            let idx = $(this).parent().parent().find('.vp-numpy-2darr-row').data('idx');
            // update state
            let state = pageThis.getState(arrId);
            state.splice(idx, 1);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.map(ele => '[' + ele.join(',') + ']').join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-2darr-box').data('obj');
            $(this).closest('.vp-numpy-2darr-box').replaceWith(function() {
                return render2dArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('click', '.vp-numpy-2darr-row-add', function() {
            let id = $(this).closest('.vp-numpy-2darr-box').data('id');
            let arrId = id + '_2darr';
            // update state
            let state = pageThis.getState(arrId);
            if (!state) {
                state = [];
            }
            state.push([0]);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.map(ele => '[' + ele.join(',') + ']').join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-2darr-box').data('obj');
            $(this).closest('.vp-numpy-2darr-box').replaceWith(function() {
                return render2dArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('click', '.vp-numpy-2darr-col-del', function() {
            let id = $(this).closest('.vp-numpy-2darr-box').data('id');
            let arrId = id + '_2darr';
            let rowIdx = $(this).parent().parent().find('.vp-numpy-2darr-item').data('rowidx');
            let idx = $(this).parent().find('.vp-numpy-2darr-item').data('idx');
            // update state
            let state = pageThis.getState(arrId);
            state[rowIdx].splice(idx, 1);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.map(ele => '[' + ele.join(',') + ']').join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-2darr-box').data('obj');
            $(this).closest('.vp-numpy-2darr-box').replaceWith(function() {
                return render2dArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('click', '.vp-numpy-2darr-col-add', function() {
            let id = $(this).closest('.vp-numpy-2darr-box').data('id');
            let arrId = id + '_2darr';
            let rowIdx = $(this).parent().parent().find('.vp-numpy-2darr-item').data('rowidx');
            // update state
            let state = pageThis.getState(arrId);
            if (!state) {
                state = Array(rowIdx + 1);
                for (let i = 0; i < state.length; i++) {
                    state[i] = [];
                }
            }
            state[rowIdx].push(0);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `[${state.map(ele => '[' + ele.join(',') + ']').join(',')}]` });
            // re-render
            let obj = $(this).closest('.vp-numpy-2darr-box').data('obj');
            $(this).closest('.vp-numpy-2darr-box').replaceWith(function() {
                return render2dArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('change', '.vp-numpy-2darr-item', function() {
            let id = $(this).closest('.vp-numpy-2darr-box').data('id');
            let arrId = id + '_2darr';
            let rowIdx = $(this).data('rowidx');
            let idx = $(this).data('idx');
            let value = $(this).val();
            // update state
            let state = pageThis.getState(arrId);
            state[rowIdx][idx] = value;
            let code = `[${state.map(ele => '[' + ele.join(',') + ']').join(',')}]`;
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: code });
            $(pageThis.wrapSelector('#'+id)).val(code);
        });

        //====================================================================
        // Event for ndArr
        //====================================================================
        $(selector).on('click', '.vp-numpy-ndarr-del', function() {
            let id = $(this).closest('.vp-numpy-ndarr-box').data('id');
            let arrId = id + '_ndarr';
            let idx = $(this).parent().find('.vp-numpy-ndarr-item').data('idx');
            // update state
            let state = pageThis.getState(arrId);
            state.splice(idx, 1);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `${state.join(',')}` });
            // re-render
            let obj = $(this).closest('.vp-numpy-ndarr-box').data('obj');
            $(this).closest('.vp-numpy-ndarr-box').replaceWith(function() {
                return renderNdArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('click', '.vp-numpy-ndarr-add', function() {
            let id = $(this).closest('.vp-numpy-ndarr-box').data('id');
            let arrId = id + '_ndarr';
            let idx = 0;
            // update state
            let state = pageThis.getState(arrId);
            if (!state) {
                state = [ ];
            } else {
                idx = state.length;
            }
            state.push(0);
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: `${state.join(',')}` });
            // re-render
            let obj = $(this).closest('.vp-numpy-ndarr-box').data('obj');
            $(this).closest('.vp-numpy-ndarr-box').replaceWith(function() {
                return renderNdArr(pageThis, obj, pageThis.getState());
            });
        });

        $(selector).on('change', '.vp-numpy-ndarr-item', function() {
            let id = $(this).closest('.vp-numpy-ndarr-box').data('id');
            let arrId = id + '_ndarr';
            let idx = $(this).data('idx');
            let value = $(this).val();
            // update state
            let state = pageThis.getState(arrId);
            state[idx] = value;
            let code = `${state.join(',')}`;
            pageThis.setState({ [arrId]: state });
            pageThis.setState({ [id]: code });
            $(pageThis.wrapSelector('#'+id)).val(code);
        });


        //====================================================================
        // Event for tabBlock
        //====================================================================
    }

    return {
        vp_showInterfaceOnPage: vp_showInterfaceOnPage,
        renderContent: renderContent,
        vp_codeGenerator: vp_codeGenerator,
        vp_generateVarSelect: vp_generateVarSelect,
        vp_getTagValue: vp_getTagValue,
        vp_bindColumnSource: vp_bindColumnSource
    };
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/com_interface.js":
/*!**************************************************!*\
  !*** ./lib/visualpython/js/com/com_interface.js ***!
  \**************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_interface.js
 *    Author          : Black Logic
 *    Note            : Interface for jupyter
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 09. 16
 *    Change Date     :
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! ./com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! ./com_String */ "./lib/visualpython/js/com/com_String.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_util, com_String) {

    var getSelectedCell = function() {
        if (vpConfig.extensionType === 'notebook') {
            return Jupyter.notebook.get_selected_index();
        } else if (vpConfig.extensionType === 'colab') {
            if (colab.global.notebook.focusedCell) {
                return colab.global.notebook.focusedCell.cellId;
            } else {
                return '';
            }
        }
    }

    /**
     * 
     * @param {String} type code / markdown 
     * @param {String} command 
     * @param {boolean} exec true(default) / false
     * @param {int} sigNum 
     */
    var insertCell = function(type, command, exec=true, sigText='') {
        // Add signature
        if (type == 'code') {
            if (sigText !== '') {
                command = com_util.formatString('# Visual Python: {0}\n', sigText) + command;
            } else {
                command = '# Visual Python\n' + command;
            }
        }

        if (vpConfig.extensionType === 'notebook') {
            var selectedIndex = getSelectedCell();
            var targetCell = Jupyter.notebook.insert_cell_below(type, selectedIndex);
    
            targetCell.set_text(command);
            Jupyter.notebook.select_next();
            if (exec) {
                switch (type) {
                    case "markdown":
                        targetCell.render();
                        break;
                    case "code":
                    default:
                        targetCell.execute();
                }
            }
            // move to executed cell
            Jupyter.notebook.scroll_to_cell(Jupyter.notebook.get_selected_index());
        } else if (vpConfig.extensionType === 'colab') {
            // CHROME: use colab api to add cell
            let cell = null;
            // get focused index
            let lastFocusedCellId = '';
            let lastFocusedCellIdx = 0;
            try {
                // get focused cell id
                lastFocusedCellId = colab.global.notebook.focusedCell? colab.global.notebook.focusedCell.getId() : null;
                // get focused cell index
                lastFocusedCellIdx = colab.global.notebook.cells.findIndex(cell => cell.getId() === lastFocusedCellId);
            } catch (err) { 
                vpLog.display(VP_LOG_TYPE.ERROR, err);
            }
            if (exec) {
                switch (type) {
                    case "markdown":
                        // add text
                        // create cell to execute
                        colab.global.notebook.insertCell('text', {after:true, index:lastFocusedCellIdx});
                        setTimeout(() => {
                            // cell = colab.global.notebook.focusedCell;
                            cell = colab.global.notebook.cells[lastFocusedCellIdx + 1];
                            cell.setText(command);
                            // colab text cell's focus out is same as running it
                            cell.setFocused(false);
                        }, 300);
                        break;
                    case "code":
                    default:
                        // add code cell
                        // colab.global.notebook.notebookToolbar.toolbarButtons.get("insert-cell-below").click();
                        // create cell to execute
                        colab.global.notebook.insertCell('code', {after:true, index:lastFocusedCellIdx});
                        setTimeout(() => {
                            // cell = colab.global.notebook.focusedCell;
                            cell = colab.global.notebook.cells[lastFocusedCellIdx + 1];
                            cell.setText(command);
                            cell.runButton.click();
                        }, 300);
                }
            }
            // move to executed cell
            // CHROME: TODO:
        } else if (vpConfig.extensionType === 'lab') {
            var { NotebookActions } = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
            var notebookPanel = vpKernel.getLabNotebookPanel();
            if (notebookPanel && notebookPanel.sessionContext){
                var sessionContext = notebookPanel.sessionContext;	
                let sessionType = sessionContext.type;
                if (sessionType === 'notebook') {
                    var notebook = notebookPanel.content;
                    var notebookModel = notebook.model;
            
                    var cellModel = notebookModel.contentFactory.createCell(type, {});				
                    cellModel.value.text = command;
            
                    const newCellIndex = notebook.activeCellIndex + 1;
                    // 셀 추가
                    notebookModel.cells.insert(newCellIndex, cellModel);				
                    notebook.activeCellIndex = newCellIndex;
            
                    var cell = notebook.activeCell;
                    if (exec == true) {
                        try{
                            NotebookActions.run(notebook, sessionContext);
                        } catch(err){
                            vpLog.display(VP_LOG_TYPE.ERROR, err);
                        }
                    }
                    // move to executed cell
                    let activeCell = notebookPanel.content.activeCell;
                    let activeCellTop = $(activeCell.node).position().top;
                    // scroll to current cell top
                    $(notebookPanel.layout.widgets[2].node).animate({scrollTop: activeCellTop},"fast");
                } else if (sessionType === 'console') {
                    var labConsole = notebookPanel.content;
                    var widget = labConsole.widgets[0];

                    // execute or not
                    if (exec == true) {
                        // console allow only code cell
                        var cellModel = widget.createCodeCell();
                        cellModel.model.value.text = command;
                        widget.addCell(cellModel);
                        widget._execute(cellModel);
                    } else {
                        widget.promptCell.model.value.text = command;
                    }
                    widget.promptCell.inputArea.editor.focus();
                }
            } else {
                // No session found
                com_util.renderAlertModal('Visual Python only supports Notebook and Console type.  Please use appropriate type of file to use it.');
            }
        }

        com_util.renderSuccessMessage('Your code is successfully generated.');
    }

    /**
     * Insert multiple cells
     * @param {String} type 
     * @param {Array} commands 
     * @param {boolean} exec 
     * @param {int} sigNum 
     */
    var insertCells = function(type, commands, exec=true, sigText='') {

        if (vpConfig.extensionType === 'lab') {
            var { NotebookActions } = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
            var notebookPanel = vpKernel.getLabNotebookPanel();
        }
        
        commands && commands.forEach((command, idx) => {
            // Add signature
            if (type == 'code') {
                if (sigText !== '') {
                    command = com_util.formatString('# Visual Python: {0}\n', sigText) + command;
                } else {
                    command = com_util.formatString('# Visual Python') + command;
                }
            }

            if (vpConfig.extensionType === 'notebook') {
                var selectedIndex = getSelectedCell();
                var targetCell = Jupyter.notebook.insert_cell_below(type, selectedIndex);

                targetCell.set_text(command);
                Jupyter.notebook.select_next();
                if (exec) {
                    switch (type) {
                        case "markdown":
                            targetCell.render();
                            break;
                        case "code":
                        default:
                            targetCell.execute();
                    }
                }
            } else if (vpConfig.extensionType === 'colab') {
                // CHROME: use colab api to add cell
                let cell = null;
                // get focused index
                let lastFocusedCellId = '';
                let lastFocusedCellIdx = 0;
                try {
                    // get focused cell id
                    lastFocusedCellId = colab.global.notebook.focusedCell? colab.global.notebook.focusedCell.getId() : colab.global.notebook.lastFocusedCellId;
                    // get focused cell index
                    lastFocusedCellIdx = colab.global.notebook.cells.findIndex(cell => cell.getId() === lastFocusedCellId);
                } catch (err) { 
                    vpLog.display(VP_LOG_TYPE.ERROR, err);
                }
                if (exec) {
                    switch (type) {
                        case "markdown":
                            // add text
                            // create cell to execute
                            colab.global.notebook.insertCell('text', {after:true, index:lastFocusedCellIdx});
                            setTimeout(() => {
                                // cell = colab.global.notebook.focusedCell;
                                cell = colab.global.notebook.cells[lastFocusedCellIdx + 1];
                                cell.setText(command);
                                // colab text cell's focus out is same as running it
                                cell.setFocused(false);
                            }, 300);
                            break;
                        case "code":
                        default:
                            colab.global.notebook.insertCell('code', {after:true, index:lastFocusedCellIdx});
                            setTimeout(() => {
                                // cell = colab.global.notebook.focusedCell;
                                cell = colab.global.notebook.cells[lastFocusedCellIdx + 1];
                                cell.setText(command);
                                cell.runButton.click();
                            }, 300);
                    }
                }
            } else if (vpConfig.extensionType === 'lab') {
                if (notebookPanel && notebookPanel.sessionContext){ 
                    var sessionContext = notebookPanel.sessionContext;	
                    let sessionType = sessionContext.type;
                    if (sessionType === 'notebook') {
                        var notebook = notebookPanel.content;
                        var notebookModel = notebook.model;
                
                        var options = {	};
                        var cellModel = notebookModel.contentFactory.createCell(type, options);				
                        cellModel.value.text = command;
                
                        const newCellIndex = notebook.activeCellIndex + 1;
                        // 셀 추가
                        notebookModel.cells.insert(newCellIndex, cellModel);				
                        notebook.activeCellIndex = newCellIndex;
                
                        var cell = notebook.activeCell;
                        if (exec == true) {
                            try{
                                NotebookActions.run(notebook, sessionContext);
                            } catch(err){
                                vpLog.display(VP_LOG_TYPE.ERROR, err);
                            }
                        }
                    } else if (sessionType === 'console') {
                        var console = notebookPanel.content;
                        var cellModel = console.contentFactory.createCell(type, {});
                        cellModel.value.text = command;

                    } 
                } else {
                    // No session found
                    com_util.renderAlertModal('Visual Python only supports Notebook and Console type. Please use appropriate type of file to use it.');
                }
            }
        });
        
        // move to executed cell
        if (vpConfig.extensionType === 'notebook') {
            Jupyter.notebook.scroll_to_cell(Jupyter.notebook.get_selected_index());
        } else if (vpConfig.extensionType === 'colab') {
            // CHROME: TODO:

        } else if (vpConfig.extensionType === 'lab') {
            // LAB: TODO:
            let activeCell = notebookPanel.content.activeCell;
            let activeCellTop = $(activeCell.node).position().top;
            // scroll to current cell top
            $(notebookPanel.layout.widgets[2].node).animate({scrollTop: activeCellTop},"fast");
        }

        com_util.renderSuccessMessage('Your code is successfully generated.');
    }
    
    var enableOtherShortcut = function() {
        vpLog.display(VP_LOG_TYPE.DEVELOP, 'enable short cut');
        if (vpConfig.extensionType == 'notebook') {
            Jupyter.notebook.keyboard_manager.enable();
        } else if (vpConfig.extensionType == 'colab') {
            ;
        }
    }

    var disableOtherShortcut = function() {
        vpLog.display(VP_LOG_TYPE.DEVELOP, 'disable short cut');
        if (vpConfig.extensionType == 'notebook') {
            Jupyter.notebook.keyboard_manager.disable();
        } else if (vpConfig.extensionType == 'colab') {
            ;
        }
    }
    
    return {
        insertCell: insertCell,
        insertCells: insertCells,
        enableOtherShortcut: enableOtherShortcut,
        disableOtherShortcut: disableOtherShortcut,

    };
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/com_makeDom.js":
/*!************************************************!*\
  !*** ./lib/visualpython/js/com/com_makeDom.js ***!
  \************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_makeDom.js
 *    Author          : Black Logic
 *    Note            : Make DOM data
 *    License         : GPLv3 (GNU General Public License v3.0)
 *    Date            : 2021. 08. 14
 *    Change Date     :
 */

//============================================================================
// Make DOM data
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function (com_Const, com_util) {
    'use strict'

    //========================================================================
    // External call function
    //========================================================================
    /**
     * Parse attributes
     * @param {object} attribute
     */
    var parseAttributes = function( attribute ) {
        var attributeStr = ``;
        var attributes = Object.entries(attribute);
        var text = ``;

        for ( var i = 0; i < attributes.length; i++ ) {
            // validation
            // attribute(key): style, class, id, text, value, type, placeholder, data_
            if ( attributes[i][0] !== 'style' || attributes[i][0] !== 'class' ||
                 attributes[i][0] !== 'id'    || attributes[i][0] !== 'text'  ||
                 attributes[i][0] !== 'type'  || attributes[i][0] !== 'placeholder' ||
                 attributes[i][0] !== 'value' || attributes[i][0].indexOf('data') === -1) {
            } else {
                continue;
            }

            // text
            if (attributes[i][0] === 'text') {
                text = attributes[i][1];
                continue;
            }

            // style
            if ( attributes[i][0] === 'style') {
                
                /** color: black 의 경우 처럼 
                 *  style을 지정하고 뒤에 ;을 붙이지 않는 경우,
                 *  자동으로 ;을 붙여주는 로직 */
                var cursor = 0;
                /**
                 * style 텍스트를 cursor가 0부터 styleText.length까지 반복문을 돔
                 * attributes[i][1] 이하 styleText로 설명
                 */
                while (cursor++ < attributes[i][1].length) {
                    /** styleText의 한 문자가 ' '(띄어쓰기)를 만날경우  */
                    if (attributes[i][1].indexOf(' ') !== -1 || attributes[i][1].indexOf(' ') !== 0
                        || attributes[i][1].indexOf(' ') !==  attributes[i][1].length - 1) {

                        /** styleText의 각 문자들을 반복문 돌다가 한 문자가 ':' 를 만날 경우 
                         *  예를 들면 `color: black` 에서 :를 만날 경우,
                         *  : black 다음에 `;`표시가 없으면 ';'을 넣어준다
                         *  `;' 표시가 있으면 넘어간다
                         */
                        if ( attributes[i][1].indexOf(':', cursor) !== -1 ) {

                            var leftCursor = attributes[i][1].indexOf(':', cursor);
                        
                            while ( leftCursor-- ) {
                            
                                if (attributes[i][1][leftCursor].indexOf(' ') !== -1 ) {
                                    if (attributes[i][1][leftCursor - 1].indexOf(' ') !== -1) {
                                        continue;
                                    }
                                    
                                    if( attributes[i][1][leftCursor - 2].indexOf(';') === -1) {
                                        attributes[i][1] = attributes[i][1].slice(0, leftCursor)
                                            .concat(';')
                                            .concat(attributes[i][1].slice(leftCursor+1, attributes[i][1].length));
                                    }
                                    break;
                                }
                            }
                            cursor = (attributes[i][1].indexOf(':', cursor) );
                        }
                        cursor ++;
                    }
                }

                attributeStr += ' ' + attributes[i][0] + '=';
                attributeStr += `'${attributes[i][1]}'`;
                continue;
            }

            /** attributes가 data_일 경우 
             *  'data_' 는 'data-' 로 파싱된다
             */
            if (attributes[i][0].indexOf('_') !== -1) {
                var cursor = 0;
                while (attributes[i][0][cursor] !== undefined ) {
                    if(attributes[i][0][cursor] === '_') {
                        attributes[i][0] = attributes[i][0].slice(0,cursor) + '-' + attributes[i][0].slice(cursor + 1,attributes[i][0].length);
                    }
                    cursor++;
                }
                // attributes[i][0] =  attributes[i][0].replaceAll('_', '-');
            }

            attributeStr += ' ' + attributes[i][0] + '=';
            attributeStr += `'${attributes[i][1]}'`;
        }
        return {
            attributeStr, text
        }
    }
    
    /**
     * 이하 attribute를 파라미터로 받는 함수 사용 예제
     *  var input = renderInput({
     *                  class: `vp vp-label`
     *                  , id: `vp_label`
     *                  , style: `width: 90%;
     *                      min-width: 50px; max-width: 100px;
     *                      margin: 8px; position: relative;  display: block; font-size: 12px;
     *                      overflow: hidden; border-width: 0; outline: none; border-radius: 2px; 
     *                      box-shadow: 0 1px 4px rgba(0, 0, 0, .6);
     *                      color: black; transition: background-color .3s`;
     *                  , text:"Lavel"
     *                  , placeholder:"입력 바랍니다"
     *                  , type: "text"
     *                  , data_input_id:"3"
     *                  , data_capations_id: "lang"
     *  });
     */

    /**
     * Rendering input
     * @param {object} attribute
     */
    var renderInput = function(attribute) {
        var { attributeStr } = parseAttributes(attribute);
        return $(`<input ${attributeStr}>
                </input>`);
    }

    /**
     * Renderig button
     * @param {object} attribute
     */
    var renderButton = function(attribute) {
        var { attributeStr, text } = parseAttributes(attribute);
        return $(`<button ${attributeStr}>
                    ${text}
                </button>`);
    }

    /**
     * Renderig select box
     * @param {object} attribute
     */
    var renderSelectBox = function(attribute) {       
        var { attributeStr } = parseAttributes(attribute);
        return $(`<select ${attributeStr}>
                </select>`);
    }

    /**
     * Rendering option
     * @param {Document} selectBox
     * @param {Object} attribute
     * @param {Array} optionDataList
     */
    var renderOption = function(selectBox, attribute, optionDataList, optionTextList = []) {
        for( var a = 0; a  < optionDataList.length; a++ ) {
            var { attributeStr } = parseAttributes(attribute);

            var value = optionDataList[a];
            var text = optionTextList.length > a ? optionTextList[a] : value;
            var option = $(`<option value='${value}' 
                                    ${attributeStr} >
                                ${text}
                            </option>`);
            $(selectBox).append(option);
        }

        // select option 클릭시 클릭 된 option 태그는 selected는 true가 되고 나머진 false
        $(selectBox).change(function()  {
            var index = $(':selected', this).index();
            var value = $(':selected', this).val();
            for(var i = 0; i < $(selectBox).children().length; i++ ) {
                ((j) => {
                    $(this).find(`option:eq(${j})`).attr('selected', false);
                })(i);
            }
            $(this).find(`option:eq(${index})`).attr('selected', true);
            $(this).val(value);
        });
        return $(selectBox);
    }

    /**
     * Rendering span
     * @param {object} attribute
     */
    var renderSpan = function(attribute) {
        var { attributeStr, text } = parseAttributes(attribute);
        return $(`<span ${attributeStr}>
                    ${text}
                </span>`);
    }

    /**
     * Rendering label
     * @param {object} attribute
     */
    var renderLabel = function(attribute) {
        var { attributeStr, text } = parseAttributes(attribute);
        return $(`<label ${attributeStr}>
                    ${text}
                </label>`);
    }

    /**
     * Rendering div
     * @param {object} attribute
     */
    var renderDiv = function(attribute) {
        var { attributeStr, text } = parseAttributes(attribute);
        return $(`<div ${attributeStr}>
                    ${text}
                </div>`);
    }

    /**
     * Rendering Ui
     * @param {object} attribute
     */
    var renderUi = function(attribute) {
        var { attributeStr, text } = parseAttributes(attribute);
        return $(`<ul ${attributeStr}>
                    ${text}
                </div>`);
    }

    /**
     * Rendering Li
     * @param {object} attribute
     */
    var renderLi = function(attribute) {
        var { attributeStr, text } = parseAttributes(attribute);
        return $(`<li ${attributeStr}>
                    ${text}
                </li>`);
    }

    /**
     * Rendering custom confirm modal
     * @param {Object} option  
     *      title : CustomConfirmModal창의 타이틀 제목을 정한다. 정하지 않을시 default는 `선택 하시겠습니까?`
     *      confirm_text : 예스 버튼의 text를 정한다. 정하지 않을시 default는 '예'
     *      cancel_text : 노 버튼의 text를 정한다. 정하지 않을시 default는 '아니오'
     * @param {function} confirmFunction  confirm 예스 버튼을 누르면 실행할 함수. 
     *                                      파라미터로 넣지 않는다면 예스 버튼을 눌러도 아무것도 실행하지 않는다.
     * @param {function} cancelFunction  confirm 노 버튼을 누르면 실행할 함수
     *                                      파라미터로 넣지 않는다면 노 버튼을 눌러도 아무것도 실행하지 않는다.
     */
    var renderCustomConfirmModal = function(option, confirmFunction, cancelFunction) {
        // load css
        com_util.loadCss( com_Const.STYLE_PATH + 'common/customConfirm.css' );
        var title = `Would you like to choose?`;
        var confirm =  `Yes`;
        var cancel = `No`;

        if(option) {
            var optionArray = Object.entries(option);
            for ( var i = 0; i < optionArray.length; i++ ) {
                if ( optionArray[i][0] === 'title' ) {
                    title = optionArray[i][1];
                
                    continue;
                }

                if ( optionArray[i][0] === 'confirm_text' ) {
                    confirm = optionArray[i][1];
                    continue;
                }

                if ( optionArray[i][0] === 'cancel_text' ) {
                    cancel = optionArray[i][1];
                    continue;
                }
            }
        }

        // load customConfirm dom tag
        var customConfirm = $(`<div class='vp-customConfirm'>
                                    <div class='vp-customConfirm-container center-1rem-gray' >
                                        <div class='vp-customConfirm-inner vp-style-flex-column-evenly'>
                                            <div class='vp-customConfirm-title 
                                                        vp-style-font-weight-700
                                                        vp-style-font-size-16px 
                                                        vp-style-text-center'>
                                
                                                <span class='vp-multilang' 
                                                    data-caption-id='doYouWantToChoose'>
                                                    ${title}
                                                </span>
                                            </div>

                                            <div class='vp-customConfirm-button-container
                                                        vp-style-flex-row-evenly'>
                                                <input class='vp-customConfirm-yes' 
                                                        id='vp_modal-input-button' 
                                                        type='submit' 
                                                        value='${confirm}' />
                                                <input class='vp-customConfirm-no'
                                                        id='vp_modal-input-button' 
                                                        type='submit' 
                                                        value='${cancel}' />
                                            </div>
                                        </div>
                                    </div>
                                </div>`);

        $('body').append(customConfirm);

        $(customConfirm).find('.vp-customConfirm-yes').click(function() {
            $(customConfirm).empty();
            $(customConfirm).remove();
            
            if ( confirmFunction ) {
                confirmFunction();
            }

            $(customConfirm).find('.vp-customConfirm-yes').off();
            $(customConfirm).find('.vp-customConfirm-no').off();
        });
        
        $(customConfirm).find('.vp-customConfirm-no').click(function() {
            $(customConfirm).empty();
            $(customConfirm).remove();
            
            if ( cancelFunction ) {
                cancelFunction();
            }
        
            $(customConfirm).find('.vp-customConfirm-yes').off();
            $(customConfirm).find('.vp-customConfirm-no').off();
        });   
    }

    return {
        renderInput: renderInput,
        renderSelectBox: renderSelectBox,
        renderButton: renderButton,
        renderOption: renderOption,
        renderSpan: renderSpan,
        renderLabel: renderLabel,
        renderDiv: renderDiv,
        renderUi: renderUi,
        renderLi: renderLi,
        renderCustomConfirmModal: renderCustomConfirmModal
    }

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)); /* function, define */

/* End of file */


/***/ }),

/***/ "./lib/visualpython/js/com/com_util.js":
/*!*********************************************!*\
  !*** ./lib/visualpython/js/com/com_util.js ***!
  \*********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : com_util.js
 *    Author          : Black Logic
 *    Note            : Common utility function
 *    License         : GPLv3 (GNU General Public License v3.0)
 *    Date            : 2021. 08. 14
 *    Change Date     :
 */

//============================================================================
// Common utility function
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function (com_String) {
    'use strict'

    //========================================================================
    // Define variable
    //========================================================================
    let isAPIListRunCode = true;

    //========================================================================
    // Internal call function
    //========================================================================
    /**
     * check duplicate variable name
     * @param {string} varName 
     */
    var _checkVariableNameDuplicate = function(varName) {
        // TODO: varName duplicate check
        return true;
    }

    //========================================================================
    // External call function
    //========================================================================
    /**
     * Generate uuid
     * @returns {String} uuid
     */
    var getUUID = function() {
        return 'u' + ([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g, c =>
            (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
        );
    }

    /**
     * append css on global
     * @param {String} url style url
     */
    var loadCss = function(url) {
        var link = document.createElement('link');
        link.type = 'text/css';
        link.rel = 'stylesheet';
        link.href = __webpack_require__("./lib/visualpython/js/com sync recursive").toUrl(url);
        document.getElementsByTagName('head')[0].appendChild(link);
    }

    /**
     * VisualPython container selector (jquery selector)
     * @returns vp top container selector
     */
    var getVPContainer = function() {
        return '#vp_wrapper';
    }

    /**
     * wrap selector
     * @param {String} selector selector
     * @returns wraped selecotr 
     */
    var wrapSelector = function(selector = '') {
        var sbSelector = new com_String();
        var cnt = arguments.length;
        // no more selector
        if (cnt < 2) {
            sbSelector.appendFormat('{0} {1}', getVPContainer(), selector);
        } else {
            sbSelector.appendFormat('{0}', getVPContainer());
            for (var idx = 0; idx < cnt; idx++) {
                sbSelector.appendFormat(' {0}', arguments[idx]);
            }
        }
        return sbSelector.toString();
    }

    /**
     * add variable and trigger event
     * @param {string} varName variable name
     * @param {string} varType variable type
     * @returns if return 0 when success, -1 when variable name duplicate
     */
    var addVariable = function(varName, varType) {
        // varName check duplicate
        if (_checkVariableNameDuplicate) {
            return -1;
        } else {
            events.trigger('add-variable.vp-wrapper', {'varName': varName, 'varType': varType});
            return 0;
        }
    }

    /**
     * format simple string
     */
    var formatString = function() {
        var cnt = arguments.length;
        if (cnt < 2) 
            return arguments[0];

        var str = arguments[0];
        for (var idx = 1; idx < cnt; idx++)
            str = str.replace('{' + (idx - 1) + '}', arguments[idx]);
        
        return str;
    }

    /**
     * Convert to string format if not numeric
     * @param {*} code 
     * @returns 
     */
    var convertToStr = function(code, isText=null, useRegex=false) {
        let prefix = '';
        if (useRegex) {
            prefix = 'r';
        }
        if (isText != null) {
            if (isText) {
                code = `${prefix}'${code}'`;
            }
        } else {
            if (!$.isNumeric(code)) {
                if (code.includes("'")) {
                    code = `${prefix}"${code}"`;
                } else {
                    code = `${prefix}'${code}'`;
                }
            }
        }
        return code;
    }

    /**
     * Remove head's script(css, js)
     * @param {string} scriptName 
     */
    var removeHeadScript = function(scriptName) {
        for (let i = 0; i < document.querySelector('head').children.length; i++){
            if (document.querySelector('head') && document.querySelector('head').children[i].outerHTML.includes(scriptName)) { 
                document.querySelector('head').removeChild(document.querySelector('head').children[i]);
            }
        }   
    }

    /**
     * Modal
     * @param {Object} config { title, message, buttons(list), final(function), defaultIdx(int) } 
     */
    var renderModal = function(config={title:'', message:'', buttons:['Ok']}) {
        Promise.resolve(/*! AMD require */).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__(/*! vp_base/js/com/component/Modal */ "./lib/visualpython/js/com/component/Modal.js")]; (function(Modal) {
            let modal = new Modal(config);
            modal.open();
        }).apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__);})['catch'](__webpack_require__.oe);
    }

    /** 
     * InfoModal
     * @param {string} titleStr 
     */
     var renderInfoModal = function(titleStr) {
        Promise.resolve(/*! AMD require */).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__(/*! vp_base/js/com/component/InfoModal */ "./lib/visualpython/js/com/component/InfoModal.js")]; (function(InfoModal) {
            new InfoModal(titleStr);
        }).apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__);})['catch'](__webpack_require__.oe);
    }

    /** 
     * AlertModal
     * @param {string} titleStr 
     */
    var renderAlertModal = function(titleStr, detail='') {
        Promise.resolve(/*! AMD require */).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__(/*! vp_base/js/com/component/AlertModal */ "./lib/visualpython/js/com/component/AlertModal.js")]; (function(AlertModal) {
            new AlertModal(titleStr, detail=detail);
        }).apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__);})['catch'](__webpack_require__.oe);
    }

    /**
     * Show success message on the top right of the screen
     * @param {string} titleStr 
     */
    var renderSuccessMessage = function(titleStr) {
        Promise.resolve(/*! AMD require */).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__(/*! vp_base/js/com/component/SuccessMessage */ "./lib/visualpython/js/com/component/SuccessMessage.js")]; (function(SuccessMessage) {
            new SuccessMessage(titleStr);
        }).apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__);})['catch'](__webpack_require__.oe);
    }

    /**
     * Template for error box
     * @param {*} titleStr 
     * @param {*} contentStr 
     * @returns 
     */
    var templateForErrorBox = function(titleStr, contentStr='', detailStr='') {
        let errorContent = new com_String();
        errorContent.appendFormatLine('<div class="{0}" {1}>', 'vp-data-error-box', (detailStr && detailStr.length > 0)?('title="'+detailStr+"'"):'');
        errorContent.appendLine('<i class="fa fa-exclamation-triangle"></i>');
        errorContent.appendFormatLine('<label class="{0}">{1}</label>',
            'vp-data-error-box-title', titleStr);
        if (contentStr && contentStr != '') {
            errorContent.appendFormatLine('<pre>{0}</pre>', contentStr.split('\\n').join('<br/>'));
        }
        errorContent.appendLine('</div>');
        return errorContent.toString();
    }

    /**
     * setIsAPIListRunCode
     */
    var setIsAPIListRunCode = function(isAPIListRunCode_param) {
        isAPIListRunCode = isAPIListRunCode_param;
    }

    /**
     * getIsAPIListRunCode
     */
    var getIsAPIListRunCode = function() {
        return isAPIListRunCode;
    }

     /**
     * Convert string(include html text) to safe string to display
     * @param {String} text 
     * @returns 
     */
    var safeString = function(text) {
        return String(text).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
    }

    var optionToLabel = function(label) {
        label = label.replaceAll('_', ' ');
        label = label.charAt(0).toUpperCase() + label.slice(1);
        return label;
    }

    //============================================================================
    // Cross-browser RegEx Split
    //============================================================================

    // This code has been MODIFIED from the code licensed below to not replace the
    // default browser split.  The license is reproduced here.

    // see http://blog.stevenlevithan.com/archives/cross-browser-split for more info:
    /*!
     * Cross-Browser Split 1.1.1
     * Copyright 2007-2012 Steven Levithan <stevenlevithan.com>
     * Available under the MIT License
     * ECMAScript compliant, uniform cross-browser split method
     */

    /**
     * Splits a string into an array of strings using a regex or string
     * separator. Matches of the separator are not included in the result array.
     * However, if `separator` is a regex that contains capturing groups,
     * backreferences are spliced into the result each time `separator` is
     * matched. Fixes browser bugs compared to the native
     * `String.prototype.split` and can be used reliably cross-browser.
     * @param {String} str String to split.
     * @param {RegExp} separator Regex to use for separating
     *     the string.
     * @param {Number} [limit] Maximum number of items to include in the result
     *     array.
     * @returns {Array} Array of substrings.
     * @example
     *
     * // Basic use
     * regex_split('a b c d', ' ');
     * // -> ['a', 'b', 'c', 'd']
     *
     * // With limit
     * regex_split('a b c d', ' ', 2);
     * // -> ['a', 'b']
     *
     * // Backreferences in result array
     * regex_split('..word1 word2..', /([a-z]+)(\d+)/i);
     * // -> ['..', 'word', '1', ' ', 'word', '2', '..']
     */
     var regex_split = function (str, separator, limit) {
        var output = [],
            flags = (separator.ignoreCase ? "i" : "") +
                    (separator.multiline  ? "m" : "") +
                    (separator.extended   ? "x" : "") + // Proposed for ES6
                    (separator.sticky     ? "y" : ""), // Firefox 3+
            lastLastIndex = 0,
            separator2, match, lastIndex, lastLength;
        // Make `global` and avoid `lastIndex` issues by working with a copy
        separator = new RegExp(separator.source, flags + "g");

        var compliantExecNpcg = typeof(/()??/.exec("")[1]) === "undefined";
        if (!compliantExecNpcg) {
            // Doesn't need flags gy, but they don't hurt
            separator2 = new RegExp("^" + separator.source + "$(?!\\s)", flags);
        }
        /* Values for `limit`, per the spec:
         * If undefined: 4294967295 // Math.pow(2, 32) - 1
         * If 0, Infinity, or NaN: 0
         * If positive number: limit = Math.floor(limit); if (limit > 4294967295) limit -= 4294967296;
         * If negative number: 4294967296 - Math.floor(Math.abs(limit))
         * If other: Type-convert, then use the above rules
         */
        limit = typeof(limit) === "undefined" ?
            -1 >>> 0 : // Math.pow(2, 32) - 1
            limit >>> 0; // ToUint32(limit)
        for (match = separator.exec(str); match; match = separator.exec(str)) {
            // `separator.lastIndex` is not reliable cross-browser
            lastIndex = match.index + match[0].length;
            if (lastIndex > lastLastIndex) {
                output.push(str.slice(lastLastIndex, match.index));
                // Fix browsers whose `exec` methods don't consistently return `undefined` for
                // nonparticipating capturing groups
                if (!compliantExecNpcg && match.length > 1) {
                    match[0].replace(separator2, function () {
                        for (var i = 1; i < arguments.length - 2; i++) {
                            if (typeof(arguments[i]) === "undefined") {
                                match[i] = undefined;
                            }
                        }
                    });
                }
                if (match.length > 1 && match.index < str.length) {
                    Array.prototype.push.apply(output, match.slice(1));
                }
                lastLength = match[0].length;
                lastLastIndex = lastIndex;
                if (output.length >= limit) {
                    break;
                }
            }
            if (separator.lastIndex === match.index) {
                separator.lastIndex++; // Avoid an infinite loop
            }
        }
        if (lastLastIndex === str.length) {
            if (lastLength || !separator.test("")) {
                output.push("");
            }
        } else {
            output.push(str.slice(lastLastIndex));
        }
        return output.length > limit ? output.slice(0, limit) : output;
    };

    //============================================================================
    // End contributed Cross-browser RegEx Split
    //============================================================================

    return {
        getUUID: getUUID,
        loadCss: loadCss,
        getVPContainer: getVPContainer,
        wrapSelector: wrapSelector,
        addVariable: addVariable,
        formatString: formatString,
        convertToStr: convertToStr,
        optionToLabel: optionToLabel,

        removeHeadScript: removeHeadScript,
        renderModal: renderModal,
        renderInfoModal: renderInfoModal,
        renderAlertModal: renderAlertModal,
        renderSuccessMessage: renderSuccessMessage,

        templateForErrorBox: templateForErrorBox,

        setIsAPIListRunCode: setIsAPIListRunCode,
        getIsAPIListRunCode: getIsAPIListRunCode,
        safeString: safeString,

        regex_split: regex_split
    }

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)); /* function, define */

/* End of file */


/***/ }),

/***/ "./lib/visualpython/js/com/component/AlertModal.js":
/*!*********************************************************!*\
  !*** ./lib/visualpython/js/com/component/AlertModal.js ***!
  \*********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : AlertModal.js
 *    Author          : Black Logic
 *    Note            : AlertModal
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] AlertModal
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/component/alertModal.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/component/alertModal.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/component/alertModal.css */ "./lib/visualpython/css/component/alertModal.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(msgHtml, msgCss, com_Const, Component) {

    /**
     * AlertModal
     */
    class AlertModal extends Component {
        constructor(title, detail='') {
            super($('body'), { title: title, detail: detail });
        }

        _bindEvent() {
            let that = this;
            // click ok button
            $(this.wrapSelector('.vp-alertModal-yes')).click( function() {
                that.remove();
            });   
        }

        template() {
            return msgHtml.replaceAll('${vp_base}', com_Const.BASE_PATH);
        }

        render() {
            super.render();

            // set title
            $(this.wrapSelector('.vp-alertModal-titleStr')).text(this.state.title);
            // set detail as tooltip
            if (this.state.detail) {
                $(this.wrapSelector('.vp-alertModal-titleStr')).attr({ title: this.state.detail });
            }
        }

        remove() {
            $(this.wrapSelector()).remove();
        }

    }

    return AlertModal;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/Component.js":
/*!********************************************************!*\
  !*** ./lib/visualpython/js/com/component/Component.js ***!
  \********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : Component.js
 *    Author          : Black Logic
 *    Note            : Base Components for rendering objects
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] Component
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! ../com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! ../com_String */ "./lib/visualpython/js/com/com_String.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_util, com_String) {
    'use strict';

    //========================================================================
    // Declare class
    //========================================================================
    /**
     * Component
     */
    class Component {
        constructor($target, state, prop={}) {
            // get uuid
            this._uuid = com_util.getUUID();
            // target, pageDom query objects
            this.$target = $target;
            this.$pageDom = '';
            // save state
            this.state = state;
            // save propagation from parent
            this.prop = prop;

            this._init();
            this.load();
            this.render();
        }

        wrapSelector(selector='') {
            var sbSelector = new com_String();
            var cnt = arguments.length;
            if (cnt < 2) {
                // if there's no more arguments
                sbSelector.appendFormat(".{0} {1}", this.uuid, selector);
            } else {
                // if there's more arguments
                sbSelector.appendFormat(".{0}", this.uuid);
                for (var idx = 0; idx < cnt; idx++) {
                    sbSelector.appendFormat(" {0}", arguments[idx]);
                }
            }
            return sbSelector.toString();
        }

        _init() {
            /** Implementation needed */
        }

        _unbindEvent() {
            /** Implementation needed */
        }

        _bindEvent() {
            /** Implementation needed */
        }

        /**
         * Load data
         */
        load() {
            /** Implementation needed */
        }

        /**
         * Generate template using states and return
         * @returns template DOM
         */
        template() { 
            /** Implementation needed */
            return '';
        }

        /**
         * Render component under $target
         * @param {*} inplace overwrite under $target
         */
        render(inplace=false) {
            this.$pageDom = $(this.template());
            this.$pageDom.addClass(this.uuid);

            let $page = this.$target.find('.' + this.uuid);
            if ($page.length > 0) {
                // if exists, replace it
                $page.replaceWith(this.$pageDom);
            } else {
                // if not exists...
                if (inplace) {
                    // replace under $target
                    this.$target.html(this.$pageDom);
                } else {
                    // append under $target
                    this.$target.append(this.$pageDom);
                }
            }

            this._bindEvent();
        }

        equals(component) {
            if (!component) {
                return false;
            }
            return component.uuid === this.uuid;
        }

        get uuid() {
            return this._uuid;
        }

        getTag() {
            return $(this.wrapSelector());
        }

        setState(stateObj) {
            this.state = {
                ...this.state,
                ...stateObj
            }
        }

        getState(stateKey=undefined) {
            if (stateKey == undefined) {
                return this.state;
            }
            return this.state[stateKey];
        }
    }

    return Component;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/* End of file */

/***/ }),

/***/ "./lib/visualpython/js/com/component/DataSelector.js":
/*!***********************************************************!*\
  !*** ./lib/visualpython/js/com/component/DataSelector.js ***!
  \***********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : DataSelector.js
 *    Author          : Black Logic
 *    Note            : Data Selector
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2022. 03. 23
 *    Change Date     :
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/component/dataSelector.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/component/dataSelector.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/component/dataSelector.css */ "./lib/visualpython/css/component/dataSelector.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! vp_base/js/com/component/MultiSelector */ "./lib/visualpython/js/com/component/MultiSelector.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(dataHTML, dataCss, com_Const, com_String, com_util, Component, MultiSelector) {
    //========================================================================
    // [CLASS] DataSelector
    // Usage:
    // let dataSelector = new DataSelector({
    //     type: 'data',
    //     pageThis: this,
    //     id: 'targetId',
    //     classes: '',
    //     placeholder: '',
    //     select: function(value, dtype) {
    //         ;
    //     }
    //     finish: function(value, dtype) {
    //         ;
    //     }
    // });
    // $('#sample').replaceWith(dataSelector.toTagString());
    //========================================================================
    class DataSelector extends Component {

        /**
         * Constructor
         * @param {Object} prop  { type, ... }
         */
        constructor(prop) {
            super($('body'), {}, prop);
        }

        _init() {
            super._init();

            this.prop = {
                type: 'data',   // selector type : data / column
                pageThis: null, // target's page object
                id: '',         // target id
                value: null,    // pre-defined value
                finish: null,   // callback after selection
                select: null,   // callback after selection from suggestInput
                allowDataType: ['DataFrame', 'Series', 'ndarray', 'list', 'dict'], // default allow data types
                // additional options
                classes: '',
                placeholder: 'Select variable',
                required: false,
                ...this.prop
            }

            this.state = {
                filterType: 'All',
                data: '',
                dataType: '',
                returnDataType: '',
                dataInfo: '',
                slicingStart1: '',
                slicingEnd1: '',
                slicingStart2: '',
                slicingEnd2: '',
                ndRowType: 'slicing',
                ndColType: 'slicing',
                useIndex: false,
                indexing: [],
                rowIndexing: [],
                colIndexing: [],
                dictKey: '',
                ...this.state
            }

            this._target = null;
            if (this.prop.pageThis) {
                this._target = this.prop.pageThis.wrapSelector('#' + this.prop.id);
            }

            this._columnSelector = null;
            this._ndRowSelector = null;
            this._ndColSelector = null;

            this._varList = [];

            this.loadVariables(); 
            this.bindEvent();
        }

        /**
         * Bind event for initializing DataSelector
         */
        bindEvent() {
            let that = this;

            // bind Event on focus/click box
            $(document).on(com_util.formatString("focus.init-{0}", that.uuid), com_util.formatString(".vp-ds-box-{0}.{1}", that.uuid, 'vp-ds-uninit'), function () {
                // unbind initial event
                $(document).unbind(com_util.formatString(".init-{0}", that.uuid));
                $(com_util.formatString(".vp-ds-box-{0}.{1}", that.uuid, 'vp-ds-uninit')).removeClass('vp-ds-uninit').addClass('vp-ds-init');

                // bind autocomplete
                that._bindAutocomplete(that._varList);

                // bind Event for opening popup
                $(that.prop.pageThis.wrapSelector()).on('click', com_util.formatString('.vp-ds-box-{0} .vp-ds-filter', that.uuid), function(evt) {
                    // check disabled
                    if (!$(this).parent().find('input.vp-ds-target').is(':disabled')) {
                        if (!$(that.wrapSelector()).length > 0) {
                            // open popup box
                            that.open();
                        }
                    }
                    evt.stopPropagation();
                });

            });

            // click filter -> open DataSelector popup
            $(document).on(com_util.formatString("click.init-{0}", that.uuid), com_util.formatString(".vp-ds-box-{0}.{1}", that.uuid, 'vp-ds-uninit'), function () {
                // unbind initial event
                $(document).unbind(com_util.formatString(".init-{0}", that.uuid));
                $(com_util.formatString(".vp-ds-box-{0}.{1}", that.uuid, 'vp-ds-uninit')).removeClass('vp-ds-uninit').addClass('vp-ds-init');

                // bind autocomplete
                that._bindAutocomplete(that._varList);

                // bind Event for opening popup
                $(that.prop.pageThis.wrapSelector()).on('click', com_util.formatString('.vp-ds-box-{0} .vp-ds-filter', that.uuid), function(evt) {
                    // check if it's disabled
                    if (!$(this).parent().find('input.vp-ds-target').is(':disabled')) {
                        if (!$(that.wrapSelector()).length > 0) {
                            // open popup box
                            that.open();
                        }
                    }
                    evt.stopPropagation();
                });

                // do click event
                // check if it's disabled
                if (!$(this).find('input.vp-ds-target').is(':disabled')) {
                    if (!$(that.wrapSelector()).length > 0) {
                        // open popup box
                        that.open();
                    }
                }
            });

        }

        /**
         * Bind autocomplete for target input tag
         * @param {*} varList { label, value }
         */
        _bindAutocomplete(varList) {
            let that = this;

            $(com_util.formatString(".vp-ds-box-{0} input.vp-ds-target", that.uuid)).autocomplete({
                autoFocus: true,
                minLength: 0,
                source: function (req, res) {
                    var srcList = varList;
                    var returlList = new Array();
                    for (var idx = 0; idx < srcList.length; idx++) {
                        // srcList as object array
                        if (srcList[idx].label.toString().toLowerCase().includes(req.term.trim().toLowerCase())) {
                            returlList.push(srcList[idx]);
                        }
                    }
                    res(returlList);
                },
                select: function (evt, ui) {
                    let result = true;
                    // trigger change
                    $(this).val(ui.item.value);
                    $(this).data('type', ui.item.dtype);

                    that.state.filterType = 'All';
                    that.state.data = ui.item.value;
                    that.state.dataType = ui.item.dtype;
                    that.state.returnDataType = ui.item.dtype;

                    that.prop.pageThis.state[that.prop.id] = ui.item.value;
                    that.prop.pageThis.state[that.prop.id + '_state'] = that.state;

                    // select event
                    if (that.prop.select && typeof that.prop.select == 'function') {
                        result = that.prop.select(ui.item.value, ui.item.dtype);
                    }
                    $(this).trigger('change');

                    if (result != undefined) {
                        return result;
                    }
                    return true;
                },
                search: function(evt, ui) {
                    return true;
                }
            }).focus(function () {
                $(this).select();
                $(this).autocomplete('search', $(this).val());
            }).click(function () {
                $(this).select();
                $(this).autocomplete('search', $(this).val());
            }).autocomplete('instance')._renderItem = function(ul, item) {
                return $('<li>').attr('data-value', item.value)
                        .append(`<div class="vp-sg-item">${item.label}<label class="vp-gray-text vp-cursor">&nbsp;| ${item.dtype}</label></div>`)
                        .appendTo(ul);
            };
        }

        _bindEventForPopup() {
            let that = this;

            // Click X to close
            $(this.wrapSelector('.vp-inner-popup-close')).on('click', function() {
                that.close();
            });

            // Click cancel
            $(this.wrapSelector('#vp_dsCancel')).on('click', function() {
                that.close();
            });

            // Click ok
            $(this.wrapSelector('#vp_dsOk')).on('click', function() {
                // set target value
                that.setValue();
                that.close();
            });
        }

        /**
         * Bind event for items created dynamically
         */
        _bindEventForItem() {
            let that = this;

            // Click data type item
            $(that.wrapSelector('.vp-ds-type-item')).off('click');
            $(that.wrapSelector('.vp-ds-type-item')).on('click', function() {
                $(that.wrapSelector('.vp-ds-type-item')).removeClass('selected');
                $(this).addClass('selected');

                let type = $(this).data('type');
                that.state.filterType = type;
                if (type == 'All') {
                    that.renderVariableBox(that._varList);
                } else if (type == 'Others') {
                    that.renderVariableBox(that._varList.filter(obj => !that.prop.allowDataType.includes(obj.dtype)));
                } else {
                    // filter variable list
                    that.renderVariableBox(that._varList.filter(obj => obj.dtype == type));
                }

            });

            // Click variable item
            $(that.wrapSelector('.vp-ds-var-item')).off('click');
            // $(that.wrapSelector('.vp-ds-var-item')).on('click', function() {
            $(that.wrapSelector('.vp-ds-var-item')).single_double_click(function(evt) {
                // single click
                $(that.wrapSelector('.vp-ds-var-item')).removeClass('selected');
                $(this).addClass('selected');

                let data = $(this).text();
                let dataType = $(this).data('type');
                that.state.data = data;
                that.state.dataType = dataType;
                that.state.returnDataType = dataType;

                // render option page
                that.renderOptionPage();
            }, function(evt) {
                // double click to select directly
                let data = $(this).text();
                let dataType = $(this).data('type');
                that.state.data = data;
                that.state.dataType = dataType;
                that.state.returnDataType = dataType;

                that.setValue();
                that.close();
            });
        }

        loadVariables() {
            let that = this;
            // Searchable variable types
            let types = [
                ...vpConfig.getDataTypes(),
                // ML Data types
                ...vpConfig.getMLDataTypes()
            ];
            
            vpKernel.getDataList(types).then(function(resultObj) {
                var varList = JSON.parse(resultObj.result);
                // re-mapping variable list
                varList = varList.map(obj => { 
                    return {
                        label: obj.varName, 
                        value: obj.varName,
                        dtype: obj.varType,
                        info: obj.varInfo
                    }; 
                });

                that._varList = varList;
                if (varList && varList.length > 0 && that.state.data == '') {
                    that.state.data = varList[0].value;
                    that.state.dataType = varList[0].dtype;
                    that.state.returnDataType = varList[0].dtype;
                }
                
                that.renderDataBox(varList);
                that._bindAutocomplete(varList);

            });
        }

        template() {
            return dataHTML;
        }

        templateForTarget() {
            let value = this.prop.value;
            if (value == undefined) {
                value = this.prop.pageThis.state[this.prop.id] || '';
            }
            return `
                <div class="vp-ds-box vp-ds-box-${this.uuid} vp-ds-uninit">
                    <input type="text" class="vp-ds-target vp-input vp-state ${this.prop.classes}" 
                            id="${this.prop.id}" value="${value}" 
                            placeholder="${this.prop.placeholder}" ${this.prop.required?'required="required"':''}/>
                    <span class="vp-ds-filter">
                    <!-- LAB: img to url -->
                    <!-- <img src="${com_Const.IMAGE_PATH}filter.svg"/> -->
                    </span>
                </div>
            `;
        }

        templateForMultiSelector() {
            return `
                <div class="vp-ds-df-option-box">
                    <label><input type="checkbox" id="useIndex" class="vp-state" ${this.state.useIndex===true?'checked':''}/> <span>Use Index</span></label>
                    <div class="vp-ds-df-multiselector" ${this.state.useIndex===true?'style="display:none;"':''}>
                    </div>
                    <div class="vp-ds-df-index-box" ${this.state.useIndex===false?'style="display:none;"':''}>
                        <div><label>Index selected.</label>
                            <div class="vp-cs-select-container no-selection">
                                <div class="vp-cs-select-left">
                                    <input type="text" class="vp-input wp100" placeholder="Search" value="" readonly>
                                    <div class="vp-cs-select-box left vp-cs-droppable no-selection vp-scrollbar">
                                    </div>
                                </div>
                                <div class="vp-cs-select-btn-box">
                                <!-- 
                                    <button type="button" class="vp-cs-select-add-all-btn" title="Add all items"><img src="${com_Const.IMAGE_PATH}arrow_right_double.svg"></button>
                                    <button type="button" class="vp-cs-select-add-btn" title="Add selected items"><img src="${com_Const.IMAGE_PATH}arrow_right.svg"></button>
                                    <button type="button" class="vp-cs-select-del-btn" title="Remove selected items"><img src="${com_Const.IMAGE_PATH}arrow_left.svg"></button>
                                    <button type="button" class="vp-cs-select-del-all-btn" title="Remove all items"><img src="${com_Const.IMAGE_PATH}arrow_left_double.svg"></button> 
                                -->
                                <!-- LAB: img to url -->
                                    <button type="button" class="vp-cs-select-add-all-btn" title="Add all items"><div class="vp-icon-arrow-right-double"></div></button>
                                    <button type="button" class="vp-cs-select-add-btn vp-icon-arrow-right" title="Add selected items"><div class="vp-icon-arrow-right"></div></button>
                                    <button type="button" class="vp-cs-select-del-btn vp-icon-arrow-left" title="Remove selected items"><div class="vp-icon-arrow-left"></div></button>
                                    <button type="button" class="vp-cs-select-del-all-btn vp-icon-arrow-left-double" title="Remove all items"><div class="vp-icon-arrow-left-double"></div></button>
                                </div>
                                <div class="vp-cs-select-right">
                                    <div class="vp-cs-select-box right vp-cs-droppable no-selection vp-scrollbar ui-droppable">
                                        <div class="vp-cs-select-item">
                                            <span>index</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `
        }

        templateForSlicing() {
            return `
                <div>
                    <label for="slicingStart1">Type start/end index for slicing.</label>
                </div>
                <div>
                    <input type="number" class="vp-input vp-state" id="slicingStart1" placeholder="Start value" value="${this.state.slicingStart1}"/>
                    <input type="number" class="vp-input vp-state" id="slicingEnd1" placeholder="End value" value="${this.state.slicingEnd1}"/>
                </div>
            `;
        }

        templateFor2darray() {
            return `
                <div class="vp-grid-col-p50" style="grid-column-gap: 5px;">
                    <div>
                        <label class="w50">Row</label>
                        <select id="ndRowType" class="vp-select vp-state">
                            <option value="slicing">Slicing</option>
                            <option value="indexing">Indexing</option>
                        </select>
                        <div class="vp-nd-row-box slicing">
                            <div>
                                <label for="slicingStart1">Type start/end index for slicing.</label>
                            </div>
                            <div>
                                <input type="number" class="vp-input m vp-state" id="slicingStart1" placeholder="Start value" value="${this.state.slicingStart1}"/>
                                <input type="number" class="vp-input m vp-state" id="slicingEnd1" placeholder="End value" value="${this.state.slicingEnd1}"/>
                            </div>
                        </div>
                        <div class="vp-nd-row-box indexing">
                        </div>
                    </div>
                    <div>
                        <label class="w50">Column</label>
                        <select id="ndColType" class="vp-select vp-state">
                            <option value="slicing">Slicing</option>
                            <option value="indexing">Indexing</option>
                        </select>
                        <div class="vp-nd-col-box slicing">
                            <div>
                                <label for="slicingStart2">Type start/end index for slicing.</label>
                            </div>
                            <div>
                                <input type="number" class="vp-input m vp-state" id="slicingStart2" placeholder="Start value" value="${this.state.slicingStart2}"/>
                                <input type="number" class="vp-input m vp-state" id="slicingEnd2" placeholder="End value" value="${this.state.slicingEnd2}"/>
                            </div>
                        </div>
                        <div class="vp-nd-col-box indexing">
                        </div>
                    </div>
                </div>
            `
        }

        templateForKeyPicker() {
            return `
                <div>
                    <label>Type or select key from dictionary.</label>
                </div>
                <div>
                    <input type="text" class="vp-input vp-state" id="dictKey" placeholder="Type key"/>
                </div>
            `
        }

        render() {
            ;
        }

        /** Render popup on clicking filter button */
        renderPopup() {
            // load state
            let state = this.prop.pageThis.state[this.prop.id + '_state'];
            if (state) {
                this.state = {
                    ...this.state,
                    ...state
                }
            }

            super.render();

            this.loadVariables();
            this._bindEventForPopup();

            // if (this.state.data != '') {
            //     this.renderOptionPage();
            // }
        }

        renderDataBox(varList) {
            let that = this;
            let varTags = new com_String();
            let types = [
                'All',
                ...this.prop.allowDataType,
                'Others'
            ];
            // Add Data Types to filter
            types && types.forEach(type => {
                varTags.appendFormatLine('<div class="{0} {1}" data-type="{2}">{3}</div>'
                    , 'vp-ds-type-item', (that.state.filterType == type? 'selected': ''), type, type);
            });
            $(this.wrapSelector('.vp-ds-type-box')).html(varTags.toString());

            // focus on selected item
            let selectedTag = $(this.wrapSelector('.vp-ds-type-item.selected')).get(0);
            selectedTag && selectedTag.scrollIntoView();

            this.renderVariableBox(varList);
        }

        renderVariableBox(varList) {
            let that = this;
            let varTags = new com_String();
            varTags = new com_String();
            varList && varList.forEach((obj, idx) => {
                varTags.appendFormatLine('<div class="{0} {1}" title="{2}" data-type="{3}">{4}</div>'
                    , 'vp-ds-var-item', (that.state.data == obj.value?'selected':''), obj.dtype, obj.dtype, obj.label);
            });
            $(this.wrapSelector('.vp-ds-variable-box')).html(varTags.toString());

            // focus on selected item
            let selectedTag = $(this.wrapSelector('.vp-ds-var-item.selected')).get(0);
            selectedTag && selectedTag.scrollIntoView();

            this.renderOptionPage();
            this._bindEventForItem();
        }

        renderOptionPage() {
            let that = this;

            // initialize page and variables
            $(this.wrapSelector('.vp-ds-option-inner-box')).html('');
            this._columnSelector = null;

            let { data, dataType } = this.state;

            switch (dataType) {
                case 'DataFrame':
                    // render option page
                    $(this.wrapSelector('.vp-ds-option-inner-box')).html(this.templateForMultiSelector());
                    // column selecting
                    this._columnSelector = new MultiSelector(this.wrapSelector('.vp-ds-df-multiselector'),
                        { mode: 'columns', parent: [data], selectedList: this.state.indexing }
                    );

                    // bind event
                    $(this.wrapSelector('#useIndex')).on('change', function() {
                        let checked = $(this).prop('checked');
                        that.state.useIndex = checked;
                        if (checked === true) {
                            $(that.wrapSelector('.vp-ds-df-multiselector')).hide();
                            $(that.wrapSelector('.vp-ds-df-index-box')).show();
                        } else {
                            $(that.wrapSelector('.vp-ds-df-multiselector')).show();
                            $(that.wrapSelector('.vp-ds-df-index-box')).hide();
                        }
                    });
                    break;
                case 'Series':
                case 'list':
                case 'ndarray':
                    // check it's ndim
                    let ndim = 0;
                    try {
                        ndim = this._varList.filter(obj => obj.value==data)[0]['info']['ndim'];
                    } catch { ; }
                    if (ndim == 2) {
                        // 1d 2d page
                        $(this.wrapSelector('.vp-ds-option-inner-box')).html(this.templateFor2darray());
                        $(this.wrapSelector('#ndRowType')).val(this.state.ndRowType);
                        $(this.wrapSelector('#ndColType')).val(this.state.ndColType);
                        this._ndRowSelector = new MultiSelector(this.wrapSelector('.vp-nd-row-box.indexing'),
                            { mode: 'ndarray0', parent: [data], selectedList: this.state.rowIndexing }
                        );
                        this._ndColSelector = new MultiSelector(this.wrapSelector('.vp-nd-col-box.indexing'),
                            { mode: 'ndarray1', parent: [data], selectedList: this.state.colIndexing }
                        );
                        $(this.wrapSelector('.vp-nd-row-box')).hide();
                        $(this.wrapSelector('.vp-nd-col-box')).hide();
                        $(this.wrapSelector('.vp-nd-row-box.' + this.state.ndRowType)).show();
                        $(this.wrapSelector('.vp-nd-col-box.' + this.state.ndColType)).show();

                        // bind event
                        $(this.wrapSelector('#ndRowType')).on('change', function() {
                            that.state.ndRowType = $(this).val();
                            $(that.wrapSelector('.vp-nd-row-box')).hide();
                            $(that.wrapSelector('.vp-nd-row-box.' + that.state.ndRowType)).show();
                        });
                        $(this.wrapSelector('#ndColType')).on('change', function() {
                            that.state.ndColType = $(this).val();
                            $(that.wrapSelector('.vp-nd-col-box')).hide();
                            $(that.wrapSelector('.vp-nd-col-box.' + that.state.ndColType)).show();
                        });

                    } else {
                        // slicing
                        $(this.wrapSelector('.vp-ds-option-inner-box')).html(this.templateForSlicing());
                    }
                    break;
                case 'dict':
                    // key picker
                    $(this.wrapSelector('.vp-ds-option-inner-box')).html(this.templateForKeyPicker());
                    break;
                default:
                    break;
            }
        }

        toTagString() {
            return this.templateForTarget();
        }

        /**
         * simple version of _saveSingleState()
         */
        _saveState() {
            let that = this;
            $(this.wrapSelector('.vp-state')).each((idx, tag) => {
                let id = tag.id;
                let tagName = $(tag).prop('tagName'); // returns with UpperCase
                let newValue = '';
                switch(tagName) {
                    case 'INPUT':
                        let inputType = $(tag).prop('type');
                        if (inputType == 'checkbox') {
                            newValue = $(tag).prop('checked');
                        } else {
                            // inputType == 'text' || inputType == 'number' || inputType == 'hidden' || inputType == 'color' || inputType == 'range'
                            newValue = $(tag).val();
                        }
                        break;
                    case 'TEXTAREA':
                    case 'SELECT':
                    default:
                        newValue = $(tag).val();
                        if (!newValue) {
                            newValue = '';
                        }
                        break;
                }

                // save state
                that.state[id] = newValue;
            }); 
        }

        setValue() {
            let newValue = this.generateCode();
            $(this._target).val(newValue);
            $(this._target).data('type', this.state.returnDataType);
            // set pageThis.state
            this.prop.pageThis.state[this.prop.id + '_state'] = this.state;
            $(this._target).change();

            if (this.prop.finish && typeof this.prop.finish == 'function') {
                this.prop.finish(newValue, this.state.returnDataType);
            }            
        }

        generateCode() {
            // save state
            this._saveState();

            // get states
            let {
                data, dataType,
                useIndex,
                slicingStart1, slicingEnd1,
                slicingStart2, slicingEnd2,
                ndRowType, ndColType
            } = this.state;
            let code = new com_String();

            switch (dataType) {
                case 'DataFrame':
                    code.append(data);
                    if (useIndex === true) {
                        // use index
                        code.append('.index');
                    } else {
                        // use column selector
                        if (this._columnSelector != null) {
                            let result = this._columnSelector.getDataList();
                            this.state.indexing = result.map(obj => obj.code); // save state
                            let columnList = [];
                            result && result.forEach(obj => {
                                columnList.push(obj.code);
                            });
                            if (columnList.length > 0) {
                                if (columnList.length == 1) {
                                    // return as Series
                                    code.appendFormat('[{0}]', columnList.join(', '));
                                    // change datatype to Series
                                    this.state.returnDataType = 'Series';
                                } else {
                                    code.appendFormat('[[{0}]]', columnList.join(', '));
                                }
                            }
                        }
                    }
                    break;
                case 'Series':
                case 'list':
                    code.append(data);
                    // start / end value
                    if ((slicingStart1 && slicingStart1 != '') || (slicingEnd1 && slicingEnd1 != '')) {
                        code.appendFormat('[{0}:{1}]', slicingStart1, slicingEnd1);
                    }
                    break;
                case 'ndarray':
                    code.append(data);
                    let ndim = 0;
                    try {
                        ndim = this._varList.filter(obj => obj.value==data)[0]['info']['ndim'];
                    } catch { ; }
                    if (ndim == 2) {
                        let rowCode = '';
                        let colCode = '';
                        if (ndRowType == 'slicing') {
                            // slicing start / end value
                            if ((slicingStart1 && slicingStart1 != '') || (slicingEnd1 && slicingEnd1 != '')) {
                                rowCode = com_util.formatString('{0}:{1}', slicingStart1, slicingEnd1);
                            }
                        } else {
                            // indexing
                            let result = this._ndRowSelector.getDataList();
                            this.state.rowIndexing = result.map(obj => obj.code); // save state
                            let rowList = [];
                            result && result.forEach(obj => {
                                rowList.push(obj.code);
                            });
                            if (rowList.length > 0) {
                                if (rowList.length == 1) {
                                    rowCode = com_util.formatString('{0}', rowList.join(', '));
                                } else {
                                    rowCode = com_util.formatString('({0})', rowList.join(', '));
                                }
                            }
                        }
                        if (ndColType == 'slicing') {
                            // slicing start / end value
                            if ((slicingStart2 && slicingStart2 != '') || (slicingEnd2 && slicingEnd2 != '')) {
                                colCode = com_util.formatString('{0}:{1}', slicingStart2, slicingEnd2);
                            }
                        } else {
                            // indexing
                            let result = this._ndColSelector.getDataList();
                            this.state.colIndexing = result.map(obj => obj.code); // save state
                            let columnList = [];
                            result && result.forEach(obj => {
                                columnList.push(obj.code);
                            });
                            if (columnList.length > 0) {
                                if (columnList.length == 1) {
                                    colCode = com_util.formatString('{0}', columnList.join(', '));
                                } else {
                                    colCode = com_util.formatString('({0})', columnList.join(', '));
                                }
                            }
                        }
                        // merge rowCode and colCode
                        if (rowCode != '' || colCode != '') {
                            if (rowCode == '' && colCode != '') {
                                rowCode = ':'
                            }
                            code.appendFormat('[{0},{1}]', rowCode, colCode);
                        }
                    } else {
                        // start / end value
                        if ((slicingStart1 && slicingStart1 != '') || (slicingEnd1 && slicingEnd1 != '')) {
                            code.appendFormat('[{0}:{1}]', slicingStart1, slicingEnd1);
                        }
                    }
                    break;
                case 'dict':
                    code.append(data);
                    let dictKey = $(this.wrapSelector('#dictKey')).val();
                    if (dictKey && dictKey != '') {
                        code.appendFormat("['{0}']", dictKey);
                        // return datatype to ...
                        this.state.returnDataType = 'str'; // FIXME: get dict's key value
                    }
                    break;
                default:
                    code.append(data);
                    break;
            }
            return code.toString();
        }

        open() {
            this.renderPopup();
            $(this.wrapSelector()).show();
        }

        close() {
            $(this.wrapSelector()).remove();
        }

    }

    return DataSelector;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/FileNavigation.js":
/*!*************************************************************!*\
  !*** ./lib/visualpython/js/com/component/FileNavigation.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : FileNavigation.js
 *    Author          : Black Logic
 *    Note            : File navigation
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] FileNavigation
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/component/fileNavigation.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/component/fileNavigation.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/component/fileNavigation.css */ "./lib/visualpython/css/component/fileNavigation.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/component/LoadingSpinner */ "./lib/visualpython/js/com/component/LoadingSpinner.js"),
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(fileNaviHtml, fileNaviCss, LoadingSpinner, com_Const, com_String, com_util, Component) {
    // Temporary constant data
    const NAVIGATION_DIRECTION_TYPE = {
        TOP: 0,
        TO: 1,
        PREV: 2,
        INIT: 3
    }

    /**
     * FileNavigation
     * ------------------------------------------------------
     * How to use: 
     * // create file navigation
     * let fileNavigation = new FileNavigation({ 
     *          type: 'open', 
     *          extensions: ['vp'], 
     *          finish: function(filesPath, status, error) {
     *              // Do something after selecting file
     *          }});
     * // open file navigation
     * fileNavigation.open(); 
     */
    class FileNavigation extends Component {
        /**
         * Constructor
         * @param {Object} state { type, extensions, finish ... }
         */
        constructor(state) {
            super($(vpConfig.parentSelector), state);
            /**
             * state.type           open / save
             * state.extensions     extensions list
             * state.finish         callback function after selection
             * - example form : function (filesPath, status, error) { }
             * - filesPath    : list    => list of Object [ { file: '', path: '' } ]
             * - status       : boolean => true for success / false for error
             * - error        : if there's error, return its content
             * ---------------------------------------------------------------
             * state.fileName       (optional on save type) pre-defined fileName
             * state.multiSelect    (optional)
             * state.showAll        (optional)
             */
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'FileNavigation created', state);
        }
        _init() {
            super._init();
            /** Write codes executed before rendering */
            // state types
            this.state = {
                direction: '',
                type: '',           // open / save
                filePath: '',
                fileName: '',
                extensions: [],     // extensions list ex) png, jpg, gif
                multiSelect: false, // multi selection
                showAll: false,     // show other extension files also
                finish: null,        // callback after selection
                ...this.state
            };
            
            this.pathStackPointer = -1;
            this.pathStack = [];
            this.currentFileList = [];

            this.pathState = {
                parentPath: '',
                currentPath: '',
                baseFolder: '',     // root folder name
                relativeDir: '',    // root folder name
                baseDir: '',        // sliced current dir
                notebookFolder: '', // base folder of jupyter notebook path
                notebookPath: ''    // jupyter notebook path
            }
        }

        _bindEvent() {
            var that = this;
            // Close file navigation
            $(this.wrapSelector('.fileNavigationPage-closedBtn')).on('click', function() {
                that.close();
            });

            // Click root
            $(this.wrapSelector('#fnpRootFolder')).on('click', function() {
                var dirObj = {
                    direction: NAVIGATION_DIRECTION_TYPE.TOP,
                    destDir: '/'
                };
                that.getFileList(dirObj);
            });

            // Click sidebar
            $(this.wrapSelector('.fnp-sidebar-menu')).click(function(event) {
                $('.fnp-sidebar-menu').removeClass('selected');
                $(this).addClass('selected');

                var pathType = $(this).attr('data-path');
                var dirObj = {
                    direction: NAVIGATION_DIRECTION_TYPE.TO,
                    destDir: '/'
                }
                switch (pathType) {
                    case 'desktop':
                        dirObj.destDir = "_vp_get_desktop_path()";
                        dirObj.useFunction = true;
                        break;
                    case 'documents':
                        dirObj.destDir = "_vp_get_documents_path()";
                        dirObj.useFunction = true;
                        break;
                    case 'downloads':
                        dirObj.destDir = "_vp_get_downloads_path()";
                        dirObj.useFunction = true;
                        break;
                    case 'userid':
                        dirObj.destDir = "_vp_get_userprofile_path()";
                        dirObj.useFunction = true;
                        break;
                    case 'drive':
                        dirObj.destDir = "/content/drive/MyDrive";
                        break;
                    case '/':
                    default:
                        dirObj.direction = NAVIGATION_DIRECTION_TYPE.TOP;
                        break;
                }
                that.getFileList(dirObj);
            });

            // Click next(>) directory
            $(this.wrapSelector('.fileNavigationPage-btn-next')).click(() => {
                if (that.pathStackPointer + 1 == that.pathStack.length) {
                    com_util.renderAlertModal('No next directory');
                    return;
                }

                // initialize sidebar-menu selection
                $('.fnp-sidebar-menu').removeClass('selected');

                // get next path stack
                that.pathStackPointer++;
                var nextData = that.pathStack[that.pathStackPointer];

                var dirObj = {
                    direction: NAVIGATION_DIRECTION_TYPE.PREV,
                    destDir: nextData
                }  
                that.getFileList(dirObj);
            });
        
            // Click prev(<) directory
            $(this.wrapSelector('.fileNavigationPage-btn-prev')).click(() => {
                if (that.pathStackPointer <= 0) {
                    com_util.renderAlertModal('No previous directory');
                    return;
                }

                // initialize sidebar-menu selection
                $('.fnp-sidebar-menu').removeClass('selected');

                // get prev path stack
                that.pathStackPointer--;
                var popedData = that.pathStack[that.pathStackPointer];

                var dirObj = {
                    direction: NAVIGATION_DIRECTION_TYPE.PREV,
                    destDir: popedData
                }
                that.getFileList(dirObj);       
            });
        }

        template() {
            /** Implement generating template */
            let fileNaviBody = $(fileNaviHtml.replaceAll('${vp_base}', com_Const.BASE_PATH));
            $(fileNaviBody).find('.fnp-sidebar-menu').hide();
            if (vpConfig.extensionType === 'notebook') {
                $(fileNaviBody).find('.fnp-sidebar-menu.notebook').show();
            } else if (vpConfig.extensionType === 'colab') {
                $(fileNaviBody).find('.fnp-sidebar-menu.colab').show();
            } else if (vpConfig.extensionType === 'lab') {
                $(fileNaviBody).find('.fnp-sidebar-menu.lab').show();
            }
            return fileNaviBody;
        }

        /**
         * Render file item
         * @param {*} fileState { name, type, path, size, atime, mtime }
         *  - name : file name
         *  - type : file type (dir / file)
         *  - path : file absolute path
         *  - size : size (format: 0.0{B,KB,MB,...})
         *  - atime : created time (format: YYYY-MM-DD HH:mm)
         *  - mtime : modified time (format: YYYY-MM-DD HH:mm)
         */
        renderFileItem(fileState) {
            let {
                name, type, path, size, atime, mtime
            } = fileState;
            let that = this;

            let directoryLi = $('<li class="fileNavigationPage-li"></li>');
            let directoryI = $(`<i class="fileNavigationPage-dir-text 
                                            item_icon 
                                            ${type=='dir'?'folder':'file'}_icon 
                                            icon-fixed-width"
                                    data-type="${type}"
                                    data-path="${path}"
                                    data-size="${size}"
                                    data-atime="${atime}"
                                    data-mtime="${mtime}">
                                    ${name}
                                </i>`);
            directoryI.click(function() {
                if (type == 'dir') {
                    var dirObj = {
                        direction: NAVIGATION_DIRECTION_TYPE.TO,
                        destDir: path
                    }
        
                    // initialize sidebar-menu selection
                    $('.fnp-sidebar-menu').removeClass('selected');
        
                    that.getFileList(dirObj);
                } else {
                    let dirPath = that.getRelativePath(that.pathState.baseDir, that.pathState.currentPath);
                    let extension = name.substring(name.lastIndexOf('.') + 1);
                    let allowExtensionList = that.state.extensions;
                    // if it is not allowed extension
                    if (!allowExtensionList.includes(extension)) {
                        // TODO: alert
                        //vpCommon.renderAlertModal('Not supported file type');
                        return;
                    }
                    
                    that.handleSelectFile(dirPath, name);
                }
            });
    
            directoryLi.append(directoryI);
            return directoryLi;
        }

        /**
         * render file list based on currentFileList
         */
        renderFileList() {
            let that = this;
            let fileList = this.currentFileList;
            // clear body
            $(this.wrapSelector('.fileNavigationPage-body')).html('');

            // render file items
            let dirArr = [];
            let fileArr = [];

            // render upper folder
            if (that.pathState.parentPath != '') {
                let upperFolderTag = that.renderFileItem({
                    name: '..',
                    type: 'dir',
                    path: that.pathState.parentPath,
                    size: '',
                    atime: '',
                    mtime: ''
                });
                dirArr.push(upperFolderTag);
            }

            fileList && fileList.forEach((file, idx) => {
                if (idx == 0) return;
                let fileTag = that.renderFileItem(file);
                if (file.type == 'dir') {
                    dirArr.push(fileTag);
                } else {
                    fileArr.push(fileTag);
                }
            });

            var fileNavigationPageUl = $(`<ul class='fileNavigationPage-ul'></ul>`);
            // render folder first
            dirArr.forEach(dirTag => {
                fileNavigationPageUl.append(dirTag);
            });

            fileArr.forEach(fileTag => {
                fileNavigationPageUl.append(fileTag);
            });

            $(this.wrapSelector('.fileNavigationPage-body')).append(fileNavigationPageUl);

        }

        renderNowLocation() {
            let that = this;
            let currentRelativePathStr = this.pathState.relativeDir;
            let currentDirStr = this.pathState.currentPath;
            var notebookPathStr = this.pathState.notebookPath;
            var notebookPathStrLength = notebookPathStr.length;
            var baseFolder = this.pathState.baseFolder;
            var notebookFolder = this.pathState.notebookFolder;
            /** render current path */
            var currentRelativePathStrArray = currentRelativePathStr.split('/');
            
            if (baseFolder === notebookFolder && vpKernel.getNotebookPath().indexOf('/') === -1) {
                var index = currentRelativePathStrArray.indexOf(baseFolder)
                if (index >= 0) {
                    currentRelativePathStrArray.splice(index,1);
                }
            }

            var currentRelativePathDomElement = $(`<div><div>`);
            var basePathDomElement = $(`<span class='vp-filenavigation-nowLocation' value='/'> / </span>`);
            currentRelativePathDomElement.append(basePathDomElement);
            basePathDomElement.click(function() {
                var dirObj = {
                    direction: NAVIGATION_DIRECTION_TYPE.TO,
                    destDir: notebookPathStr
                }
                
                // initialize sidebar-menu selection
                $('.fnp-sidebar-menu').removeClass('selected');

                // render current file/dir list in fileNavigation body
                that.getFileList(dirObj, this);
            });

            var nestedLength = 0;
            // if it's outside of notebookPath, ignore notebookPath
            var prevLength = notebookPathStrLength;
            var useSidebar = false;
            if (currentRelativePathStr.includes('..')) {
                var upperList = currentRelativePathStr.match(/(\.\.\/)/g);
                if (upperList && upperList.length > 0) {
                    // in case, currentRelativePathStr = ../../somePathHere
                    prevLength -= upperList.length * 3; // 3 = length of '../' upper path string
                    useSidebar = true;
                } else {
                    // in case, currentRelativePathStr = .. 
                    prevLength = 0;
                    useSidebar = true;
                }
            }
            let slashStr = '/';
            currentRelativePathStrArray.forEach((pathToken,index) => {
                if (index === 0) {
                    slashStr = '';
                } else {
                    slashStr = '/';
                }

                var spanElement = $(`<span class='vp-filenavigation-nowLocation' value='${pathToken}'> 
                                        ${slashStr} ${pathToken}
                                    </span>`);
                
                var pathLength = prevLength + pathToken.length + 1 + nestedLength;
                spanElement.click(function() {
                    var currentRelativePathStr = `${currentDirStr.substring(0, pathLength)}`;
        
                    var dirObj = {
                        direction: NAVIGATION_DIRECTION_TYPE.TO,
                        destDir: currentRelativePathStr
                    }

                    // initialize sidebar-menu selection
                    $('.fnp-sidebar-menu').removeClass('selected');
                
                    // render current file/dir list in fileNavigation body
                    that.getFileList(dirObj, this);
                });
                currentRelativePathDomElement.append(spanElement);
                nestedLength += pathToken.length + 1;
            });
                
            $('.fileNavigationPage-directory-nowLocation').empty();
            $('.fileNavigationPage-directory-nowLocation').append(currentRelativePathDomElement);
        }

        renderSaveBox() {
            let page = new com_String();
            page.appendFormatLine('<input id="{0}" type="text" class="vp-input" placeholder="{1}" value="{2}"/>'
                                , 'vp_fileNavigationInput', 'New File Name', this.state.fileName);
            page.appendFormatLine('<select id="{0}" class="vp-select">', 'vp_fileNavigationExt');
            this.state.extensions.forEach(ext => {
                page.appendFormatLine('<option value="{0}">{1}</option>', ext, ext);
            });
            page.appendLine('</select>');
            page.appendFormatLine('<button class="{0} vp-button" data-menu="{1}">{2}</button>', 'vp-filenavi-btn', 'select', 'Select');
            $('.fileNavigationPage-button').html(page.toString());

            let that = this;
            // bind filename change event
            $(this.wrapSelector('#vp_fileNavigationInput')).on('change', function() {
                let fileName = $(this).val();
                let filePath = that.getRelativePath(that.pathState.baseDir, that.pathState.currentPath);
                
                that.handleSelectFile(filePath, fileName);
            });
            // bind save cancel event
            $(this.wrapSelector('.vp-filenavi-btn')).on('click', function() {
                let menu = $(this).data('menu');
                if (menu == 'select') {
                    // select file
                    let { fileName, filePath } = that.state;
                    let selectedExt = $(that.wrapSelector('#vp_fileNavigationExt')).val();
                    let fileExtIdx = fileName.lastIndexOf('.');
                    // if no extension, add it
                    if (selectedExt != '' && (fileExtIdx < 0 || fileName.substring(fileExtIdx + 1) != selectedExt)) {
                        fileName += '.' + selectedExt;
                    }
                    // no path, set it
                    if (filePath == '') {
                        filePath = './' + fileName;
                    }
                    fileExtIdx = filePath.lastIndexOf('.');
                    if (selectedExt != '' && (fileExtIdx < 0 || filePath.substring(fileExtIdx + 1) != selectedExt)) {
                        filePath += '.' + selectedExt;
                    }

                    // Manage result using finish function
                    let filesPath = [{ file: fileName, path: filePath }]; //FIXME: fix it if multiple selection implemented
                    let status = true;
                    let error = null;
                    vpLog.display(VP_LOG_TYPE.DEVELOP, 'fileNavigation finished saving', filesPath, status, error);
                    that.state.finish(filesPath, status, error);

                    // cancel file navigation
                    that.close();
                }
            });
        }

        loadFileList() {
            this.renderNowLocation();
            this.renderFileList();
        }

        render() {
            super.render();
            let that = this;
            /** Implement after rendering */
            // if save mode
            if (this.state.type == 'save') {
                // render saving box
                this.renderSaveBox();
            }

            // get current path
            this.getCurrentDirectory().then(function(currentPath) {
                that.pathState.currentPath = currentPath;
                that.makePaths(currentPath);
                // get file list of current path
                that.getFileList({ direction: NAVIGATION_DIRECTION_TYPE.INIT, destDir: currentPath});
            })
        }

        open() {
            $(this.wrapSelector()).show();
        }

        close() {
            $(this.wrapSelector()).remove();
        }

        //============================================================================
        // File & Path control
        //============================================================================
        handleSelectFile(relativeDirPath, filePathStr) {
            var fileNavigationState = this.pathState;

            var baseFolder = fileNavigationState.baseFolder;
            var currentDirStr = fileNavigationState.currentPath;

            var slashstr = `/`;
            if (relativeDirPath === '') {
                slashstr = '';
            }

            var pathInput = '';
            var fileInput = `${filePathStr}`;
            // if baseFolder doesn't exist in current path
            if (currentDirStr.indexOf(baseFolder) === -1) {
                
                pathInput = `${relativeDirPath}${slashstr}${filePathStr}`;
            } else {
                // if baseFolder exists in current path
                pathInput = `./${relativeDirPath}${slashstr}${filePathStr}`;
            }

            //============================================================================
            // Set selection result
            //============================================================================
            if (this.state.type == 'save') {
                // add as saving file
                this.setSelectedFile(fileInput, pathInput);
            } else {
                // Manage result using finish function
                let filesPath = [{ file: fileInput, path: pathInput }]; //FIXME: fix it if multiple selection implemented
                let status = true;
                let error = null;
                vpLog.display(VP_LOG_TYPE.DEVELOP, 'fileNavigation finished', filesPath, status, error);
                this.state.finish(filesPath, status, error);
        
                // remove and close file navigation
                this.close();
            }
        }
        getCurrentDirectory() {
            return vpKernel.getCurrentDirectory();
        }

        /**
         * Get File/Dir list
         * @param {Object} dirObj { direction, destDir, useFunction }
         *  - direction   : TO, PREV, TOP, INIT
         *  - destDir     : path to search
         *  - useFunction : boolean (true if use given path (Desktop, Downloads, User, ...))
         * @returns Promise(result)
         */
        getFileList(dirObj) {
            let that = this;
            let { direction, destDir, useFunction } = dirObj;
            if (direction === NAVIGATION_DIRECTION_TYPE.TO 
                || direction === NAVIGATION_DIRECTION_TYPE.PREV) {
                    ;
            }
            else if (direction === NAVIGATION_DIRECTION_TYPE.TOP) {
                destDir = '..';
            } else {
                destDir = '.';
            }
            // loading
            let loadingSpinner = new LoadingSpinner($(this.wrapSelector('.fileNavigationPage-directory-container')));
            // get file list using kernel
            return vpKernel.getFileList(destDir, useFunction).then(function(result) {
                /** Caution : if change code "$1" to '$1' as single quote, json parsing error occurs */
                var jsonVars = result.replace(/'([^']+)': /g, `"$1": `);        // object front
                jsonVars = jsonVars.replace(/: '([^']+)'([,}])/g, `: "$1"$2`);  // object back
                jsonVars = jsonVars.replace(/\\/g, `/`);
                var varList = JSON.parse(jsonVars);

                /** remove file/dir which starts with . */
                var filtered_varList = varList.filter(data => {
                    if (data.name && data.name[0] == '.') {
                        return false;
                    } else {
                        return true;
                    }
                }).sort((a,b) => {
                    /** sort ascending */
                    return a - b;
                });

                /**
                 * Filter file/dir which included in this.state.extensions
                 */
                if (Array.isArray(that.state.extensions) && that.state.extensions.length > 0 && that.state.extensions.toString() !== '') {
                    filtered_varList = filtered_varList.filter((data, index) => {
                        if (index == 0) {
                            return true;
                        }

                        if (data.type && data.type == 'dir') {
                            // if file, just show
                            return true;
                        } else if (data.name) {
                            var extension = data.name.substring(data.name.lastIndexOf('.') + 1);
                            if (that.state.extensions.includes(extension)) {
                                return true;
                            } else {
                                return false;
                            }
                        } else {
                            return false;
                        }
                    });
                }

                vpLog.display(VP_LOG_TYPE.DEVELOP, 'FileNavigation - getFileList: ', filtered_varList);

                var { currentDirStr,  currentRelativePathStr } = that.splitPathStrAndSetStack(dirObj, filtered_varList);
                if (filtered_varList[0].current === filtered_varList[0].parent) {
                    // no parent
                    that.pathState.parentPath = '';
                } else {
                    that.pathState.parentPath = filtered_varList[0].parent; // parent path
                }
                that.pathState.relativeDir = currentRelativePathStr;
                that.pathState.currentPath = currentDirStr;
                that.currentFileList = filtered_varList;

                that.loadFileList();
            }).catch(function(resultObj) {
                vpLog.display(VP_LOG_TYPE.ERROR, 'FileNavigation error', resultObj);

                let { msg, result } = resultObj;
                // show error using alert
                
                if (msg.content.evalue) {
                    let resultStr = msg.content.evalue;
                    //t.match(/\[Errno [0-9]+?\] (.*)/)[1]
                    // get error message from traceback
                    let alertMsg = resultStr.match(/\[Errno [0-9]+?\] (.*)/)[1];
                    com_util.renderAlertModal(alertMsg);
                }
            }).finally(function() {
                loadingSpinner.remove();
            });
        }

        /**
         * Get current path and set pathStates
         * @param {String} currentDirStr 
         */
        makePaths(currentDirStr) {
            var slicedCurrentDirStr = currentDirStr.slice(1, currentDirStr.length -1);
                slicedCurrentDirStr = slicedCurrentDirStr.replace(/\\/g, `/`);
      
            // slicedCurrentDirStr = slicedCurrentDirStr.replaceAll("//","/"); // replace with codes below
            var cursor = 0;
            while (slicedCurrentDirStr[cursor] !== undefined ) {
                if(slicedCurrentDirStr[cursor] === "/" && slicedCurrentDirStr[cursor + 1] === "/") {
                    slicedCurrentDirStr = slicedCurrentDirStr.slice(0,cursor) + slicedCurrentDirStr.slice(cursor + 1,slicedCurrentDirStr.length);
                }
                cursor++;
            }
          
            var splitedDirStrArr = slicedCurrentDirStr.split('/');
            /** 
             *  ex) if current path is 'C:/Users/VP/Desktop/Test'
             *      BaseFolderStr = 'Test'
             *      BaseDirStr = 'C:/Users/VP/Desktop/Test'
             *      RelativePathStr = 'Test'
             *      RelativePathStr changes when moving through paths
             */
            var rootFolderName = splitedDirStrArr[splitedDirStrArr.length - 1];
            var notebookPath = vpKernel.getNotebookPath();

            this.pathState.baseFolder = rootFolderName;
            this.pathState.relativeDir = rootFolderName;
            this.pathState.baseDir = slicedCurrentDirStr;

            var baseDirStr = slicedCurrentDirStr;

            /** 
             *  Generate notebookFolder, notebookPathStr using Jupyter.notebook.notebook_path
             *  ex) if current path is 'C:/Users/VP/Desktop/Test'
             *      Jupyter.notebook.notebook_path = 'Desktop/Test'
             *      notebookFolder = 'Desktop'
             *      notebookPathStr = 'Desktop/Test'
             *      Very root folder is 'VP'
             */
            if (notebookPath.indexOf("/") !== -1) {
                var index = 0;
                while ( notebookPath[index] !== "/" ) {
                    if ( notebookPath[index] === undefined ) {
                        break;
                    }
                    index++;
                }
            
                var notebookFolder = notebookPath.substring(0, index);
                var index2 = baseDirStr.indexOf(notebookFolder);
                while (baseDirStr[index2] !== "/") {
                    if ( baseDirStr[index2] === undefined ) {
                        break;
                    }
                    index2++;
                }

                var notebookFullPathStr = baseDirStr.substring(0, index2);
                var index3 = notebookFullPathStr.indexOf(notebookFolder);
                var notebookPathStr = baseDirStr.substring(0, index3 - 1);

                this.pathState.notebookFolder = notebookFolder;
                this.pathState.notebookPath = notebookPathStr;
            } else {
                this.pathState.notebookFolder = rootFolderName;
                this.pathState.notebookPath = slicedCurrentDirStr;
            }
        }

        splitPathStrAndSetStack(dirObj, resultInfoArr){
            var currentDirStr = resultInfoArr[0].current.split('//').join('/');
            var splitedDirStrArr = currentDirStr.split('/');
            var rootFolderName = splitedDirStrArr[splitedDirStrArr.length - 1];
    
            var firstIndex = currentDirStr.indexOf( this.pathState.notebookFolder );
    
            var currentRelativePathStr = '';
            if ( firstIndex === -1 ) {
                var notebookDir = this.pathState.notebookPath; //TEST:
                // FIXME: if current path is upper than Jupyter Home, send no permission?
                // currentRelativePathStr = currentDirStr.substring(this.getNotebookDir().length + 1, currentDirStr.length);
                // currentRelativePathStr = this.getRelativePath(notebookDir, currentDirStr);
                var baseDir = this.pathState.baseDir;
                currentRelativePathStr = this.getRelativePath(baseDir, currentDirStr);
            } else {
                currentRelativePathStr = currentDirStr.substring(firstIndex, currentDirStr.length); 
            }
    
            if ( dirObj.direction === NAVIGATION_DIRECTION_TYPE.TOP 
                 || dirObj.direction === NAVIGATION_DIRECTION_TYPE.TO ) {
                this.pushPath(currentDirStr);
            }
    
            return {
                currentDirStr,
                currentRelativePathStr,
                rootFolderName
            }
        }

        /**
         * Get relative path based on start path
         * - referred python os.path.relpath()
         * @param {string} start start path (base path)
         * @param {string} path current path
         * @returns current relative path
         */
        getRelativePath(start, path) {
            const sep = '/';
            const curdir = '.';
            const pardir = '..';

            var startSplit = start.split(sep);
            var pathSplit = path.split(sep);

            // TODO: check drive: startSplit[0] == pathSplit[0]

            var startList = startSplit.slice(1);
            var pathList = pathSplit.slice(1);

            var stopIdx = 0;
            while (stopIdx < startList.length) {
                var e1 = startList[stopIdx];
                var e2 = pathList[stopIdx];
                if (e1 != e2) {
                    break;
                }
                stopIdx++;
            }
            var parList = Array(startList.length - stopIdx).fill(pardir);
            var relList = parList.concat(pathList.slice(stopIdx));
            if (!relList || relList.length == 0) {
                return ''; // curdir
            }
            return relList.join(sep);
        }

        pushPath = function(path) {
            this.pathStack.push(path);
            return true;
        }
    
        popPath = function() {
            if (this.pathStack.length <= 0) {
                return undefined;
            }
            return this.pathStack.pop();
        }

        //============================================================================
        // Set states
        //============================================================================

        setExtensions(arr) {
            this.state.extensions = arr;
        }

        setSelectedFile(fileName, filePath) {
            this.state.fileName = fileName;
            this.state.filePath = filePath;

            $(this.wrapSelector('#vp_fileNavigationInput')).val(fileName);
        }
    }

    return FileNavigation;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/InfoModal.js":
/*!********************************************************!*\
  !*** ./lib/visualpython/js/com/component/InfoModal.js ***!
  \********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : InfoModal.js
 *    Author          : Black Logic
 *    Note            : InfoModal
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] InfoModal
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/component/infoModal.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/component/infoModal.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/component/infoModal.css */ "./lib/visualpython/css/component/infoModal.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(msgHtml, msgCss, com_Const, Component) {

    /**
     * InfoModal
     */
    class InfoModal extends Component {
        constructor(title) {
            super($('body'), { title: title });
        }

        _bindEvent() {
            let that = this;
            // click ok button
            $(this.wrapSelector('.vp-infoModal-yes')).click( function() {
                that.remove();
            });   
        }

        template() {
            return msgHtml.replaceAll('${vp_base}', com_Const.BASE_PATH);
        }

        render() {
            super.render();

            // set title
            $(this.wrapSelector('.vp-infoModal-titleStr')).text(this.state.title);
        }

        remove() {
            $(this.wrapSelector()).remove();
        }

    }

    return InfoModal;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/InnerFuncViewer.js":
/*!**************************************************************!*\
  !*** ./lib/visualpython/js/com/component/InnerFuncViewer.js ***!
  \**************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : InnerFuncViewer.js
 *    Author          : Black Logic
 *    Note            : Component > InnerFuncViewer
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2022. 06. 14
 *    Change Date     :
 */

//============================================================================
// [CLASS] InnerFuncViewer
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/component/innerFuncViewer.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/component/innerFuncViewer.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/component/innerFuncViewer.css */ "./lib/visualpython/css/component/innerFuncViewer.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/component/PopupComponent */ "./lib/visualpython/js/com/component/PopupComponent.js"),
    __webpack_require__(/*! vp_base/js/com/component/FileNavigation */ "./lib/visualpython/js/com/component/FileNavigation.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(ifHtml, ifCss, com_util, com_Const, com_String, PopupComponent, FileNavigation) {

    /**
     * InnerFuncViewer
     */
    class InnerFuncViewer extends PopupComponent {
        _init() {
            super._init();
            /** Write codes executed before rendering */
            this.name = 'Inner Function Viewer';
            this.config.codeview = false;
            this.config.dataview = false;
            this.config.runButton = false;
            this.config.sizeLevel = 3;

            this.state = {
                vp_userCode: '',
                ...this.state
            }

            this.codemirrorList = {};
            this.importedList = [];
            this.title_no = 0;
    
            // double click setter
            this.clicked = 0;
        }

        _bindEvent() {
            super._bindEvent();
            /** Implement binding events */
            let that = this;

            // search item 
            $(this.wrapSelector('.vp-if-search')).on('change', function(evt) {
                var value = $(this).val();
                if (value != '') {
                    $(that.wrapSelector('.vp-if-item')).hide();
                    $(that.wrapSelector('.vp-if-item')).filter(function() {
                        return $(this).data('title').search(value) >= 0;
                    }).show();
                } else {
                    $(that.wrapSelector('.vp-if-item')).show();
                }
            });
        }

        bindSnippetItem() {
            let that = this;
            // item header click (toggle item)
            $(this.wrapSelector('.vp-if-item-header')).off('click');
            $(this.wrapSelector('.vp-if-item-header')).on('click', function(evt) {
                // select item
                // remove selection
                $(that.wrapSelector('.vp-if-item-header')).removeClass('selected');
                // select item
                $(this).addClass('selected');

                // toggle item
                var parent = $(this).parent();
                var indicator = $(parent).find('.vp-if-indicator');
                var hasOpen = $(indicator).hasClass('open');
                
                if (!hasOpen) {
                    // show code
                    $(indicator).addClass('open');
                    $(parent).find('.vp-if-item-code').show();
                } else {
                    // hide code
                    $(indicator).removeClass('open');
                    $(parent).find('.vp-if-item-code').hide();
                }
                evt.stopPropagation();
            });

            // item menu click
            $(this.wrapSelector('.vp-if-item-menu-item')).off('click');
            $(this.wrapSelector('.vp-if-item-menu-item')).on('click', function(evt) {
                var menu = $(this).data('menu');
                var item = $(this).closest('.vp-if-item');
                var title = $(item).data('title');
                if (menu == 'run') {
                    // get codemirror
                    let cmCode = that.codemirrorList[title];
                    cmCode.save();
                    var code = cmCode.getValue();
                    // create block and run it
                    $('#vp_wrapper').trigger({
                        type: 'create_option_page', 
                        blockType: 'block',
                        menuId: 'lgExe_code',
                        menuState: { taskState: { code: code } },
                        afterAction: 'run'
                    });
                } 
                evt.stopPropagation();
            });
        }

        bindCodeMirror(title, selector) {
            let cmCode = this.initCodemirror({
                key: title,
                selector: selector,
                type: 'readonly',
                events: [{ 
                    key: 'change',
                    callback: function(evt, chgObj) {
                        if (chgObj.removed.join('') != '' || chgObj.text.join('') != '') {
                            // enable save button
                            $(selector).parent().find('.vp-if-save').removeClass('vp-disable');
                        }
                    }
                }]
            });
            this.codemirrorList[title] = cmCode;
        }

        templateForBody() {
            return ifHtml;
        }

        render() {
            super.render();

            // load udf list
            this.loadUserCommandList();
        }

        renderSnippetItem(title, code, description) {
            var item = new com_String();
            item.appendFormatLine('<div class="{0}" data-title="{1}">', 'vp-if-item', title, title);
            item.appendFormatLine('<div class="{0}" title="{1}">', 'vp-if-item-header', description);
            item.appendFormatLine('<div class="{0}"></div>', 'vp-if-indicator');
            item.appendFormatLine('<input type="text" class="vp-input {0}" value="{1}" disabled/>', 'vp-if-item-title', title);
            item.appendFormatLine('<div class="{0}">', 'vp-if-item-menu');
            // LAB: img to url
            // item.appendFormatLine('<div class="{0}" data-menu="{1}" title="{2}">'
            item.appendFormatLine('<div class="{0} vp-icon-run" data-menu="{1}" title="{2}">'
                                , 'vp-if-item-menu-item', 'run', 'Run');
            // item.appendFormatLine('<img src="{0}"/>', com_Const.IMAGE_PATH + 'snippets/run.svg');
            item.appendLine('</div>');
            item.appendLine('</div>'); // end of vp-if-item-menu
            item.appendLine('</div>'); // end of vp-if-item-header
            item.appendFormatLine('<div class="{0}">', 'vp-if-item-code');
            item.appendFormatLine('<textarea>{0}</textarea>', code);
            item.appendLine('</div>'); // end of vp-if-item-code
            item.appendLine('</div>'); // end of vp-if-item
            return item.toString();
        }

        generateCode() {
            return '';
        }

        loadUserCommandList() {
            var that = this;

            let funcDict = vpConfig.getModuleCode();
            funcDict = Object.fromEntries(Object.entries(funcDict).filter(([key]) => funcDict[key].type == 'function'));

            // clear table except head
            $(this.wrapSelector('.vp-if-table')).html('');

            // load code list
            var innerFuncCode = new com_String();
            Object.keys(funcDict).forEach(key => {
                let obj = funcDict[key];
                if (obj.code != null && obj.code != undefined) {
                    var item = that.renderSnippetItem(key, obj.code, obj.description);
                    innerFuncCode.append(item);
                }
            });
            $(that.wrapSelector('.vp-if-table')).html(innerFuncCode.toString());

            // bind snippet item
            that.bindSnippetItem();

            // load codemirror
            var codeList = $(that.wrapSelector('.vp-if-item-code textarea'));
            codeList.each((idx, tag) => {
                var title = $(tag).closest('.vp-if-item').data('title');
                that.bindCodeMirror(title, tag);
            });
        }

    }

    return InnerFuncViewer;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/InstanceEditor.js":
/*!*************************************************************!*\
  !*** ./lib/visualpython/js/com/component/InstanceEditor.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/css/component/instanceEditor.css */ "./lib/visualpython/css/component/instanceEditor.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/component/SuggestInput */ "./lib/visualpython/js/com/component/SuggestInput.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(insCss, com_Const, com_String, com_util, SuggestInput) {


    // temporary const
    const VP_INS_BOX = 'vp-ins-box';
    const VP_INS_SELECT_CONTAINER = 'vp-ins-select-container';
    const VP_INS_SELECT_TITLE = 'vp-ins-select-title';
    const VP_INS_SEARCH = 'vp-ins-search';
    const VP_INS_TYPE = 'vp-ins-type';
    const VP_INS_SELECT_BOX = 'vp-ins-select-box';
    const VP_INS_SELECT_LIST = 'vp-ins-select-list';
    const VP_INS_SELECT_ITEM = 'vp-ins-select-item';

    const VP_INS_PARAMETER_BOX = 'vp-ins-parameter-box';
    const VP_INS_PARAMETER = 'vp-ins-parameter';

    const VP_CREATE_VAR_BOX = 'vp-create-var-box';
    const VP_CREATE_VAR = 'vp-create-var';
    const VP_CREATE_VAR_BTN = 'vp-create-var-btn';

    // function/method types
    var _METHOD_TYPES = ['function', 'method', 'type', 'builtin_function_or_method', 'PlotAccessor'];

    /**
     * @class InstanceEditor
     * @param {object} pageThis
     * @param {string} targetId
     * @param {boolean} popup
     * @constructor
     */
    class InstanceEditor {
        constructor(pageThis, targetId, containerId = 'vp_wrapper', popup = false) {
            this.pageThis = pageThis;
            this.targetId = targetId;
            this.uuid = 'u' + com_util.getUUID();
            this.containerId = containerId;
            this.popup = popup;

            this.state = {
                code: '',
                type: '',
                list: [],
            };

            this.isFirstPage = false;
            this.dataTypeInfo = [
                { label: 'DataFrame', type: 'DataFrame', assign: ' = pd.DataFrame()' },
                { label: 'Series', type: 'Series', assign: ' = pd.Series()' },
                { label: 'Dict', type: 'dict', assign: ' = {}' },
                { label: 'List', type: 'list', assign: ' = []' },
                { label: 'Integer', type: 'int', assign: ' = 0' },
                { label: 'Others', type: '' }
            ];
            this.dataTypeList = ['DataFrame', 'Series', 'dict', 'list', 'int'];

            this.bindEvent();
            this.init();

        }
        getVarType() {
            return this.state.type;
        }
        getVarList() {
            return this.state.list;
        }
        init() {

            this.reload();
        }
        wrapSelector(selector = '') {
            return com_util.formatString('.{0} {1}', this.uuid, selector);
        }
        renderFirstPage() {
            var tag = new com_String();
            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_BOX, this.uuid); // vp-select-base

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_CONTAINER, 'datatype');
            tag.appendFormatLine('<div class="vp-multilang {0}">Data Type</div>', VP_INS_SELECT_TITLE);
            tag.appendFormatLine('<input class="{0} {1}" type="hidden"/>', VP_INS_TYPE, 'datatype');
            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_BOX, 'datatype');
            tag.appendFormatLine('<ul class="{0} {1}">', VP_INS_SELECT_LIST, 'datatype');
            this.dataTypeInfo.forEach((obj, idx) => {
                tag.appendFormatLine('<li class="{0}" data-var-name="{1}" data-var-type="{2}" data-var-assign="{3}">{4}</li>',
                    VP_INS_SELECT_ITEM + (idx == 0 ? ' selected' : ''), obj.label, obj.type, obj.assign, obj.label);
            });
            tag.appendLine('</ul>');
            tag.appendLine('</div>'); // VP_INS_SELECT_BOX
            tag.appendLine('</div>'); // VP_INS_SELECT_CONTAINER

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_CONTAINER, 'variable');
            tag.appendFormatLine('<div class="vp-multilang {0}">Variable</div>', VP_INS_SELECT_TITLE);
            tag.appendFormatLine('<input class="{0} {1}" type="hidden"/>', VP_INS_TYPE, 'variable');
            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_BOX, 'variable');
            tag.appendFormatLine('<ul class="{0} {1}">', VP_INS_SELECT_LIST, 'variable');
            tag.appendLine('</ul>');
            tag.appendLine('</div>'); // VP_INS_SELECT_BOX


            // create variable input
            tag.appendFormatLine('<div class="{0}">', VP_CREATE_VAR_BOX);
            tag.appendFormatLine('<input class="vp-input {0}" type="text" placeholder="Create new variable" />', VP_CREATE_VAR);
            // tag.appendFormatLine('<div class="{0}"><img src="{1}"/></div>', VP_CREATE_VAR_BTN, com_Const.IMAGE_PATH + 'plus.svg');
            tag.appendFormatLine('<div class="{0} vp-icon-plus"></div>', VP_CREATE_VAR_BTN);
            tag.appendLine('</div>');

            tag.appendLine('</div>'); // VP_INS_SELECT_CONTAINER

            tag.appendLine('</div>'); // VP_INS_BOX END



            // TODO: if this.popup == true
            $(this.pageThis.wrapSelector('#' + this.containerId)).html(tag.toString());

            return tag.toString();
        }
        renderVarList(varType, varList) {
            var varListTag = new com_String();
            varList != undefined && varList.forEach(obj => {
                if ((varType == '' && !this.dataTypeList.includes(obj.type))
                    || obj.type == varType) {
                    varListTag.appendFormatLine('<li class="{0}" data-var-name="{1}" data-var-type="{2}" title="{3}">{4}</li>',
                        VP_INS_SELECT_ITEM, obj.name, obj.type, obj.type, obj.name);
                }
            });
            $(this.wrapSelector('.' + VP_INS_SELECT_LIST + '.variable')).html(varListTag.toString());
        }
        renderPage(replace = true) {
            var tag = new com_String();
            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_BOX, this.uuid); // vp-select-base

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_CONTAINER, 'attr');
            tag.appendFormatLine('<div class="vp-multilang {0}">Attribute</div>', VP_INS_SELECT_TITLE);

            tag.appendFormatLine('<div style="{0}">', 'position: relative;');
            tag.appendFormatLine('<input class="vp-input {0} {1}" type="text" placeholder="Search Attribute"/>', VP_INS_SEARCH, 'attr');
            tag.appendFormatLine('<input class="{0} {1}" type="hidden"/>', VP_INS_TYPE, 'attr');
            tag.appendLine('</div>');

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_BOX, 'attr');
            tag.appendFormatLine('<ul class="{0} {1}">', VP_INS_SELECT_LIST, 'attr');
            tag.appendLine('</ul>');
            tag.appendLine('</div>'); // VP_INS_SELECT_BOX
            tag.appendLine('</div>'); // VP_INS_SELECT_CONTAINER

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_CONTAINER, 'method');
            tag.appendFormatLine('<div class="vp-multilang {0}">Method</div>', VP_INS_SELECT_TITLE);

            tag.appendFormatLine('<div style="{0}">', 'position: relative;');
            tag.appendFormatLine('<input class="vp-input {0} {1}" type="text" placeholder="Search Method"/>', VP_INS_SEARCH, 'method');
            tag.appendFormatLine('<input class="{0} {1}" type="hidden"/>', VP_INS_TYPE, 'method');
            tag.appendLine('</div>');

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_BOX, 'method');
            tag.appendFormatLine('<ul class="{0} {1}">', VP_INS_SELECT_LIST, 'method');
            tag.appendLine('</ul>');
            tag.appendLine('</div>'); // VP_INS_SELECT_BOX
            tag.appendLine('</div>'); // VP_INS_SELECT_CONTAINER

            tag.appendFormatLine('<div class="{0}">', VP_INS_PARAMETER_BOX);
            tag.appendFormatLine('<input type="text" class="{0}" placeholder="{1}"/>',
                VP_INS_PARAMETER, 'input parameter');
            tag.appendLine('</div>'); // VP_INS_PARAMETER

            tag.appendLine('</div>'); // VP_INS_BOX END



            // TODO: if this.popup == true
            $(this.pageThis.wrapSelector('#' + this.containerId)).html(tag.toString());

            return tag.toString();
        }
        bindEvent() {
            var that = this;

            // select datatype
            $(document).on('click', this.wrapSelector('.' + VP_INS_SELECT_LIST + '.datatype .' + VP_INS_SELECT_ITEM), function (event) {
                var varType = $(this).attr('data-var-type');
                $(that.wrapSelector('.' + VP_INS_SELECT_LIST + '.datatype .' + VP_INS_SELECT_ITEM)).removeClass('selected');
                $(this).addClass('selected');

                // if others selected, cannot create variable
                if (varType == '') {
                    $(that.wrapSelector('.' + VP_CREATE_VAR_BOX)).hide();
                } else {
                    $(that.wrapSelector('.' + VP_CREATE_VAR_BOX)).show();
                }

                that.reload();
            });

            // select variable
            $(document).on('click', this.wrapSelector('.' + VP_INS_SELECT_LIST + '.variable .' + VP_INS_SELECT_ITEM), function (event) {
                var varName = $(this).attr('data-var-name');
                var varType = $(this).attr('data-var-type');

                // console.log('clicked', varName, varType, that.state);
                $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                    type: "instance_editor_selected",
                    varName: varName,
                    varType: varType,
                    isMethod: false
                });
            });

            // create variable
            $(document).on('click', this.wrapSelector('.' + VP_CREATE_VAR_BTN), function (event) {
                var varName = $(that.wrapSelector('.' + VP_CREATE_VAR)).val();
                var selectedType = $(that.wrapSelector('.' + VP_INS_SELECT_LIST + '.datatype .' + VP_INS_SELECT_ITEM + '.selected'));
                var varType = selectedType.attr('data-var-type');
                var assignCode = selectedType.attr('data-var-assign');

                if (varName == '') {
                    ; // no variable name entered
                } else {
                    var code = com_util.formatString('{0}{1}\n{2}', varName, assignCode, 'type(' + varName + ').__name__');
                    vpKernel.execute(code).then(function (resultObj) {
                        let { result } = resultObj;
                        if (result.includes(varType)) {
                            com_util.renderSuccessMessage('Variable Created!');
                            that.reload();
                        }
                        $(that.wrapSelector('.' + VP_CREATE_VAR)).val('');
                    });
                }
            });

            // select attribute
            $(document).on('click', this.wrapSelector('.' + VP_INS_SELECT_LIST + '.attr .' + VP_INS_SELECT_ITEM), function (event) {
                var varName = $(this).attr('data-var-name');
                var varType = $(this).attr('data-var-type');

                // console.log('clicked', varName, varType, that.state);
                $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                    type: "instance_editor_selected",
                    varName: varName,
                    varType: varType,
                    isMethod: false
                });
            });

            // select method
            $(document).on('click', this.wrapSelector('.' + VP_INS_SELECT_LIST + '.method .' + VP_INS_SELECT_ITEM), function (event) {
                var varName = $(this).attr('data-var-name');
                var varType = $(this).attr('data-var-type');
                // console.log('clicked', varName, varType, that.state);
                $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                    type: "instance_editor_selected",
                    varName: varName,
                    varType: varType,
                    isMethod: true
                });
            });

            // parameter input
            $(document).on('change', this.wrapSelector('.' + VP_INS_PARAMETER), function (event) {
                var parameter = $(this).val();
                var variable = $(that.pageThis.wrapSelector('#' + that.targetId)).val();
                var splitList = variable.split('.');
                if (splitList && splitList.length > 0) {
                    var lastSplit = splitList[splitList.length - 1];
                    var matchList = lastSplit.match(/\(.*?\)$/gi);
                    if (matchList && matchList.length > 0) {
                        var lastBracket = matchList[matchList.length - 1];
                        splitList[splitList.length - 1] = lastSplit.replace(lastBracket, com_util.formatString('({0})', parameter));
                        var newCode = splitList.join('.');
                        $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                            type: "instance_editor_replaced",
                            originCode: variable,
                            newCode: newCode
                        });
                    }
                }
            });
        }
        reload(callback = undefined) {
            var that = this;
            var variable = $(this.pageThis.wrapSelector('#' + this.targetId)).val();
            if (variable == null) {
                this.isFirstPage = false;
                this.renderPage();
                return;
            }
            this.state.code = variable;

            if (variable == '') {
                if (!this.isFirstPage) {
                    this.renderFirstPage();
                    this.isFirstPage = true;
                }
            } else {
                this.isFirstPage = false;
                this.renderPage();
            }

            var code = com_util.formatString('_vp_print(_vp_load_instance("{0}"))', variable);

            vpKernel.execute(code).then(function (resultObj) {
                let { result } = resultObj;
                var varObj = {
                    type: 'None',
                    list: []
                };
                try {
                    varObj = JSON.parse(result);
                } catch {
                    ; // command error
                }

                var varType = varObj.type;
                var varList = varObj.list;

                that.state.type = varType;
                that.state.list = varList;

                // set variable type
                // $(that.wrapSelector('#vp_instanceType')).text(varType);
                // set dir list
                if (that.isFirstPage) {
                    varType = $(that.wrapSelector('.' + VP_INS_SELECT_LIST + '.datatype .' + VP_INS_SELECT_ITEM + '.selected')).attr('data-var-type');
                    that.renderVarList(varType, varList);
                } else {
                    var attrListTag = new com_String();
                    var methodListTag = new com_String();
                    var attrList = [];
                    var methodList = [];
                    varList != undefined && varList.forEach(obj => {
                        if (obj.type.includes('Indexer')) {
                            methodListTag.appendFormatLine('<li class="{0}" data-var-name="{1}" data-var-type="{2}" title="{3}">{4}</li>',
                                VP_INS_SELECT_ITEM, obj.name + '[]', obj.type, obj.type, obj.name);
                            methodList.push({
                                label: obj.name + '[]' + ' (' + obj.type + ')',
                                value: obj.name + '[]',
                                type: obj.type
                            });
                        }

                        // Method/Function... -> Method
                        else if (_METHOD_TYPES.includes(obj.type)) {
                            methodListTag.appendFormatLine('<li class="{0}" data-var-name="{1}" data-var-type="{2}" title="{3}">{4}</li>',
                                VP_INS_SELECT_ITEM, obj.name + '()', obj.type, obj.type, obj.name);
                            methodList.push({
                                label: obj.name + '()' + ' (' + obj.type + ')',
                                value: obj.name + '()',
                                type: obj.type
                            });
                        } else {
                            attrListTag.appendFormatLine('<li class="{0}" data-var-name="{1}" data-var-type="{2}" title="{3}">{4}</li>',
                                VP_INS_SELECT_ITEM, obj.name, obj.type, obj.type, obj.name);
                            attrList.push({
                                label: obj.name + ' (' + obj.type + ')',
                                value: obj.name,
                                type: obj.type
                            });
                        }
                    });
                    $(that.wrapSelector('.' + VP_INS_SELECT_LIST + '.attr')).html(attrListTag.toString());
                    $(that.wrapSelector('.' + VP_INS_SELECT_LIST + '.method')).html(methodListTag.toString());

                    // attribute search suggest
                    var suggestInput = new SuggestInput();
                    suggestInput.addClass('vp-input attr');
                    suggestInput.addClass(VP_INS_SEARCH);
                    suggestInput.setPlaceholder("Search Attribute");
                    suggestInput.setSuggestList(function () { return attrList; });
                    suggestInput.setSelectEvent(function (value, item) {
                        $(this.wrapSelector()).val(value);
                        $(that.wrapSelector('.' + VP_INS_TYPE + '.attr')).val(item.type);

                        $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                            type: "instance_editor_selected",
                            varName: value,
                            varType: item.type,
                            isMethod: false
                        });
                    });
                    $(that.wrapSelector('.' + VP_INS_SEARCH + '.attr')).replaceWith(function () {
                        return suggestInput.toTagString();
                    });

                    // method search suggest
                    suggestInput = new SuggestInput();
                    suggestInput.addClass('vp-input method');
                    suggestInput.addClass(VP_INS_SEARCH);
                    suggestInput.setPlaceholder("Search Method");
                    suggestInput.setSuggestList(function () { return methodList; });
                    suggestInput.setSelectEvent(function (value, item) {
                        $(this.wrapSelector()).val(value);
                        $(that.wrapSelector('.' + VP_INS_TYPE + '.method')).val(item.type);

                        $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                            type: "instance_editor_selected",
                            varName: value,
                            varType: item.type,
                            isMethod: true
                        });
                    });
                    $(that.wrapSelector('.' + VP_INS_SEARCH + '.method')).replaceWith(function () {
                        return suggestInput.toTagString();
                    });

                    // get parameter
                    var splitList = variable.split('.');
                    if (splitList && splitList.length > 0) {
                        var lastSplit = splitList[splitList.length - 1];
                        // if bracket is at the end of code
                        var matchList = lastSplit.match(/\(.*?\)$/gi);
                        if (matchList != null && matchList.length > 0) {
                            var lastBracket = matchList[matchList.length - 1];
                            // remove first/last brackets
                            var parameter = lastBracket.substr(1, lastBracket.length - 2);
                            $(that.wrapSelector('.' + VP_INS_PARAMETER)).val(parameter);
                            $(that.wrapSelector('.' + VP_INS_PARAMETER)).show();
                        } else {
                            $(that.wrapSelector('.' + VP_INS_PARAMETER)).val('');
                            $(that.wrapSelector('.' + VP_INS_PARAMETER)).hide();
                        }
                    } else {
                        $(that.wrapSelector('.' + VP_INS_PARAMETER)).hide();
                    }
                }

                // callback
                if (callback) {
                    callback(varObj);
                }
            }).catch(function(resultObj) {
                let { result } = resultObj;
                // show alert if this is visible
                if (that.pageThis.isHidden() == false) {
                    com_util.renderAlertModal(result.ename + ': ' + result.evalue);
                }
                // callback
                if (callback) {
                    callback('');
                }
            });


        }
        show() {
            $(this.wrapSelector()).show();
            this.reload();
        }
        hide() {
            $(this.wrapSelector()).hide();
        }
    }



    








    return InstanceEditor;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__))

/***/ }),

/***/ "./lib/visualpython/js/com/component/LibraryComponent.js":
/*!***************************************************************!*\
  !*** ./lib/visualpython/js/com/component/LibraryComponent.js ***!
  \***************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : LibraryComponent.js
 *    Author          : Black Logic
 *    Note            : Library Component
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] LibraryComponent
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/m_library/libraryComponent.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/m_library/libraryComponent.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/m_library/libraryComponent.css */ "./lib/visualpython/css/m_library/libraryComponent.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/component/PopupComponent */ "./lib/visualpython/js/com/component/PopupComponent.js"),
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_generator */ "./lib/visualpython/js/com/com_generator.js"),
    __webpack_require__(/*! vp_base/data/m_library/pandasLibrary */ "./lib/visualpython/data/m_library/pandasLibrary.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(libHtml, libCss, PopupComponent, com_Const, com_generator, pandasLibrary) {

    /**
     * LibraryComponent
     */
    class LibraryComponent extends PopupComponent {
        _init() {
            super._init();
            /** Write codes executed before rendering */
            this.config.dataview = false;
            this.config.sizeLevel = 1;
            
            this.packageId = this.state.config.id;
            // deep copy package info
            this.package = null;
            try {
                let findPackage = pandasLibrary.PANDAS_FUNCTION[this.packageId];
                if (findPackage) {
                    this.package = JSON.parse(JSON.stringify(findPackage)); // deep copy of package
                } else {
                    throw 'Cannot find package';
                }
            } catch(err) {
                vpLog.display(VP_LOG_TYPE.ERROR, 'Cannot find package id from library: ' + this.packageId);
                return;
            }
            this.config.checkModules = ['pd'];

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'loading state', this.state);
        }

        _bindEvent() {
            super._bindEvent();
            /** Implement binding events */
            var that = this;
            // save change of vp-state component
            $(this.wrapSelector('.vp-state')).on('change', function() {
                let id = $(this)[0].id;
                let val = $(this).val();
                that.state[id] = val;
            });
        }

        loadState() {
            vpLog.display(VP_LOG_TYPE.DEVELOP, this.state);   

            let that = this;
            Object.keys(this.state).forEach(key => {
                if (key !== 'config') {
                    let tag = $(that.wrapSelector('#' + key));
                    let tagName = $(tag).prop('tagName');
                    let savedValue = that.state[key];
                    switch(tagName) {
                        case 'INPUT':
                            let inputType = $(tag).prop('type');
                            if (inputType == 'text' || inputType == 'number' || inputType == 'hidden') {
                                $(tag).val(savedValue);
                                break;
                            }
                            if (inputType == 'checkbox') {
                                $(tag).prop('checked', savedValue);
                                break;
                            }
                            break;
                        case 'TEXTAREA':
                        case 'SELECT':
                        default:
                            $(tag).val(savedValue);
                            break;
                    }
                }
            });
        }

        saveState() {
            let that = this;
            $(this.wrapSelector('.vp-state')).each((idx, tag) => {
                let id = tag.id;
                let tagName = $(tag).prop('tagName');
                let newValue = '';
                switch(tagName) {
                    case 'INPUT':
                        let inputType = $(tag).prop('type');
                        if (inputType == 'text' || inputType == 'number' || inputType == 'hidden') {
                            newValue = $(tag).val();
                            break;
                        }
                        if (inputType == 'checkbox') {
                            newValue = $(tag).prop('checked');
                            break;
                        }
                        break;
                    case 'TEXTAREA':
                    case 'SELECT':
                    default:
                        newValue = $(tag).val();
                        break;
                }
                
                that.state[id] = newValue;
            }); 
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'savedState', that.state);   
        }

        templateForBody() {
            return libHtml.replaceAll('${vp_base}', com_Const.BASE_PATH);
        }

        render() {
            super.render();

            // show interface
            com_generator.vp_showInterfaceOnPage(this.wrapSelector(), this.package);

            // hide optional page if no options
            if ($.trim($(this.wrapSelector('#vp_optionBox table tbody')).html())=='') {
                $(this.wrapSelector('.vp-option-box')).hide();
            }
        }

        generateCode() {
            return com_generator.vp_codeGenerator(this.uuid, this.package);
        }

    }

    return LibraryComponent;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/LoadingSpinner.js":
/*!*************************************************************!*\
  !*** ./lib/visualpython/js/com/component/LoadingSpinner.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : LoadingSpinner.js
 *    Author          : Black Logic
 *    Note            : LoadingSpinner
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2022. 08. 26
 *    Change Date     :
 */

//============================================================================
// [CLASS] LoadingSpinner
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/css/component/loadingSpinner.css */ "./lib/visualpython/css/component/loadingSpinner.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(msgCss, Component) {

    /**
     * LoadingSpinner
     * Usage:
     * let loadingSpinner = new LoadingSpinner($(this.wrapSelector('.container')));
     * loadingSpinner.remove();
     */
    class LoadingSpinner extends Component {
        constructor(targetTag) {
            super($(targetTag));
        }

        template() {
            return '<div class="vp-loading-spinner"></div>';
        }

        render() {
            super.render();
        }

        remove() {
            $(this.wrapSelector()).remove();
        }

    }

    return LoadingSpinner;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/Modal.js":
/*!****************************************************!*\
  !*** ./lib/visualpython/js/com/component/Modal.js ***!
  \****************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : Modal.js
 *    Author          : Black Logic
 *    Note            : Modal
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] Modal
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/css/component/modal.css */ "./lib/visualpython/css/component/modal.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(modalCss, com_String, Component, com_util) {

    /**
     * Modal
     */
    class Modal extends Component {
        /**
         * 
         * @param {Object} state {title, message, buttons, defaultButtonIdx, finish}
         *  - title   : string / modal title
         *  - message : string / modal message
         *  - buttons : list / at least 1 button needed
         * [optional]
         *  - defaultButtonIdx : int (default: 1)
         *  - finish : callback function when modal button clicked (result:button idx 0~n)
         *  - buttonClass : list / same length as buttons, define classes for buttons
         */
        constructor(state) {
            super($('body'), state);
        }
        _init() {
            super._init();
            this.state = {
                title: '',
                message: '',
                buttons: [],
                defaultButtonIdx: 1,
                finish: function(modalIdx) {
                    /* Implementation needed */
                },
                buttonClass: [],
                ...this.state
            }
            /** Write codes executed before rendering */
            if (this.state.buttons.length == 0) {
                this.state.buttons.push("OK");
            }
        }

        _bindEvent() {
            /** Implement binding events */
            let that = this;
            // button click event
            $(this.wrapSelector('.vp-modal-button')).on('click', function () {
                if (typeof that.state.finish == "function") {
                    let modalIdx = parseInt($(this).data('idx'));
                    that.state.finish(modalIdx);
                }
                that.close();
            });
            
            // esc key to close, enter key to select
            $(document).bind(com_util.formatString('keydown.{0}', this.uuid), function (event) {
                that.handleEscToExit(event);
                that.handleEnterToClickButton(event);
            });
        }

        template() {
            /** Implement generating template */
            let { title, message, buttons, defaultButtonIdx, buttonClass } = this.state;
            var sbTagString = new com_String();
            sbTagString.appendLine("<div id='vp_multiButtonModal'>");
            sbTagString.appendLine("<div class='vp-multi-button-modal-box'>");
            sbTagString.appendLine("<div class='vp-multi-button-modal-message'>");
            sbTagString.appendLine("<div class='vp-multi-button-modal-message-inner'>");
            sbTagString.appendFormatLine("<span>{0}</span>", title);
            sbTagString.appendFormatLine("<p>{0}</p>", message);
            sbTagString.appendLine("</div>");
            sbTagString.appendLine("</div>");
            sbTagString.appendLine("<div class='vp-multi-button-modal-buttons'>");

            buttons && buttons.forEach((btn, idx) => {
                sbTagString.appendFormatLine("<input class='vp-button vp-modal-button {0} {1}' data-idx={2} type='button' value='{3}' />",
                    defaultButtonIdx == idx? 'vp-modal-selected-button' : '',
                    buttonClass[idx],
                    idx,
                    btn);
            });

            sbTagString.appendLine("</div>");
            sbTagString.appendLine("</div>");
            sbTagString.appendLine("</div>");
            sbTagString.appendLine("</div>");
            return sbTagString.toString();
        }

        render() {
            /** Implement after rendering */

        }

        //============================================================================
        // Settings
        //============================================================================
        /**
         * Open modal tag
         * @param {function} callBackList
         */
        open() {
            // render on open
            super.render();
            /** focus on default button */
            $(this.wrapSelector('.vp-modal-button[data-idx="' + this.state.defaultButtonIdx + '"]')).focus();
            // show
            $(this.wrapSelector()).show();
        }
        close() {
            $(document).unbind(com_util.formatString(".{0}", this.uuid));
            $(document).unbind(com_util.formatString("keydown.{0}", this.uuid));
            $(this.wrapSelector()).remove();
        }
        /**
         * close using esc
         * @param {Event} event
         */
        handleEscToExit(event) {
            var keyCode = event.keyCode ? event.keyCode : event.which;
            // esc
            if (keyCode == 27) {
                this.close();
            }
        }
        /**
         * select using enter
         * @param {Event} event 
         */
        handleEnterToClickButton(event) {
            var keyCode = event.keyCode ? event.keyCode : event.which;
            // enter
            if (keyCode == 13) {
                $(this.wrapSelector('.vp-modal-button[data-idx="' + this.state.defaultButtonIdx + '"]')).click();
                this.close();
            }
        }

    }

    return Modal;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/ModelEditor.js":
/*!**********************************************************!*\
  !*** ./lib/visualpython/js/com/component/ModelEditor.js ***!
  \**********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/css/component/instanceEditor.css */ "./lib/visualpython/css/component/instanceEditor.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/com_generatorV2 */ "./lib/visualpython/js/com/com_generatorV2.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! vp_base/js/com/component/SuggestInput */ "./lib/visualpython/js/com/component/SuggestInput.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(insCss, com_String, com_util, com_generator, Component, SuggestInput) {

    // temporary const
    const VP_INS_BOX = 'vp-ins-box';
    const VP_INS_SELECT_CONTAINER = 'vp-ins-select-container';
    const VP_INS_SELECT_TITLE = 'vp-ins-select-title';
    const VP_INS_SEARCH = 'vp-ins-search';
    const VP_INS_TYPE = 'vp-ins-type';
    const VP_INS_SELECT_BOX = 'vp-ins-select-box';
    const VP_INS_SELECT_LIST = 'vp-ins-select-list';
    const VP_INS_SELECT_ITEM = 'vp-ins-select-item';

    const VP_INS_PARAMETER_BOX = 'vp-ins-parameter-box';
    const VP_INS_PARAMETER = 'vp-ins-parameter';

    class ModelEditor extends Component {
        constructor(pageThis, targetId, containerId) {
            super(null, { pageThis: pageThis, targetId: targetId, containerId: containerId });
        }

        _init() {
            super._init();

            this.pageThis = this.state.pageThis;
            this.targetId = this.state.targetId;
            this.containerId = this.state.containerId;

            let modelEditorType = '';
            let modelEditorName = '';
            if (this.pageThis.state['modelEditorType'] == undefined) {
                modelEditorType = '';
            }
            if (this.pageThis.state['modelEditorName'] == undefined) {
                modelEditorName = '';
            }

            this.state = {
                modelEditorType: modelEditorType,
                modelEditorName: modelEditorName,
                action: {},
                info: {},
                config: {},
                ...this.state
            }

            this.loaded = false;
        }

        render() {
            ;
        }

        getModelCategory(modelType) {
            let mlDict = vpConfig.getMLDataDict();
            let keys = Object.keys(mlDict);
            let modelCategory = '';
            for (let i = 0; i < keys.length; i++) {
                let key = keys[i];
                if (mlDict[key].includes(modelType)) {
                    modelCategory = key;
                    break;
                }
            }
            return modelCategory;
        }

        getAction(modelType) {
            let category = this.getModelCategory(modelType);
            let defaultActions = {
                'fit': {
                    name: 'fit',
                    label: 'Fit',
                    code: '${model}.fit(${fit_featureData}, ${fit_targetData})',
                    description: 'Perform modeling from features, or distance matrix.',
                    options: [
                        { name: 'fit_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X_train' },
                        { name: 'fit_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y_train' }
                    ]
                },
                'predict': {
                    name: 'predict',
                    label: 'Predict',
                    code: '${pred_allocate} = ${model}.predict(${pred_featureData})',
                    description: 'Predict the closest target data X belongs to.',
                    options: [
                        { name: 'pred_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X_test' },
                        { name: 'pred_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'pred' }
                    ]
                },
                'predict_proba': {
                    name: 'predict_proba',
                    label: 'Predict probability',
                    code: '${pred_prob_allocate} = ${model}.predict_proba(${pred_prob_featureData})',
                    description: 'Predict class probabilities for X.',
                    options: [
                        { name: 'pred_prob_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X_test' },
                        { name: 'pred_prob_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'pred' }
                    ]
                },
                'transform': {
                    name: 'transform',
                    label: 'Transform',
                    code: '${trans_allocate} = ${model}.transform(${trans_featureData})',
                    description: 'Apply dimensionality reduction to X.',
                    options: [
                        { name: 'trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                        { name: 'trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                    ]
                }
            };
            let actions = {};
            switch (category) {
                case 'Data Preparation':
                    actions = {
                        'fit': {
                            name: 'fit',
                            label: 'Fit',
                            code: '${model}.fit(${fit_featureData})',
                            description: 'Fit Encoder/Scaler to X.',
                            options: [
                                { name: 'fit_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' }
                            ]
                        },
                        'fit_transform': {
                            name: 'fit_transform',
                            label: 'Fit and transform',
                            code: '${fit_trans_allocate} = ${model}.fit_transform(${fit_trans_featureData})',
                            description: 'Fit Encoder/Scaler to X, then transform X.',
                            options: [
                                { name: 'fit_trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'fit_trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                            ]
                        },
                        'transform': {
                            ...defaultActions['transform'],
                            description: 'Transform labels to normalized encoding.'
                        }
                    }

                    if (modelType != 'ColumnTransformer') {
                        actions = {
                            ...actions,
                            'inverse_transform': {
                                name: 'inverse_transform',
                                label: 'Inverse transform',
                                code: '${inverse_allocate} = ${model}.inverse_transform(${inverse_featureData})',
                                description: 'Transform binary labels back to multi-class labels.',
                                options: [
                                    { name: 'inverse_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'inverse_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'inv_trans' }
                                ]
                            }
                        }
                    }
                    break;
                case 'Regression':
                    actions = {
                        'fit': defaultActions['fit'],
                        'predict': defaultActions['predict']
                    }
                    break;
                case 'Classification':
                    actions = {
                        'fit': defaultActions['fit'],
                        'predict': defaultActions['predict'],
                        'predict_proba': defaultActions['predict_proba'],
                    }
                    if (['LogisticRegression', 'SVC', 'GradientBoostingClassifier'].includes(modelType)) {
                        actions = {
                            ...actions,
                            'decision_function': {
                                name: 'decision_function',
                                label: 'Decision function',
                                code: '${dec_allocate} = ${model}.decision_function(${dec_featureData})',
                                description: 'Compute the decision function of X.',
                                options: [
                                    { name: 'dec_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'dec_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable' }
                                ]
                            }
                        }
                    }
                    break;
                case 'Auto ML':
                    actions = {
                        'fit': defaultActions['fit'],
                        'predict': defaultActions['predict'],
                        'fit_predict': {
                            name: 'fit_predict',
                            label: 'Fit and predict',
                            code: '${fit_pred_allocate} = ${model}.fit_predict(${fit_pred_featureData})',
                            description: 'Fit and predict.',
                            options: [
                                { name: 'fit_pred_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'fit_pred_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'pred' }
                            ]
                        },
                        'predict_proba': defaultActions['predict_proba']
                    }
                    break;
                case 'Clustering':
                    if (modelType == 'AgglomerativeClustering' 
                        || modelType == 'DBSCAN') {
                        actions = {
                            'fit': {
                                name: 'fit',
                                label: 'Fit',
                                code: '${model}.fit(${fit_featureData})',
                                description: 'Perform clustering from features, or distance matrix.',
                                options: [
                                    { name: 'fit_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' }
                                ]
                            },
                            'fit_predict': {
                                name: 'fit_predict',
                                label: 'Fit and predict',
                                code: '${fit_pred_allocate} = ${model}.fit_predict(${fit_pred_featureData})',
                                description: 'Compute clusters from a data or distance matrix and predict labels.',
                                options: [
                                    { name: 'fit_pred_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'fit_pred_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'pred' }
                                ]
                            }
                        }
                        break;
                    }
                    actions = {
                        'fit': {
                            name: 'fit',
                            label: 'Fit',
                            code: '${model}.fit(${fit_featureData})',
                            description: 'Compute clustering.',
                            options: [
                                { name: 'fit_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' }
                            ]
                        },
                        'predict': {
                            name: 'predict',
                            label: 'Predict',
                            code: '${pred_allocate} = ${model}.predict(${pred_featureData})',
                            description: 'Predict the closest target data X belongs to.',
                            options: [
                                { name: 'pred_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'pred_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'pred' }
                            ]
                        },
                        'fit_predict': {
                            name: 'fit_predict',
                            label: 'Fit and predict',
                            code: '${fit_pred_allocate} = ${model}.fit_predict(${fit_pred_featureData})',
                            description: 'Compute cluster centers and predict cluster index for each sample.',
                            options: [
                                { name: 'fit_pred_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'fit_pred_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'pred' }
                            ]
                        }
                    }
                    if (modelType == 'KMeans') {
                        actions = {
                            ...actions,
                            'fit_transform': {
                                name: 'fit_transform',
                                label: 'Fit and transform',
                                code: '${fit_trans_allocate} = ${model}.fit_transform(${fit_trans_featureData})',
                                description: 'Compute clustering and transform X to cluster-distance space.', 
                                options: [
                                    { name: 'fit_trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'fit_trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                                ]
                            },
                            'transform': {
                                name: 'transform',
                                label: 'Transform',
                                code: '${trans_allocate} = ${model}.transform(${trans_featureData})',
                                description: 'Transform X to a cluster-distance space.',
                                options: [
                                    { name: 'trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                                ]
                            }
                        }
                    }
                    break;
                case 'Dimension Reduction':
                    if (modelType == 'TSNE') {
                        actions = {
                            'fit': {
                                name: 'fit',
                                label: 'Fit',
                                code: '${model}.fit(${fit_featureData})',
                                description: 'Fit X into an embedded space.',
                                options: [
                                    { name: 'fit_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' }
                                ]
                            },
                            'fit_transform': {
                                name: 'fit_transform',
                                label: 'Fit and transform',
                                code: '${fit_trans_allocate} = ${model}.fit_transform(${fit_trans_featureData})',
                                description: 'Fit X into an embedded space and return that transformed output.', 
                                options: [
                                    { name: 'fit_trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'fit_trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                                ]
                            }
                        }
                        break;
                    }
                    if (modelType == 'LinearDiscriminantAnalysis') { // LDA
                        actions = {
                            'fit': {
                                name: 'fit',
                                label: 'Fit',
                                code: '${model}.fit(${fit_featureData}, ${fit_targetData})',
                                description: 'Fit the Linear Discriminant Analysis model.',
                                options: [
                                    { name: 'fit_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'fit_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y' }
                                ]
                            },
                            'fit_transform': {
                                name: 'fit_transform',
                                label: 'Fit and transform',
                                code: '${fit_trans_allocate} = ${model}.fit_transform(${fit_trans_featureData}${fit_trans_targetData})',
                                description: 'Fit to data, then transform it.', 
                                options: [
                                    { name: 'fit_trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'fit_trans_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y' },
                                    { name: 'fit_trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                                ]
                            },
                            'predict': {
                                name: 'predict',
                                label: 'Predict',
                                code: '${pred_allocate} = ${model}.predict(${pred_featureData})',
                                description: 'Predict class labels for samples in X.',
                                options: [
                                    { name: 'pred_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'pred_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'pred' }
                                ]
                            },
                            'transform': {
                                name: 'transform',
                                label: 'Transform',
                                code: '${trans_allocate} = ${model}.transform(${trans_featureData})',
                                description: 'Project data to maximize class separation.',
                                options: [
                                    { name: 'trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                                ]
                            }
                        }
                        break;
                    }
                    actions = {
                        'fit': {
                            name: 'fit',
                            label: 'Fit',
                            code: '${model}.fit(${fit_featureData})',
                            description: 'Fit X into an embedded space.',
                            options: [
                                { name: 'fit_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' }
                            ]
                        },
                        'fit_transform': {
                            name: 'fit_transform',
                            label: 'Fit and transform',
                            code: '${fit_trans_allocate} = ${model}.fit_transform(${fit_trans_featureData})',
                            description: 'Fit the model with X and apply the dimensionality reduction on X.', 
                            options: [
                                { name: 'fit_trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'fit_trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                            ]
                        },
                        'inverse_transform': {
                            name: 'inverse_transform',
                            label: 'Inverse transform',
                            code: '${inverse_allocate} = ${model}.inverse_transform(${inverse_featureData})',
                            description: 'Transform data back to its original space.',
                            options: [
                                { name: 'inverse_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'inverse_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'inv_trans' }
                            ]
                        },
                        'transform': {
                            name: 'transform',
                            label: 'Transform',
                            code: '${trans_allocate} = ${model}.transform(${trans_featureData})',
                            description: 'Apply dimensionality reduction to X.',
                            options: [
                                { name: 'trans_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'trans_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'trans' }
                            ]
                        }
                    }
                    break;
            }
            return actions;
        }

        getInfo(modelType) {
            let category = this.getModelCategory(modelType);
            let infos = {};
            let defaultInfos = {
                'score': {
                    name: 'score',
                    label: 'Score',
                    code: '${score_allocate} = ${model}.score(${score_featureData}, ${score_targetData})',
                    description: '',
                    options: [
                        { name: 'score_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                        { name: 'score_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y' },
                        { name: 'score_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'scores' }
                    ]
                },
                'get_params': {
                    name: 'get_params',
                    label: 'Get parameters',
                    code: '${param_allocate} = ${model}.get_params(${deep})',
                    description: 'Get parameters for this estimator.',
                    options: [
                        { name: 'deep', component: ['bool_select'], default: 'True', usePair: true },
                        { name: 'param_allocate', label: 'Allocate to', component: ['input'], value: 'params' }
                    ]  
                },
                'permutation_importance': {
                    name: 'permutation_importance',
                    label: 'Permutation importance',
                    import: 'from sklearn.inspection import permutation_importance',
                    code: '${importance_allocate} = permutation_importance(${model}, ${importance_featureData}, ${importance_targetData}${scoring}${random_state}${etc})',
                    description: 'Permutation importance for feature evaluation.',
                    options: [
                        { name: 'importance_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X_train' },
                        { name: 'importance_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y_train' },
                        { name: 'scoring', component: ['input'], usePair: true },
                        { name: 'random_state', component: ['input_number'], placeholder: '123', usePair: true },
                        { name: 'importance_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'importances' }
                    ]
                }
            }
            switch (category) {
                case 'Data Preparation':
                    if (modelType == 'OneHotEncoder') {
                        infos = {
                            'categories_': { // TODO:
                                name: 'categories_',
                                label: 'Categories',
                                code: '${categories_allocate} = ${model}.categories_',
                                description: 'The categories of each feature determined during fitting',
                                options: [
                                    { name: 'categories_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'categories' }
                                ]
                            },
                            'get_feature_names_out': {
                                name: 'get_feature_names_out',
                                label: 'Get feature names',
                                code: '${feature_names_allocate} = ${model}.get_feature_names_out()',
                                description: 'Get output feature names.',
                                options: [
                                    { name: 'feature_names_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'features' }
                                ]
                            }
                        }
                    }
                    if (modelType == 'LabelEncoder') {
                        infos = {
                            'classes_': {
                                name: 'classes_',
                                label: 'Classes',
                                code: '${classes_allocate} = ${model}.classes_',
                                description: 'Holds the label for each class.',
                                options: [
                                    { name: 'classes_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'classes' }
                                ]
                            }
                        }
                    }
                    if (modelType == 'KBinsDiscretizer') {
                        infos = {
                            'bin_edges': { // TODO:
                                name: 'bin_edges',
                                label: 'Bin edges',
                                code: '${bin_edges_allocate} = ${model}.bin_edges_',
                                description: 'The edges of each bin. Contain arrays of varying shapes',
                                options: [
                                    { name: 'bin_edges_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'bin_edges' }
                                ]
                            }
                        }
                    }
                    if (modelType == 'ColumnTransformer') {
                        infos = {
                            'transformers_': {
                                name: 'transformers_',
                                label: 'Transformers_',
                                code: '${transformers_allocate} = ${model}.transformers_',
                                description: 'The collection of fitted transformers as tuples of (name, fitted_transformer, column).',
                                options: [
                                    { name: 'transformers_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'classes' }
                                ]
                            },
                            'get_feature_names_out': {
                                name: 'get_feature_names_out',
                                label: 'Get feature names',
                                code: '${feature_names_allocate} = ${model}.get_feature_names_out()',
                                description: 'Get output feature names.',
                                options: [
                                    { name: 'feature_names_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'features' }
                                ]
                            }
                        }
                    }
                    infos = {
                        ...infos,
                        'get_params': defaultInfos['get_params']
                    }
                    break;
                case 'Regression':
                    infos = {
                        'score': {
                            ...defaultInfos['score'],
                            description: 'Return the coefficient of determination of the prediction.'
                        },
                        'cross_val_score': {
                            name: 'cross_val_score',
                            label: 'Cross validation score',
                            import: 'from sklearn.model_selection import cross_val_score',
                            code: '${cvs_allocate} = cross_val_score(${model}, ${cvs_featureData}, ${cvs_targetData}${scoring}${cv})',
                            description: 'Evaluate a score by cross-validation.',
                            options: [
                                { name: 'cvs_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'cvs_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y' },
                                { name: 'scoring', component: ['option_select'], usePair: true, type: 'text',
                                    options: [
                                        '',
                                        'explained_variance', 'max_error', 'neg_mean_absolute_error', 'neg_mean_squared_error', 'neg_root_mean_squared_error',
                                        'neg_mean_squared_log_error', 'neg_median_absolute_error', 'r2', 'neg_mean_poisson_deviance', 'neg_mean_gamma_deviance',
                                        'neg_mean_absolute_percentage_error'
                                    ] },
                                { name: 'cv', label: 'Cross Validation', component: ['input_number'], placeholder: '1 ~ 10', default: 5, usePair: true },
                                { name: 'cvs_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'scores' }
                            ]
                        },
                        'permutation_importance': defaultInfos['permutation_importance'],
                        'Coefficient': {
                            name: 'coef_',
                            label: 'Coefficient',
                            code: '${coef_allocate} = ${model}.coef_',
                            description: 'Weights assigned to the features.',
                            options: [
                                { name: 'coef_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'coef' }
                            ]
                        },
                        'Intercept': {
                            name: 'intercept_',
                            label: 'Intercept',
                            code: '${intercept_allocate} = ${model}.intercept_',
                            description: 'Constants in decision function.',
                            options: [
                                { name: 'intercept_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'intercepts' }
                            ]
                        }
                    }
                    break;
                case 'Classification':
                    infos = {
                        'score': {
                            ...defaultInfos['score'],
                            description: 'Return the mean accuracy on the given test data and labels.'
                        },
                        'cross_val_score': {
                            name: 'cross_val_score',
                            label: 'Cross validation score',
                            import: 'from sklearn.model_selection import cross_val_score',
                            code: '${cvs_allocate} = cross_val_score(${model}, ${cvs_featureData}, ${cvs_targetData}${scoring}${cv})',
                            description: 'Evaluate a score by cross-validation.',
                            options: [
                                { name: 'cvs_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'cvs_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y' },
                                { name: 'scoring', component: ['option_select'], usePair: true, type: 'text', 
                                    options: [
                                        '',
                                        'accuracy', 'balanced_accuracy', 'top_k_accuracy', 'average_precision', 'neg_brier_score',
                                        'f1', 'f1_micro', 'f1_macro', 'f1_weighted', 'f1_samples', 'neg_log_loss', 'precision', 'recall', 'jaccard', 
                                        'roc_auc', 'roc_auc_ovr', 'roc_auc_ovo', 'roc_auc_ovr_weighted', 'roc_auc_ovo_weighted'
                                    ] },
                                { name: 'cv', label: 'Cross Validation', component: ['input_number'], placeholder: '1 ~ 10', default: 5, usePair: true },
                                { name: 'cvs_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'scores' }
                            ]
                        },
                        'permutation_importance': defaultInfos['permutation_importance']
                    }
                    break;
                case 'Auto ML':
                    infos = {
                        'score': {
                            ...defaultInfos['score'],
                            description: 'Return the mean accuracy on the given test data and labels.'
                        },
                        'get_params': {
                            ...defaultInfos['get_params']
                        }
                    }
                    break;
                case 'Clustering':
                    infos = {
                        // 'Size of clusters': {
                        //     name: 'Size of clusters',
                        //     code: "print(f'Size of clusters: {np.bincount(pred)}')", // FIXME: model.cluster_centers_ / use model info or hide it
                        //     options: []
                        // }
                    }

                    if (modelType == 'KMeans') {
                        infos = {
                            ...infos,
                            'cluster_centers_': {
                                name: 'cluster_centers',
                                label: 'Cluster centers',
                                code: '${centers_allocate} = ${model}.cluster_centers_',
                                description: 'Coordinates of cluster centers.', 
                                options: [
                                    { name: 'centers_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'cluster_centers' }
                                ]
                            }
                        }
                    }

                    if (modelType == 'AgglomerativeClustering') {
                        infos = {
                            ...infos,
                            'Dendrogram': { // FIXME:
                                name: 'dendrogram',
                                label: 'Dendrogram',
                                code: "# import\nfrom scipy.cluster.hierarchy import dendrogram, ward\n\nlinkage_array = ward(${dendro_data})\ndendrogram(linkage_array, p=3, truncate_mode='level', no_labels=True)\nplt.show()",
                                description: 'Draw a dendrogram',
                                options: [
                                    { name: 'dendro_data', label: 'Data', component: ['var_select'], var_type: ['DataFrame'] }
                                ]
                            }
                        }
                    }
                    break;
                case 'Dimension Reduction':
                    if (modelType == 'LDA') {
                        infos = {
                            'score': {
                                name: 'score',
                                label: 'Score',
                                code: '${score_allocate} = ${model}.score(${score_featureData}, ${score_targetData})',
                                description: 'Return the average log-likelihood of all samples.',
                                options: [
                                    { name: 'score_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                    { name: 'score_targetData', label: 'Target Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'y' },
                                    { name: 'score_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'scores' }
                                ]
                            }
                        }
                        break;
                    }
                    if (modelType == 'PCA') {
                        infos = {
                            'explained_variance_ratio_': {
                                name: 'explained_variance_ratio_',
                                label: 'Explained variance ratio',
                                code: '${ratio_allocate} = ${model}.explained_variance_ratio_',
                                description: 'Percentage of variance explained by each of the selected components.',
                                options: [
                                    { name: 'ratio_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'ratio' }
                                ]
                            }
                        }
                    }
                    infos = {
                        ...infos,
                        'score': {
                            name: 'score',
                            label: 'Score',
                            code: '${score_allocate} = ${model}.score(${score_featureData})',
                            description: 'Return the average log-likelihood of all samples.',
                            options: [
                                { name: 'score_featureData', label: 'Feature Data', component: ['var_select'], var_type: ['DataFrame', 'Series'], value: 'X' },
                                { name: 'score_allocate', label: 'Allocate to', component: ['input'], placeholder: 'New variable', value: 'scores' }
                            ]
                        }
                    }
                    break;
            }
            return infos;
        }

        renderPage() {
            var tag = new com_String();
            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_BOX, this.uuid); // vp-select-base

            // Model Editor State (Saved state)
            tag.appendFormatLine('<input type="hidden" id="{0}" class="vp-state" value="{1}"/>', 'modelEditorType', this.state.modelEditorType);
            tag.appendFormatLine('<input type="hidden" id="{0}" class="vp-state" value="{1}"/>', 'modelEditorName', this.state.modelEditorName);

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_CONTAINER, 'action');
            tag.appendFormatLine('<div class="vp-multilang {0}">Action</div>', VP_INS_SELECT_TITLE);

            tag.appendFormatLine('<div style="{0}">', 'position: relative;');
            tag.appendFormatLine('<input class="vp-input {0} {1}" type="text" placeholder="Search Action"/>', VP_INS_SEARCH, 'attr');
            tag.appendFormatLine('<input class="{0} {1}" type="hidden"/>', VP_INS_TYPE, 'action');
            tag.appendFormatLine('<i class="{0} {1}"></i>', 'fa fa-search', 'vp-ins-search-icon');
            tag.appendLine('</div>');

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_BOX, 'action');
            tag.appendFormatLine('<ul class="{0} {1}" style="height:80px">', VP_INS_SELECT_LIST, 'action');
            tag.appendLine('</ul>');
            tag.appendLine('</div>'); // VP_INS_SELECT_BOX
            tag.appendLine('</div>'); // VP_INS_SELECT_CONTAINER

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_CONTAINER, 'info');
            tag.appendFormatLine('<div class="vp-multilang {0}">Information</div>', VP_INS_SELECT_TITLE);

            tag.appendFormatLine('<div style="{0}">', 'position: relative;');
            tag.appendFormatLine('<input class="vp-input {0} {1}" type="text" placeholder="Search Info"/>', VP_INS_SEARCH, 'method');
            tag.appendFormatLine('<input class="{0} {1}" type="hidden"/>', VP_INS_TYPE, 'info');
            tag.appendFormatLine('<i class="{0} {1}"></i>', 'fa fa-search', 'vp-ins-search-icon');
            tag.appendLine('</div>');

            tag.appendFormatLine('<div class="{0} {1}">', VP_INS_SELECT_BOX, 'info');
            tag.appendFormatLine('<ul class="{0} {1}" style="height:80px">', VP_INS_SELECT_LIST, 'info');
            tag.appendLine('</ul>');
            tag.appendLine('</div>'); // VP_INS_SELECT_BOX
            tag.appendLine('</div>'); // VP_INS_SELECT_CONTAINER

            tag.appendFormatLine('<div class="vp-multilang {0}">Options</div>', VP_INS_SELECT_TITLE);
            tag.appendFormatLine('<div class="{0} vp-grid-col-95"></div>', VP_INS_PARAMETER_BOX);
            tag.appendLine('</div>'); // VP_INS_BOX END

            $(this.pageThis.wrapSelector('#' + this.containerId)).html(tag.toString());

            return tag.toString();
        }

        reload() {
            this.renderPage();

            let targetTag = $(this.pageThis.wrapSelector('#' + this.targetId));
            let model = $(targetTag).val();
            let modelType = $(targetTag).find('option:selected').data('type');
            
            let actions = this.getAction(modelType);
            let infos = this.getInfo(modelType);
            this.state.action = { ...actions };
            this.state.info = { ...infos };
            
            var actListTag = new com_String();
            var infoListTag = new com_String();
            
            Object.keys(actions).forEach(actKey => {
                let titleText = actions[actKey].description;
                if (actions[actKey].name != actions[actKey].label) {   
                    titleText = actions[actKey].name + ': ' + titleText;
                }
                actListTag.appendFormatLine('<li class="{0}" data-var-name="{1}" data-var-type="{2}" title="{3}">{4}</li>',
                VP_INS_SELECT_ITEM, actKey, 'action', titleText, actions[actKey].label);
            });
            Object.keys(infos).forEach(infoKey => {
                let titleText = infos[infoKey].description;
                if (infos[infoKey].name != infos[infoKey].label) {   
                    titleText = infos[infoKey].name + ': ' + titleText;
                }
                infoListTag.appendFormatLine('<li class="{0}" data-var-name="{1}" data-var-type="{2}" title="{3}">{4}</li>',
                VP_INS_SELECT_ITEM, infoKey, 'info', titleText, infos[infoKey].label);
            });
            
            $(this.wrapSelector('.' + VP_INS_SELECT_LIST + '.action')).html(actListTag.toString());
            $(this.wrapSelector('.' + VP_INS_SELECT_LIST + '.info')).html(infoListTag.toString());
            
            let that = this;
            // action search suggest
            var suggestInput = new SuggestInput();
            suggestInput.addClass('vp-input action');
            suggestInput.addClass(VP_INS_SEARCH);
            suggestInput.setPlaceholder("Search Action");
            suggestInput.setSuggestList(function () { return Object.keys(actions); });
            suggestInput.setSelectEvent(function (value, item) {
                $(this.wrapSelector()).val(value);
                $(that.wrapSelector('.' + VP_INS_TYPE + '.action')).val(item.type);

                $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                    type: "model_editor_selected",
                    varName: value,
                    varOptions: actions[value],
                    isMethod: false
                });
            });
            $(that.wrapSelector('.' + VP_INS_SEARCH + '.action')).replaceWith(function () {
                return suggestInput.toTagString();
            });

            // info search suggest
            suggestInput = new SuggestInput();
            suggestInput.addClass('vp-input info');
            suggestInput.addClass(VP_INS_SEARCH);
            suggestInput.setPlaceholder("Search info");
            suggestInput.setSuggestList(function () { return Object.keys(infos); });
            suggestInput.setSelectEvent(function (value, item) {
                $(this.wrapSelector()).val(value);
                $(that.wrapSelector('.' + VP_INS_TYPE + '.info')).val(item.type);

                $(that.pageThis.wrapSelector('#' + that.targetId)).trigger({
                    type: "model_editor_selected",
                    varName: value,
                    varOptions: infos[value],
                    isMethod: true
                });
            });
            $(that.wrapSelector('.' + VP_INS_SEARCH + '.info')).replaceWith(function () {
                return suggestInput.toTagString();
            });

            // bind event
            this._bindEvent();

            // load once on initializing page
            if (this.loaded == false) {
                let { modelEditorType, modelEditorName } = this.pageThis.state;
                if (modelEditorType != '' && modelEditorName != '') {
                    // render option page for saved state
                    that.renderOptionPage(modelEditorType, modelEditorName);
                }
                // set loaded true
                this.loaded = true;
            }
        }

        renderOptionPage(type, name) {
            if (this.state[type] != undefined && this.state[type][name] != undefined) {
                let config = this.state[type][name];
                let optBox = new com_String();
                // render tag
                config && config.options && config.options.forEach(opt => {
                    let label = opt.name;
                    if (opt.label != undefined) {
                        label = opt.label;
                    }
                    // fix label
                    label = com_util.optionToLabel(label);
                    optBox.appendFormatLine('<label for="{0}" title="{1}">{2}</label>'
                        , opt.name, opt.name, label);
                    let content = com_generator.renderContent(this, opt.component[0], opt, this.pageThis.state);
                    optBox.appendLine(content[0].outerHTML);
                });
                // replace option box
                $(this.wrapSelector('.' + VP_INS_PARAMETER_BOX)).html(optBox.toString());
    
                this.state.config = config;
    
                // add selection
                $(this.wrapSelector('.' + VP_INS_SELECT_ITEM)).removeClass('selected');
                let typeClass = '.' + VP_INS_SELECT_LIST + '.' + type;
                let nameClass = '.' + VP_INS_SELECT_ITEM + '[data-var-name="' + name + '"]';
                $(this.wrapSelector(typeClass + ' ' + nameClass)).addClass('selected');
                // set state
                $(this.wrapSelector('#modelEditorType')).val(type);
                $(this.wrapSelector('#modelEditorName')).val(name);
                this.pageThis.state.modelEditorType = type;
                this.pageThis.state.modelEditorName = name;
            }
        }

        _bindEvent() {
            super._bindEvent();
            let that = this;

            $(this.wrapSelector('.' + VP_INS_SELECT_ITEM)).on('click', function() {
                let name = $(this).data('var-name');
                let type = $(this).data('var-type');
                
                that.renderOptionPage(type, name);
            });
        }

        /**
         * Show Model Editor
         * @param {*} showType all / action / info 
         */
        show() {
            $(this.wrapSelector()).show();

            this.reload();
        }

        hide() {
            $(this.wrapSelector()).hide();
        }

        getCode(replaceDict={}) {
            let code = new com_String();
            if (this.state.config.import != undefined) {
                code.appendLine(this.state.config.import);
                code.appendLine();
            }
            let modelCode = com_generator.vp_codeGenerator(this.pageThis, this.state.config, this.pageThis.state);
            Object.keys(replaceDict).forEach(key => {
                modelCode = modelCode.replace(key, replaceDict[key]);
            });
            code.append(modelCode);

            let allocateIdx = modelCode.indexOf(' = ');
            if (allocateIdx >= 0) {
                let allocateCode = modelCode.substr(0, allocateIdx);
                code.appendLine();
                code.append(allocateCode);
            }

            return code.toString();
        }
    }

    return ModelEditor;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/MultiSelector.js":
/*!************************************************************!*\
  !*** ./lib/visualpython/js/com/component/MultiSelector.js ***!
  \************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : MultiSelector.js
 *    Author          : Black Logic
 *    Note            : Multi Selector
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 10. 05
 *    Change Date     :
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/css/component/multiSelector.css */ "./lib/visualpython/css/component/multiSelector.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! vp_base/js/com/component/SuggestInput */ "./lib/visualpython/js/com/component/SuggestInput.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(multiCss, com_Const, com_String, com_util, Component, SuggestInput) {

    //========================================================================
    // Define variable
    //========================================================================
    /** select */
    const APP_PREFIX = 'vp-cs'
    const APP_SELECT_CONTAINER = APP_PREFIX + '-select-container';
    const APP_SELECT_LEFT = APP_PREFIX + '-select-left';
    const APP_SELECT_BTN_BOX = APP_PREFIX + '-select-btn-box';
    const APP_SELECT_RIGHT = APP_PREFIX + '-select-right';

    const APP_SELECT_BOX = APP_PREFIX + '-select-box';
    const APP_SELECT_ITEM = APP_PREFIX + '-select-item';
    
    /** select left */
    const APP_SELECT_SEARCH = APP_PREFIX + '-select-search';
    const APP_DROPPABLE = APP_PREFIX + '-droppable';
    const APP_DRAGGABLE = APP_PREFIX + '-draggable';

    /** select btns */
    const APP_SELECT_ADD_ALL_BTN = APP_PREFIX + '-select-add-all-btn';
    const APP_SELECT_ADD_BTN = APP_PREFIX + '-select-add-btn';
    const APP_SELECT_DEL_BTN = APP_PREFIX + '-select-del-btn';
    const APP_SELECT_DEL_ALL_BTN = APP_PREFIX + '-select-del-all-btn';


    //========================================================================
    // [CLASS] MultiSelector
    //========================================================================
    class MultiSelector extends Component {

        /**
         * 
         * @param {string} frameSelector        query for parent component
         * @param {Object} config  parent:[], selectedList=[], includeList=[]
         */
        constructor(frameSelector, config) {
            super(frameSelector, config, {});
        }

        _init() {
            this.frameSelector = this.$target;

            // configuration
            this.config = this.state;

            var { mode, type, parent, dataList=[], selectedList=[], includeList=[], excludeList=[] } = this.config;
            this.mode = mode;   // variable / columns / index / ndarray0 / ndarray1 / methods / data(given data)
            this.parent = parent;
            this.selectedList = selectedList;
            this.includeList = includeList;
            this.excludeList = excludeList;

            this.dataList = dataList;   // [ { value, code, type }, ... ]
            this.pointer = { start: -1, end: -1 };

            var that = this;

            switch (mode) {
                case 'columns':
                    this._getColumnList(parent, function(dataList) {
                        that._executeCallback(dataList);
                    });
                    break;
                case 'variable':
                    this._getVariableList(type, function(dataList) {
                        that._executeCallback(dataList);
                    });
                    break;
                case 'index':
                    this._getRowList(parent, function(dataList) {
                        that._executeCallback(dataList);
                    });
                    break;
                case 'ndarray0':
                    this._getNdarray(parent, 0, function(dataList) {
                        that._executeCallback(dataList);
                    });
                    break;
                case 'ndarray1':
                    this._getNdarray(parent, 1, function(dataList) {
                        that._executeCallback(dataList);
                    });
                    break;
                case 'data':
                    that._executeCallback(this.dataList);
                    break;
            }
        }

        // render() {
        //     ;
        // }

        _executeCallback(dataList) {
            if (this.includeList && this.includeList.length > 0) {
                dataList = dataList.filter(data => this.includeList.includes(data.code));
            }
            if (this.excludeList && this.excludeList.length > 0) {
                dataList = dataList.filter(data => !this.excludeList.includes(data.code));
            }
            this.dataList = dataList;

            // load
            this.load();
        }

        _getVariableList(type, callback) {
            vpKernel.getDataList(type).then(function(resultObj) {
                let { result } = resultObj;
                try {
                    var dataList = JSON.parse(result);
                    dataList = dataList.map(function(x, idx) {
                        return {
                            ...x,
                            value: x.varName,
                            code: x.varName,
                            type: x.varType,
                            location: idx
                        };
                    });
                    callback(dataList);
                } catch (e) {
                    callback([]);
                }
            });
        }
        
        _getColumnList(parent, callback) {
            if (Array.isArray(parent) && parent.length > 1) {
                vpKernel.getCommonColumnList(parent).then(function(resultObj) {
                    let { result } = resultObj;
                    try {
                        var colList = JSON.parse(result);
                        colList = colList.map(function(x) {
                            return {
                                ...x,
                                value: x.label,
                                code: x.value,
                                type: x.dtype
                            };
                        });
                        callback(colList);
                    } catch (e) {
                        callback([]);
                    }
                });
            } else {
                vpKernel.getColumnList(parent).then(function(resultObj) {
                    let { result } = resultObj;
                    try {
                        var colList = JSON.parse(result);
                        colList = colList.map(function(x) {
                            return {
                                ...x,
                                value: x.label,
                                code: x.value,
                                type: x.dtype
                            };
                        });
                        callback(colList);
                    } catch (e) {
                        callback([]);
                    }
                });
            }
        }

        _getRowList(parent, callback) {
            vpKernel.getRowList(parent).then(function(resultObj) {
                let { result } = resultObj;
                try {
                    var rowList = JSON.parse(result);
                    rowList = rowList.map(function(x) {
                        return {
                            ...x,
                            value: x.label,
                            code: x.value,
                            type: x.dtype
                        };
                    });
                    callback(rowList);
                } catch (e) {
                    callback([]);
                }
            });
        }

        _getNdarray(parent, dim, callback) {
            let parentVar = '';
            if (parent && parent.length > 0) {
                parentVar = parent[0];

                let cmd = com_util.formatString('{0}.shape[{1}]', parentVar, dim);
                vpKernel.execute(cmd).then(function(resultObj) {
                    let { result } = resultObj;
                    try {
                        let dimLength = parseInt(result);
                        let ndList = [];
                        for (let i = 0; i < dimLength; i++) {
                            ndList.push({
                                value: i,
                                code: i,
                                type: 'int'
                            });
                        }
                        callback(ndList);
                    } catch (e) {
                        callback([]);
                    }
                });
            } else {
                callback([]);
            }
            
        }

        load() {
            $(this.frameSelector).html(this.render());
            this.bindEvent();
            this.bindDraggable();
        }

        getDataList() {
            var colTags = $(this.wrapSelector('.' + APP_SELECT_ITEM + '.added:not(.moving)'));
            var dataList = [];
            if (colTags.length > 0) {
                for (var i = 0; i < colTags.length; i++) {
                    var name = $(colTags[i]).data('name');
                    var type = $(colTags[i]).data('type');
                    var code = $(colTags[i]).data('code');
                    if (code) {
                        dataList.push({ name: name, type: type, code: code});                   
                    }
                }
            }
            return dataList;
        }

        render() {
            var that = this;

            var tag = new com_String();
            tag.appendLine('<label>Drag-and-drop columns to right to select.</label>');
            tag.appendFormatLine('<div class="{0} {1}">', APP_SELECT_CONTAINER, this.uuid);
            // select - left
            tag.appendFormatLine('<div class="{0}">', APP_SELECT_LEFT);
            // tag.appendFormatLine('<input type="text" class="{0}" placeholder="{1}"/>'
            //                         , APP_SELECT_SEARCH, 'Search Column');
            var vpSearchSuggest = new SuggestInput();
            vpSearchSuggest.addClass(APP_SELECT_SEARCH);
            vpSearchSuggest.addClass('vp-input');
            vpSearchSuggest.setPlaceholder('Search ' + this.mode);
            vpSearchSuggest.setSuggestList(function() { return that.dataList; });
            vpSearchSuggest.setSelectEvent(function(value) {
                $(this.wrapSelector()).val(value);
                $(this.wrapSelector()).trigger('change');
            });
            vpSearchSuggest.setNormalFilter(true);
            tag.appendLine(vpSearchSuggest.toTagString());
            tag.appendFormatLine('<i class="fa fa-search search-icon"></i>')
            
            var selectionList = this.dataList.filter(data => !that.selectedList.includes(data.code));
            tag.appendLine(this.renderSelectionBox(selectionList));
            tag.appendLine('</div>');  // APP_SELECT_LEFT
            // select - buttons
            tag.appendFormatLine('<div class="{0}">', APP_SELECT_BTN_BOX);
            // LAB: img to url
            // tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><img src="{2}"/></button>'
            //                     , APP_SELECT_ADD_ALL_BTN, 'Add all items', com_Const.IMAGE_PATH + 'arrow_right_double.svg');
            // tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><img src="{2}"/></button>'
            //                     ,  APP_SELECT_ADD_BTN, 'Add selected items', com_Const.IMAGE_PATH + 'arrow_right.svg');
            // tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><img src="{2}"/></button>'
            //                     , APP_SELECT_DEL_BTN, 'Remove selected items', com_Const.IMAGE_PATH + 'arrow_left.svg');
            // tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><img src="{2}"/></button>'
            //                     , APP_SELECT_DEL_ALL_BTN, 'Remove all items', com_Const.IMAGE_PATH + 'arrow_left_double.svg');
            tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><div class="vp-icon-arrow-right-double"></div></button>'
                                , APP_SELECT_ADD_ALL_BTN, 'Add all items');
            tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><div class="vp-icon-arrow-right"></div></button>'
                                ,  APP_SELECT_ADD_BTN, 'Add selected items');
            tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><div class="vp-icon-arrow-left"></div></button>'
                                , APP_SELECT_DEL_BTN, 'Remove selected items');
            tag.appendFormatLine('<button type="button" class="{0}" title="{1}"><div class="vp-icon-arrow-left-double"></div></button>'
                                , APP_SELECT_DEL_ALL_BTN, 'Remove all items');
            tag.appendLine('</div>');  // APP_SELECT_BTNS
            // select - right
            tag.appendFormatLine('<div class="{0}">', APP_SELECT_RIGHT);
            var selectedList = this.dataList.filter(data => that.selectedList.includes(data.code));
            tag.appendLine(this.renderSelectedBox(selectedList));
            tag.appendLine('</div>');  // APP_SELECT_RIGHT
            tag.appendLine('</div>');  // APP_SELECT_CONTAINER
            return tag.toString();
        }

        renderSelectionBox(dataList) {
            var tag = new com_String();
            tag.appendFormatLine('<div class="{0} {1} {2} {3}">', APP_SELECT_BOX, 'left', APP_DROPPABLE, 'no-selection vp-scrollbar');
            // get data and make draggable items
            dataList && dataList.forEach((data, idx) => {
                // for column : data.array parsing
                var info = com_util.safeString(data.array);
                if (info && info != 'undefined') {
                    info = data.value + ':\n' + info;
                } else {
                    info = '';
                }
                // render item box
                tag.appendFormatLine('<div class="{0} {1}" data-idx="{2}" data-name="{3}" data-type="{4}" data-code="{5}" title="{6}"><span>{7}</span></div>'
                                    , APP_SELECT_ITEM, APP_DRAGGABLE, data.location, data.value, data.type, data.code, info, data.value);
            });
            tag.appendLine('</div>');  // APP_SELECT_BOX
            return tag.toString();
        }

        renderSelectedBox(dataList) {
            var tag = new com_String();
            tag.appendFormatLine('<div class="{0} {1} {2} {3}">', APP_SELECT_BOX, 'right', APP_DROPPABLE, 'no-selection vp-scrollbar');
            // get data and make draggable items
            dataList && dataList.forEach((data, idx) => {
                // for column : data.array parsing
                var info = com_util.safeString(data.array);
                if (info) {
                    info = data.value + ':\n';
                } else {
                    info = '';
                }
                // render item box
                tag.appendFormatLine('<div class="{0} {1} {2}" data-idx="{3}" data-name="{4}" data-type="{5}" data-code="{6}" title="{7}"><span>{8}</span></div>'
                                    , APP_SELECT_ITEM, APP_DRAGGABLE, 'added', data.location, data.value, data.type, data.code, info, data.value);
            });
            tag.appendLine('</div>');  // APP_SELECT_BOX
            return tag.toString();
        }

        bindEvent() {
            var that = this;
            // item indexing - search
            $(this.wrapSelector('.' + APP_SELECT_SEARCH)).on('change', function(event) {
                var searchValue = $(this).val();
                
                // filter added items
                var addedTags = $(that.wrapSelector('.' + APP_SELECT_RIGHT + ' .' + APP_SELECT_ITEM + '.added'));
                var addedList = [];
                for (var i = 0; i < addedTags.length; i++) {
                    var value = $(addedTags[i]).attr('data-colname');
                    addedList.push(value);
                }
                var filteredList = that.dataList.filter(x => x.value.includes(searchValue) && !addedList.includes(x.value));

                // items indexing
                $(that.wrapSelector('.' + APP_SELECT_BOX + '.left')).replaceWith(function() {
                    return that.renderSelectionBox(filteredList);
                });

                // draggable
                that.bindDraggable();
            });

            // item indexing
            $(this.wrapSelector('.' + APP_SELECT_ITEM)).on('click', function(event) {
                var dataIdx = $(this).attr('data-idx');
                var idx = $(this).index();
                var added = $(this).hasClass('added'); // right side added item?
                var selector = '';

                // remove selection for select box on the other side
                if (added) {
                    // remove selection for left side
                    $(that.wrapSelector('.' + APP_SELECT_ITEM + ':not(.added)')).removeClass('selected');
                    // set selector
                    selector = '.added';
                } else {
                    // remove selection for right(added) side
                    $(that.wrapSelector('.' + APP_SELECT_ITEM + '.added')).removeClass('selected');
                    // set selector
                    selector = ':not(.added)';
                }

                if (vpEvent.keyManager.keyCheck.ctrlKey) {
                    // multi-select
                    that.pointer = { start: idx, end: -1 };
                    $(this).toggleClass('selected');
                } else if (vpEvent.keyManager.keyCheck.shiftKey) {
                    // slicing
                    var startIdx = that.pointer.start;
                    
                    if (startIdx == -1) {
                        // no selection
                        that.pointer = { start: idx, end: -1 };
                    } else if (startIdx > idx) {
                        // add selection from idx to startIdx
                        var tags = $(that.wrapSelector('.' + APP_SELECT_ITEM + selector));
                        for (var i = idx; i <= startIdx; i++) {
                            $(tags[i]).addClass('selected');
                        }
                        that.pointer = { start: startIdx, end: idx };
                    } else if (startIdx <= idx) {
                        // add selection from startIdx to idx
                        var tags = $(that.wrapSelector('.' + APP_SELECT_ITEM + selector));
                        for (var i = startIdx; i <= idx; i++) {
                            $(tags[i]).addClass('selected');
                        }
                        that.pointer = { start: startIdx, end: idx };
                    }
                } else {
                    // single-select
                    that.pointer = { start: idx, end: -1 };
                    // un-select others
                    $(that.wrapSelector('.' + APP_SELECT_ITEM + selector)).removeClass('selected');
                    // select this
                    $(this).addClass('selected');
                }
            });

            // item indexing - add all
            $(this.wrapSelector('.' + APP_SELECT_ADD_ALL_BTN)).on('click', function(event) {
                $(that.wrapSelector('.' + APP_SELECT_BOX + '.left .' + APP_SELECT_ITEM)).appendTo(
                    $(that.wrapSelector('.' + APP_SELECT_BOX + '.right'))
                );
                $(that.wrapSelector('.' + APP_SELECT_ITEM)).addClass('added');
                $(that.wrapSelector('.' + APP_SELECT_ITEM + '.selected')).removeClass('selected');
                that.pointer = { start: -1, end: -1 };
            });

            // item indexing - add
            $(this.wrapSelector('.' + APP_SELECT_ADD_BTN)).on('click', function(event) {
                var selector = '.selected';

                $(that.wrapSelector('.' + APP_SELECT_ITEM + selector)).appendTo(
                    $(that.wrapSelector('.' + APP_SELECT_BOX + '.right'))
                );
                $(that.wrapSelector('.' + APP_SELECT_ITEM + selector)).addClass('added');
                $(that.wrapSelector('.' + APP_SELECT_ITEM + selector)).removeClass('selected');
                that.pointer = { start: -1, end: -1 };
            });

            // item indexing - del
            $(this.wrapSelector('.' + APP_SELECT_DEL_BTN)).on('click', function(event) {
                var selector = '.selected';
                var targetBoxQuery = that.wrapSelector('.' + APP_SELECT_BOX + '.left');

                var selectedTag = $(that.wrapSelector('.' + APP_SELECT_ITEM + selector));
                selectedTag.appendTo(
                    $(targetBoxQuery)
                );
                // sort
                $(targetBoxQuery + ' .' + APP_SELECT_ITEM).sort(function(a, b) {
                    return ($(b).data('idx')) < ($(a).data('idx')) ? 1 : -1;
                }).appendTo(
                    $(targetBoxQuery)
                );
                selectedTag.removeClass('added');
                selectedTag.removeClass('selected');
                that.pointer = { start: -1, end: -1 };
            });

            // item indexing - delete all
            $(this.wrapSelector('.' + APP_SELECT_DEL_ALL_BTN)).on('click', function(event) {
                var targetBoxQuery = that.wrapSelector('.' + APP_SELECT_BOX + '.left');
                $(that.wrapSelector('.' + APP_SELECT_BOX + '.right .' + APP_SELECT_ITEM)).appendTo(
                    $(targetBoxQuery)
                );
                // sort
                $(targetBoxQuery + ' .' + APP_SELECT_ITEM).sort(function(a, b) {
                    return ($(b).data('idx')) < ($(a).data('idx')) ? 1 : -1;
                }).appendTo(
                    $(targetBoxQuery)
                );
                $(that.wrapSelector('.' + APP_SELECT_ITEM)).removeClass('added');
                $(that.wrapSelector('.' + APP_SELECT_ITEM + '.selected')).removeClass('selected');
                that.pointer = { start: -1, end: -1 };
            });
        }

        bindDraggable() {
            var that = this;
            var draggableQuery = this.wrapSelector('.' + APP_DRAGGABLE);
            var droppableQuery = this.wrapSelector('.' + APP_DROPPABLE);
    
            $(draggableQuery).draggable({
                // containment: '.select-' + type + ' .' + APP_DROPPABLE,
                // appendTo: droppableQuery,
                // snap: '.' + APP_DRAGGABLE,
                revert: 'invalid',
                cursor: 'pointer',
                connectToSortable: droppableQuery + '.right',
                // cursorAt: { bottom: 5, right: 5 },
                helper: function() {
                    // selected items
                    var widthString = parseInt($(this).outerWidth()) + 'px';
                    var selectedTag = $(this).parent().find('.selected');
                    if (selectedTag.length <= 0) {
                        selectedTag = $(this);
                    }
                    return $('<div></div>').append(selectedTag.clone().addClass('moving').css({ 
                        width: widthString, border: '0.25px solid #C4C4C4'
                    }));
                }
            });

            $(droppableQuery).droppable({
                accept: draggableQuery,
                drop: function(event, ui) {
                    var dropped = ui.draggable;
                    var droppedOn = $(this);
    
                    // is dragging on same droppable container?
                    if (droppedOn.get(0) == $(dropped).parent().get(0)) {
                        
                        return ;
                    }
    
                    var dropGroup = $(dropped).parent().find('.selected:not(.moving)');
                    // if nothing selected(as orange_text), use dragging item
                    if (dropGroup.length <= 0) {
                        dropGroup = $(dropped);
                    }
                    $(dropGroup).detach().css({top:0, left:0}).appendTo(droppedOn);
    
                    if ($(this).hasClass('right')) {
                        // add
                        $(dropGroup).addClass('added');
                    } else {
                        // del
                        $(dropGroup).removeClass('added');
                        // sort
                        $(droppedOn).find('.' + APP_SELECT_ITEM).sort(function(a, b) {
                            return ($(b).data('idx')) < ($(a).data('idx')) ? 1 : -1;
                        }).appendTo( $(droppedOn) );
                    }
                    // remove selection
                    $(droppableQuery).find('.selected').removeClass('selected');
                    that.pointer = { start: -1, end: -1 };
                },
                over: function(event, elem) {
                },
                out: function(event, elem) {
                }
            });
        }
    }

    return MultiSelector;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/* End of file */

/***/ }),

/***/ "./lib/visualpython/js/com/component/NumpyComponent.js":
/*!*************************************************************!*\
  !*** ./lib/visualpython/js/com/component/NumpyComponent.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : NumpyComponent.js
 *    Author          : Black Logic
 *    Note            : Library Component
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] NumpyComponent
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/m_library/numpyComponent.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/m_library/numpyComponent.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/m_library/numpyComponent.css */ "./lib/visualpython/css/m_library/numpyComponent.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/component/PopupComponent */ "./lib/visualpython/js/com/component/PopupComponent.js"),
    __webpack_require__(/*! vp_base/js/com/com_generatorV2 */ "./lib/visualpython/js/com/com_generatorV2.js"),
    __webpack_require__(/*! vp_base/data/m_library/numpyLibrary */ "./lib/visualpython/data/m_library/numpyLibrary.js"),
    __webpack_require__(/*! vp_base/data/m_library/pythonLibrary */ "./lib/visualpython/data/m_library/pythonLibrary.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(libHtml, libCss, PopupComponent, com_generatorV2, numpyLibrary, pythonLibrary) {

    /**
     * NumpyComponent
     */
    class NumpyComponent extends PopupComponent {
        _init() {
            super._init();
            /** Write codes executed before rendering */
            this.config.dataview = false;
            this.config.sizeLevel = 1;
            
            this.packageId = this.state.config.id;
            // deep copy package info
            this.package = null;
            try {
                let packageName = this.state.config.path.split(' - ')[2];
                let findPackage = null;
                if (packageName == 'numpy') {
                    findPackage = numpyLibrary.NUMPY_LIBRARIES[this.packageId];
                } else if (packageName == 'python') {
                    findPackage = pythonLibrary.PYTHON_LIBRARIES[this.packageId];
                }
                if (findPackage) {
                    this.package = JSON.parse(JSON.stringify(findPackage)); // deep copy of package
                } else {
                    throw 'Cannot find package';
                }
            } catch(err) {
                vpLog.display(VP_LOG_TYPE.ERROR, 'Cannot find package id from library: ' + this.packageId);
                return;
            }
            this.config.checkModules = ['np'];

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'loading state', this.state);
        }

        _bindEvent() {
            super._bindEvent();
            /** Implement binding events */
            var that = this;
            // save change of vp-state component
            $(this.wrapSelector('.vp-state')).on('change', function() {
                let id = $(this)[0].id;
                let val = $(this).val();
                that.state[id] = val;
            });
        }

        loadState() {
            vpLog.display(VP_LOG_TYPE.DEVELOP, this.state);   

            let that = this;
            Object.keys(this.state).forEach(key => {
                if (key !== 'config') {
                    let tag = $(that.wrapSelector('#' + key));
                    let tagName = $(tag).prop('tagName');
                    let savedValue = that.state[key];
                    switch(tagName) {
                        case 'INPUT':
                            let inputType = $(tag).prop('type');
                            if (inputType == 'text' || inputType == 'number' || inputType == 'hidden') {
                                $(tag).val(savedValue);
                                break;
                            }
                            if (inputType == 'checkbox') {
                                $(tag).prop('checked', savedValue);
                                break;
                            }
                            break;
                        case 'TEXTAREA':
                        case 'SELECT':
                        default:
                            $(tag).val(savedValue);
                            break;
                    }
                }
            });
        }

        saveState() {
            let that = this;
            $(this.wrapSelector('.vp-state')).each((idx, tag) => {
                let id = tag.id;
                let tagName = $(tag).prop('tagName');
                let newValue = '';
                switch(tagName) {
                    case 'INPUT':
                        let inputType = $(tag).prop('type');
                        if (inputType == 'text' || inputType == 'number' || inputType == 'hidden') {
                            newValue = $(tag).val();
                            break;
                        }
                        if (inputType == 'checkbox') {
                            newValue = $(tag).prop('checked');
                            break;
                        }
                        break;
                    case 'TEXTAREA':
                    case 'SELECT':
                    default:
                        newValue = $(tag).val();
                        break;
                }
                
                that.state[id] = newValue;
            }); 
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'savedState', that.state);   
        }

        templateForBody() {
            return libHtml;
        }

        render() {
            super.render();

            // show interface
            com_generatorV2.vp_showInterfaceOnPage(this, this.package, this.state);

            // hide required page if no options
            if ($.trim($(this.wrapSelector('#vp_inputOutputBox table tbody')).html())=='') {
                $(this.wrapSelector('.vp-require-box')).hide();
            }

            // hide optional page if no options
            if ($.trim($(this.wrapSelector('#vp_optionBox table tbody')).html())=='') {
                $(this.wrapSelector('.vp-option-box')).hide();
            }
        }

        open() {
            super.open();
            // hide optional page if no options
            if ($.trim($(this.wrapSelector('#vp_optionBox table tbody')).html())=='') {
                $(this.wrapSelector('.vp-option-box')).hide();
            }
        }

        generateCode() {
            let code = com_generatorV2.vp_codeGenerator(this, this.package, this.state);
            return code;
        }

    }

    return NumpyComponent;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/PopupComponent.js":
/*!*************************************************************!*\
  !*** ./lib/visualpython/js/com/component/PopupComponent.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : PopupComponent.js
 *    Author          : Black Logic
 *    Note            : Popup Components for rendering objects
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] PopupComponent
//============================================================================
// CHROME: notebook/js/codemirror-ipython
(function(mod) {
    if (true){ // CommonJS
        if (vpExtType === 'lab') {
            mod(__webpack_require__(/*! codemirror/lib/codemirror */ "./lib/visualpython/lib/codemirror/lib/codemirror.js"),
            __webpack_require__(/*! codemirror/mode/python/python */ "./lib/visualpython/lib/codemirror/mode/python/python.js")
            );
        } else {
            mod(requirejs("codemirror/lib/codemirror"),
                requirejs("codemirror/mode/python/python")
            );
        }
    } else {}
})(function(CodeMirror) {
    "use strict";

    CodeMirror.defineMode("ipython", function(conf, parserConf) {
        var pythonConf = {};
        for (var prop in parserConf) {
            if (parserConf.hasOwnProperty(prop)) {
                pythonConf[prop] = parserConf[prop];
            }
        }
        pythonConf.name = 'python';
        pythonConf.singleOperators = new RegExp("^[\\+\\-\\*/%&|@\\^~<>!\\?]");
        if (pythonConf.version === 3) {
            pythonConf.identifiers = new RegExp("^[_A-Za-z\u00A1-\uFFFF][_A-Za-z0-9\u00A1-\uFFFF]*");
        } else if (pythonConf.version === 2) {
            pythonConf.identifiers = new RegExp("^[_A-Za-z][_A-Za-z0-9]*");
        }
        return CodeMirror.getMode(conf, pythonConf);
    }, 'python');

    CodeMirror.defineMIME("text/x-ipython", "ipython");
});

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/component/popupComponent.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/component/popupComponent.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/component/popupComponent.css */ "./lib/visualpython/css/component/popupComponent.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! ../com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! ../com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! ../com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! ../com_interface */ "./lib/visualpython/js/com/com_interface.js"),
    __webpack_require__(/*! ./Component */ "./lib/visualpython/js/com/component/Component.js"),
    __webpack_require__(/*! ./DataSelector */ "./lib/visualpython/js/com/component/DataSelector.js"),

    /** codemirror */
    __webpack_require__(/*! codemirror/lib/codemirror */ "./lib/visualpython/lib/codemirror/lib/codemirror.js"),
    __webpack_require__(/*! codemirror/mode/python/python */ "./lib/visualpython/lib/codemirror/mode/python/python.js"),
    __webpack_require__(/*! codemirror/addon/display/placeholder */ "./lib/visualpython/lib/codemirror/addon/display/placeholder.js"),
    __webpack_require__(/*! codemirror/addon/display/autorefresh */ "./lib/visualpython/lib/codemirror/addon/display/autorefresh.js"),
    // 'notebook/js/codemirror-ipython' // LAB: disabled to avoid error FIXME:
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(popupComponentHtml, popupComponentCss
    , com_util, com_Const, com_String, com_interface, Component, DataSelector, codemirror
) {
    'use strict';

    //========================================================================
    // Declare class
    //========================================================================
    /**
     * Component
     */
    class PopupComponent extends Component {
        constructor(state={ config: { id: 'popup', name: 'Popup title', path: 'path/file' }}, prop={}) {
            // CHROME: FIXME: #site -> .notebook-vertical
            // super($('#site'), state, prop);
            super($(vpConfig.parentSelector), state, prop);
        }

        _init() {
            this.eventTarget = '#vp_wrapper';
            this.id = this.state.config.id;
            this.name = this.state.config.name;
            this.path = this.state.config.path;
            

            this.config = {
                sizeLevel: 0,          // 0: 400x400 / 1: 500x500 / 2: 600x500 / 3: 750x500
                executeMode: 'code',   // cell execute mode
                // show header bar buttons
                installButton: false, // install button (#popupInstall) // FIXME: after creating packagemanager, deprecate it
                importButton: false,  // import library button (#popupImport)
                packageButton: false, // package manager button (#popupPackage)
                // show view box
                codeview: true, 
                dataview: true,
                // show footer
                runButton: true,
                footer: true,
                position: { right: 10, top: 120 },
                size: { width: 400, height: 550 },
                saveOnly: false,
                checkModules: [] // module aliases or function names
            };

            // check BoardFrame width and set initial position of popup
            let boardWidth = $('#vp_boardFrame').width();
            this.config.position.right = boardWidth + 10;

            this.cmPythonConfig = {
                mode: {
                    name: 'python',
                    version: 3,
                    singleLineStringErrors: false
                },
                height: '100%',
                width: '100%',
                indentUnit: 4,
                lineNumbers: true,
                matchBrackets: true,
                autoRefresh: true,
                theme: "ipython",
                extraKeys: {"Enter": "newlineAndIndentContinueMarkdownList"}
            }
            this.cmReadonlyConfig = {
                ...this.cmPythonConfig,
                readOnly: true,
                lineNumbers: false,
                scrollbarStyle: "null"
            }

            this.cmCodeview = null;

            this.cmCodeList = [];
        }

        wrapSelector(selector='') {
            var sbSelector = new com_String();
            var cnt = arguments.length;
            if (cnt < 2) {
                // if there's no more arguments
                sbSelector.appendFormat(".vp-popup-frame.{0} {1}", this.uuid, selector);
            } else {
                // if there's more arguments
                sbSelector.appendFormat(".vp-popup-frame.{0}", this.uuid);
                for (var idx = 0; idx < cnt; idx++) {
                    sbSelector.appendFormat(" {0}", arguments[idx]);
                }
            }
            return sbSelector.toString();
        }

        /**
         * Add codemirror object
         * usage: 
         *  this._addCodemirror('code', this.wrapSelector('#code'));
         * @param {String} key stateKey
         * @param {String} selector textarea class name
         * @param {boolean} type code(python)/readonly/markdown
         * @param {Object} etcOpt { events:[{key, callback}, ...] }
         * @returns Object { key, selector, type, cm, ... }
         */
        _addCodemirror(key, selector, type='code', etcOpt={}) {
            this.cmCodeList.push({ key: key, selector: selector, type: type, cm: null, ...etcOpt });
            return this.cmCodeList[this.cmCodeList.length - 1];
        }

        /**
         * bind codemirror
         * @param {string} selector 
         */
        _bindCodemirror() {
            // codemirror editor (if available)
            for (let i = 0; i < this.cmCodeList.length; i++) {
                let cmObj = this.cmCodeList[i];
                if (cmObj.cm == null) {
                    let cm = this.initCodemirror(cmObj);
                    cmObj.cm = cm;
                }
            }

            // code view
            if (this.config.codeview) {
                if (!this.cmCodeview) {
                    // codemirror setting
                    let selector = this.wrapSelector('.vp-popup-codeview-box textarea');
                    let textarea = $(selector);
                    if (textarea && textarea.length > 0) {
                        this.cmCodeview = codemirror.fromTextArea(textarea[0], this.cmReadonlyConfig);
                    } else {
                        vpLog.display(VP_LOG_TYPE.ERROR, 'No text area to create codemirror. (selector: '+selector+')');
                    }
                } else {
                    this.cmCodeview.refresh();
                }
            }
        }

        /**
         * Initialize codemirror
         * @param {Object} cmObj { key, selector, type, ... }
         *  - key      : key to save its value as state (this.state[key])
         *  - selector : selector to distinguish codemirror tag (textarea)
         *    ex) this.wrapSelector('.cm-tag')
         *  - type     : code / readonly / markdown
         *  - events   : list of event objects
         *    ex) [{ key: 'change', callback: function() { ; } }]
         */
        initCodemirror(cmObj) {
            let {key, selector, type, events} = cmObj;
            let that = this;

            let cmCode = null;
            let targetTag = $(selector);
            let cmConfig = this.cmPythonConfig;
            if (type == 'readonly') {
                cmConfig = {
                    ...cmConfig,
                    readOnly: true,
                    lineNumbers: false,
                    scrollbarStyle: "null"
                }
            } else if (type == 'markdown') {
                cmConfig = {
                    ...cmConfig,
                    mode: 'markdown'
                }
            }
            
            if (targetTag && targetTag.length > 0) {
                cmCode = codemirror.fromTextArea(targetTag[0], cmConfig);
                if (cmCode) {
                    // add class on text area
                    if (type != 'readonly') {
                        $(selector).parent().find('.CodeMirror').addClass('vp-writable-codemirror');
                    }
                    cmCode.on('focus', function() {
                        // disable other shortcuts
                        com_interface.disableOtherShortcut();
                    });
                    cmCode.on('blur', function(instance, evt) {
                        // enable other shortcuts
                        com_interface.enableOtherShortcut();
                        // instance = codemirror
                        // save its code to textarea component
                        instance.save();
                        that.state[key] = targetTag.val();
                    });
                    // bind events
                    events && events.forEach(evObj => {
                        cmCode.on(evObj.key, evObj.callback);
                    });
                    vpLog.display(VP_LOG_TYPE.DEVELOP, key, cmCode);
                }
            } else {
                vpLog.display(VP_LOG_TYPE.ERROR, 'No text area to bind codemirror. (selector: '+selector+')');
            }

            return cmCode;
        }

        setCmValue(key, value) {
            let targetCmObj = this.cmCodeList.filter(obj => obj.key == key);
            if (targetCmObj.length > 0) {
                let cm = targetCmObj[0].cm;
                if (cm) {
                    cm.setValue(value);
                    cm.save();
                    setTimeout(function () {
                        cm.refresh();
                    }, 1);
                }
            }
        }

        _bindEvent() {
            var that = this;
            // Close popup event
            $(this.wrapSelector('.vp-popup-close')).on('click', function(evt) {
                if (that.getTaskType() === 'task') {
                    $(that.eventTarget).trigger({
                        type: 'remove_option_page',
                        component: that
                    });
                } else {
                    // if it's block, just hide it
                    $(that.eventTarget).trigger({
                        type: 'close_option_page',
                        component: that
                    });
                }
            });
            // Toggle operation (minimize)
            $(this.wrapSelector('.vp-popup-toggle')).on('click', function(evt) {
                $(that.eventTarget).trigger({
                    type: 'close_option_page',
                    component: that
                });
            });
            // Maximize operation
            $(this.wrapSelector('.vp-popup-maximize')).on('click', function(evt) {
                // save position
                that.config.position = $(that.wrapSelector()).position();
                // save size
                that.config.size = {
                    width: $(that.wrapSelector()).width(),
                    height: $(that.wrapSelector()).height()
                }
                // maximize popup
                $(that.wrapSelector()).css({
                    width: '100%',
                    height: '100%',
                    top: 0,
                    left: 0
                });
                // show / hide buttons
                $(this).hide();
                $(that.wrapSelector('.vp-popup-return')).show();
            });
            // Return operation
            $(this.wrapSelector('.vp-popup-return')).on('click', function(evt) {
                // return size
                $(that.wrapSelector()).css({
                    width: that.config.size.width + 'px',
                    height: that.config.size.height + 'px',
                    top: that.config.position.top,
                    left: that.config.position.left
                });
                // show / hide buttons
                $(this).hide();
                $(that.wrapSelector('.vp-popup-maximize')).show();
            });

            // Click install package
            $(this.wrapSelector('#popupInstall')).on('click', function() {
                // add install codes
                var codes = that.generateInstallCode();
                codes && codes.forEach(code => {
                    com_interface.insertCell('code', code, true, that.getSigText());
                });
            });

            // Click import library
            $(this.wrapSelector('#popupImport')).on('click', function() {
                // add import codes
                var codes = that.generateImportCode();
                codes && codes.forEach(code => {
                    // create block and run it
                    $('#vp_wrapper').trigger({
                        type: 'create_option_page', 
                        blockType: 'block',
                        menuId: 'lgExe_code',
                        menuState: { taskState: { code: code } },
                        afterAction: 'run'
                    });
                });
            });

            // Click package manager
            $(this.wrapSelector('#popupPackage')).on('click', function() {
                // TODO:
            });


            // Focus recognization
            $(this.wrapSelector()).on('click', function() {
                $(that.eventTarget).trigger({
                    type: 'focus_option_page',
                    component: that
                });
            });

            // save state values
            $(document).on('change', this.wrapSelector('.vp-state'), function() {
                that._saveSingleState($(this)[0]);
            });

            // Click buttons
            $(this.wrapSelector('.vp-popup-button')).on('click', function(evt) {
                var btnType = $(this).data('type');
                switch(btnType) {
                    case 'code':
                        if ($(that.wrapSelector('.vp-popup-codeview-box')).is(':hidden')) {
                            that.openView('code');
                        } else {
                            that.closeView('code');
                        }
                        evt.stopPropagation();
                        break;
                    case 'data':
                        if ($(that.wrapSelector('.vp-popup-dataview-box')).is(':hidden')) {
                            that.openView('data');
                        } else {
                            that.closeView('data');
                        }
                        evt.stopPropagation();
                        break;
                    case 'cancel':
                        if (that.getTaskType() === 'task') {
                            $(that.eventTarget).trigger({
                                type: 'remove_option_page',
                                component: that
                            });
                        } else {
                            // if it's block, just hide it
                            $(that.eventTarget).trigger({
                                type: 'close_option_page',
                                component: that
                            });
                        }
                        break;
                    case 'run':
                        let result = that.run();
                        if (result) {
                            that.save();
                        }
                        break;
                    case 'show-detail':
                        $(that.wrapSelector('.vp-popup-run-detailbox')).show();
                        evt.stopPropagation();
                        break;
                    case 'save':
                        that.save();
                        break;
                }
            });
            // Click detail buttons
            $(this.wrapSelector('.vp-popup-detail-button')).on('click', function(evt) {
                var btnType = $(this).data('type');
                switch(btnType) {
                    case 'apply':
                        that.save();
                        break;
                    case 'add':
                        let result = that.run(false);
                        if (result) {
                            that.save();
                        }
                        break;
                }
            });
            // Close event for inner popup
            $(this.wrapSelector('.vp-inner-popup-close')).on('click', function(evt) {
                that.closeInnerPopup();
            });
            // Click button event for inner popup
            $(this.wrapSelector('.vp-inner-popup-button')).on('click', function(evt) {
                let btnType = $(this).data('type');
                switch(btnType) {
                    case 'cancel':
                        that.closeInnerPopup();
                        break;
                    case 'ok':
                        that.handleInnerOk();
                        break;
                }
            });

            // focus on data selector input
            $(this.wrapSelector('.vp-data-selector')).on('focus', function(evt) {
                
            });

            // click on data selector input filter
            $(this.wrapSelector('.vp-data-selector')).on('click', function(evt) {

            });
        }

        _unbindEvent() {
            $(document).off('change', this.wrapSelector('.vp-state'));
        }

        _bindDraggable() {
            var that = this;
            let containment = 'body';
            if (vpConfig.extensionType === 'lab') {
                containment = '#main';
            }
            $(this.wrapSelector()).draggable({
                handle: '.vp-popup-title',
                containment: containment,
                start: function(evt, ui) {
                    // check focused
                    $(that.eventTarget).trigger({
                        type: 'focus_option_page',
                        component: that
                    });
                }
            });

            // inner popup draggable
            $(this.wrapSelector('.vp-inner-popup-box')).draggable({
                handle: '.vp-inner-popup-title',
                containment: 'parent'
            });
        }

        _unbindResizable() {
            $(this.wrapSelector()).resizable('disable');
        }

        _bindResizable() {
            let that = this;
            $(this.wrapSelector()).resizable({
                handles: 'all',
                start: function(evt, ui) {
                    // show / hide buttons
                    $(that.wrapSelector('.vp-popup-return')).hide();
                    $(that.wrapSelector('.vp-popup-maximize')).show();
                }
            });
        }

        templateForBody() {
            /** Implementation needed */
            return '';
        }

        template() { 
            this.$pageDom = $(popupComponentHtml.replaceAll('${vp_base}', com_Const.BASE_PATH));
            // set title
            this.$pageDom.find('.vp-popup-title').text(this.name);
            // set body
            let bodyTemplate = this.templateForBody();
            // CHROME: check url keyword and replace it
            if (bodyTemplate) {
                if (typeof bodyTemplate === 'string') {
                    // string replacement
                    bodyTemplate = bodyTemplate.replaceAll('${vp_base}', com_Const.BASE_PATH);
                } else {
                    // object = jquery object

                }
            }
            this.$pageDom.find('.vp-popup-content').html(bodyTemplate);
            return this.$pageDom;
        }

        /**
         * Render page
         * @param {Object} config configure whether to use buttons or not 
         */
        render(inplace=false) {
            super.render(inplace);

            let { 
                installButton, importButton, packageButton, 
                codeview, dataview, runButton, footer, 
                sizeLevel, position
            } = this.config;

            // import & package manager button hide/show
            if (!installButton) { // FIXME: Deprecated after creating package manager
                $(this.wrapSelector('#popupInstall')).hide();
            }
            if (!importButton) {
                $(this.wrapSelector('#popupImport')).hide();
            }
            if (!packageButton) {
                $(this.wrapSelector('#popupPackage')).hide();
            }
            if (installButton || importButton || packageButton) {
                // resize height
                $(this.wrapSelector('.vp-popup-content')).css({
                    'height': 'calc(100% - 30px)'
                });
            } else {
                $(this.wrapSelector('.vp-popup-content')).css({
                    'height': '100%'
                });
            }

            // codeview & dataview button hide/show
            if (!codeview) {
                $(this.wrapSelector('.vp-popup-button[data-type="code"]')).hide();
            } 
            if (!dataview) {
                $(this.wrapSelector('.vp-popup-button[data-type="data"]')).hide();
            }

            // run button
            if (!runButton) {
                $(this.wrapSelector('.vp-popup-runadd-box')).hide();
            }

            // footer
            if(!footer) {
                $(this.wrapSelector('.vp-popup-footer')).hide();
                // set body wider
                $(this.wrapSelector('.vp-popup-body')).css({
                    'height': 'calc(100% - 30px)'
                })
            }

            // popup-frame size
            switch (sizeLevel) {
                case 1: 
                    this.config.size = { width: 500, height: 550 };
                    break;
                case 2: 
                    this.config.size = { width: 600, height: 550 };
                    break;
                case 3: 
                    this.config.size = { width: 760, height: 550 };
                    break;
            }

            // set detailed size
            $(this.wrapSelector()).css({
                width: this.config.size.width + 'px',
                height: this.config.size.height + 'px'
            });

            // position
            $(this.wrapSelector()).css({ top: position.top, right: position.right });

            // set apply mode
            if (this.config.saveOnly) {
                this.setSaveOnlyMode();
            }

            this._bindDraggable();
            this._bindResizable();
        }
        
        templateForInnerPopup() {
            /** Implementation needed */
            return '';
        }
        
        /**
         * Render inner popup for selecting columns
         * @returns Inner popup page dom
         */
        renderInnerPopup() {
            $(this.wrapSelector('.vp-inner-popup-body')).html(this.templateForInnerPopup());


            // set position to center
            let width = $(this.wrapSelector('.vp-inner-popup-box')).width();
            let height = $(this.wrapSelector('.vp-inner-popup-box')).height();

            $(this.wrapSelector('.vp-inner-popup-box')).css({
                left: 'calc(50% - ' + parseInt(width/2) + 'px)',
                top: 'calc(50% - ' + parseInt(height/2) + 'px)',
            })
        }

        templateForDataView() {
            /** Implementation needed */
            return '';
        }

        renderDataView() {
            $('.vp-popup-dataview-box').html('');
            $('.vp-popup-dataview-box').html(this.templateForDataView());
        }

        /**
         * Generated on clicking Install Package button
         * @returns Array of installment codes
         */
        generateInstallCode() {
            /** Implementation needed - Generated on clicking Install Package button */
            return [];
        }

        generateImportCode() {
            /** Implementation needed - Generated on clicking Import Library button */
            return [];
        }

        generateCode() {
            /** Implementation needed */
            return '';
        }

        load() {
            
        }

        loadState() {
            /** Implementation needed */
        }

        saveState() {
            /** Implementation needed */
            let that = this;
            $(this.wrapSelector('.vp-state')).each((idx, tag) => {
                that._saveSingleState(tag);
            }); 
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'savedState', that.state);   
        }

        _saveSingleState(tag) {
            let id = tag.id;
            let customKey = $(tag).data('key');
            let tagName = $(tag).prop('tagName'); // returns with UpperCase
            let newValue = '';
            switch(tagName) {
                case 'INPUT':
                    let inputType = $(tag).prop('type');
                    if (inputType == 'checkbox') {
                        newValue = $(tag).prop('checked');
                    } else {
                        // inputType == 'text' || inputType == 'number' || inputType == 'hidden' || inputType == 'color' || inputType == 'range'
                        newValue = $(tag).val();
                    }
                    break;
                case 'TEXTAREA':
                case 'SELECT':
                default:
                    newValue = $(tag).val();
                    if (!newValue) {
                        newValue = '';
                    }
                    break;
            }
            
            // if custom key is available, use it
            if (customKey && customKey != '') {
                // allow custom key until level 2
                let customKeys = customKey.split('.');
                if (customKeys.length == 2) {
                    this.state[customKeys[0]][customKeys[1]] = newValue;
                } else {
                    this.state[customKey] = newValue;
                }
            } else {
                this.state[id] = newValue;
            }
        }

        getSigText() {
            let sigText = '';
            if (this.getTaskType() == 'block') {
                let block = this.taskItem;
                sigText = block.sigText;
            } else {
                try {
                    let menuGroup = this.path.split(' - ')[1];
                    let menuGroupLabel = vpConfig.getMenuGroupLabel(menuGroup);
                    if (menuGroupLabel != undefined && menuGroupLabel !== '') {
                        sigText = menuGroupLabel + ' > ' + this.name;
                    } else {
                        sigText = this.name;
                    }
                } catch {}
            }
            return sigText;
        }

        /**
         * Check if required option is filled
         * @returns true if it's ok / false if there is empty required option
         */
        checkRequiredOption() {
            let requiredFilled = true;
            let requiredTags = $(this.wrapSelector('input[required=true]') + ',' + this.wrapSelector('input[required=required]'));

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'checkRequiredOption', this, requiredTags);

            if (requiredTags) {
                for (let i = 0; i < requiredTags.length; i++) {
                    let thisTag = $(requiredTags[i]);
                    // if it's visible and empty, focus on it
                    if (thisTag.is(':visible') && thisTag.val() == '') {
                        $(requiredTags[i]).focus();
                        requiredFilled = false;
                        break;
                    }
                }
            }

            return requiredFilled;
        }

        checkAndRunModules(execute=true, background=false) {
            let sigText = this.getSigText();

            let checkModules = this.config.checkModules;
            return new Promise(function(resolve, reject) {
                // CHROME: TODO: 9: checkmodule works strange...
                if (checkModules.length > 0) {
                    vpKernel.checkModule(checkModules).then(function(resultObj) {
                        let { result } = resultObj;
                        vpLog.display(VP_LOG_TYPE.DEVELOP, resultObj);
                        let checkedList = JSON.parse(result);
                        let executeList = [];
                        checkedList && checkedList.forEach((mod, idx) => {
                            if (mod == false) {
                                let modInfo = vpConfig.getModuleCode(checkModules[idx]);
                                if (modInfo) {
                                    executeList.push(modInfo.code);
                                }
                            }
                        });
                        if (executeList && executeList.length > 0) {
                            com_interface.insertCell('code', executeList.join('\n'), execute, sigText);
                        }
                        resolve(executeList);
                    });
                } else {
                    resolve([]);
                }
                // resolve([]);
            });
        }

        run(execute=true, addcell=true) {
            // check required
            if (this.checkRequiredOption() === false) {
                return false;
            }

            let mode = this.config.executeMode;
            let sigText = this.getSigText();
            let code = this.generateCode();

            vpLog.display(VP_LOG_TYPE.DEVELOP, sigText, mode, code);

            // check modules
            this.checkAndRunModules(execute).then(function(executeList) {
                if (addcell) {
                    if (Array.isArray(code)) {
                        // insert cells if it's array of codes
                        com_interface.insertCells(mode, code, execute, sigText);
                    } else {
                        com_interface.insertCell(mode, code, execute, sigText);
                    }
                }
            });
            return true;
        }

        /**
         * Open popup
         * - show popup
         * - focus popup
         * - bind codemirror
         */
        open() {
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'open popup', this);
            this.loadState();
            
            this.show();

            // set popup position if its top-left side is outside of view
            let pos = $(this.wrapSelector()).position();
            if (pos) {
                if (pos.top < 0) {
                    $(this.wrapSelector()).css({ top: 0 });
                }
                if (pos.left < 0) {
                    $(this.wrapSelector()).css({ left: 0 });
                }
            }

            this._bindCodemirror();

            $(this.eventTarget).trigger({
                type: 'focus_option_page',
                component: this
            });
        }

        setSaveOnlyMode() {
            // show save button only
            $(this.wrapSelector('.vp-popup-runadd-box')).hide();
            $(this.wrapSelector('.vp-popup-save-button')).show();
        }

        /**
         * Close popup
         * - remove popup
         * - unbind event
         */
        close() {
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'close popup', this);
            this.saveState();
            this.hide();
        }

        save() {
            $(this.eventTarget).trigger({
                type: 'apply_option_page', 
                blockType: 'block',
                component: this
            });
        }

        remove() {
            vpLog.display(VP_LOG_TYPE.DEVELOP, 'remove popup', this);
            this._unbindEvent();
            $(this.wrapSelector()).remove();
        }

        focus() {
            $('.vp-popup-frame').removeClass('vp-focused');
            $('.vp-popup-frame').css({ 'z-index': 1200 });
            $(this.wrapSelector()).addClass('vp-focused');
            $(this.wrapSelector()).css({ 'z-index': 1205 }); // move forward
            // focus on its block
            if (this.taskItem) {
                this.taskItem.focusItem();
            }
        }

        blur() {
            $(this.wrapSelector()).removeClass('vp-focused');
        }

        show() {
            this.taskItem && this.taskItem.focusItem();
            $(this.wrapSelector()).show();
        }

        hide() {
            this.taskItem && this.taskItem.blurItem();
            $(this.wrapSelector()).hide();
        }

        isHidden() {
            return !$(this.wrapSelector()).is(':visible');
        }

        /**
         * minimize and maximize
         */
        toggle() {
            let $this = $(this.wrapSelector());
            let isClosed = $this.hasClass('vp-close');
            if (isClosed) {
                // show
                $this.removeClass('vp-close');
                $(this.wrapSelector('.vp-popup-toggle')).attr('src', com_Const.IMAGE_PATH + 'tri_down_fill_dark.svg');
            } else {
                // hide
                $this.addClass('vp-close');
                $(this.wrapSelector('.vp-popup-toggle')).attr('src', com_Const.IMAGE_PATH + 'tri_right_fill_dark.svg');
            }
        }

        /**
         * Open view
         * @param {*} viewType code / data
         */
        openView(viewType) {
            if (viewType == 'code') {
                this.saveState();
                var code = this.generateCode();
                let codeText = '';
                if (Array.isArray(code)) {
                    codeText = code.join('\n');
                } else {
                    codeText = code;
                }
                this.cmCodeview.setValue(codeText);
                this.cmCodeview.save();
                
                var that = this;
                setTimeout(function() {
                    that.cmCodeview.refresh();
                }, 1);
                $(this.wrapSelector('.vp-popup-dataview-box')).hide();
            } else {
                this.renderDataView();
                $(this.wrapSelector('.vp-popup-codeview-box')).hide();
            }

            $(this.wrapSelector('.vp-popup-'+viewType+'view-box')).show();
        }

        closeView(viewType) {
            $(this.wrapSelector('.vp-popup-'+viewType+'view-box')).hide();
        }

        /**
         * Open inner popup box
         */
        openInnerPopup(title) {
            $(this.wrapSelector('.vp-inner-popup-title')).text(title);
            $(this.wrapSelector('.vp-inner-popup-box')).show();

            // focus on first input
            $(this.wrapSelector('.vp-inner-popup-box input:not(:disabled):visible:first')).focus();
            // disable Jupyter key
            com_interface.disableOtherShortcut();
        }
        
        /**
         * Close inner popup box
         */
        closeInnerPopup() {
            this.handleInnerCancel();
            $(this.wrapSelector('.vp-inner-popup-box')).hide();
        }

        handleInnerCancel() {
            /** Implementation needed */
        }

        handleInnerOk() {
            /** Implementation needed */
        }

        //========================================================================
        // Get / set
        //========================================================================
        getCodemirror(key) {
            let filteredCm = this.cmCodeList.find(cmObj => cmObj.key == key);
            return filteredCm;
        }

        //========================================================================
        // Control task item 
        //========================================================================
        setTaskItem(taskItem) {
            this.taskItem = taskItem;
        }

        getTaskType() {
            if (this.taskItem) {
                if (this.taskItem.constructor.name == 'Block') {
                    return 'block';
                }
                if (this.taskItem.constructor.name == 'TaskItem') {
                    return 'task';
                }
            }
            return null;
        }

        removeBlock() {
            this.taskItem && this.taskItem.removeItem();
        }
    }

    return PopupComponent;

}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/* End of file */

/***/ }),

/***/ "./lib/visualpython/js/com/component/SampleComponent.js":
/*!**************************************************************!*\
  !*** ./lib/visualpython/js/com/component/SampleComponent.js ***!
  \**************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : SampleComponent.js
 *    Author          : Black Logic
 *    Note            : Sample Component
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] SampleComponent
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_String, Component) {

    /**
     * SampleComponent
     * Add below code in /data/libraries.json
        {
            "id"   : "apps_sample",
            "type" : "function",
            "level": 1,
            "name" : "Sample",
            "tag"  : "SAMPLE,APPS",
            "path" : "visualpython - apps - sample",
            "desc" : "Sample app for testing",
            "file" : "m_apps/SampleApp",
            "apps" : {
                "color": 4,
                "icon": "apps/apps_white.svg"
            }
        }
     */
    class SampleComponent extends Component {
        _init() {
            super._init();
            /** Write codes executed before rendering */
            
        }

        _bindEvent() {
            /** Implement binding events */
            
        }

        template() {
            /** Implement generating template */
            var page = new com_String();
            
            return page.toString();
        }

        render() {
            super.render();
            /** Implement after rendering */

        }

    }

    return SampleComponent;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/SuccessMessage.js":
/*!*************************************************************!*\
  !*** ./lib/visualpython/js/com/component/SuccessMessage.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
 *    Project Name    : Visual Python
 *    Description     : GUI-based Python code generator
 *    File Name       : SuccessMessage.js
 *    Author          : Black Logic
 *    Note            : SuccessMessage
 *    License         : GNU GPLv3 with Visual Python special exception
 *    Date            : 2021. 11. 18
 *    Change Date     :
 */

//============================================================================
// [CLASS] SuccessMessage
//============================================================================
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! !!text-loader!vp_base/html/component/successMessage.html */ "./node_modules/text-loader/index.js!./lib/visualpython/html/component/successMessage.html"), // INTEGRATION: unified version of text loader
    __webpack_require__(/*! vp_base/css/component/successMessage.css */ "./lib/visualpython/css/component/successMessage.css"), // INTEGRATION: unified version of css loader
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js")
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(msgHtml, msgCss, com_Const, Component) {

    /**
     * SuccessMessage
     */
    class SuccessMessage extends Component {
        constructor(title, timeout=1500) {
            super($('#header'), { title: title, timeout: timeout });
        }

        template() {
            return msgHtml.replaceAll('${vp_base}', com_Const.BASE_PATH);
        }

        render() {
            super.render();

            // set title
            $(this.wrapSelector('.vp-successMessage-title')).text(this.state.title);

            let that = this;
            // remove after timeout
            setTimeout( function() {
                $(that.wrapSelector()).remove();
            }, this.state.timeout);
        }

    }

    return SuccessMessage;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/SuggestInput.js":
/*!***********************************************************!*\
  !*** ./lib/visualpython/js/com/component/SuggestInput.js ***!
  \***********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
], __WEBPACK_AMD_DEFINE_RESULT__ = (function (com_util, com_String, Component) {
    /**
     * @class SuggestInput
     * @constructor
     */
    class SuggestInput extends Component{
        constructor() {
            super(null, {});
        }

        _init() {
            this._value = "";
            this._placeholder = "Select variable";
            this._compID = "";
            this._additionalClass = "";
            this._normalFilter = true;
            this._suggestList = new Array();
            this._selectEvent = undefined;
            this._attributes = {};
            this._minLength = 0;
        }

        render() {
            ;
        }
        /**
         * value
         * @param {String} value value
         */
        setValue(value = "") {
            this._value = value;
        }
        /**
         * placeholder
         * @param {String} placeholder placeholder
         */
        setPlaceholder(placeholder = "") {
            this._placeholder = placeholder;
        }
        /**
         * Component id
         * @param {String} compID
         */
        setComponentID(compID = "") {
            this._compID = compID;
        }
        /**
         * normal filter usage
         * @param {String} normalFilter 
         */
        setNormalFilter(normalFilter = true) {
            this._normalFilter = normalFilter;
        }
        /**
         * suggest list
         * @param {Array or Function} suggestList
         */
        setSuggestList(suggestList = new Array()) {
            this._suggestList = suggestList;
        }
        /**
         * show default list
         * - true: autocomplete.minLength to 0
         * - false: autocomplete.minLength to 1
         * @param {bool} showDefaultList 
         */
        setMinSearchLength(minLength) {
            this._minLength = minLength;
        }
        /**
         * Additional Class
         * @param {String} additionalClass
         */
        addClass(additionalClass = "") {
            if (additionalClass == "")
                return;
            this._additionalClass = com_util.formatString("{0} {1}", this._additionalClass, additionalClass);
        }
        addAttribute(key, value) {
            this._attributes = {
                ...this._attributes,
                [key]: value
            };
        }
        /**
         * selection event
         * @param {function} selectEvent
         */
        setSelectEvent(selectEvent) {
            if (typeof selectEvent != "function") {
                selectEvent = undefined;
            }
            this._selectEvent = selectEvent;
        }
        /**
         * icon input box tag
         * @returns html icon input text tag string
         */
        toTagString() {
            var sbTagString = new com_String();
            var that = this;

            let minLength = this._minLength;

            // make attributes
            var attributes = Object.keys(this._attributes).map(key => key + '="' + this._attributes[key] + '"').join(" ");

            sbTagString.appendFormatLine(`<input type='text' class='{0} {1} {2}' {3} placeholder='{4}' value="{5}" {6}/>`,
                that.uuid, 'suggest-input-uninit', that._additionalClass, that._compID == "" ? "" : com_util.formatString("id='{0}'", that._compID), that._placeholder, that._value, attributes);

            $(document).on(com_util.formatString("focus.init-{0}", that.uuid), com_util.formatString(".{0}.{1}", that.uuid, 'suggest-input-uninit'), function () {
                $(document).unbind(com_util.formatString(".init-{0}", that.uuid));

                $(com_util.formatString(".{0}", that.uuid)).removeClass('suggest-input-uninit').addClass('suggest-input');

                $(com_util.formatString(".{0}", that.uuid)).autocomplete({
                    autoFocus: true,
                    minLength: minLength,
                    source: function (req, res) {
                        var srcList = typeof that._suggestList == "function" ? that._suggestList() : that._suggestList;
                        var returlList = new Array();
                        if (that._normalFilter) {
                            for (var idx = 0; idx < srcList.length; idx++) {
                                // srcList as object array
                                if (typeof srcList[idx] == "object") {
                                    // { label: string, value: string } format
                                    if (srcList[idx].label.toString().toLowerCase().includes(req.term.trim().toLowerCase())) {
                                        returlList.push(srcList[idx]);
                                    }
                                } else if (srcList[idx].toString().toLowerCase().includes(req.term.trim().toLowerCase()))
                                    returlList.push(srcList[idx]);
                            }
                        } else {
                            returlList = srcList;
                        }
                        res(returlList);
                    },
                    select: function (evt, ui) {
                        let result = true;
                        // trigger change
                        $(this).val(ui.item.value);
                        
                        if (typeof that._selectEvent == "function") {
                            result = that._selectEvent(ui.item.value, ui.item);
                        }
                        $(this).trigger('change');
                        if (result != undefined) {
                            return result;
                        }
                        return true;
                    }
                }).focus(function() {
                    $(this).select();
                    $(com_util.formatString(".{0}", that.uuid)).autocomplete('search', $(com_util.formatString(".{0}", that.uuid)).val());
                }).click(function() {
                    $(this).select();
                    $(com_util.formatString(".{0}", that.uuid)).autocomplete('search', $(com_util.formatString(".{0}", that.uuid)).val());
                }).autocomplete('instance')._renderItem = function(ul, item) {
                    if (item.dtype != undefined) {
                        return $('<li>').attr('data-value', item.value)
                            .append(`<div class="vp-sg-item">${item.label}<label class="vp-gray-text vp-cursor">&nbsp;| ${item.dtype}</label></div>`)
                            .appendTo(ul);
                    }
                    return $('<li>').attr('data-value', item.value)
                            .append(`<div class="vp-sg-item">${item.label}</div>`)
                            .appendTo(ul);
                };;
            });

            return sbTagString.toString();
        }
    }
    
    return SuggestInput;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/VarSelector.js":
/*!**********************************************************!*\
  !*** ./lib/visualpython/js/com/component/VarSelector.js ***!
  \**********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_Const, com_String, com_util) {

    const VP_VS_BOX = 'vp-vs-box';
    const VP_VS_DATA_TYPE = 'vp-vs-data-type';
    const VP_VS_VARIABLES = 'vp-vs-variables';
    const VP_VS_TYPING_INPUT = 'vp-vs-typing-input';  
    const VP_VS_COLUMN_INPUT = 'vp-vs-column-input';
    const VP_VS_REFRESH = 'vp-vs-refresh';

    /**
     * @class VarSelector
     * @param {Array} dataTypes
     * @param {String} defaultType
     * @constructor
     * 
     * using sample:
        var varSelector = new VarSelector(['DataFrame', 'Series'], 'DataFrame');
        $(this.wrapSelector('.vp-vs-tester')).html(varSelector.render());
     */
    class VarSelector {
        constructor(dataTypes, defaultType = '', showOthers = true, useTyping = true) {
            this.uuid = 'u' + com_util.getUUID();
            this.label = {
                'others': 'Others',
                'typing': 'Typing'
            };

            this.boxClass = [];

            this.id = '';
            this.class = [];
            this.attributes = {};

            this.typeClass = []; // type selector class
            this.varClass = [];  // variable selector class
            this.colClass = [];  // column selector class

            this.dataTypes = dataTypes;
            if (defaultType == '') {
                if (dataTypes.length > 0) {
                    defaultType = dataTypes[0];
                } else {
                }
            }
            this.state = {
                selectedType: defaultType,
                varList: [],
                column: ''
            };

            this.defaultType = defaultType;
            this.defaultValue = '';
            this.defaultColumn = '';

            this.showOthers = showOthers;
            this.useTyping = useTyping;
            this.useColumn = false;

            this.reload();
            this.bindEvent();
        }
        setComponentId(id) {
            this.id = id;
        }
        addBoxClass(classname) {
            this.boxClass.push(classname);
        }
        addClass(classname) {
            this.class.push(classname);
        }
        addTypeClass(classname) {
            this.typeClass.push(classname);
        }
        addVarClass(classname) {
            this.varClass.push(classname);
        }
        addColClass(classname) {
            this.colClass.push(classname);
        }
        addAttribute(key, value) {
            this.attributes.push({ [key]: value });
        }
        setValue(value) {
            if (value == null || value == undefined) {
                value = '';
            }
            this.defaultValue = value;
            if (value.includes('[') && value.includes(']') ) {
                // divide it to variable / column
                let startIdx = value.indexOf('[');
                let endIdx = value.indexOf(']');
                this.defaultValue = value.substring(0, startIdx);
                this.defaultColumn = value.substring(startIdx + 1, endIdx);
            }
        }
        setState(newState) {
            this.state = {
                ...this.state,
                ...newState
            }
        }
        setUseColumn(useColumn) {
            this.useColumn = useColumn;
        }
        wrapSelector(selector = '') {
            return com_util.formatString('.{0} {1}', this.uuid, selector);
        }
        render(defaultType = this.defaultType, defaultValue = this.defaultValue) {
            var tag = new com_String();

            // var selector box
            tag.appendFormatLine('<div class="{0} {1} {2}">', VP_VS_BOX, this.uuid, this.boxClass.join(' '));

            // // hidden input value
            // tag.appendFormatLine('<input type="hidden" {0} />', 
            //                     this.attributes.id? 'id="' + this.attributes.id + '"': '');
            // data type selector
            tag.appendFormatLine('<select class="{0} {1} {2}">', VP_VS_DATA_TYPE, 'vp-select m', this.typeClass.join(' '));
            this.dataTypes.forEach((v, i) => {
                tag.appendFormatLine('<option value="{0}" {1}>{2}</option>', v,
                    defaultType == v ? 'selected' : '', v);
            });
            if (this.showOthers) {
                tag.appendFormatLine('<option value="{0}">{1}</option>', 'others', this.label.others);
            }
            if (this.useTyping) {
                tag.appendFormatLine('<option value="{0}">{1}</option>', 'typing', this.label.typing);
            }
            tag.appendLine('</select>'); // VP_VS_DATA_TYPE


            // variable selctor
            tag.appendLine(this.renderVariableList(this.state.varList));

            var attrStr = Object.keys(this.attributes).map(key => key + '="' + this.attributes[key] + '"').join(' ');

            // typing
            tag.appendFormatLine('<input type="text" class="{0} {1} {2}" placeholder="{3}" style="display: none;" {4} value="{5}" data-type="{6}" {7}/>',
                VP_VS_TYPING_INPUT, 'vp-input m', this.class.join(' '),
                'Type your code',
                this.id ? 'id="' + this.id + '"' : '',
                defaultValue,
                defaultType,
                attrStr);

            // column for dataframe
            tag.appendFormatLine('<select class="{0} {1} {2}" {3}></select>', 
                VP_VS_COLUMN_INPUT, 'vp-select m', this.colClass.join(' '),
                (this.useColumn == true && defaultType == 'DataFrame'?'':'style="display: none;"'));

            // reload
            // LAB: img to url
            // tag.appendFormatLine('<span class="{0} vp-cursor" title="{1}"><img src="{2}"></span>',
            //                     VP_VS_REFRESH, 'Refresh variables', com_Const.IMAGE_PATH + 'refresh.svg');
            tag.appendFormatLine('<span class="{0} vp-cursor vp-icon-refresh" title="{1}"></span>',
                                VP_VS_REFRESH, 'Refresh variables');

            tag.appendLine('</div>'); // VP_VS_BOX
            return tag.toString();
        }
        reload() {
            var that = this;
            // load using kernel
            var dataTypes = this.showOthers ? [] : this.dataTypes;
            vpKernel.getDataList(dataTypes).then(function (resultObj) {
                try {
                    let { result, type, msg } = resultObj;
                    var varList = JSON.parse(result);
                    that.state.varList = varList;
                    // render variable list
                    that.loadVariableList(varList);
                } catch (ex) {
                    // console.log(ex);
                }
            });
        }
        renderVariableList(varList) {
            var tag = new com_String();
            tag.appendFormatLine('<select class="{0} {1} {2}" {3}>', VP_VS_VARIABLES, 'vp-select m', this.varClass.join(' '),
                this.state.selectedType == 'typing' ? 'style="display:none;"' : '');
            varList.forEach(vObj => {
                // varName, varType
                var label = vObj.varName;
                if (this.state.selectedType == 'others') {
                    label += com_util.formatString(' ({0})', vObj.varType);
                }
                tag.appendFormatLine('<option value="{0}" data-type="{1}" {2}>{3}</option>',
                    vObj.varName, vObj.varType,
                    this.defaultValue == vObj.varName ? 'selected' : '',
                    label);
            });
            tag.appendLine('</select>'); // VP_VS_VARIABLES
            return tag.toString();
        }
        loadVariableList(varList) {
            var filteredList = varList;
            var that = this;
            let dataTypes = this.dataTypes;
            // Include various index types for Index type
            var INDEX_TYPES = ['RangeIndex', 'CategoricalIndex', 'MultiIndex', 'IntervalIndex', 'DatetimeIndex', 'TimedeltaIndex', 'PeriodIndex', 'Int64Index', 'UInt64Index', 'Float64Index'];
            // Include various groupby types for Groupby type
            var GROUPBY_TYPES = ['DataFrameGroupBy', 'SeriesGroupBy']
            if (dataTypes.indexOf('Index') >= 0) {
                dataTypes = dataTypes.concat(INDEX_TYPES);
            }
            if (dataTypes.indexOf('GroupBy') >= 0) {
                dataTypes = dataTypes.concat(GROUPBY_TYPES);
            }

            if (this.state.selectedType == 'others') {
                filteredList = varList.filter(v => !dataTypes.includes(v.varType));
            } else if (this.state.selectedType == 'typing') {
                filteredList = [];
            } else {
                let filterDataTypes = [ this.state.selectedType ];
                if (filterDataTypes.indexOf('Index') >= 0) {
                    filterDataTypes = filterDataTypes.concat(INDEX_TYPES);
                }
                if (filterDataTypes.indexOf('GroupBy') >= 0) {
                    filterDataTypes = filterDataTypes.concat(GROUPBY_TYPES);
                }

                filteredList = varList.filter(v => filterDataTypes.includes(v.varType));
            }

            // replace
            $(this.wrapSelector('.' + VP_VS_VARIABLES)).replaceWith(function () {
                return that.renderVariableList(filteredList);
            });
            $(this.wrapSelector('.' + VP_VS_VARIABLES)).trigger('change');
        }
        loadColumnList(varName) {
            let that = this;
            // get result and show on detail box
            vpKernel.getColumnList(varName).then(function(resultObj) {
                try {
                    let { result, type, msg } = resultObj;
                    var varResult = JSON.parse(result);

                    let newTag = new com_String();
                    newTag.appendFormatLine('<select class="{0} {1} {2}" {3}>', 
                        VP_VS_COLUMN_INPUT, 'vp-select m', that.colClass.join(' '),
                        (that.useColumn == true && that.defaultType == 'DataFrame'?'':'style="display: none;"'));
                    newTag.appendFormatLine('<option value="{0}" data-dtype="{1}">{2}</option>',
                        '', '', '');
                    varResult && varResult.forEach(col => {
                        // label, value, dtype, array, location, category
                        newTag.appendFormatLine('<option value="{0}" data-dtype="{1}" {2}>{3}</option>',
                            col.value, col.dtype, 
                            that.defaultColumn == col.value ? 'selected' : '',
                            col.label);
                    });
                    newTag.appendLine('</select>');
                    // replace
                    $(that.wrapSelector('.' + VP_VS_COLUMN_INPUT)).replaceWith(function() {
                        return newTag.toString();
                    });
                } catch (e) {
                    vpLog.display(VP_LOG_TYPE.ERROR, 'varSelector - bindColumnSource: not supported data type. ', e);
                }
            });
        }
        bindEvent() {
            var that = this;
            // data type selection
            $(document).on('change', this.wrapSelector('.' + VP_VS_DATA_TYPE), function (event) {
                // re-renderVariableList
                var dataType = $(this).val();
                that.state.selectedType = dataType;
                if (dataType == 'typing') {
                    $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).val('');
                    $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).attr('data-type', '');
                    $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).show();
                    $(that.wrapSelector('.' + VP_VS_VARIABLES)).hide();
                    $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).trigger({
                        type: 'var_changed',
                        value: '',
                        dataType: ''
                    });
                } else {
                    $(that.wrapSelector('.' + VP_VS_VARIABLES)).show();
                    $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).hide();
                    // 1) load variable once
                    that.loadVariableList(that.state.varList);
                    // 2) load on every selection of data types
                    // that.reload();
                }

                if (that.useColumn == true) {
                    if (dataType == 'DataFrame') {
                        $(that.wrapSelector('.' + VP_VS_COLUMN_INPUT)).show();
                    } else {
                        $(that.wrapSelector('.' + VP_VS_COLUMN_INPUT)).hide();
                    }
                } else {
                    $(that.wrapSelector('.' + VP_VS_COLUMN_INPUT)).hide();
                }
            });

            // variable selection
            $(document).on('change', this.wrapSelector('.' + VP_VS_VARIABLES), function (event) {
                var value = $(this).val();
                var dataType = $(this).find('option:selected').attr('data-type');
                $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).val(value);
                $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).attr('data-type', dataType);
                $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).trigger({
                    type: 'var_changed',
                    value: value,
                    dataType: dataType
                });

                // if datatype == dataframe, change column list
                if (that.useColumn == true && dataType == 'DataFrame') {
                    that.loadColumnList(value);
                }
            });

            // column selection
            $(document).on('change', this.wrapSelector('.' + VP_VS_COLUMN_INPUT), function(event) {
                var value = $(that.wrapSelector('.' + VP_VS_VARIABLES)).val();
                var colValue = $(this).val();
                var newValue = value;
                if (colValue != '') {
                    newValue += '[' + colValue + ']';
                }

                var dataType = $(this).find('option:selected').attr('data-type');
                $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).val(newValue);
                $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).attr('data-type', dataType);
                $(that.wrapSelector('.' + VP_VS_TYPING_INPUT)).trigger({
                    type: 'var_changed',
                    value: newValue,
                    dataType: 'DataFrame'
                });
            });

            // refresh
            $(document).on('click', this.wrapSelector('.' + VP_VS_REFRESH), function() {
                that.reload();
            });
        }
    }

    return VarSelector;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__))

/***/ }),

/***/ "./lib/visualpython/js/com/component/VarSelector2.js":
/*!***********************************************************!*\
  !*** ./lib/visualpython/js/com/component/VarSelector2.js ***!
  \***********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;!(__WEBPACK_AMD_DEFINE_ARRAY__ = [
    __webpack_require__(/*! vp_base/js/com/com_Const */ "./lib/visualpython/js/com/com_Const.js"),
    __webpack_require__(/*! vp_base/js/com/com_String */ "./lib/visualpython/js/com/com_String.js"),
    __webpack_require__(/*! vp_base/js/com/com_util */ "./lib/visualpython/js/com/com_util.js"),
    __webpack_require__(/*! vp_base/js/com/component/Component */ "./lib/visualpython/js/com/component/Component.js"),
], __WEBPACK_AMD_DEFINE_RESULT__ = (function(com_Const, com_String, com_util, Component) {
    /**
     * @class VarSelector
     * @constructor
     */
     class VarSelector extends Component{
        constructor(parentTag, dataTypes=['DataFrame', 'Series', 'ndarray', 'list', 'dict'], defaultType='', showOthers=true, showFilterbox=true) {
            super(null, {parentTag: parentTag, dataTypes: dataTypes, defaultType: defaultType, showOthers: showOthers, showFilterbox: showFilterbox});
        }

        _init() {
            this._value = "";
            this._placeholder = "Select variable";
            this._compID = "";
            this._additionalClass = "";
            this._normalFilter = true;
            this._suggestList = new Array();
            this._selectEvent = undefined;
            this._attributes = {};
            this._minLength = 0;

            this._parentTag = this.state.parentTag;
            this._dataTypes = this.state.dataTypes;
            this._defaultType = this.state.defaultType;
            this._showOthers = this.state.showOthers;
            this._showFilterbox = this.state.showFilterbox;
            if (this._defaultType == '') {
                if (this._dataTypes.length > 0) {
                    this._defaultType = this._dataTypes[0];
                } else {
                }
            }

            this.state = {
                selectedType: this._defaultType,
                varList: [],
                column: ''
            }

            this.reload();
            this.bindEvent();
        }

        render() {
            ;
        }
        
        bindEvent() {
            let that = this;

            // bind Event on focus/click box
            $(document).on(com_util.formatString("focus.init-{0} click.init-{1}", that.uuid, that.uuid), com_util.formatString(".{0}.{1}", that.uuid, 'vp-vs-uninit'), function () {
                // unbind initial event
                $(document).unbind(com_util.formatString(".init-{0}", that.uuid));
                $(com_util.formatString(".{0}.{1}", that.uuid, 'vp-vs-uninit')).removeClass('vp-vs-uninit').addClass('vp-vs-init');

                // bind autocomplete
                that.bindAutocomplete();

                // bind Event
                $(that._parentTag).on('click', that.wrapSelector('.vp-vs-filter'), function(evt) {
                    // check disabled
                    if (!$(this).parent().find('input').is(':disabled')) {
                        // toggle filter box
                        let isOpen = $(that.wrapSelector('.vp-vs-filter-box')).hasClass('vp-inline-block');
                        $('.vp-vs-filter-box').removeClass('vp-inline-block');
                        
                        if (!isOpen) {
                            // open filter box
                            $(that.wrapSelector('.vp-vs-filter-box')).addClass('vp-inline-block');
                        }
                    }
                    evt.stopPropagation();
                });

                $(that._parentTag).on('click', function(evt) {
                    let target = evt.target;
                    if ($(that.wrapSelector('.vp-vs-filter-box')).find(target).length > 0 
                        || $(target).hasClass('vp-vs-filter-box')) {
                        // trigger focus
                        $(that.wrapSelector('.vp-vs-input')).trigger('focus');
                    }
                });
    
                $(that._parentTag).on('change', that.wrapSelector('.vp-vs-filter-select-all'), function() {
                    let checked = $(this).prop('checked');
                    // check all
                    $(that.wrapSelector('.vp-vs-filter-type')).prop('checked', checked);
                    // reload
                    that.reload().then(function() {
                        $(that.wrapSelector('.vp-vs-input')).trigger('focus');
                    });
                });
    
                $(that._parentTag).on('change', that.wrapSelector('.vp-vs-filter-type'), function() {
                    // if checked all
                    let allLength = $(that.wrapSelector('.vp-vs-filter-type')).length;
                    let checkedLength = $(that.wrapSelector('.vp-vs-filter-type:checked')).length;
                    if (allLength == checkedLength) {
                        $(that.wrapSelector('.vp-vs-filter-select-all')).prop('checked', true);
                    } else {
                        $(that.wrapSelector('.vp-vs-filter-select-all')).prop('checked', false);
                    }
                    that.reload().then(function() {
                        $(that.wrapSelector('.vp-vs-input')).trigger('focus');
                    });
                });
            });
        }

        /**
         * value
         * @param {String} value value
         */
        setValue(value = "") {
            this._value = value;
        }
        /**
         * placeholder
         * @param {String} placeholder placeholder
         */
        setPlaceholder(placeholder = "") {
            this._placeholder = placeholder;
        }
        /**
         * Component id
         * @param {String} compID
         */
        setComponentID(compID = "") {
            this._compID = compID;
        }
        /**
         * normal filter usage
         * @param {String} normalFilter 
         */
        setNormalFilter(normalFilter = true) {
            this._normalFilter = normalFilter;
        }
        /**
         * suggest list
         * @param {Array or Function} suggestList
         */
        setSuggestList(suggestList = new Array()) {
            this._suggestList = suggestList;
        }
        /**
         * show default list
         * - true: autocomplete.minLength to 0
         * - false: autocomplete.minLength to 1
         * @param {bool} showDefaultList 
         */
        setMinSearchLength(minLength) {
            this._minLength = minLength;
        }
        /**
         * Additional Class
         * @param {String} additionalClass
         */
        addClass(additionalClass = "") {
            if (additionalClass == "")
                return;
            this._additionalClass = com_util.formatString("{0} {1}", this._additionalClass, additionalClass);
        }
        addAttribute(key, value) {
            this._attributes = {
                ...this._attributes,
                [key]: value
            };
        }
        /**
         * selection event
         * @param {function} selectEvent
         */
        setSelectEvent(selectEvent) {
            if (typeof selectEvent != "function") {
                selectEvent = undefined;
            }
            this._selectEvent = selectEvent;
        }

        reload() {
            var that = this;
            // load using kernel
            let dataTypes = this._dataTypes;
            let excludeTypes = [];
            let othersChecked = this._showOthers;
            // check filter
            if ($(this.wrapSelector('.vp-vs-filter-box')).length > 0) {
                let filterTypes = [];
                let filterTypeTags = $(this.wrapSelector('.vp-vs-filter-type'));
                filterTypeTags.each((i, tag) => {
                    let checked = $(tag).prop('checked');
                    let dtype = $(tag).data('dtype');
                    if (checked) {
                        if (dtype == 'others') {
                            othersChecked = true;
                        } else {
                            filterTypes.push(dtype);
                        }
                    } else {
                        if (dtype == 'others') {
                            othersChecked = false;
                        } else {
                            excludeTypes.push(dtype);
                        }
                    }
                });
                let allChecked = $(this.wrapSelector('.vp-vs-filter-select-all')).prop('checked');
                if (allChecked) {
                    if (othersChecked) {
                        dataTypes = []; // load all types of variables
                        excludeTypes = [];
                    } else {
                        dataTypes = filterTypes;
                    }
                } else {
                    if (othersChecked) {
                        dataTypes = [];
                    } else {
                        if (filterTypes.length == 0) {
                            // nothing checked
                            // no variable list
                            this.state.varList = [];
                            this._suggestList = [];
                            return new Promise(function(resolve, reject) {
                                resolve([]);
                            });
                        }
                        dataTypes = filterTypes;
                    }
                    
                }
            } else {
                dataTypes = [];
            }

            vpLog.display(VP_LOG_TYPE.DEVELOP, 'VarSelector2 - reload ', dataTypes, excludeTypes);

            return new Promise(function(resolve, reject) {
                vpKernel.getDataList(dataTypes, excludeTypes).then(function (resultObj) {
                    try {
                        let { result, type, msg } = resultObj;
                        var varList = JSON.parse(result);
                        // re-mapping variable list
                        varList = varList.map(obj => { 
                            return {
                                label: obj.varName, 
                                value: obj.varName,
                                dtype: obj.varType
                            }; 
                        });

                        // save variable list as state
                        that.state.varList = varList;
                        that._suggestList = varList;
                        resolve(varList);

                    } catch (ex) {
                        reject(ex);
                    }
                });
            });
        }

        bindAutocomplete() {
            let that = this;
            let minLength = this._minLength;

            $(com_util.formatString(".{0} input", that.uuid)).autocomplete({
                autoFocus: true,
                minLength: minLength,
                source: function (req, res) {
                    var srcList = typeof that._suggestList == "function" ? that._suggestList() : that._suggestList;
                    var returlList = new Array();
                    if (that._normalFilter) {
                        for (var idx = 0; idx < srcList.length; idx++) {
                            // srcList as object array
                            if (typeof srcList[idx] == "object") {
                                // { label: string, value: string } format
                                if (srcList[idx].label.toString().toLowerCase().includes(req.term.trim().toLowerCase())) {
                                    returlList.push(srcList[idx]);
                                }
                            } else if (srcList[idx].toString().toLowerCase().includes(req.term.trim().toLowerCase()))
                                returlList.push(srcList[idx]);
                        }
                    } else {
                        returlList = srcList;
                    }
                    res(returlList);
                },
                select: function (evt, ui) {
                    let result = true;
                    // trigger change
                    $(this).val(ui.item.value);
                    $(this).trigger('change');

                    // select event
                    if (typeof that._selectEvent == "function")
                        result = that._selectEvent(ui.item.value, ui.item);
                    if (result != undefined) {
                        return result;
                    }
                    return true;
                },
                search: function(evt, ui) {
                    return true;
                },
                open: function(evt, ui) {
                    if (!$(that.wrapSelector('.vp-vs-filter-box')).hasClass('vp-inline-block')) {
                        $(that.wrapSelector('.vp-vs-filter-box')).addClass('vp-inline-block');
                    }
                },
                close: function(evt, ui) {
                    // $(that.wrapSelector('.vp-vs-filter-box')).removeClass('vp-inline-block');
                    evt.preventDefault();
                    return false;
                }
            }).focus(function () {
                $(this).select();
                $(this).autocomplete('search', $(this).val());
            }).click(function () {
                $(this).select();
                $(this).autocomplete('search', $(this).val());
            }).autocomplete('instance')._renderItem = function(ul, item) {
                return $('<li>').attr('data-value', item.value)
                        .append(`<div class="vp-vs-item">${item.label}<label class="vp-gray-text vp-cursor">&nbsp;| ${item.dtype}</label></div>`)
                        .appendTo(ul);
            };
        }

        /**
         * icon input box tag
         * @returns html icon input text tag string
         */
        toTagString() {
            var sbTagString = new com_String();
            var that = this;

            // make attributes
            var attributes = Object.keys(this._attributes).map(key => key + '="' + this._attributes[key] + '"').join(" ");

            sbTagString.appendFormatLine('<div class="{0} {1}">', this.uuid, 'vp-vs-box vp-vs-uninit');
            sbTagString.appendFormatLine(`<input type="text" class="vp-vs-blur-btn {0} {1}" {2} placeholder="{3}" value="{4}" {5}/>`,
                'vp-vs-input', that._additionalClass, that._compID == "" ? "" : com_util.formatString('id="{0}"', that._compID), that._placeholder, that._value, attributes);
            if (this._showFilterbox) {
                // filter icon
                // LAB: img to url
                // sbTagString.appendFormatLine('<span class="vp-vs-blur-btn {0}"><img src="{1}"/></span>', 'vp-vs-filter', com_Const.IMAGE_PATH + 'filter.svg');
                sbTagString.appendFormatLine('<span class="vp-vs-blur-btn {0} {1}"></span>', 'vp-vs-filter', 'vp-icon-filter');
                // filter box
                sbTagString.appendFormatLine('<div class="vp-vs-blur-btn vp-vs-blur {0}">', 'vp-vs-filter-box');
                sbTagString.appendLine('<div class="vp-grid-box">');
                sbTagString.appendFormatLine('<input type="checkbox" id="{0}" class="{1}" checked><label for="{2}">{3}</label>', 
                    this.uuid + '_vsSelectAll', 'vp-vs-filter-select-all', this.uuid + '_vsSelectAll', 'Select All');
                this._dataTypes && this._dataTypes.forEach(dt => {
                    let tmpId = that.uuid + '_' + dt;
                    sbTagString.appendFormatLine('<input type="checkbox" id="{0}" class="{1}" data-dtype="{2}" checked><label for="{3}">{4}</label>', 
                        tmpId, 'vp-vs-filter-type', dt, tmpId, dt);
                });
                if (this._showOthers) {
                    let tmpId = that.uuid + '_others';
                    sbTagString.appendFormatLine('<input type="checkbox" id="{0}" class="{1}" data-dtype="{2}" checked><label for="{3}">{4}</label>', 
                        tmpId, 'vp-vs-filter-type', 'others', tmpId, 'Others');
                }
                sbTagString.appendLine('</div>'); // end of vp-grid-box
                sbTagString.appendLine('</div>'); // end of vp-vs-filter-box
            }
            sbTagString.appendLine('</div>'); // end of vp-vs-box

            return sbTagString.toString();
        }

    }

    return VarSelector;
}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./lib/visualpython/js/com/component/__init__.py":
/*!*******************************************************!*\
  !*** ./lib/visualpython/js/com/component/__init__.py ***!
  \*******************************************************/
/***/ (() => {

print('Visual Python')


/***/ }),

/***/ "./lib/visualpython/js/com/lib/__init__.py":
/*!*************************************************!*\
  !*** ./lib/visualpython/js/com/lib/__init__.py ***!
  \*************************************************/
/***/ (() => {

print('Visual Python')


/***/ }),

/***/ "./lib/visualpython/js/com/template/__init__.py":
/*!******************************************************!*\
  !*** 