/*!
 * Copyright (c) 2012 - 2019, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"]);
})(this, function(Bokeh) {
  var define;
  return (function(modules, entry, aliases, externals) {
    if (Bokeh != null) {
      return Bokeh.register_plugin(modules, entry, aliases, externals);
    } else {
      throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");
    }
  })
({
"55dac5102b": function _(e,a,s){var n=e("1d13522e8a");s.Panel=n,e("@bokehjs/base").register_models(n)},
"1d13522e8a": function _(a,e,o){var r=a("c167e0e33e");o.AcePlot=r.AcePlot;var t=a("d2f2f8c2b2");o.Audio=t.Audio;var c=a("cef8bc2777");o.HTML=c.HTML;var l=a("7a3cc4b4c6");o.KaTeX=l.KaTeX;var P=a("75803aafc7");o.MathJax=P.MathJax;var d=a("24a20e4790");o.Player=d.Player;var v=a("c864119ab3");o.PlotlyPlot=v.PlotlyPlot;var V=a("1d01be8a6e");o.Progress=V.Progress;var b=a("4cbc2c8e7e");o.State=b.State;var T=a("780561860e");o.VegaPlot=T.VegaPlot;var f=a("4a2dcd4d15");o.Video=f.Video;var i=a("cbedefa11b");o.VideoStream=i.VideoStream;var K=a("d4af2357ca");o.VTKPlot=K.VTKPlot;var u=a("64e1d58d42");o.VTKVolumePlot=u.VTKVolumePlot},
"c167e0e33e": function _(t,e,o){var i,n=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},function(t,e){function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),r=t("@bokehjs/core/properties"),s=t("@bokehjs/models/layouts/html_box"),a=t("@bokehjs/core/dom");var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._ace=window.ace,this._container=a.div({id:"_"+Math.random().toString(36).substr(2,9),style:{width:"100%",height:"100%"}})},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.code.change,function(){return e._update_code_from_model()}),this.connect(this.model.properties.theme.change,function(){return e._update_theme()}),this.connect(this.model.properties.language.change,function(){return e._update_language()}),this.connect(this.model.properties.annotations.change,function(){return e._add_annotations()}),this.connect(this.model.properties.readonly.change,function(){e._editor.setReadOnly(e.model.readonly)})},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this._container!==this.el.childNodes[0]&&this.el.appendChild(this._container),this._container.textContent=this.model.code,this._editor=this._ace.edit(this._container.id),this._editor.setTheme("ace/theme/"+this.model.theme),this._editor.session.setMode("ace/mode/"+this.model.language),this._editor.setReadOnly(this.model.readonly),this._langTools=this._ace.require("ace/ext/language_tools"),this._editor.setOptions({enableBasicAutocompletion:!0,enableSnippets:!0,fontFamily:"monospace"}),this._editor.on("change",function(){return e._update_code_from_editor()})},e.prototype._update_code_from_model=function(){this._editor&&this._editor.getValue()!=this.model.code&&this._editor.setValue(this.model.code)},e.prototype._update_code_from_editor=function(){this._editor.getValue()!=this.model.code&&(this.model.code=this._editor.getValue())},e.prototype._update_theme=function(){this._editor.setTheme("ace/theme/"+this.model.theme)},e.prototype._update_language=function(){this._editor.session.setMode("ace/mode/"+this.model.language)},e.prototype._add_annotations=function(){this._editor.session.setAnnotations(this.model.annotations)},e.prototype.after_layout=function(){t.prototype.after_layout.call(this),this._editor.resize()},e.__name__="AcePlotView",e}(s.HTMLBoxView);o.AcePlotView=c;var h=function(t){function e(e){return t.call(this,e)||this}return n(e,t),e.init_AcePlot=function(){this.prototype.default_view=c,this.define({code:[r.String],language:[r.String,"python"],theme:[r.String,"chrome"],annotations:[r.Array,[]],readonly:[r.Boolean,!1]}),this.override({height:300,width:300})},e.__name__="AcePlot",e.__module__="panel.models.ace",e}(s.HTMLBox);o.AcePlot=h,h.init_AcePlot()},
"d2f2f8c2b2": function _(t,e,o){var i,n=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},function(t,e){function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),u=t("@bokehjs/core/properties"),l=t("@bokehjs/models/widgets/widget"),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._blocked=!1,this._time=Date.now()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.properties.loop.change,function(){return e.set_loop()}),this.connect(this.model.properties.paused.change,function(){return e.set_paused()}),this.connect(this.model.properties.time.change,function(){return e.set_time()}),this.connect(this.model.properties.value.change,function(){return e.set_value()}),this.connect(this.model.properties.volume.change,function(){return e.set_volume()})},e.prototype.render=function(){var t=this;this.audioEl||(this.audioEl=document.createElement("audio"),this.audioEl.controls=!0,this.audioEl.src=this.model.value,this.audioEl.currentTime=this.model.time,this.audioEl.loop=this.model.loop,null!=this.model.volume?this.audioEl.volume=this.model.volume/100:this.model.volume=100*this.audioEl.volume,this.audioEl.onpause=function(){return t.model.paused=!0},this.audioEl.onplay=function(){return t.model.paused=!1},this.audioEl.ontimeupdate=function(){return t.update_time(t)},this.audioEl.onvolumechange=function(){return t.update_volume(t)},this.el.appendChild(this.audioEl),this.model.paused||this.audioEl.play())},e.prototype.update_time=function(t){Date.now()-t._time<t.model.throttle||(t._blocked=!0,t.model.time=t.audioEl.currentTime,t._time=Date.now())},e.prototype.update_volume=function(t){t._blocked=!0,t.model.volume=100*t.audioEl.volume},e.prototype.set_loop=function(){this.audioEl.loop=this.model.loop},e.prototype.set_paused=function(){!this.audioEl.paused&&this.model.paused&&this.audioEl.pause(),this.audioEl.paused&&!this.model.paused&&this.audioEl.play()},e.prototype.set_volume=function(){this._blocked?this._blocked=!1:null!=this.model.volume&&(this.audioEl.volume=this.model.volume/100)},e.prototype.set_time=function(){this._blocked?this._blocked=!1:this.audioEl.currentTime=this.model.time},e.prototype.set_value=function(){this.audioEl.src=this.model.value},e.__name__="AudioView",e}(l.WidgetView);o.AudioView=s;var d=function(t){function e(e){return t.call(this,e)||this}return n(e,t),e.init_Audio=function(){this.prototype.default_view=s,this.define({loop:[u.Boolean,!1],paused:[u.Boolean,!0],time:[u.Number,0],throttle:[u.Number,250],value:[u.Any,""],volume:[u.Number,null]})},e.__name__="Audio",e.__module__="panel.models.widgets",e}(l.Widget);o.Audio=d,d.init_Audio()},
"cef8bc2777": function _(t,e,r){var n,o=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])})(t,e)},function(t,e){function r(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}),i=t("@bokehjs/models/widgets/markup");var a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o(e,t),e.prototype.render=function(){t.prototype.render.call(this);var e,r=(e=this.model.text,(new DOMParser).parseFromString(e,"text/html").documentElement.textContent);r?(this.markup_el.innerHTML=r,Array.from(this.markup_el.querySelectorAll("script")).forEach(function(t){var e=document.createElement("script");Array.from(t.attributes).forEach(function(t){return e.setAttribute(t.name,t.value)}),e.appendChild(document.createTextNode(t.innerHTML)),t.parentNode&&t.parentNode.replaceChild(e,t)})):this.markup_el.innerHTML=""},e.__name__="HTMLView",e}(i.MarkupView);r.HTMLView=a;var u=function(t){function e(e){return t.call(this,e)||this}return o(e,t),e.init_HTML=function(){this.prototype.default_view=a},e.__name__="HTML",e.__module__="panel.models.markup",e}(i.Markup);r.HTML=u,u.init_HTML()},
"7a3cc4b4c6": function _(t,e,n){var i,r=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)},function(t,e){function n(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)}),o=t("@bokehjs/models/widgets/markup"),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.markup_el.innerHTML=this.model.text,window.renderMathInElement&&window.renderMathInElement(this.el,{delimiters:[{left:"$$",right:"$$",display:!0},{left:"\\[",right:"\\]",display:!0},{left:"$",right:"$",display:!1},{left:"\\(",right:"\\)",display:!1}]})},e.__name__="KaTeXView",e}(o.MarkupView);n.KaTeXView=a;var l=function(t){function e(e){return t.call(this,e)||this}return r(e,t),e.init_KaTeX=function(){this.prototype.default_view=a},e.__name__="KaTeX",e.__module__="panel.models.katex",e}(o.Markup);n.KaTeX=l,l.init_KaTeX()},
"75803aafc7": function _(t,i,n){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var n in i)i.hasOwnProperty(n)&&(t[n]=i[n])})(t,i)},function(t,i){function n(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(n.prototype=i.prototype,new n)}),r=t("@bokehjs/models/widgets/markup"),a=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return o(i,t),i.prototype.initialize=function(){t.prototype.initialize.call(this),this._hub=window.MathJax.Hub,this._hub.Config({tex2jax:{inlineMath:[["$","$"],["\\(","\\)"]]}})},i.prototype.render=function(){t.prototype.render.call(this),this._hub&&(this.markup_el.innerHTML=this.model.text,this._hub.Queue(["Typeset",this._hub,this.markup_el]))},i.__name__="MathJaxView",i}(r.MarkupView);n.MathJaxView=a;var u=function(t){function i(i){return t.call(this,i)||this}return o(i,t),i.init_MathJax=function(){this.prototype.default_view=a},i.__name__="MathJax",i.__module__="panel.models.mathjax",i}(r.Markup);n.MathJax=u,u.init_MathJax()},
"24a20e4790": function _(t,e,i){var n,o=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])})(t,e)},function(t,e){function i(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),r=t("@bokehjs/core/properties"),s=t("@bokehjs/core/dom"),a=t("@bokehjs/models/widgets/widget"),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return e.render()}),this.connect(this.model.properties.value.change,function(){return e.render()}),this.connect(this.model.properties.loop_policy.change,function(){return e.set_loop_state(e.model.loop_policy)})},e.prototype.get_height=function(){return 250},e.prototype.render=function(){var e=this;if(null!=this.sliderEl)return this.sliderEl.style.width="{this.model.width}px",this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),void(this.sliderEl.value=String(this.model.value));t.prototype.render.call(this),this.sliderEl=document.createElement("input"),this.sliderEl.setAttribute("type","range"),this.sliderEl.style.width=this.model.width+"px",this.sliderEl.value=String(this.model.value),this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),this.sliderEl.onchange=function(t){return e.set_frame(parseInt(t.target.value))};var i=s.div();i.style.cssText="margin: 0 auto; display: table; padding: 5px";var n="text-align: center; min-width: 40px; margin: 2px",o=document.createElement("button");o.style.cssText="text-align: center; min-width: 20px",o.appendChild(document.createTextNode("–")),o.onclick=function(){return e.slower()},i.appendChild(o);var r=document.createElement("button");r.style.cssText=n,r.appendChild(document.createTextNode("❚◀◀")),r.onclick=function(){return e.first_frame()},i.appendChild(r);var a=document.createElement("button");a.style.cssText=n,a.appendChild(document.createTextNode("❚◀")),a.onclick=function(){return e.previous_frame()},i.appendChild(a);var l=document.createElement("button");l.style.cssText=n,l.appendChild(document.createTextNode("◀")),l.onclick=function(){return e.reverse_animation()},i.appendChild(l);var d=document.createElement("button");d.style.cssText=n,d.appendChild(document.createTextNode("❚❚")),d.onclick=function(){return e.pause_animation()},i.appendChild(d);var p=document.createElement("button");p.style.cssText=n,p.appendChild(document.createTextNode("▶")),p.onclick=function(){return e.play_animation()},i.appendChild(p);var c=document.createElement("button");c.style.cssText=n,c.appendChild(document.createTextNode("▶❚")),c.onclick=function(){return e.next_frame()},i.appendChild(c);var h=document.createElement("button");h.style.cssText=n,h.appendChild(document.createTextNode("▶▶❚")),h.onclick=function(){return e.last_frame()},i.appendChild(h);var u=document.createElement("button");u.style.cssText="text-align: center; min-width: 20px",u.appendChild(document.createTextNode("+")),u.onclick=function(){return e.faster()},i.appendChild(u),this.loop_state=document.createElement("form"),this.loop_state.style.cssText="margin: 0 auto; display: table";var m=document.createElement("input");m.type="radio",m.value="once",m.name="state";var _=document.createElement("label");_.innerHTML="Once",_.style.cssText="padding: 0 10px 0 5px; user-select:none;";var f=document.createElement("input");f.setAttribute("type","radio"),f.setAttribute("value","loop"),f.setAttribute("name","state");var v=document.createElement("label");v.innerHTML="Loop",v.style.cssText="padding: 0 10px 0 5px; user-select:none;";var y=document.createElement("input");y.setAttribute("type","radio"),y.setAttribute("value","reflect"),y.setAttribute("name","state");var x=document.createElement("label");x.innerHTML="Reflect",x.style.cssText="padding: 0 10px 0 5px; user-select:none;","once"==this.model.loop_policy?m.checked=!0:"loop"==this.model.loop_policy?f.checked=!0:y.checked=!0,this.loop_state.appendChild(m),this.loop_state.appendChild(_),this.loop_state.appendChild(f),this.loop_state.appendChild(v),this.loop_state.appendChild(y),this.loop_state.appendChild(x),this.el.appendChild(this.sliderEl),this.el.appendChild(i),this.el.appendChild(this.loop_state)},e.prototype.set_frame=function(t){this.model.value!=t&&(this.model.value=t),this.sliderEl.value!=String(t)&&(this.sliderEl.value=String(t))},e.prototype.get_loop_state=function(){for(var t=this.loop_state.state,e=0;e<t.length;e++){var i=t[e];if(i.checked)return i.value}return"once"},e.prototype.set_loop_state=function(t){for(var e=this.loop_state.state,i=0;i<e.length;i++){var n=e[i];n.value==t&&(n.checked=!0)}},e.prototype.next_frame=function(){this.set_frame(Math.min(this.model.end,this.model.value+this.model.step))},e.prototype.previous_frame=function(){this.set_frame(Math.max(this.model.start,this.model.value-this.model.step))},e.prototype.first_frame=function(){this.set_frame(this.model.start)},e.prototype.last_frame=function(){this.set_frame(this.model.end)},e.prototype.slower=function(){this.model.interval=Math.round(this.model.interval/.7),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()},e.prototype.faster=function(){this.model.interval=Math.round(.7*this.model.interval),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()},e.prototype.anim_step_forward=function(){if(this.model.value<this.model.end)this.next_frame();else{var t=this.get_loop_state();"loop"==t?this.first_frame():"reflect"==t?(this.last_frame(),this.reverse_animation()):(this.pause_animation(),this.last_frame())}},e.prototype.anim_step_reverse=function(){if(this.model.value>this.model.start)this.previous_frame();else{var t=this.get_loop_state();"loop"==t?this.last_frame():"reflect"==t?(this.first_frame(),this.play_animation()):(this.pause_animation(),this.first_frame())}},e.prototype.pause_animation=function(){this.model.direction=0,this.timer&&(clearInterval(this.timer),this.timer=null)},e.prototype.play_animation=function(){var t=this;this.pause_animation(),this.model.direction=1,this.timer||(this.timer=setInterval(function(){return t.anim_step_forward()},this.model.interval))},e.prototype.reverse_animation=function(){var t=this;this.pause_animation(),this.model.direction=-1,this.timer||(this.timer=setInterval(function(){return t.anim_step_reverse()},this.model.interval))},e.__name__="PlayerView",e}(a.WidgetView);i.PlayerView=l;var d=function(t){function e(e){return t.call(this,e)||this}return o(e,t),e.init_Player=function(){this.prototype.default_view=l,this.define({direction:[r.Number,0],interval:[r.Number,500],start:[r.Number],end:[r.Number],step:[r.Number,1],loop_policy:[r.Any,"once"],value:[r.Any,0]}),this.override({width:400})},e.__name__="Player",e.__module__="panel.models.widgets",e}(a.Widget);i.Player=d,d.init_Player()},
"c864119ab3": function _(t,e,o){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},function(t,e){function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),i=t("@bokehjs/core/properties"),l=t("@bokehjs/core/util/object"),a=t("@bokehjs/models/layouts/html_box"),p=window._,s=window.Plotly;var u=function(t,e,o){var r,n=Array.isArray(e)?[]:{};if("click"===o||"hover"===o||"selected"===o){var i=[];if(null==e)return null;for(var l=t.data,a=0;a<e.points.length;a++){var p=e.points[a],s={};for(var u in p){var c=p[u];p.hasOwnProperty(u)&&!Array.isArray(c)&&(r=c,"[object Object]"!==Object.prototype.toString.call(r))&&(s[u]=c)}null!=p&&(p.hasOwnProperty("curveNumber")&&p.hasOwnProperty("pointNumber")&&l[p.curveNumber].hasOwnProperty("customdata")&&(s.customdata=l[p.curveNumber].customdata[p.pointNumber]),p.hasOwnProperty("pointNumbers")&&(s.pointNumbers=p.pointNumbers)),i[a]=s}n.points=i}else if("relayout"===o||"restyle"===o)for(var u in e)e.hasOwnProperty(u)&&(n[u]=e[u]);return e.hasOwnProperty("range")&&(n.range=e.range),e.hasOwnProperty("lassoPoints")&&(n.lassoPoints=e.lassoPoints),n},c=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._settingViewport=!1,e._plotInitialized=!1,e._reacting=!1,e._relayouting=!1,e._end_relayouting=p.debounce(function(){e._relayouting=!1},2e3,{leading:!1}),e}return n(e,t),e.prototype.connect_signals=function(){t.prototype.connect_signals.call(this),this.connect(this.model.properties.viewport_update_policy.change,this._updateSetViewportFunction),this.connect(this.model.properties.viewport_update_throttle.change,this._updateSetViewportFunction),this.connect(this.model.properties._render_count.change,this.render),this.connect(this.model.properties.viewport.change,this._updateViewportFromProperty)},e.prototype.render=function(){var t=this;if(window.Plotly){for(var e=[],o=0;o<this.model.data.length;o++)e.push(this._get_trace(o,!1));var r=p.cloneDeep(this.model.layout);if(this._relayouting){var n=this.el.layout;p.forOwn(n,function(t,e){"axis"===e.slice(1,5)&&p.has(t,"range")&&(r[e].range=t.range)})}this._reacting=!0,s.react(this.el,e,r,this.model.config).then(function(){t._updateSetViewportFunction(),t._updateViewportProperty(),t._plotInitialized||(t.el.on("plotly_relayout",function(e){!0!==e._update_from_property&&(t.model.relayout_data=u(t.el,e,"relayout"),t._updateViewportProperty(),t._end_relayouting())}),t.el.on("plotly_relayouting",function(){"mouseup"!==t.model.viewport_update_policy&&(t._relayouting=!0,t._updateViewportProperty())}),t.el.on("plotly_restyle",function(e){t.model.restyle_data=u(t.el,e,"restyle"),t._updateViewportProperty()}),t.el.on("plotly_click",function(e){t.model.click_data=u(t.el,e,"click")}),t.el.on("plotly_hover",function(e){t.model.hover_data=u(t.el,e,"hover")}),t.el.on("plotly_selected",function(e){t.model.selected_data=u(t.el,e,"selected")}),t.el.on("plotly_clickannotation",function(e){delete e.event,delete e.fullAnnotation,t.model.clickannotation_data=e}),t.el.on("plotly_deselect",function(){t.model.selected_data=null}),t.el.on("plotly_unhover",function(){t.model.hover_data=null})),t._plotInitialized=!0,t._reacting=!1})}},e.prototype._get_trace=function(t,e){for(var o=l.clone(this.model.data[t]),r=this.model.data_sources[t],n=0,i=r.columns();n<i.length;n++){var a=i[n],p=r._shapes[a][0],s=r.get_array(a)[0];if(p.length>1){for(var u=[],c=0;c<p[0];c++)u.push(s.slice(c*p[1],(c+1)*p[1]));s=u}for(var _=a.split("."),d=_[_.length-1],y=o,h=0,f=_.slice(0,-1);h<f.length;h++){y=y[f[h]]}e&&1==_.length?y[d]=[s]:y[d]=s}return o},e.prototype._updateViewportFromProperty=function(){var t=this;if(s&&!this._settingViewport&&!this._reacting&&this.model.viewport){var e=this.el._fullLayout;p.forOwn(this.model.viewport,function(o,r){if(p.isEqual(p.get(e,r),o))return!0;var n=p.cloneDeep(t.model.viewport);return n._update_from_property=!0,s.relayout(t.el,n),!1})}},e.prototype._updateViewportProperty=function(){var t=this.el._fullLayout,e={};for(var o in t)if(t.hasOwnProperty(o)){var r=o.slice(0,5);"xaxis"!==r&&"yaxis"!==r||(e[o+".range"]=p.cloneDeep(t[o].range))}p.isEqual(e,this.model.viewport)||this._setViewport(e)},e.prototype._updateSetViewportFunction=function(){var t=this;"continuous"===this.model.viewport_update_policy||"mouseup"===this.model.viewport_update_policy?this._setViewport=function(e){t._settingViewport||(t._settingViewport=!0,t.model.viewport=e,t._settingViewport=!1)}:this._setViewport=p.throttle(function(e){t._settingViewport||(t._settingViewport=!0,t.model.viewport=e,t._settingViewport=!1)},this.model.viewport_update_throttle)},e.__name__="PlotlyPlotView",e}(a.HTMLBoxView);o.PlotlyPlotView=c;var _=function(t){function e(e){return t.call(this,e)||this}return n(e,t),e.init_PlotlyPlot=function(){this.prototype.default_view=c,this.define({data:[i.Array,[]],layout:[i.Any,{}],config:[i.Any,{}],data_sources:[i.Array,[]],relayout_data:[i.Any,{}],restyle_data:[i.Array,[]],click_data:[i.Any,{}],hover_data:[i.Any,{}],clickannotation_data:[i.Any,{}],selected_data:[i.Any,{}],viewport:[i.Any,{}],viewport_update_policy:[i.String,"mouseup"],viewport_update_throttle:[i.Number,200],_render_count:[i.Number,0]})},e.__name__="PlotlyPlot",e.__module__="panel.models.plotly",e}(a.HTMLBox);o.PlotlyPlot=_,_.init_PlotlyPlot()},
"1d01be8a6e": function _(t,e,s){var o,i=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var s in e)e.hasOwnProperty(s)&&(t[s]=e[s])})(t,e)},function(t,e){function s(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(s.prototype=e.prototype,new s)}),r=this&&this.__assign||function(){return(r=Object.assign||function(t){for(var e,s=1,o=arguments.length;s<o;s++)for(var i in e=arguments[s])Object.prototype.hasOwnProperty.call(e,i)&&(t[i]=e[i]);return t}).apply(this,arguments)},n=t("@bokehjs/core/layout"),l=t("@bokehjs/core/properties"),c=t("@bokehjs/models/widgets/widget"),h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,function(){e.render(),e.root.compute_layout()}),this.connect(this.model.properties.active.change,function(){return e.setCSS()}),this.connect(this.model.properties.bar_color.change,function(){return e.setCSS()}),this.connect(this.model.properties.css_classes.change,function(){return e.setCSS()}),this.connect(this.model.properties.value.change,function(){return e.setValue()}),this.connect(this.model.properties.max.change,function(){return e.setMax()})},e.prototype.render=function(){t.prototype.render.call(this);var e=r(r({},this.model.style),{display:"inline-block"});for(var s in this.progressEl=document.createElement("progress"),this.setValue(),this.setMax(),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode?"stretch_width"!=this.model.sizing_mode&&"stretch_both"!=this.model.sizing_mode&&"max"!=this.model.width_policy&&"fit"!=this.model.width_policy||(this.progressEl.style.width="100%"):this.model.width&&(this.progressEl.style.width=this.model.width+"px"),this.setCSS(),e)this.progressEl.style.setProperty(s,e[s]);this.el.appendChild(this.progressEl)},e.prototype.setCSS=function(){var t=this.model.css_classes.join(" ")+" "+this.model.bar_color;this.model.active?this.progressEl.className=t+" active":this.progressEl.className=t},e.prototype.setValue=function(){null!=this.model.value&&(this.progressEl.value=this.model.value)},e.prototype.setMax=function(){null!=this.model.max&&(this.progressEl.max=this.model.max)},e.prototype._update_layout=function(){this.layout=new n.VariadicBox(this.el),this.layout.set_sizing(this.box_sizing())},e.__name__="ProgressView",e}(c.WidgetView);s.ProgressView=h;var a=function(t){function e(e){return t.call(this,e)||this}return i(e,t),e.init_Progress=function(){this.prototype.default_view=h,this.define({active:[l.Boolean,!0],bar_color:[l.String,"primary"],style:[l.Any,{}],max:[l.Number,100],value:[l.Number,null]})},e.__name__="Progress",e.__module__="panel.models.widgets",e}(c.Widget);s.Progress=a,a.init_Progress()},
"4cbc2c8e7e": function _(t,e,n){var o,s=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)},function(t,e){function n(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)}),i=t("@bokehjs/core/properties"),r=t("@bokehjs/core/view"),a=t("@bokehjs/core/util/array"),c=t("@bokehjs/model"),h=t("@bokehjs/protocol/receiver");var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s(e,t),e.prototype.renderTo=function(){},e.__name__="StateView",e}(r.View);n.StateView=_;var p=function(t){function e(e){var n=t.call(this,e)||this;return n._receiver=new h.Receiver,n._cache={},n}return s(e,t),e.prototype.apply_state=function(t){this._receiver.consume(t.header),this._receiver.consume(t.metadata),this._receiver.consume(t.content),this._receiver.message&&this.document&&this.document.apply_json_patch(this._receiver.message.content)},e.prototype._receive_json=function(t,e){var n=JSON.parse(t);this._cache[e]=n;for(var o=this.state,s=0,i=this.values;s<i.length;s++){o=o[i[s]]}o===e?this.apply_state(n):this._cache[o]&&this.apply_state(this._cache[o])},e.prototype.set_state=function(t,e){var n=this,o=a.copy(this.values);o[this.widgets[t.id]]=e;for(var s,i,r,c=this.state,h=0,_=o;h<_.length;h++){var p=_[h];c=c[p]}this.values=o,this.json?this._cache[c]?this.apply_state(this._cache[c]):(s=c,i=function(t){return n._receive_json(t,c)},(r=new XMLHttpRequest).overrideMimeType("application/json"),r.open("GET",s,!0),r.onreadystatechange=function(){4==r.readyState&&200==r.status&&i(r.responseText)},r.send(null)):this.apply_state(c)},e.init_State=function(){this.prototype.default_view=_,this.define({json:[i.Boolean,!1],state:[i.Any,{}],widgets:[i.Any,{}],values:[i.Any,[]]})},e.__name__="State",e.__module__="panel.models.state",e}(c.Model);n.State=p,p.init_State()},
"780561860e": function _(t,e,o){var n,a=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},function(t,e){function o(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),s=t("@bokehjs/core/properties"),i=t("@bokehjs/models/layouts/html_box"),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.data.change,this._plot),this.connect(this.model.properties.data_sources.change,function(){return e._connect_sources()}),this._connected=[],this._connect_sources()},e.prototype._connect_sources=function(){for(var t in this.model.data_sources){var e=this.model.data_sources[t];this._connected.indexOf(t)<0&&(this.connect(e.properties.data.change,this._plot),this._connected.push(t))}},e.prototype._fetch_datasets=function(){var t={};for(var e in this.model.data_sources){for(var o=this.model.data_sources[e],n=[],a=o.columns(),s=0;s<o.data[a[0]].length;s++){for(var i={},r=0,c=a;r<c.length;r++){var _=c[r];i[_]=o.data[_][s]}n.push(i)}t[e]=n}return t},e.prototype.render=function(){t.prototype.render.call(this),this._plot()},e.prototype._plot=function(){if(this.model.data&&window.vegaEmbed){if(this.model.data_sources&&Object.keys(this.model.data_sources).length>0){var t=this._fetch_datasets();"data"in t&&(this.model.data.data.values=t.data,delete t.data),this.model.data.datasets=t}window.vegaEmbed(this.el,this.model.data,{actions:!1})}},e.__name__="VegaPlotView",e}(i.HTMLBoxView);o.VegaPlotView=r;var c=function(t){function e(e){return t.call(this,e)||this}return a(e,t),e.init_VegaPlot=function(){this.prototype.default_view=r,this.define({data:[s.Any],data_sources:[s.Any]})},e.__name__="VegaPlot",e.__module__="panel.models.vega",e}(i.HTMLBox);o.VegaPlot=c,c.init_VegaPlot()},
"4a2dcd4d15": function _(e,t,o){var i,n=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var o in t)t.hasOwnProperty(o)&&(e[o]=t[o])})(e,t)},function(e,t){function o(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(o.prototype=t.prototype,new o)}),l=e("@bokehjs/core/properties"),s=e("@bokehjs/models/widgets/widget"),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return n(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this._blocked=!1,this._time=Date.now()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()}),this.connect(this.model.properties.loop.change,function(){return t.set_loop()}),this.connect(this.model.properties.paused.change,function(){return t.set_paused()}),this.connect(this.model.properties.time.change,function(){return t.set_time()}),this.connect(this.model.properties.value.change,function(){return t.set_value()}),this.connect(this.model.properties.volume.change,function(){return t.set_volume()})},t.prototype.render=function(){var e=this;this.videoEl||(this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.videoEl.controls=!0,this.videoEl.src=this.model.value,this.videoEl.currentTime=this.model.time,this.videoEl.loop=this.model.loop,null!=this.model.volume?this.videoEl.volume=this.model.volume/100:this.model.volume=100*this.videoEl.volume,this.videoEl.onpause=function(){return e.model.paused=!0},this.videoEl.onplay=function(){return e.model.paused=!1},this.videoEl.ontimeupdate=function(){return e.update_time(e)},this.videoEl.onvolumechange=function(){return e.update_volume(e)},this.el.appendChild(this.videoEl),this.model.paused||this.videoEl.play())},t.prototype.update_time=function(e){Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.videoEl.currentTime,e._time=Date.now())},t.prototype.update_volume=function(e){e._blocked=!0,e.model.volume=100*e.videoEl.volume},t.prototype.set_loop=function(){this.videoEl.loop=this.model.loop},t.prototype.set_paused=function(){!this.videoEl.paused&&this.model.paused&&this.videoEl.pause(),this.videoEl.paused&&!this.model.paused&&this.videoEl.play()},t.prototype.set_volume=function(){this._blocked?this._blocked=!1:null!=this.model.volume&&(this.videoEl.volume=this.model.volume/100)},t.prototype.set_time=function(){this._blocked?this._blocked=!1:this.videoEl.currentTime=this.model.time},t.prototype.set_value=function(){this.videoEl.src=this.model.value},t.__name__="VideoView",t}(s.WidgetView);o.VideoView=d;var h=function(e){function t(t){return e.call(this,t)||this}return n(t,e),t.init_Video=function(){this.prototype.default_view=d,this.define({loop:[l.Boolean,!1],paused:[l.Boolean,!0],time:[l.Number,0],throttle:[l.Number,250],value:[l.Any,""],volume:[l.Number,null]})},t.__name__="Video",t.__module__="panel.models.widgets",t}(s.Widget);o.Video=h,h.init_Video()},
"cbedefa11b": function _(t,e,i){var o,n=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])})(t,e)},function(t,e){function i(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),s=t("@bokehjs/core/properties"),r=t("@bokehjs/models/widgets/widget"),h=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.constraints={audio:!1,video:!0},e}return n(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),null!==this.model.timeout&&this.set_timeout()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.snapshot.change,function(){return e.set_timeout()}),this.connect(this.model.properties.snapshot.change,function(){return e.snapshot()}),this.connect(this.model.properties.paused.change,function(){return e.model.paused?e.videoEl.pause():e.videoEl.play()})},e.prototype.set_timeout=function(){var t=this;this.timer&&(clearInterval(this.timer),this.timer=null),null!==this.model.timeout&&(this.timer=setInterval(function(){return t.snapshot()},this.model.timeout))},e.prototype.snapshot=function(){this.canvasEl.width=this.videoEl.videoWidth,this.canvasEl.height=this.videoEl.videoHeight;var t=this.canvasEl.getContext("2d");t&&t.drawImage(this.videoEl,0,0,this.canvasEl.width,this.canvasEl.height),this.model.value=this.canvasEl.toDataURL("image/"+this.model.format,.95)},e.prototype.remove=function(){t.prototype.remove.call(this),this.timer&&(clearInterval(this.timer),this.timer=null)},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.videoEl||(this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.canvasEl=document.createElement("canvas"),this.el.appendChild(this.videoEl),navigator.mediaDevices.getUserMedia&&navigator.mediaDevices.getUserMedia(this.constraints).then(function(t){e.videoEl.srcObject=t,e.model.paused||e.videoEl.play()}).catch(console.error))},e.__name__="VideoStreamView",e}(r.WidgetView);i.VideoStreamView=h;var a=function(t){function e(e){return t.call(this,e)||this}return n(e,t),e.init_VideoStream=function(){this.prototype.default_view=h,this.define({format:[s.String,"png"],paused:[s.Boolean,!1],snapshot:[s.Boolean,!1],timeout:[s.Number,null],value:[s.Any]}),this.override({height:240,width:320})},e.__name__="VideoStream",e.__module__="panel.models.widgets",e}(r.Widget);i.VideoStream=a,a.init_VideoStream()},
"d4af2357ca": function _(e,t,n){var r,i=this&&this.__extends||(r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},function(e,t){function n(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}),o=e("@bokehjs/core/properties"),a=e("@bokehjs/core/util/object"),s=e("@bokehjs/models/layouts/html_box"),d=e("@bokehjs/core/dom"),c=window.vtk;function _(e,t,n){var r=[0,0,0],i=Math.abs(e[t])>Math.abs(e[n])?t:n,o=e[i]>0?1:-1;return r[i]=o,r}var l=function(e){function t(){var t=null!==e&&e.apply(this,arguments)||this;return t._setting=!1,t}return i(t,e),t.prototype.initialize=function(){this._container=d.div({style:{width:"100%",height:"100%"}}),e.prototype.initialize.call(this)},t.prototype._create_orientation_widget=function(){var e=this,t=c.Rendering.Core.vtkAxesActor.newInstance(),n=c.Interaction.Widgets.vtkOrientationMarkerWidget.newInstance({actor:t,interactor:this._interactor});n.setEnabled(!0),n.setViewportCorner(c.Interaction.Widgets.vtkOrientationMarkerWidget.Corners.BOTTOM_RIGHT),n.setViewportSize(.15),n.setMinPixelSize(100),n.setMaxPixelSize(300),this._orientationWidget=n;var r=c.Widgets.Core.vtkWidgetManager.newInstance();r.setRenderer(n.getRenderer());var i=c.Widgets.Widgets3D.vtkInteractiveOrientationWidget.newInstance();i.placeWidget(t.getBounds()),i.setBounds(t.getBounds()),i.setPlaceFactor(1);var o=r.addWidget(i);this._widgetManager=r,o.onOrientationChange(function(t){var n=t.direction,r=e._camera.getFocalPoint(),i=e._camera.getPosition(),o=e._camera.getViewUp(),a=Math.sqrt(Math.pow(i[0]-r[0],2)+Math.pow(i[1]-r[1],2)+Math.pow(i[2]-r[2],2));e._camera.setPosition(r[0]+n[0]*a,r[1]+n[1]*a,r[2]+n[2]*a),n[0]&&e._camera.setViewUp(_(o,1,2)),n[1]&&e._camera.setViewUp(_(o,0,2)),n[2]&&e._camera.setViewUp(_(o,0,1)),e._orientationWidget.updateMarkerOrientation(),e._renderer.resetCameraClippingRange(),e._rendererEl.getRenderWindow().render()}),this._orientation_widget_visbility(this.model.orientation_widget)},t.prototype.after_layout=function(){var t=this;this._rendererEl||(this.el.appendChild(this._container),this._rendererEl=c.Rendering.Misc.vtkFullScreenRenderWindow.newInstance({rootContainer:this.el,container:this._container}),this._renderer=this._rendererEl.getRenderer(),this._interactor=this._rendererEl.getInteractor(),this._camera=this._renderer.getActiveCamera(),this._plot(),this._camera.onModified(function(){return t._get_camera_state()}),this._remove_default_key_binding(),this.model.renderer_el=this._rendererEl),e.prototype.after_layout.call(this)},t.prototype._orientation_widget_visbility=function(e){this._orientationWidget.setEnabled(e),e?this._widgetManager.enablePicking():this._widgetManager.disablePicking(),this._orientationWidget.updateMarkerOrientation(),this._rendererEl.getRenderWindow().render()},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.data.change,function(){return t._plot()}),this.connect(this.model.properties.camera.change,function(){return t._set_camera_state()}),this.connect(this.model.properties.orientation_widget.change,function(){t._orientation_widget_visbility(t.model.orientation_widget)}),this._container.addEventListener("mouseenter",function(){t.model.enable_keybindings&&(document.querySelector("body").addEventListener("keypress",t._interactor.handleKeyPress),document.querySelector("body").addEventListener("keydown",t._interactor.handleKeyDown),document.querySelector("body").addEventListener("keyup",t._interactor.handleKeyUp))}),this._container.addEventListener("mouseleave",function(){document.querySelector("body").removeEventListener("keypress",t._interactor.handleKeyPress),document.querySelector("body").removeEventListener("keydown",t._interactor.handleKeyDown),document.querySelector("body").removeEventListener("keyup",t._interactor.handleKeyUp)})},t.prototype._remove_default_key_binding=function(){document.querySelector("body").removeEventListener("keypress",this._interactor.handleKeyPress),document.querySelector("body").removeEventListener("keydown",this._interactor.handleKeyDown),document.querySelector("body").removeEventListener("keyup",this._interactor.handleKeyUp)},t.prototype._get_camera_state=function(){if(!this._setting){this._setting=!0;var e=a.clone(this._camera.get());delete e.classHierarchy,delete e.vtkObject,delete e.vtkCamera,delete e.viewPlaneNormal,this.model.camera=e,this._setting=!1}},t.prototype._set_camera_state=function(){if(!this._setting){this._setting=!0;try{this._camera.set(this.model.camera)}finally{this._setting=!1}null!=this._orientationWidget&&this._orientationWidget.updateMarkerOrientation(),this._renderer.resetCameraClippingRange(),this._rendererEl.getRenderWindow().render()}},t.prototype._plot=function(){var e=this;if(this._delete_all_actors(),this.model.data)var t=c.IO.Core.DataAccessHelper.get("zip",{zipContent:atob(this.model.data),callback:function(n){var r=c.IO.Core.vtkHttpSceneLoader.newInstance({renderer:e._rendererEl.getRenderer(),dataAccessHelper:t}),i=c.macro.debounce(function(){null==e._orientationWidget&&e._create_orientation_widget(),e._set_camera_state()},100);r.setUrl("index.json"),r.onReady(i)}});else this._rendererEl.getRenderWindow().render()},t.prototype._delete_all_actors=function(){var e=this;this._renderer.getActors().map(function(t){return e._renderer.removeActor(t)})},t.__name__="VTKPlotView",t}(s.HTMLBoxView);n.VTKPlotView=l;var h=function(e){function t(t){var n=e.call(this,t)||this;n.renderer_el=null,n.outline=c.Filters.General.vtkOutlineFilter.newInstance();var r=c.Rendering.Core.vtkMapper.newInstance();return r.setInputConnection(n.outline.getOutputPort()),n.outline_actor=c.Rendering.Core.vtkActor.newInstance(),n.outline_actor.setMapper(r),n}return i(t,e),t.prototype.getActors=function(){return this.renderer_el.getRenderer().getActors()},t.init_VTKPlot=function(){this.prototype.default_view=l,this.define({data:[o.String],camera:[o.Any],enable_keybindings:[o.Boolean,!1],orientation_widget:[o.Boolean,!1]}),this.override({height:300,width:300})},t.__name__="VTKPlot",t.__module__="panel.models.vtk",t}(s.HTMLBox);n.VTKPlot=h,h.init_VTKPlot()},
"64e1d58d42": function _(e,t,r){var n,o=this&&this.__extends||(n=function(e,t){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})(e,t)},function(e,t){function r(){this.constructor=e}n(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}),i=e("@bokehjs/core/properties"),a=e("@bokehjs/core/util/serialization"),s=e("@bokehjs/models/layouts/html_box"),l=e("@bokehjs/core/dom"),c=window.vtk;function p(e){for(var t=new ArrayBuffer(e.length),r=new Uint8Array(t),n=0,o=e.length;n<o;n++)r[n]=e.charCodeAt(n);return t}var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o(t,e),t.prototype.after_layout=function(){this._rendererEl||(this._controllerWidget=c.Interaction.UI.vtkVolumeController.newInstance({size:[400,150],rescaleColorMap:!1}),this._controllerWidget.setContainer(this.el),this._container=l.div({style:{width:"100%",height:"100%"}}),this.el.appendChild(this._container),this._rendererEl=c.Rendering.Misc.vtkFullScreenRenderWindow.newInstance({rootContainer:this.el,container:this._container}),this._rendererEl.getRenderWindow().getInteractor(),this._rendererEl.getRenderWindow().getInteractor().setDesiredUpdateRate(45),this._plot(),this._rendererEl.getRenderer().resetCamera(),this._rendererEl.getRenderWindow().render()),e.prototype.after_layout.call(this)},t.prototype._create_source=function(){var e=this.model.data,t=c.Common.DataModel.vtkImageData.newInstance({spacing:e.spacing});t.setDimensions(e.dims),t.setOrigin(null!=e.origin?e.origin:e.dims.map(function(e){return e/2}));var r=c.Common.Core.vtkDataArray.newInstance({name:"scalars",numberOfComponents:1,values:new a.ARRAY_TYPES[e.dtype](p(atob(e.buffer)))});return t.getPointData().setScalars(r),t},t.prototype._plot=function(){var e=this._create_source(),t=c.Rendering.Core.vtkVolume.newInstance(),r=c.Rendering.Core.vtkVolumeMapper.newInstance();t.setMapper(r),r.setInputData(e);var n=(e.getPointData().getScalars()||e.getPointData().getArrays()[0]).getRange(),o=c.Rendering.Core.vtkColorTransferFunction.newInstance(),i=c.Common.DataModel.vtkPiecewiseFunction.newInstance(),a=.7*Math.sqrt(e.getSpacing().map(function(e){return e*e}).reduce(function(e,t){return e+t},0));r.setSampleDistance(a),t.getProperty().setRGBTransferFunction(0,o),t.getProperty().setScalarOpacity(0,i),t.getProperty().setInterpolationTypeToFastLinear(),t.getProperty().setScalarOpacityUnitDistance(0,c.Common.DataModel.vtkBoundingBox.getDiagonalLength(e.getBounds())/Math.max.apply(Math,e.getDimensions())),t.getProperty().setGradientOpacityMinimumValue(0,0),t.getProperty().setGradientOpacityMaximumValue(0,.05*(n[1]-n[0])),t.getProperty().setShade(!0),t.getProperty().setUseGradientOpacity(0,!0),t.getProperty().setGradientOpacityMinimumOpacity(0,0),t.getProperty().setGradientOpacityMaximumOpacity(0,1),t.getProperty().setAmbient(.2),t.getProperty().setDiffuse(.7),t.getProperty().setSpecular(.3),t.getProperty().setSpecularPower(8),this._rendererEl.getRenderer().addVolume(t),this._controllerWidget.setupContent(this._rendererEl.getRenderWindow(),t,!0)},t.__name__="VTKVolumePlotView",t}(s.HTMLBoxView);r.VTKVolumePlotView=u;var d=function(e){function t(t){return e.call(this,t)||this}return o(t,e),t.init_VTKVolumePlot=function(){this.prototype.default_view=u,this.define({data:[i.Any],actor:[i.Any]}),this.override({height:300,width:300})},t.__name__="VTKVolumePlot",t.__module__="panel.models.vtk",t}(s.HTMLBox);r.VTKVolumePlot=d,d.init_VTKVolumePlot()},
}, "55dac5102b", {"index":"55dac5102b","models/index":"1d13522e8a","models/ace":"c167e0e33e","models/audio":"d2f2f8c2b2","models/html":"cef8bc2777","models/katex":"7a3cc4b4c6","models/mathjax":"75803aafc7","models/player":"24a20e4790","models/plotly":"c864119ab3","models/progress":"1d01be8a6e","models/state":"4cbc2c8e7e","models/vega":"780561860e","models/video":"4a2dcd4d15","models/videostream":"cbedefa11b","models/vtk":"d4af2357ca","models/vtkvolume":"64e1d58d42"}, {});
})

//# sourceMappingURL=panel.min.js.map
