/*
 * Decompiled with CFR 0.152.
 */
package org.pbjar.jxlayer.repaint;

import com.github.weisj.darklaf.log.LogFormatter;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;
import org.jdesktop.swingx.ForwardingRepaintManager;
import org.pbjar.jxlayer.repaint.RepaintManagerProvider;
import org.pbjar.jxlayer.repaint.WrappedRepaintManager;

public final class RepaintManagerUtils {
    private static final Logger LOGGER = Logger.getLogger(RepaintManagerUtils.class.getName());
    private static final boolean swingX = RepaintManagerUtils.isSwingXAvailable();

    private RepaintManagerUtils() {
    }

    public static Action createRPDisplayAction() {
        return new DisplayAction();
    }

    public static void ensureRepaintManagerSet(Component c, RepaintManagerProvider provider) {
        RepaintManagerUtils.ensureImpl(RepaintManager.currentManager(c), provider);
    }

    private static void ensureImpl(RepaintManager delegate, RepaintManagerProvider provider) {
        RepaintManager manager = delegate;
        while (!provider.isAdequate(manager.getClass())) {
            if (swingX) {
                if (manager instanceof ForwardingRepaintManager) {
                    manager = ((ForwardingRepaintManager)manager).getDelegateManager();
                    continue;
                }
                RepaintManager.setCurrentManager(RepaintManagerUtils.createManager(provider.getForwardingRepaintManagerClass(), delegate));
                break;
            }
            if (manager instanceof WrappedRepaintManager) {
                manager = ((WrappedRepaintManager)manager).getDelegateManager();
                continue;
            }
            RepaintManager.setCurrentManager(RepaintManagerUtils.createManager(provider.getWrappedRepaintManagerClass(), delegate));
            break;
        }
    }

    private static RepaintManager createManager(Class<? extends RepaintManager> clazz, RepaintManager delegate) {
        try {
            RepaintManager newManager = clazz.getConstructor(RepaintManager.class).newInstance(delegate);
            return newManager;
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot instantiate " + clazz.getName(), t);
        }
    }

    public static void ensureRepaintManagerSet(JComponent c, RepaintManagerProvider provider) {
        RepaintManagerUtils.ensureImpl(RepaintManager.currentManager(c), provider);
    }

    private static boolean isSwingXAvailable() {
        try {
            Class<ForwardingRepaintManager> clazz = ForwardingRepaintManager.class;
            LOGGER.info("SwingX is available");
            return clazz != null;
        }
        catch (Throwable t) {
            LOGGER.info("SwingX is not available");
            return false;
        }
    }

    static {
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter());
        LOGGER.addHandler(handler);
    }

    private static class DisplayAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DisplayAction() {
            super("RPM tree");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent c = (JComponent)e.getSource();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("The tree for the current RepaintManager:");
            pw.println();
            RepaintManager manager = RepaintManager.currentManager(c);
            this.appendDelegates(pw, manager);
            pw.close();
            String text = sw.toString();
            JTextPane message = new JTextPane();
            message.setFont(Font.decode("Monospaced"));
            message.setContentType("text/plain");
            message.setText(text);
            message.setEditable(false);
            JOptionPane.showMessageDialog(c, message, "The RepaintManager tree", 1);
        }

        private void appendClass(PrintWriter writer, Object obj) {
            String prefix = "Class:   ";
            for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                writer.println(prefix + clazz.getName());
                prefix = "Extends: ";
            }
        }

        private void appendDelegates(PrintWriter writer, Object rp) {
            this.appendClass(writer, rp);
            RepaintManager delegate = rp instanceof WrappedRepaintManager ? ((WrappedRepaintManager)rp).getDelegateManager() : (swingX ? (rp instanceof ForwardingRepaintManager ? ((ForwardingRepaintManager)rp).getDelegateManager() : null) : null);
            if (delegate != null) {
                writer.println();
                writer.println("Delegate:");
                this.appendDelegates(writer, delegate);
            }
        }
    }
}

