/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import java.util.Arrays;
import org.ejml.MatrixDimensionException;
import org.ejml.UtilEjml;
import org.ejml.data.FGrowArray;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.interfaces.decomposition.LUSparseDecomposition_F32;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.masks.Mask;
import org.ejml.ops.FOperatorBinary;
import org.ejml.ops.FOperatorBinaryIdx;
import org.ejml.ops.FOperatorUnary;
import org.ejml.ops.IPredicateBinary;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.MatrixFeatures_FSCC;
import org.ejml.sparse.csc.factory.DecompositionFactory_FSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_FSCC;
import org.ejml.sparse.csc.misc.ImplCommonOps_FSCC;
import org.ejml.sparse.csc.mult.ImplMultiplication_FSCC;
import org.jetbrains.annotations.Nullable;

public class CommonOps_FSCC {
    public static boolean checkIndicesSorted(FMatrixSparseCSC A2) {
        for (int j = 0; j < A2.numCols; ++j) {
            int idx0 = A2.col_idx[j];
            int idx1 = A2.col_idx[j + 1];
            if (idx0 != idx1 && A2.nz_rows[idx0] >= A2.numRows) {
                return false;
            }
            for (int i = idx0 + 1; i < idx1; ++i) {
                int row = A2.nz_rows[i];
                if (A2.nz_rows[i - 1] >= row) {
                    return false;
                }
                if (row < A2.numRows) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkStructure(FMatrixSparseCSC A2) {
        if (A2.col_idx.length < A2.numCols + 1) {
            return false;
        }
        if (A2.col_idx[A2.numCols] != A2.nz_length) {
            return false;
        }
        if (A2.nz_rows.length < A2.nz_length) {
            return false;
        }
        if (A2.nz_values.length < A2.nz_length) {
            return false;
        }
        if (A2.col_idx[0] != 0) {
            return false;
        }
        for (int i = 0; i < A2.numCols; ++i) {
            if (A2.col_idx[i] > A2.col_idx[i + 1]) {
                return false;
            }
            if (A2.col_idx[i + 1] - A2.col_idx[i] <= A2.numRows) continue;
            return false;
        }
        if (!CommonOps_FSCC.checkSortedFlag(A2)) {
            return false;
        }
        return !CommonOps_FSCC.checkDuplicateElements(A2);
    }

    public static boolean checkSortedFlag(FMatrixSparseCSC A2) {
        if (A2.indicesSorted) {
            return CommonOps_FSCC.checkIndicesSorted(A2);
        }
        return true;
    }

    public static boolean checkDuplicateElements(FMatrixSparseCSC A2) {
        A2 = A2.copy();
        A2.sortIndices(null);
        return !CommonOps_FSCC.checkSortedFlag(A2);
    }

    public static FMatrixSparseCSC transpose(FMatrixSparseCSC A2, @Nullable FMatrixSparseCSC A_t, @Nullable IGrowArray gw) {
        A_t = UtilEjml.reshapeOrDeclare(A_t, A2.numCols, A2.numRows, A2.nz_length);
        ImplCommonOps_FSCC.transpose(A2, A_t, gw);
        return A_t;
    }

    public static FMatrixSparseCSC mult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC outputC) {
        return CommonOps_FSCC.mult(A2, B, outputC, null, null);
    }

    public static FMatrixSparseCSC mult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC outputC, @Nullable IGrowArray gw, @Nullable FGrowArray gx) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2, A2.numRows, B.numCols);
        ImplMultiplication_FSCC.mult(A2, B, outputC, gw, gx);
        return outputC;
    }

    public static FMatrixRMaj mult(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj outputC) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numRows, B.numCols);
        ImplMultiplication_FSCC.mult(A2, B, outputC);
        return outputC;
    }

    public static void multAdd(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC) {
        if (A2.numCols != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numRows != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        ImplMultiplication_FSCC.multAdd(A2, B, outputC);
    }

    public static FMatrixRMaj multTransA(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj outputC, @Nullable FGrowArray work) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (work == null) {
            work = new FGrowArray();
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numCols, B.numCols);
        ImplMultiplication_FSCC.multTransA(A2, B, outputC, work);
        return outputC;
    }

    public static void multAddTransA(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC, @Nullable FGrowArray work) {
        if (A2.numRows != B.numRows) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numCols != outputC.numRows || B.numCols != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (work == null) {
            work = new FGrowArray();
        }
        ImplMultiplication_FSCC.multAddTransA(A2, B, outputC, work);
    }

    public static FMatrixRMaj multTransB(FMatrixSparseCSC A2, FMatrixRMaj B, @Nullable FMatrixRMaj outputC, @Nullable FGrowArray work) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numRows, B.numRows);
        if (work == null) {
            work = new FGrowArray();
        }
        ImplMultiplication_FSCC.multTransB(A2, B, outputC, work);
        return outputC;
    }

    public static void multAddTransB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC, @Nullable FGrowArray work) {
        if (A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numRows != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        if (work == null) {
            work = new FGrowArray();
        }
        ImplMultiplication_FSCC.multAddTransB(A2, B, outputC, work);
    }

    public static FMatrixRMaj multTransAB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2.numCols, B.numRows);
        ImplMultiplication_FSCC.multTransAB(A2, B, outputC);
        return outputC;
    }

    public static void multAddTransAB(FMatrixSparseCSC A2, FMatrixRMaj B, FMatrixRMaj outputC) {
        if (A2.numRows != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        if (A2.numCols != outputC.numRows || B.numRows != outputC.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B, outputC));
        }
        ImplMultiplication_FSCC.multAddTransAB(A2, B, outputC);
    }

    public static void symmLowerToFull(FMatrixSparseCSC A2, FMatrixSparseCSC outputB, @Nullable IGrowArray gw) {
        ImplCommonOps_FSCC.symmLowerToFull(A2, outputB, gw);
    }

    public static FMatrixSparseCSC add(float alpha, FMatrixSparseCSC A2, float beta, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC outputC, @Nullable IGrowArray gw, @Nullable FGrowArray gx) {
        if (A2.numRows != B.numRows || A2.numCols != B.numCols) {
            throw new MatrixDimensionException("Inconsistent matrix shapes. " + UtilEjml.stringShapes(A2, B));
        }
        outputC = UtilEjml.reshapeOrDeclare(outputC, A2, A2.numRows, A2.numCols);
        ImplCommonOps_FSCC.add(alpha, A2, beta, B, outputC, gw, gx);
        return outputC;
    }

    public static FMatrixSparseCSC identity(int length) {
        return CommonOps_FSCC.identity(length, length);
    }

    public static FMatrixSparseCSC identity(int numRows, int numCols) {
        int min = Math.min(numRows, numCols);
        FMatrixSparseCSC A2 = new FMatrixSparseCSC(numRows, numCols, min);
        CommonOps_FSCC.setIdentity(A2);
        return A2;
    }

    public static void setIdentity(FMatrixSparseCSC A2) {
        int i;
        int min = Math.min(A2.numRows, A2.numCols);
        A2.growMaxLength(min, false);
        A2.nz_length = min;
        Arrays.fill(A2.nz_values, 0, min, 1.0f);
        for (i = 1; i <= min; ++i) {
            A2.col_idx[i] = i;
            A2.nz_rows[i - 1] = i - 1;
        }
        for (i = min + 1; i <= A2.numCols; ++i) {
            A2.col_idx[i] = min;
        }
    }

    public static void scale(float scalar, FMatrixSparseCSC A2, FMatrixSparseCSC outputB) {
        if (A2 != outputB) {
            outputB.copyStructure(A2);
            for (int i = 0; i < A2.nz_length; ++i) {
                outputB.nz_values[i] = A2.nz_values[i] * scalar;
            }
        } else {
            int i = 0;
            while (i < A2.nz_length) {
                int n = i++;
                outputB.nz_values[n] = outputB.nz_values[n] * scalar;
            }
        }
    }

    public static void divide(FMatrixSparseCSC A2, float scalar, FMatrixSparseCSC outputB) {
        if (A2 != outputB) {
            outputB.copyStructure(A2);
            for (int i = 0; i < A2.nz_length; ++i) {
                outputB.nz_values[i] = A2.nz_values[i] / scalar;
            }
        } else {
            int i = 0;
            while (i < A2.nz_length) {
                int n = i++;
                A2.nz_values[n] = A2.nz_values[n] / scalar;
            }
        }
    }

    public static void divide(float scalar, FMatrixSparseCSC A2, FMatrixSparseCSC outputB) {
        if (A2 != outputB) {
            outputB.copyStructure(A2);
        }
        for (int i = 0; i < A2.nz_length; ++i) {
            outputB.nz_values[i] = scalar / A2.nz_values[i];
        }
    }

    public static void changeSign(FMatrixSparseCSC A2, FMatrixSparseCSC outputB) {
        if (A2 != outputB) {
            outputB.copyStructure(A2);
        }
        for (int i = 0; i < A2.nz_length; ++i) {
            outputB.nz_values[i] = -A2.nz_values[i];
        }
    }

    public static float elementMinAbs(FMatrixSparseCSC A2) {
        if (A2.nz_length == 0) {
            return 0.0f;
        }
        float min = A2.isFull() ? Math.abs(A2.nz_values[0]) : 0.0f;
        for (int i = 0; i < A2.nz_length; ++i) {
            float val = Math.abs(A2.nz_values[i]);
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static float elementMaxAbs(FMatrixSparseCSC A2) {
        if (A2.nz_length == 0) {
            return 0.0f;
        }
        float max = A2.isFull() ? Math.abs(A2.nz_values[0]) : 0.0f;
        for (int i = 0; i < A2.nz_length; ++i) {
            float val = Math.abs(A2.nz_values[i]);
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static float elementMin(FMatrixSparseCSC A2) {
        if (A2.nz_length == 0) {
            return 0.0f;
        }
        float min = A2.isFull() ? A2.nz_values[0] : 0.0f;
        for (int i = 0; i < A2.nz_length; ++i) {
            float val = A2.nz_values[i];
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public static float elementMax(FMatrixSparseCSC A2) {
        if (A2.nz_length == 0) {
            return 0.0f;
        }
        float max = A2.isFull() ? A2.nz_values[0] : 0.0f;
        for (int i = 0; i < A2.nz_length; ++i) {
            float val = A2.nz_values[i];
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public static float elementSum(FMatrixSparseCSC A2) {
        if (A2.nz_length == 0) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (int i = 0; i < A2.nz_length; ++i) {
            sum += A2.nz_values[i];
        }
        return sum;
    }

    public static FMatrixSparseCSC elementMult(FMatrixSparseCSC A2, FMatrixSparseCSC B, @Nullable FMatrixSparseCSC output, @Nullable IGrowArray gw, @Nullable FGrowArray gx) {
        if (A2.numCols != B.numCols || A2.numRows != B.numRows) {
            throw new MatrixDimensionException("All inputs must have the same number of rows and columns. " + UtilEjml.stringShapes(A2, B));
        }
        output = UtilEjml.reshapeOrDeclare(output, A2, A2.numRows, A2.numCols);
        ImplCommonOps_FSCC.elementMult(A2, B, output, gw, gx);
        return output;
    }

    public static void maxAbsCols(FMatrixSparseCSC A2, @Nullable FMatrixRMaj outputB) {
        outputB = UtilEjml.reshapeOrDeclare(outputB, 1, A2.numCols);
        for (int i = 0; i < A2.numCols; ++i) {
            int idx0 = A2.col_idx[i];
            int idx1 = A2.col_idx[i + 1];
            float maxabs = 0.0f;
            for (int j = idx0; j < idx1; ++j) {
                float v = Math.abs(A2.nz_values[j]);
                if (!(v > maxabs)) continue;
                maxabs = v;
            }
            outputB.data[i] = maxabs;
        }
    }

    public static void multColumns(FMatrixSparseCSC A2, float[] values, int offset) {
        if (values.length + offset < A2.numCols) {
            throw new IllegalArgumentException("Array is too small. " + values.length + " < " + A2.numCols);
        }
        for (int i = 0; i < A2.numCols; ++i) {
            int idx0 = A2.col_idx[i];
            int idx1 = A2.col_idx[i + 1];
            float v = values[offset + i];
            int j = idx0;
            while (j < idx1) {
                int n = j++;
                A2.nz_values[n] = A2.nz_values[n] * v;
            }
        }
    }

    public static void divideColumns(FMatrixSparseCSC A2, float[] values, int offset) {
        if (values.length + offset < A2.numCols) {
            throw new IllegalArgumentException("Array is too small. " + values.length + " < " + A2.numCols);
        }
        for (int i = 0; i < A2.numCols; ++i) {
            int idx0 = A2.col_idx[i];
            int idx1 = A2.col_idx[i + 1];
            float v = values[offset + i];
            int j = idx0;
            while (j < idx1) {
                int n = j++;
                A2.nz_values[n] = A2.nz_values[n] / v;
            }
        }
    }

    public static void multRowsCols(float[] diagA, int offsetA, FMatrixSparseCSC B, float[] diagC, int offsetC) {
        if (diagA.length + offsetA < B.numRows) {
            throw new IllegalArgumentException("diagA is too small.");
        }
        if (diagC.length + offsetC < B.numCols) {
            throw new IllegalArgumentException("diagA is too small.");
        }
        for (int i = 0; i < B.numCols; ++i) {
            int idx0 = B.col_idx[i];
            int idx1 = B.col_idx[i + 1];
            float c = diagC[offsetC + i];
            for (int j = idx0; j < idx1; ++j) {
                int n = j;
                B.nz_values[n] = B.nz_values[n] * (c * diagA[offsetA + B.nz_rows[j]]);
            }
        }
    }

    public static void divideRowsCols(float[] diagA, int offsetA, FMatrixSparseCSC B, float[] diagC, int offsetC) {
        if (diagA.length + offsetA < B.numRows) {
            throw new IllegalArgumentException("diagA is too small.");
        }
        if (diagC.length + offsetC < B.numCols) {
            throw new IllegalArgumentException("diagA is too small.");
        }
        for (int i = 0; i < B.numCols; ++i) {
            int idx0 = B.col_idx[i];
            int idx1 = B.col_idx[i + 1];
            float c = diagC[offsetC + i];
            for (int j = idx0; j < idx1; ++j) {
                int n = j;
                B.nz_values[n] = B.nz_values[n] / (c * diagA[offsetA + B.nz_rows[j]]);
            }
        }
    }

    public static FMatrixSparseCSC diag(float ... values) {
        int N = values.length;
        return CommonOps_FSCC.diag(new FMatrixSparseCSC(N, N, N), values, 0, N);
    }

    public static FMatrixSparseCSC diag(@Nullable FMatrixSparseCSC A2, float[] values, int offset, int length) {
        int N = length;
        if (A2 == null) {
            A2 = new FMatrixSparseCSC(N, N, N);
        } else {
            A2.reshape(N, N, N);
        }
        A2.nz_length = N;
        for (int i = 0; i < N; ++i) {
            A2.col_idx[i + 1] = i + 1;
            A2.nz_rows[i] = i;
            A2.nz_values[i] = values[offset + i];
        }
        return A2;
    }

    public static void extractDiag(FMatrixSparseCSC A2, FMatrixSparseCSC outputB) {
        int N = Math.min(A2.numRows, A2.numCols);
        if (!MatrixFeatures_FSCC.isVector(outputB)) {
            outputB.reshape(N, 1, N);
        } else if (outputB.numRows * outputB.numCols != N) {
            outputB.reshape(N, 1, N);
        } else {
            outputB.growMaxLength(N, false);
        }
        outputB.nz_length = N;
        outputB.indicesSorted = true;
        if (outputB.numRows != 1) {
            outputB.col_idx[0] = 0;
            outputB.col_idx[1] = N;
            for (int i = 0; i < N; ++i) {
                outputB.nz_values[i] = A2.unsafe_get(i, i);
                outputB.nz_rows[i] = i;
            }
        } else {
            outputB.col_idx[0] = 0;
            for (int i = 0; i < N; ++i) {
                outputB.nz_values[i] = A2.unsafe_get(i, i);
                outputB.nz_rows[i] = 0;
                outputB.col_idx[i + 1] = i + 1;
            }
        }
    }

    public static void extractDiag(FMatrixSparseCSC A2, FMatrixRMaj outputB) {
        int N = Math.min(A2.numRows, A2.numCols);
        if (outputB.getNumElements() != N || outputB.numRows != 1 && outputB.numCols != 1) {
            outputB.reshape(N, 1);
        }
        for (int i = 0; i < N; ++i) {
            outputB.data[i] = A2.unsafe_get(i, i);
        }
    }

    public static FMatrixSparseCSC permutationMatrix(int[] p, boolean inverse, int N, @Nullable FMatrixSparseCSC P) {
        if (P == null) {
            P = new FMatrixSparseCSC(N, N, N);
        } else {
            P.reshape(N, N, N);
        }
        P.indicesSorted = true;
        P.nz_length = N;
        if (!inverse) {
            for (int i = 0; i < N; ++i) {
                P.col_idx[i + 1] = i + 1;
                P.nz_rows[p[i]] = i;
                P.nz_values[i] = 1.0f;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                P.col_idx[i + 1] = i + 1;
                P.nz_rows[i] = p[i];
                P.nz_values[i] = 1.0f;
            }
        }
        return P;
    }

    public static void permutationVector(FMatrixSparseCSC P, int[] vector) {
        if (P.numCols != P.numRows) {
            throw new MatrixDimensionException("Expected a square matrix");
        }
        if (P.nz_length != P.numCols) {
            throw new IllegalArgumentException("Expected N non-zero elements in permutation matrix");
        }
        if (vector.length < P.numCols) {
            throw new IllegalArgumentException("vector is too short");
        }
        int M = P.numCols;
        for (int i = 0; i < M; ++i) {
            if (P.col_idx[i + 1] != i + 1) {
                throw new IllegalArgumentException("Unexpected number of elements in a column");
            }
            vector[P.nz_rows[i]] = i;
        }
    }

    public static void permutationInverse(int[] original, int[] inverse, int length) {
        for (int i = 0; i < length; ++i) {
            inverse[original[i]] = i;
        }
    }

    public static int[] permutationInverse(int[] original, int length) {
        int[] inverse = new int[length];
        CommonOps_FSCC.permutationInverse(original, inverse, length);
        return inverse;
    }

    public static void permuteRowInv(int[] permInv, FMatrixSparseCSC input, FMatrixSparseCSC output) {
        if (input.numRows > permInv.length) {
            throw new IllegalArgumentException("permutation vector must have at least as many elements as input has rows");
        }
        output.reshape(input.numRows, input.numCols, input.nz_length);
        output.nz_length = input.nz_length;
        output.indicesSorted = false;
        System.arraycopy(input.nz_values, 0, output.nz_values, 0, input.nz_length);
        System.arraycopy(input.col_idx, 0, output.col_idx, 0, input.numCols + 1);
        int idx0 = 0;
        for (int i = 0; i < input.numCols; ++i) {
            int idx1 = output.col_idx[i + 1];
            for (int j = idx0; j < idx1; ++j) {
                output.nz_rows[j] = permInv[input.nz_rows[j]];
            }
            idx0 = idx1;
        }
    }

    public static void permute(@Nullable int[] permRowInv, FMatrixSparseCSC input, @Nullable int[] permCol, FMatrixSparseCSC output) {
        if (permRowInv != null && input.numRows > permRowInv.length) {
            throw new IllegalArgumentException("rowInv permutation vector must have at least as many elements as input has columns");
        }
        if (permCol != null && input.numCols > permCol.length) {
            throw new IllegalArgumentException("permCol permutation vector must have at least as many elements as input has rows");
        }
        output.reshape(input.numRows, input.numCols, input.nz_length);
        output.indicesSorted = false;
        output.nz_length = input.nz_length;
        int N = input.numCols;
        int outputNZ = 0;
        for (int i = 0; i < N; ++i) {
            int inputCol = permCol != null ? permCol[i] : i;
            int inputNZ = input.col_idx[inputCol];
            int total = input.col_idx[inputCol + 1] - inputNZ;
            output.col_idx[i + 1] = output.col_idx[i] + total;
            for (int j = 0; j < total; ++j) {
                int row = input.nz_rows[inputNZ];
                output.nz_rows[outputNZ] = permRowInv != null ? permRowInv[row] : row;
                output.nz_values[outputNZ++] = input.nz_values[inputNZ++];
            }
        }
    }

    public static void permute(int[] perm, float[] input, float[] output, int N) {
        for (int k = 0; k < N; ++k) {
            output[k] = input[perm[k]];
        }
    }

    public static void permuteInv(int[] perm, float[] input, float[] output, int N) {
        for (int k = 0; k < N; ++k) {
            output[perm[k]] = input[k];
        }
    }

    public static void permuteSymmetric(FMatrixSparseCSC input, int[] permInv, FMatrixSparseCSC output, @Nullable IGrowArray gw) {
        int i2;
        int i;
        int p;
        int idx1;
        int idx0;
        int j2;
        int j;
        if (input.numRows != input.numCols) {
            throw new MatrixDimensionException("Input must be a square matrix. " + UtilEjml.stringShapes(input, output));
        }
        if (input.numRows != permInv.length) {
            throw new MatrixDimensionException("Number of column in input must match length of permInv");
        }
        int N = input.numCols;
        int[] w = UtilEjml.adjustClear(gw, N);
        output.reshape(N, N, 0);
        output.indicesSorted = false;
        output.col_idx[0] = 0;
        for (j = 0; j < N; ++j) {
            j2 = permInv[j];
            idx0 = input.col_idx[j];
            idx1 = input.col_idx[j + 1];
            for (p = idx0; p < idx1; ++p) {
                i = input.nz_rows[p];
                if (i > j) continue;
                i2 = permInv[i];
                int n = i2 > j2 ? i2 : j2;
                w[n] = w[n] + 1;
            }
        }
        output.histogramToStructure(w);
        System.arraycopy(output.col_idx, 0, w, 0, output.numCols);
        for (j = 0; j < N; ++j) {
            j2 = permInv[j];
            idx0 = input.col_idx[j];
            idx1 = input.col_idx[j + 1];
            for (p = idx0; p < idx1; ++p) {
                i = input.nz_rows[p];
                if (i > j) continue;
                i2 = permInv[i];
                int n = i2 > j2 ? i2 : j2;
                w[n] = w[n] + 1;
                output.nz_rows[q] = i2 < j2 ? i2 : j2;
                output.nz_values[q] = input.nz_values[p];
            }
        }
    }

    public static FMatrixSparseCSC concatRows(FMatrixSparseCSC top, FMatrixSparseCSC bottom, @Nullable FMatrixSparseCSC out) {
        if (top.numCols != bottom.numCols) {
            throw new MatrixDimensionException("Number of columns must match. " + UtilEjml.stringShapes(top, bottom));
        }
        if (out == null) {
            out = new FMatrixSparseCSC(0, 0, 0);
        }
        out.reshape(top.numRows + bottom.numRows, top.numCols, top.nz_length + bottom.nz_length);
        out.nz_length = top.nz_length + bottom.nz_length;
        int index = 0;
        for (int i = 0; i < top.numCols; ++i) {
            int out1;
            int top0 = top.col_idx[i];
            int top1 = top.col_idx[i + 1];
            int bot0 = bottom.col_idx[i];
            int bot1 = bottom.col_idx[i + 1];
            int out0 = out.col_idx[i];
            out.col_idx[i + 1] = out1 = out0 + top1 - top0 + bot1 - bot0;
            int j = top0;
            while (j < top1) {
                out.nz_values[index] = top.nz_values[j];
                out.nz_rows[index] = top.nz_rows[j];
                ++j;
                ++index;
            }
            j = bot0;
            while (j < bot1) {
                out.nz_values[index] = bottom.nz_values[j];
                out.nz_rows[index] = top.numRows + bottom.nz_rows[j];
                ++j;
                ++index;
            }
        }
        out.indicesSorted = false;
        return out;
    }

    public static FMatrixSparseCSC concatColumns(FMatrixSparseCSC left, FMatrixSparseCSC right, @Nullable FMatrixSparseCSC out) {
        if (left.numRows != right.numRows) {
            throw new MatrixDimensionException("Number of rows must match. " + UtilEjml.stringShapes(left, right));
        }
        if (out == null) {
            out = new FMatrixSparseCSC(0, 0, 0);
        }
        out.reshape(left.numRows, left.numCols + right.numCols, left.nz_length + right.nz_length);
        out.nz_length = left.nz_length + right.nz_length;
        System.arraycopy(left.col_idx, 0, out.col_idx, 0, left.numCols + 1);
        System.arraycopy(left.nz_rows, 0, out.nz_rows, 0, left.nz_length);
        System.arraycopy(left.nz_values, 0, out.nz_values, 0, left.nz_length);
        int index = left.nz_length;
        for (int i = 0; i < right.numCols; ++i) {
            int r0 = right.col_idx[i];
            int r1 = right.col_idx[i + 1];
            out.col_idx[left.numCols + i] = index;
            out.col_idx[left.numCols + i + 1] = index + (r1 - r0);
            int j = r0;
            while (j < r1) {
                out.nz_rows[index] = right.nz_rows[j];
                out.nz_values[index] = right.nz_values[j];
                ++j;
                ++index;
            }
        }
        out.indicesSorted = left.indicesSorted && right.indicesSorted;
        return out;
    }

    public static FMatrixSparseCSC extractColumn(FMatrixSparseCSC A2, int column, @Nullable FMatrixSparseCSC out) {
        if (out == null) {
            out = new FMatrixSparseCSC(1, 1, 1);
        }
        int idx0 = A2.col_idx[column];
        int idx1 = A2.col_idx[column + 1];
        out.reshape(A2.numRows, 1, idx1 - idx0);
        out.nz_length = idx1 - idx0;
        out.col_idx[0] = 0;
        out.col_idx[1] = out.nz_length;
        System.arraycopy(A2.nz_values, idx0, out.nz_values, 0, out.nz_length);
        System.arraycopy(A2.nz_rows, idx0, out.nz_rows, 0, out.nz_length);
        return out;
    }

    public static FMatrixSparseCSC extractRows(FMatrixSparseCSC A2, int row0, int row1, @Nullable FMatrixSparseCSC out) {
        if (out == null) {
            out = new FMatrixSparseCSC(1, 1, 1);
        }
        out.reshape(row1 - row0, A2.numCols, A2.nz_length);
        for (int col = 0; col < A2.numCols; ++col) {
            int idx0 = A2.col_idx[col];
            int idx1 = A2.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int row = A2.nz_rows[i];
                if (row < row0 || row >= row1) continue;
                out.nz_values[out.nz_length] = A2.nz_values[i];
                out.nz_rows[out.nz_length++] = row - row0;
            }
            out.col_idx[col + 1] = out.nz_length;
        }
        return out;
    }

    public static void extract(FMatrixSparseCSC src, int srcY0, int srcY1, int srcX0, int srcX1, FMatrixSparseCSC dst, int dstY0, int dstX0) {
        if (srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.getNumRows()) {
            throw new MatrixDimensionException("srcY1 < srcY0 || srcY0 < 0 || srcY1 > src.numRows. " + UtilEjml.stringShapes(src, dst));
        }
        if (srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.getNumCols()) {
            throw new MatrixDimensionException("srcX1 < srcX0 || srcX0 < 0 || srcX1 > src.numCols. " + UtilEjml.stringShapes(src, dst));
        }
        int w = srcX1 - srcX0;
        int h = srcY1 - srcY0;
        if (dstY0 + h > dst.getNumRows()) {
            throw new IllegalArgumentException("dst is too small in rows. " + dst.getNumRows() + " < " + (dstY0 + h));
        }
        if (dstX0 + w > dst.getNumCols()) {
            throw new IllegalArgumentException("dst is too small in columns. " + dst.getNumCols() + " < " + (dstX0 + w));
        }
        CommonOps_FSCC.zero(dst, dstY0, dstY0 + h, dstX0, dstX0 + w);
        for (int colSrc = srcX0; colSrc < srcX1; ++colSrc) {
            int idxS0 = src.col_idx[colSrc];
            int idxS1 = src.col_idx[colSrc + 1];
            for (int i = idxS0; i < idxS1; ++i) {
                int row = src.nz_rows[i];
                if (row < srcY0 || row >= srcY1) continue;
                dst.set(row - srcY0 + dstY0, colSrc - srcX0 + dstX0, src.nz_values[i]);
            }
        }
    }

    public static FMatrixSparseCSC select(FMatrixSparseCSC A2, IPredicateBinary selector, @Nullable FMatrixSparseCSC output) {
        if (output != A2) {
            output = UtilEjml.reshapeOrDeclare(output, A2);
        }
        ImplCommonOps_FSCC.select(A2, output, selector);
        return output;
    }

    public static void fill(FMatrixSparseCSC A2, float value) {
        int N = A2.numCols * A2.numRows;
        A2.growMaxLength(N, false);
        A2.col_idx[0] = 0;
        for (int col = 0; col < A2.numCols; ++col) {
            int idx0 = A2.col_idx[col];
            int n = idx0 + A2.numRows;
            A2.col_idx[col + 1] = n;
            int idx1 = n;
            for (int i = idx0; i < idx1; ++i) {
                A2.nz_rows[i] = i - idx0;
                A2.nz_values[i] = value;
            }
        }
        A2.nz_length = N;
        A2.indicesSorted = true;
    }

    public static FMatrixRMaj sumCols(FMatrixSparseCSC input, @Nullable FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int col = 0; col < input.numCols; ++col) {
            int idx0 = input.col_idx[col];
            int idx1 = input.col_idx[col + 1];
            float sum = 0.0f;
            for (int i = idx0; i < idx1; ++i) {
                sum += input.nz_values[i];
            }
            output.data[col] = sum;
        }
        return output;
    }

    public static FMatrixRMaj minCols(FMatrixSparseCSC input, @Nullable FMatrixRMaj output) {
        output = UtilEjml.reshapeOrDeclare(output, 1, input.numCols);
        for (int col = 0; col < input.numCols; ++col) {
            int idx1 = input.col_idx[col + 1];
            int idx0 = input.col_idx[col];
            float min = idx1 - idx0 == input.numRows ? Float.MAX_VALUE : 0.0f;
            for (int i = idx0; i < idx1; ++i) {
                float v = input.nz_values[i];
                if (!(min > v)) continue;
                min = v;
            }
            output.data[col] = min;
        }
        return output;
    }

    public static FMatrixRMaj maxCols(FMatrixSparseCSC input, @Nullable FMatrixRMaj output) {
        output = UtilEjml.reshapeOrDeclare(output, 1, input.numCols);
        for (int col = 0; col < input.numCols; ++col) {
            int idx1 = input.col_idx[col + 1];
            int idx0 = input.col_idx[col];
            float max = idx1 - idx0 == input.numRows ? -3.4028235E38f : 0.0f;
            for (int i = idx0; i < idx1; ++i) {
                float v = input.nz_values[i];
                if (!(max < v)) continue;
                max = v;
            }
            output.data[col] = max;
        }
        return output;
    }

    public static FMatrixRMaj sumRows(FMatrixSparseCSC input, @Nullable FMatrixRMaj output) {
        output = UtilEjml.reshapeOrDeclare(output, input.numRows, 1);
        Arrays.fill(output.data, 0, input.numRows, 0.0f);
        for (int col = 0; col < input.numCols; ++col) {
            int idx0 = input.col_idx[col];
            int idx1 = input.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int n = input.nz_rows[i];
                output.data[n] = output.data[n] + input.nz_values[i];
            }
        }
        return output;
    }

    public static FMatrixRMaj minRows(FMatrixSparseCSC input, @Nullable FMatrixRMaj output, @Nullable IGrowArray gw) {
        output = UtilEjml.reshapeOrDeclare(output, input.numRows, 1);
        int[] w = UtilEjml.adjust(gw, input.numRows, input.numRows);
        Arrays.fill(output.data, 0, input.numRows, Float.MAX_VALUE);
        for (int col = 0; col < input.numCols; ++col) {
            int idx0 = input.col_idx[col];
            int idx1 = input.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int row = input.nz_rows[i];
                float v = input.nz_values[i];
                if (output.data[row] > v) {
                    output.data[row] = v;
                }
                int n = row;
                w[n] = w[n] + 1;
            }
        }
        for (int row = 0; row < input.numRows; ++row) {
            if (w[row] == input.numCols || !(output.data[row] > 0.0f)) continue;
            output.data[row] = 0.0f;
        }
        return output;
    }

    public static FMatrixRMaj maxRows(FMatrixSparseCSC input, @Nullable FMatrixRMaj output, @Nullable IGrowArray gw) {
        output = UtilEjml.reshapeOrDeclare(output, input.numRows, 1);
        int[] w = UtilEjml.adjust(gw, input.numRows, input.numRows);
        Arrays.fill(output.data, 0, input.numRows, -3.4028235E38f);
        for (int col = 0; col < input.numCols; ++col) {
            int idx0 = input.col_idx[col];
            int idx1 = input.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                int row = input.nz_rows[i];
                float v = input.nz_values[i];
                if (output.data[row] < v) {
                    output.data[row] = v;
                }
                int n = row;
                w[n] = w[n] + 1;
            }
        }
        for (int row = 0; row < input.numRows; ++row) {
            if (w[row] == input.numCols || !(output.data[row] < 0.0f)) continue;
            output.data[row] = 0.0f;
        }
        return output;
    }

    public static void zero(FMatrixSparseCSC A2, int row0, int row1, int col0, int col1) {
        for (int col = col1 - 1; col >= col0; --col) {
            int i;
            int numRemoved = 0;
            int idx0 = A2.col_idx[col];
            int idx1 = A2.col_idx[col + 1];
            for (i = idx0; i < idx1; ++i) {
                int row = A2.nz_rows[i];
                if (row >= row0 && row < row1) {
                    ++numRemoved;
                    continue;
                }
                if (numRemoved <= 0) continue;
                A2.nz_rows[i - numRemoved] = row;
                A2.nz_values[i - numRemoved] = A2.nz_values[i];
            }
            if (numRemoved <= 0) continue;
            for (i = idx1; i < A2.nz_length; ++i) {
                A2.nz_rows[i - numRemoved] = A2.nz_rows[i];
                A2.nz_values[i - numRemoved] = A2.nz_values[i];
            }
            A2.nz_length -= numRemoved;
            i = col + 1;
            while (i <= A2.numCols) {
                int n = i++;
                A2.col_idx[n] = A2.col_idx[n] - numRemoved;
            }
        }
    }

    public static float dotInnerColumns(FMatrixSparseCSC A2, int colA, FMatrixSparseCSC B, int colB, @Nullable IGrowArray gw, @Nullable FGrowArray gx) {
        return ImplMultiplication_FSCC.dotInnerColumns(A2, colA, B, colB, gw, gx);
    }

    public static boolean solve(FMatrixSparseCSC a, FMatrixRMaj b, FMatrixRMaj x) {
        x.reshape(a.numCols, b.numCols);
        LinearSolverSparse<FMatrixSparseCSC, FMatrixRMaj> solver = a.numRows > a.numCols ? LinearSolverFactory_FSCC.qr(FillReducing.NONE) : LinearSolverFactory_FSCC.lu(FillReducing.NONE);
        if (solver.modifiesA()) {
            a = a.copy();
        }
        if (solver.modifiesB()) {
            b = b.copy();
        }
        if (!solver.setA(a)) {
            return false;
        }
        solver.solve(b, x);
        return true;
    }

    public static boolean solve(FMatrixSparseCSC a, FMatrixSparseCSC b, FMatrixSparseCSC x) {
        x.reshape(a.numCols, b.numCols);
        LinearSolverSparse<FMatrixSparseCSC, FMatrixRMaj> solver = a.numRows > a.numCols ? LinearSolverFactory_FSCC.qr(FillReducing.NONE) : LinearSolverFactory_FSCC.lu(FillReducing.NONE);
        if (solver.modifiesA()) {
            a = a.copy();
        }
        if (solver.modifiesB()) {
            b = b.copy();
        }
        if (!solver.setA(a)) {
            return false;
        }
        solver.solveSparse(b, x);
        return true;
    }

    public static boolean invert(FMatrixSparseCSC A2, FMatrixRMaj inverse) {
        if (A2.numRows != A2.numCols) {
            throw new IllegalArgumentException("A must be a square matrix");
        }
        inverse.reshape(A2.numRows, A2.numCols);
        LinearSolverSparse<FMatrixSparseCSC, FMatrixRMaj> solver = LinearSolverFactory_FSCC.lu(FillReducing.NONE);
        if (solver.modifiesA()) {
            A2 = A2.copy();
        }
        FMatrixRMaj I2 = CommonOps_FDRM.identity(A2.numRows);
        if (!solver.setA(A2)) {
            return false;
        }
        solver.solve(I2, inverse);
        return true;
    }

    public static float det(FMatrixSparseCSC A2) {
        LUSparseDecomposition_F32<FMatrixSparseCSC> alg = DecompositionFactory_FSCC.lu(FillReducing.NONE);
        if (alg.inputModified()) {
            A2 = A2.copy();
        }
        if (!alg.decompose(A2)) {
            return 0.0f;
        }
        return alg.computeDeterminant().real;
    }

    public static void removeZeros(FMatrixSparseCSC input, FMatrixSparseCSC output, float tol) {
        ImplCommonOps_FSCC.removeZeros(input, output, tol);
    }

    public static void removeZeros(FMatrixSparseCSC A2, float tol) {
        ImplCommonOps_FSCC.removeZeros(A2, tol);
    }

    public static void duplicatesAdd(FMatrixSparseCSC A2, @Nullable IGrowArray work) {
        ImplCommonOps_FSCC.duplicatesAdd(A2, work);
    }

    public static void multRows(float[] diag, int offset, FMatrixSparseCSC A2) {
        if (diag.length < A2.numRows) {
            throw new IllegalArgumentException("Array is too small. " + diag.length + " < " + A2.numCols);
        }
        for (int i = 0; i < A2.nz_length; ++i) {
            int n = i;
            A2.nz_values[n] = A2.nz_values[n] * diag[A2.nz_rows[i + offset]];
        }
    }

    public static void divideRows(float[] diag, int offset, FMatrixSparseCSC A2) {
        if (diag.length < A2.numRows) {
            throw new IllegalArgumentException("Array is too small. " + diag.length + " < " + A2.numCols);
        }
        for (int i = 0; i < A2.nz_length; ++i) {
            int n = i;
            A2.nz_values[n] = A2.nz_values[n] / diag[A2.nz_rows[i + offset]];
        }
    }

    public static float trace(FMatrixSparseCSC A2) {
        float output = 0.0f;
        int o = Math.min(A2.numCols, A2.numRows);
        block0: for (int col = 0; col < o; ++col) {
            int idx0 = A2.col_idx[col];
            int idx1 = A2.col_idx[col + 1];
            for (int i = idx0; i < idx1; ++i) {
                if (A2.nz_rows[i] != col) continue;
                output += A2.nz_values[i];
                continue block0;
            }
        }
        return output;
    }

    public static FMatrixSparseCSC apply(FMatrixSparseCSC input, FOperatorUnary func, @Nullable FMatrixSparseCSC output) {
        if (output == null) {
            output = input.createLike();
        }
        if (input != output) {
            output.copyStructure(input);
        }
        for (int i = 0; i < input.nz_length; ++i) {
            output.nz_values[i] = func.apply(input.nz_values[i]);
        }
        return output;
    }

    public static FMatrixSparseCSC apply(FMatrixSparseCSC input, FOperatorUnary func) {
        return CommonOps_FSCC.apply(input, func, input);
    }

    public static FMatrixSparseCSC applyRowIdx(FMatrixSparseCSC input, FOperatorBinaryIdx func, @Nullable FMatrixSparseCSC output) {
        if (output == null) {
            output = input.createLike();
        }
        if (input != output) {
            output.copyStructure(input);
        }
        for (int i = 0; i < input.nz_length; ++i) {
            output.nz_values[i] = func.apply(input.nz_rows[i], input.nz_values[i]);
        }
        return output;
    }

    public static FMatrixSparseCSC applyColumnIdx(FMatrixSparseCSC input, FOperatorBinaryIdx func, @Nullable FMatrixSparseCSC output) {
        if (output == null) {
            output = input.createLike();
        }
        if (input != output) {
            output.copyStructure(input);
        }
        for (int col = 0; col < input.numCols; ++col) {
            for (int i = input.col_idx[col]; i < input.col_idx[col + 1]; ++i) {
                output.nz_values[i] = func.apply(col, input.nz_values[i]);
            }
        }
        return output;
    }

    public static float reduceScalar(FMatrixSparseCSC input, float initValue, FOperatorBinary func) {
        float result = initValue;
        for (int i = 0; i < input.nz_length; ++i) {
            result = func.apply(result, input.nz_values[i]);
        }
        return result;
    }

    public static float reduceScalar(FMatrixSparseCSC input, FOperatorBinary func) {
        return CommonOps_FSCC.reduceScalar(input, 0.0f, func);
    }

    public static FMatrixRMaj reduceColumnWise(FMatrixSparseCSC input, float initValue, FOperatorBinary func, @Nullable FMatrixRMaj output, @Nullable Mask mask) {
        if (output == null) {
            output = new FMatrixRMaj(1, input.numCols);
        } else {
            output.reshape(1, input.numCols);
        }
        for (int col = 0; col < input.numCols; ++col) {
            int start = input.col_idx[col];
            int end = input.col_idx[col + 1];
            float acc = initValue;
            if (mask == null || mask.isSet(col)) {
                for (int i = start; i < end; ++i) {
                    acc = func.apply(acc, input.nz_values[i]);
                }
            }
            output.data[col] = acc;
        }
        return output;
    }

    public static FMatrixRMaj reduceRowWise(FMatrixSparseCSC input, float initValue, FOperatorBinary func, @Nullable FMatrixRMaj output) {
        if (output == null) {
            output = new FMatrixRMaj(1, input.numRows);
        } else {
            output.reshape(1, input.numCols);
        }
        Arrays.fill(output.data, initValue);
        for (int col = 0; col < input.numCols; ++col) {
            int start = input.col_idx[col];
            int end = input.col_idx[col + 1];
            for (int i = start; i < end; ++i) {
                output.data[input.nz_rows[i]] = func.apply(output.data[input.nz_rows[i]], input.nz_values[i]);
            }
        }
        return output;
    }
}

