/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.qr;

import org.ejml.concurrency.EjmlConcurrency;
import org.ejml.data.DMatrixRMaj;

public class QrHelperFunctions_MT_DDRM {
    public static void rank1UpdateMultR(DMatrixRMaj A2, double[] u, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i2;
        for (i2 = colA0; i2 < A2.numCols; ++i2) {
            _temp[i2] = u[w0] * A2.data[w0 * A2.numCols + i2];
        }
        for (int k = w0 + 1; k < w1; ++k) {
            int indexA = k * A2.numCols + colA0;
            double valU = u[k];
            int i3 = colA0;
            while (i3 < A2.numCols) {
                int n = i3++;
                _temp[n] = _temp[n] + valU * A2.data[indexA++];
            }
        }
        i2 = colA0;
        while (i2 < A2.numCols) {
            int n = i2++;
            _temp[n] = _temp[n] * gamma;
        }
        EjmlConcurrency.loopFor(w0, w1, i -> {
            double valU = u[i];
            int indexA = i * A2.numCols + colA0;
            for (int j = colA0; j < A2.numCols; ++j) {
                int n = indexA++;
                A2.data[n] = A2.data[n] - valU * _temp[j];
            }
        });
    }

    public static void rank1UpdateMultR_u0(DMatrixRMaj A2, double[] u, double u_0, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i2;
        for (i2 = colA0; i2 < A2.numCols; ++i2) {
            _temp[i2] = u_0 * A2.data[w0 * A2.numCols + i2];
        }
        for (int k = w0 + 1; k < w1; ++k) {
            int indexA = k * A2.numCols + colA0;
            double valU = u[k];
            int i3 = colA0;
            while (i3 < A2.numCols) {
                int n = i3++;
                _temp[n] = _temp[n] + valU * A2.data[indexA++];
            }
        }
        i2 = colA0;
        while (i2 < A2.numCols) {
            int n = i2++;
            _temp[n] = _temp[n] * gamma;
        }
        int indexA = w0 * A2.numCols + colA0;
        for (int j = colA0; j < A2.numCols; ++j) {
            int n = indexA++;
            A2.data[n] = A2.data[n] - u_0 * _temp[j];
        }
        EjmlConcurrency.loopFor(w0 + 1, w1, i -> {
            double valU = u[i];
            int indexA = i * A2.numCols + colA0;
            for (int j = colA0; j < A2.numCols; ++j) {
                int n = indexA++;
                A2.data[n] = A2.data[n] - valU * _temp[j];
            }
        });
    }

    public static void rank1UpdateMultR(DMatrixRMaj A2, double[] u, int offsetU, double gamma, int colA0, int w0, int w1, double[] _temp) {
        int i2;
        for (i2 = colA0; i2 < A2.numCols; ++i2) {
            _temp[i2] = u[w0 + offsetU] * A2.data[w0 * A2.numCols + i2];
        }
        for (int k = w0 + 1; k < w1; ++k) {
            int indexA = k * A2.numCols + colA0;
            double valU = u[k + offsetU];
            int i3 = colA0;
            while (i3 < A2.numCols) {
                int n = i3++;
                _temp[n] = _temp[n] + valU * A2.data[indexA++];
            }
        }
        i2 = colA0;
        while (i2 < A2.numCols) {
            int n = i2++;
            _temp[n] = _temp[n] * gamma;
        }
        EjmlConcurrency.loopFor(w0, w1, i -> {
            double valU = u[i + offsetU];
            int indexA = i * A2.numCols + colA0;
            for (int j = colA0; j < A2.numCols; ++j) {
                int n = indexA++;
                A2.data[n] = A2.data[n] - valU * _temp[j];
            }
        });
    }

    public static void rank1UpdateMultL(DMatrixRMaj A2, double[] u, double gamma, int colA0, int w0, int w1) {
        EjmlConcurrency.loopFor(colA0, A2.numRows, i -> {
            int j;
            int startIndex = i * A2.numCols + w0;
            double sum = 0.0;
            int rowIndex = startIndex;
            for (j = w0; j < w1; ++j) {
                sum += A2.data[rowIndex++] * u[j];
            }
            sum = -gamma * sum;
            rowIndex = startIndex;
            for (j = w0; j < w1; ++j) {
                int n = rowIndex++;
                A2.data[n] = A2.data[n] + sum * u[j];
            }
        });
    }
}

