/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class DogLinkedList<T> {
    @Nullable
    protected Element<T> first;
    @Nullable
    protected Element<T> last;
    protected int size;
    protected final ArrayDeque<Element<T>> available = new ArrayDeque();

    public void reset() {
        Element<T> e = this.first;
        while (e != null) {
            Element n = e.next;
            e.clear();
            this.available.add(e);
            e = n;
            if (e != this.first) continue;
            break;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Element<T> getElement(int index, boolean fromFront) {
        if (index > this.size || index < 0) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        if (fromFront) {
            Element<T> e = this.first;
            for (int i = 0; i < index; ++i) {
                if (e == null) {
                    throw new IllegalArgumentException("Element " + i + " is null");
                }
                e = e.next;
            }
            return e;
        }
        Element<T> e = this.last;
        for (int i = 0; i < index; ++i) {
            if (e == null) {
                throw new IllegalArgumentException("Element " + i + " is null");
            }
            e = e.prev;
        }
        return e;
    }

    public Element<T> pushHead(T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        if (this.first == null) {
            this.last = e;
            this.first = this.last;
        } else {
            e.next = this.first;
            this.first.prev = e;
            this.first = e;
        }
        ++this.size;
        return e;
    }

    public Element<T> pushTail(T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        if (this.last == null) {
            this.last = e;
            this.first = this.last;
        } else {
            e.prev = this.last;
            this.last.next = e;
            this.last = e;
        }
        ++this.size;
        return e;
    }

    public Element<T> insertAfter(Element<T> previous, T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        e.prev = previous;
        e.next = previous.next;
        if (e.next != null) {
            e.next.prev = e;
        } else {
            this.last = e;
        }
        previous.next = e;
        ++this.size;
        return e;
    }

    public Element<T> insertBefore(Element<T> next, T object) {
        Element<T> e = this.requestNew();
        e.object = object;
        e.prev = next.prev;
        e.next = next;
        if (e.prev != null) {
            e.prev.next = e;
        } else {
            this.first = e;
        }
        next.prev = e;
        ++this.size;
        return e;
    }

    public void swap(Element<T> a, Element<T> b) {
        if (a.next == b) {
            if (a.prev != null) {
                a.prev.next = b;
            }
            if (b.next != null) {
                b.next.prev = a;
            }
            Element tmp = a.prev;
            a.prev = b;
            a.next = b.next;
            b.prev = tmp;
            b.next = a;
            if (this.first == a) {
                this.first = b;
            }
            if (this.last == b) {
                this.last = a;
            }
        } else if (a.prev == b) {
            if (a.next != null) {
                a.next.prev = b;
            }
            if (b.prev != null) {
                b.prev.next = a;
            }
            Element tmp = a.next;
            a.next = b;
            a.prev = b.prev;
            b.prev = a;
            b.next = tmp;
            if (this.first == b) {
                this.first = a;
            }
            if (this.last == a) {
                this.last = b;
            }
        } else {
            if (a.next != null) {
                a.next.prev = b;
            }
            if (a.prev != null) {
                a.prev.next = b;
            }
            if (b.next != null) {
                b.next.prev = a;
            }
            if (b.prev != null) {
                b.prev.next = a;
            }
            Element tempNext = b.next;
            Element tempPrev = b.prev;
            b.next = a.next;
            b.prev = a.prev;
            a.next = tempNext;
            a.prev = tempPrev;
            if (a.next == null) {
                this.last = a;
            } else if (b.next == null) {
                this.last = b;
            }
            if (a.prev == null) {
                this.first = a;
            } else if (b.prev == null) {
                this.first = b;
            }
        }
    }

    public void remove(Element<T> element) {
        if (element.next == null) {
            this.last = element.prev;
        } else {
            element.next.prev = element.prev;
        }
        if (element.prev == null) {
            this.first = element.next;
        } else {
            element.prev.next = element.next;
        }
        --this.size;
        element.clear();
        this.available.add(element);
    }

    public T removeHead() {
        if (this.first == null) {
            throw new IllegalArgumentException("Empty list");
        }
        T ret = this.first.getObject();
        Element<T> e = this.first;
        this.available.add(this.first);
        if (this.first.next != null) {
            this.first.next.prev = null;
            this.first = this.first.next;
        } else {
            this.last = null;
            this.first = null;
        }
        e.clear();
        --this.size;
        return ret;
    }

    public T removeTail() {
        if (this.last == null) {
            throw new IllegalArgumentException("Empty list");
        }
        T ret = this.last.getObject();
        Element<T> e = this.last;
        this.available.add(this.last);
        if (this.last.prev != null) {
            this.last.prev.next = null;
            this.last = this.last.prev;
        } else {
            this.last = null;
            this.first = null;
        }
        e.clear();
        --this.size;
        return ret;
    }

    @Nullable
    public Element<T> find(T object) {
        Element<T> e = this.first;
        while (e != null) {
            if (e.object == object) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Nullable
    public Element<T> getHead() {
        return this.first;
    }

    @Nullable
    public Element<T> getTail() {
        return this.last;
    }

    public T getFirst() {
        return Objects.requireNonNull(this.first).object;
    }

    public T getLast() {
        return Objects.requireNonNull(this.last).object;
    }

    public void addAll(List<T> list) {
        if (list.isEmpty()) {
            return;
        }
        Element<T> a = this.requestNew();
        a.object = list.get(0);
        if (this.first == null) {
            this.first = a;
        } else if (this.last != null) {
            this.last.next = a;
            a.prev = this.last;
        }
        for (int i = 1; i < list.size(); ++i) {
            Element<T> b = this.requestNew();
            b.object = list.get(i);
            a.next = b;
            b.prev = a;
            a = b;
        }
        this.last = a;
        this.size += list.size();
    }

    public void addAll(T[] array, int first, int length) {
        if (length <= 0) {
            return;
        }
        Element<T> a = this.requestNew();
        a.object = array[first];
        if (this.first == null) {
            this.first = a;
        } else if (this.last != null) {
            this.last.next = a;
            a.prev = this.last;
        }
        for (int i = 1; i < length; ++i) {
            Element<T> b = this.requestNew();
            b.object = array[first + i];
            a.next = b;
            b.prev = a;
            a = b;
        }
        this.last = a;
        this.size += length;
    }

    public int size() {
        return this.size;
    }

    protected Element<T> requestNew() {
        if (this.available.isEmpty()) {
            return new Element();
        }
        return this.available.pop();
    }

    public static class Element<T> {
        @Nullable
        public Element<T> next;
        @Nullable
        public Element<T> prev;
        public T object;

        public void clear() {
            this.next = null;
            this.prev = null;
            this.object = null;
        }

        @Nullable
        public Element<T> getNext() {
            return this.next;
        }

        public void setNext(@Nullable Element<T> next) {
            this.next = next;
        }

        @Nullable
        public Element<T> getPrev() {
            return this.prev;
        }

        public void setPrev(@Nullable Element<T> prev) {
            this.prev = prev;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }
    }
}

