/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import java.util.Random;
import org.ddogleg.struct.DogArrayPrimitive;
import org.ddogleg.struct.DogLambdas;

public class DogArray_I16
implements DogArrayPrimitive<DogArray_I16> {
    public short[] data;
    public int size;

    public DogArray_I16(int reserve) {
        this.data = new short[reserve];
        this.size = 0;
    }

    public DogArray_I16() {
        this(10);
    }

    public static DogArray_I16 zeros(int length) {
        DogArray_I16 out = new DogArray_I16(length);
        out.size = length;
        return out;
    }

    public static DogArray_I16 array(short ... values) {
        DogArray_I16 out = DogArray_I16.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    public static DogArray_I16 array(int ... values) {
        DogArray_I16 out = DogArray_I16.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = (short)values[i];
        }
        return out;
    }

    public static DogArray_I16 range(int idx0, int idx1) {
        DogArray_I16 out = DogArray_I16.zeros(idx1 - idx0);
        for (int i = idx0; i < idx1; ++i) {
            out.data[i - idx0] = (short)i;
        }
        return out;
    }

    public int count(int value) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            ++total;
        }
        return total;
    }

    public boolean isEquals(short ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(int ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(DogArray_I16 values) {
        if (this.size != values.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values.data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public DogArray_I16 reset() {
        this.size = 0;
        return this;
    }

    public void addAll(DogArray_I16 queue) {
        if (this.size + queue.size > this.data.length) {
            short[] temp = new short[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(short[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array. " + endIndex + " > " + array.length);
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            short[] temp = new short[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(int val) {
        this.push(val);
    }

    public void push(int val) {
        if (this.size == this.data.length) {
            short[] temp;
            try {
                temp = new short[this.size * 2 + 5];
            }
            catch (OutOfMemoryError e) {
                System.gc();
                temp = new short[3 * this.size / 2];
            }
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = (short)val;
    }

    public DogArray_I16 setTo(short[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
        return this;
    }

    @Override
    public DogArray_I16 setTo(short ... src) {
        this.setTo(src, 0, src.length);
        return this;
    }

    public short[] toArray() {
        short[] out = new short[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last. first=" + first + " last=" + last);
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size. last=" + last + " size=" + this.size);
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void insert(int index, int value) {
        if (this.size == this.data.length) {
            short[] temp = new short[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = (short)value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = (short)value;
        }
    }

    public short removeSwap(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        short ret = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        return ret;
    }

    public short removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public short get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public short getTail() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        return this.data[this.size - 1];
    }

    public short getTail(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[this.size - index - 1];
    }

    public void setTail(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        this.data[this.size - index - 1] = (short)value;
    }

    public short getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public short unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = (short)value;
    }

    @Override
    public DogArray_I16 setTo(DogArray_I16 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
        return this;
    }

    @Override
    public DogArray_I16 resize(int size) {
        this.reserve(size);
        this.size = size;
        return this;
    }

    public DogArray_I16 resize(int size, short value) {
        int priorSize = this.size;
        this.resize(size);
        if (priorSize >= size) {
            return this;
        }
        this.fill(priorSize, size, value);
        return this;
    }

    @Deprecated
    public void resetResize(int size, short value) {
        this.reset();
        this.resize(size, value);
    }

    public void resize(int size, DogLambdas.AssignIdx_I16 op) {
        int priorSize = this.size;
        this.resize(size);
        for (int i = priorSize; i < size; ++i) {
            this.data[i] = op.assign(i);
        }
    }

    public void fill(short value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void fill(int idx0, int idx1, short value) {
        Arrays.fill(this.data, idx0, idx1, value);
    }

    public boolean contains(short value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void extend(int size) {
        this.reserve(size);
        this.size = size;
    }

    @Override
    public void reserve(int amount) {
        if (this.data.length >= amount) {
            return;
        }
        if (this.size == 0) {
            this.data = null;
            this.data = new short[amount];
        } else {
            short[] tmp = new short[amount];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, (short)0);
    }

    @Override
    public DogArray_I16 copy() {
        DogArray_I16 ret = new DogArray_I16(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            short tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public void printHex() {
        System.out.print("[ ");
        for (int i = 0; i < this.size; ++i) {
            System.out.printf("0x%04X ", this.data[i]);
        }
        System.out.print("]");
    }

    public static DogArray_I16 parseHex(String message) {
        message = message.replaceAll("\\[", "");
        message = message.replaceAll("\\]", "");
        message = message.replaceAll(" ", "");
        String[] words = message.split(",");
        DogArray_I16 out = new DogArray_I16(words.length);
        out.size = words.length;
        for (int i = 0; i < words.length; ++i) {
            out.data[i] = Integer.decode(words[i]).shortValue();
        }
        return out;
    }

    public short pop() {
        return this.data[--this.size];
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int indexOfGreatest() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        short best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.data[i] <= best) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    public int indexOfLeast() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        short best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (this.data[i] >= best) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void shuffle(Random rand) {
        for (int i = 0; i < this.size; ++i) {
            int src = rand.nextInt(this.size - i) + i;
            short tmp = this.data[i];
            this.data[i] = this.data[src];
            this.data[src] = tmp;
        }
    }

    public void forIdx(FunctionEachIdx func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(i, this.data[i]);
        }
    }

    public void forEach(FunctionEach func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(this.data[i]);
        }
    }

    public void applyIdx(FunctionApplyIdx func) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = func.process(i, this.data[i]);
        }
    }

    public int count(Filter filter) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!filter.include(this.data[i])) continue;
            ++total;
        }
        return total;
    }

    @FunctionalInterface
    public static interface FunctionEachIdx {
        public void process(int var1, short var2);
    }

    @FunctionalInterface
    public static interface FunctionEach {
        public void process(short var1);
    }

    @FunctionalInterface
    public static interface FunctionApplyIdx {
        public short process(int var1, short var2);
    }

    @FunctionalInterface
    public static interface Filter {
        public boolean include(int var1);
    }
}

