/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import java.util.Random;
import org.ddogleg.sorting.QuickSort_F32;
import org.ddogleg.struct.DogArrayPrimitive;
import org.ddogleg.struct.DogLambdas;

public class DogArray_F32
implements DogArrayPrimitive<DogArray_F32> {
    public float[] data;
    public int size;

    public DogArray_F32(int reserve) {
        this.data = new float[reserve];
        this.size = 0;
    }

    public DogArray_F32() {
        this(10);
    }

    public static DogArray_F32 zeros(int length) {
        DogArray_F32 out = new DogArray_F32(length);
        out.size = length;
        return out;
    }

    public static DogArray_F32 array(float ... values) {
        DogArray_F32 out = DogArray_F32.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = values[i];
        }
        return out;
    }

    public static DogArray_F32 range(int idx0, int idx1) {
        DogArray_F32 out = DogArray_F32.zeros(idx1 - idx0);
        for (int i = idx0; i < idx1; ++i) {
            out.data[i - idx0] = i;
        }
        return out;
    }

    public int count(float value) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            ++total;
        }
        return total;
    }

    public boolean isEquals(float ... values) {
        if (this.size != values.length) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(DogArray_F32 values) {
        if (this.size != values.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == values.data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public DogArray_F32 reset() {
        this.size = 0;
        return this;
    }

    public void addAll(DogArray_F32 queue) {
        if (this.size + queue.size > this.data.length) {
            float[] temp = new float[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(float[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array. " + endIndex + " > " + array.length);
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            float[] temp = new float[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(float val) {
        this.push(val);
    }

    public void push(float val) {
        if (this.size == this.data.length) {
            float[] temp;
            try {
                temp = new float[this.size * 2 + 5];
            }
            catch (OutOfMemoryError e) {
                System.gc();
                temp = new float[3 * this.size / 2];
            }
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public DogArray_F32 setTo(float[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
        return this;
    }

    @Override
    public DogArray_F32 setTo(float ... src) {
        this.setTo(src, 0, src.length);
        return this;
    }

    public float[] toArray() {
        float[] out = new float[this.size];
        System.arraycopy(this.data, 0, out, 0, this.size);
        return out;
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last. first=" + first + " last=" + last);
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size. last=" + last + " size=" + this.size);
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void insert(int index, float value) {
        if (this.size == this.data.length) {
            float[] temp = new float[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = value;
        }
    }

    public float removeSwap(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Out of bounds. index=" + index + " max size " + this.size);
        }
        float ret = this.data[index];
        --this.size;
        this.data[index] = this.data[this.size];
        return ret;
    }

    public float removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public float get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public float getTail() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("Array is empty");
        }
        return this.data[this.size - 1];
    }

    public float getTail(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[this.size - index - 1];
    }

    public void setTail(int index, float value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        this.data[this.size - index - 1] = value;
    }

    public float getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public float unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, float value) {
        this.data[index] = value;
    }

    @Override
    public DogArray_F32 setTo(DogArray_F32 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
        return this;
    }

    @Override
    public DogArray_F32 resize(int size) {
        this.reserve(size);
        this.size = size;
        return this;
    }

    public DogArray_F32 resize(int size, float value) {
        int priorSize = this.size;
        this.resize(size);
        if (priorSize >= size) {
            return this;
        }
        this.fill(priorSize, size, value);
        return this;
    }

    @Deprecated
    public void resetResize(int size, float value) {
        this.reset();
        this.resize(size, value);
    }

    public DogArray_F32 resize(int size, DogLambdas.AssignIdx_F32 op) {
        int priorSize = this.size;
        this.resize(size);
        for (int i = priorSize; i < size; ++i) {
            this.data[i] = op.assign(i);
        }
        return this;
    }

    public void fill(float value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void fill(int idx0, int idx1, float value) {
        Arrays.fill(this.data, idx0, idx1, value);
    }

    public boolean contains(float value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void extend(int size) {
        this.reserve(size);
        this.size = size;
    }

    @Override
    public void reserve(int amount) {
        if (this.data.length >= amount) {
            return;
        }
        if (this.size == 0) {
            this.data = null;
            this.data = new float[amount];
        } else {
            float[] tmp = new float[amount];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, 0.0f);
    }

    @Override
    public DogArray_F32 copy() {
        DogArray_F32 ret = new DogArray_F32(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            float tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public float pop() {
        return this.data[--this.size];
    }

    public int indexOf(float value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int indexOfGreatest() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        float best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.data[i] > best)) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    public int indexOfLeast() {
        if (this.size <= 0) {
            return -1;
        }
        int selected = 0;
        float best = this.data[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.data[i] < best)) continue;
            best = this.data[i];
            selected = i;
        }
        return selected;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    public void sort(QuickSort_F32 sorter) {
        sorter.sort(this.data, this.size);
    }

    public void shuffle(Random rand) {
        for (int i = 0; i < this.size; ++i) {
            int src = rand.nextInt(this.size - i) + i;
            float tmp = this.data[i];
            this.data[i] = this.data[src];
            this.data[src] = tmp;
        }
    }

    public void forIdx(FunctionEachIdx func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(i, this.data[i]);
        }
    }

    public void forEach(FunctionEach func) {
        for (int i = 0; i < this.size; ++i) {
            func.process(this.data[i]);
        }
    }

    public void applyIdx(FunctionApplyIdx func) {
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = func.process(i, this.data[i]);
        }
    }

    public int count(Filter filter) {
        int total = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!filter.include(this.data[i])) continue;
            ++total;
        }
        return total;
    }

    @FunctionalInterface
    public static interface FunctionEachIdx {
        public void process(int var1, float var2);
    }

    @FunctionalInterface
    public static interface FunctionEach {
        public void process(float var1);
    }

    @FunctionalInterface
    public static interface FunctionApplyIdx {
        public float process(int var1, float var2);
    }

    @FunctionalInterface
    public static interface Filter {
        public boolean include(double var1);
    }
}

