/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import org.ddogleg.struct.BigDogGrowth;
import org.ddogleg.struct.FastArray;

public abstract class BigDogArrayBase<Array> {
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    protected final FastArray<Array> blocks;
    protected final int blockSize;
    public int size;
    private int initialBlockSize = 8;
    protected final BigDogGrowth growth;

    protected BigDogArrayBase(int initialAllocation, int blockSize, BigDogGrowth growth) {
        if (initialAllocation <= 0) {
            throw new IllegalArgumentException("initialAllocation size must be a positive value");
        }
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size must be a positive value");
        }
        this.blockSize = blockSize;
        this.growth = growth;
        Class<?> type = this.newArrayInstance(0).getClass();
        this.blocks = new FastArray(type, this.getDesiredBlocks(initialAllocation));
        this.blocks.size = this.blocks.data.length;
        for (int i = 0; i < this.blocks.size - 1; ++i) {
            this.blocks.set(i, this.newArrayInstance(blockSize));
        }
        if (this.blocks.size > 0) {
            if (this.blocks.size == 1 && growth == BigDogGrowth.GROW_FIRST || growth == BigDogGrowth.GROW) {
                this.blocks.set(this.blocks.size - 1, this.newArrayInstance(initialAllocation % blockSize));
            } else {
                this.blocks.set(this.blocks.size - 1, this.newArrayInstance(blockSize));
            }
        }
    }

    public boolean isIndexOutOfBounds(int index) {
        return index < 0 || index >= this.size;
    }

    public void reset() {
        this.size = 0;
    }

    public void reserve(int desiredSize) {
        this.allocate(desiredSize, false, false);
    }

    protected void allocate(int desiredSize, boolean saveValues, boolean addExtra) {
        Object old;
        if (desiredSize < 0) {
            throw new IllegalArgumentException("desiredSize must be positive. Overflowed? desiredSize=" + desiredSize);
        }
        int desiredNumBlocks = this.getDesiredBlocks(desiredSize);
        if (this.blocks.size() > desiredNumBlocks) {
            return;
        }
        int priorNumBlocks = this.blocks.size;
        this.blocks.resize(desiredNumBlocks);
        if (priorNumBlocks > 0 && priorNumBlocks < desiredNumBlocks && this.arrayLength(old = this.blocks.data[priorNumBlocks - 1]) != this.blockSize) {
            Array replacement = this.newArrayInstance(this.blockSize);
            if (saveValues) {
                System.arraycopy(old, 0, replacement, 0, this.arrayLength(old));
            }
            this.blocks.data[priorNumBlocks - 1] = replacement;
        }
        for (int i = priorNumBlocks; i < desiredNumBlocks - 1; ++i) {
            this.blocks.data[i] = this.newArrayInstance(this.blockSize);
        }
        int desiredLastBlockSize = this.computeLastBlockSize(desiredSize, desiredNumBlocks);
        if (priorNumBlocks == desiredNumBlocks && priorNumBlocks > 0) {
            Object old2 = this.blocks.data[priorNumBlocks - 1];
            int oldLength = this.arrayLength(old2);
            if (oldLength < desiredLastBlockSize) {
                if (addExtra) {
                    desiredLastBlockSize = Math.min(this.blockSize, this.initialBlockSize + oldLength * 2 + desiredLastBlockSize);
                }
                Array replacement = this.newArrayInstance(desiredLastBlockSize);
                if (saveValues) {
                    System.arraycopy(old2, 0, replacement, 0, this.arrayLength(old2));
                }
                this.blocks.data[desiredNumBlocks - 1] = replacement;
            }
        } else if (priorNumBlocks < desiredNumBlocks) {
            if (addExtra) {
                desiredLastBlockSize = Math.min(this.blockSize, this.initialBlockSize + 2 * desiredLastBlockSize);
            }
            this.blocks.data[desiredNumBlocks - 1] = this.newArrayInstance(desiredLastBlockSize);
        }
    }

    private int computeLastBlockSize(int desiredSize, int numBlocks) {
        if (this.growth == BigDogGrowth.FIXED || numBlocks > 1 && this.growth == BigDogGrowth.GROW_FIRST) {
            return this.blockSize;
        }
        return desiredSize % this.blockSize == 0 ? this.blockSize : desiredSize % this.blockSize;
    }

    public void resize(int desiredSize) {
        this.allocate(desiredSize, true, false);
        this.size = desiredSize;
    }

    public void append(Array array, int offset, int length) {
        this.allocate(this.size + length, true, true);
        this.size += length;
        this.setArray(this.size - length, array, offset, length);
    }

    public void setArray(long location, Array array, int offset, int length) {
        long idx0 = location;
        long idx1 = location + (long)length;
        if (idx0 % (long)this.blockSize != 0L) {
            int blockIdx0 = (int)(idx0 % (long)this.blockSize);
            int remainingInBlock = this.blockSize - blockIdx0;
            int lengthInBlock = Math.min(remainingInBlock, (int)(idx1 - idx0));
            System.arraycopy(array, offset, this.blocks.data[(int)(idx0 / (long)this.blockSize)], blockIdx0, lengthInBlock);
            offset += lengthInBlock;
            idx0 += (long)lengthInBlock;
        }
        while (idx0 + (long)this.blockSize <= idx1) {
            System.arraycopy(array, offset, this.blocks.data[(int)(idx0 / (long)this.blockSize)], 0, this.blockSize);
            offset += this.blockSize;
            idx0 += (long)this.blockSize;
        }
        if (idx0 != idx1) {
            System.arraycopy(array, offset, this.blocks.data[(int)(idx0 / (long)this.blockSize)], 0, (int)(idx1 - idx0));
        }
    }

    public void processByBlock(int idx0, int idx1, FunctionEachRange<Array> op) {
        int origIdx0 = idx0;
        if (idx0 % this.blockSize != 0) {
            int blockIdx0 = idx0 % this.blockSize;
            int remainingInBlock = this.blockSize - blockIdx0;
            int lengthInBlock = Math.min(remainingInBlock, idx1 - idx0);
            int blockIdx1 = blockIdx0 + lengthInBlock;
            op.process(this.blocks.data[idx0 / this.blockSize], blockIdx0, blockIdx1, 0);
            idx0 += lengthInBlock;
        }
        while (idx0 + this.blockSize < idx1) {
            op.process(this.blocks.data[idx0 / this.blockSize], 0, this.blockSize, idx0 - origIdx0);
            idx0 += this.blockSize;
        }
        if (idx0 != idx1) {
            op.process(this.blocks.data[idx0 / this.blockSize], 0, idx1 - idx0, idx0 - origIdx0);
        }
    }

    protected final int getDesiredBlocks(int desiredSize) {
        return desiredSize / this.blockSize + (desiredSize % this.blockSize > 0 ? 1 : 0);
    }

    public boolean isValidStructure() {
        if (this.blocks.size == 0) {
            return false;
        }
        int maxStorage = this.arrayLength(this.blocks.getTail()) + (this.blocks.size - 1) * this.blockSize;
        if (this.size > maxStorage) {
            return false;
        }
        switch (this.growth) {
            case FIXED: {
                for (int i = 0; i < this.blocks.size; ++i) {
                    if (this.arrayLength(this.blocks.get(i)) == this.blockSize) continue;
                    return false;
                }
                break;
            }
            case GROW_FIRST: {
                for (int i = 1; i < this.blocks.size; ++i) {
                    if (this.arrayLength(this.blocks.get(i)) == this.blockSize) continue;
                    return false;
                }
                if (!(this.blocks.size == 1 ? this.arrayLength(this.blocks.get(0)) > this.blockSize : this.arrayLength(this.blocks.get(0)) != this.blockSize)) break;
                return false;
            }
            case GROW: {
                for (int i = 0; i < this.blocks.size - 1; ++i) {
                    if (this.arrayLength(this.blocks.get(i)) == this.blockSize) continue;
                    return false;
                }
                if (this.arrayLength(this.blocks.getTail()) <= this.blockSize) break;
                return false;
            }
        }
        return true;
    }

    public int getTotalAllocation() {
        return (this.blocks.size - 1) * this.blockSize + this.arrayLength(this.blocks.data[this.blocks.size - 1]);
    }

    protected int blockArrayLength(int block) {
        return this.arrayLength(this.blocks.get(block));
    }

    public void setInitialBlockSize(int initialBlockSize) {
        this.initialBlockSize = Math.min(this.blockSize, Math.max(1, initialBlockSize));
    }

    protected abstract Array newArrayInstance(int var1);

    protected abstract int arrayLength(Array var1);

    public FastArray<Array> getBlocks() {
        return this.blocks;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getSize() {
        return this.size;
    }

    public int getInitialBlockSize() {
        return this.initialBlockSize;
    }

    public BigDogGrowth getGrowth() {
        return this.growth;
    }

    @FunctionalInterface
    public static interface FunctionEachRange<Array> {
        public void process(Array var1, int var2, int var3, int var4);
    }
}

