/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class FitQuadratic2D {
    LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.leastSquares(10, 6);
    DMatrixRMaj A = new DMatrixRMaj(1, 6);
    DMatrixRMaj b = new DMatrixRMaj(1, 1);
    DMatrixRMaj x = new DMatrixRMaj(6, 1);
    double foundX;
    double foundY;

    public void reset() {
        this.A.reshape(0, 6);
        this.b.reshape(0, 0);
    }

    public void add(double x, double y, double value) {
        int row = this.A.numRows;
        if (this.A.data.length < 6 * row + 6) {
            int n = this.A.data.length * 2;
            this.A.reshape(n, 1, true);
            this.b.reshape(n / 6, 1, true);
        }
        this.A.reshape(row + 1, 6, true);
        this.b.reshape(row + 1, 1, true);
        this.A.set(row, 0, x * x);
        this.A.set(row, 1, x * y);
        this.A.set(row, 2, y * y);
        this.A.set(row, 3, x);
        this.A.set(row, 4, y);
        this.A.set(row, 5, 1.0);
        this.b.set(row, value);
    }

    public boolean process() {
        if (!this.solver.setA(this.A)) {
            return false;
        }
        this.solver.solve(this.b, this.x);
        double a = this.x.data[0];
        double b = this.x.data[1];
        double c = this.x.data[2];
        double d = this.x.data[3];
        double e = this.x.data[4];
        double bottom = 4.0 * a * c - b * b;
        this.foundX = (b * e - 2.0 * d * c) / bottom;
        this.foundY = (b * d - 2.0 * a * e) / bottom;
        return true;
    }

    public double getFoundX() {
        return this.foundX;
    }

    public double getFoundY() {
        return this.foundY;
    }
}

