/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ejml.data.DMatrix;

public class LsToNonLinearDeriv<S extends DMatrix>
implements FunctionNtoN {
    FunctionNtoM func;
    FunctionNtoMxN<S> deriv;
    double[] funcOutput;
    S J;

    public LsToNonLinearDeriv(FunctionNtoM func, FunctionNtoMxN<S> deriv) {
        this.func = func;
        this.deriv = deriv;
        this.funcOutput = new double[deriv.getNumOfOutputsM()];
        this.J = deriv.declareMatrixMxN();
    }

    @Override
    public int getN() {
        return this.deriv.getNumOfInputsN();
    }

    @Override
    public void process(double[] input, double[] output) {
        int i;
        this.func.process(input, this.funcOutput);
        this.deriv.process(input, this.J);
        int N = this.deriv.getNumOfInputsN();
        int M = this.deriv.getNumOfOutputsM();
        for (i = 0; i < N; ++i) {
            output[i] = 0.0;
        }
        for (i = 0; i < M; ++i) {
            double f = this.funcOutput[i];
            for (int j = 0; j < N; ++j) {
                int n = j;
                output[n] = output[n] + 2.0 * f * this.J.get(i, j);
            }
        }
    }
}

