/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.math;

import org.ddogleg.optimization.math.HessianMath;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.mult.VectorVectorMult_DDRM;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class HessianMath_DDRM
implements HessianMath {
    protected LinearSolver<DMatrixRMaj, DMatrixRMaj> solver;
    protected DMatrixRMaj hessian = new DMatrixRMaj(1, 1);

    public HessianMath_DDRM() {
    }

    public HessianMath_DDRM(LinearSolverDense<DMatrixRMaj> solver) {
        this.solver = UtilEjml.safe(solver);
    }

    @Override
    public void init(int numParameters) {
        this.hessian.reshape(numParameters, numParameters);
    }

    @Override
    public double innerVectorHessian(DMatrixRMaj v) {
        return VectorVectorMult_DDRM.innerProdA(v, this.hessian, v);
    }

    @Override
    public void extractDiagonals(DMatrixRMaj diag) {
        CommonOps_DDRM.extractDiag(this.hessian, diag);
    }

    @Override
    public void setDiagonals(DMatrixRMaj diag) {
        for (int i = 0; i < this.hessian.numRows; ++i) {
            this.hessian.set(i, i, diag.data[i]);
        }
    }

    @Override
    public void divideRowsCols(DMatrixRMaj scaling) {
        CommonOps_DDRM.divideCols(this.hessian, scaling.data);
        CommonOps_DDRM.divideRows(scaling.data, this.hessian);
    }

    @Override
    public boolean initializeSolver() {
        if (this.solver == null) {
            throw new RuntimeException("Solver not set");
        }
        return this.solver.setA(this.hessian);
    }

    @Override
    public boolean solve(DMatrixRMaj Y2, DMatrixRMaj step) {
        this.solver.solve(Y2, step);
        return true;
    }

    public DMatrixRMaj getHessian() {
        return this.hessian;
    }
}

