/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.distance;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.distance.FitByMeanStatistics;
import org.ddogleg.fitting.modelset.distance.FitByMedianStatistics;
import org.ddogleg.fitting.modelset.distance.PointIndex;
import org.ddogleg.fitting.modelset.distance.StatisticalDistance;
import org.ddogleg.fitting.modelset.distance.StatisticalFit;

public class StatisticalDistanceModelMatcher<Model, Point>
implements ModelMatcher<Model, Point> {
    private final int maxIterations;
    private final double minChange;
    protected Model param;
    protected Model currParam;
    private final StatisticalFit<Model, Point> errorAlg;
    protected double oldCenter;
    protected double centerError;
    private final double exitCenterError;
    private final double failError;
    private final int minFitPoints;
    private final ModelGenerator<Model, Point> modelFitter;
    private final DistanceFromModel<Model, Point> modelError;
    private final ModelCodec<Model> codec;
    ArrayDeque<PointIndex<Point>> pruneList = new ArrayDeque();
    private final List<Point> inliers = new ArrayList<Point>();
    private int[] matchToInput = new int[1];

    public StatisticalDistanceModelMatcher(int maxIterations, double minChange, double exitCenterError, double failError, int minFitPoints, StatisticalDistance statistics, double pruneThreshold, ModelManager<Model> modelManager, ModelGenerator<Model, Point> modelFitter, DistanceFromModel<Model, Point> modelError, ModelCodec<Model> codec) {
        this.maxIterations = maxIterations;
        this.minChange = minChange;
        this.exitCenterError = exitCenterError;
        this.failError = failError;
        this.minFitPoints = minFitPoints;
        this.modelFitter = modelFitter;
        this.modelError = modelError;
        this.codec = codec;
        this.param = modelManager.createModelInstance();
        this.currParam = modelManager.createModelInstance();
        switch (statistics) {
            case MEAN: {
                this.errorAlg = new FitByMeanStatistics(pruneThreshold);
                break;
            }
            case PERCENTILE: {
                this.errorAlg = new FitByMedianStatistics(pruneThreshold);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown statistics selected");
            }
        }
    }

    @Override
    public boolean process(List<Point> dataSet) {
        boolean ret;
        if (dataSet.size() < this.minFitPoints) {
            return false;
        }
        if (dataSet.size() > this.matchToInput.length) {
            this.matchToInput = new int[dataSet.size()];
        }
        this.pruneList.clear();
        this.inliers.clear();
        for (int i = 0; i < dataSet.size(); ++i) {
            this.pruneList.add(new PointIndex<Point>(dataSet.get(i), i));
        }
        this.inliers.clear();
        this.errorAlg.init(this.modelError, this.pruneList);
        this.oldCenter = Double.MAX_VALUE;
        boolean converged = false;
        for (int i = 0; i < this.maxIterations && !converged && this.pruneList.size() >= this.minFitPoints; ++i) {
            this.inliers.clear();
            for (PointIndex<Point> p : this.pruneList) {
                this.inliers.add(p.data);
            }
            if (!this.modelFitter.generate(this.inliers, this.currParam)) break;
            this.modelError.setModel(this.currParam);
            this.errorAlg.computeStatistics();
            this.centerError = this.errorAlg.getErrorMetric();
            if (this.centerError < this.exitCenterError) {
                converged = true;
            } else if (this.computeDiff(this.currParam, this.param) <= this.minChange) {
                converged = true;
            }
            Model temp = this.param;
            this.param = this.currParam;
            this.currParam = temp;
            if (converged) continue;
            this.errorAlg.prune();
            this.oldCenter = this.centerError;
        }
        boolean bl = ret = this.centerError < this.failError && this.pruneList.size() >= this.minFitPoints;
        if (ret) {
            this.inliers.clear();
            int index = 0;
            for (PointIndex<Point> p : this.pruneList) {
                this.inliers.add(p.data);
                this.matchToInput[index++] = p.index;
            }
        }
        return ret;
    }

    protected double computeDiff(Model modelA, Model modelB) {
        double[] paramA = new double[this.codec.getParamLength()];
        double[] paramB = new double[this.codec.getParamLength()];
        this.codec.encode(modelA, paramA);
        this.codec.encode(modelB, paramB);
        double total = 0.0;
        for (int i = 0; i < paramA.length; ++i) {
            total += Math.abs(paramA[i] - paramB[i]);
        }
        return total / (double)paramA.length;
    }

    @Override
    public Model getModelParameters() {
        return this.param;
    }

    @Override
    public List<Point> getMatchSet() {
        return this.inliers;
    }

    @Override
    public int getInputIndex(int matchIndex) {
        return this.matchToInput[matchIndex];
    }

    @Override
    public double getFitQuality() {
        return this.centerError;
    }

    @Override
    public int getMinimumSize() {
        return this.minFitPoints;
    }

    @Override
    public void reset() {
    }

    @Override
    public Class<Point> getPointType() {
        return this.modelError.getPointType();
    }

    @Override
    public Class<Model> getModelType() {
        return this.modelError.getModelType();
    }
}

