/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import org.ddogleg.DDoglegConcurrency;
import org.ddogleg.clustering.ComputeClusters;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.clustering.kmeans.InitializeKMeans;
import org.ddogleg.clustering.kmeans.StandardKMeans;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.DogLambdas;
import org.ddogleg.struct.LArrayAccessor;
import pabeles.concurrency.GrowArray;

public class StandardKMeans_MT<P>
extends StandardKMeans<P> {
    GrowArray<MatchData> workspace = new GrowArray<MatchData>(() -> new MatchData(), MatchData::reset);
    int minimumForConcurrent = 0;

    public StandardKMeans_MT(ComputeMeanClusters<P> updateMeans, InitializeKMeans<P> seedSelector, PointDistance<P> distancer, DogLambdas.NewInstance<P> factory) {
        super(updateMeans, seedSelector, distancer, factory);
    }

    @Override
    protected void matchPointsToClusters(LArrayAccessor<P> points, DogArray<P> clusters) {
        if (points.size() < this.minimumForConcurrent) {
            super.matchPointsToClusters(points, clusters);
            return;
        }
        this.assignments.resize(points.size());
        DDoglegConcurrency.loopBlocks(0, points.size(), this.workspace, (work, idx0, idx1) -> {
            DogArray_I32 memberCount = work.memberCount;
            memberCount.resetResize(clusters.size, 0);
            Object point = work.point;
            for (int i = idx0; i < idx1; ++i) {
                points.getCopy(i, point);
                int assignment = this.findBestMatch(point, clusters, (MatchData)work);
                this.assignments.set(i, assignment);
                int n = assignment;
                memberCount.data[n] = memberCount.data[n] + 1;
            }
        });
        this.memberCount.resetResize(clusters.size, 0);
        this.sumDistance = 0.0;
        for (int i = 0; i < this.workspace.size(); ++i) {
            MatchData md = this.workspace.get(i);
            this.sumDistance += md.sumDistance;
            for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
                int n = clusterIdx;
                this.memberCount.data[n] = this.memberCount.data[n] + md.memberCount.data[clusterIdx];
            }
        }
    }

    protected int findBestMatch(P p, DogArray<P> clusters, MatchData match) {
        int bestCluster = -1;
        double bestDistance = Double.MAX_VALUE;
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            double d = this.distancer.distance(p, clusters.get(clusterIdx));
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            bestCluster = clusterIdx;
        }
        match.sumDistance += bestDistance;
        return bestCluster;
    }

    @Override
    public ComputeClusters<P> newInstanceThread() {
        StandardKMeans_MT spawn = new StandardKMeans_MT(this.updateMeans.newInstanceThread(), this.seedSelector.newInstanceThread(), this.distancer.newInstanceThread(), this.factory);
        spawn.convergeTol = this.convergeTol;
        spawn.maxIterations = this.maxIterations;
        spawn.reseedAfterIterations = this.reseedAfterIterations;
        spawn.verbose = this.verbose;
        return spawn;
    }

    public int getMinimumForConcurrent() {
        return this.minimumForConcurrent;
    }

    public void setMinimumForConcurrent(int minimumForConcurrent) {
        this.minimumForConcurrent = minimumForConcurrent;
    }

    private class MatchData {
        public double sumDistance;
        public P point;
        DogArray_I32 memberCount = new DogArray_I32();

        public MatchData() {
            this.point = StandardKMeans_MT.this.factory.newInstance();
        }

        public void reset() {
            this.sumDistance = 0.0;
            this.memberCount.reset();
        }
    }
}

