/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.ComputeClusters;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.clustering.kmeans.AssignKMeans;
import org.ddogleg.clustering.kmeans.InitializeKMeans;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.DogLambdas;
import org.ddogleg.struct.LArrayAccessor;

public class StandardKMeans<P>
implements ComputeClusters<P> {
    boolean verbose = false;
    public int maxIterations = 100;
    public int reseedAfterIterations = 20;
    public int maxReSeed = 5;
    public double convergeTol = 1.0E-8;
    public ComputeMeanClusters<P> updateMeans;
    public InitializeKMeans<P> seedSelector;
    DogArray<P> workClusters;
    PointDistance<P> distancer;
    DogLambdas.NewInstance<P> factory;
    final DogArray_I32 assignments = new DogArray_I32();
    final DogArray_I32 memberCount = new DogArray_I32();
    double sumDistance;
    final DogArray<P> bestClusters;
    double bestClusterScore;
    final DogArray_I32 bestMemberCount = new DogArray_I32();

    public StandardKMeans(ComputeMeanClusters<P> updateMeans, InitializeKMeans<P> seedSelector, PointDistance<P> distancer, DogLambdas.NewInstance<P> factory) {
        this.updateMeans = updateMeans;
        this.seedSelector = seedSelector;
        this.distancer = distancer;
        this.factory = factory;
        this.workClusters = new DogArray<Object>(factory::newInstance);
        this.bestClusters = new DogArray<Object>(factory::newInstance);
    }

    @Override
    public void initialize(long randomSeed) {
        if (this.convergeTol >= 1.0 || this.convergeTol < 0.0) {
            throw new IllegalArgumentException("convergeTol must be 0 <= tol < 1.0, not " + this.convergeTol);
        }
        this.seedSelector.initialize(this.distancer, randomSeed);
    }

    @Override
    public void process(LArrayAccessor<P> points, int numCluster) {
        if (numCluster <= 0) {
            throw new IllegalArgumentException("There must be at least one cluster");
        }
        if (points.size() == 0) {
            throw new IllegalArgumentException("There must be at least one point");
        }
        if (this.verbose) {
            System.out.println("ENTER standard kmeans process");
        }
        this.workClusters.resize(numCluster);
        this.bestClusters.resize(numCluster);
        this.seedSelector.selectSeeds(points, numCluster, this.workClusters);
        this.bestClusterScore = Double.MAX_VALUE;
        this.sumDistance = Double.MAX_VALUE;
        double previousSum = Double.MAX_VALUE;
        int lastConverge = 0;
        int numReSeeded = 0;
        int maxReSeed = this.maxReSeed <= 0 ? Integer.MAX_VALUE : this.maxReSeed;
        for (int iteration = 0; iteration < this.maxIterations && numReSeeded < maxReSeed; ++iteration) {
            this.matchPointsToClusters(points, this.workClusters);
            boolean reseed = iteration - lastConverge >= this.reseedAfterIterations;
            double fractionalChange = 1.0 - this.sumDistance / previousSum;
            if (reseed |= fractionalChange >= 0.0 && fractionalChange <= this.convergeTol) {
                if (this.sumDistance < this.bestClusterScore) {
                    this.saveBestCluster(points);
                }
                if (this.verbose) {
                    System.out.println(iteration + "  Reseeding, distance = " + this.sumDistance);
                }
                this.seedSelector.selectSeeds(points, numCluster, this.workClusters);
                previousSum = Double.MAX_VALUE;
                lastConverge = iteration;
                ++numReSeeded;
                continue;
            }
            if (this.verbose && previousSum == Double.MAX_VALUE) {
                System.out.println(iteration + "  first iteration: " + this.sumDistance);
            }
            previousSum = this.sumDistance;
            this.updateMeans.process(points, this.assignments, this.workClusters);
        }
        if (this.sumDistance < this.bestClusterScore) {
            this.saveBestCluster(points);
        }
        this.matchPointsToClusters(points, this.bestClusters);
        this.memberCount.setTo(this.bestMemberCount);
        if (this.verbose) {
            System.out.println("EXIT standard kmeans process");
        }
    }

    private void saveBestCluster(LArrayAccessor<P> points) {
        this.bestClusterScore = this.sumDistance;
        this.bestClusters.reserve(this.workClusters.size);
        this.bestClusters.reset();
        for (int i = 0; i < this.workClusters.size; ++i) {
            points.copy(this.workClusters.get(i), this.bestClusters.grow());
        }
        this.bestMemberCount.setTo(this.memberCount);
        if (this.verbose) {
            System.out.println(" better clusters score: " + this.bestClusterScore);
        }
    }

    @Override
    public AssignCluster<P> getAssignment() {
        return new AssignKMeans<P>(this.bestClusters.toList(), this.distancer);
    }

    protected void matchPointsToClusters(LArrayAccessor<P> points, DogArray<P> clusters) {
        this.memberCount.resetResize(clusters.size, 0);
        this.sumDistance = 0.0;
        this.assignments.resize(points.size());
        for (int i = 0; i < points.size(); ++i) {
            P point = points.getTemp(i);
            int assignment = this.findBestMatch(point, clusters);
            this.assignments.set(i, assignment);
            int n = assignment;
            this.memberCount.data[n] = this.memberCount.data[n] + 1;
        }
    }

    protected int findBestMatch(P p, DogArray<P> clusters) {
        int bestCluster = -1;
        double bestDistance = Double.MAX_VALUE;
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            double d = this.distancer.distance(p, clusters.get(clusterIdx));
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            bestCluster = clusterIdx;
        }
        this.sumDistance += bestDistance;
        return bestCluster;
    }

    @Override
    public double getDistanceMeasure() {
        return this.sumDistance;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public ComputeClusters<P> newInstanceThread() {
        StandardKMeans<P> spawn = new StandardKMeans<P>(this.updateMeans.newInstanceThread(), this.seedSelector.newInstanceThread(), this.distancer.newInstanceThread(), this.factory);
        spawn.convergeTol = this.convergeTol;
        spawn.maxIterations = this.maxIterations;
        spawn.reseedAfterIterations = this.reseedAfterIterations;
        spawn.verbose = this.verbose;
        return spawn;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public int getReseedAfterIterations() {
        return this.reseedAfterIterations;
    }

    public void setReseedAfterIterations(int reseedAfterIterations) {
        this.reseedAfterIterations = reseedAfterIterations;
    }

    public int getMaxReSeed() {
        return this.maxReSeed;
    }

    public void setMaxReSeed(int maxReSeed) {
        this.maxReSeed = maxReSeed;
    }

    public double getConvergeTol() {
        return this.convergeTol;
    }

    public void setConvergeTol(double convergeTol) {
        this.convergeTol = convergeTol;
    }

    public DogArray_I32 getAssignments() {
        return this.assignments;
    }

    public DogArray_I32 getMemberCount() {
        return this.memberCount;
    }

    public DogArray<P> getBestClusters() {
        return this.bestClusters;
    }

    public double getBestClusterScore() {
        return this.bestClusterScore;
    }
}

