/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import org.ddogleg.DDoglegConcurrency;
import org.ddogleg.clustering.kmeans.InitializeKMeans;
import org.ddogleg.clustering.kmeans.InitializePlusPlus;
import org.ddogleg.struct.DogLambdas;
import org.ddogleg.struct.LArrayAccessor;
import pabeles.concurrency.GrowArray;

public class InitializePlusPlus_MT<P>
extends InitializePlusPlus<P> {
    DogLambdas.NewInstance<P> factoryPoint;
    GrowArray<DistanceWork> threadsData;
    int minimumConcurrent = 0;

    public InitializePlusPlus_MT(DogLambdas.NewInstance<P> factoryPoint) {
        this.factoryPoint = factoryPoint;
        this.threadsData = new GrowArray<DistanceWork>(() -> new DistanceWork(), DistanceWork::reset);
    }

    @Override
    public InitializeKMeans<P> newInstanceThread() {
        return new InitializePlusPlus_MT<P>(this.factoryPoint);
    }

    @Override
    protected void updateDistanceWithNewSeed(LArrayAccessor<P> points, P seed) {
        if (points.size() < this.minimumConcurrent) {
            super.updateDistanceWithNewSeed(points, seed);
            return;
        }
        DDoglegConcurrency.loopBlocks(0, points.size(), this.threadsData, (work, idx0, idx1) -> {
            Object point = work.point;
            double sum = 0.0;
            for (int pointIdx = idx0; pointIdx < idx1; ++pointIdx) {
                points.getCopy(pointIdx, point);
                double d = this.computeDistance.distance(point, seed);
                double prevD = this.distances.data[pointIdx];
                if (d < prevD) {
                    this.distances.data[pointIdx] = d;
                    sum += d;
                    continue;
                }
                sum += prevD;
            }
            work.sum = sum;
        });
        this.sumDistances = 0.0;
        for (int i = 0; i < this.threadsData.size(); ++i) {
            this.sumDistances += this.threadsData.get((int)i).sum;
        }
    }

    public int getMinimumConcurrent() {
        return this.minimumConcurrent;
    }

    public void setMinimumConcurrent(int minimumConcurrent) {
        this.minimumConcurrent = minimumConcurrent;
    }

    private class DistanceWork {
        public double sum;
        public P point;

        private DistanceWork() {
            this.point = InitializePlusPlus_MT.this.factoryPoint.newInstance();
        }

        public void reset() {
            this.sum = 0.0;
        }
    }
}

