/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.Random;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.clustering.kmeans.InitializeKMeans;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.LArrayAccessor;

public class InitializePlusPlus<P>
implements InitializeKMeans<P> {
    Random rand;
    PointDistance<P> computeDistance;
    DogArray_F64 distances = new DogArray_F64();
    double sumDistances;

    @Override
    public void initialize(PointDistance<P> distance, long randomSeed) {
        this.computeDistance = distance;
        this.rand = new Random(randomSeed);
    }

    @Override
    public void selectSeeds(LArrayAccessor<P> points, int requestedSeeds, DogArray<P> selectedSeeds) {
        int selected;
        selectedSeeds.reserve(requestedSeeds);
        selectedSeeds.reset();
        if (points.size() == 0 || requestedSeeds == 0) {
            return;
        }
        points.getCopy(this.rand.nextInt(points.size()), selectedSeeds.grow());
        this.distances.resetResize(points.size(), Double.MAX_VALUE);
        this.updateDistanceWithNewSeed(points, selectedSeeds.get(0));
        for (int seedIdx = 1; seedIdx < requestedSeeds && (selected = this.selectPointForNextSeed(this.rand.nextDouble())) != -1; ++seedIdx) {
            P seed = selectedSeeds.grow();
            points.getCopy(selected, seed);
            this.updateDistanceWithNewSeed(points, seed);
        }
    }

    @Override
    public InitializeKMeans<P> newInstanceThread() {
        return new InitializePlusPlus<P>();
    }

    protected void updateDistanceWithNewSeed(LArrayAccessor<P> points, P seed) {
        this.sumDistances = 0.0;
        for (int pointIdx = 0; pointIdx < points.size(); ++pointIdx) {
            double prevD;
            P point = points.getTemp(pointIdx);
            double d = this.computeDistance.distance(point, seed);
            if (d < (prevD = this.distances.data[pointIdx])) {
                this.distances.data[pointIdx] = d;
                this.sumDistances += d;
                continue;
            }
            this.sumDistances += prevD;
        }
    }

    protected int selectPointForNextSeed(double targetFraction) {
        double sum = 0.0;
        double targetValue = this.sumDistances * targetFraction;
        for (int pointIdx = 0; pointIdx < this.distances.size(); ++pointIdx) {
            double d = this.distances.get(pointIdx);
            if (!((sum += d) >= targetValue) || d == 0.0) continue;
            return pointIdx;
        }
        return -1;
    }
}

