/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.clustering.AssignCluster;
import org.ddogleg.clustering.PointDistance;

public class AssignKMeans<P>
implements AssignCluster<P>,
Serializable {
    List<P> clusters;
    PointDistance<P> distancer;

    public AssignKMeans(List<P> clusters, PointDistance<P> distancer) {
        this.clusters = new ArrayList<P>(clusters);
        this.distancer = distancer;
    }

    @Override
    public int assign(P point) {
        int best = -1;
        double bestScore = Double.MAX_VALUE;
        for (int i = 0; i < this.clusters.size(); ++i) {
            double score = this.distancer.distance(point, this.clusters.get(i));
            if (!(score < bestScore)) continue;
            bestScore = score;
            best = i;
        }
        return best;
    }

    @Override
    public void assign(P point, double[] fit) {
        int i;
        Arrays.fill(fit, 0.0);
        double max = 0.0;
        for (int i2 = 0; i2 < this.clusters.size(); ++i2) {
            double d;
            fit[i2] = d = this.distancer.distance(point, this.clusters.get(i2));
            if (!(d > max)) continue;
            max = d;
        }
        double total = 0.0;
        int i3 = 0;
        while (i3 < this.clusters.size()) {
            int n = i3++;
            double d = fit[n] / max;
            fit[n] = d;
            total += d;
        }
        double total2 = 0.0;
        for (i = 0; i < this.clusters.size(); ++i) {
            fit[i] = total - fit[i];
            total2 += fit[i];
        }
        i = 0;
        while (i < this.clusters.size()) {
            int n = i++;
            fit[n] = fit[n] / total2;
        }
    }

    @Override
    public int getNumberOfClusters() {
        return this.clusters.size();
    }

    public List<P> getClusters() {
        return this.clusters;
    }

    public void setClusters(List<P> clusters) {
        this.clusters = clusters;
    }

    public PointDistance<P> getDistancer() {
        return this.distancer;
    }

    public void setDistancer(PointDistance<P> distancer) {
        this.distancer = distancer;
    }
}

