/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering;

import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.clustering.ConfigKMeans;
import org.ddogleg.clustering.PointDistance;
import org.ddogleg.clustering.gmm.ExpectationMaximizationGmm_F64;
import org.ddogleg.clustering.gmm.SeedFromKMeans_F64;
import org.ddogleg.clustering.kmeans.InitializeKMeans;
import org.ddogleg.clustering.kmeans.InitializePlusPlus;
import org.ddogleg.clustering.kmeans.InitializePlusPlus_MT;
import org.ddogleg.clustering.kmeans.InitializeStandard;
import org.ddogleg.clustering.kmeans.StandardKMeans;
import org.ddogleg.clustering.kmeans.StandardKMeans_MT;
import org.ddogleg.clustering.misc.EuclideanSqArrayF64;
import org.ddogleg.clustering.misc.MeanArrayF64;
import org.ddogleg.struct.DogLambdas;
import org.jetbrains.annotations.Nullable;

public class FactoryClustering {
    public static ExpectationMaximizationGmm_F64 gaussianMixtureModelEM_F64(int maxIterations, int maxConverge, double convergeTol, int pointDimension) {
        ConfigKMeans configKMeans = new ConfigKMeans();
        configKMeans.reseedAfterIterations = maxConverge;
        configKMeans.maxIterations = maxIterations;
        configKMeans.convergeTol = convergeTol;
        StandardKMeans<double[]> kmeans = FactoryClustering.kMeans(configKMeans, pointDimension, double[].class);
        SeedFromKMeans_F64 seeds = new SeedFromKMeans_F64(kmeans);
        return new ExpectationMaximizationGmm_F64(maxIterations, convergeTol, pointDimension, seeds);
    }

    public static <T> StandardKMeans<T> kMeans(@Nullable ConfigKMeans config, int pointDimension, Class<T> dataType) {
        if (dataType != double[].class) {
            throw new IllegalArgumentException("Only double[] supported at this time.");
        }
        return FactoryClustering.kMeans(config, new MeanArrayF64(pointDimension), new EuclideanSqArrayF64(pointDimension), () -> new double[pointDimension]);
    }

    public static <T> StandardKMeans<T> kMeans_MT(@Nullable ConfigKMeans config, int pointDimension, int minimumForThreads, Class<T> dataType) {
        if (dataType != double[].class) {
            throw new IllegalArgumentException("Only double[] supported at this time.");
        }
        return FactoryClustering.kMeans_MT(config, minimumForThreads, new MeanArrayF64(pointDimension), new EuclideanSqArrayF64(pointDimension), () -> new double[pointDimension]);
    }

    public static <P> StandardKMeans<P> kMeans(@Nullable ConfigKMeans config, ComputeMeanClusters<P> updateMeans, PointDistance<P> pointDistance, DogLambdas.NewInstance<P> factory) {
        InitializeKMeans seed;
        if (config == null) {
            config = new ConfigKMeans();
        }
        switch (config.initializer) {
            case PLUS_PLUS: {
                seed = new InitializePlusPlus();
                break;
            }
            case STANDARD: {
                seed = new InitializeStandard();
                break;
            }
            default: {
                throw new RuntimeException("Unknown initializer " + config.initializer);
            }
        }
        StandardKMeans<P> alg = new StandardKMeans<P>(updateMeans, seed, pointDistance, factory);
        alg.convergeTol = config.convergeTol;
        alg.maxIterations = config.maxIterations;
        alg.reseedAfterIterations = config.reseedAfterIterations;
        alg.maxReSeed = config.maxReSeed;
        return alg;
    }

    public static <P> StandardKMeans<P> kMeans_MT(@Nullable ConfigKMeans config, int minimumForThreads, ComputeMeanClusters<P> updateMeans, PointDistance<P> pointDistance, DogLambdas.NewInstance<P> factory) {
        InitializeKMeans seed;
        if (config == null) {
            config = new ConfigKMeans();
        }
        switch (config.initializer) {
            case PLUS_PLUS: {
                seed = new InitializePlusPlus_MT<P>(factory);
                ((InitializePlusPlus_MT)seed).setMinimumConcurrent(minimumForThreads);
                break;
            }
            case STANDARD: {
                seed = new InitializeStandard();
                break;
            }
            default: {
                throw new RuntimeException("Unknown initializer " + config.initializer);
            }
        }
        StandardKMeans_MT<P> alg = new StandardKMeans_MT<P>(updateMeans, seed, pointDistance, factory);
        alg.convergeTol = config.convergeTol;
        alg.maxIterations = config.maxIterations;
        alg.reseedAfterIterations = config.reseedAfterIterations;
        alg.maxReSeed = config.maxReSeed;
        alg.setMinimumForConcurrent(minimumForThreads);
        return alg;
    }
}

