/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.menu;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.utils.MaterialDrawingUtils;
import mdlaf.utils.MaterialManagerListener;

public class MaterialMenuUI
extends BasicMenuUI {
    private MouseListener mouseHover = new MouseHover();

    public static ComponentUI createUI(JComponent c) {
        return new MaterialMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JMenu menu = (JMenu)c;
        menu.setFont(UIManager.getFont("Menu.font"));
        menu.setBorder(UIManager.getBorder("Menu.border"));
        menu.setBackground(UIManager.getColor("Menu.background"));
        menu.setForeground(UIManager.getColor("Menu.foreground"));
        menu.setOpaque(UIManager.getBoolean("Menu.opaque"));
        c.setCursor(Cursor.getPredefinedCursor(12));
        if (UIManager.getBoolean("Menu[MouseOver].enable")) {
            menu.addMouseMotionListener(MaterialUIMovement.getMovement(menu, Color.black));
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.menuItem.setFont(null);
        this.menuItem.setBackground(null);
        this.menuItem.setForeground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setCursor(null);
        c.removeMouseListener(this.mouseHover);
        MaterialManagerListener.removeAllMaterialMouseListener(this.menuItem);
        super.uninstallUI(this.menuItem);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(MaterialDrawingUtils.getAliasedGraphics(g), c);
    }

    @Override
    protected ChangeListener createChangeListener(JComponent c) {
        if (UIManager.getBoolean("Menu[MouseOver].enable")) {
            c.addMouseListener(this.mouseHover);
        }
        return super.createChangeListener(c);
    }

    private class MouseHover
    implements MouseListener {
        private MouseHover() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu;
            if (e.getSource() instanceof JMenu && (menu = (JMenu)e.getSource()).isEnabled()) {
                menu.setSelected(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JMenu menu;
            if (e.getSource() instanceof JMenu && (menu = (JMenu)e.getSource()).isEnabled()) {
                menu.setSelected(false);
            }
        }
    }
}

