/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.geometry.GeometryMath_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class SePointOps_F64 {
    public static Point2D_F64 transform(Se2_F64 se, Point2D_F64 orig, @Nullable Point2D_F64 result) {
        if (result == null) {
            result = new Point2D_F64();
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        double x = orig.x;
        double y = orig.y;
        result.x = se.getX() + x * c - y * s;
        result.y = se.getY() + x * s + y * c;
        return result;
    }

    public static Point2D_F64 transform(Se2_F64 se, double x, double y, @Nullable Point2D_F64 result) {
        if (result == null) {
            result = new Point2D_F64();
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        result.x = se.getX() + x * c - y * s;
        result.y = se.getY() + x * s + y * c;
        return result;
    }

    public static Point2D_F64 transformReverse(Se2_F64 se, Point2D_F64 orig, @Nullable Point2D_F64 result) {
        if (result == null) {
            result = new Point2D_F64();
        }
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        double x = orig.x - se.getX();
        double y = orig.y - se.getY();
        result.x = x * c + y * s;
        result.y = -x * s + y * c;
        return result;
    }

    public static void transform(Se2_F64 se, Point2D_F64[] points, int length) {
        double tranX = se.getX();
        double tranY = se.getY();
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        for (int i = 0; i < length; ++i) {
            Point2D_F64 pt = points[i];
            double x = pt.x;
            double y = pt.y;
            pt.x = tranX + x * c - y * s;
            pt.y = tranY + x * s + y * c;
        }
    }

    public static void transform(Se2_F64 se, List<Point2D_F64> points) {
        double tranX = se.getX();
        double tranY = se.getY();
        double c = se.getCosineYaw();
        double s = se.getSineYaw();
        for (Point2D_F64 pt : points) {
            double x = pt.x;
            double y = pt.y;
            pt.x = tranX + x * c - y * s;
            pt.y = tranY + x * s + y * c;
        }
    }

    public static void transform(Se3_F64 se, Point3D_F64[] points, int start, int length) {
        for (int i = 0; i < length; ++i) {
            Point3D_F64 p = points[i + start];
            SePointOps_F64.transform(se, p, p);
        }
    }

    public static void transform(Se3_F64 se, List<Point3D_F64> points) {
        for (Point3D_F64 p : points) {
            SePointOps_F64.transform(se, p, p);
        }
    }

    public static Point3D_F64 transform(Se3_F64 se, Point3D_F64 src, @Nullable Point3D_F64 dst) {
        return SePointOps_F64.transform(se, src.x, src.y, src.z, dst);
    }

    public static Point3D_F64 transform(Se3_F64 se, double x, double y, double z, @Nullable Point3D_F64 dst) {
        if (dst == null) {
            dst = new Point3D_F64();
        }
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        dst.x = R.data[0] * x + R.data[1] * y + R.data[2] * z + T.x;
        dst.y = R.data[3] * x + R.data[4] * y + R.data[5] * z + T.y;
        dst.z = R.data[6] * x + R.data[7] * y + R.data[8] * z + T.z;
        return dst;
    }

    public static Point3D_F64 transform(Se3_F64 se, Point4D_F64 src, @Nullable Point3D_F64 dst) {
        return SePointOps_F64.transform(se, src.x, src.y, src.z, src.w, dst);
    }

    public static Point3D_F64 transform(Se3_F64 se, double x, double y, double z, double w, @Nullable Point3D_F64 dst) {
        if (dst == null) {
            dst = new Point3D_F64();
        }
        DMatrixRMaj R = se.R;
        Vector3D_F64 T = se.T;
        dst.x = R.data[0] * x + R.data[1] * y + R.data[2] * z + T.x * w;
        dst.y = R.data[3] * x + R.data[4] * y + R.data[5] * z + T.y * w;
        dst.z = R.data[6] * x + R.data[7] * y + R.data[8] * z + T.z * w;
        dst.x /= w;
        dst.y /= w;
        dst.z /= w;
        return dst;
    }

    public static Point3D_F64 transformV(Se3_F64 se, Point4D_F64 src, @Nullable Point3D_F64 dst) {
        return SePointOps_F64.transformV(se, src.x, src.y, src.z, src.w, dst);
    }

    public static Point3D_F64 transformV(Se3_F64 se, double x, double y, double z, double w, @Nullable Point3D_F64 dst) {
        if (dst == null) {
            dst = new Point3D_F64();
        }
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        dst.x = R.data[0] * x + R.data[1] * y + R.data[2] * z + T.x * w;
        dst.y = R.data[3] * x + R.data[4] * y + R.data[5] * z + T.y * w;
        dst.z = R.data[6] * x + R.data[7] * y + R.data[8] * z + T.z * w;
        return dst;
    }

    public static Point4D_F64 transform(Se3_F64 se, Point4D_F64 src, @Nullable Point4D_F64 dst) {
        return SePointOps_F64.transform(se, src.x, src.y, src.z, src.w, dst);
    }

    public static Point4D_F64 transform(Se3_F64 se, double x, double y, double z, double w, @Nullable Point4D_F64 dst) {
        if (dst == null) {
            dst = new Point4D_F64();
        }
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        double P11 = R.data[0];
        double P12 = R.data[1];
        double P13 = R.data[2];
        double P14 = T.x;
        double P21 = R.data[3];
        double P22 = R.data[4];
        double P23 = R.data[5];
        double P24 = T.y;
        double P31 = R.data[6];
        double P32 = R.data[7];
        double P33 = R.data[8];
        double P34 = T.z;
        dst.x = P11 * x + P12 * y + P13 * z + P14 * w;
        dst.y = P21 * x + P22 * y + P23 * z + P24 * w;
        dst.z = P31 * x + P32 * y + P33 * z + P34 * w;
        dst.w = w;
        return dst;
    }

    public static Point4D_F64 transformReverse(Se3_F64 se, Point4D_F64 src, @Nullable Point4D_F64 dst) {
        return SePointOps_F64.transformReverse(se, src.x, src.y, src.z, src.w, dst);
    }

    public static Point4D_F64 transformReverse(Se3_F64 se, double x, double y, double z, double w, @Nullable Point4D_F64 dst) {
        if (dst == null) {
            dst = new Point4D_F64();
        }
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        double P11 = R.data[0];
        double P12 = R.data[3];
        double P13 = R.data[6];
        double P21 = R.data[1];
        double P22 = R.data[4];
        double P23 = R.data[7];
        double P31 = R.data[2];
        double P32 = R.data[5];
        double P33 = R.data[8];
        double P14 = -(P11 * T.x + P12 * T.y + P13 * T.z);
        double P24 = -(P21 * T.x + P22 * T.y + P23 * T.z);
        double P34 = -(P31 * T.x + P32 * T.y + P33 * T.z);
        dst.x = P11 * x + P12 * y + P13 * z + P14 * w;
        dst.y = P21 * x + P22 * y + P23 * z + P24 * w;
        dst.z = P31 * x + P32 * y + P33 * z + P34 * w;
        dst.w = w;
        return dst;
    }

    public static Point3D_F64 transformReverse(Se3_F64 se, Point3D_F64 origPt, @Nullable Point3D_F64 tranPt) {
        if (tranPt == null) {
            tranPt = new Point3D_F64();
        }
        DMatrixRMaj R = se.getR();
        Vector3D_F64 T = se.getT();
        GeometryMath_F64.sub(origPt, T, tranPt);
        GeometryMath_F64.multTran(R, tranPt, tranPt);
        return tranPt;
    }
}

