/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.metric.UtilAngle;
import georegression.struct.se.Se2_F64;

public class InterpolateLinearSe2_F64 {
    public static void interpolate(Se2_F64 a, Se2_F64 b, double where, Se2_F64 output) {
        double ccw;
        double yaw1;
        double w0 = 1.0 - where;
        output.T.x = a.T.x * w0 + b.T.x * where;
        output.T.y = a.T.y * w0 + b.T.y * where;
        double yaw0 = a.getYaw();
        double cw = UtilAngle.distanceCW(yaw0, yaw1 = b.getYaw());
        double yaw = cw > (ccw = UtilAngle.distanceCCW(yaw0, yaw1)) ? yaw0 + ccw * where : yaw0 - cw * where;
        output.setYaw(yaw);
    }
}

