/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.so;

import georegression.struct.point.Vector3D_F64;
import java.io.Serializable;

public class Rodrigues_F64
implements Serializable {
    public Vector3D_F64 unitAxisRotation = new Vector3D_F64();
    public double theta;

    public Rodrigues_F64() {
    }

    public Rodrigues_F64(double theta, Vector3D_F64 unitAxisRotation) {
        this.theta = theta;
        this.unitAxisRotation.setTo(unitAxisRotation);
    }

    public Rodrigues_F64(double theta, double x, double y, double z) {
        this.theta = theta;
        this.unitAxisRotation.setTo(x, y, z);
        this.unitAxisRotation.normalize();
    }

    public Rodrigues_F64 setTo(Rodrigues_F64 src) {
        this.theta = src.theta;
        this.unitAxisRotation.setTo(src.unitAxisRotation);
        return this;
    }

    public Vector3D_F64 getUnitAxisRotation() {
        return this.unitAxisRotation;
    }

    public void setUnitAxisRotation(Vector3D_F64 unitAxisRotation) {
        this.unitAxisRotation.setTo(unitAxisRotation);
    }

    public void setParamVector(double x, double y, double z) {
        double ax = Math.abs(x);
        double ay = Math.abs(y);
        double az = Math.abs(z);
        double max = Math.max(ax, ay);
        if ((max = Math.max(max, az)) == 0.0) {
            this.theta = 0.0;
            this.unitAxisRotation.setTo(1.0, 0.0, 0.0);
        } else {
            this.theta = Math.sqrt((x /= max) * x + (y /= max) * y + (z /= max) * z);
            this.unitAxisRotation.x = x / this.theta;
            this.unitAxisRotation.y = y / this.theta;
            this.unitAxisRotation.z = z / this.theta;
            this.theta *= max;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " v{ " + this.unitAxisRotation.x + " , " + this.unitAxisRotation.y + " , " + this.unitAxisRotation.z + " } theta = " + this.theta;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }
}

