/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.so;

import georegression.struct.point.Vector3D_F32;
import java.io.Serializable;

public class Rodrigues_F32
implements Serializable {
    public Vector3D_F32 unitAxisRotation = new Vector3D_F32();
    public float theta;

    public Rodrigues_F32() {
    }

    public Rodrigues_F32(float theta, Vector3D_F32 unitAxisRotation) {
        this.theta = theta;
        this.unitAxisRotation.setTo(unitAxisRotation);
    }

    public Rodrigues_F32(float theta, float x, float y, float z) {
        this.theta = theta;
        this.unitAxisRotation.setTo(x, y, z);
        this.unitAxisRotation.normalize();
    }

    public Rodrigues_F32 setTo(Rodrigues_F32 src) {
        this.theta = src.theta;
        this.unitAxisRotation.setTo(src.unitAxisRotation);
        return this;
    }

    public Vector3D_F32 getUnitAxisRotation() {
        return this.unitAxisRotation;
    }

    public void setUnitAxisRotation(Vector3D_F32 unitAxisRotation) {
        this.unitAxisRotation.setTo(unitAxisRotation);
    }

    public void setParamVector(float x, float y, float z) {
        float ax = Math.abs(x);
        float ay = Math.abs(y);
        float az = Math.abs(z);
        float max = Math.max(ax, ay);
        if ((max = Math.max(max, az)) == 0.0f) {
            this.theta = 0.0f;
            this.unitAxisRotation.setTo(1.0f, 0.0f, 0.0f);
        } else {
            this.theta = (float)Math.sqrt((x /= max) * x + (y /= max) * y + (z /= max) * z);
            this.unitAxisRotation.x = x / this.theta;
            this.unitAxisRotation.y = y / this.theta;
            this.unitAxisRotation.z = z / this.theta;
            this.theta *= max;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " v{ " + this.unitAxisRotation.x + " , " + this.unitAxisRotation.y + " , " + this.unitAxisRotation.z + " } theta = " + this.theta;
    }

    public float getTheta() {
        return this.theta;
    }

    public void setTheta(float theta) {
        this.theta = theta;
    }
}

