/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.struct.point.Point2D_F32;
import java.io.Serializable;

public class Rectangle2D_F32
implements Serializable {
    public Point2D_F32 p0 = new Point2D_F32();
    public Point2D_F32 p1 = new Point2D_F32();

    public Rectangle2D_F32(float x0, float y0, float x1, float y1) {
        this.setTo(x0, y0, x1, y1);
    }

    public Rectangle2D_F32(Rectangle2D_F32 orig) {
        this.setTo(orig);
    }

    public Rectangle2D_F32() {
    }

    public Rectangle2D_F32 setTo(Rectangle2D_F32 orig) {
        this.p0.setTo(orig.p0);
        this.p1.setTo(orig.p1);
        return this;
    }

    public Rectangle2D_F32 setTo(float x0, float y0, float x1, float y1) {
        this.p0.setTo(x0, y0);
        this.p1.setTo(x1, y1);
        return this;
    }

    public void zero() {
        this.p0.setTo(0.0f, 0.0f);
        this.p1.setTo(0.0f, 0.0f);
    }

    public void enforceExtents() {
        float tmp;
        if (this.p1.x < this.p0.x) {
            tmp = this.p1.x;
            this.p1.x = this.p0.x;
            this.p0.x = tmp;
        }
        if (this.p1.y < this.p0.y) {
            tmp = this.p1.y;
            this.p1.y = this.p0.y;
            this.p0.y = tmp;
        }
    }

    public boolean isEquals(Rectangle2D_F32 r, float tol) {
        return this.isEquals(r.p0.x, r.p0.y, r.p1.x, r.p1.y, tol);
    }

    public boolean isEquals(float x0, float y0, float x1, float y1, float tol) {
        if (Math.abs(x0 - this.p0.x) > tol) {
            return false;
        }
        if (Math.abs(y0 - this.p0.y) > tol) {
            return false;
        }
        if (Math.abs(x1 - this.p1.x) > tol) {
            return false;
        }
        return !(Math.abs(y1 - this.p1.y) > tol);
    }

    public float getWidth() {
        return this.p1.x - this.p0.x;
    }

    public float getHeight() {
        return this.p1.y - this.p0.y;
    }

    public float area() {
        return (this.p1.y - this.p0.y) * (this.p1.x - this.p0.x);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ p0(" + this.p0.x + " " + this.p0.y + ") p1(" + this.p1.x + " " + this.p1.y + ") }";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rectangle2D_F32)) {
            return false;
        }
        Rectangle2D_F32 o = (Rectangle2D_F32)obj;
        return this.p0.x == o.p0.x && this.p0.y == o.p0.y && this.p1.x == o.p1.x && this.p1.y == o.p1.y;
    }

    public int hashCode() {
        return this.p0.hashCode() + this.p1.hashCode();
    }

    public Point2D_F32 getP0() {
        return this.p0;
    }

    public Point2D_F32 getP1() {
        return this.p1;
    }

    public void setP0(Point2D_F32 p0) {
        this.p0 = p0;
    }

    public void setP1(Point2D_F32 p1) {
        this.p1 = p1;
    }
}

