/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.metric.Area2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Quadrilateral_F32
implements Serializable {
    public Point2D_F32 a;
    public Point2D_F32 b;
    public Point2D_F32 c;
    public Point2D_F32 d;

    public Quadrilateral_F32() {
        this.a = new Point2D_F32();
        this.b = new Point2D_F32();
        this.c = new Point2D_F32();
        this.d = new Point2D_F32();
    }

    public Quadrilateral_F32(Quadrilateral_F32 quad) {
        this();
        this.a.setTo(quad.a);
        this.b.setTo(quad.b);
        this.c.setTo(quad.c);
        this.d.setTo(quad.d);
    }

    public Quadrilateral_F32(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        this.a = new Point2D_F32(x0, y0);
        this.b = new Point2D_F32(x1, y1);
        this.c = new Point2D_F32(x2, y2);
        this.d = new Point2D_F32(x3, y3);
    }

    public Quadrilateral_F32(Point2D_F32 a, Point2D_F32 b, Point2D_F32 c, Point2D_F32 d) {
        this(a, b, c, d, true);
    }

    public Quadrilateral_F32(Point2D_F32 a, Point2D_F32 b, Point2D_F32 c, Point2D_F32 d, boolean copy) {
        if (copy) {
            this.a = new Point2D_F32(a);
            this.b = new Point2D_F32(b);
            this.c = new Point2D_F32(c);
            this.d = new Point2D_F32(d);
        } else {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }
    }

    public void zero() {
        this.a.setTo(0.0f, 0.0f);
        this.b.setTo(0.0f, 0.0f);
        this.c.setTo(0.0f, 0.0f);
        this.d.setTo(0.0f, 0.0f);
    }

    public float area() {
        return Area2D_F32.quadrilateral(this);
    }

    public Point2D_F32 get(int index) {
        Point2D_F32 point2D_F32;
        switch (index) {
            case 0: {
                point2D_F32 = this.a;
                break;
            }
            case 1: {
                point2D_F32 = this.b;
                break;
            }
            case 2: {
                point2D_F32 = this.c;
                break;
            }
            case 3: {
                point2D_F32 = this.d;
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested index out of range. " + index);
            }
        }
        return point2D_F32;
    }

    public LineSegment2D_F32 getLine(int which, LineSegment2D_F32 storage) {
        if (storage == null) {
            storage = new LineSegment2D_F32();
        }
        switch (which) {
            case 0: {
                storage.a.setTo(this.a);
                storage.b.setTo(this.b);
                break;
            }
            case 1: {
                storage.a.setTo(this.b);
                storage.b.setTo(this.c);
                break;
            }
            case 2: {
                storage.a.setTo(this.c);
                storage.b.setTo(this.d);
                break;
            }
            case 3: {
                storage.a.setTo(this.d);
                storage.b.setTo(this.a);
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested index out of range. " + which);
            }
        }
        return storage;
    }

    public float getSideLength(int which) {
        return (float)Math.sqrt(this.getSideLength2(which));
    }

    public float getSideLength2(int which) {
        float f;
        switch (which) {
            case 0: {
                f = this.a.distance2(this.b);
                break;
            }
            case 1: {
                f = this.b.distance2(this.c);
                break;
            }
            case 2: {
                f = this.c.distance2(this.d);
                break;
            }
            case 3: {
                f = this.d.distance2(this.a);
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested index out of range. " + which);
            }
        }
        return f;
    }

    public void setTo(Quadrilateral_F32 quad) {
        this.a.setTo(quad.a);
        this.b.setTo(quad.b);
        this.c.setTo(quad.c);
        this.d.setTo(quad.d);
    }

    public List<Point2D_F32> convert(@Nullable List<Point2D_F32> storage, boolean copy) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F32>();
        } else {
            storage.clear();
        }
        if (copy) {
            for (int i = 0; i < 4; ++i) {
                storage.add(this.get(i).copy());
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                storage.add(this.get(i));
            }
        }
        return storage;
    }

    public void setTo(List<Point2D_F32> list) {
        if (list.size() != 4) {
            throw new IllegalArgumentException("List must have size of 4");
        }
        this.a.setTo(list.get(0));
        this.b.setTo(list.get(1));
        this.c.setTo(list.get(2));
        this.d.setTo(list.get(3));
    }

    public Quadrilateral_F32 copy() {
        return new Quadrilateral_F32(this);
    }

    public boolean isEquals(Quadrilateral_F32 quad, float tol) {
        tol *= tol;
        if (this.a.distance2(quad.a) > tol) {
            return false;
        }
        if (this.b.distance2(quad.b) > tol) {
            return false;
        }
        if (this.c.distance2(quad.c) > tol) {
            return false;
        }
        return this.d.distance2(quad.d) <= tol;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + "}";
    }

    public Point2D_F32 getA() {
        return this.a;
    }

    public void setA(Point2D_F32 a) {
        this.a = a;
    }

    public Point2D_F32 getB() {
        return this.b;
    }

    public void setB(Point2D_F32 b) {
        this.b = b;
    }

    public Point2D_F32 getC() {
        return this.c;
    }

    public void setC(Point2D_F32 c) {
        this.c = c;
    }

    public Point2D_F32 getD() {
        return this.d;
    }

    public void setD(Point2D_F32 d) {
        this.d = d;
    }
}

