/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.geometry.UtilPolygons2D_F32;
import georegression.metric.Area2D_F32;
import georegression.metric.Intersection2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.UtilEjml;
import org.jetbrains.annotations.Nullable;

public class Polygon2D_F32
implements Serializable {
    public DogArray<Point2D_F32> vertexes;

    public Polygon2D_F32(float[][] a) {
        this(a.length);
        for (int i = 0; i < a.length; ++i) {
            ((Point2D_F32)this.vertexes.get(i)).setTo(a[i][0], a[i][1]);
        }
    }

    public Polygon2D_F32(Polygon2D_F32 a) {
        this.vertexes = new DogArray<Point2D_F32>(a.size(), Point2D_F32::new);
        for (int i = 0; i < a.size(); ++i) {
            this.vertexes.grow().setTo(a.get(i));
        }
    }

    public Polygon2D_F32(int numVertexes) {
        this.vertexes = new DogArray<Point2D_F32>(numVertexes, Point2D_F32::new);
        this.vertexes.reserve(numVertexes);
        this.vertexes.size = numVertexes;
    }

    public Polygon2D_F32(float ... xy) {
        if (xy.length % 2 == 1) {
            throw new IllegalArgumentException("Expected an even number");
        }
        this.vertexes = new DogArray<Point2D_F32>(xy.length / 2, Point2D_F32::new);
        this.vertexes.reserve(xy.length / 2);
        this.vertexes.size = xy.length / 2;
        int count = 0;
        for (int i = 0; i < xy.length; i += 2) {
            ((Point2D_F32[])this.vertexes.data)[count++].setTo(xy[i], xy[i + 1]);
        }
    }

    public Polygon2D_F32() {
        this.vertexes = new DogArray<Point2D_F32>(Point2D_F32::new);
    }

    public void zero() {
        for (int i = 0; i < this.vertexes.size; ++i) {
            ((Point2D_F32)this.vertexes.get(i)).setTo(0.0f, 0.0f);
        }
    }

    public Polygon2D_F32 setTo(Polygon2D_F32 orig) {
        this.vertexes.resize(orig.size());
        for (int i = 0; i < orig.size(); ++i) {
            ((Point2D_F32[])this.vertexes.data)[i].setTo(((Point2D_F32[])orig.vertexes.data)[i]);
        }
        return this;
    }

    public void set(int index, float x, float y) {
        ((Point2D_F32[])this.vertexes.data)[index].setTo(x, y);
    }

    public float getSideLength(int index) {
        Point2D_F32 a = (Point2D_F32)this.vertexes.get(index);
        Point2D_F32 b = (Point2D_F32)this.vertexes.get((index + 1) % this.vertexes.size);
        return a.distance(b);
    }

    public Point2D_F32 get(int index) {
        return ((Point2D_F32[])this.vertexes.data)[index];
    }

    public int size() {
        return this.vertexes.size();
    }

    public Polygon2D_F32 copy() {
        return new Polygon2D_F32(this);
    }

    public float areaSimple() {
        return Area2D_F32.polygonSimple(this);
    }

    public boolean isInside(Point2D_F32 p) {
        if (this.isConvex()) {
            return Intersection2D_F32.containsConvex(this, p);
        }
        return Intersection2D_F32.containsConcave(this, p);
    }

    public boolean isCCW() {
        return UtilPolygons2D_F32.isCCW(this.vertexes.toList());
    }

    public boolean isConvex() {
        return UtilPolygons2D_F32.isConvex(this);
    }

    public boolean isIdentical(Polygon2D_F32 a, float tol) {
        return UtilPolygons2D_F32.isIdentical(this, a, tol);
    }

    public boolean isEquivalent(Polygon2D_F32 a, float tol) {
        return UtilPolygons2D_F32.isEquivalent(this, a, tol);
    }

    public void flip() {
        UtilPolygons2D_F32.flip(this);
    }

    public Polygon2D_F32 flip(@Nullable Polygon2D_F32 storage) {
        if (storage == null) {
            storage = new Polygon2D_F32(this.size());
        }
        storage.setTo(this);
        storage.flip();
        return storage;
    }

    public LineSegment2D_F32 getLine(int index, LineSegment2D_F32 storage) {
        if (storage == null) {
            storage = new LineSegment2D_F32();
        }
        int j = (index + 1) % this.vertexes.size;
        storage.a.setTo(this.get(index));
        storage.b.setTo(this.get(j));
        return storage;
    }

    public List<Point2D_F32> convert(@Nullable List<Point2D_F32> storage, boolean copy) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F32>();
        } else {
            storage.clear();
        }
        if (copy) {
            for (int i = 0; i < this.vertexes.size; ++i) {
                storage.add(((Point2D_F32)this.vertexes.get(i)).copy());
            }
        } else {
            storage.addAll(this.vertexes.toList());
        }
        return storage;
    }

    public void setTo(List<Point2D_F32> list) {
        this.vertexes.resize(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ((Point2D_F32[])this.vertexes.data)[i].setTo(list.get(i));
        }
    }

    public String toString() {
        int length = 11;
        DecimalFormat format = new DecimalFormat("#");
        String out = this.getClass().getSimpleName() + "{ order=" + this.vertexes.size + ", [ ";
        for (int i = 0; i < this.vertexes.size; ++i) {
            Point2D_F32 p = (Point2D_F32)this.vertexes.get(i);
            out = out + "(" + UtilEjml.fancyString(p.x, format, false, 11, 4) + ", " + UtilEjml.fancyString(p.y, format, false, 11, 4) + ") ";
        }
        out = out + "] }";
        return out;
    }
}

