/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.struct.point.Point3D_F64;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class BoxLength3D_F64
implements Serializable {
    public Point3D_F64 p = new Point3D_F64();
    public double lengthX;
    public double lengthY;
    public double lengthZ;

    public BoxLength3D_F64(double x0, double y0, double z0, double lengthX, double lengthY, double lengthZ) {
        this.p.setTo(x0, y0, z0);
        this.lengthX = lengthX;
        this.lengthY = lengthY;
        this.lengthZ = lengthZ;
    }

    public BoxLength3D_F64(BoxLength3D_F64 orig) {
        this.setTo(orig);
    }

    public BoxLength3D_F64() {
    }

    public BoxLength3D_F64 setTo(BoxLength3D_F64 orig) {
        return this.setTo(orig.p.x, orig.p.y, orig.p.z, orig.lengthX, orig.lengthY, orig.lengthZ);
    }

    public BoxLength3D_F64 setTo(double x0, double y0, double z0, double lengthX, double lengthY, double lengthZ) {
        this.p.setTo(x0, y0, z0);
        this.lengthX = lengthX;
        this.lengthY = lengthY;
        this.lengthZ = lengthZ;
        return this;
    }

    public void zero() {
        this.setTo(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public double area() {
        return this.lengthX * this.lengthY * this.lengthZ;
    }

    public void setP(Point3D_F64 p) {
        this.p.setTo(p);
    }

    public Point3D_F64 getCorner(int index, @Nullable Point3D_F64 corner) {
        if (corner == null) {
            corner = new Point3D_F64();
        }
        corner.setTo(this.p);
        if ((index & 1) != 0) {
            corner.x += this.lengthX;
        }
        if ((index & 2) != 0) {
            corner.y += this.lengthY;
        }
        if ((index & 4) != 0) {
            corner.z += this.lengthZ;
        }
        return corner;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "P( " + this.p.x + " " + this.p.y + " " + this.p.z + " ) sides ( " + this.lengthX + " , " + this.lengthY + " , " + this.lengthZ + " )";
    }

    public Point3D_F64 getP() {
        return this.p;
    }

    public double getLengthX() {
        return this.lengthX;
    }

    public double getLengthY() {
        return this.lengthY;
    }

    public double getLengthZ() {
        return this.lengthZ;
    }

    public void setLengthX(double lengthX) {
        this.lengthX = lengthX;
    }

    public void setLengthY(double lengthY) {
        this.lengthY = lengthY;
    }

    public void setLengthZ(double lengthZ) {
        this.lengthZ = lengthZ;
    }
}

