/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.shapes;

import georegression.struct.point.Point3D_F64;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class Box3D_F64
implements Serializable {
    public Point3D_F64 p0 = new Point3D_F64();
    public Point3D_F64 p1 = new Point3D_F64();

    public Box3D_F64(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.p0.setTo(x0, y0, z0);
        this.p1.setTo(x1, y1, z1);
    }

    public Box3D_F64(Box3D_F64 orig) {
        this.setTo(orig);
    }

    public Box3D_F64() {
    }

    public Box3D_F64 setTo(Box3D_F64 orig) {
        this.setTo(orig.p0.x, orig.p0.y, orig.p0.z, orig.p1.x, orig.p1.y, orig.p1.z);
        return this;
    }

    public Box3D_F64 setTo(double x0, double y0, double z0, double x1, double y1, double z1) {
        this.p0.setTo(x0, y0, z0);
        this.p1.setTo(x1, y1, z1);
        return this;
    }

    public void zero() {
        this.setTo(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public boolean isEquals(Box3D_F64 r, double tol) {
        return this.isEquals(r.p0.x, r.p0.y, r.p0.z, r.p1.x, r.p1.y, r.p1.z, tol);
    }

    public boolean isEquals(double x0, double y0, double z0, double x1, double y1, double z1, double tol) {
        if (Math.abs(x0 - this.p0.x) > tol) {
            return false;
        }
        if (Math.abs(y0 - this.p0.y) > tol) {
            return false;
        }
        if (Math.abs(z0 - this.p0.z) > tol) {
            return false;
        }
        if (Math.abs(x1 - this.p1.x) > tol) {
            return false;
        }
        if (Math.abs(y1 - this.p1.y) > tol) {
            return false;
        }
        return !(Math.abs(z1 - this.p1.z) > tol);
    }

    public double area() {
        return (this.p1.x - this.p0.x) * (this.p1.y - this.p0.y) * (this.p1.z - this.p0.z);
    }

    public double getLengthX() {
        return this.p1.x - this.p0.x;
    }

    public double getLengthY() {
        return this.p1.y - this.p0.y;
    }

    public double getLengthZ() {
        return this.p1.z - this.p0.z;
    }

    public void setP1(Point3D_F64 p1) {
        this.p1.setTo(p1);
    }

    public void setP0(Point3D_F64 p0) {
        this.p0.setTo(p0);
    }

    public Point3D_F64 center(@Nullable Point3D_F64 storage) {
        if (storage == null) {
            storage = new Point3D_F64();
        }
        storage.x = (this.p0.x + this.p1.x) / 2.0;
        storage.y = (this.p0.y + this.p1.y) / 2.0;
        storage.z = (this.p0.z + this.p1.z) / 2.0;
        return storage;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ P0( " + this.p0.x + " " + this.p0.y + " " + this.p0.z + " ) P1( " + this.p1.x + " " + this.p1.y + " " + this.p1.z + " ) }";
    }

    public Point3D_F64 getP0() {
        return this.p0;
    }

    public Point3D_F64 getP1() {
        return this.p1;
    }
}

